/* game-window.c generated by valac 0.30.0.3-b11d, the Vala compiler
 * generated from game-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2015 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of a GNOME game.
 *
 * This application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This application is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this application. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>


#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;
typedef struct _GameWindowPrivate GameWindowPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _GameWindowPrivate {
	gboolean tiled_state;
	gboolean maximized_state;
	gint window_width;
	gint window_height;
	gboolean game_finished;
	GtkHeaderBar* headerbar;
	GtkStack* stack;
	GtkButton* start_game_button;
	GtkButton* new_game_button;
	GtkButton* back_button;
	GtkBox* controls_box;
	GtkBox* game_box;
	GtkBox* new_game_box;
	GtkBox* side_box;
	GtkWidget* view;
	GSimpleAction* back_action;
};


static gpointer game_window_parent_class = NULL;

GType game_window_flags_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
#define GAME_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_WINDOW, GameWindowPrivate))
enum  {
	GAME_WINDOW_DUMMY_PROPERTY
};
static void game_window_new_game_cb (GameWindow* self);
static void _game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void game_window_start_game_cb (GameWindow* self);
static void _game_window_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void game_window_back_cb (GameWindow* self);
static void _game_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void game_window_undo_cb (GameWindow* self);
static void _game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void game_window_redo_cb (GameWindow* self);
static void _game_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void game_window_hint_cb (GameWindow* self);
static void _game_window_hint_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GameWindow* game_window_new (const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
GameWindow* game_window_construct (GType object_type, const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
static void game_window_size_allocate_cb (GameWindow* self, GtkAllocation* allocation);
static void _game_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean game_window_window_state_event_cb (GameWindow* self, GdkEventWindowState* event);
static gboolean _game_window_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void game_window_show_view (GameWindow* self);
static void game_window_show_new_game_screen (GameWindow* self);
void game_window_shutdown (GameWindow* self, GSettings* settings);
void game_window_add_to_sidebox (GameWindow* self, GtkWidget* widget);
void game_window_cannot_undo_more (GameWindow* self);
void game_window_set_subtitle (GameWindow* self, const gchar* subtitle);
void game_window_finish_game (GameWindow* self);
static void game_window_finalize (GObject* obj);

static const GActionEntry GAME_WINDOW_win_actions[6] = {{"new-game", _game_window_new_game_cb_gsimple_action_activate_callback}, {"start-game", _game_window_start_game_cb_gsimple_action_activate_callback}, {"back", _game_window_back_cb_gsimple_action_activate_callback}, {"undo", _game_window_undo_cb_gsimple_action_activate_callback}, {"redo", _game_window_redo_cb_gsimple_action_activate_callback}, {"hint", _game_window_hint_cb_gsimple_action_activate_callback}};

GType game_window_flags_get_type (void) {
	static volatile gsize game_window_flags_type_id__volatile = 0;
	if (g_once_init_enter (&game_window_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{GAME_WINDOW_FLAGS_SHOW_UNDO, "GAME_WINDOW_FLAGS_SHOW_UNDO", "show-undo"}, {GAME_WINDOW_FLAGS_SHOW_REDO, "GAME_WINDOW_FLAGS_SHOW_REDO", "show-redo"}, {GAME_WINDOW_FLAGS_SHOW_HINT, "GAME_WINDOW_FLAGS_SHOW_HINT", "show-hint"}, {GAME_WINDOW_FLAGS_SHOW_START_BUTTON, "GAME_WINDOW_FLAGS_SHOW_START_BUTTON", "show-start-button"}, {0, NULL, NULL}};
		GType game_window_flags_type_id;
		game_window_flags_type_id = g_flags_register_static ("GameWindowFlags", values);
		g_once_init_leave (&game_window_flags_type_id__volatile, game_window_flags_type_id);
	}
	return game_window_flags_type_id__volatile;
}


static void _game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_new_game_cb ((GameWindow*) self);
#line 140 "game-window.c"
}


static void _game_window_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_start_game_cb ((GameWindow*) self);
#line 147 "game-window.c"
}


static void _game_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_back_cb ((GameWindow*) self);
#line 154 "game-window.c"
}


static void _game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_undo_cb ((GameWindow*) self);
#line 161 "game-window.c"
}


static void _game_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_redo_cb ((GameWindow*) self);
#line 168 "game-window.c"
}


static void _game_window_hint_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_hint_cb ((GameWindow*) self);
#line 175 "game-window.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	return self ? g_object_ref (self) : NULL;
#line 182 "game-window.c"
}


static void _game_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_size_allocate_cb ((GameWindow*) self, allocation);
#line 189 "game-window.c"
}


static gboolean _game_window_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = game_window_window_state_event_cb ((GameWindow*) self, event);
#line 122 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	return result;
#line 198 "game-window.c"
}


GameWindow* game_window_construct (GType object_type, const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view) {
	GameWindow * self = NULL;
	const gchar* _tmp0_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	GAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	GAction* _tmp10_ = NULL;
	GSimpleAction* _tmp11_ = NULL;
	GAction* _tmp12_ = NULL;
	GSimpleAction* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
	GSimpleAction* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkHeaderBar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gboolean _tmp22_ = FALSE;
	GtkBox* _tmp23_ = NULL;
	GtkBox* _tmp24_ = NULL;
	GameWindowFlags _tmp25_ = 0;
	GtkBox* _tmp37_ = NULL;
	GtkWidget* _tmp38_ = NULL;
	GtkBox* _tmp39_ = NULL;
	GtkWidget* _tmp40_ = NULL;
	GtkWidget* _tmp41_ = NULL;
	GtkWidget* _tmp42_ = NULL;
	GtkWidget* _tmp43_ = NULL;
	GameWindowFlags _tmp44_ = 0;
	gboolean _tmp58_ = FALSE;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_val_if_fail (new_game_screen != NULL, NULL);
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_val_if_fail (_view != NULL, NULL);
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self = (GameWindow*) g_object_new (object_type, NULL);
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = css_resource;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (_tmp0_ != NULL) {
#line 246 "game-window.c"
		GtkCssProvider* css_provider = NULL;
		GtkCssProvider* _tmp1_ = NULL;
		GtkCssProvider* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GdkScreen* _tmp4_ = NULL;
		GtkCssProvider* _tmp5_ = NULL;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp1_ = gtk_css_provider_new ();
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		css_provider = _tmp1_;
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp2_ = css_provider;
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp3_ = css_resource;
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_css_provider_load_from_resource (_tmp2_, _tmp3_);
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp4_ = gdk_screen_get_default ();
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp5_ = css_provider;
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_style_context_add_provider_for_screen (_tmp4_, (GtkStyleProvider*) _tmp5_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_g_object_unref0 (css_provider);
#line 271 "game-window.c"
	}
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp6_ = _view;
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->view);
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->priv->view = _tmp7_;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_action_map_add_action_entries ((GActionMap*) self, GAME_WINDOW_win_actions, G_N_ELEMENTS (GAME_WINDOW_win_actions), self);
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) self, "back");
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_simple_action_get_type (), GSimpleAction));
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->back_action);
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->priv->back_action = _tmp9_;
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_simple_action_get_type (), GSimpleAction));
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->undo_action);
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->undo_action = _tmp11_;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_simple_action_get_type (), GSimpleAction));
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->redo_action);
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->redo_action = _tmp13_;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp14_ = self->priv->back_action;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_simple_action_set_enabled (_tmp14_, FALSE);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp15_ = self->undo_action;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_simple_action_set_enabled (_tmp15_, FALSE);
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp16_ = self->redo_action;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_simple_action_set_enabled (_tmp16_, FALSE);
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp17_ = name;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp17_);
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp18_ = self->priv->headerbar;
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp19_ = name;
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_header_bar_set_title (_tmp18_, _tmp19_);
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp20_ = width;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp21_ = height;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, _tmp20_, _tmp21_);
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp22_ = maximized;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (_tmp22_) {
#line 119 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 341 "game-window.c"
	}
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _game_window_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 122 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _game_window_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp23_ = self->priv->new_game_box;
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp24_ = new_game_screen;
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_box_pack_start (_tmp23_, (GtkWidget*) _tmp24_, TRUE, TRUE, (guint) 0);
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp25_ = flags;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if ((_tmp25_ & GAME_WINDOW_FLAGS_SHOW_START_BUTTON) == GAME_WINDOW_FLAGS_SHOW_START_BUTTON) {
#line 357 "game-window.c"
		const gchar* _tmp26_ = NULL;
		GtkButton* _tmp27_ = NULL;
		GtkButton* _tmp28_ = NULL;
		GtkButton* _tmp29_ = NULL;
		GtkButton* _tmp30_ = NULL;
		GtkButton* _tmp31_ = NULL;
		GtkButton* _tmp32_ = NULL;
		GtkStyleContext* _tmp33_ = NULL;
		GtkButton* _tmp34_ = NULL;
		GtkBox* _tmp35_ = NULL;
		GtkButton* _tmp36_ = NULL;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp26_ = _ ("_Start Game");
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp27_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp26_);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		g_object_ref_sink (_tmp27_);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_g_object_unref0 (self->priv->start_game_button);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		self->priv->start_game_button = _tmp27_;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp28_ = self->priv->start_game_button;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		g_object_set ((GtkWidget*) _tmp28_, "width-request", 222, NULL);
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp29_ = self->priv->start_game_button;
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		g_object_set ((GtkWidget*) _tmp29_, "height-request", 60, NULL);
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp30_ = self->priv->start_game_button;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_widget_set_halign ((GtkWidget*) _tmp30_, GTK_ALIGN_CENTER);
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp31_ = self->priv->start_game_button;
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_actionable_set_action_name ((GtkActionable*) _tmp31_, "win.start-game");
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp32_ = self->priv->start_game_button;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) _tmp32_);
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_style_context_add_class (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_style_context_get_type (), GtkStyleContext), "suggested-action");
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp34_ = self->priv->start_game_button;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_widget_show ((GtkWidget*) _tmp34_);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp35_ = self->priv->new_game_box;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp36_ = self->priv->start_game_button;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_box_pack_end (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
#line 411 "game-window.c"
	}
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp37_ = self->priv->game_box;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp38_ = self->priv->view;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_box_pack_start (_tmp37_, _tmp38_, TRUE, TRUE, (guint) 0);
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp39_ = self->priv->game_box;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp40_ = self->priv->view;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_container_set_focus_child ((GtkContainer*) _tmp39_, _tmp40_);
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp41_ = self->priv->view;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_set_halign (_tmp41_, GTK_ALIGN_FILL);
#line 142 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp42_ = self->priv->view;
#line 142 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_object_set (_tmp42_, "can-focus", TRUE, NULL);
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp43_ = self->priv->view;
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_show (_tmp43_);
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp44_ = flags;
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if ((_tmp44_ & GAME_WINDOW_FLAGS_SHOW_UNDO) == GAME_WINDOW_FLAGS_SHOW_UNDO) {
#line 441 "game-window.c"
		GtkBox* history_box = NULL;
		GtkBox* _tmp45_ = NULL;
		GtkBox* _tmp46_ = NULL;
		GtkStyleContext* _tmp47_ = NULL;
		GtkButton* undo_button = NULL;
		GtkButton* _tmp48_ = NULL;
		GtkButton* _tmp49_ = NULL;
		GtkButton* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		GtkButton* _tmp52_ = NULL;
		GtkBox* _tmp53_ = NULL;
		GtkButton* _tmp54_ = NULL;
		GtkBox* _tmp55_ = NULL;
		GtkBox* _tmp56_ = NULL;
		GtkBox* _tmp57_ = NULL;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp45_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		g_object_ref_sink (_tmp45_);
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		history_box = _tmp45_;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp46_ = history_box;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp47_ = gtk_widget_get_style_context ((GtkWidget*) _tmp46_);
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_style_context_add_class (_tmp47_, "linked");
#line 151 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp48_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_BUTTON);
#line 151 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		g_object_ref_sink (_tmp48_);
#line 151 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		undo_button = _tmp48_;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp49_ = undo_button;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_actionable_set_action_name ((GtkActionable*) _tmp49_, "win.undo");
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp50_ = undo_button;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp51_ = _ ("Undo your most recent move");
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp50_, _tmp51_);
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp52_ = undo_button;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_widget_show ((GtkWidget*) _tmp52_);
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp53_ = history_box;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp54_ = undo_button;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_box_pack_start (_tmp53_, (GtkWidget*) _tmp54_, TRUE, TRUE, (guint) 0);
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp55_ = history_box;
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_widget_show ((GtkWidget*) _tmp55_);
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp56_ = self->priv->controls_box;
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp57_ = history_box;
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_box_pack_start (_tmp56_, (GtkWidget*) _tmp57_, TRUE, TRUE, (guint) 0);
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_g_object_unref0 (undo_button);
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_g_object_unref0 (history_box);
#line 509 "game-window.c"
	}
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp58_ = start_now;
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (_tmp58_) {
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		game_window_show_view (self);
#line 517 "game-window.c"
	} else {
#line 182 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		game_window_show_new_game_screen (self);
#line 521 "game-window.c"
	}
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	return self;
#line 525 "game-window.c"
}


GameWindow* game_window_new (const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view) {
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	return game_window_construct (TYPE_GAME_WINDOW, css_resource, name, width, height, maximized, start_now, flags, new_game_screen, _view);
#line 532 "game-window.c"
}


static void game_window_size_allocate_cb (GameWindow* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (allocation != NULL);
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = self->priv->maximized_state;
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (_tmp1_) {
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp0_ = TRUE;
#line 553 "game-window.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp2_ = self->priv->tiled_state;
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp0_ = _tmp2_;
#line 560 "game-window.c"
	}
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (_tmp0_) {
#line 192 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		return;
#line 566 "game-window.c"
	}
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp3_ = *allocation;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp4_ = _tmp3_.width;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->priv->window_width = _tmp4_;
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp5_ = *allocation;
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp6_ = _tmp5_.height;
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->priv->window_height = _tmp6_;
#line 580 "game-window.c"
}


static gboolean game_window_window_state_event_cb (GameWindow* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = event;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 600 "game-window.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp2_ = event;
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		self->priv->maximized_state = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 609 "game-window.c"
	}
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp4_ = event;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 617 "game-window.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp6_ = event;
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		self->priv->tiled_state = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 626 "game-window.c"
	}
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	result = FALSE;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	return result;
#line 632 "game-window.c"
}


void game_window_shutdown (GameWindow* self, GSettings* settings) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (settings != NULL);
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = settings;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = self->priv->window_width;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp2_ = settings;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp3_ = self->priv->window_height;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp4_ = settings;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp5_ = self->priv->maximized_state;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_destroy ((GtkWidget*) self);
#line 667 "game-window.c"
}


void game_window_add_to_sidebox (GameWindow* self, GtkWidget* widget) {
	GtkBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
#line 219 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 219 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (widget != NULL);
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->side_box;
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = widget;
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_box_pack_start (_tmp0_, _tmp1_, FALSE, FALSE, (guint) 0);
#line 684 "game-window.c"
}


void game_window_cannot_undo_more (GameWindow* self) {
	GSimpleAction* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->undo_action;
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = self->priv->view;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_grab_focus (_tmp1_);
#line 701 "game-window.c"
}


void game_window_set_subtitle (GameWindow* self, const gchar* subtitle) {
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 230 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->headerbar;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = subtitle;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_header_bar_set_subtitle (_tmp0_, _tmp1_);
#line 716 "game-window.c"
}


void game_window_finish_game (GameWindow* self) {
	GtkButton* _tmp0_ = NULL;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->priv->game_finished = TRUE;
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->new_game_button;
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
#line 730 "game-window.c"
}


static void game_window_show_new_game_screen (GameWindow* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->headerbar;
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = self->priv->stack;
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_stack_set_visible_child_name (_tmp1_, "start-box");
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp2_ = self->priv->controls_box;
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_hide ((GtkWidget*) _tmp2_);
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp4_ = self->priv->game_finished;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (!_tmp4_) {
#line 758 "game-window.c"
		GtkButton* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp5_ = self->priv->back_button;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp7_ = _tmp6_;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp3_ = _tmp7_;
#line 770 "game-window.c"
	} else {
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp3_ = FALSE;
#line 774 "game-window.c"
	}
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (_tmp3_) {
#line 778 "game-window.c"
		GtkButton* _tmp8_ = NULL;
#line 258 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp8_ = self->priv->back_button;
#line 258 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
#line 784 "game-window.c"
	} else {
		GtkButton* _tmp9_ = NULL;
#line 259 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp9_ = self->priv->start_game_button;
#line 259 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		if (_tmp9_ != NULL) {
#line 791 "game-window.c"
			GtkButton* _tmp10_ = NULL;
#line 260 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
			_tmp10_ = self->priv->start_game_button;
#line 260 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
#line 797 "game-window.c"
		}
	}
}


static void game_window_show_view (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = self->priv->back_button;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp2_ = self->priv->controls_box;
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp2_);
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp3_ = self->priv->game_finished;
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (_tmp3_) {
#line 826 "game-window.c"
		GtkButton* _tmp4_ = NULL;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp4_ = self->priv->new_game_button;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
#line 832 "game-window.c"
	} else {
		GtkWidget* _tmp5_ = NULL;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp5_ = self->priv->view;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_widget_grab_focus (_tmp5_);
#line 839 "game-window.c"
	}
}


static void game_window_new_game_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkStack* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
#line 279 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		return;
#line 861 "game-window.c"
	}
#line 284 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_emit_by_name (self, "wait");
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp2_ = self->priv->stack;
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_stack_set_transition_type (_tmp2_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp3_ = self->priv->stack;
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_stack_set_transition_duration (_tmp3_, (guint) 800);
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp4_ = self->priv->back_button;
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp5_ = self->priv->back_action;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_simple_action_set_enabled (_tmp5_, TRUE);
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_show_new_game_screen (self);
#line 883 "game-window.c"
}


static void game_window_start_game_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GtkStack* _tmp4_ = NULL;
	GtkStack* _tmp5_ = NULL;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "start-box") != 0) {
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		return;
#line 904 "game-window.c"
	}
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->priv->game_finished = FALSE;
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp2_ = self->undo_action;
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp3_ = self->redo_action;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_emit_by_name (self, "play");
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp4_ = self->priv->stack;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_stack_set_transition_type (_tmp4_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp5_ = self->priv->stack;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_stack_set_transition_duration (_tmp5_, (guint) 1000);
#line 309 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_show_view (self);
#line 928 "game-window.c"
}


static void game_window_back_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkStack* _tmp3_ = NULL;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "start-box") != 0) {
#line 315 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		return;
#line 947 "game-window.c"
	}
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp2_ = self->priv->stack;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_stack_set_transition_type (_tmp2_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp3_ = self->priv->stack;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_stack_set_transition_duration (_tmp3_, (guint) 800);
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_show_view (self);
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_emit_by_name (self, "back");
#line 961 "game-window.c"
}


static void game_window_undo_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		return;
#line 982 "game-window.c"
	}
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->priv->game_finished = FALSE;
#line 335 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp2_ = self->priv->new_game_button;
#line 335 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_object_get ((GtkWidget*) _tmp2_, "is-focus", &_tmp3_, NULL);
#line 335 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp4_ = _tmp3_;
#line 335 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (_tmp4_) {
#line 994 "game-window.c"
		GtkWidget* _tmp5_ = NULL;
#line 336 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp5_ = self->priv->view;
#line 336 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_widget_grab_focus (_tmp5_);
#line 1000 "game-window.c"
	}
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp6_ = self->redo_action;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_simple_action_set_enabled (_tmp6_, TRUE);
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_emit_by_name (self, "undo");
#line 1008 "game-window.c"
}


static void game_window_redo_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		return;
#line 1029 "game-window.c"
	}
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp2_ = self->priv->new_game_button;
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_object_get ((GtkWidget*) _tmp2_, "is-focus", &_tmp3_, NULL);
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp4_ = _tmp3_;
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (_tmp4_) {
#line 1039 "game-window.c"
		GtkWidget* _tmp5_ = NULL;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		_tmp5_ = self->priv->view;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		gtk_widget_grab_focus (_tmp5_);
#line 1045 "game-window.c"
	}
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp6_ = self->undo_action;
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_simple_action_set_enabled (_tmp6_, TRUE);
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_emit_by_name (self, "redo");
#line 1053 "game-window.c"
}


static void game_window_hint_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
		return;
#line 1070 "game-window.c"
	}
#line 356 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_emit_by_name (self, "hint");
#line 1074 "game-window.c"
}


static void game_window_class_init (GameWindowClass * klass) {
	gint GameWindow_private_offset;
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	game_window_parent_class = g_type_class_peek_parent (klass);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_type_class_add_private (klass, sizeof (GameWindowPrivate));
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	G_OBJECT_CLASS (klass)->finalize = game_window_finalize;
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	GameWindow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/iagno/ui/game-window.ui");
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_new ("play", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_new ("wait", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_new ("back", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_new ("undo", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_new ("redo", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	g_signal_new ("hint", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, headerbar));
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, stack));
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, new_game_button));
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, back_button));
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "controls_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, controls_box));
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, game_box));
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, new_game_box));
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "side_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, side_box));
#line 1118 "game-window.c"
}


static void game_window_instance_init (GameWindow * self) {
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->priv = GAME_WINDOW_GET_PRIVATE (self);
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->priv->game_finished = FALSE;
#line 48 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self->priv->start_game_button = NULL;
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 1131 "game-window.c"
}


static void game_window_finalize (GObject* obj) {
	GameWindow * self;
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
#line 44 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->stack);
#line 48 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->start_game_button);
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->new_game_button);
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->back_button);
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->controls_box);
#line 57 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->game_box);
#line 59 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->new_game_box);
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->side_box);
#line 63 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->view);
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->priv->back_action);
#line 88 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->undo_action);
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	_g_object_unref0 (self->redo_action);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/iagno/src/game-window.vala"
	G_OBJECT_CLASS (game_window_parent_class)->finalize (obj);
#line 1167 "game-window.c"
}


GType game_window_get_type (void) {
	static volatile gsize game_window_type_id__volatile = 0;
	if (g_once_init_enter (&game_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameWindow), 0, (GInstanceInitFunc) game_window_instance_init, NULL };
		GType game_window_type_id;
		game_window_type_id = g_type_register_static (gtk_application_window_get_type (), "GameWindow", &g_define_type_info, 0);
		g_once_init_leave (&game_window_type_id__volatile, game_window_type_id);
	}
	return game_window_type_id__volatile;
}



