/* computer-player.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from computer-player.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
typedef struct _ComputerPlayerPrivate ComputerPlayerPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _ComputerPlayerMoveAsyncData ComputerPlayerMoveAsyncData;

#define COMPUTER_PLAYER_TYPE_POSSIBLE_MOVE (computer_player_possible_move_get_type ())
typedef struct _ComputerPlayerPossibleMove ComputerPlayerPossibleMove;
#define _computer_player_possible_move_free0(var) ((var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL)))
#define __g_list_free__computer_player_possible_move_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__computer_player_possible_move_free0_ (var), NULL)))

#define TYPE_PLAYER (player_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ComputerPlayer {
	GObject parent_instance;
	ComputerPlayerPrivate * priv;
};

struct _ComputerPlayerClass {
	GObjectClass parent_class;
};

struct _ComputerPlayerPrivate {
	Game* game;
	gint difficulty_level;
	guint pending_move_id;
	gboolean _move_pending;
	GRecMutex _move_pending_mutex;
};

struct _Block1Data {
	int _ref_count_;
	ComputerPlayer* self;
	gint x;
	gint y;
	gpointer _async_data_;
};

struct _ComputerPlayerMoveAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ComputerPlayer* self;
	gdouble delay_seconds;
	Block1Data* _data1_;
	GTimer* timer;
	GTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GTimer* _tmp3_;
	GThread* _tmp4_;
	GThread* _tmp5_;
	GTimer* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GTimer* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	GTimer* _tmp13_;
	gdouble _tmp14_;
	guint _tmp15_;
};

struct _ComputerPlayerPossibleMove {
	gint x;
	gint y;
	gint n_tiles;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;


static gpointer computer_player_parent_class = NULL;

GType computer_player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define COMPUTER_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPUTER_PLAYER, ComputerPlayerPrivate))
enum  {
	COMPUTER_PLAYER_DUMMY_PROPERTY
};
#define COMPUTER_PLAYER_POSITIVE_INFINITY 10000
#define COMPUTER_PLAYER_NEGATIVE_INFINITY (-10000)
ComputerPlayer* computer_player_new (Game* game, gint difficulty_level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint difficulty_level);
static void computer_player_complete_move (ComputerPlayer* self, gint x, gint y);
gint game_place_tile (Game* self, gint x, gint y, gboolean apply);
gchar* game_to_string (Game* self);
void computer_player_move (ComputerPlayer* self);
static void computer_player_run_search (ComputerPlayer* self, gint* x, gint* y);
static void computer_player_move_async_data_free (gpointer _data);
void computer_player_move_async (ComputerPlayer* self, gdouble delay_seconds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void computer_player_move_finish (ComputerPlayer* self, GAsyncResult* _res_);
static gboolean computer_player_move_async_co (ComputerPlayerMoveAsyncData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean computer_player_get_move_pending (ComputerPlayer* self);
static gboolean _computer_player_move_async_co_gsource_func (gpointer self);
static void* __lambda4_ (Block1Data* _data1_);
static void computer_player_set_move_pending (ComputerPlayer* self, gboolean value);
static gpointer ___lambda4__gthread_func (gpointer self);
static gboolean __lambda5_ (Block1Data* _data1_);
static gboolean ___lambda5__gsource_func (gpointer self);
void computer_player_cancel_move (ComputerPlayer* self);
gboolean game_get_current_player_can_move (Game* self);
gint game_get_size (Game* self);
gint game_get_n_tiles (Game* self);
gint game_get_initial_number_of_tiles (Game* self);
static void computer_player_random_select (Game* g, gint* move_x, gint* move_y);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
static GType computer_player_possible_move_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self);
static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self);
static void computer_player_get_possible_moves_sorted (ComputerPlayer* self, Game* g, GList** moves);
static gint computer_player_search (ComputerPlayer* self, Game* g, gint depth, gint a, gint b);
void game_undo (Game* self, gint count);
static void _computer_player_possible_move_free0_ (gpointer var);
static void _g_list_free__computer_player_possible_move_free0_ (GList* self);
gboolean game_get_is_complete (Game* self);
gint game_get_n_current_tiles (Game* self);
gint game_get_n_opponent_tiles (Game* self);
static gint computer_player_calculate_heuristic (ComputerPlayer* self, Game* g);
void game_pass (Game* self);
static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles);
static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b);
static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b);
static gint computer_player_eval_heuristic (Game* g);
static gint computer_player_around (Game* g);
GType player_get_type (void) G_GNUC_CONST;
Player game_get_owner (Game* self, gint x, gint y);
Player game_get_current_color (Game* self);
static gint computer_player_is_empty (Game* g, gint x, gint y);
gboolean game_is_valid_location (Game* self, gint x, gint y);
gboolean game_can_place (Game* self, gint x, gint y, Player color);
static void computer_player_finalize (GObject* obj);
static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static const gint COMPUTER_PLAYER_heuristic[64] = {65, -3, 6, 4, 4, 6, -3, 65, -3, -29, 3, 1, 1, 3, -29, -3, 6, 3, 5, 3, 3, 5, 3, 6, 4, 1, 3, 1, 1, 3, 1, 4, 4, 1, 3, 1, 1, 3, 1, 4, 6, 3, 5, 3, 3, 5, 3, 6, -3, -29, 3, 1, 1, 3, -29, -3, 65, -3, 6, 4, 4, 6, -3, 65};

static gpointer _g_object_ref0 (gpointer self) {
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return self ? g_object_ref (self) : NULL;
#line 200 "computer-player.c"
}


ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint difficulty_level) {
	ComputerPlayer * self = NULL;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 76 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 76 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self = (ComputerPlayer*) g_object_new (object_type, NULL);
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = game;
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_object_unref0 (self->priv->game);
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self->priv->game = _tmp1_;
#line 79 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = difficulty_level;
#line 79 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self->priv->difficulty_level = _tmp2_;
#line 76 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return self;
#line 227 "computer-player.c"
}


ComputerPlayer* computer_player_new (Game* game, gint difficulty_level) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return computer_player_construct (TYPE_COMPUTER_PLAYER, game, difficulty_level);
#line 234 "computer-player.c"
}


static void computer_player_complete_move (ComputerPlayer* self, gint x, gint y) {
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->game;
#line 84 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = x;
#line 84 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = y;
#line 84 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp3_ = game_place_tile (_tmp0_, _tmp1_, _tmp2_, TRUE);
#line 84 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp3_ == 0) {
#line 255 "computer-player.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		Game* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 86 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp4_ = x;
#line 86 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp5_ = y;
#line 86 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp6_ = self->priv->game;
#line 86 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp7_ = game_to_string (_tmp6_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp8_ = _tmp7_;
#line 86 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_critical ("computer-player.vala:86: Computer chose an invalid move: %d,%d\n%s", _tmp4_, _tmp5_, _tmp8_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_g_free0 (_tmp8_);
#line 87 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_assert_not_reached ();
#line 277 "computer-player.c"
	}
}


void computer_player_move (ComputerPlayer* self) {
	gint x = 0;
	gint y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	x = 0;
#line 95 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	y = 0;
#line 97 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_run_search (self, &x, &y);
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = x;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = y;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_complete_move (self, _tmp0_, _tmp1_);
#line 301 "computer-player.c"
}


static void computer_player_move_async_data_free (gpointer _data) {
	ComputerPlayerMoveAsyncData* _data_;
	_data_ = _data;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_object_unref0 (_data_->self);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_slice_free (ComputerPlayerMoveAsyncData, _data_);
#line 312 "computer-player.c"
}


void computer_player_move_async (ComputerPlayer* self, gdouble delay_seconds, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ComputerPlayerMoveAsyncData* _data_;
	ComputerPlayer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_ = g_slice_new0 (ComputerPlayerMoveAsyncData);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, computer_player_move_async);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, computer_player_move_async_data_free);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->self = _tmp0_;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = delay_seconds;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->delay_seconds = _tmp1_;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_move_async_co (_data_);
#line 336 "computer-player.c"
}


void computer_player_move_finish (ComputerPlayer* self, GAsyncResult* _res_) {
	ComputerPlayerMoveAsyncData* _data_;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 344 "computer-player.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return _data1_;
#line 353 "computer-player.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 362 "computer-player.c"
		ComputerPlayer* self;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		self = _data1_->self;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_g_object_unref0 (self);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_slice_free (Block1Data, _data1_);
#line 370 "computer-player.c"
	}
}


static gboolean _computer_player_move_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = computer_player_move_async_co (self);
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 380 "computer-player.c"
}


static void* __lambda4_ (Block1Data* _data1_) {
	ComputerPlayer* self;
	void* result = NULL;
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self = _data1_->self;
#line 117 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_set_move_pending (self, TRUE);
#line 118 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_run_search (self, &_data1_->x, &_data1_->y);
#line 119 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_move_async_co (_data1_->_async_data_);
#line 120 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = NULL;
#line 120 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 399 "computer-player.c"
}


static gpointer ___lambda4__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda4_ (self);
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	block1_data_unref (self);
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 410 "computer-player.c"
}


static gboolean __lambda5_ (Block1Data* _data1_) {
	ComputerPlayer* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 139 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self = _data1_->self;
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = _data1_->x;
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = _data1_->y;
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_complete_move (self, _tmp0_, _tmp1_);
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = G_SOURCE_REMOVE;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 431 "computer-player.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
#line 139 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 440 "computer-player.c"
}


static gboolean computer_player_move_async_co (ComputerPlayerMoveAsyncData* _data_) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	switch (_data_->_state_) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		case 0:
#line 449 "computer-player.c"
		goto _state_0;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		case 1:
#line 453 "computer-player.c"
		goto _state_1;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		case 2:
#line 457 "computer-player.c"
		goto _state_2;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		case 3:
#line 461 "computer-player.c"
		goto _state_3;
		default:
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_assert_not_reached ();
#line 466 "computer-player.c"
	}
	_state_0:
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp0_ = NULL;
#line 103 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp0_ = g_timer_new ();
#line 103 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->timer = _data_->_tmp0_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_data1_->x = 0;
#line 105 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_data1_->y = 0;
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	while (TRUE) {
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp1_ = FALSE;
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp1_ = computer_player_get_move_pending (_data_->self);
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp2_ = FALSE;
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		if (!_data_->_tmp2_) {
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			break;
#line 501 "computer-player.c"
		}
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _computer_player_move_async_co_gsource_func, _data_, NULL);
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_state_ = 1;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return FALSE;
#line 509 "computer-player.c"
		_state_1:
		;
	}
#line 115 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp3_ = NULL;
#line 115 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp3_ = _data_->timer;
#line 115 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_timer_start (_data_->_tmp3_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp4_ = NULL;
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp4_ = g_thread_new ("AI thread", ___lambda4__gthread_func, block1_data_ref (_data_->_data1_));
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp5_ = NULL;
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_thread_unref0 (_data_->_tmp5_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_state_ = 2;
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return FALSE;
#line 533 "computer-player.c"
	_state_2:
	;
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp6_ = NULL;
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp6_ = _data_->timer;
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_timer_stop (_data_->_tmp6_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp7_ = FALSE;
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp7_ = computer_player_get_move_pending (_data_->self);
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp8_ = FALSE;
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (!_data_->_tmp8_) {
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_g_timer_destroy0 (_data_->timer);
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		block1_data_unref (_data_->_data1_);
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_data1_ = NULL;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		if (_data_->_state_ == 0) {
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 562 "computer-player.c"
		} else {
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 566 "computer-player.c"
		}
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_object_unref (_data_->_async_result);
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return FALSE;
#line 572 "computer-player.c"
	}
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp9_ = NULL;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp9_ = _data_->timer;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp10_ = 0.0;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp10_ = g_timer_elapsed (_data_->_tmp9_, NULL);
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp11_ = 0.0;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_tmp11_ = _data_->delay_seconds;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_data_->_tmp10_ < _data_->_tmp11_) {
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp12_ = 0.0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp12_ = _data_->delay_seconds;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp13_ = NULL;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp13_ = _data_->timer;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp14_ = 0.0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp14_ = g_timer_elapsed (_data_->_tmp13_, NULL);
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp15_ = 0U;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_tmp15_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((_data_->_tmp12_ - _data_->_tmp14_) * 1000), _computer_player_move_async_co_gsource_func, _data_, NULL);
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->self->priv->pending_move_id = _data_->_tmp15_;
#line 132 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_data_->_state_ = 3;
#line 132 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return FALSE;
#line 610 "computer-player.c"
		_state_3:
		;
	}
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->self->priv->pending_move_id = (guint) 0;
#line 136 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_set_move_pending (_data_->self, FALSE);
#line 139 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_timer_destroy0 (_data_->timer);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	block1_data_unref (_data_->_data1_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_data_->_data1_ = NULL;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_data_->_state_ == 0) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 630 "computer-player.c"
	} else {
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 634 "computer-player.c"
	}
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_object_unref (_data_->_async_result);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return FALSE;
#line 640 "computer-player.c"
}


void computer_player_cancel_move (ComputerPlayer* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_ = 0U;
#line 145 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = computer_player_get_move_pending (self);
#line 147 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = _tmp0_;
#line 147 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (!_tmp1_) {
#line 148 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return;
#line 658 "computer-player.c"
	}
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = self->priv->pending_move_id;
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp2_ != ((guint) 0)) {
#line 664 "computer-player.c"
		guint _tmp3_ = 0U;
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp3_ = self->priv->pending_move_id;
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_source_remove (_tmp3_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		self->priv->pending_move_id = (guint) 0;
#line 672 "computer-player.c"
	}
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_set_move_pending (self, FALSE);
#line 676 "computer-player.c"
}


static gpointer _computer_player_possible_move_dup0 (gpointer self) {
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return self ? computer_player_possible_move_dup (self) : NULL;
#line 683 "computer-player.c"
}


static void _computer_player_possible_move_free0_ (gpointer var) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	(var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL));
#line 690 "computer-player.c"
}


static void _g_list_free__computer_player_possible_move_free0_ (GList* self) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_list_foreach (self, (GFunc) _computer_player_possible_move_free0_, NULL);
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_list_free (self);
#line 699 "computer-player.c"
}


static void computer_player_run_search (ComputerPlayer* self, gint* x, gint* y) {
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	Game* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Game* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Game* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	Game* g = NULL;
	Game* _tmp16_ = NULL;
	Game* _tmp17_ = NULL;
	gint depth = 0;
	gint _tmp18_ = 0;
	gint a = 0;
	GList* moves = NULL;
	Game* _tmp19_ = NULL;
	GList* _tmp20_ = NULL;
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->game;
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = game_get_current_player_can_move (_tmp0_);
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = _tmp1_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (_tmp2_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp4_ = self->priv->game;
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp5_ = game_get_size (_tmp4_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp6_ = _tmp5_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp6_ < 6) {
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp3_ = 2;
#line 746 "computer-player.c"
	} else {
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp3_ = 4;
#line 750 "computer-player.c"
	}
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp7_ = self->priv->game;
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp8_ = game_get_n_tiles (_tmp7_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp9_ = _tmp8_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp10_ = self->priv->game;
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp11_ = game_get_initial_number_of_tiles (_tmp10_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp12_ = _tmp11_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp9_ < (_tmp12_ + _tmp3_)) {
#line 766 "computer-player.c"
		Game* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp13_ = self->priv->game;
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		computer_player_random_select (_tmp13_, &_tmp14_, &_tmp15_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		*x = _tmp14_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		*y = _tmp15_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return;
#line 780 "computer-player.c"
	}
#line 179 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp16_ = self->priv->game;
#line 179 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp17_ = game_new_copy (_tmp16_);
#line 179 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g = _tmp17_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp18_ = self->priv->difficulty_level;
#line 180 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	depth = _tmp18_ * 2;
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	a = COMPUTER_PLAYER_NEGATIVE_INFINITY - 1;
#line 184 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	moves = NULL;
#line 185 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp19_ = g;
#line 185 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_get_possible_moves_sorted (self, _tmp19_, &moves);
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp20_ = moves;
#line 802 "computer-player.c"
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		move_collection = _tmp20_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 810 "computer-player.c"
			ComputerPlayerPossibleMove* _tmp21_ = NULL;
			ComputerPlayerPossibleMove* move = NULL;
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp21_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) move_it->data);
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			move = _tmp21_;
#line 817 "computer-player.c"
			{
				Game* _tmp22_ = NULL;
				ComputerPlayerPossibleMove* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				ComputerPlayerPossibleMove* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint a_new = 0;
				Game* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				Game* _tmp49_ = NULL;
#line 190 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp22_ = g;
#line 190 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp23_ = move;
#line 190 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp24_ = (*_tmp23_).x;
#line 190 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp25_ = move;
#line 190 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp26_ = (*_tmp25_).y;
#line 190 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp27_ = game_place_tile (_tmp22_, _tmp24_, _tmp26_, TRUE);
#line 190 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (_tmp27_ == 0) {
#line 847 "computer-player.c"
					gint _tmp28_ = 0;
					ComputerPlayerPossibleMove* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					ComputerPlayerPossibleMove* _tmp31_ = NULL;
					gint _tmp32_ = 0;
					ComputerPlayerPossibleMove* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					Game* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp28_ = depth;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp29_ = move;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp30_ = (*_tmp29_).x;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp31_ = move;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp32_ = (*_tmp31_).y;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp33_ = move;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp34_ = (*_tmp33_).n_tiles;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp35_ = g;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp36_ = game_to_string (_tmp35_);
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp37_ = _tmp36_;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					g_critical ("computer-player.vala:192: Computer marked move (depth %d, %d,%d, %d fl" \
"ips) as valid, but is invalid when checking.\n" \
"%s", _tmp28_, _tmp30_, _tmp32_, _tmp34_, _tmp37_);
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_g_free0 (_tmp37_);
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					g_assert_not_reached ();
#line 884 "computer-player.c"
				}
#line 196 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp38_ = g;
#line 196 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp39_ = depth;
#line 196 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp40_ = a;
#line 196 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp41_ = computer_player_search (self, _tmp38_, _tmp39_, COMPUTER_PLAYER_NEGATIVE_INFINITY, -_tmp40_);
#line 196 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				a_new = (-1) * _tmp41_;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp42_ = a_new;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp43_ = a;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (_tmp42_ > _tmp43_) {
#line 902 "computer-player.c"
					gint _tmp44_ = 0;
					ComputerPlayerPossibleMove* _tmp45_ = NULL;
					gint _tmp46_ = 0;
					ComputerPlayerPossibleMove* _tmp47_ = NULL;
					gint _tmp48_ = 0;
#line 199 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp44_ = a_new;
#line 199 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					a = _tmp44_;
#line 200 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp45_ = move;
#line 200 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp46_ = (*_tmp45_).x;
#line 200 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					*x = _tmp46_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp47_ = move;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp48_ = (*_tmp47_).y;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					*y = _tmp48_;
#line 924 "computer-player.c"
				}
#line 204 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp49_ = g;
#line 204 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				game_undo (_tmp49_, 1);
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_computer_player_possible_move_free0 (move);
#line 932 "computer-player.c"
			}
		}
	}
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_object_unref0 (g);
#line 940 "computer-player.c"
}


static gint computer_player_search (ComputerPlayer* self, Game* g, gint depth, gint a, gint b) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
	Game* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gint _tmp66_ = 0;
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = a;
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = b;
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (_tmp0_ <= _tmp1_, 0);
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = g;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp3_ = game_get_is_complete (_tmp2_);
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp4_ = _tmp3_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp4_) {
#line 976 "computer-player.c"
		gint _tmp5_ = 0;
		Game* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		Game* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp6_ = g;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp7_ = game_get_n_current_tiles (_tmp6_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp8_ = _tmp7_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp9_ = g;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp10_ = game_get_n_opponent_tiles (_tmp9_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp11_ = _tmp10_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		if (_tmp8_ > _tmp11_) {
#line 998 "computer-player.c"
			Game* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp12_ = g;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp13_ = game_get_n_opponent_tiles (_tmp12_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp14_ = _tmp13_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp5_ = COMPUTER_PLAYER_POSITIVE_INFINITY - _tmp14_;
#line 1010 "computer-player.c"
		} else {
			Game* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp15_ = g;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp16_ = game_get_n_current_tiles (_tmp15_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp17_ = _tmp16_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp5_ = COMPUTER_PLAYER_NEGATIVE_INFINITY + _tmp17_;
#line 1023 "computer-player.c"
		}
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		result = _tmp5_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return result;
#line 1029 "computer-player.c"
	}
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp18_ = computer_player_get_move_pending (self);
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp19_ = _tmp18_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (!_tmp19_) {
#line 218 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		result = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return result;
#line 1041 "computer-player.c"
	}
#line 221 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp20_ = depth;
#line 221 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp20_ == 0) {
#line 1047 "computer-player.c"
		Game* _tmp21_ = NULL;
		gint _tmp22_ = 0;
#line 222 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp21_ = g;
#line 222 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp22_ = computer_player_calculate_heuristic (self, _tmp21_);
#line 222 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		result = _tmp22_;
#line 222 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return result;
#line 1058 "computer-player.c"
	}
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp23_ = g;
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp24_ = game_get_current_player_can_move (_tmp23_);
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp25_ = _tmp24_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp25_) {
#line 1068 "computer-player.c"
		GList* moves = NULL;
		Game* _tmp26_ = NULL;
		GList* _tmp27_ = NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		moves = NULL;
#line 227 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp26_ = g;
#line 227 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		computer_player_get_possible_moves_sorted (self, _tmp26_, &moves);
#line 230 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp27_ = moves;
#line 1080 "computer-player.c"
		{
			GList* move_collection = NULL;
			GList* move_it = NULL;
#line 230 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			move_collection = _tmp27_;
#line 230 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 1088 "computer-player.c"
				ComputerPlayerPossibleMove* _tmp28_ = NULL;
				ComputerPlayerPossibleMove* move = NULL;
#line 230 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp28_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) move_it->data);
#line 230 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				move = _tmp28_;
#line 1095 "computer-player.c"
				{
					Game* _tmp29_ = NULL;
					ComputerPlayerPossibleMove* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					ComputerPlayerPossibleMove* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					gint _tmp34_ = 0;
					gint a_new = 0;
					Game* _tmp45_ = NULL;
					gint _tmp46_ = 0;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					gint _tmp50_ = 0;
					gint _tmp51_ = 0;
					Game* _tmp53_ = NULL;
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp29_ = g;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp30_ = move;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp31_ = (*_tmp30_).x;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp32_ = move;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp33_ = (*_tmp32_).y;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp34_ = game_place_tile (_tmp29_, _tmp31_, _tmp33_, TRUE);
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					if (_tmp34_ == 0) {
#line 1128 "computer-player.c"
						gint _tmp35_ = 0;
						ComputerPlayerPossibleMove* _tmp36_ = NULL;
						gint _tmp37_ = 0;
						ComputerPlayerPossibleMove* _tmp38_ = NULL;
						gint _tmp39_ = 0;
						ComputerPlayerPossibleMove* _tmp40_ = NULL;
						gint _tmp41_ = 0;
						Game* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp35_ = depth;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp36_ = move;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp37_ = (*_tmp36_).x;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp38_ = move;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp39_ = (*_tmp38_).y;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp40_ = move;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp41_ = (*_tmp40_).n_tiles;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp42_ = g;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp43_ = game_to_string (_tmp42_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp44_ = _tmp43_;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						g_critical ("computer-player.vala:234: Computer marked move (depth %d, %d,%d, %d fl" \
"ips) as valid, but is invalid when checking.\n" \
"%s", _tmp35_, _tmp37_, _tmp39_, _tmp41_, _tmp44_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_g_free0 (_tmp44_);
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						g_assert_not_reached ();
#line 1165 "computer-player.c"
					}
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp45_ = g;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp46_ = depth;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp47_ = b;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp48_ = a;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp49_ = computer_player_search (self, _tmp45_, _tmp46_ - 1, -_tmp47_, -_tmp48_);
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					a_new = (-1) * _tmp49_;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp50_ = a_new;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp51_ = a;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					if (_tmp50_ > _tmp51_) {
#line 1185 "computer-player.c"
						gint _tmp52_ = 0;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp52_ = a_new;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						a = _tmp52_;
#line 1191 "computer-player.c"
					}
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp53_ = g;
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					game_undo (_tmp53_, 1);
#line 245 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp54_ = b;
#line 245 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp55_ = a;
#line 245 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					if (_tmp54_ <= _tmp55_) {
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_computer_player_possible_move_free0 (move);
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						break;
#line 1207 "computer-player.c"
					}
#line 230 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_computer_player_possible_move_free0 (move);
#line 1211 "computer-player.c"
				}
			}
		}
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 1217 "computer-player.c"
	} else {
		Game* _tmp56_ = NULL;
		gint a_new = 0;
		Game* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
		Game* _tmp65_ = NULL;
#line 251 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp56_ = g;
#line 251 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		game_pass (_tmp56_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp57_ = g;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp58_ = depth;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp59_ = b;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp60_ = a;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp61_ = computer_player_search (self, _tmp57_, _tmp58_ - 1, -_tmp59_, -_tmp60_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		a_new = (-1) * _tmp61_;
#line 254 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp62_ = a_new;
#line 254 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp63_ = a;
#line 254 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		if (_tmp62_ > _tmp63_) {
#line 1251 "computer-player.c"
			gint _tmp64_ = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp64_ = a_new;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			a = _tmp64_;
#line 1257 "computer-player.c"
		}
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp65_ = g;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		game_undo (_tmp65_, 1);
#line 1263 "computer-player.c"
	}
#line 260 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp66_ = a;
#line 260 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = _tmp66_;
#line 260 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 1271 "computer-player.c"
}


static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = computer_player_compare_move ((ComputerPlayerPossibleMove*) a, (ComputerPlayerPossibleMove*) b);
#line 274 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 1280 "computer-player.c"
}


static void computer_player_get_possible_moves_sorted (ComputerPlayer* self, Game* g, GList** moves) {
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (g != NULL);
#line 1289 "computer-player.c"
	{
		gint x = 0;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		x = 0;
#line 1294 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1301 "computer-player.c"
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 1308 "computer-player.c"
					gint _tmp1_ = 0;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 1314 "computer-player.c"
				}
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp3_ = g;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp4_ = game_get_size (_tmp3_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp5_ = _tmp4_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					break;
#line 1330 "computer-player.c"
				}
				{
					gint y = 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					y = 0;
#line 1336 "computer-player.c"
					{
						gboolean _tmp6_ = FALSE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp6_ = TRUE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1343 "computer-player.c"
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint n_tiles = 0;
							Game* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							ComputerPlayerPossibleMove move = {0};
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							ComputerPlayerPossibleMove _tmp20_ = {0};
							ComputerPlayerPossibleMove* _tmp21_ = NULL;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!_tmp6_) {
#line 1362 "computer-player.c"
								gint _tmp7_ = 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp7_ = y;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								y = _tmp7_ + 1;
#line 1368 "computer-player.c"
							}
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp6_ = FALSE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp8_ = y;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp10_ = game_get_size (_tmp9_);
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp11_ = _tmp10_;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!(_tmp8_ < _tmp11_)) {
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								break;
#line 1384 "computer-player.c"
							}
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp12_ = g;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp13_ = x;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp14_ = y;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp15_ = game_place_tile (_tmp12_, _tmp13_, _tmp14_, FALSE);
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							n_tiles = _tmp15_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp16_ = n_tiles;
#line 270 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (_tmp16_ <= 0) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								continue;
#line 1402 "computer-player.c"
							}
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp17_ = x;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp18_ = y;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp19_ = n_tiles;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							computer_player_possible_move_init (&move, _tmp17_, _tmp18_, _tmp19_);
#line 274 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp20_ = move;
#line 274 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp21_ = _computer_player_possible_move_dup0 (&_tmp20_);
#line 274 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							*moves = g_list_insert_sorted (*moves, _tmp21_, _computer_player_compare_move_gcompare_func);
#line 1418 "computer-player.c"
						}
					}
				}
			}
		}
	}
}


static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b) {
	gint result = 0;
	ComputerPlayerPossibleMove* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ComputerPlayerPossibleMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = b;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = (*_tmp0_).n_tiles;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = a;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp3_ = (*_tmp2_).n_tiles;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = _tmp1_ - _tmp3_;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 1446 "computer-player.c"
}


static gint computer_player_calculate_heuristic (ComputerPlayer* self, Game* g) {
	gint result = 0;
	gint tile_difference = 0;
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Game* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Game* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	Game* _tmp14_ = NULL;
	gint _tmp15_ = 0;
#line 288 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 288 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = g;
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = game_get_n_current_tiles (_tmp0_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = _tmp1_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp3_ = g;
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp4_ = game_get_n_opponent_tiles (_tmp3_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp5_ = _tmp4_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	tile_difference = _tmp2_ - _tmp5_;
#line 293 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp6_ = self->priv->difficulty_level;
#line 293 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp6_ == 1) {
#line 1490 "computer-player.c"
		gint _tmp7_ = 0;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp7_ = tile_difference;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		result = -_tmp7_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return result;
#line 1498 "computer-player.c"
	}
#line 297 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp8_ = g;
#line 297 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp9_ = game_get_n_tiles (_tmp8_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp10_ = _tmp9_;
#line 297 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp10_ >= 54) {
#line 298 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		result = tile_difference;
#line 298 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return result;
#line 1512 "computer-player.c"
	}
#line 301 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp11_ = tile_difference;
#line 301 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp12_ = g;
#line 301 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp13_ = computer_player_eval_heuristic (_tmp12_);
#line 301 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp14_ = g;
#line 301 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp15_ = computer_player_around (_tmp14_);
#line 301 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = (_tmp11_ + _tmp13_) + _tmp15_;
#line 301 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 1528 "computer-player.c"
}


static gint computer_player_eval_heuristic (Game* g) {
	gint result = 0;
	gint count = 0;
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 304 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 306 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	count = 0;
#line 308 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = g;
#line 308 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = game_get_size (_tmp0_);
#line 308 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = _tmp1_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp2_ != 8) {
#line 309 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		result = 0;
#line 309 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return result;
#line 1554 "computer-player.c"
	}
	{
		gint x = 0;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		x = 0;
#line 1560 "computer-player.c"
		{
			gboolean _tmp3_ = FALSE;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp3_ = TRUE;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1567 "computer-player.c"
				gint _tmp5_ = 0;
				Game* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!_tmp3_) {
#line 1574 "computer-player.c"
					gint _tmp4_ = 0;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp4_ = x;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					x = _tmp4_ + 1;
#line 1580 "computer-player.c"
				}
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp3_ = FALSE;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp5_ = x;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp6_ = g;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp7_ = game_get_size (_tmp6_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp8_ = _tmp7_;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					break;
#line 1596 "computer-player.c"
				}
				{
					gint y = 0;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					y = 0;
#line 1602 "computer-player.c"
					{
						gboolean _tmp9_ = FALSE;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp9_ = TRUE;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1609 "computer-player.c"
							gint _tmp11_ = 0;
							Game* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint h = 0;
							gint _tmp15_ = 0;
							Game* _tmp16_ = NULL;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							Game* _tmp21_ = NULL;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							Player _tmp24_ = 0;
							Game* _tmp25_ = NULL;
							Player _tmp26_ = 0;
							Player _tmp27_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!_tmp9_) {
#line 1632 "computer-player.c"
								gint _tmp10_ = 0;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp10_ = y;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								y = _tmp10_ + 1;
#line 1638 "computer-player.c"
							}
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp9_ = FALSE;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp11_ = y;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp12_ = g;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp13_ = game_get_size (_tmp12_);
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp14_ = _tmp13_;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!(_tmp11_ < _tmp14_)) {
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								break;
#line 1654 "computer-player.c"
							}
#line 315 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp15_ = y;
#line 315 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp16_ = g;
#line 315 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp17_ = game_get_size (_tmp16_);
#line 315 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp18_ = _tmp17_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp19_ = x;
#line 315 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp20_ = COMPUTER_PLAYER_heuristic[(_tmp15_ * _tmp18_) + _tmp19_];
#line 315 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							h = _tmp20_;
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp21_ = g;
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp22_ = x;
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp23_ = y;
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp24_ = game_get_owner (_tmp21_, _tmp22_, _tmp23_);
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp25_ = g;
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp26_ = game_get_current_color (_tmp25_);
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp27_ = _tmp26_;
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (_tmp24_ != _tmp27_) {
#line 1686 "computer-player.c"
								gint _tmp28_ = 0;
#line 317 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp28_ = h;
#line 317 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								h = -_tmp28_;
#line 1692 "computer-player.c"
							}
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp29_ = count;
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp30_ = h;
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							count = _tmp29_ + _tmp30_;
#line 1700 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = count;
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 1711 "computer-player.c"
}


static gint computer_player_around (Game* g) {
	gint result = 0;
	gint count = 0;
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	count = 0;
#line 1722 "computer-player.c"
	{
		gint x = 0;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		x = 0;
#line 1727 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1734 "computer-player.c"
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 1741 "computer-player.c"
					gint _tmp1_ = 0;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 1747 "computer-player.c"
				}
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp3_ = g;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp4_ = game_get_size (_tmp3_);
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp5_ = _tmp4_;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					break;
#line 1763 "computer-player.c"
				}
				{
					gint y = 0;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					y = 0;
#line 1769 "computer-player.c"
					{
						gboolean _tmp6_ = FALSE;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp6_ = TRUE;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1776 "computer-player.c"
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint a = 0;
							gint _tmp12_ = 0;
							Game* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Game* _tmp18_ = NULL;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							Game* _tmp23_ = NULL;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							Game* _tmp28_ = NULL;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							Game* _tmp33_ = NULL;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							Game* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							gint _tmp42_ = 0;
							Game* _tmp43_ = NULL;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							Game* _tmp48_ = NULL;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							Game* _tmp54_ = NULL;
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							Player _tmp57_ = 0;
							Game* _tmp58_ = NULL;
							Player _tmp59_ = 0;
							Player _tmp60_ = 0;
							gint _tmp63_ = 0;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!_tmp6_) {
#line 1834 "computer-player.c"
								gint _tmp7_ = 0;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp7_ = y;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								y = _tmp7_ + 1;
#line 1840 "computer-player.c"
							}
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp6_ = FALSE;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp8_ = y;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp10_ = game_get_size (_tmp9_);
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp11_ = _tmp10_;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!(_tmp8_ < _tmp11_)) {
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								break;
#line 1856 "computer-player.c"
							}
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = 0;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp12_ = a;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp13_ = g;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp14_ = x;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp15_ = y;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp16_ = computer_player_is_empty (_tmp13_, _tmp14_ + 1, _tmp15_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp12_ - _tmp16_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp17_ = a;
#line 334 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp18_ = g;
#line 334 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp19_ = x;
#line 334 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp20_ = y;
#line 334 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp21_ = computer_player_is_empty (_tmp18_, _tmp19_ + 1, _tmp20_ + 1);
#line 334 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp17_ - _tmp21_;
#line 335 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp22_ = a;
#line 335 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp23_ = g;
#line 335 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp24_ = x;
#line 335 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp25_ = y;
#line 335 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp26_ = computer_player_is_empty (_tmp23_, _tmp24_, _tmp25_ + 1);
#line 335 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp22_ - _tmp26_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp27_ = a;
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp28_ = g;
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp29_ = x;
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp30_ = y;
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp31_ = computer_player_is_empty (_tmp28_, _tmp29_ - 1, _tmp30_ + 1);
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp27_ - _tmp31_;
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp32_ = a;
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp33_ = g;
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp34_ = x;
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp35_ = y;
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp36_ = computer_player_is_empty (_tmp33_, _tmp34_ - 1, _tmp35_);
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp32_ - _tmp36_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp37_ = a;
#line 338 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp38_ = g;
#line 338 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp39_ = x;
#line 338 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp40_ = y;
#line 338 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp41_ = computer_player_is_empty (_tmp38_, _tmp39_ - 1, _tmp40_ - 1);
#line 338 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp37_ - _tmp41_;
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp42_ = a;
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp43_ = g;
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp44_ = x;
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp45_ = y;
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp46_ = computer_player_is_empty (_tmp43_, _tmp44_, _tmp45_ - 1);
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp42_ - _tmp46_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp47_ = a;
#line 340 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp48_ = g;
#line 340 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp49_ = x;
#line 340 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp50_ = y;
#line 340 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp51_ = computer_player_is_empty (_tmp48_, _tmp49_ + 1, _tmp50_ - 1);
#line 340 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp47_ - _tmp51_;
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp52_ = a;
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (_tmp52_ == 0) {
#line 344 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								a = 2;
#line 1962 "computer-player.c"
							}
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp54_ = g;
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp55_ = x;
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp56_ = y;
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp57_ = game_get_owner (_tmp54_, _tmp55_, _tmp56_);
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp58_ = g;
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp59_ = game_get_current_color (_tmp58_);
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp60_ = _tmp59_;
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (_tmp57_ == _tmp60_) {
#line 1980 "computer-player.c"
								gint _tmp61_ = 0;
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp61_ = a;
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp53_ = _tmp61_;
#line 1986 "computer-player.c"
							} else {
								gint _tmp62_ = 0;
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp62_ = a;
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp53_ = -_tmp62_;
#line 1993 "computer-player.c"
							}
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp63_ = count;
#line 346 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							count = _tmp63_ + _tmp53_;
#line 1999 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 349 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = count;
#line 349 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 2010 "computer-player.c"
}


static gint computer_player_is_empty (Game* g, gint x, gint y) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
#line 352 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = g;
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = x;
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp3_ = y;
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp4_ = game_is_valid_location (_tmp1_, _tmp2_, _tmp3_);
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp4_) {
#line 2033 "computer-player.c"
		Game* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		Player _tmp8_ = 0;
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp5_ = g;
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp6_ = x;
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp7_ = y;
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp8_ = game_get_owner (_tmp5_, _tmp6_, _tmp7_);
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp0_ = _tmp8_ == PLAYER_NONE;
#line 2048 "computer-player.c"
	} else {
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp0_ = FALSE;
#line 2052 "computer-player.c"
	}
#line 354 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp0_) {
#line 355 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		result = 1;
#line 355 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return result;
#line 2060 "computer-player.c"
	}
#line 357 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = 0;
#line 357 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 2066 "computer-player.c"
}


static void computer_player_random_select (Game* g, gint* move_x, gint* move_y) {
	gint _vala_move_x = 0;
	gint _vala_move_y = 0;
	GList* moves = NULL;
	GList* _tmp24_ = NULL;
	gint32 i = 0;
	GList* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	gint32 _tmp27_ = 0;
	gint xy = 0;
	GList* _tmp28_ = NULL;
	gconstpointer _tmp29_ = NULL;
	Game* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	Game* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
#line 364 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (g != NULL);
#line 366 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	moves = NULL;
#line 2092 "computer-player.c"
	{
		gint x = 0;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		x = 0;
#line 2097 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			while (TRUE) {
#line 2104 "computer-player.c"
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 2111 "computer-player.c"
					gint _tmp1_ = 0;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 2117 "computer-player.c"
				}
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp3_ = g;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp4_ = game_get_size (_tmp3_);
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp5_ = _tmp4_;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					break;
#line 2133 "computer-player.c"
				}
				{
					gint y = 0;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					y = 0;
#line 2139 "computer-player.c"
					{
						gboolean _tmp6_ = FALSE;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp6_ = TRUE;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						while (TRUE) {
#line 2146 "computer-player.c"
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							Game* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							Game* _tmp15_ = NULL;
							Player _tmp16_ = 0;
							Player _tmp17_ = 0;
							gboolean _tmp18_ = FALSE;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!_tmp6_) {
#line 2160 "computer-player.c"
								gint _tmp7_ = 0;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp7_ = y;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								y = _tmp7_ + 1;
#line 2166 "computer-player.c"
							}
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp6_ = FALSE;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp8_ = y;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp10_ = game_get_size (_tmp9_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp11_ = _tmp10_;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!(_tmp8_ < _tmp11_)) {
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								break;
#line 2182 "computer-player.c"
							}
#line 369 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp12_ = g;
#line 369 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp13_ = x;
#line 369 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp14_ = y;
#line 369 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp15_ = g;
#line 369 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp16_ = game_get_current_color (_tmp15_);
#line 369 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp17_ = _tmp16_;
#line 369 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp18_ = game_can_place (_tmp12_, _tmp13_, _tmp14_, _tmp17_);
#line 369 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (_tmp18_) {
#line 2200 "computer-player.c"
								gint _tmp19_ = 0;
								Game* _tmp20_ = NULL;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp19_ = x;
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp20_ = g;
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp21_ = game_get_size (_tmp20_);
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp22_ = _tmp21_;
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp23_ = y;
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								moves = g_list_append (moves, (gpointer) ((gintptr) ((_tmp19_ * _tmp22_) + _tmp23_)));
#line 2218 "computer-player.c"
							}
						}
					}
				}
			}
		}
	}
#line 372 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp24_ = moves;
#line 372 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp24_ == NULL) {
#line 373 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_assert_not_reached ();
#line 2232 "computer-player.c"
	}
#line 375 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp25_ = moves;
#line 375 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp26_ = g_list_length (_tmp25_);
#line 375 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp27_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp26_));
#line 375 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	i = _tmp27_;
#line 376 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp28_ = moves;
#line 376 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp29_ = g_list_nth_data (_tmp28_, (guint) i);
#line 376 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	xy = (gint) ((gintptr) _tmp29_);
#line 377 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp30_ = g;
#line 377 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp31_ = game_get_size (_tmp30_);
#line 377 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp32_ = _tmp31_;
#line 377 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_vala_move_x = xy / _tmp32_;
#line 378 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp33_ = g;
#line 378 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp34_ = game_get_size (_tmp33_);
#line 378 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp35_ = _tmp34_;
#line 378 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_vala_move_y = xy % _tmp35_;
#line 364 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_list_free0 (moves);
#line 364 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (move_x) {
#line 364 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		*move_x = _vala_move_x;
#line 2270 "computer-player.c"
	}
#line 364 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (move_y) {
#line 364 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		*move_y = _vala_move_y;
#line 2276 "computer-player.c"
	}
}


static gboolean computer_player_get_move_pending (ComputerPlayer* self) {
	gboolean result;
	gboolean _result_ = FALSE;
	gboolean _tmp0_ = FALSE;
#line 60 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 62 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_rec_mutex_lock (&self->priv->_move_pending_mutex);
#line 63 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->_move_pending;
#line 63 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_result_ = _tmp0_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_rec_mutex_unlock (&self->priv->_move_pending_mutex);
#line 65 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = _result_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 2299 "computer-player.c"
}


static void computer_player_set_move_pending (ComputerPlayer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 68 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_rec_mutex_lock (&self->priv->_move_pending_mutex);
#line 71 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = value;
#line 71 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self->priv->_move_pending = _tmp0_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_rec_mutex_unlock (&self->priv->_move_pending_mutex);
#line 2315 "computer-player.c"
}


static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 20 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	memset (self, 0, sizeof (ComputerPlayerPossibleMove));
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = x;
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	(*self).x = _tmp0_;
#line 23 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = y;
#line 23 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	(*self).y = _tmp1_;
#line 24 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = n_tiles;
#line 24 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	(*self).n_tiles = _tmp2_;
#line 2337 "computer-player.c"
}


static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self) {
	ComputerPlayerPossibleMove* dup;
#line 14 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	dup = g_new0 (ComputerPlayerPossibleMove, 1);
#line 14 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	memcpy (dup, self, sizeof (ComputerPlayerPossibleMove));
#line 14 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return dup;
#line 2349 "computer-player.c"
}


static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self) {
#line 14 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_free (self);
#line 2356 "computer-player.c"
}


static GType computer_player_possible_move_get_type (void) {
	static volatile gsize computer_player_possible_move_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_possible_move_type_id__volatile)) {
		GType computer_player_possible_move_type_id;
		computer_player_possible_move_type_id = g_boxed_type_register_static ("ComputerPlayerPossibleMove", (GBoxedCopyFunc) computer_player_possible_move_dup, (GBoxedFreeFunc) computer_player_possible_move_free);
		g_once_init_leave (&computer_player_possible_move_type_id__volatile, computer_player_possible_move_type_id);
	}
	return computer_player_possible_move_type_id__volatile;
}


static void computer_player_class_init (ComputerPlayerClass * klass) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_type_class_add_private (klass, sizeof (ComputerPlayerPrivate));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_computer_player_get_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_computer_player_set_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->finalize = computer_player_finalize;
#line 2382 "computer-player.c"
}


static void computer_player_instance_init (ComputerPlayer * self) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self->priv = COMPUTER_PLAYER_GET_PRIVATE (self);
#line 52 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self->priv->pending_move_id = (guint) 0;
#line 2391 "computer-player.c"
}


static void computer_player_finalize (GObject* obj) {
	ComputerPlayer * self;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 33 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_object_unref0 (self->priv->game);
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_vala_clear_GRecMutex (&self->priv->_move_pending_mutex);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (computer_player_parent_class)->finalize (obj);
#line 2405 "computer-player.c"
}


GType computer_player_get_type (void) {
	static volatile gsize computer_player_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComputerPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) computer_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComputerPlayer), 0, (GInstanceInitFunc) computer_player_instance_init, NULL };
		GType computer_player_type_id;
		computer_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ComputerPlayer", &g_define_type_info, 0);
		g_once_init_leave (&computer_player_type_id__volatile, computer_player_type_id);
	}
	return computer_player_type_id__volatile;
}


static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	switch (property_id) {
#line 2426 "computer-player.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		break;
#line 2432 "computer-player.c"
	}
}


static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	switch (property_id) {
#line 2442 "computer-player.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		break;
#line 2448 "computer-player.c"
	}
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



