/* game-view.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from game-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

#define TYPE_PLAYER (player_get_type ())

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	gint tile_size;
	gint board_size;
	guint render_size;
	cairo_pattern_t* tiles_pattern;
	gint* pixmaps;
	gint pixmaps_length1;
	gint pixmaps_length2;
	guint animate_timeout;
	gboolean flip_final_result_now;
	Game* _game;
	gchar* _theme;
};

struct _Block2Data {
	int _ref_count_;
	GameView* self;
	gint x;
	gint y;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME
};
#define GAME_VIEW_GRID_BORDER 3
#define GAME_VIEW_GRID_SPACING 2
#define GAME_VIEW_PIXMAP_FLIP_DELAY 20
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void game_view_calculate (GameView* self);
Game* game_view_get_game (GameView* self);
gint game_get_size (Game* self);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
static void game_view_load_theme (GameView* self, cairo_t* c);
static gint game_view_get_x_offset (GameView* self);
static gint game_view_get_y_offset (GameView* self);
const gchar* game_view_get_theme (GameView* self);
static void game_view_square_changed_cb (GameView* self, gint x, gint y);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
GType player_get_type (void) G_GNUC_CONST;
static gint game_view_get_pixmap (GameView* self, Player color);
Player game_get_owner (Game* self, gint x, gint y);
gboolean game_get_is_complete (Game* self);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap);
static gboolean ___lambda6_ (Block2Data* _data2_);
static gboolean ____lambda6__gsource_func (gpointer self);
static gboolean game_view_animate_cb (GameView* self);
static gboolean _game_view_animate_cb_gsource_func (gpointer self);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
#line 70 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = (GameView*) g_object_new (object_type, NULL);
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK));
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 350, 350);
#line 70 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return self;
#line 153 "game-view.c"
}


GameView* game_view_new (void) {
#line 70 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return game_view_construct (TYPE_GAME_VIEW);
#line 160 "game-view.c"
}


static void game_view_calculate (GameView* self) {
	gint size = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Game* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
#line 76 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = MIN (_tmp0_, _tmp1_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	size = _tmp2_;
#line 80 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp3_ = game_view_get_game (self);
#line 80 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 80 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp5_ = game_get_size (_tmp4_);
#line 80 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp6_ = _tmp5_;
#line 80 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->tile_size = ((size - (2 * GAME_VIEW_GRID_BORDER)) + GAME_VIEW_GRID_SPACING) / _tmp6_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp7_ = self->priv->tile_size;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp8_ = game_view_get_game (self);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp9_ = _tmp8_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp10_ = game_get_size (_tmp9_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp11_ = _tmp10_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->board_size = ((_tmp7_ * _tmp11_) - GAME_VIEW_GRID_SPACING) + (2 * GAME_VIEW_GRID_BORDER);
#line 210 "game-view.c"
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	cairo_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	cairo_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	cairo_t* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
	cairo_t* _tmp30_ = NULL;
	cairo_t* _tmp48_ = NULL;
	cairo_t* _tmp49_ = NULL;
#line 85 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 85 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 87 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 87 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 87 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 88 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		result = FALSE;
#line 88 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return result;
#line 251 "game-view.c"
	}
#line 90 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	game_view_calculate (self);
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp3_ = self->priv->tiles_pattern;
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp3_ == NULL) {
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp2_ = TRUE;
#line 261 "game-view.c"
	} else {
		guint _tmp4_ = 0U;
		gint _tmp5_ = 0;
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp4_ = self->priv->render_size;
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp5_ = self->priv->tile_size;
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp2_ = _tmp4_ != ((guint) _tmp5_);
#line 271 "game-view.c"
	}
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp2_) {
#line 275 "game-view.c"
		gint _tmp6_ = 0;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp7_ = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		cairo_surface_t* _tmp11_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp12_ = NULL;
		cairo_t* _tmp13_ = NULL;
		cairo_t* _tmp14_ = NULL;
		cairo_surface_t* _tmp15_ = NULL;
		cairo_pattern_t* _tmp16_ = NULL;
#line 94 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp6_ = self->priv->tile_size;
#line 94 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		self->priv->render_size = (guint) _tmp6_;
#line 95 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp7_ = cr;
#line 95 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = cairo_get_target (_tmp7_);
#line 95 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp9_ = self->priv->tile_size;
#line 95 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp10_ = self->priv->tile_size;
#line 95 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_ = cairo_surface_create_similar (_tmp8_, CAIRO_CONTENT_COLOR_ALPHA, _tmp9_ * 8, _tmp10_ * 4);
#line 95 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		surface = _tmp11_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp12_ = surface;
#line 96 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp13_ = cairo_create (_tmp12_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		c = _tmp13_;
#line 97 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp14_ = c;
#line 97 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		game_view_load_theme (self, _tmp14_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp15_ = surface;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp16_ = cairo_pattern_create_for_surface (_tmp15_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		self->priv->tiles_pattern = _tmp16_;
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_cairo_destroy0 (c);
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_cairo_surface_destroy0 (surface);
#line 327 "game-view.c"
	}
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp17_ = cr;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp18_ = game_view_get_x_offset (self);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp19_ = _tmp18_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp20_ = game_view_get_y_offset (self);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp21_ = _tmp20_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_translate (_tmp17_, (gdouble) _tmp19_, (gdouble) _tmp21_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp22_ = cr;
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_set_source_rgba (_tmp22_, 0.3, 0.6, 0.4, 1.0);
#line 105 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp23_ = cr;
#line 105 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp24_ = self->priv->board_size;
#line 105 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp25_ = self->priv->board_size;
#line 105 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_rectangle (_tmp23_, (-GAME_VIEW_GRID_BORDER) / 2.0, (-GAME_VIEW_GRID_BORDER) / 2.0, (gdouble) (_tmp24_ - GAME_VIEW_GRID_BORDER), (gdouble) (_tmp25_ - GAME_VIEW_GRID_BORDER));
#line 106 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp26_ = cr;
#line 106 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_fill_preserve (_tmp26_);
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp27_ = cr;
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_set_source_rgba (_tmp27_, 0.0, 0.0, 0.0, 1.0);
#line 108 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp28_ = cr;
#line 108 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_set_line_width (_tmp28_, (gdouble) GAME_VIEW_GRID_BORDER);
#line 109 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp29_ = cr;
#line 109 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_stroke (_tmp29_);
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp30_ = cr;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_set_line_width (_tmp30_, (gdouble) GAME_VIEW_GRID_SPACING);
#line 373 "game-view.c"
	{
		gint i = 0;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		i = 1;
#line 378 "game-view.c"
		{
			gboolean _tmp31_ = FALSE;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp31_ = TRUE;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			while (TRUE) {
#line 385 "game-view.c"
				gint _tmp33_ = 0;
				Game* _tmp34_ = NULL;
				Game* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				cairo_t* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				cairo_t* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				cairo_t* _tmp43_ = NULL;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				cairo_t* _tmp46_ = NULL;
				gint _tmp47_ = 0;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!_tmp31_) {
#line 403 "game-view.c"
					gint _tmp32_ = 0;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp32_ = i;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					i = _tmp32_ + 1;
#line 409 "game-view.c"
				}
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp31_ = FALSE;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp33_ = i;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp34_ = game_view_get_game (self);
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp35_ = _tmp34_;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp36_ = game_get_size (_tmp35_);
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp37_ = _tmp36_;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!(_tmp33_ < _tmp37_)) {
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					break;
#line 427 "game-view.c"
				}
#line 115 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp38_ = cr;
#line 115 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp39_ = i;
#line 115 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp40_ = self->priv->tile_size;
#line 115 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				cairo_move_to (_tmp38_, (_tmp39_ * _tmp40_) - (GAME_VIEW_GRID_SPACING / 2.0), (gdouble) 0);
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp41_ = cr;
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp42_ = self->priv->board_size;
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				cairo_rel_line_to (_tmp41_, (gdouble) 0, (gdouble) (_tmp42_ - GAME_VIEW_GRID_BORDER));
#line 118 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp43_ = cr;
#line 118 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp44_ = i;
#line 118 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp45_ = self->priv->tile_size;
#line 118 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				cairo_move_to (_tmp43_, (gdouble) 0, (_tmp44_ * _tmp45_) - (GAME_VIEW_GRID_SPACING / 2.0));
#line 119 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp46_ = cr;
#line 119 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp47_ = self->priv->board_size;
#line 119 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				cairo_rel_line_to (_tmp46_, (gdouble) (_tmp47_ - GAME_VIEW_GRID_BORDER), (gdouble) 0);
#line 457 "game-view.c"
			}
		}
	}
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp48_ = cr;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_stroke (_tmp48_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp49_ = cr;
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_translate (_tmp49_, (gdouble) ((-GAME_VIEW_GRID_SPACING) / 2), (gdouble) ((-GAME_VIEW_GRID_SPACING) / 2));
#line 469 "game-view.c"
	{
		gint x = 0;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		x = 0;
#line 474 "game-view.c"
		{
			gboolean _tmp50_ = FALSE;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp50_ = TRUE;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			while (TRUE) {
#line 481 "game-view.c"
				gint _tmp52_ = 0;
				Game* _tmp53_ = NULL;
				Game* _tmp54_ = NULL;
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!_tmp50_) {
#line 489 "game-view.c"
					gint _tmp51_ = 0;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp51_ = x;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					x = _tmp51_ + 1;
#line 495 "game-view.c"
				}
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp50_ = FALSE;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp52_ = x;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp53_ = game_view_get_game (self);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp54_ = _tmp53_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp55_ = game_get_size (_tmp54_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp56_ = _tmp55_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!(_tmp52_ < _tmp56_)) {
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					break;
#line 513 "game-view.c"
				}
				{
					gint y = 0;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					y = 0;
#line 519 "game-view.c"
					{
						gboolean _tmp57_ = FALSE;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						_tmp57_ = TRUE;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						while (TRUE) {
#line 526 "game-view.c"
							gint _tmp59_ = 0;
							Game* _tmp60_ = NULL;
							Game* _tmp61_ = NULL;
							gint _tmp62_ = 0;
							gint _tmp63_ = 0;
							gint* _tmp64_ = NULL;
							gint _tmp64__length1 = 0;
							gint _tmp64__length2 = 0;
							gint _tmp65_ = 0;
							gint _tmp66_ = 0;
							gint _tmp67_ = 0;
							gint tile_x = 0;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
							gint tile_y = 0;
							gint _tmp70_ = 0;
							gint _tmp71_ = 0;
							gint texture_x = 0;
							gint* _tmp72_ = NULL;
							gint _tmp72__length1 = 0;
							gint _tmp72__length2 = 0;
							gint _tmp73_ = 0;
							gint _tmp74_ = 0;
							gint _tmp75_ = 0;
							gint _tmp76_ = 0;
							gint texture_y = 0;
							gint* _tmp77_ = NULL;
							gint _tmp77__length1 = 0;
							gint _tmp77__length2 = 0;
							gint _tmp78_ = 0;
							gint _tmp79_ = 0;
							gint _tmp80_ = 0;
							gint _tmp81_ = 0;
							cairo_matrix_t matrix = {0};
							gint _tmp82_ = 0;
							gint _tmp83_ = 0;
							gint _tmp84_ = 0;
							gint _tmp85_ = 0;
							cairo_pattern_t* _tmp86_ = NULL;
							cairo_matrix_t _tmp87_ = {0};
							cairo_t* _tmp88_ = NULL;
							cairo_pattern_t* _tmp89_ = NULL;
							cairo_t* _tmp90_ = NULL;
							gint _tmp91_ = 0;
							gint _tmp92_ = 0;
							gint _tmp93_ = 0;
							gint _tmp94_ = 0;
							cairo_t* _tmp95_ = NULL;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (!_tmp57_) {
#line 577 "game-view.c"
								gint _tmp58_ = 0;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp58_ = y;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								y = _tmp58_ + 1;
#line 583 "game-view.c"
							}
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp57_ = FALSE;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp59_ = y;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp60_ = game_view_get_game (self);
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp61_ = _tmp60_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp62_ = game_get_size (_tmp61_);
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp63_ = _tmp62_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (!(_tmp59_ < _tmp63_)) {
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								break;
#line 601 "game-view.c"
							}
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp64_ = self->priv->pixmaps;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp64__length1 = self->priv->pixmaps_length1;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp64__length2 = self->priv->pixmaps_length2;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp65_ = x;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp66_ = y;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp67_ = _tmp64_[(_tmp65_ * _tmp64__length2) + _tmp66_];
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (_tmp67_ == 0) {
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								continue;
#line 619 "game-view.c"
							}
#line 132 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp68_ = x;
#line 132 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp69_ = self->priv->tile_size;
#line 132 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							tile_x = _tmp68_ * _tmp69_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp70_ = y;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp71_ = self->priv->tile_size;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							tile_y = _tmp70_ * _tmp71_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp72_ = self->priv->pixmaps;
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp72__length1 = self->priv->pixmaps_length1;
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp72__length2 = self->priv->pixmaps_length2;
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp73_ = x;
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp74_ = y;
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp75_ = _tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_];
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp76_ = self->priv->tile_size;
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							texture_x = (_tmp75_ % 8) * _tmp76_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp77_ = self->priv->pixmaps;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp77__length1 = self->priv->pixmaps_length1;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp77__length2 = self->priv->pixmaps_length2;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp78_ = x;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp79_ = y;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp80_ = _tmp77_[(_tmp78_ * _tmp77__length2) + _tmp79_];
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp81_ = self->priv->tile_size;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							texture_y = (_tmp80_ / 8) * _tmp81_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_matrix_init_identity (&matrix);
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp82_ = texture_x;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp83_ = tile_x;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp84_ = texture_y;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp85_ = tile_y;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_matrix_translate (&matrix, (gdouble) (_tmp82_ - _tmp83_), (gdouble) (_tmp84_ - _tmp85_));
#line 139 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp86_ = self->priv->tiles_pattern;
#line 139 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp87_ = matrix;
#line 139 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_pattern_set_matrix (_tmp86_, &_tmp87_);
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp88_ = cr;
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp89_ = self->priv->tiles_pattern;
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_set_source (_tmp88_, _tmp89_);
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp90_ = cr;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp91_ = tile_x;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp92_ = tile_y;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp93_ = self->priv->tile_size;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp94_ = self->priv->tile_size;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_rectangle (_tmp90_, (gdouble) _tmp91_, (gdouble) _tmp92_, (gdouble) _tmp93_, (gdouble) _tmp94_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp95_ = cr;
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_fill (_tmp95_);
#line 705 "game-view.c"
						}
					}
				}
			}
		}
	}
#line 145 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = FALSE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 716 "game-view.c"
}


static void game_view_load_theme (GameView* self, cairo_t* c) {
	gint width = 0;
	gint _tmp0_ = 0;
	gint height = 0;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
#line 148 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 148 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (c != NULL);
#line 150 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = self->priv->tile_size;
#line 150 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	width = _tmp0_ * 8;
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = self->priv->tile_size;
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	height = _tmp1_ * 4;
#line 738 "game-view.c"
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		RsvgHandle* _tmp4_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		cairo_t* _tmp9_ = NULL;
		cairo_matrix_t _tmp10_ = {0};
		cairo_t* _tmp11_ = NULL;
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp2_ = game_view_get_theme (self);
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp3_ = _tmp2_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp4_ = rsvg_handle_new_from_file (_tmp3_, &_inner_error_);
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		h = _tmp4_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 762 "game-view.c"
			goto __catch0_g_error;
		}
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		cairo_matrix_init_identity (&m);
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_object_get (h, "width", &_tmp5_, NULL);
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp6_ = _tmp5_;
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_object_get (h, "height", &_tmp7_, NULL);
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		cairo_matrix_scale (&m, ((gdouble) width) / _tmp6_, ((gdouble) height) / _tmp8_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp9_ = c;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp10_ = m;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		cairo_set_matrix (_tmp9_, &_tmp10_);
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_ = c;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		rsvg_handle_render_cairo (h, _tmp11_);
#line 162 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_g_object_unref0 (h);
#line 162 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return;
#line 791 "game-view.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		e = _inner_error_;
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 803 "game-view.c"
	}
	__finally0:
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return;
#line 814 "game-view.c"
	}
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GdkPixbuf* _tmp14_ = NULL;
		cairo_t* _tmp15_ = NULL;
		GdkPixbuf* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp12_ = game_view_get_theme (self);
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp14_ = gdk_pixbuf_new_from_file_at_scale (_tmp13_, width, height, FALSE, &_inner_error_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		p = _tmp14_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 834 "game-view.c"
			goto __catch1_g_error;
		}
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp15_ = c;
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp16_ = p;
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		gdk_cairo_set_source_pixbuf (_tmp15_, _tmp16_, (gdouble) 0, (gdouble) 0);
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17_ = c;
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		cairo_paint (_tmp17_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_g_object_unref0 (p);
#line 849 "game-view.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		e = _inner_error_;
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp18_ = game_view_get_theme (self);
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp19_ = _tmp18_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp20_ = e;
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp21_ = _tmp20_->message;
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_warning ("game-view.vala:177: Failed to load theme %s: %s", _tmp19_, _tmp21_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 875 "game-view.c"
	}
	__finally1:
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return;
#line 886 "game-view.c"
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return _data2_;
#line 896 "game-view.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 905 "game-view.c"
		GameView* self;
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		self = _data2_->self;
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_g_object_unref0 (self);
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_slice_free (Block2Data, _data2_);
#line 913 "game-view.c"
	}
}


static gboolean ___lambda6_ (Block2Data* _data2_) {
	GameView* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 222 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = _data2_->self;
#line 223 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->flip_final_result_now = TRUE;
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = _data2_->x;
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = _data2_->y;
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	game_view_square_changed_cb (self, _tmp0_, _tmp1_);
#line 225 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = G_SOURCE_REMOVE;
#line 225 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 937 "game-view.c"
}


static gboolean ____lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda6_ (self);
#line 222 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 946 "game-view.c"
}


static void game_view_square_changed_cb (GameView* self, gint x, gint y) {
	Block2Data* _data2_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint pixmap = 0;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Player _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	Game* _tmp49_ = NULL;
	Game* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data2_->_ref_count_ = 1;
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data2_->self = g_object_ref (self);
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = x;
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data2_->x = _tmp0_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = y;
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data2_->y = _tmp1_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = game_view_get_game (self);
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp4_ = _data2_->x;
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp5_ = _data2_->y;
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp6_ = game_get_owner (_tmp3_, _tmp4_, _tmp5_);
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp7_ = game_view_get_pixmap (self, _tmp6_);
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	pixmap = _tmp7_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp9_ = self->priv->flip_final_result_now;
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp9_) {
#line 1006 "game-view.c"
		Game* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp10_ = game_view_get_game (self);
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_ = _tmp10_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp12_ = game_get_is_complete (_tmp11_);
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = _tmp13_;
#line 1021 "game-view.c"
	} else {
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = FALSE;
#line 1025 "game-view.c"
	}
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp8_) {
#line 1029 "game-view.c"
		gint n = 0;
		gint _tmp14_ = 0;
		Game* _tmp15_ = NULL;
		Game* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		Player winning_color = 0;
		Player losing_color = 0;
		gint n_winning_tiles = 0;
		Game* _tmp20_ = NULL;
		Game* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint n_losing_tiles = 0;
		Game* _tmp24_ = NULL;
		Game* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp14_ = _data2_->y;
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp15_ = game_view_get_game (self);
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp16_ = _tmp15_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17_ = game_get_size (_tmp16_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp18_ = _tmp17_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp19_ = _data2_->x;
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		n = (_tmp14_ * _tmp18_) + _tmp19_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		winning_color = PLAYER_LIGHT;
#line 190 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		losing_color = PLAYER_DARK;
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp20_ = game_view_get_game (self);
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp21_ = _tmp20_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp22_ = game_get_n_light_tiles (_tmp21_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp23_ = _tmp22_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		n_winning_tiles = _tmp23_;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp24_ = game_view_get_game (self);
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp25_ = _tmp24_;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp26_ = game_get_n_dark_tiles (_tmp25_);
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp27_ = _tmp26_;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		n_losing_tiles = _tmp27_;
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp28_ = n_losing_tiles;
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp29_ = n_winning_tiles;
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp28_ > _tmp29_) {
#line 1097 "game-view.c"
			gint t = 0;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
#line 195 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			winning_color = PLAYER_DARK;
#line 196 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			losing_color = PLAYER_LIGHT;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp30_ = n_winning_tiles;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			t = _tmp30_;
#line 198 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp31_ = n_losing_tiles;
#line 198 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			n_winning_tiles = _tmp31_;
#line 199 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp32_ = t;
#line 199 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			n_losing_tiles = _tmp32_;
#line 1118 "game-view.c"
		}
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp33_ = n;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp34_ = n_winning_tiles;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp33_ < _tmp34_) {
#line 1126 "game-view.c"
			Player _tmp35_ = 0;
			gint _tmp36_ = 0;
#line 202 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp35_ = winning_color;
#line 202 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp36_ = game_view_get_pixmap (self, _tmp35_);
#line 202 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			pixmap = _tmp36_;
#line 1135 "game-view.c"
		} else {
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
#line 203 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp37_ = n;
#line 203 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp38_ = n_winning_tiles;
#line 203 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp39_ = n_losing_tiles;
#line 203 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			if (_tmp37_ < (_tmp38_ + _tmp39_)) {
#line 1148 "game-view.c"
				Player _tmp40_ = 0;
				gint _tmp41_ = 0;
#line 204 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp40_ = losing_color;
#line 204 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp41_ = game_view_get_pixmap (self, _tmp40_);
#line 204 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				pixmap = _tmp41_;
#line 1157 "game-view.c"
			} else {
				gint _tmp42_ = 0;
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp42_ = game_view_get_pixmap (self, PLAYER_NONE);
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				pixmap = _tmp42_;
#line 1164 "game-view.c"
			}
		}
	} else {
		gboolean _tmp43_ = FALSE;
#line 209 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp43_ = self->priv->flip_final_result_now;
#line 209 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp43_) {
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			self->priv->flip_final_result_now = FALSE;
#line 1175 "game-view.c"
		}
	}
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp44_ = _data2_->x;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp45_ = _data2_->y;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp46_ = pixmap;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	game_view_set_square (self, _tmp44_, _tmp45_, _tmp46_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp49_ = game_view_get_game (self);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp50_ = _tmp49_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp51_ = game_get_is_complete (_tmp50_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp52_ = _tmp51_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp52_) {
#line 1196 "game-view.c"
		Game* _tmp53_ = NULL;
		Game* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp53_ = game_view_get_game (self);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp54_ = _tmp53_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp55_ = game_get_n_light_tiles (_tmp54_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp56_ = _tmp55_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp48_ = _tmp56_ > 0;
#line 1211 "game-view.c"
	} else {
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp48_ = FALSE;
#line 1215 "game-view.c"
	}
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp48_) {
#line 1219 "game-view.c"
		Game* _tmp57_ = NULL;
		Game* _tmp58_ = NULL;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp57_ = game_view_get_game (self);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp58_ = _tmp57_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp59_ = game_get_n_dark_tiles (_tmp58_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp60_ = _tmp59_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp47_ = _tmp60_ > 0;
#line 1234 "game-view.c"
	} else {
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp47_ = FALSE;
#line 1238 "game-view.c"
	}
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp47_) {
#line 222 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ____lambda6__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 1244 "game-view.c"
	}
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	block2_data_unref (_data2_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data2_ = NULL;
#line 1250 "game-view.c"
}


static gboolean _game_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_view_animate_cb ((GameView*) self);
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1259 "game-view.c"
}


static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
#line 230 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = self->priv->pixmaps;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0__length1 = self->priv->pixmaps_length1;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0__length2 = self->priv->pixmaps_length2;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = x;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = y;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp4_ = pixmap;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp3_ == _tmp4_) {
#line 233 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return;
#line 1303 "game-view.c"
	}
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp6_ = pixmap;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp6_ == 0) {
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp5_ = TRUE;
#line 1311 "game-view.c"
	} else {
		gint* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp7_ = self->priv->pixmaps;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp7__length1 = self->priv->pixmaps_length1;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp7__length2 = self->priv->pixmaps_length2;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = x;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp9_ = y;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp5_ = _tmp10_ == 0;
#line 1333 "game-view.c"
	}
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp5_) {
#line 1337 "game-view.c"
		gint* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp11__length2 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_ = self->priv->pixmaps;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11__length1 = self->priv->pixmaps_length1;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11__length2 = self->priv->pixmaps_length2;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp12_ = x;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp13_ = y;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp14_ = pixmap;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = _tmp14_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp15_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 1361 "game-view.c"
	} else {
		gint _tmp16_ = 0;
		gint* _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gint _tmp17__length2 = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		guint _tmp29_ = 0U;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp16_ = pixmap;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17_ = self->priv->pixmaps;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17__length1 = self->priv->pixmaps_length1;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17__length2 = self->priv->pixmaps_length2;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp18_ = x;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp19_ = y;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp16_ > _tmp20_) {
#line 1387 "game-view.c"
			gint* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp21__length2 = 0;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21_ = self->priv->pixmaps;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21__length1 = self->priv->pixmaps_length1;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21__length2 = self->priv->pixmaps_length2;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp22_ = x;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp23_ = y;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp24_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp24_ + 1;
#line 1408 "game-view.c"
		} else {
			gint* _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			gint _tmp25__length2 = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp25_ = self->priv->pixmaps;
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp25__length1 = self->priv->pixmaps_length1;
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp25__length2 = self->priv->pixmaps_length2;
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp26_ = x;
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp27_ = y;
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_] = _tmp28_ - 1;
#line 1430 "game-view.c"
		}
#line 243 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp29_ = self->priv->animate_timeout;
#line 243 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp29_ == ((guint) 0)) {
#line 1436 "game-view.c"
			guint _tmp30_ = 0U;
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp30_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GAME_VIEW_PIXMAP_FLIP_DELAY, _game_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			self->priv->animate_timeout = _tmp30_;
#line 1442 "game-view.c"
		}
	}
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp31_ = game_view_get_x_offset (self);
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp32_ = _tmp31_;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp33_ = x;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp34_ = self->priv->tile_size;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp35_ = game_view_get_y_offset (self);
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp36_ = _tmp35_;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp37_ = y;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp38_ = self->priv->tile_size;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp39_ = self->priv->tile_size;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp40_ = self->priv->tile_size;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp32_ + (_tmp33_ * _tmp34_), _tmp36_ + (_tmp37_ * _tmp38_), _tmp39_, _tmp40_);
#line 1467 "game-view.c"
}


static gboolean game_view_animate_cb (GameView* self) {
	gboolean result = FALSE;
	gboolean animating = FALSE;
	gboolean _tmp25_ = FALSE;
#line 249 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 251 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	animating = FALSE;
#line 1479 "game-view.c"
	{
		gint x = 0;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		x = 0;
#line 1484 "game-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp0_ = TRUE;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			while (TRUE) {
#line 1491 "game-view.c"
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				Game* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!_tmp0_) {
#line 1499 "game-view.c"
					gint _tmp1_ = 0;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp1_ = x;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					x = _tmp1_ + 1;
#line 1505 "game-view.c"
				}
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp0_ = FALSE;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp2_ = x;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp3_ = game_view_get_game (self);
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp4_ = _tmp3_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp5_ = game_get_size (_tmp4_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp6_ = _tmp5_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					break;
#line 1523 "game-view.c"
				}
				{
					gint y = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					y = 0;
#line 1529 "game-view.c"
					{
						gboolean _tmp7_ = FALSE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						_tmp7_ = TRUE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						while (TRUE) {
#line 1536 "game-view.c"
							gint _tmp9_ = 0;
							Game* _tmp10_ = NULL;
							Game* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint old = 0;
							gint* _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint* _tmp20_ = NULL;
							gint _tmp20__length1 = 0;
							gint _tmp20__length2 = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (!_tmp7_) {
#line 1560 "game-view.c"
								gint _tmp8_ = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp8_ = y;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								y = _tmp8_ + 1;
#line 1566 "game-view.c"
							}
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp7_ = FALSE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp9_ = y;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp10_ = game_view_get_game (self);
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp11_ = _tmp10_;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp12_ = game_get_size (_tmp11_);
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp13_ = _tmp12_;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								break;
#line 1584 "game-view.c"
							}
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp14_ = self->priv->pixmaps;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp14__length1 = self->priv->pixmaps_length1;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp14__length2 = self->priv->pixmaps_length2;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp15_ = x;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp16_ = y;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							old = _tmp17_;
#line 258 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp18_ = x;
#line 258 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp19_ = y;
#line 258 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							game_view_square_changed_cb (self, _tmp18_, _tmp19_);
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp20_ = self->priv->pixmaps;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp20__length1 = self->priv->pixmaps_length1;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp20__length2 = self->priv->pixmaps_length2;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp21_ = x;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp22_ = y;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp23_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp24_ = old;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (_tmp23_ != _tmp24_) {
#line 260 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								animating = TRUE;
#line 1624 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 264 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp25_ = animating;
#line 264 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (!_tmp25_) {
#line 266 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		self->priv->animate_timeout = (guint) 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		result = G_SOURCE_REMOVE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return result;
#line 1642 "game-view.c"
	}
#line 270 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = G_SOURCE_CONTINUE;
#line 270 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1648 "game-view.c"
}


static gint game_view_get_pixmap (GameView* self, Player color) {
	gint result = 0;
	Player _tmp0_ = 0;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = color;
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	switch (_tmp0_) {
#line 1661 "game-view.c"
		default:
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case PLAYER_NONE:
#line 1665 "game-view.c"
		{
#line 279 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			result = 0;
#line 279 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			return result;
#line 1671 "game-view.c"
		}
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case PLAYER_DARK:
#line 1675 "game-view.c"
		{
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			result = 1;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			return result;
#line 1681 "game-view.c"
		}
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case PLAYER_LIGHT:
#line 1685 "game-view.c"
		{
#line 283 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			result = 31;
#line 283 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			return result;
#line 1691 "game-view.c"
		}
	}
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 287 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 287 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = event;
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = _tmp1_->button;
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp2_ == ((guint) 1)) {
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp0_ = TRUE;
#line 1715 "game-view.c"
	} else {
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp3_ = event;
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp4_ = _tmp3_->button;
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp0_ = _tmp4_ == ((guint) 3);
#line 1725 "game-view.c"
	}
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp0_) {
#line 1729 "game-view.c"
		gint x = 0;
		GdkEventButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint y = 0;
		GdkEventButton* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gint _tmp18_ = 0;
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp5_ = event;
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp6_ = _tmp5_->x;
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp7_ = game_view_get_x_offset (self);
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp9_ = self->priv->tile_size;
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		x = ((gint) (_tmp6_ - _tmp8_)) / _tmp9_;
#line 293 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp10_ = event;
#line 293 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_ = _tmp10_->y;
#line 293 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp12_ = game_view_get_y_offset (self);
#line 293 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 293 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp14_ = self->priv->tile_size;
#line 293 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		y = ((gint) (_tmp11_ - _tmp13_)) / _tmp14_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp18_ = x;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp18_ >= 0) {
#line 1774 "game-view.c"
			gint _tmp19_ = 0;
			Game* _tmp20_ = NULL;
			Game* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp19_ = x;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp20_ = game_view_get_game (self);
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21_ = _tmp20_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp22_ = game_get_size (_tmp21_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp23_ = _tmp22_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp17_ = _tmp19_ < _tmp23_;
#line 1792 "game-view.c"
		} else {
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp17_ = FALSE;
#line 1796 "game-view.c"
		}
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp17_) {
#line 1800 "game-view.c"
			gint _tmp24_ = 0;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp24_ = y;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp16_ = _tmp24_ >= 0;
#line 1806 "game-view.c"
		} else {
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp16_ = FALSE;
#line 1810 "game-view.c"
		}
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp16_) {
#line 1814 "game-view.c"
			gint _tmp25_ = 0;
			Game* _tmp26_ = NULL;
			Game* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp25_ = y;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp26_ = game_view_get_game (self);
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp27_ = _tmp26_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp28_ = game_get_size (_tmp27_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp29_ = _tmp28_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp15_ = _tmp25_ < _tmp29_;
#line 1832 "game-view.c"
		} else {
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp15_ = FALSE;
#line 1836 "game-view.c"
		}
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp15_) {
#line 1840 "game-view.c"
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
#line 295 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp30_ = x;
#line 295 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp31_ = y;
#line 295 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			g_signal_emit_by_name (self, "move", _tmp30_, _tmp31_);
#line 1849 "game-view.c"
		}
	}
#line 298 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = TRUE;
#line 298 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1856 "game-view.c"
}


static gint game_view_get_x_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 21 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 21 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 21 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = self->priv->board_size;
#line 21 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = ((_tmp0_ - _tmp1_) / 2) + GAME_VIEW_GRID_BORDER;
#line 21 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1874 "game-view.c"
}


static gint game_view_get_y_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = self->priv->board_size;
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = ((_tmp0_ - _tmp1_) / 2) + GAME_VIEW_GRID_BORDER;
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1892 "game-view.c"
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
#line 45 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 45 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = _tmp0_;
#line 45 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1907 "game-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 50 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 1914 "game-view.c"
}


static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self) {
#line 54 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	game_view_square_changed_cb ((GameView*) self, x, y);
#line 1921 "game-view.c"
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Game* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
#line 46 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 48 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp0_ != NULL) {
#line 1945 "game-view.c"
		Game* _tmp1_ = NULL;
#line 49 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp1_ = self->priv->_game;
#line 49 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1951 "game-view.c"
	}
#line 50 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = value;
#line 50 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 50 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 50 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->_game = _tmp3_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp4_ = game_view_get_game (self);
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp6_ = game_get_size (_tmp5_);
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp7_ = _tmp6_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp8_ = game_view_get_game (self);
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp9_ = _tmp8_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp10_ = game_get_size (_tmp9_);
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp11_ = _tmp10_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp12_ = g_new0 (gint, _tmp7_ * _tmp11_);
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->pixmaps = _tmp12_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->pixmaps_length1 = _tmp7_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->pixmaps_length2 = _tmp11_;
#line 52 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp13_ = self->priv->_game;
#line 52 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp13_ != NULL) {
#line 1991 "game-view.c"
		Game* _tmp14_ = NULL;
#line 54 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp14_ = self->priv->_game;
#line 54 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_signal_connect_object (_tmp14_, "square-changed", (GCallback) _game_view_square_changed_cb_game_square_changed, self, 0);
#line 1997 "game-view.c"
		{
			gint x = 0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			x = 0;
#line 2002 "game-view.c"
			{
				gboolean _tmp15_ = FALSE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp15_ = TRUE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				while (TRUE) {
#line 2009 "game-view.c"
					gint _tmp17_ = 0;
					Game* _tmp18_ = NULL;
					Game* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					if (!_tmp15_) {
#line 2017 "game-view.c"
						gint _tmp16_ = 0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						_tmp16_ = x;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						x = _tmp16_ + 1;
#line 2023 "game-view.c"
					}
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp15_ = FALSE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp17_ = x;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp18_ = game_view_get_game (self);
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp19_ = _tmp18_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp20_ = game_get_size (_tmp19_);
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp21_ = _tmp20_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					if (!(_tmp17_ < _tmp21_)) {
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						break;
#line 2041 "game-view.c"
					}
					{
						gint y = 0;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						y = 0;
#line 2047 "game-view.c"
						{
							gboolean _tmp22_ = FALSE;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp22_ = TRUE;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							while (TRUE) {
#line 2054 "game-view.c"
								gint _tmp24_ = 0;
								Game* _tmp25_ = NULL;
								Game* _tmp26_ = NULL;
								gint _tmp27_ = 0;
								gint _tmp28_ = 0;
								gint* _tmp29_ = NULL;
								gint _tmp29__length1 = 0;
								gint _tmp29__length2 = 0;
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								Game* _tmp32_ = NULL;
								gint _tmp33_ = 0;
								gint _tmp34_ = 0;
								Player _tmp35_ = 0;
								gint _tmp36_ = 0;
								gint _tmp37_ = 0;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								if (!_tmp22_) {
#line 2073 "game-view.c"
									gint _tmp23_ = 0;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
									_tmp23_ = y;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
									y = _tmp23_ + 1;
#line 2079 "game-view.c"
								}
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp22_ = FALSE;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp24_ = y;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp25_ = game_view_get_game (self);
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp26_ = _tmp25_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp27_ = game_get_size (_tmp26_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp28_ = _tmp27_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								if (!(_tmp24_ < _tmp28_)) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
									break;
#line 2097 "game-view.c"
								}
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp29_ = self->priv->pixmaps;
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp29__length1 = self->priv->pixmaps_length1;
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp29__length2 = self->priv->pixmaps_length2;
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp30_ = x;
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp31_ = y;
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp32_ = self->priv->_game;
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp33_ = x;
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp34_ = y;
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp35_ = game_get_owner (_tmp32_, _tmp33_, _tmp34_);
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp36_ = game_view_get_pixmap (self, _tmp35_);
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_] = _tmp36_;
#line 57 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp37_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 2123 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 59 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 46 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "game");
#line 2135 "game-view.c"
}


const gchar* game_view_get_theme (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 66 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 66 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = _tmp0_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 2150 "game-view.c"
}


void game_view_set_theme (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 67 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 67 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 67 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 67 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 67 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->_theme = _tmp1_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 67 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->tiles_pattern = NULL;
#line 67 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 67 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "theme");
#line 2175 "game-view.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		data1 = closure->data;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		data2 = param_values->data[0].v_pointer;
#line 2194 "game-view.c"
	} else {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		data2 = closure->data;
#line 2200 "game-view.c"
	}
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 2206 "game-view.c"
}


static void game_view_class_init (GameViewClass * klass) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	game_view_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->draw = game_view_real_draw;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = game_view_real_button_press_event;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_signal_new ("move", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 2231 "game-view.c"
}


static void game_view_instance_init (GameView * self) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv = GAME_VIEW_GET_PRIVATE (self);
#line 28 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->render_size = (guint) 0;
#line 29 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->tiles_pattern = NULL;
#line 35 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->animate_timeout = (guint) 0;
#line 40 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->flip_final_result_now = FALSE;
#line 42 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->_game = NULL;
#line 63 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->_theme = NULL;
#line 2250 "game-view.c"
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
#line 29 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 32 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
#line 42 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 63 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
#line 2268 "game-view.c"
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_value_set_object (value, game_view_get_game (self));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_value_set_string (value, game_view_get_theme (self));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 2301 "game-view.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 2307 "game-view.c"
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		game_view_set_game (self, g_value_get_object (value));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		game_view_set_theme (self, g_value_get_string (value));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 2329 "game-view.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 2335 "game-view.c"
	}
}



