/* sudoku-view.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from sudoku-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include "libsudoku.h"
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gee.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_SUDOKU_CELL_VIEW (sudoku_cell_view_get_type ())
#define SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellView))
#define SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))
#define IS_SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL_VIEW))
#define IS_SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL_VIEW))
#define SUDOKU_CELL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))

typedef struct _SudokuCellView SudokuCellView;
typedef struct _SudokuCellViewClass SudokuCellViewClass;
typedef struct _SudokuCellViewPrivate SudokuCellViewPrivate;

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
typedef struct _SudokuViewPrivate SudokuViewPrivate;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

struct _SudokuCellView {
	GtkDrawingArea parent_instance;
	SudokuCellViewPrivate * priv;
};

struct _SudokuCellViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _SudokuCellViewPrivate {
	PangoLayout* layout;
	gdouble size_ratio;
	GtkPopover* popover;
	GtkPopover* earmark_popover;
	SudokuGame* game;
	gint row;
	gint col;
	gboolean _show_possibilities;
	gboolean _show_warnings;
	gboolean _selected;
	GdkRGBA _background_color;
	NumberPicker* number_picker;
	NumberPicker* earmark_picker;
};

struct _Block5Data {
	int _ref_count_;
	SudokuCellView* self;
	gint row;
	gint col;
};

struct _SudokuView {
	GtkAspectFrame parent_instance;
	SudokuViewPrivate * priv;
	SudokuGame* game;
};

struct _SudokuViewClass {
	GtkAspectFrameClass parent_class;
};

struct _SudokuViewPrivate {
	SudokuCellView** cells;
	gint cells_length1;
	gint cells_length2;
	gboolean previous_board_broken_state;
	GtkOverlay* overlay;
	GtkDrawingArea* drawing;
	GtkGrid* grid;
	gint selected_row;
	gint selected_col;
	gboolean _show_warnings;
	gboolean _show_possibilities;
};

struct _Block6Data {
	int _ref_count_;
	SudokuView* self;
	SudokuGame* game;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	gint cell_row;
	gint cell_col;
};


static gpointer sudoku_cell_view_parent_class = NULL;
static gpointer sudoku_view_parent_class = NULL;

GType sudoku_cell_view_get_type (void) G_GNUC_CONST;
GType number_picker_get_type (void) G_GNUC_CONST;
#define SUDOKU_CELL_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewPrivate))
enum  {
	SUDOKU_CELL_VIEW_DUMMY_PROPERTY,
	SUDOKU_CELL_VIEW_VALUE,
	SUDOKU_CELL_VIEW_IS_FIXED,
	SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES,
	SUDOKU_CELL_VIEW_SHOW_WARNINGS,
	SUDOKU_CELL_VIEW_SELECTED,
	SUDOKU_CELL_VIEW_BACKGROUND_COLOR
};
SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game);
SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
void sudoku_cell_view_set_value (SudokuCellView* self, gint value);
gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self);
NumberPicker* number_picker_new (SudokuBoard** board, gboolean earmark);
NumberPicker* number_picker_construct (GType object_type, SudokuBoard** board, gboolean earmark);
static void __lambda7_ (SudokuCellView* self, NumberPicker* o, gint number);
static void ___lambda7__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self);
static gboolean __lambda8_ (SudokuCellView* self);
static gboolean ___lambda8__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void __lambda9_ (Block5Data* _data5_, gint number, gboolean state);
gint sudoku_cell_view_get_value (SudokuCellView* self);
static void ___lambda9__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self);
void number_picker_set_earmarks (NumberPicker* self, gint row, gint col);
static gboolean __lambda10_ (SudokuCellView* self);
static gboolean ___lambda10__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event);
static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val);
static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self);
static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self);
static void sudoku_cell_view_show_number_picker (SudokuCellView* self);
void number_picker_set_clear_button_visibility (NumberPicker* self, gboolean visible);
static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name);
static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
gboolean number_picker_set_earmark (NumberPicker* self, gint row, gint col, gint index, gboolean state);
static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c);
void sudoku_cell_view_clear (SudokuCellView* self);
gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self);
void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self);
void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_selected (SudokuCellView* self);
void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value);
void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result);
void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value);
static void sudoku_cell_view_finalize (GObject* obj);
static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_VIEW, SudokuViewPrivate))
enum  {
	SUDOKU_VIEW_DUMMY_PROPERTY,
	SUDOKU_VIEW_SHOW_WARNINGS,
	SUDOKU_VIEW_SHOW_POSSIBILITIES
};
static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c);
static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ________lambda11_ (Block7Data* _data7_);
static gboolean _________lambda11__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void ________lambda12_ (Block7Data* _data7_, GObject* s, GParamSpec* p);
static void _________lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void sudoku_view_clear (SudokuView* self);
gboolean sudoku_view_get_show_warnings (SudokuView* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
gboolean sudoku_view_get_show_possibilities (SudokuView* self);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void sudoku_view_finalize (GObject* obj);
static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GdkRGBA SUDOKU_VIEW_fixed_cell_color = {0.8, 0.8, 0.8, (gdouble) 0};
static const GdkRGBA SUDOKU_VIEW_free_cell_color = {1.0, 1.0, 1.0, 1.0};
static const GdkRGBA SUDOKU_VIEW_highlight_color = {0.93, 0.93, 0.93, (gdouble) 0};
static const GdkRGBA SUDOKU_VIEW_selected_bg_color = {0.7, 0.8, 0.9};

static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data5_;
#line 248 "sudoku-view.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 257 "sudoku-view.c"
		SudokuCellView* self;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data5_->self;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block5Data, _data5_);
#line 265 "sudoku-view.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 273 "sudoku-view.c"
}


static void __lambda7_ (SudokuCellView* self, NumberPicker* o, gint number) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkPopover* _tmp2_ = NULL;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (o != NULL);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = number;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_value (self, _tmp0_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = number;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_ == 0) {
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 293 "sudoku-view.c"
	}
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->popover;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp2_);
#line 299 "sudoku-view.c"
}


static void ___lambda7__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self) {
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	__lambda7_ ((SudokuCellView*) self, _sender, number);
#line 306 "sudoku-view.c"
}


static gboolean __lambda8_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = TRUE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 321 "sudoku-view.c"
}


static gboolean ___lambda8__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda8_ ((SudokuCellView*) self);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 330 "sudoku-view.c"
}


static void __lambda9_ (Block5Data* _data5_, gint number, gboolean state) {
	SudokuCellView* self;
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data5_->self;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = state;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 350 "sudoku-view.c"
		SudokuGame* _tmp1_ = NULL;
		SudokuBoard* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->game;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = _tmp1_->board;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _data5_->row;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = _data5_->col;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = number;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_board_enable_earmark (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 368 "sudoku-view.c"
	} else {
		SudokuGame* _tmp6_ = NULL;
		SudokuBoard* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = self->priv->game;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->board;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = _data5_->row;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = _data5_->col;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = number;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_board_disable_earmark (_tmp7_, _tmp8_, _tmp9_, _tmp10_);
#line 387 "sudoku-view.c"
	}
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->game;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = _data5_->row;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = _data5_->col;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = sudoku_cell_view_get_value (self);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = _tmp14_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = sudoku_cell_view_get_value (self);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_emit_by_name (_tmp11_, "cell-changed", _tmp12_, _tmp13_, _tmp15_, _tmp17_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 407 "sudoku-view.c"
}


static void ___lambda9__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self) {
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	__lambda9_ (self, number, active);
#line 414 "sudoku-view.c"
}


static gboolean __lambda10_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_popover;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = TRUE;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 429 "sudoku-view.c"
}


static gboolean ___lambda10__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda10_ ((SudokuCellView*) self);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 438 "sudoku-view.c"
}


static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = sudoku_cell_view_focus_out_cb ((SudokuCellView*) self, _sender, event);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 447 "sudoku-view.c"
}


static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_cell_changed_cb ((SudokuCellView*) self, row, col, old_val, new_val);
#line 454 "sudoku-view.c"
}


SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game) {
	SudokuCellView * self = NULL;
	Block5Data* _data5_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuGame* _tmp2_ = NULL;
	SudokuGame* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkStyle* _tmp6_ = NULL;
	GtkStyle* _tmp7_ = NULL;
	PangoFontDescription* _tmp8_ = NULL;
	SudokuGame* _tmp9_ = NULL;
	SudokuBoard* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	SudokuGame* _tmp16_ = NULL;
	NumberPicker* _tmp17_ = NULL;
	NumberPicker* _tmp18_ = NULL;
	GtkPopover* _tmp19_ = NULL;
	GtkPopover* _tmp20_ = NULL;
	NumberPicker* _tmp21_ = NULL;
	GtkPopover* _tmp22_ = NULL;
	GtkPopover* _tmp23_ = NULL;
	GtkPopover* _tmp24_ = NULL;
	SudokuGame* _tmp25_ = NULL;
	NumberPicker* _tmp26_ = NULL;
	NumberPicker* _tmp27_ = NULL;
	NumberPicker* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	GtkPopover* _tmp31_ = NULL;
	GtkPopover* _tmp32_ = NULL;
	NumberPicker* _tmp33_ = NULL;
	GtkPopover* _tmp34_ = NULL;
	GtkPopover* _tmp35_ = NULL;
	GtkPopover* _tmp36_ = NULL;
	SudokuGame* _tmp37_ = NULL;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (*game != NULL, NULL);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->_ref_count_ = 1;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = row;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->row = _tmp0_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = col;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->col = _tmp1_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) g_object_new (object_type, NULL);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->self = g_object_ref (self);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = *game;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->game);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->game = _tmp3_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _data5_->row;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->row = _tmp4_;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _data5_->col;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->col = _tmp5_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = gtk_widget_get_style ((GtkWidget*) self);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp6_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = _tmp7_->font_desc;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	pango_font_description_set_size (_tmp8_, PANGO_SCALE * 13);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = *game;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = _tmp9_->board;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = _data5_->row;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = _data5_->col;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = sudoku_board_get (_tmp10_, _tmp11_, _tmp12_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_value (self, _tmp13_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_KEY_PRESS_MASK);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = sudoku_cell_view_get_is_fixed (self);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = _tmp14_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp15_) {
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		block5_data_unref (_data5_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_data5_ = NULL;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return self;
#line 569 "sudoku-view.c"
	}
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = *game;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = number_picker_new (&_tmp16_->board, FALSE);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp17_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->number_picker);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->number_picker = _tmp17_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = self->priv->number_picker;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp18_, "number-picked", (GCallback) ___lambda7__number_picker_number_picked, self, 0);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp19_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->popover);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->popover = _tmp19_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = self->priv->popover;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp21_ = self->priv->number_picker;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp22_ = self->priv->popover;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_modal (_tmp22_, FALSE);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp23_ = self->priv->popover;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_position (_tmp23_, GTK_POS_BOTTOM);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp24_ = self->priv->popover;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp24_, "focus-out-event", (GCallback) ___lambda8__gtk_widget_focus_out_event, self, 0);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp25_ = *game;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp26_ = number_picker_new (&_tmp25_->board, TRUE);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp26_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_picker);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->earmark_picker = _tmp26_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp27_ = self->priv->earmark_picker;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_data (_tmp27_, "earmark-state-changed", (GCallback) ___lambda9__number_picker_earmark_state_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp28_ = self->priv->earmark_picker;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp29_ = _data5_->row;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp30_ = _data5_->col;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	number_picker_set_earmarks (_tmp28_, _tmp29_, _tmp30_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp31_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp31_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_popover);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->earmark_popover = _tmp31_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp32_ = self->priv->earmark_popover;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp33_ = self->priv->earmark_picker;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp34_ = self->priv->earmark_popover;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_modal (_tmp34_, FALSE);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp35_ = self->priv->earmark_popover;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_position (_tmp35_, GTK_POS_BOTTOM);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp36_ = self->priv->earmark_popover;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp36_, "focus-out-event", (GCallback) ___lambda10__gtk_widget_focus_out_event, self, 0);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event, self, 0);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp37_ = *game;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp37_, "cell-changed", (GCallback) _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed, self, 0);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	block5_data_unref (_data5_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = NULL;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self;
#line 671 "sudoku-view.c"
}


SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return sudoku_cell_view_construct (TYPE_SUDOKU_CELL_VIEW, row, col, game);
#line 678 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GtkPopover* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GdkEventButton* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = event;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->button;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_ != ((guint) 1)) {
#line 709 "sudoku-view.c"
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = event;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = _tmp3_->button;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp4_ != ((guint) 3);
#line 718 "sudoku-view.c"
	} else {
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 722 "sudoku-view.c"
	}
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 730 "sudoku-view.c"
	}
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp5_, NULL);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp6_) {
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_grab_focus ((GtkWidget*) self);
#line 740 "sudoku-view.c"
	}
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = sudoku_cell_view_get_is_fixed (self);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = _tmp8_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp9_) {
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = TRUE;
#line 750 "sudoku-view.c"
	} else {
		SudokuGame* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = self->priv->game;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = sudoku_game_get_paused (_tmp10_);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = _tmp11_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp12_;
#line 763 "sudoku-view.c"
	}
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp7_) {
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 771 "sudoku-view.c"
	}
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = self->priv->popover;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = gtk_widget_get_visible ((GtkWidget*) _tmp14_);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = _tmp15_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp16_) {
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = TRUE;
#line 783 "sudoku-view.c"
	} else {
		GtkPopover* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp17_ = self->priv->earmark_popover;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = gtk_widget_get_visible ((GtkWidget*) _tmp17_);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp19_ = _tmp18_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp19_;
#line 796 "sudoku-view.c"
	}
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp13_) {
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_hide_both_popovers (self);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 806 "sudoku-view.c"
	}
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = event;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp21_ = _tmp20_->button;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp21_ == ((guint) 1)) {
#line 814 "sudoku-view.c"
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = self->priv->_show_possibilities;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (!_tmp23_) {
#line 821 "sudoku-view.c"
			GdkEventButton* _tmp24_ = NULL;
			GdkModifierType _tmp25_ = 0;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp24_ = event;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = _tmp24_->state;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = (_tmp25_ & GDK_CONTROL_MASK) > 0;
#line 830 "sudoku-view.c"
		} else {
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = FALSE;
#line 834 "sudoku-view.c"
		}
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp22_) {
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_earmark_picker (self);
#line 840 "sudoku-view.c"
		} else {
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_number_picker (self);
#line 844 "sudoku-view.c"
		}
	} else {
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp27_ = self->priv->_show_possibilities;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (!_tmp27_) {
#line 853 "sudoku-view.c"
			GdkEventButton* _tmp28_ = NULL;
			guint _tmp29_ = 0U;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = event;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = _tmp28_->button;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp26_ = _tmp29_ == ((guint) 3);
#line 862 "sudoku-view.c"
		} else {
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp26_ = FALSE;
#line 866 "sudoku-view.c"
		}
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp26_) {
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_earmark_picker (self);
#line 872 "sudoku-view.c"
		}
	}
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 879 "sudoku-view.c"
}


static void sudoku_cell_view_show_number_picker (SudokuCellView* self) {
	NumberPicker* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkPopover* _tmp3_ = NULL;
	GtkPopover* _tmp4_ = NULL;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->number_picker;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = sudoku_cell_view_get_value (self);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	number_picker_set_clear_button_visibility (_tmp0_, _tmp2_ != 0);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->earmark_popover;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->popover;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 907 "sudoku-view.c"
}


static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp1_ = NULL;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->earmark_popover;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp1_);
#line 924 "sudoku-view.c"
}


static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp1_ = NULL;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->earmark_popover;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 941 "sudoku-view.c"
}


static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event) {
	gboolean result = FALSE;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_hide_both_popovers (self);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 959 "sudoku-view.c"
}


static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (key_name != NULL, 0);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = key_name;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp1_, "KP_0") == 0) {
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 986 "sudoku-view.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = key_name;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "0") == 0;
#line 993 "sudoku-view.c"
	}
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 0;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1001 "sudoku-view.c"
	}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = key_name;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp3_, "KP_1") == 0) {
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 1;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1011 "sudoku-view.c"
	}
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = key_name;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp4_, "KP_2") == 0) {
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 2;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1021 "sudoku-view.c"
	}
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = key_name;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp5_, "KP_3") == 0) {
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 3;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1031 "sudoku-view.c"
	}
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = key_name;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp6_, "KP_4") == 0) {
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 4;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1041 "sudoku-view.c"
	}
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = key_name;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp7_, "KP_5") == 0) {
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 5;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1051 "sudoku-view.c"
	}
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = key_name;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp8_, "KP_6") == 0) {
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 6;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1061 "sudoku-view.c"
	}
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = key_name;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp9_, "KP_7") == 0) {
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 7;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1071 "sudoku-view.c"
	}
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = key_name;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp10_, "KP_8") == 0) {
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 8;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1081 "sudoku-view.c"
	}
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = key_name;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp11_, "KP_9") == 0) {
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 9;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1091 "sudoku-view.c"
	}
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = -1;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1097 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* k_name = NULL;
	GdkEventKey* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gint k_no = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	gint _tmp46_ = 0;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp54_ = NULL;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = sudoku_cell_view_get_is_fixed (self);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_) {
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 1137 "sudoku-view.c"
	} else {
		SudokuGame* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = self->priv->game;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = sudoku_game_get_paused (_tmp3_);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = _tmp4_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp5_;
#line 1150 "sudoku-view.c"
	}
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1158 "sudoku-view.c"
	}
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = event;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp6_->keyval;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = gdk_keyval_name (_tmp7_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	k_name = _tmp9_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = k_name;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = atoi (_tmp10_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	k_no = _tmp11_;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = k_no;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp12_ == 0) {
#line 1180 "sudoku-view.c"
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = k_name;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp14_ = sudoku_cell_view_key_map_keypad (self, _tmp13_);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		k_no = _tmp14_;
#line 1189 "sudoku-view.c"
	}
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = k_no;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp16_ >= 1) {
#line 1195 "sudoku-view.c"
		gint _tmp17_ = 0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp17_ = k_no;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = _tmp17_ <= 9;
#line 1201 "sudoku-view.c"
	} else {
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = FALSE;
#line 1205 "sudoku-view.c"
	}
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp15_) {
#line 1209 "sudoku-view.c"
		GdkEventKey* _tmp18_ = NULL;
		GdkModifierType _tmp19_ = 0;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = event;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp19_ = _tmp18_->state;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if ((_tmp19_ & GDK_CONTROL_MASK) > 0) {
#line 1218 "sudoku-view.c"
			gboolean new_state = FALSE;
			SudokuGame* _tmp20_ = NULL;
			SudokuBoard* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gboolean _tmp25_ = FALSE;
			NumberPicker* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_ = FALSE;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp20_ = self->priv->game;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = _tmp20_->board;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = self->priv->row;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp23_ = self->priv->col;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp24_ = k_no;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = sudoku_board_is_earmark_enabled (_tmp21_, _tmp22_, _tmp23_, _tmp24_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			new_state = !_tmp25_;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp26_ = self->priv->earmark_picker;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp27_ = self->priv->row;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = self->priv->col;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = k_no;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp30_ = new_state;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp31_ = number_picker_set_earmark (_tmp26_, _tmp27_, _tmp28_, _tmp29_ - 1, _tmp30_);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp31_) {
#line 1260 "sudoku-view.c"
				gboolean _tmp32_ = FALSE;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp32_ = new_state;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp32_) {
#line 1266 "sudoku-view.c"
					SudokuGame* _tmp33_ = NULL;
					SudokuBoard* _tmp34_ = NULL;
					gint _tmp35_ = 0;
					gint _tmp36_ = 0;
					gint _tmp37_ = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp33_ = self->priv->game;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp34_ = _tmp33_->board;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp35_ = self->priv->row;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp36_ = self->priv->col;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp37_ = k_no;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_board_enable_earmark (_tmp34_, _tmp35_, _tmp36_, _tmp37_);
#line 1284 "sudoku-view.c"
				} else {
					SudokuGame* _tmp38_ = NULL;
					SudokuBoard* _tmp39_ = NULL;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					gint _tmp42_ = 0;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp38_ = self->priv->game;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp39_ = _tmp38_->board;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp40_ = self->priv->row;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp41_ = self->priv->col;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp42_ = k_no;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_board_disable_earmark (_tmp39_, _tmp40_, _tmp41_, _tmp42_);
#line 1303 "sudoku-view.c"
				}
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				gtk_widget_queue_draw ((GtkWidget*) self);
#line 1307 "sudoku-view.c"
			}
		} else {
			gint _tmp43_ = 0;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp43_ = k_no;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_set_value (self, _tmp43_);
#line 1315 "sudoku-view.c"
		}
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1323 "sudoku-view.c"
	}
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp46_ = k_no;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp46_ == 0) {
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = TRUE;
#line 1331 "sudoku-view.c"
	} else {
		const gchar* _tmp47_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp47_ = k_name;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = g_strcmp0 (_tmp47_, "BackSpace") == 0;
#line 1338 "sudoku-view.c"
	}
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp45_) {
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp44_ = TRUE;
#line 1344 "sudoku-view.c"
	} else {
		const gchar* _tmp48_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp48_ = k_name;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp44_ = g_strcmp0 (_tmp48_, "Delete") == 0;
#line 1351 "sudoku-view.c"
	}
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp44_) {
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, 0);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1365 "sudoku-view.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp51_ = k_name;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp51_, "space") == 0) {
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp50_ = TRUE;
#line 1373 "sudoku-view.c"
	} else {
		const gchar* _tmp52_ = NULL;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp52_ = k_name;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp50_ = g_strcmp0 (_tmp52_, "Return") == 0;
#line 1380 "sudoku-view.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp50_) {
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp49_ = TRUE;
#line 1386 "sudoku-view.c"
	} else {
		const gchar* _tmp53_ = NULL;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp53_ = k_name;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp49_ = g_strcmp0 (_tmp53_, "KP_Enter") == 0;
#line 1393 "sudoku-view.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp49_) {
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_show_number_picker (self);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1405 "sudoku-view.c"
	}
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp54_ = k_name;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp54_, "Escape") == 0) {
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_hide_both_popovers (self);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1419 "sudoku-view.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_free0 (k_name);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1427 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gint glyph_width = 0;
	gint glyph_height = 0;
	PangoLayout* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	SudokuGame* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp110_ = FALSE;
	gboolean _tmp111_ = FALSE;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->layout;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	pango_layout_get_pixel_size (_tmp0_, &_tmp1_, &_tmp2_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	glyph_width = _tmp1_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	glyph_height = _tmp2_;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->_show_warnings;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp4_) {
#line 1467 "sudoku-view.c"
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		Coord _tmp10_ = {0};
		gboolean _tmp11_ = FALSE;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = self->priv->game;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = _tmp5_->board;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->broken_coords;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->row;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->col;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		coord_init (&_tmp10_, _tmp8_, _tmp9_);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = gee_collection_contains ((GeeCollection*) _tmp7_, &_tmp10_);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _tmp11_;
#line 1491 "sudoku-view.c"
	} else {
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = FALSE;
#line 1495 "sudoku-view.c"
	}
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp3_) {
#line 1499 "sudoku-view.c"
		cairo_t* _tmp12_ = NULL;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = c;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp12_, 1.0, 0.0, 0.0);
#line 1505 "sudoku-view.c"
	} else {
		gboolean _tmp13_ = FALSE;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = self->priv->_selected;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp13_) {
#line 1512 "sudoku-view.c"
			cairo_t* _tmp14_ = NULL;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp14_ = c;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp14_, 0.2, 0.2, 0.2);
#line 1518 "sudoku-view.c"
		} else {
			cairo_t* _tmp15_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp15_ = c;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp15_, 0.0, 0.0, 0.0);
#line 1525 "sudoku-view.c"
		}
	}
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = self->priv->game;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = sudoku_game_get_paused (_tmp16_);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = _tmp17_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp18_) {
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1540 "sudoku-view.c"
	}
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = sudoku_cell_view_get_value (self);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = _tmp19_;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp20_ != 0) {
#line 1548 "sudoku-view.c"
		gint width = 0;
		gint height = 0;
		PangoLayout* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gdouble scale = 0.0;
		gint _tmp25_ = 0;
		gdouble _tmp26_ = 0.0;
		gint _tmp27_ = 0;
		cairo_t* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gdouble _tmp31_ = 0.0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gdouble _tmp34_ = 0.0;
		cairo_t* _tmp35_ = NULL;
		cairo_t* _tmp36_ = NULL;
		gdouble _tmp37_ = 0.0;
		gdouble _tmp38_ = 0.0;
		cairo_t* _tmp39_ = NULL;
		PangoLayout* _tmp40_ = NULL;
		cairo_t* _tmp41_ = NULL;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp21_ = self->priv->layout;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_get_size (_tmp21_, &_tmp22_, &_tmp23_);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		width = _tmp22_;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		height = _tmp23_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp24_ = height;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		height = _tmp24_ / PANGO_SCALE;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp25_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp26_ = self->priv->size_ratio;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp27_ = height;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		scale = (((gdouble) _tmp25_) / _tmp26_) / _tmp27_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp28_ = c;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp29_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp30_ = glyph_width;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp31_ = scale;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp32_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp33_ = glyph_height;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp34_ = scale;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp28_, (_tmp29_ - (_tmp30_ * _tmp31_)) / 2, (_tmp32_ - (_tmp33_ * _tmp34_)) / 2);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp35_ = c;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_save (_tmp35_);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp36_ = c;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp37_ = scale;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp38_ = scale;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_scale (_tmp36_, _tmp37_, _tmp38_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp39_ = c;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp40_ = self->priv->layout;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_cairo_show_layout (_tmp39_, _tmp40_);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp41_ = c;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_restore (_tmp41_);
#line 1631 "sudoku-view.c"
	}
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp42_ = sudoku_cell_view_get_is_fixed (self);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp43_ = _tmp42_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp43_) {
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1643 "sudoku-view.c"
	}
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp44_ = self->priv->_show_possibilities;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp44_) {
#line 1649 "sudoku-view.c"
		gdouble earmark_size = 0.0;
		gint _tmp45_ = 0;
		gdouble _tmp46_ = 0.0;
		cairo_t* _tmp47_ = NULL;
		gdouble _tmp48_ = 0.0;
		cairo_t* _tmp49_ = NULL;
		gdouble _tmp50_ = 0.0;
		cairo_t* _tmp51_ = NULL;
		cairo_t* _tmp52_ = NULL;
		SudokuGame* _tmp53_ = NULL;
		SudokuBoard* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp46_ = self->priv->size_ratio;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		earmark_size = _tmp45_ / (_tmp46_ * 2);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp47_ = c;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp48_ = earmark_size;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp47_, _tmp48_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp49_ = c;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp50_ = earmark_size;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp49_, (gdouble) 0, _tmp50_);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp51_ = c;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp51_, 0.0, 0.0, 0.0);
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp52_ = c;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp53_ = self->priv->game;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp54_ = _tmp53_->board;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp55_ = self->priv->row;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp56_ = self->priv->col;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp57_ = sudoku_board_get_earmarks_string (_tmp54_, _tmp55_, _tmp56_);
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp58_ = _tmp57_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp52_, _tmp58_);
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (_tmp58_);
#line 1705 "sudoku-view.c"
	} else {
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp59_ = sudoku_cell_view_get_value (self);
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp60_ = _tmp59_;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp60_ == 0) {
#line 1715 "sudoku-view.c"
			gdouble possibility_size = 0.0;
			gint _tmp61_ = 0;
			gdouble _tmp62_ = 0.0;
			cairo_t* _tmp63_ = NULL;
			gdouble _tmp64_ = 0.0;
			cairo_t* _tmp65_ = NULL;
			gboolean* possibilities = NULL;
			SudokuGame* _tmp66_ = NULL;
			SudokuBoard* _tmp67_ = NULL;
			gint _tmp68_ = 0;
			gint _tmp69_ = 0;
			gint _tmp70_ = 0;
			gboolean* _tmp71_ = NULL;
			gint possibilities_length1 = 0;
			gint _possibilities_size_ = 0;
			gint height = 0;
			gint _tmp72_ = 0;
			SudokuGame* _tmp73_ = NULL;
			SudokuBoard* _tmp74_ = NULL;
			gint _tmp75_ = 0;
			gint _tmp76_ = 0;
			gint width = 0;
			gint _tmp77_ = 0;
			SudokuGame* _tmp78_ = NULL;
			SudokuBoard* _tmp79_ = NULL;
			gint _tmp80_ = 0;
			gint _tmp81_ = 0;
			gint num = 0;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp61_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp62_ = self->priv->size_ratio;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibility_size = _tmp61_ / (_tmp62_ * 2);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp63_ = c;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp64_ = possibility_size;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_font_size (_tmp63_, _tmp64_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp65_ = c;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp65_, 0.0, 0.0, 0.0);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp66_ = self->priv->game;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp67_ = _tmp66_->board;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp68_ = self->priv->row;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp69_ = self->priv->col;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp71_ = sudoku_board_get_possibilities_as_bool_array (_tmp67_, _tmp68_, _tmp69_, &_tmp70_);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities = _tmp71_;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities_length1 = _tmp70_;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_possibilities_size_ = possibilities_length1;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp72_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp73_ = self->priv->game;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp74_ = _tmp73_->board;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp75_ = sudoku_board_get_block_cols (_tmp74_);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp76_ = _tmp75_;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			height = _tmp72_ / _tmp76_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp77_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp78_ = self->priv->game;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp79_ = _tmp78_->board;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp80_ = sudoku_board_get_block_rows (_tmp79_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp81_ = _tmp80_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			width = _tmp77_ / _tmp81_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			num = 0;
#line 1802 "sudoku-view.c"
			{
				gint row_tmp = 0;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				row_tmp = 0;
#line 1807 "sudoku-view.c"
				{
					gboolean _tmp82_ = FALSE;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp82_ = TRUE;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					while (TRUE) {
#line 1814 "sudoku-view.c"
						gint _tmp84_ = 0;
						SudokuGame* _tmp85_ = NULL;
						SudokuBoard* _tmp86_ = NULL;
						gint _tmp87_ = 0;
						gint _tmp88_ = 0;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						if (!_tmp82_) {
#line 1822 "sudoku-view.c"
							gint _tmp83_ = 0;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp83_ = row_tmp;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							row_tmp = _tmp83_ + 1;
#line 1828 "sudoku-view.c"
						}
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp82_ = FALSE;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp84_ = row_tmp;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp85_ = self->priv->game;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp86_ = _tmp85_->board;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp87_ = sudoku_board_get_block_rows (_tmp86_);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp88_ = _tmp87_;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						if (!(_tmp84_ < _tmp88_)) {
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							break;
#line 1846 "sudoku-view.c"
						}
						{
							gint col_tmp = 0;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							col_tmp = 0;
#line 1852 "sudoku-view.c"
							{
								gboolean _tmp89_ = FALSE;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp89_ = TRUE;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								while (TRUE) {
#line 1859 "sudoku-view.c"
									gint _tmp91_ = 0;
									SudokuGame* _tmp92_ = NULL;
									SudokuBoard* _tmp93_ = NULL;
									gint _tmp94_ = 0;
									gint _tmp95_ = 0;
									gint _tmp96_ = 0;
									gboolean* _tmp97_ = NULL;
									gint _tmp97__length1 = 0;
									gint _tmp98_ = 0;
									gboolean _tmp99_ = FALSE;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (!_tmp89_) {
#line 1872 "sudoku-view.c"
										gint _tmp90_ = 0;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp90_ = col_tmp;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										col_tmp = _tmp90_ + 1;
#line 1878 "sudoku-view.c"
									}
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp89_ = FALSE;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp91_ = col_tmp;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp92_ = self->priv->game;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp93_ = _tmp92_->board;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp94_ = sudoku_board_get_block_cols (_tmp93_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp95_ = _tmp94_;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (!(_tmp91_ < _tmp95_)) {
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										break;
#line 1896 "sudoku-view.c"
									}
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp96_ = num;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									num = _tmp96_ + 1;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp97_ = possibilities;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp97__length1 = possibilities_length1;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp98_ = num;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp99_ = _tmp97_[_tmp98_ - 1];
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (_tmp99_) {
#line 1912 "sudoku-view.c"
										cairo_t* _tmp100_ = NULL;
										gint _tmp101_ = 0;
										gint _tmp102_ = 0;
										gint _tmp103_ = 0;
										gint _tmp104_ = 0;
										gdouble _tmp105_ = 0.0;
										cairo_t* _tmp106_ = NULL;
										gint _tmp107_ = 0;
										gchar* _tmp108_ = NULL;
										gchar* _tmp109_ = NULL;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp100_ = c;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp101_ = col_tmp;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp102_ = width;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp103_ = row_tmp;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp104_ = height;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp105_ = possibility_size;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										cairo_move_to (_tmp100_, (gdouble) (_tmp101_ * _tmp102_), (_tmp103_ * _tmp104_) + _tmp105_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp106_ = c;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp107_ = num;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp108_ = g_strdup_printf ("%d", _tmp107_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp109_ = _tmp108_;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										cairo_show_text (_tmp106_, _tmp109_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_g_free0 (_tmp109_);
#line 1949 "sudoku-view.c"
									}
								}
							}
						}
					}
				}
			}
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities = (g_free (possibilities), NULL);
#line 1959 "sudoku-view.c"
		}
	}
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp111_ = self->priv->_show_warnings;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp111_) {
#line 1966 "sudoku-view.c"
		gboolean _tmp112_ = FALSE;
		gint _tmp113_ = 0;
		gint _tmp114_ = 0;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp113_ = sudoku_cell_view_get_value (self);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp114_ = _tmp113_;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp114_ == 0) {
#line 1976 "sudoku-view.c"
			SudokuGame* _tmp115_ = NULL;
			SudokuBoard* _tmp116_ = NULL;
			gint _tmp117_ = 0;
			gint _tmp118_ = 0;
			gint _tmp119_ = 0;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp115_ = self->priv->game;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp116_ = _tmp115_->board;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp117_ = self->priv->row;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp118_ = self->priv->col;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp119_ = sudoku_board_count_possibilities (_tmp116_, _tmp117_, _tmp118_);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp112_ = _tmp119_ == 0;
#line 1994 "sudoku-view.c"
		} else {
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp112_ = FALSE;
#line 1998 "sudoku-view.c"
		}
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp110_ = _tmp112_;
#line 2002 "sudoku-view.c"
	} else {
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp110_ = FALSE;
#line 2006 "sudoku-view.c"
	}
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp110_) {
#line 2010 "sudoku-view.c"
		gchar* warning = NULL;
		gchar* _tmp120_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp121_ = NULL;
		gint _tmp122_ = 0;
		cairo_t* _tmp123_ = NULL;
		const gchar* _tmp124_ = NULL;
		cairo_text_extents_t _tmp125_ = {0};
		cairo_t* _tmp126_ = NULL;
		gint _tmp127_ = 0;
		cairo_text_extents_t _tmp128_ = {0};
		gdouble _tmp129_ = 0.0;
		gint _tmp130_ = 0;
		cairo_text_extents_t _tmp131_ = {0};
		gdouble _tmp132_ = 0.0;
		cairo_t* _tmp133_ = NULL;
		cairo_t* _tmp134_ = NULL;
		const gchar* _tmp135_ = NULL;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp120_ = g_strdup ("X");
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		warning = _tmp120_;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp121_ = c;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp122_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp121_, (gdouble) (_tmp122_ / 2));
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp123_ = c;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp124_ = warning;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_text_extents (_tmp123_, _tmp124_, &_tmp125_);
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		extents = _tmp125_;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp126_ = c;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp127_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp128_ = extents;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp129_ = _tmp128_.width;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp130_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp131_ = extents;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp132_ = _tmp131_.height;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp126_, ((_tmp127_ - _tmp129_) / 2) - 1, ((_tmp130_ + _tmp132_) / 2) + 1);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp133_ = c;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp133_, 1.0, 0.0, 0.0);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp134_ = c;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp135_ = warning;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp134_, _tmp135_);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (warning);
#line 2075 "sudoku-view.c"
	}
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2081 "sudoku-view.c"
}


void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = row;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_ == _tmp2_) {
#line 2097 "sudoku-view.c"
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = col;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->col;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 2106 "sudoku-view.c"
	} else {
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 2110 "sudoku-view.c"
	}
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 2114 "sudoku-view.c"
		gint _tmp5_ = 0;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = new_val;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, _tmp5_);
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 2122 "sudoku-view.c"
	}
}


void sudoku_cell_view_clear (SudokuCellView* self) {
	NumberPicker* _tmp0_ = NULL;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_picker;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 2135 "sudoku-view.c"
		{
			gint i = 0;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			i = 0;
#line 2140 "sudoku-view.c"
			{
				gboolean _tmp1_ = FALSE;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = TRUE;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				while (TRUE) {
#line 2147 "sudoku-view.c"
					gint _tmp3_ = 0;
					SudokuGame* _tmp4_ = NULL;
					SudokuBoard* _tmp5_ = NULL;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					NumberPicker* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					if (!_tmp1_) {
#line 2159 "sudoku-view.c"
						gint _tmp2_ = 0;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp2_ = i;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						i = _tmp2_ + 1;
#line 2165 "sudoku-view.c"
					}
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp1_ = FALSE;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp3_ = i;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp4_ = self->priv->game;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp5_ = _tmp4_->board;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp6_ = sudoku_board_get_max_val (_tmp5_);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp7_ = _tmp6_;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					if (!(_tmp3_ < _tmp7_)) {
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						break;
#line 2183 "sudoku-view.c"
					}
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp8_ = self->priv->earmark_picker;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = self->priv->row;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp10_ = self->priv->col;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp11_ = i;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					number_picker_set_earmark (_tmp8_, _tmp9_, _tmp10_, _tmp11_, FALSE);
#line 2195 "sudoku-view.c"
				}
			}
		}
	}
}


gint sudoku_cell_view_get_value (SudokuCellView* self) {
	gint result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->col;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = sudoku_board_get (_tmp1_, _tmp2_, _tmp3_);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp4_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2226 "sudoku-view.c"
}


void sudoku_cell_view_set_value (SudokuCellView* self, gint value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp14_ = 0;
	gint _tmp30_ = 0;
	SudokuGame* _tmp31_ = NULL;
	SudokuBoard* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	SudokuGame* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 2252 "sudoku-view.c"
		gchar* text = NULL;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		PangoLayout* _tmp9_ = NULL;
		PangoLayout* _tmp10_ = NULL;
		GtkStyle* _tmp11_ = NULL;
		GtkStyle* _tmp12_ = NULL;
		PangoFontDescription* _tmp13_ = NULL;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = self->priv->game;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _tmp2_->board;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->row;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = self->priv->col;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = sudoku_board_get (_tmp3_, _tmp4_, _tmp5_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp7_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = text;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp8_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp9_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = self->priv->layout;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = gtk_widget_get_style ((GtkWidget*) self);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = _tmp11_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp12_->font_desc;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp10_, _tmp13_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2302 "sudoku-view.c"
	}
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = value;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp14_ == 0) {
#line 2308 "sudoku-view.c"
		gchar* text = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		PangoLayout* _tmp17_ = NULL;
		PangoLayout* _tmp18_ = NULL;
		GtkStyle* _tmp19_ = NULL;
		GtkStyle* _tmp20_ = NULL;
		PangoFontDescription* _tmp21_ = NULL;
		SudokuGame* _tmp22_ = NULL;
		SudokuBoard* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = g_strdup ("");
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp15_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = text;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp17_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp16_);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp17_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = self->priv->layout;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp19_ = gtk_widget_get_style ((GtkWidget*) self);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp20_ = _tmp19_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp21_ = _tmp20_->font_desc;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp18_, _tmp21_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp22_ = self->priv->game;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = _tmp22_->board;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp24_ = self->priv->row;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp25_ = self->priv->col;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp26_ = sudoku_board_get (_tmp23_, _tmp24_, _tmp25_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp26_ != 0) {
#line 2356 "sudoku-view.c"
			SudokuGame* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp27_ = self->priv->game;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = self->priv->row;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = self->priv->col;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_game_remove (_tmp27_, _tmp28_, _tmp29_);
#line 2368 "sudoku-view.c"
		}
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2374 "sudoku-view.c"
	}
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp30_ = value;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp31_ = self->priv->game;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp32_ = _tmp31_->board;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp33_ = self->priv->row;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp34_ = self->priv->col;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp35_ = sudoku_board_get (_tmp32_, _tmp33_, _tmp34_);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp30_ == _tmp35_) {
#line 2390 "sudoku-view.c"
		gchar* text = NULL;
		gint _tmp36_ = 0;
		gchar* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		PangoLayout* _tmp39_ = NULL;
		PangoLayout* _tmp40_ = NULL;
		GtkStyle* _tmp41_ = NULL;
		GtkStyle* _tmp42_ = NULL;
		PangoFontDescription* _tmp43_ = NULL;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp36_ = value;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp37_ = g_strdup_printf ("%d", _tmp36_);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp37_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp38_ = text;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp39_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp38_);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp39_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp40_ = self->priv->layout;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp41_ = gtk_widget_get_style ((GtkWidget*) self);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = _tmp41_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp43_ = _tmp42_->font_desc;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp40_, _tmp43_);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2428 "sudoku-view.c"
	}
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp44_ = self->priv->game;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp45_ = self->priv->row;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp46_ = self->priv->col;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp47_ = value;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_game_insert (_tmp44_, _tmp45_, _tmp46_, _tmp47_);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "value");
#line 2442 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self) {
	gboolean result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gboolean* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->is_fixed;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2__length1 = _tmp1_->is_fixed_length1;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2__length2 = _tmp1_->is_fixed_length2;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->row;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->col;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _tmp2_[(_tmp3_ * _tmp2__length2) + _tmp4_];
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp5_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2478 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_possibilities;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2493 "sudoku-view.c"
}


void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = _tmp0_;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-possibilities");
#line 2509 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_warnings;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2524 "sudoku-view.c"
}


void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = _tmp0_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-warnings");
#line 2540 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_selected (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_selected;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2555 "sudoku-view.c"
}


void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_selected = _tmp0_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "selected");
#line 2569 "sudoku-view.c"
}


void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_background_color;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	*result = _tmp0_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return;
#line 2583 "sudoku-view.c"
}


void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value) {
	GdkRGBA _tmp0_ = {0};
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = *value;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_background_color = _tmp0_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "background-color");
#line 2597 "sudoku-view.c"
}


static void sudoku_cell_view_class_init (SudokuCellViewClass * klass) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_type_class_add_private (klass, sizeof (SudokuCellViewPrivate));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = sudoku_cell_view_real_button_press_event;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->key_press_event = sudoku_cell_view_real_key_press_event;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->draw = sudoku_cell_view_real_draw;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_view_get_property;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_view_set_property;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_view_finalize;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_VALUE, g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_IS_FIXED, g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_BACKGROUND_COLOR, g_param_spec_boxed ("background-color", "background-color", "background-color", gdk_rgba_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2630 "sudoku-view.c"
}


static void sudoku_cell_view_instance_init (SudokuCellView * self) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv = SUDOKU_CELL_VIEW_GET_PRIVATE (self);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->size_ratio = (gdouble) 2;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = TRUE;
#line 2641 "sudoku-view.c"
}


static void sudoku_cell_view_finalize (GObject* obj) {
	SudokuCellView * self;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->layout);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->popover);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_popover);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->game);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->number_picker);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_picker);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (sudoku_cell_view_parent_class)->finalize (obj);
#line 2663 "sudoku-view.c"
}


GType sudoku_cell_view_get_type (void) {
	static volatile gsize sudoku_cell_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_cell_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuCellViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCellView), 0, (GInstanceInitFunc) sudoku_cell_view_instance_init, NULL };
		GType sudoku_cell_view_type_id;
		sudoku_cell_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "SudokuCellView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_cell_view_type_id__volatile, sudoku_cell_view_type_id);
	}
	return sudoku_cell_view_type_id__volatile;
}


static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_VALUE:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_int (value, sudoku_cell_view_get_value (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_IS_FIXED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_is_fixed (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_show_possibilities (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_show_warnings (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SELECTED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_selected (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
#line 2716 "sudoku-view.c"
		{
			GdkRGBA boxed;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_get_background_color (self, &boxed);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			g_value_set_boxed (value, &boxed);
#line 2723 "sudoku-view.c"
		}
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2727 "sudoku-view.c"
		default:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2733 "sudoku-view.c"
	}
}


static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_VALUE:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, g_value_get_int (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_show_possibilities (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_show_warnings (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SELECTED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_selected (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_background_color (self, g_value_get_boxed (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2773 "sudoku-view.c"
		default:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2779 "sudoku-view.c"
	}
}


static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col) {
	SudokuCellView** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuCellView* _tmp3_ = NULL;
	SudokuCellView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuCellView* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	SudokuCellView** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	SudokuCellView* _tmp13_ = NULL;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->cells;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0__length1 = self->priv->cells_length1;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0__length2 = self->priv->cells_length2;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->selected_row;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->selected_col;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_selected (_tmp3_, FALSE);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->cells;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4__length1 = self->priv->cells_length1;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4__length2 = self->priv->cells_length2;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->selected_row;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->selected_col;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = cell_row;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_row = _tmp8_;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = cell_col;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_col = _tmp9_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = self->priv->cells;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10__length1 = self->priv->cells_length1;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10__length2 = self->priv->cells_length2;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->selected_row;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->selected_col;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_selected (_tmp13_, TRUE);
#line 2857 "sudoku-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data6_;
#line 2866 "sudoku-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 2875 "sudoku-view.c"
		SudokuView* self;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data6_->self;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (_data6_->game);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 2885 "sudoku-view.c"
	}
}


static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = sudoku_view_draw_board ((SudokuView*) self, cr);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2895 "sudoku-view.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data7_;
#line 2904 "sudoku-view.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 2913 "sudoku-view.c"
		SudokuView* self;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data7_->_data6_->self;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		block6_data_unref (_data7_->_data6_);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_data7_->_data6_ = NULL;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block7Data, _data7_);
#line 2923 "sudoku-view.c"
	}
}


static gboolean ________lambda11_ (Block7Data* _data7_) {
	Block6Data* _data6_;
	SudokuView* self;
	gboolean result = FALSE;
	SudokuGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	SudokuCellView** _tmp91_ = NULL;
	gint _tmp91__length1 = 0;
	gint _tmp91__length2 = 0;
	gint _tmp92_ = 0;
	gint _tmp93_ = 0;
	SudokuCellView* _tmp94_ = NULL;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = _data7_->_data6_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data6_->self;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = _data6_->game;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_) {
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 2959 "sudoku-view.c"
	}
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _data7_->cell_row;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _data7_->cell_col;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_view_set_selected (self, _tmp3_, _tmp4_);
#line 2967 "sudoku-view.c"
	{
		gint col_tmp = 0;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		col_tmp = 0;
#line 2972 "sudoku-view.c"
		{
			gboolean _tmp5_ = FALSE;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp5_ = TRUE;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 2979 "sudoku-view.c"
				gint _tmp7_ = 0;
				SudokuGame* _tmp8_ = NULL;
				SudokuBoard* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				GdkRGBA _tmp12_ = {0};
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				GdkRGBA color = {0};
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp5_) {
#line 2991 "sudoku-view.c"
					gint _tmp6_ = 0;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp6_ = col_tmp;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col_tmp = _tmp6_ + 1;
#line 2997 "sudoku-view.c"
				}
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = FALSE;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = col_tmp;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp8_ = _data6_->game;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp9_ = _tmp8_->board;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp10_ = sudoku_board_get_cols (_tmp9_);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = _tmp10_;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp7_ < _tmp11_)) {
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3015 "sudoku-view.c"
				}
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp13_ = col_tmp;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp14_ = _data7_->cell_col;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp13_ == _tmp14_) {
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = SUDOKU_VIEW_highlight_color;
#line 3025 "sudoku-view.c"
				} else {
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = SUDOKU_VIEW_free_cell_color;
#line 3029 "sudoku-view.c"
				}
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				color = _tmp12_;
#line 3033 "sudoku-view.c"
				{
					gint row_tmp = 0;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					row_tmp = 0;
#line 3038 "sudoku-view.c"
					{
						gboolean _tmp15_ = FALSE;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp15_ = TRUE;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 3045 "sudoku-view.c"
							gint _tmp17_ = 0;
							SudokuGame* _tmp18_ = NULL;
							SudokuBoard* _tmp19_ = NULL;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							GdkRGBA _tmp22_ = {0};
							SudokuCellView** _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp23__length2 = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							SudokuCellView* _tmp26_ = NULL;
							gboolean _tmp27_ = FALSE;
							gboolean _tmp28_ = FALSE;
							SudokuCellView** _tmp30_ = NULL;
							gint _tmp30__length1 = 0;
							gint _tmp30__length2 = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							SudokuCellView* _tmp33_ = NULL;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp15_) {
#line 3068 "sudoku-view.c"
								gint _tmp16_ = 0;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp16_ = row_tmp;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								row_tmp = _tmp16_ + 1;
#line 3074 "sudoku-view.c"
							}
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = FALSE;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = row_tmp;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _data6_->game;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = _tmp18_->board;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp20_ = sudoku_board_get_rows (_tmp19_);
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp21_ = _tmp20_;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp17_ < _tmp21_)) {
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 3092 "sudoku-view.c"
							}
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp23_ = self->priv->cells;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp23__length1 = self->priv->cells_length1;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp23__length2 = self->priv->cells_length2;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp24_ = row_tmp;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25_ = col_tmp;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_];
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp27_ = sudoku_cell_view_get_is_fixed (_tmp26_);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp28_ = _tmp27_;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (_tmp28_) {
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp22_ = SUDOKU_VIEW_fixed_cell_color;
#line 3114 "sudoku-view.c"
							} else {
								GdkRGBA _tmp29_ = {0};
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp29_ = color;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp22_ = _tmp29_;
#line 3121 "sudoku-view.c"
							}
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp30_ = self->priv->cells;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp30__length1 = self->priv->cells_length1;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp30__length2 = self->priv->cells_length2;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp31_ = row_tmp;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = col_tmp;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp33_ = _tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_];
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_background_color (_tmp33_, &_tmp22_);
#line 3137 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
	{
		gint col_tmp = 0;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		col_tmp = 0;
#line 3148 "sudoku-view.c"
		{
			gboolean _tmp34_ = FALSE;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp34_ = TRUE;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 3155 "sudoku-view.c"
				gint _tmp36_ = 0;
				SudokuGame* _tmp37_ = NULL;
				SudokuBoard* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				GdkRGBA _tmp41_ = {0};
				SudokuCellView** _tmp42_ = NULL;
				gint _tmp42__length1 = 0;
				gint _tmp42__length2 = 0;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				SudokuCellView* _tmp45_ = NULL;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_ = FALSE;
				SudokuCellView** _tmp48_ = NULL;
				gint _tmp48__length1 = 0;
				gint _tmp48__length2 = 0;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				SudokuCellView* _tmp51_ = NULL;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp34_) {
#line 3178 "sudoku-view.c"
					gint _tmp35_ = 0;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp35_ = col_tmp;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col_tmp = _tmp35_ + 1;
#line 3184 "sudoku-view.c"
				}
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp34_ = FALSE;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp36_ = col_tmp;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp37_ = _data6_->game;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp38_ = _tmp37_->board;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp39_ = sudoku_board_get_cols (_tmp38_);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp40_ = _tmp39_;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp36_ < _tmp40_)) {
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3202 "sudoku-view.c"
				}
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp42_ = self->priv->cells;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp42__length1 = self->priv->cells_length1;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp42__length2 = self->priv->cells_length2;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp43_ = _data7_->cell_row;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp44_ = col_tmp;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp45_ = _tmp42_[(_tmp43_ * _tmp42__length2) + _tmp44_];
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp46_ = sudoku_cell_view_get_is_fixed (_tmp45_);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp47_ = _tmp46_;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp47_) {
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp41_ = SUDOKU_VIEW_fixed_cell_color;
#line 3224 "sudoku-view.c"
				} else {
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp41_ = SUDOKU_VIEW_highlight_color;
#line 3228 "sudoku-view.c"
				}
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp48_ = self->priv->cells;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp48__length1 = self->priv->cells_length1;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp48__length2 = self->priv->cells_length2;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp49_ = _data7_->cell_row;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp50_ = col_tmp;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp51_ = _tmp48_[(_tmp49_ * _tmp48__length2) + _tmp50_];
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_set_background_color (_tmp51_, &_tmp41_);
#line 3244 "sudoku-view.c"
			}
		}
	}
	{
		GeeList* _coord_list = NULL;
		SudokuGame* _tmp52_ = NULL;
		SudokuBoard* _tmp53_ = NULL;
		GeeMap* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		SudokuGame* _tmp56_ = NULL;
		SudokuBoard* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		SudokuGame* _tmp61_ = NULL;
		SudokuBoard* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		Coord _tmp65_ = {0};
		gpointer _tmp66_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		gint _coord_index = 0;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp52_ = _data6_->game;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp53_ = _tmp52_->board;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp54_ = _tmp53_->coords_for_block;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp55_ = _data7_->cell_row;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp56_ = _data6_->game;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp57_ = _tmp56_->board;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp58_ = sudoku_board_get_block_rows (_tmp57_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp59_ = _tmp58_;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp60_ = _data7_->cell_col;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp61_ = _data6_->game;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp62_ = _tmp61_->board;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp63_ = sudoku_board_get_block_cols (_tmp62_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp64_ = _tmp63_;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		coord_init (&_tmp65_, _tmp55_ / _tmp59_, _tmp60_ / _tmp64_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp66_ = gee_map_get (_tmp54_, &_tmp65_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_list = (GeeList*) _tmp66_;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp67_ = _coord_list;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp68_ = gee_collection_get_size ((GeeCollection*) _tmp67_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp69_ = _tmp68_;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_size = _tmp69_;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_index = -1;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		while (TRUE) {
#line 3314 "sudoku-view.c"
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			gint _tmp72_ = 0;
			Coord* coord = NULL;
			GeeList* _tmp73_ = NULL;
			gint _tmp74_ = 0;
			gpointer _tmp75_ = NULL;
			GdkRGBA _tmp76_ = {0};
			SudokuCellView** _tmp77_ = NULL;
			gint _tmp77__length1 = 0;
			gint _tmp77__length2 = 0;
			Coord* _tmp78_ = NULL;
			gint _tmp79_ = 0;
			Coord* _tmp80_ = NULL;
			gint _tmp81_ = 0;
			SudokuCellView* _tmp82_ = NULL;
			gboolean _tmp83_ = FALSE;
			gboolean _tmp84_ = FALSE;
			SudokuCellView** _tmp85_ = NULL;
			gint _tmp85__length1 = 0;
			gint _tmp85__length2 = 0;
			Coord* _tmp86_ = NULL;
			gint _tmp87_ = 0;
			Coord* _tmp88_ = NULL;
			gint _tmp89_ = 0;
			SudokuCellView* _tmp90_ = NULL;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp70_ = _coord_index;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_coord_index = _tmp70_ + 1;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp71_ = _coord_index;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp72_ = _coord_size;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (!(_tmp71_ < _tmp72_)) {
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				break;
#line 3353 "sudoku-view.c"
			}
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp73_ = _coord_list;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp74_ = _coord_index;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp75_ = gee_list_get (_tmp73_, _tmp74_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			coord = (Coord*) _tmp75_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp77_ = self->priv->cells;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp77__length1 = self->priv->cells_length1;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp77__length2 = self->priv->cells_length2;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp78_ = coord;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp79_ = (*_tmp78_).row;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp80_ = coord;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp81_ = (*_tmp80_).col;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp82_ = _tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_];
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp83_ = sudoku_cell_view_get_is_fixed (_tmp82_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp84_ = _tmp83_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp84_) {
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp76_ = SUDOKU_VIEW_fixed_cell_color;
#line 3387 "sudoku-view.c"
			} else {
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp76_ = SUDOKU_VIEW_highlight_color;
#line 3391 "sudoku-view.c"
			}
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp85_ = self->priv->cells;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp85__length1 = self->priv->cells_length1;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp85__length2 = self->priv->cells_length2;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp86_ = coord;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp87_ = (*_tmp86_).row;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp88_ = coord;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp89_ = (*_tmp88_).col;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp90_ = _tmp85_[(_tmp87_ * _tmp85__length2) + _tmp89_];
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_set_background_color (_tmp90_, &_tmp76_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (coord);
#line 3413 "sudoku-view.c"
		}
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (_coord_list);
#line 3417 "sudoku-view.c"
	}
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp91_ = self->priv->cells;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp91__length1 = self->priv->cells_length1;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp91__length2 = self->priv->cells_length2;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp92_ = _data7_->cell_row;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp93_ = _data7_->cell_col;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp94_ = _tmp91_[(_tmp92_ * _tmp91__length2) + _tmp93_];
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_background_color (_tmp94_, &SUDOKU_VIEW_selected_bg_color);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3439 "sudoku-view.c"
}


static gboolean _________lambda11__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = ________lambda11_ (self);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3448 "sudoku-view.c"
}


static void ________lambda12_ (Block7Data* _data7_, GObject* s, GParamSpec* p) {
	Block6Data* _data6_;
	SudokuView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = _data7_->_data6_;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data6_->self;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (s != NULL);
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (p != NULL);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->_show_possibilities;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp3_) {
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = TRUE;
#line 3473 "sudoku-view.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->_show_warnings;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = _tmp4_;
#line 3480 "sudoku-view.c"
	}
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_) {
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = TRUE;
#line 3486 "sudoku-view.c"
	} else {
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = _data6_->game;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = _tmp5_->board;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = sudoku_board_get_broken (_tmp6_);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = _tmp7_;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = _tmp8_;
#line 3502 "sudoku-view.c"
	}
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 3508 "sudoku-view.c"
	} else {
		gboolean _tmp9_ = FALSE;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->previous_board_broken_state;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp9_;
#line 3515 "sudoku-view.c"
	}
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 3519 "sudoku-view.c"
		SudokuGame* _tmp10_ = NULL;
		SudokuBoard* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = _data6_->game;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = _tmp10_->board;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = sudoku_board_get_broken (_tmp11_);
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp12_;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->previous_board_broken_state = _tmp13_;
#line 3534 "sudoku-view.c"
	}
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 3538 "sudoku-view.c"
}


static void _________lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	________lambda12_ (self, _sender, pspec);
#line 3545 "sudoku-view.c"
}


SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game) {
	SudokuView * self = NULL;
	Block6Data* _data6_;
	SudokuGame* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	GtkOverlay* _tmp2_ = NULL;
	GtkOverlay* _tmp3_ = NULL;
	GtkDrawingArea* _tmp4_ = NULL;
	GtkDrawingArea* _tmp5_ = NULL;
	GtkGrid* _tmp6_ = NULL;
	SudokuGame* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkGrid* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	SudokuBoard* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	SudokuGame* _tmp20_ = NULL;
	SudokuBoard* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	SudokuCellView** _tmp24_ = NULL;
	GtkOverlay* _tmp61_ = NULL;
	GtkDrawingArea* _tmp62_ = NULL;
	GtkOverlay* _tmp63_ = NULL;
	GtkGrid* _tmp64_ = NULL;
	GtkDrawingArea* _tmp65_ = NULL;
	GtkGrid* _tmp66_ = NULL;
	GtkOverlay* _tmp67_ = NULL;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_->_ref_count_ = 1;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = game;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (_data6_->game);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_->game = _tmp1_;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuView*) g_object_new (object_type, NULL);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_->self = g_object_ref (self);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_frame_set_shadow_type ((GtkFrame*) self, GTK_SHADOW_NONE);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkAspectFrame*) self, "obey-child", FALSE, NULL);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkAspectFrame*) self, "ratio", (gfloat) 1, NULL);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = (GtkOverlay*) gtk_overlay_new ();
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp2_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->overlay);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->overlay = _tmp2_;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->overlay;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = (GtkDrawingArea*) gtk_drawing_area_new ();
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp4_);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->drawing);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->drawing = _tmp4_;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->drawing;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp5_, "draw", (GCallback) _sudoku_view_draw_board_gtk_widget_draw, self, 0);
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->grid;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp6_ != NULL) {
#line 3634 "sudoku-view.c"
		GtkOverlay* _tmp7_ = NULL;
		GtkGrid* _tmp8_ = NULL;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = self->priv->overlay;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->grid;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_container_remove ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
#line 3643 "sudoku-view.c"
	}
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = _data6_->game;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->game);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->game = _tmp10_;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp11_);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->grid);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->grid = _tmp11_;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->grid;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_row_spacing (_tmp12_, 1);
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = self->priv->grid;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_column_spacing (_tmp13_, 1);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = self->priv->grid;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_column_homogeneous (_tmp14_, TRUE);
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = self->priv->grid;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_row_homogeneous (_tmp15_, TRUE);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = _data6_->game;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_->board;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = sudoku_board_get_rows (_tmp17_);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = _tmp18_;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = _data6_->game;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp21_ = _tmp20_->board;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp22_ = sudoku_board_get_cols (_tmp21_);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp23_ = _tmp22_;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp24_ = g_new0 (SudokuCellView*, (_tmp19_ * _tmp23_) + 1);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = _tmp24_;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells_length1 = _tmp19_;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells_length2 = _tmp23_;
#line 3703 "sudoku-view.c"
	{
		gint row = 0;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		row = 0;
#line 3708 "sudoku-view.c"
		{
			gboolean _tmp25_ = FALSE;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = TRUE;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 3715 "sudoku-view.c"
				gint _tmp27_ = 0;
				SudokuGame* _tmp28_ = NULL;
				SudokuBoard* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp25_) {
#line 3723 "sudoku-view.c"
					gint _tmp26_ = 0;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp26_ = row;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					row = _tmp26_ + 1;
#line 3729 "sudoku-view.c"
				}
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp25_ = FALSE;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp27_ = row;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp28_ = _data6_->game;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp29_ = _tmp28_->board;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp30_ = sudoku_board_get_rows (_tmp29_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp31_ = _tmp30_;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp27_ < _tmp31_)) {
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3747 "sudoku-view.c"
				}
				{
					gint col = 0;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col = 0;
#line 3753 "sudoku-view.c"
					{
						gboolean _tmp32_ = FALSE;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp32_ = TRUE;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 3760 "sudoku-view.c"
							Block7Data* _data7_;
							gint _tmp34_ = 0;
							SudokuGame* _tmp35_ = NULL;
							SudokuBoard* _tmp36_ = NULL;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							SudokuCellView* cell = NULL;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							SudokuCellView* _tmp41_ = NULL;
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							GdkRGBA _tmp44_ = {0};
							SudokuCellView* _tmp45_ = NULL;
							gboolean _tmp46_ = FALSE;
							gboolean _tmp47_ = FALSE;
							SudokuCellView* _tmp48_ = NULL;
							SudokuCellView* _tmp49_ = NULL;
							SudokuCellView* _tmp50_ = NULL;
							SudokuCellView** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp51__length2 = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							SudokuCellView* _tmp54_ = NULL;
							SudokuCellView* _tmp55_ = NULL;
							SudokuCellView* _tmp56_ = NULL;
							GtkGrid* _tmp57_ = NULL;
							SudokuCellView* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_ = g_slice_new0 (Block7Data);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->_ref_count_ = 1;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->_data6_ = block6_data_ref (_data6_);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp32_) {
#line 3800 "sudoku-view.c"
								gint _tmp33_ = 0;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp33_ = col;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								col = _tmp33_ + 1;
#line 3806 "sudoku-view.c"
							}
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = FALSE;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = col;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _data6_->game;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp36_ = _tmp35_->board;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp37_ = sudoku_board_get_cols (_tmp36_);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp38_ = _tmp37_;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp34_ < _tmp38_)) {
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								block7_data_unref (_data7_);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_data7_ = NULL;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 3828 "sudoku-view.c"
							}
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp39_ = row;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp40_ = col;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp41_ = sudoku_cell_view_new (_tmp39_, _tmp40_, &self->game);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_object_ref_sink (_tmp41_);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cell = _tmp41_;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp42_ = row;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->cell_row = _tmp42_;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp43_ = col;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->cell_col = _tmp43_;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp45_ = cell;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp46_ = sudoku_cell_view_get_is_fixed (_tmp45_);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp47_ = _tmp46_;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (_tmp47_) {
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp44_ = SUDOKU_VIEW_fixed_cell_color;
#line 3858 "sudoku-view.c"
							} else {
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp44_ = SUDOKU_VIEW_free_cell_color;
#line 3862 "sudoku-view.c"
							}
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp48_ = cell;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_background_color (_tmp48_, &_tmp44_);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp49_ = cell;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_signal_connect_data ((GtkWidget*) _tmp49_, "focus-in-event", (GCallback) _________lambda11__gtk_widget_focus_in_event, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp50_ = cell;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_signal_connect_data ((GObject*) _tmp50_, "notify::value", (GCallback) _________lambda12__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51_ = self->priv->cells;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51__length1 = self->priv->cells_length1;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51__length2 = self->priv->cells_length2;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp52_ = row;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp53_ = col;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp54_ = cell;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp55_ = _g_object_ref0 (_tmp54_);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_g_object_unref0 (_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_]);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_] = _tmp55_;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp56_ = _tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_];
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp57_ = self->priv->grid;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp58_ = cell;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp59_ = col;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp60_ = row;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							gtk_grid_attach (_tmp57_, (GtkWidget*) _tmp58_, _tmp59_, _tmp60_, 1, 1);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_g_object_unref0 (cell);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							block7_data_unref (_data7_);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_ = NULL;
#line 3912 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp61_ = self->priv->overlay;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp62_ = self->priv->drawing;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp61_, (GtkWidget*) _tmp62_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp63_ = self->priv->overlay;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp64_ = self->priv->grid;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_overlay_add_overlay (_tmp63_, (GtkWidget*) _tmp64_);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp65_ = self->priv->drawing;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp65_);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp66_ = self->priv->grid;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp66_);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp67_ = self->priv->overlay;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp67_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	block6_data_unref (_data6_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = NULL;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self;
#line 3949 "sudoku-view.c"
}


SudokuView* sudoku_view_new (SudokuGame* game) {
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return sudoku_view_construct (TYPE_SUDOKU_VIEW, game);
#line 3956 "sudoku-view.c"
}


static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c) {
	gboolean result = FALSE;
	gint board_length = 0;
	GtkGrid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble tile_length = 0.0;
	gint _tmp2_ = 0;
	SudokuGame* _tmp3_ = NULL;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GtkTextDirection _tmp7_ = 0;
	cairo_t* _tmp48_ = NULL;
	cairo_t* _tmp49_ = NULL;
	cairo_t* _tmp88_ = NULL;
	cairo_t* _tmp89_ = NULL;
	cairo_t* _tmp126_ = NULL;
	SudokuGame* _tmp127_ = NULL;
	gboolean _tmp128_ = FALSE;
	gboolean _tmp129_ = FALSE;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->grid;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	board_length = _tmp1_;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = board_length;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->game;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _tmp3_->board;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = sudoku_board_get_cols (_tmp4_);
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	tile_length = ((gdouble) (_tmp2_ - 1)) / _tmp6_;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = gtk_widget_get_default_direction ();
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp7_ == GTK_TEXT_DIR_RTL) {
#line 4006 "sudoku-view.c"
		cairo_t* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		cairo_t* _tmp10_ = NULL;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = c;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = board_length;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_translate (_tmp8_, (gdouble) _tmp9_, (gdouble) 0);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = c;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_scale (_tmp10_, (gdouble) (-1), (gdouble) 1);
#line 4020 "sudoku-view.c"
	}
	{
		gint i = 0;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4026 "sudoku-view.c"
		{
			gboolean _tmp11_ = FALSE;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp11_ = TRUE;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4033 "sudoku-view.c"
				gint _tmp13_ = 0;
				SudokuGame* _tmp14_ = NULL;
				SudokuBoard* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp11_) {
#line 4041 "sudoku-view.c"
					gint _tmp12_ = 0;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = i;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp12_ + 1;
#line 4047 "sudoku-view.c"
				}
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = FALSE;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp13_ = i;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp14_ = self->game;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp15_ = _tmp14_->board;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp16_ = sudoku_board_get_cols (_tmp15_);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp17_ = _tmp16_;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp13_ < _tmp17_)) {
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4065 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4071 "sudoku-view.c"
					{
						gboolean _tmp18_ = FALSE;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp18_ = TRUE;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4078 "sudoku-view.c"
							gint _tmp20_ = 0;
							SudokuGame* _tmp21_ = NULL;
							SudokuBoard* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							GdkRGBA background_color = {0};
							SudokuCellView** _tmp25_ = NULL;
							gint _tmp25__length1 = 0;
							gint _tmp25__length2 = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							SudokuCellView* _tmp28_ = NULL;
							GdkRGBA _tmp29_ = {0};
							GdkRGBA _tmp30_ = {0};
							cairo_t* _tmp31_ = NULL;
							GdkRGBA _tmp32_ = {0};
							gdouble _tmp33_ = 0.0;
							GdkRGBA _tmp34_ = {0};
							gdouble _tmp35_ = 0.0;
							GdkRGBA _tmp36_ = {0};
							gdouble _tmp37_ = 0.0;
							cairo_t* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							gdouble _tmp40_ = 0.0;
							gint _tmp41_ = 0;
							gdouble _tmp42_ = 0.0;
							gint _tmp43_ = 0;
							gdouble _tmp44_ = 0.0;
							gint _tmp45_ = 0;
							gdouble _tmp46_ = 0.0;
							cairo_t* _tmp47_ = NULL;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp18_) {
#line 4112 "sudoku-view.c"
								gint _tmp19_ = 0;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp19_ = j;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp19_ + 1;
#line 4118 "sudoku-view.c"
							}
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = FALSE;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp20_ = j;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp21_ = self->game;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22_ = _tmp21_->board;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp23_ = sudoku_board_get_cols (_tmp22_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp24_ = _tmp23_;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp20_ < _tmp24_)) {
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4136 "sudoku-view.c"
							}
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25_ = self->priv->cells;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length1 = self->priv->cells_length1;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length2 = self->priv->cells_length2;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp26_ = i;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp27_ = j;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_get_background_color (_tmp28_, &_tmp29_);
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp30_ = _tmp29_;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							background_color = _tmp30_;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp31_ = c;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = background_color;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp33_ = _tmp32_.red;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = background_color;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _tmp34_.green;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp36_ = background_color;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp37_ = _tmp36_.blue;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_set_source_rgb (_tmp31_, _tmp33_, _tmp35_, _tmp37_);
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp38_ = c;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp39_ = j;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp40_ = tile_length;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp41_ = i;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp42_ = tile_length;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp43_ = j;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp44_ = tile_length;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp45_ = i;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp46_ = tile_length;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_rectangle (_tmp38_, ((gint) (_tmp39_ * _tmp40_)) + 0.5, ((gint) (_tmp41_ * _tmp42_)) + 0.5, ((gint) ((_tmp43_ + 1) * _tmp44_)) + 0.5, ((gint) ((_tmp45_ + 1) * _tmp46_)) + 0.5);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp47_ = c;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_fill (_tmp47_);
#line 4196 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp48_ = c;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_line_width (_tmp48_, (gdouble) 1);
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp49_ = c;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_source_rgb (_tmp49_, 0.6, 0.6, 0.6);
#line 4211 "sudoku-view.c"
	{
		gint i = 0;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 1;
#line 4216 "sudoku-view.c"
		{
			gboolean _tmp50_ = FALSE;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp50_ = TRUE;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4223 "sudoku-view.c"
				gint _tmp52_ = 0;
				SudokuGame* _tmp53_ = NULL;
				SudokuBoard* _tmp54_ = NULL;
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				SudokuGame* _tmp58_ = NULL;
				SudokuBoard* _tmp59_ = NULL;
				gint _tmp60_ = 0;
				gint _tmp61_ = 0;
				cairo_t* _tmp62_ = NULL;
				gint _tmp63_ = 0;
				gdouble _tmp64_ = 0.0;
				cairo_t* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gdouble _tmp67_ = 0.0;
				gint _tmp68_ = 0;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp50_) {
#line 4243 "sudoku-view.c"
					gint _tmp51_ = 0;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp51_ = i;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp51_ + 1;
#line 4249 "sudoku-view.c"
				}
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp50_ = FALSE;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp52_ = i;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp53_ = self->game;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp54_ = _tmp53_->board;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp55_ = sudoku_board_get_cols (_tmp54_);
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp56_ = _tmp55_;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp52_ < _tmp56_)) {
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4267 "sudoku-view.c"
				}
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp57_ = i;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp58_ = self->game;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp59_ = _tmp58_->board;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp60_ = sudoku_board_get_block_cols (_tmp59_);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp61_ = _tmp60_;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if ((_tmp57_ % _tmp61_) == 0) {
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					continue;
#line 4283 "sudoku-view.c"
				}
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp62_ = c;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp63_ = i;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp64_ = tile_length;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp62_, ((gint) (_tmp63_ * _tmp64_)) + 0.5, (gdouble) 1);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp65_ = c;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp66_ = i;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp67_ = tile_length;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp68_ = board_length;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp65_, ((gint) (_tmp66_ * _tmp67_)) + 0.5, (gdouble) _tmp68_);
#line 4303 "sudoku-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 1;
#line 4311 "sudoku-view.c"
		{
			gboolean _tmp69_ = FALSE;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp69_ = TRUE;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4318 "sudoku-view.c"
				gint _tmp71_ = 0;
				SudokuGame* _tmp72_ = NULL;
				SudokuBoard* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				SudokuGame* _tmp77_ = NULL;
				SudokuBoard* _tmp78_ = NULL;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				cairo_t* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gdouble _tmp83_ = 0.0;
				cairo_t* _tmp84_ = NULL;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				gdouble _tmp87_ = 0.0;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp69_) {
#line 4338 "sudoku-view.c"
					gint _tmp70_ = 0;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp70_ = i;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp70_ + 1;
#line 4344 "sudoku-view.c"
				}
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp69_ = FALSE;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp71_ = i;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp72_ = self->game;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp73_ = _tmp72_->board;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp74_ = sudoku_board_get_cols (_tmp73_);
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp75_ = _tmp74_;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp71_ < _tmp75_)) {
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4362 "sudoku-view.c"
				}
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp76_ = i;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp77_ = self->game;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp78_ = _tmp77_->board;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp79_ = sudoku_board_get_block_rows (_tmp78_);
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp80_ = _tmp79_;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if ((_tmp76_ % _tmp80_) == 0) {
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					continue;
#line 4378 "sudoku-view.c"
				}
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp81_ = c;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp82_ = i;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp83_ = tile_length;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp81_, (gdouble) 1, ((gint) (_tmp82_ * _tmp83_)) + 0.5);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp84_ = c;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp85_ = board_length;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp86_ = i;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp87_ = tile_length;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp84_, (gdouble) _tmp85_, ((gint) (_tmp86_ * _tmp87_)) + 0.5);
#line 4398 "sudoku-view.c"
			}
		}
	}
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp88_ = c;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_stroke (_tmp88_);
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp89_ = c;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_source_rgb (_tmp89_, 0.0, 0.0, 0.0);
#line 4410 "sudoku-view.c"
	{
		gint i = 0;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4415 "sudoku-view.c"
		{
			gboolean _tmp90_ = FALSE;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp90_ = TRUE;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4422 "sudoku-view.c"
				gint _tmp96_ = 0;
				SudokuGame* _tmp97_ = NULL;
				SudokuBoard* _tmp98_ = NULL;
				gint _tmp99_ = 0;
				gint _tmp100_ = 0;
				cairo_t* _tmp101_ = NULL;
				gint _tmp102_ = 0;
				gdouble _tmp103_ = 0.0;
				cairo_t* _tmp104_ = NULL;
				gint _tmp105_ = 0;
				gdouble _tmp106_ = 0.0;
				gint _tmp107_ = 0;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp90_) {
#line 4437 "sudoku-view.c"
					gint _tmp91_ = 0;
					SudokuGame* _tmp92_ = NULL;
					SudokuBoard* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					gint _tmp95_ = 0;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp91_ = i;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp92_ = self->game;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp93_ = _tmp92_->board;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp94_ = sudoku_board_get_block_cols (_tmp93_);
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp95_ = _tmp94_;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp91_ + _tmp95_;
#line 4455 "sudoku-view.c"
				}
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp90_ = FALSE;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp96_ = i;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp97_ = self->game;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp98_ = _tmp97_->board;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp99_ = sudoku_board_get_cols (_tmp98_);
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp100_ = _tmp99_;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp96_ <= _tmp100_)) {
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4473 "sudoku-view.c"
				}
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp101_ = c;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp102_ = i;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp103_ = tile_length;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp101_, ((gint) (_tmp102_ * _tmp103_)) + 0.5, (gdouble) 0);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp104_ = c;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp105_ = i;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp106_ = tile_length;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp107_ = board_length;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp104_, ((gint) (_tmp105_ * _tmp106_)) + 0.5, (gdouble) _tmp107_);
#line 4493 "sudoku-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4501 "sudoku-view.c"
		{
			gboolean _tmp108_ = FALSE;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp108_ = TRUE;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4508 "sudoku-view.c"
				gint _tmp114_ = 0;
				SudokuGame* _tmp115_ = NULL;
				SudokuBoard* _tmp116_ = NULL;
				gint _tmp117_ = 0;
				gint _tmp118_ = 0;
				cairo_t* _tmp119_ = NULL;
				gint _tmp120_ = 0;
				gdouble _tmp121_ = 0.0;
				cairo_t* _tmp122_ = NULL;
				gint _tmp123_ = 0;
				gint _tmp124_ = 0;
				gdouble _tmp125_ = 0.0;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp108_) {
#line 4523 "sudoku-view.c"
					gint _tmp109_ = 0;
					SudokuGame* _tmp110_ = NULL;
					SudokuBoard* _tmp111_ = NULL;
					gint _tmp112_ = 0;
					gint _tmp113_ = 0;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp109_ = i;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp110_ = self->game;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp111_ = _tmp110_->board;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp112_ = sudoku_board_get_block_rows (_tmp111_);
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp113_ = _tmp112_;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp109_ + _tmp113_;
#line 4541 "sudoku-view.c"
				}
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp108_ = FALSE;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp114_ = i;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp115_ = self->game;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp116_ = _tmp115_->board;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp117_ = sudoku_board_get_cols (_tmp116_);
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp118_ = _tmp117_;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp114_ <= _tmp118_)) {
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4559 "sudoku-view.c"
				}
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp119_ = c;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp120_ = i;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp121_ = tile_length;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp119_, (gdouble) 0, ((gint) (_tmp120_ * _tmp121_)) + 0.5);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp122_ = c;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp123_ = board_length;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp124_ = i;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp125_ = tile_length;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp122_, (gdouble) _tmp123_, ((gint) (_tmp124_ * _tmp125_)) + 0.5);
#line 4579 "sudoku-view.c"
			}
		}
	}
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp126_ = c;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_stroke (_tmp126_);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp127_ = self->game;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp128_ = sudoku_game_get_paused (_tmp127_);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp129_ = _tmp128_;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp129_) {
#line 4595 "sudoku-view.c"
		cairo_t* _tmp130_ = NULL;
		cairo_t* _tmp131_ = NULL;
		cairo_t* _tmp132_ = NULL;
		cairo_t* _tmp133_ = NULL;
		gint _tmp134_ = 0;
		gchar* text = NULL;
		const gchar* _tmp135_ = NULL;
		gchar* _tmp136_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp137_ = NULL;
		const gchar* _tmp138_ = NULL;
		cairo_text_extents_t _tmp139_ = {0};
		cairo_t* _tmp140_ = NULL;
		gint _tmp141_ = 0;
		cairo_text_extents_t _tmp142_ = {0};
		gdouble _tmp143_ = 0.0;
		gint _tmp144_ = 0;
		cairo_text_extents_t _tmp145_ = {0};
		gdouble _tmp146_ = 0.0;
		cairo_t* _tmp147_ = NULL;
		cairo_t* _tmp148_ = NULL;
		const gchar* _tmp149_ = NULL;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp130_ = c;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgba (_tmp130_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp131_ = c;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_paint (_tmp131_);
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp132_ = c;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_select_font_face (_tmp132_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp133_ = c;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp134_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp133_, _tmp134_ * 0.125);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp135_ = _ ("Paused");
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp136_ = g_strdup (_tmp135_);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp136_;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp137_ = c;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp138_ = text;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_text_extents (_tmp137_, _tmp138_, &_tmp139_);
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		extents = _tmp139_;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp140_ = c;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp141_ = board_length;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp142_ = extents;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp143_ = _tmp142_.width;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp144_ = board_length;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp145_ = extents;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp146_ = _tmp145_.height;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp140_, (_tmp141_ / 2.0) - (_tmp143_ / 2.0), (_tmp144_ / 2.0) + (_tmp146_ / 2.0));
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp147_ = c;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp147_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp148_ = c;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp149_ = text;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp148_, _tmp149_);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 4678 "sudoku-view.c"
	}
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 4684 "sudoku-view.c"
}


void sudoku_view_clear (SudokuView* self) {
#line 571 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 4691 "sudoku-view.c"
	{
		gint i = 0;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4696 "sudoku-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp0_ = TRUE;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4703 "sudoku-view.c"
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp0_) {
#line 4711 "sudoku-view.c"
					gint _tmp1_ = 0;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp1_ = i;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp1_ + 1;
#line 4717 "sudoku-view.c"
				}
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp0_ = FALSE;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp2_ = i;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = self->game;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = _tmp3_->board;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = _tmp5_;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4735 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4741 "sudoku-view.c"
					{
						gboolean _tmp7_ = FALSE;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp7_ = TRUE;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4748 "sudoku-view.c"
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuCellView** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							SudokuCellView* _tmp17_ = NULL;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp7_) {
#line 4762 "sudoku-view.c"
								gint _tmp8_ = 0;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp8_ = j;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp8_ + 1;
#line 4768 "sudoku-view.c"
							}
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp7_ = FALSE;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp9_ = j;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = self->game;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = _tmp10_->board;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = _tmp12_;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4786 "sudoku-view.c"
							}
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = self->priv->cells;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14__length1 = self->priv->cells_length1;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14__length2 = self->priv->cells_length2;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = i;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = j;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_clear (_tmp17_);
#line 4802 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
}


gboolean sudoku_view_get_show_warnings (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_warnings;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 4823 "sudoku-view.c"
}


void sudoku_view_set_show_warnings (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = _tmp0_;
#line 4835 "sudoku-view.c"
	{
		gint i = 0;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4840 "sudoku-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp1_ = TRUE;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4847 "sudoku-view.c"
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp1_) {
#line 4855 "sudoku-view.c"
					gint _tmp2_ = 0;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp2_ = i;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp2_ + 1;
#line 4861 "sudoku-view.c"
				}
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = FALSE;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = i;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = self->game;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _tmp4_->board;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = _tmp6_;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp3_ < _tmp7_)) {
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4879 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4885 "sudoku-view.c"
					{
						gboolean _tmp8_ = FALSE;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp8_ = TRUE;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4892 "sudoku-view.c"
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp8_) {
#line 4907 "sudoku-view.c"
								gint _tmp9_ = 0;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp9_ = j;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp9_ + 1;
#line 4913 "sudoku-view.c"
							}
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp8_ = FALSE;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = j;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = self->game;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = _tmp11_->board;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = _tmp13_;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp10_ < _tmp14_)) {
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4931 "sudoku-view.c"
							}
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = self->priv->cells;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length1 = self->priv->cells_length1;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length2 = self->priv->cells_length2;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = i;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = j;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = self->priv->_show_warnings;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_show_warnings (_tmp18_, _tmp19_);
#line 4949 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-warnings");
#line 4958 "sudoku-view.c"
}


gboolean sudoku_view_get_show_possibilities (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_possibilities;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 4973 "sudoku-view.c"
}


void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = _tmp0_;
#line 4985 "sudoku-view.c"
	{
		gint i = 0;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4990 "sudoku-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp1_ = TRUE;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4997 "sudoku-view.c"
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp1_) {
#line 5005 "sudoku-view.c"
					gint _tmp2_ = 0;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp2_ = i;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp2_ + 1;
#line 5011 "sudoku-view.c"
				}
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = FALSE;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = i;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = self->game;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _tmp4_->board;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = _tmp6_;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp3_ < _tmp7_)) {
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 5029 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 5035 "sudoku-view.c"
					{
						gboolean _tmp8_ = FALSE;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp8_ = TRUE;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 5042 "sudoku-view.c"
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp8_) {
#line 5057 "sudoku-view.c"
								gint _tmp9_ = 0;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp9_ = j;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp9_ + 1;
#line 5063 "sudoku-view.c"
							}
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp8_ = FALSE;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = j;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = self->game;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = _tmp11_->board;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = _tmp13_;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp10_ < _tmp14_)) {
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 5081 "sudoku-view.c"
							}
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = self->priv->cells;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length1 = self->priv->cells_length1;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length2 = self->priv->cells_length2;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = i;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = j;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = value;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_show_possibilities (_tmp18_, _tmp19_);
#line 5099 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-possibilities");
#line 5108 "sudoku-view.c"
}


static void sudoku_view_class_init (SudokuViewClass * klass) {
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_view_parent_class = g_type_class_peek_parent (klass);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_type_class_add_private (klass, sizeof (SudokuViewPrivate));
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_view_get_property;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_view_set_property;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_view_finalize;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5127 "sudoku-view.c"
}


static void sudoku_view_instance_init (SudokuView * self) {
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv = SUDOKU_VIEW_GET_PRIVATE (self);
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->previous_board_broken_state = FALSE;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_row = 0;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_col = 0;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = FALSE;
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = FALSE;
#line 5144 "sudoku-view.c"
}


static void sudoku_view_finalize (GObject* obj) {
	SudokuView * self;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_VIEW, SudokuView);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->game);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->overlay);
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->drawing);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->grid);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (sudoku_view_parent_class)->finalize (obj);
#line 5164 "sudoku-view.c"
}


GType sudoku_view_get_type (void) {
	static volatile gsize sudoku_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuView), 0, (GInstanceInitFunc) sudoku_view_instance_init, NULL };
		GType sudoku_view_type_id;
		sudoku_view_type_id = g_type_register_static (gtk_aspect_frame_get_type (), "SudokuView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_view_type_id__volatile, sudoku_view_type_id);
	}
	return sudoku_view_type_id__volatile;
}


static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_WARNINGS:
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_show_warnings (self));
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_show_possibilities (self));
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5197 "sudoku-view.c"
		default:
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5203 "sudoku-view.c"
	}
}


static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_WARNINGS:
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_show_warnings (self, g_value_get_boolean (value));
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_show_possibilities (self, g_value_get_boolean (value));
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5225 "sudoku-view.c"
		default:
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5231 "sudoku-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



