/* sudoku-printer.c generated by valac 0.25.3.3-7022, the Vala compiler
 * generated from sudoku-printer.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include "libsudoku.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
typedef struct _SudokuPrinterPrivate SudokuPrinterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_GAME_PRINTER (game_printer_get_type ())
#define GAME_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_PRINTER, GamePrinter))
#define GAME_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_PRINTER, GamePrinterClass))
#define IS_GAME_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_PRINTER))
#define IS_GAME_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_PRINTER))
#define GAME_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_PRINTER, GamePrinterClass))

typedef struct _GamePrinter GamePrinter;
typedef struct _GamePrinterClass GamePrinterClass;
typedef struct _GamePrinterPrivate GamePrinterPrivate;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

struct _SudokuPrinter {
	GObject parent_instance;
	SudokuPrinterPrivate * priv;
};

struct _SudokuPrinterClass {
	GObjectClass parent_class;
};

struct _SudokuPrinterPrivate {
	SudokuBoard** boards;
	gint boards_length1;
	gint _boards_size_;
	GtkWindow* window;
	gint margin;
	gint n_sudokus;
	GtkPrintOperation* print_op;
};

struct _GamePrinter {
	GObject parent_instance;
	GamePrinterPrivate * priv;
};

struct _GamePrinterClass {
	GObjectClass parent_class;
};

struct _GamePrinterPrivate {
	SudokuSaver* saver;
	GtkApplicationWindow* window;
	GSettings* settings;
	GtkDialog* dialog;
	GtkSpinButton* nsudokus_button;
	GtkRadioButton* easy_button;
	GtkRadioButton* medium_button;
	GtkRadioButton* hard_button;
	GtkRadioButton* very_hard_button;
	GtkSpinner* spinner;
};

struct _Block9Data {
	int _ref_count_;
	GamePrinter* self;
	gchar* key_name;
	GtkAdjustment* action;
};

struct _Block10Data {
	int _ref_count_;
	GamePrinter* self;
	GtkDialog* dialog;
};


static gpointer sudoku_printer_parent_class = NULL;
static gpointer game_printer_parent_class = NULL;

GType sudoku_printer_get_type (void) G_GNUC_CONST;
#define SUDOKU_PRINTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_PRINTER, SudokuPrinterPrivate))
enum  {
	SUDOKU_PRINTER_DUMMY_PROPERTY
};
#define SUDOKU_PRINTER_SUDOKUS_PER_PAGE 2
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
SudokuPrinter* sudoku_printer_new (SudokuBoard** boards, int boards_length1, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, SudokuBoard** boards, int boards_length1, GtkWindow* window);
static SudokuBoard** _vala_array_dup1 (SudokuBoard** self, int length);
static void sudoku_printer_begin_print_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context);
static void _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self);
static void sudoku_printer_draw_page_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context, gint page_nr);
static void _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
static gdouble sudoku_printer_fit_squares_in_rectangle (SudokuPrinter* self, gdouble width, gdouble height, gint margin);
static SudokuBoard** _vala_array_dup2 (SudokuBoard** self, int length);
static void sudoku_printer_draw_sudoku (SudokuPrinter* self, cairo_t* cr, SudokuBoard* sudoku_board, gdouble size, gdouble offset_x, gdouble offset_y);
static void sudoku_printer_finalize (GObject* obj);
GType game_printer_get_type (void) G_GNUC_CONST;
#define GAME_PRINTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_PRINTER, GamePrinterPrivate))
enum  {
	GAME_PRINTER_DUMMY_PROPERTY
};
#define GAME_PRINTER_DIFFICULTY_KEY_NAME "print-multiple-sudoku-difficulty"
GamePrinter* game_printer_new (SudokuSaver* saver, GtkApplicationWindow** window);
GamePrinter* game_printer_construct (GType object_type, SudokuSaver* saver, GtkApplicationWindow** window);
static void game_printer_response_cb (GamePrinter* self, GtkDialog* dialog, gint response);
static void _game_printer_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void game_printer_wrap_adjustment (GamePrinter* self, const gchar* key_name, GtkAdjustment* action);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda19_ (Block9Data* _data9_);
static void ___lambda19__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda18_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res);
static void ___lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void game_printer_run_dialog (GamePrinter* self);
static void game_printer_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self) {
	GtkPrintOperationResult result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GtkPrintOperationResult _result_ = 0;
		GtkPrintOperation* _tmp0_ = NULL;
		GtkWindow* _tmp1_ = NULL;
		GtkPrintOperationResult _tmp2_ = 0;
		_tmp0_ = self->priv->print_op;
		_tmp1_ = self->priv->window;
		_tmp2_ = gtk_print_operation_run (_tmp0_, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, _tmp1_, &_inner_error_);
		_result_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		result = _result_;
		return result;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GtkWindow* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GtkMessageDialog* _tmp9_ = NULL;
		GtkMessageDialog* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = self->priv->window;
		_tmp4_ = _ ("Error printing file:");
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strdup_printf ("%s\n%s", _tmp4_, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp8_);
		g_object_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		gtk_dialog_run ((GtkDialog*) _tmp10_);
		_g_object_unref0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = GTK_PRINT_OPERATION_RESULT_ERROR;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static SudokuBoard** _vala_array_dup1 (SudokuBoard** self, int length) {
	SudokuBoard** result;
	int i;
	result = g_new0 (SudokuBoard*, length + 1);
	for (i = 0; i < length; i++) {
		SudokuBoard* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self) {
	sudoku_printer_begin_print_cb ((SudokuPrinter*) self, _sender, context);
}


static void _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
	sudoku_printer_draw_page_cb ((SudokuPrinter*) self, _sender, context, page_nr);
}


SudokuPrinter* sudoku_printer_construct (GType object_type, SudokuBoard** boards, int boards_length1, GtkWindow* window) {
	SudokuPrinter * self = NULL;
	SudokuBoard** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	SudokuBoard** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GtkWindow* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	SudokuBoard** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GtkPrintOperation* _tmp5_ = NULL;
	GtkPrintOperation* _tmp6_ = NULL;
	GtkPrintOperation* _tmp7_ = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (SudokuPrinter*) g_object_new (object_type, NULL);
	_tmp0_ = boards;
	_tmp0__length1 = boards_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->boards = (_vala_array_free (self->priv->boards, self->priv->boards_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->boards = _tmp1_;
	self->priv->boards_length1 = _tmp1__length1;
	self->priv->_boards_size_ = self->priv->boards_length1;
	_tmp2_ = window;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp3_;
	self->priv->margin = 25;
	_tmp4_ = boards;
	_tmp4__length1 = boards_length1;
	self->priv->n_sudokus = _tmp4__length1;
	_tmp5_ = gtk_print_operation_new ();
	_g_object_unref0 (self->priv->print_op);
	self->priv->print_op = _tmp5_;
	_tmp6_ = self->priv->print_op;
	g_signal_connect_object (_tmp6_, "begin-print", (GCallback) _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print, self, 0);
	_tmp7_ = self->priv->print_op;
	g_signal_connect_object (_tmp7_, "draw-page", (GCallback) _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page, self, 0);
	return self;
}


SudokuPrinter* sudoku_printer_new (SudokuBoard** boards, int boards_length1, GtkWindow* window) {
	return sudoku_printer_construct (TYPE_SUDOKU_PRINTER, boards, boards_length1, window);
}


static void sudoku_printer_begin_print_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context) {
	gint pages = 0;
	gint _tmp0_ = 0;
	GtkPrintOperation* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->n_sudokus;
	pages = _tmp0_ / SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
	while (TRUE) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = pages;
		_tmp2_ = self->priv->n_sudokus;
		if (!((_tmp1_ * SUDOKU_PRINTER_SUDOKUS_PER_PAGE) < _tmp2_)) {
			break;
		}
		_tmp3_ = pages;
		pages = _tmp3_ + 1;
	}
	_tmp4_ = operation;
	_tmp5_ = pages;
	gtk_print_operation_set_n_pages (_tmp4_, _tmp5_);
}


static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


static SudokuBoard** _vala_array_dup2 (SudokuBoard** self, int length) {
	SudokuBoard** result;
	int i;
	result = g_new0 (SudokuBoard*, length + 1);
	for (i = 0; i < length; i++) {
		SudokuBoard* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void sudoku_printer_draw_page_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context, gint page_nr) {
	cairo_t* cr = NULL;
	GtkPrintContext* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	gdouble width = 0.0;
	GtkPrintContext* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	gdouble height = 0.0;
	GtkPrintContext* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gdouble best_square_size = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gint _tmp9_ = 0;
	gdouble _tmp10_ = 0.0;
	gint start = 0;
	gint _tmp11_ = 0;
	gint end = 0;
	gint _tmp12_ = 0;
	SudokuBoard** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp14_ = 0;
	SudokuBoard** sudokus_on_page = NULL;
	SudokuBoard** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	SudokuBoard** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint sudokus_on_page_length1 = 0;
	gint _sudokus_on_page_size_ = 0;
	gdouble left = 0.0;
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_ = 0.0;
	gdouble top = 0.0;
	gint _tmp21_ = 0;
	SudokuBoard** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
	_tmp2_ = _cairo_reference0 (_tmp1_);
	cr = _tmp2_;
	_tmp3_ = context;
	_tmp4_ = gtk_print_context_get_width (_tmp3_);
	width = _tmp4_;
	_tmp5_ = context;
	_tmp6_ = gtk_print_context_get_height (_tmp5_);
	height = _tmp6_;
	_tmp7_ = width;
	_tmp8_ = height;
	_tmp9_ = self->priv->margin;
	_tmp10_ = sudoku_printer_fit_squares_in_rectangle (self, _tmp7_, _tmp8_, _tmp9_);
	best_square_size = _tmp10_;
	_tmp11_ = page_nr;
	start = _tmp11_ * SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
	_tmp12_ = start;
	_tmp13_ = self->priv->boards;
	_tmp13__length1 = self->priv->boards_length1;
	_tmp14_ = MIN (_tmp12_ + SUDOKU_PRINTER_SUDOKUS_PER_PAGE, _tmp13__length1);
	end = _tmp14_;
	_tmp15_ = self->priv->boards;
	_tmp15__length1 = self->priv->boards_length1;
	_tmp16_ = start;
	_tmp17_ = end;
	_tmp18_ = ((_tmp15_ + _tmp16_) != NULL) ? _vala_array_dup2 (_tmp15_ + _tmp16_, _tmp17_ - _tmp16_) : ((gpointer) (_tmp15_ + _tmp16_));
	_tmp18__length1 = _tmp17_ - _tmp16_;
	sudokus_on_page = _tmp18_;
	sudokus_on_page_length1 = _tmp18__length1;
	_sudokus_on_page_size_ = sudokus_on_page_length1;
	_tmp19_ = width;
	_tmp20_ = best_square_size;
	left = (_tmp19_ - _tmp20_) / 2;
	_tmp21_ = self->priv->margin;
	top = (gdouble) _tmp21_;
	_tmp22_ = sudokus_on_page;
	_tmp22__length1 = sudokus_on_page_length1;
	{
		SudokuBoard** sudoku_collection = NULL;
		gint sudoku_collection_length1 = 0;
		gint _sudoku_collection_size_ = 0;
		gint sudoku_it = 0;
		sudoku_collection = _tmp22_;
		sudoku_collection_length1 = _tmp22__length1;
		for (sudoku_it = 0; sudoku_it < _tmp22__length1; sudoku_it = sudoku_it + 1) {
			SudokuBoard* _tmp23_ = NULL;
			SudokuBoard* sudoku = NULL;
			_tmp23_ = _g_object_ref0 (sudoku_collection[sudoku_it]);
			sudoku = _tmp23_;
			{
				gchar* label = NULL;
				SudokuBoard* _tmp24_ = NULL;
				DifficultyCategory _tmp25_ = 0;
				DifficultyCategory _tmp26_ = 0;
				gchar* _tmp27_ = NULL;
				cairo_t* _tmp28_ = NULL;
				cairo_t* _tmp29_ = NULL;
				cairo_t* _tmp30_ = NULL;
				cairo_text_extents_t extents = {0};
				cairo_t* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				cairo_text_extents_t _tmp33_ = {0};
				cairo_t* _tmp34_ = NULL;
				gdouble _tmp35_ = 0.0;
				cairo_text_extents_t _tmp36_ = {0};
				gdouble _tmp37_ = 0.0;
				gdouble _tmp38_ = 0.0;
				cairo_text_extents_t _tmp39_ = {0};
				gdouble _tmp40_ = 0.0;
				cairo_t* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				cairo_t* _tmp43_ = NULL;
				SudokuBoard* _tmp44_ = NULL;
				gdouble _tmp45_ = 0.0;
				gdouble _tmp46_ = 0.0;
				gdouble _tmp47_ = 0.0;
				gdouble _tmp48_ = 0.0;
				gdouble _tmp49_ = 0.0;
				gint _tmp50_ = 0;
				_tmp24_ = sudoku;
				_tmp25_ = sudoku_board_get_difficulty_category (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = difficulty_category_to_string (_tmp26_);
				label = _tmp27_;
				_tmp28_ = cr;
				cairo_set_font_size (_tmp28_, (gdouble) 12);
				_tmp29_ = cr;
				cairo_select_font_face (_tmp29_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
				_tmp30_ = cr;
				cairo_set_source_rgb (_tmp30_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
				_tmp31_ = cr;
				_tmp32_ = label;
				cairo_text_extents (_tmp31_, _tmp32_, &_tmp33_);
				extents = _tmp33_;
				_tmp34_ = cr;
				_tmp35_ = width;
				_tmp36_ = extents;
				_tmp37_ = _tmp36_.width;
				_tmp38_ = top;
				_tmp39_ = extents;
				_tmp40_ = _tmp39_.height;
				cairo_move_to (_tmp34_, (_tmp35_ - _tmp37_) / 2, _tmp38_ - (_tmp40_ / 2));
				_tmp41_ = cr;
				_tmp42_ = label;
				cairo_show_text (_tmp41_, _tmp42_);
				_tmp43_ = cr;
				_tmp44_ = sudoku;
				_tmp45_ = best_square_size;
				_tmp46_ = left;
				_tmp47_ = top;
				sudoku_printer_draw_sudoku (self, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_);
				_tmp48_ = top;
				_tmp49_ = best_square_size;
				_tmp50_ = self->priv->margin;
				top = _tmp48_ + (_tmp49_ + (2 * _tmp50_));
				_g_free0 (label);
				_g_object_unref0 (sudoku);
			}
		}
	}
	sudokus_on_page = (_vala_array_free (sudokus_on_page, sudokus_on_page_length1, (GDestroyNotify) g_object_unref), NULL);
	_cairo_destroy0 (cr);
}


static gdouble sudoku_printer_fit_squares_in_rectangle (SudokuPrinter* self, gdouble width, gdouble height, gint margin) {
	gdouble result = 0.0;
	gint n = 0;
	gdouble best_square_size = 0.0;
	gdouble square_size = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	n = SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
	best_square_size = 0.0;
	square_size = 0.0;
	{
		gint n_across = 0;
		n_across = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gdouble n_down = 0.0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gdouble across_size = 0.0;
				gdouble _tmp6_ = 0.0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				gint _tmp10_ = 0;
				gdouble down_size = 0.0;
				gdouble _tmp11_ = 0.0;
				gdouble _tmp12_ = 0.0;
				gint _tmp13_ = 0;
				gdouble _tmp14_ = 0.0;
				gdouble _tmp15_ = 0.0;
				gdouble _tmp16_ = 0.0;
				gdouble _tmp17_ = 0.0;
				gdouble _tmp18_ = 0.0;
				gdouble _tmp19_ = 0.0;
				gdouble _tmp20_ = 0.0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = n_across;
					n_across = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = n_across;
				_tmp3_ = n;
				if (!(_tmp2_ <= _tmp3_)) {
					break;
				}
				_tmp4_ = n;
				_tmp5_ = n_across;
				n_down = (gdouble) (_tmp4_ / _tmp5_);
				_tmp6_ = width;
				_tmp7_ = n_across;
				_tmp8_ = margin;
				across_size = _tmp6_ - ((_tmp7_ + 1) * _tmp8_);
				_tmp9_ = across_size;
				_tmp10_ = n_across;
				across_size = _tmp9_ / _tmp10_;
				_tmp11_ = height;
				_tmp12_ = n_down;
				_tmp13_ = margin;
				down_size = _tmp11_ - ((_tmp12_ + 1) * _tmp13_);
				_tmp14_ = down_size;
				_tmp15_ = n_down;
				down_size = _tmp14_ / _tmp15_;
				_tmp16_ = across_size;
				_tmp17_ = down_size;
				_tmp18_ = MIN (_tmp16_, _tmp17_);
				square_size = _tmp18_;
				_tmp19_ = square_size;
				_tmp20_ = best_square_size;
				if (_tmp19_ > _tmp20_) {
					gdouble _tmp21_ = 0.0;
					_tmp21_ = square_size;
					best_square_size = _tmp21_;
				}
			}
		}
	}
	result = best_square_size;
	return result;
}


static void sudoku_printer_draw_sudoku (SudokuPrinter* self, cairo_t* cr, SudokuBoard* sudoku_board, gdouble size, gdouble offset_x, gdouble offset_y) {
	static const gint SUDOKU_SIZE = 9;
	static const gint N_BOXES = 3;
	static const gdouble PENCIL_GREY[] = {0.3, 0.3, 0.3};
	static const gdouble BACKGROUND_COLOR[] = {1.0, 1.0, 1.0};
	static const gdouble BORDER_COLOR[] = {1.0, 1.0, 1.0};
	static const gdouble LINE_COLOR[] = {0.0, 0.0, 0.0};
	gdouble THIN = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble THICK = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble BORDER = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble WHITE_SPACE = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble SQUARE_SIZE = 0.0;
	gdouble _tmp8_ = 0.0;
	gint FONT_SIZE = 0;
	gdouble _tmp9_ = 0.0;
	static const cairo_font_weight_t FONT_WEIGHT = CAIRO_FONT_WEIGHT_NORMAL;
	gdouble* outer = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble* _tmp16_ = NULL;
	gint outer_length1 = 0;
	gint _outer_size_ = 0;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	gdouble* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gdouble _tmp20_ = 0.0;
	gdouble* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	cairo_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	gdouble _tmp28_ = 0.0;
	cairo_t* _tmp29_ = NULL;
	gdouble* _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	gdouble* _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	cairo_t* _tmp40_ = NULL;
	gdouble _tmp41_ = 0.0;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	cairo_t* _tmp44_ = NULL;
	cairo_t* _tmp45_ = NULL;
	gdouble _tmp46_ = 0.0;
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	cairo_t* _tmp49_ = NULL;
	cairo_t* _tmp50_ = NULL;
	cairo_t* _tmp51_ = NULL;
	gdouble _tmp52_ = 0.0;
	cairo_t* _tmp53_ = NULL;
	gdouble* _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
	gdouble _tmp57_ = 0.0;
	gdouble* _tmp58_ = NULL;
	gint _tmp58__length1 = 0;
	gdouble _tmp59_ = 0.0;
	gdouble _tmp60_ = 0.0;
	gdouble _tmp61_ = 0.0;
	gdouble _tmp62_ = 0.0;
	gdouble _tmp63_ = 0.0;
	gdouble _tmp64_ = 0.0;
	gdouble _tmp65_ = 0.0;
	gdouble _tmp66_ = 0.0;
	gdouble _tmp67_ = 0.0;
	cairo_t* _tmp68_ = NULL;
	gdouble _tmp69_ = 0.0;
	gdouble _tmp70_ = 0.0;
	gdouble _tmp71_ = 0.0;
	cairo_t* _tmp72_ = NULL;
	gdouble* pos = NULL;
	gdouble* _tmp73_ = NULL;
	gint pos_length1 = 0;
	gint _pos_size_ = 0;
	gdouble position = 0.0;
	gdouble _tmp74_ = 0.0;
	gdouble _tmp75_ = 0.0;
	gdouble* _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	gdouble _tmp77_ = 0.0;
	gdouble _tmp78_ = 0.0;
	gdouble _tmp79_ = 0.0;
	gdouble last_line = 0.0;
	cairo_t* _tmp131_ = NULL;
	gint _tmp132_ = 0;
	gchar* letter = NULL;
	gchar* _tmp133_ = NULL;
	cairo_text_extents_t extents = {0};
	gint* sudoku = NULL;
	SudokuBoard* _tmp134_ = NULL;
	gint _tmp135_ = 0;
	gint _tmp136_ = 0;
	gint* _tmp137_ = NULL;
	gint sudoku_length1 = 0;
	gint sudoku_length2 = 0;
	gboolean invert = FALSE;
	GtkTextDirection _tmp138_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (sudoku_board != NULL);
	_tmp0_ = size;
	THIN = _tmp0_ / 500.0;
	_tmp1_ = THIN;
	THICK = _tmp1_ * 5;
	_tmp2_ = THICK;
	BORDER = _tmp2_;
	_tmp3_ = size;
	_tmp4_ = BORDER;
	_tmp5_ = THICK;
	_tmp6_ = THICK;
	_tmp7_ = THIN;
	WHITE_SPACE = (((_tmp3_ - (2 * _tmp4_)) - (2 * _tmp5_)) - ((N_BOXES - 1) * _tmp6_)) - ((N_BOXES * 2) * _tmp7_);
	_tmp8_ = WHITE_SPACE;
	SQUARE_SIZE = _tmp8_ / SUDOKU_SIZE;
	_tmp9_ = SQUARE_SIZE;
	FONT_SIZE = ((gint) _tmp9_) / 2;
	_tmp10_ = offset_x;
	_tmp11_ = offset_x;
	_tmp12_ = size;
	_tmp13_ = offset_y;
	_tmp14_ = offset_y;
	_tmp15_ = size;
	_tmp16_ = g_new0 (gdouble, 4);
	_tmp16_[0] = _tmp10_;
	_tmp16_[1] = _tmp11_ + _tmp12_;
	_tmp16_[2] = _tmp13_;
	_tmp16_[3] = _tmp14_ + _tmp15_;
	outer = _tmp16_;
	outer_length1 = 4;
	_outer_size_ = outer_length1;
	_tmp17_ = cr;
	cairo_set_source_rgb (_tmp17_, 1.0, 1.0, 1.0);
	_tmp18_ = cr;
	_tmp19_ = outer;
	_tmp19__length1 = outer_length1;
	_tmp20_ = _tmp19_[0];
	_tmp21_ = outer;
	_tmp21__length1 = outer_length1;
	_tmp22_ = _tmp21_[2];
	_tmp23_ = size;
	_tmp24_ = size;
	cairo_rectangle (_tmp18_, _tmp20_, _tmp22_, _tmp23_, _tmp24_);
	_tmp25_ = cr;
	cairo_fill (_tmp25_);
	_tmp26_ = cr;
	cairo_set_line_join (_tmp26_, CAIRO_LINE_JOIN_ROUND);
	_tmp27_ = cr;
	_tmp28_ = BORDER;
	cairo_set_line_width (_tmp27_, _tmp28_);
	_tmp29_ = cr;
	_tmp30_ = outer;
	_tmp30__length1 = outer_length1;
	_tmp31_ = _tmp30_[0];
	_tmp32_ = BORDER;
	_tmp33_ = outer;
	_tmp33__length1 = outer_length1;
	_tmp34_ = _tmp33_[2];
	_tmp35_ = BORDER;
	_tmp36_ = size;
	_tmp37_ = BORDER;
	_tmp38_ = size;
	_tmp39_ = BORDER;
	cairo_rectangle (_tmp29_, _tmp31_ + (_tmp32_ / 2.0), _tmp34_ + (_tmp35_ / 2.0), _tmp36_ - _tmp37_, _tmp38_ - _tmp39_);
	_tmp40_ = cr;
	_tmp41_ = BACKGROUND_COLOR[0];
	_tmp42_ = BACKGROUND_COLOR[1];
	_tmp43_ = BACKGROUND_COLOR[2];
	cairo_set_source_rgb (_tmp40_, _tmp41_, _tmp42_, _tmp43_);
	_tmp44_ = cr;
	cairo_fill_preserve (_tmp44_);
	_tmp45_ = cr;
	_tmp46_ = BORDER_COLOR[0];
	_tmp47_ = BORDER_COLOR[1];
	_tmp48_ = BORDER_COLOR[2];
	cairo_set_source_rgb (_tmp45_, _tmp46_, _tmp47_, _tmp48_);
	_tmp49_ = cr;
	cairo_stroke (_tmp49_);
	_tmp50_ = cr;
	cairo_set_line_join (_tmp50_, CAIRO_LINE_JOIN_MITER);
	_tmp51_ = cr;
	_tmp52_ = THICK;
	cairo_set_line_width (_tmp51_, _tmp52_);
	_tmp53_ = cr;
	_tmp54_ = outer;
	_tmp54__length1 = outer_length1;
	_tmp55_ = _tmp54_[0];
	_tmp56_ = BORDER;
	_tmp57_ = THICK;
	_tmp58_ = outer;
	_tmp58__length1 = outer_length1;
	_tmp59_ = _tmp58_[2];
	_tmp60_ = BORDER;
	_tmp61_ = THICK;
	_tmp62_ = size;
	_tmp63_ = BORDER;
	_tmp64_ = THICK;
	_tmp65_ = size;
	_tmp66_ = BORDER;
	_tmp67_ = THICK;
	cairo_rectangle (_tmp53_, (_tmp55_ + _tmp56_) + (_tmp57_ / 2.0), (_tmp59_ + _tmp60_) + (_tmp61_ / 2.0), (_tmp62_ - (_tmp63_ * 2)) - _tmp64_, (_tmp65_ - (_tmp66_ * 2)) - _tmp67_);
	_tmp68_ = cr;
	_tmp69_ = LINE_COLOR[0];
	_tmp70_ = LINE_COLOR[1];
	_tmp71_ = LINE_COLOR[2];
	cairo_set_source_rgb (_tmp68_, _tmp69_, _tmp70_, _tmp71_);
	_tmp72_ = cr;
	cairo_stroke (_tmp72_);
	_tmp73_ = g_new0 (gdouble, SUDOKU_SIZE + 1);
	pos = _tmp73_;
	pos_length1 = SUDOKU_SIZE + 1;
	_pos_size_ = pos_length1;
	_tmp74_ = BORDER;
	_tmp75_ = THICK;
	position = _tmp74_ + _tmp75_;
	_tmp76_ = pos;
	_tmp76__length1 = pos_length1;
	_tmp77_ = position;
	_tmp78_ = SQUARE_SIZE;
	_tmp76_[0] = _tmp77_ + (_tmp78_ / 2.0);
	_tmp79_ = _tmp76_[0];
	last_line = 0.0;
	{
		gint n = 0;
		n = 1;
		{
			gboolean _tmp80_ = FALSE;
			_tmp80_ = TRUE;
			while (TRUE) {
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gdouble* _tmp98_ = NULL;
				gint _tmp98__length1 = 0;
				gint _tmp99_ = 0;
				gdouble _tmp100_ = 0.0;
				gdouble _tmp101_ = 0.0;
				gdouble _tmp102_ = 0.0;
				gdouble _tmp103_ = 0.0;
				cairo_t* _tmp104_ = NULL;
				gdouble _tmp105_ = 0.0;
				gdouble _tmp106_ = 0.0;
				gdouble _tmp107_ = 0.0;
				gdouble _tmp108_ = 0.0;
				gdouble _tmp109_ = 0.0;
				cairo_t* _tmp110_ = NULL;
				gdouble _tmp111_ = 0.0;
				gdouble _tmp112_ = 0.0;
				gdouble _tmp113_ = 0.0;
				gdouble _tmp114_ = 0.0;
				gdouble _tmp115_ = 0.0;
				gdouble _tmp116_ = 0.0;
				cairo_t* _tmp117_ = NULL;
				gdouble _tmp118_ = 0.0;
				gdouble _tmp119_ = 0.0;
				gdouble _tmp120_ = 0.0;
				gdouble _tmp121_ = 0.0;
				gdouble _tmp122_ = 0.0;
				cairo_t* _tmp123_ = NULL;
				gdouble _tmp124_ = 0.0;
				gdouble _tmp125_ = 0.0;
				gdouble _tmp126_ = 0.0;
				gdouble _tmp127_ = 0.0;
				gdouble _tmp128_ = 0.0;
				gdouble _tmp129_ = 0.0;
				cairo_t* _tmp130_ = NULL;
				if (!_tmp80_) {
					gint _tmp81_ = 0;
					_tmp81_ = n;
					n = _tmp81_ + 1;
				}
				_tmp80_ = FALSE;
				_tmp82_ = n;
				if (!(_tmp82_ <= SUDOKU_SIZE)) {
					break;
				}
				_tmp83_ = n;
				if ((_tmp83_ % N_BOXES) == 0) {
					cairo_t* _tmp84_ = NULL;
					gdouble _tmp85_ = 0.0;
					gdouble _tmp86_ = 0.0;
					gdouble _tmp87_ = 0.0;
					gdouble _tmp88_ = 0.0;
					gdouble _tmp89_ = 0.0;
					gdouble _tmp90_ = 0.0;
					_tmp84_ = cr;
					_tmp85_ = THICK;
					cairo_set_line_width (_tmp84_, _tmp85_);
					_tmp86_ = position;
					_tmp87_ = SQUARE_SIZE;
					_tmp88_ = last_line;
					_tmp89_ = THICK;
					position = _tmp86_ + ((_tmp87_ + (_tmp88_ / 2.0)) + (_tmp89_ / 2.0));
					_tmp90_ = THICK;
					last_line = _tmp90_;
				} else {
					cairo_t* _tmp91_ = NULL;
					gdouble _tmp92_ = 0.0;
					gdouble _tmp93_ = 0.0;
					gdouble _tmp94_ = 0.0;
					gdouble _tmp95_ = 0.0;
					gdouble _tmp96_ = 0.0;
					gdouble _tmp97_ = 0.0;
					_tmp91_ = cr;
					_tmp92_ = THIN;
					cairo_set_line_width (_tmp91_, _tmp92_);
					_tmp93_ = position;
					_tmp94_ = SQUARE_SIZE;
					_tmp95_ = last_line;
					_tmp96_ = THIN;
					position = _tmp93_ + ((_tmp94_ + (_tmp95_ / 2.0)) + (_tmp96_ / 2.0));
					_tmp97_ = THIN;
					last_line = _tmp97_;
				}
				_tmp98_ = pos;
				_tmp98__length1 = pos_length1;
				_tmp99_ = n;
				_tmp100_ = position;
				_tmp101_ = last_line;
				_tmp102_ = SQUARE_SIZE;
				_tmp98_[_tmp99_] = (_tmp100_ + (_tmp101_ / 2.0)) + (_tmp102_ / 2.0);
				_tmp103_ = _tmp98_[_tmp99_];
				_tmp104_ = cr;
				_tmp105_ = BORDER;
				_tmp106_ = THICK;
				_tmp107_ = offset_x;
				_tmp108_ = position;
				_tmp109_ = offset_y;
				cairo_move_to (_tmp104_, (_tmp105_ + (_tmp106_ / 2.0)) + _tmp107_, _tmp108_ + _tmp109_);
				_tmp110_ = cr;
				_tmp111_ = size;
				_tmp112_ = BORDER;
				_tmp113_ = THICK;
				_tmp114_ = offset_x;
				_tmp115_ = position;
				_tmp116_ = offset_y;
				cairo_line_to (_tmp110_, ((_tmp111_ - _tmp112_) - (_tmp113_ / 2.0)) + _tmp114_, _tmp115_ + _tmp116_);
				_tmp117_ = cr;
				_tmp118_ = position;
				_tmp119_ = offset_x;
				_tmp120_ = BORDER;
				_tmp121_ = THICK;
				_tmp122_ = offset_y;
				cairo_move_to (_tmp117_, _tmp118_ + _tmp119_, (_tmp120_ + (_tmp121_ / 2.0)) + _tmp122_);
				_tmp123_ = cr;
				_tmp124_ = position;
				_tmp125_ = offset_x;
				_tmp126_ = size;
				_tmp127_ = BORDER;
				_tmp128_ = THICK;
				_tmp129_ = offset_y;
				cairo_line_to (_tmp123_, _tmp124_ + _tmp125_, ((_tmp126_ - _tmp127_) - (_tmp128_ / 2.0)) + _tmp129_);
				_tmp130_ = cr;
				cairo_stroke (_tmp130_);
			}
		}
	}
	_tmp131_ = cr;
	_tmp132_ = FONT_SIZE;
	cairo_set_font_size (_tmp131_, (gdouble) _tmp132_);
	_tmp133_ = g_strdup ("");
	letter = _tmp133_;
	_tmp134_ = sudoku_board;
	_tmp137_ = sudoku_board_get_cells (_tmp134_, &_tmp135_, &_tmp136_);
	sudoku = _tmp137_;
	sudoku_length1 = _tmp135_;
	sudoku_length2 = _tmp136_;
	_tmp138_ = gtk_widget_get_default_direction ();
	invert = _tmp138_ == GTK_TEXT_DIR_RTL;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp139_ = FALSE;
			_tmp139_ = TRUE;
			while (TRUE) {
				gint _tmp141_ = 0;
				gint _tmp142_ = 0;
				gboolean _tmp143_ = FALSE;
				gint real_x = 0;
				if (!_tmp139_) {
					gint _tmp140_ = 0;
					_tmp140_ = x;
					x = _tmp140_ + 1;
				}
				_tmp139_ = FALSE;
				_tmp141_ = x;
				if (!(_tmp141_ < SUDOKU_SIZE)) {
					break;
				}
				_tmp143_ = invert;
				if (_tmp143_) {
					gint _tmp144_ = 0;
					_tmp144_ = x;
					_tmp142_ = (SUDOKU_SIZE - _tmp144_) - 1;
				} else {
					gint _tmp145_ = 0;
					_tmp145_ = x;
					_tmp142_ = _tmp145_;
				}
				real_x = _tmp142_;
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp146_ = FALSE;
						_tmp146_ = TRUE;
						while (TRUE) {
							gint _tmp148_ = 0;
							cairo_t* _tmp149_ = NULL;
							gdouble* _tmp150_ = NULL;
							gint _tmp150__length1 = 0;
							gint _tmp151_ = 0;
							gdouble _tmp152_ = 0.0;
							gdouble _tmp153_ = 0.0;
							gdouble* _tmp154_ = NULL;
							gint _tmp154__length1 = 0;
							gint _tmp155_ = 0;
							gdouble _tmp156_ = 0.0;
							gdouble _tmp157_ = 0.0;
							gchar* _tmp158_ = NULL;
							gint* _tmp159_ = NULL;
							gint _tmp159__length1 = 0;
							gint _tmp159__length2 = 0;
							gint _tmp160_ = 0;
							gint _tmp161_ = 0;
							gint _tmp162_ = 0;
							if (!_tmp146_) {
								gint _tmp147_ = 0;
								_tmp147_ = y;
								y = _tmp147_ + 1;
							}
							_tmp146_ = FALSE;
							_tmp148_ = y;
							if (!(_tmp148_ < SUDOKU_SIZE)) {
								break;
							}
							_tmp149_ = cr;
							_tmp150_ = pos;
							_tmp150__length1 = pos_length1;
							_tmp151_ = x;
							_tmp152_ = _tmp150_[_tmp151_];
							_tmp153_ = offset_x;
							_tmp154_ = pos;
							_tmp154__length1 = pos_length1;
							_tmp155_ = y;
							_tmp156_ = _tmp154_[_tmp155_];
							_tmp157_ = offset_y;
							cairo_move_to (_tmp149_, _tmp152_ + _tmp153_, _tmp156_ + _tmp157_);
							_tmp158_ = g_strdup ("");
							_g_free0 (letter);
							letter = _tmp158_;
							_tmp159_ = sudoku;
							_tmp159__length1 = sudoku_length1;
							_tmp159__length2 = sudoku_length2;
							_tmp160_ = y;
							_tmp161_ = real_x;
							_tmp162_ = _tmp159_[(_tmp160_ * _tmp159__length2) + _tmp161_];
							if (_tmp162_ != 0) {
								gint* _tmp163_ = NULL;
								gint _tmp163__length1 = 0;
								gint _tmp163__length2 = 0;
								gint _tmp164_ = 0;
								gint _tmp165_ = 0;
								gint _tmp166_ = 0;
								gchar* _tmp167_ = NULL;
								SudokuBoard* _tmp168_ = NULL;
								gboolean* _tmp169_ = NULL;
								gint _tmp169__length1 = 0;
								gint _tmp169__length2 = 0;
								gint _tmp170_ = 0;
								gint _tmp171_ = 0;
								gboolean _tmp172_ = FALSE;
								cairo_t* _tmp180_ = NULL;
								const gchar* _tmp181_ = NULL;
								cairo_text_extents_t _tmp182_ = {0};
								cairo_t* _tmp183_ = NULL;
								gdouble* _tmp184_ = NULL;
								gint _tmp184__length1 = 0;
								gint _tmp185_ = 0;
								gdouble _tmp186_ = 0.0;
								gdouble _tmp187_ = 0.0;
								cairo_text_extents_t _tmp188_ = {0};
								gdouble _tmp189_ = 0.0;
								gdouble* _tmp190_ = NULL;
								gint _tmp190__length1 = 0;
								gint _tmp191_ = 0;
								gdouble _tmp192_ = 0.0;
								gdouble _tmp193_ = 0.0;
								cairo_text_extents_t _tmp194_ = {0};
								gdouble _tmp195_ = 0.0;
								cairo_t* _tmp196_ = NULL;
								const gchar* _tmp197_ = NULL;
								_tmp163_ = sudoku;
								_tmp163__length1 = sudoku_length1;
								_tmp163__length2 = sudoku_length2;
								_tmp164_ = y;
								_tmp165_ = real_x;
								_tmp166_ = _tmp163_[(_tmp164_ * _tmp163__length2) + _tmp165_];
								_tmp167_ = g_strdup_printf ("%i", _tmp166_);
								_g_free0 (letter);
								letter = _tmp167_;
								_tmp168_ = sudoku_board;
								_tmp169_ = _tmp168_->is_fixed;
								_tmp169__length1 = _tmp168_->is_fixed_length1;
								_tmp169__length2 = _tmp168_->is_fixed_length2;
								_tmp170_ = y;
								_tmp171_ = real_x;
								_tmp172_ = _tmp169_[(_tmp170_ * _tmp169__length2) + _tmp171_];
								if (_tmp172_) {
									cairo_t* _tmp173_ = NULL;
									cairo_t* _tmp174_ = NULL;
									_tmp173_ = cr;
									cairo_select_font_face (_tmp173_, "Sans", CAIRO_FONT_SLANT_NORMAL, FONT_WEIGHT);
									_tmp174_ = cr;
									cairo_set_source_rgb (_tmp174_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
								} else {
									cairo_t* _tmp175_ = NULL;
									cairo_t* _tmp176_ = NULL;
									gdouble _tmp177_ = 0.0;
									gdouble _tmp178_ = 0.0;
									gdouble _tmp179_ = 0.0;
									_tmp175_ = cr;
									cairo_select_font_face (_tmp175_, "Times", CAIRO_FONT_SLANT_ITALIC, FONT_WEIGHT);
									_tmp176_ = cr;
									_tmp177_ = PENCIL_GREY[0];
									_tmp178_ = PENCIL_GREY[1];
									_tmp179_ = PENCIL_GREY[2];
									cairo_set_source_rgb (_tmp176_, _tmp177_, _tmp178_, _tmp179_);
								}
								_tmp180_ = cr;
								_tmp181_ = letter;
								cairo_text_extents (_tmp180_, _tmp181_, &_tmp182_);
								extents = _tmp182_;
								_tmp183_ = cr;
								_tmp184_ = pos;
								_tmp184__length1 = pos_length1;
								_tmp185_ = x;
								_tmp186_ = _tmp184_[_tmp185_];
								_tmp187_ = offset_x;
								_tmp188_ = extents;
								_tmp189_ = _tmp188_.x_advance;
								_tmp190_ = pos;
								_tmp190__length1 = pos_length1;
								_tmp191_ = y;
								_tmp192_ = _tmp190_[_tmp191_];
								_tmp193_ = offset_y;
								_tmp194_ = extents;
								_tmp195_ = _tmp194_.height;
								cairo_move_to (_tmp183_, (_tmp186_ + _tmp187_) - (_tmp189_ / 2.0), (_tmp192_ + _tmp193_) + (_tmp195_ / 2.0));
								_tmp196_ = cr;
								_tmp197_ = letter;
								cairo_show_text (_tmp196_, _tmp197_);
							}
						}
					}
				}
			}
		}
	}
	sudoku = (g_free (sudoku), NULL);
	_g_free0 (letter);
	pos = (g_free (pos), NULL);
	outer = (g_free (outer), NULL);
}


static void sudoku_printer_class_init (SudokuPrinterClass * klass) {
	sudoku_printer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuPrinterPrivate));
	G_OBJECT_CLASS (klass)->finalize = sudoku_printer_finalize;
}


static void sudoku_printer_instance_init (SudokuPrinter * self) {
	self->priv = SUDOKU_PRINTER_GET_PRIVATE (self);
}


static void sudoku_printer_finalize (GObject* obj) {
	SudokuPrinter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_PRINTER, SudokuPrinter);
	self->priv->boards = (_vala_array_free (self->priv->boards, self->priv->boards_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->print_op);
	G_OBJECT_CLASS (sudoku_printer_parent_class)->finalize (obj);
}


GType sudoku_printer_get_type (void) {
	static volatile gsize sudoku_printer_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_printer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuPrinterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_printer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuPrinter), 0, (GInstanceInitFunc) sudoku_printer_instance_init, NULL };
		GType sudoku_printer_type_id;
		sudoku_printer_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuPrinter", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_printer_type_id__volatile, sudoku_printer_type_id);
	}
	return sudoku_printer_type_id__volatile;
}


static void _game_printer_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	game_printer_response_cb ((GamePrinter*) self, _sender, response_id);
}


GamePrinter* game_printer_construct (GType object_type, SudokuSaver* saver, GtkApplicationWindow** window) {
	GamePrinter * self = NULL;
	SudokuSaver* _tmp0_ = NULL;
	SudokuSaver* _tmp1_ = NULL;
	GtkApplicationWindow* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp5_ = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GtkBuilder* _tmp7_ = NULL;
	GObject* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkApplicationWindow* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkRadioButton* _tmp16_ = NULL;
	GtkBuilder* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	GtkRadioButton* _tmp19_ = NULL;
	GtkBuilder* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	GtkRadioButton* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkRadioButton* _tmp25_ = NULL;
	DifficultyCategory saved_difficulty = 0;
	GSettings* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	DifficultyCategory _tmp28_ = 0;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkSpinButton* _tmp38_ = NULL;
	GtkSpinButton* _tmp39_ = NULL;
	GtkAdjustment* _tmp40_ = NULL;
	GtkBuilder* _tmp41_ = NULL;
	GObject* _tmp42_ = NULL;
	GtkSpinner* _tmp43_ = NULL;
	g_return_val_if_fail (saver != NULL, NULL);
	g_return_val_if_fail (*window != NULL, NULL);
	self = (GamePrinter*) g_object_new (object_type, NULL);
	_tmp0_ = saver;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->saver);
	self->priv->saver = _tmp1_;
	_tmp2_ = *window;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp3_;
	_tmp4_ = g_settings_new ("org.gnome.sudoku");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = gtk_builder_new_from_resource ("/org/gnome/sudoku/ui/print-games.ui");
	builder = _tmp5_;
	_tmp6_ = builder;
	gtk_builder_connect_signals (_tmp6_, NULL);
	_tmp7_ = builder;
	_tmp8_ = gtk_builder_get_object (_tmp7_, "dialog");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp8_) : NULL);
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp9_;
	_tmp10_ = self->priv->dialog;
	_tmp11_ = *window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp10_, (GtkWindow*) _tmp11_);
	_tmp12_ = self->priv->dialog;
	gtk_dialog_set_default_response (_tmp12_, (gint) GTK_RESPONSE_OK);
	_tmp13_ = self->priv->dialog;
	g_signal_connect_object (_tmp13_, "response", (GCallback) _game_printer_response_cb_gtk_dialog_response, self, 0);
	_tmp14_ = builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "easyRadioButton");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp15_) : NULL);
	_g_object_unref0 (self->priv->easy_button);
	self->priv->easy_button = _tmp16_;
	_tmp17_ = builder;
	_tmp18_ = gtk_builder_get_object (_tmp17_, "mediumRadioButton");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp18_) : NULL);
	_g_object_unref0 (self->priv->medium_button);
	self->priv->medium_button = _tmp19_;
	_tmp20_ = builder;
	_tmp21_ = gtk_builder_get_object (_tmp20_, "hardRadioButton");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp21_) : NULL);
	_g_object_unref0 (self->priv->hard_button);
	self->priv->hard_button = _tmp22_;
	_tmp23_ = builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "very_hardRadioButton");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp24_) : NULL);
	_g_object_unref0 (self->priv->very_hard_button);
	self->priv->very_hard_button = _tmp25_;
	_tmp26_ = self->priv->settings;
	_tmp27_ = g_settings_get_enum (_tmp26_, GAME_PRINTER_DIFFICULTY_KEY_NAME);
	saved_difficulty = (DifficultyCategory) _tmp27_;
	_tmp28_ = saved_difficulty;
	if (_tmp28_ == DIFFICULTY_CATEGORY_EASY) {
		GtkRadioButton* _tmp29_ = NULL;
		_tmp29_ = self->priv->easy_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp29_, TRUE);
	} else {
		DifficultyCategory _tmp30_ = 0;
		_tmp30_ = saved_difficulty;
		if (_tmp30_ == DIFFICULTY_CATEGORY_MEDIUM) {
			GtkRadioButton* _tmp31_ = NULL;
			_tmp31_ = self->priv->medium_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp31_, TRUE);
		} else {
			DifficultyCategory _tmp32_ = 0;
			_tmp32_ = saved_difficulty;
			if (_tmp32_ == DIFFICULTY_CATEGORY_HARD) {
				GtkRadioButton* _tmp33_ = NULL;
				_tmp33_ = self->priv->hard_button;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp33_, TRUE);
			} else {
				DifficultyCategory _tmp34_ = 0;
				_tmp34_ = saved_difficulty;
				if (_tmp34_ == DIFFICULTY_CATEGORY_VERY_HARD) {
					GtkRadioButton* _tmp35_ = NULL;
					_tmp35_ = self->priv->very_hard_button;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp35_, TRUE);
				}
			}
		}
	}
	_tmp36_ = builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "sudokusToPrintSpinButton");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp37_) : NULL);
	_g_object_unref0 (self->priv->nsudokus_button);
	self->priv->nsudokus_button = _tmp38_;
	_tmp39_ = self->priv->nsudokus_button;
	_tmp40_ = gtk_spin_button_get_adjustment (_tmp39_);
	game_printer_wrap_adjustment (self, "print-multiple-sudokus-to-print", _tmp40_);
	_tmp41_ = builder;
	_tmp42_ = gtk_builder_get_object (_tmp41_, "spinner");
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, gtk_spinner_get_type ()) ? ((GtkSpinner*) _tmp42_) : NULL);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp43_;
	_g_object_unref0 (builder);
	return self;
}


GamePrinter* game_printer_new (SudokuSaver* saver, GtkApplicationWindow** window) {
	return game_printer_construct (TYPE_GAME_PRINTER, saver, window);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		GamePrinter* self;
		self = _data9_->self;
		_g_free0 (_data9_->key_name);
		_g_object_unref0 (_data9_->action);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static void __lambda19_ (Block9Data* _data9_) {
	GamePrinter* self;
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	self = _data9_->self;
	_tmp0_ = self->priv->settings;
	_tmp1_ = _data9_->key_name;
	_tmp2_ = _data9_->action;
	_tmp3_ = gtk_adjustment_get_value (_tmp2_);
	g_settings_set_int (_tmp0_, _tmp1_, (gint) _tmp3_);
}


static void ___lambda19__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	__lambda19_ (self);
}


static void game_printer_wrap_adjustment (GamePrinter* self, const gchar* key_name, GtkAdjustment* action) {
	Block9Data* _data9_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	GtkAdjustment* _tmp3_ = NULL;
	GtkAdjustment* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkAdjustment* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_name != NULL);
	g_return_if_fail (action != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = key_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data9_->key_name);
	_data9_->key_name = _tmp1_;
	_tmp2_ = action;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data9_->action);
	_data9_->action = _tmp3_;
	_tmp4_ = _data9_->action;
	_tmp5_ = self->priv->settings;
	_tmp6_ = _data9_->key_name;
	_tmp7_ = g_settings_get_int (_tmp5_, _tmp6_);
	gtk_adjustment_set_value (_tmp4_, (gdouble) _tmp7_);
	_tmp8_ = _data9_->action;
	g_signal_connect_data (_tmp8_, "value-changed", (GCallback) ___lambda19__gtk_adjustment_value_changed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		GamePrinter* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}


static void __lambda18_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res) {
	GamePrinter* self;
	GError * _inner_error_ = NULL;
	self = _data10_->self;
	g_return_if_fail (res != NULL);
	{
		SudokuBoard** boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		SudokuBoard** _tmp2_ = NULL;
		gint boards_length1 = 0;
		gint _boards_size_ = 0;
		GtkSpinner* _tmp3_ = NULL;
		GtkSpinner* _tmp4_ = NULL;
		GtkDialog* _tmp5_ = NULL;
		SudokuPrinter* printer = NULL;
		GtkDialog* _tmp6_ = NULL;
		SudokuPrinter* _tmp7_ = NULL;
		GtkPrintOperationResult _result_ = 0;
		SudokuPrinter* _tmp8_ = NULL;
		GtkPrintOperationResult _tmp9_ = 0;
		GtkPrintOperationResult _tmp10_ = 0;
		_tmp0_ = res;
		_tmp2_ = sudoku_generator_generate_boards_finish (_tmp0_, &_tmp1_, &_inner_error_);
		boards = _tmp2_;
		boards_length1 = _tmp1_;
		_boards_size_ = boards_length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch5_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->spinner;
		gtk_spinner_stop (_tmp3_);
		_tmp4_ = self->priv->spinner;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
		_tmp5_ = _data10_->dialog;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
		_tmp6_ = _data10_->dialog;
		_tmp7_ = sudoku_printer_new (boards, boards_length1, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow));
		printer = _tmp7_;
		_tmp8_ = printer;
		_tmp9_ = sudoku_printer_print_sudoku (_tmp8_);
		_result_ = _tmp9_;
		_tmp10_ = _result_;
		if (_tmp10_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
			GtkDialog* _tmp11_ = NULL;
			_tmp11_ = _data10_->dialog;
			gtk_widget_hide ((GtkWidget*) _tmp11_);
			g_signal_emit_by_name (self, "game-printer-closed");
			{
				SudokuBoard** board_collection = NULL;
				gint board_collection_length1 = 0;
				gint _board_collection_size_ = 0;
				gint board_it = 0;
				board_collection = boards;
				board_collection_length1 = boards_length1;
				for (board_it = 0; board_it < boards_length1; board_it = board_it + 1) {
					SudokuBoard* _tmp12_ = NULL;
					SudokuBoard* board = NULL;
					_tmp12_ = _g_object_ref0 (board_collection[board_it]);
					board = _tmp12_;
					{
						SudokuSaver* _tmp13_ = NULL;
						SudokuBoard* _tmp14_ = NULL;
						SudokuGame* _tmp15_ = NULL;
						SudokuGame* _tmp16_ = NULL;
						_tmp13_ = self->priv->saver;
						_tmp14_ = board;
						_tmp15_ = sudoku_game_new (_tmp14_);
						_tmp16_ = _tmp15_;
						sudoku_saver_add_game_to_finished (_tmp13_, _tmp16_, FALSE);
						_g_object_unref0 (_tmp16_);
						_g_object_unref0 (board);
					}
				}
			}
		}
		_g_object_unref0 (printer);
		boards = (_vala_array_free (boards, boards_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	goto __finally5;
	__catch5_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e->message;
		g_error ("sudoku-printer.vala:330: Thread error: %s\n", _tmp17_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda18_ (self, source_object, res);
	block10_data_unref (self);
}


static void game_printer_response_cb (GamePrinter* self, GtkDialog* dialog, gint response) {
	Block10Data* _data10_;
	GtkDialog* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint nsudokus = 0;
	GtkSpinButton* _tmp6_ = NULL;
	GtkAdjustment* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	DifficultyCategory level = 0;
	GtkRadioButton* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GSettings* _tmp17_ = NULL;
	DifficultyCategory _tmp18_ = 0;
	GtkSpinner* _tmp19_ = NULL;
	GtkSpinner* _tmp20_ = NULL;
	GtkSpinner* _tmp21_ = NULL;
	GtkSpinner* _tmp22_ = NULL;
	GtkDialog* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	DifficultyCategory _tmp25_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = dialog;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data10_->dialog);
	_data10_->dialog = _tmp1_;
	_tmp3_ = response;
	if (_tmp3_ != ((gint) GTK_RESPONSE_ACCEPT)) {
		gint _tmp4_ = 0;
		_tmp4_ = response;
		_tmp2_ = _tmp4_ != ((gint) GTK_RESPONSE_OK);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkDialog* _tmp5_ = NULL;
		_tmp5_ = _data10_->dialog;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
		g_signal_emit_by_name (self, "game-printer-closed");
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	_tmp6_ = self->priv->nsudokus_button;
	_tmp7_ = gtk_spin_button_get_adjustment (_tmp6_);
	_tmp8_ = gtk_adjustment_get_value (_tmp7_);
	nsudokus = (gint) _tmp8_;
	_tmp9_ = self->priv->easy_button;
	_tmp10_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp9_);
	if (_tmp10_) {
		level = DIFFICULTY_CATEGORY_EASY;
	} else {
		GtkRadioButton* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = self->priv->medium_button;
		_tmp12_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp11_);
		if (_tmp12_) {
			level = DIFFICULTY_CATEGORY_MEDIUM;
		} else {
			GtkRadioButton* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = self->priv->hard_button;
			_tmp14_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp13_);
			if (_tmp14_) {
				level = DIFFICULTY_CATEGORY_HARD;
			} else {
				GtkRadioButton* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				_tmp15_ = self->priv->very_hard_button;
				_tmp16_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp15_);
				if (_tmp16_) {
					level = DIFFICULTY_CATEGORY_VERY_HARD;
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
	_tmp17_ = self->priv->settings;
	_tmp18_ = level;
	g_settings_set_enum (_tmp17_, GAME_PRINTER_DIFFICULTY_KEY_NAME, (gint) _tmp18_);
	_tmp19_ = self->priv->spinner;
	gtk_widget_set_visible ((GtkWidget*) _tmp19_, TRUE);
	_tmp20_ = self->priv->spinner;
	g_object_set (_tmp20_, "active", TRUE, NULL);
	_tmp21_ = self->priv->spinner;
	gtk_widget_show ((GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->spinner;
	gtk_spinner_start (_tmp22_);
	_tmp23_ = _data10_->dialog;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, FALSE);
	_tmp24_ = nsudokus;
	_tmp25_ = level;
	sudoku_generator_generate_boards_async (_tmp24_, _tmp25_, ___lambda18__gasync_ready_callback, block10_data_ref (_data10_));
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


void game_printer_run_dialog (GamePrinter* self) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dialog;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static void game_printer_class_init (GamePrinterClass * klass) {
	game_printer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamePrinterPrivate));
	G_OBJECT_CLASS (klass)->finalize = game_printer_finalize;
	g_signal_new ("game_printer_closed", TYPE_GAME_PRINTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void game_printer_instance_init (GamePrinter * self) {
	self->priv = GAME_PRINTER_GET_PRIVATE (self);
}


static void game_printer_finalize (GObject* obj) {
	GamePrinter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_PRINTER, GamePrinter);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->nsudokus_button);
	_g_object_unref0 (self->priv->easy_button);
	_g_object_unref0 (self->priv->medium_button);
	_g_object_unref0 (self->priv->hard_button);
	_g_object_unref0 (self->priv->very_hard_button);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (game_printer_parent_class)->finalize (obj);
}


GType game_printer_get_type (void) {
	static volatile gsize game_printer_type_id__volatile = 0;
	if (g_once_init_enter (&game_printer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamePrinterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_printer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamePrinter), 0, (GInstanceInitFunc) game_printer_instance_init, NULL };
		GType game_printer_type_id;
		game_printer_type_id = g_type_register_static (G_TYPE_OBJECT, "GamePrinter", &g_define_type_info, 0);
		g_once_init_leave (&game_printer_type_id__volatile, game_printer_type_id);
	}
	return game_printer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



