/* gnome-sudoku.c generated by valac 0.25.3.3-7022, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>


#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_GAME_PRINTER (game_printer_get_type ())
#define GAME_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_PRINTER, GamePrinter))
#define GAME_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_PRINTER, GamePrinterClass))
#define IS_GAME_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_PRINTER))
#define IS_GAME_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_PRINTER))
#define GAME_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_PRINTER, GamePrinterClass))

typedef struct _GamePrinter GamePrinter;
typedef struct _GamePrinterClass GamePrinterClass;

struct _Sudoku {
	GtkApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	GtkApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	gboolean is_maximized;
	gint window_width;
	gint window_height;
	GtkApplicationWindow* window;
	SudokuGame* game;
	SudokuView* view;
	GtkHeaderBar* header_bar;
	GtkStack* main_stack;
	GtkBox* game_box;
	GtkBox* undo_redo_box;
	GtkButton* back_button;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	gchar* header_bar_subtitle;
	gboolean show_possibilities;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	SudokuBoard* board;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};


static gpointer sudoku_parent_class = NULL;

GType sudoku_get_type (void) G_GNUC_CONST;
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU, SudokuPrivate))
enum  {
	SUDOKU_DUMMY_PROPERTY
};
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Sudoku* sudoku_new (void);
Sudoku* sudoku_construct (GType object_type);
static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options);
static void sudoku_real_startup (GApplication* base);
static void __lambda21_ (Sudoku* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean sudoku_window_configure_event_cb (Sudoku* self, GdkEventConfigure* event);
static gboolean _sudoku_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event);
static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void sudoku_start_game (Sudoku* self, SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void __lambda14_ (Sudoku* self);
static void ___lambda14__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static void __lambda15_ (Block1Data* _data1_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda16_ (Block2Data* _data2_, gint response_id);
static void ___lambda16__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void ___lambda15__sudoku_board_completed (SudokuBoard* _sender, gpointer self);
static void __lambda13_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda17_ (Block3Data* _data3_, gint response_id);
void sudoku_view_clear (SudokuView* self);
static void ___lambda17__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (SudokuBoard** boards, int boards_length1, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, SudokuBoard** boards, int boards_length1, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
GType game_printer_get_type (void) G_GNUC_CONST;
GamePrinter* game_printer_new (SudokuSaver* saver, GtkApplicationWindow** window);
GamePrinter* game_printer_construct (GType object_type, SudokuSaver* saver, GtkApplicationWindow** window);
void game_printer_run_dialog (GamePrinter* self);
static void __lambda20_ (Sudoku* self, GamePrinter* p);
static void ___lambda20__game_printer_game_printer_closed (GamePrinter* _sender, gpointer self);
gint sudoku_main (gchar** args, int args_length1);
static void sudoku_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry SUDOKU_action_entries[11] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {"show-possible-values", 's', 0, G_OPTION_ARG_NONE, NULL, "Show the possible values for each cell", NULL}, {NULL}};
static const gchar* SUDOKU_authors[6] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", NULL};

static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_new_game_cb ((Sudoku*) self);
}


static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
}


static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_reset_cb ((Sudoku*) self);
}


static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_back_cb ((Sudoku*) self);
}


static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_undo_cb ((Sudoku*) self);
}


static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_redo_cb ((Sudoku*) self);
}


static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_print_cb ((Sudoku*) self);
}


static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_print_multiple_cb ((Sudoku*) self);
}


static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_help_cb ((Sudoku*) self);
}


static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_about_cb ((Sudoku*) self);
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	g_application_quit ((GApplication*) self);
}


Sudoku* sudoku_construct (GType object_type) {
	Sudoku * self = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
	return self;
}


Sudoku* sudoku_new (void) {
	return sudoku_construct (TYPE_SUDOKU);
}


static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Sudoku * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (Sudoku*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "gnome-sudoku %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	_tmp3_ = options;
	_tmp4_ = g_variant_dict_contains (_tmp3_, "show-possible-values");
	if (_tmp4_) {
		self->priv->show_possibilities = TRUE;
	}
	result = -1;
	return result;
}


static void __lambda21_ (Sudoku* self) {
	SudokuView* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->view;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_boolean (_tmp1_, "show-warnings");
	sudoku_view_set_show_warnings (_tmp0_, _tmp2_);
}


static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda21_ ((Sudoku*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _sudoku_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = sudoku_window_configure_event_cb ((Sudoku*) self, event);
	return result;
}


static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = sudoku_window_state_event_cb ((Sudoku*) self, event);
	return result;
}


static void sudoku_real_startup (GApplication* base) {
	Sudoku * self;
	GSettings* _tmp0_ = NULL;
	GAction* action = NULL;
	GSettings* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp24_ = NULL;
	GdkScreen* _tmp30_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp31_ = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GObject* _tmp33_ = NULL;
	GtkApplicationWindow* _tmp34_ = NULL;
	GtkApplicationWindow* _tmp35_ = NULL;
	GtkApplicationWindow* _tmp36_ = NULL;
	GtkApplicationWindow* _tmp37_ = NULL;
	GSettings* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	GSettings* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	GSettings* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	GtkApplicationWindow* _tmp45_ = NULL;
	GtkBuilder* _tmp46_ = NULL;
	GObject* _tmp47_ = NULL;
	GtkHeaderBar* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	GObject* _tmp50_ = NULL;
	GtkStack* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkBox* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkButton* _tmp60_ = NULL;
	GAction* _tmp61_ = NULL;
	GSimpleAction* _tmp62_ = NULL;
	GAction* _tmp63_ = NULL;
	GSimpleAction* _tmp64_ = NULL;
	GAction* _tmp65_ = NULL;
	GSimpleAction* _tmp66_ = NULL;
	GAction* _tmp67_ = NULL;
	GSimpleAction* _tmp68_ = NULL;
	GAction* _tmp69_ = NULL;
	GSimpleAction* _tmp70_ = NULL;
	SudokuSaver* _tmp71_ = NULL;
	SudokuGame* savegame = NULL;
	SudokuSaver* _tmp72_ = NULL;
	SudokuGame* _tmp73_ = NULL;
	SudokuGame* _tmp74_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Sudoku*) base;
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, G_N_ELEMENTS (SUDOKU_action_entries), self);
	_tmp0_ = g_settings_new ("org.gnome.sudoku");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
	action = _tmp2_;
	g_signal_connect_object ((GObject*) action, "notify::state", (GCallback) ___lambda21__g_object_notify, self, 0);
	g_action_map_add_action ((GActionMap*) self, action);
	_tmp3_ = g_strdup ("<Primary>n");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("<Primary>p");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp8_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_strdup ("<Primary>q");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<Primary>r");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("<Primary>z");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = g_strdup ("<Primary><Shift>z");
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp20_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_tmp21_ = g_strdup ("F1");
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp23_);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	gtk_window_set_default_icon_name ("gnome-sudoku");
	_tmp24_ = gtk_css_provider_new ();
	css_provider = _tmp24_;
	{
		gchar* data = NULL;
		gchar* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		_tmp25_ = g_strdup ("GtkButtonBox { -GtkButtonBox-child-internal-pad-x:0; }\n" \
"                          GtkBox#start_box { margin:0 80px 0 80px; }");
		data = _tmp25_;
		_tmp26_ = strlen (data);
		_tmp27_ = _tmp26_;
		gtk_css_provider_load_from_data (css_provider, data, (gssize) _tmp27_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (data);
			goto __catch0_g_error;
		}
		_g_free0 (data);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_warning ("gnome-sudoku.vala:123: Error loading css styles: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (css_provider);
		_g_object_unref0 (action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp30_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp30_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp31_ = gtk_builder_new_from_resource ("/org/gnome/sudoku/ui/gnome-sudoku.ui");
	builder = _tmp31_;
	_tmp32_ = builder;
	_tmp33_ = gtk_builder_get_object (_tmp32_, "sudoku_app");
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_application_window_get_type (), GtkApplicationWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp34_;
	_tmp35_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp35_, "configure-event", (GCallback) _sudoku_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp36_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp36_, "window-state-event", (GCallback) _sudoku_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp37_ = self->priv->window;
	_tmp38_ = self->priv->settings;
	_tmp39_ = g_settings_get_int (_tmp38_, "window-width");
	_tmp40_ = self->priv->settings;
	_tmp41_ = g_settings_get_int (_tmp40_, "window-height");
	gtk_window_set_default_size ((GtkWindow*) _tmp37_, _tmp39_, _tmp41_);
	_tmp42_ = self->priv->settings;
	_tmp43_ = g_settings_get_boolean (_tmp42_, "window-is-maximized");
	if (_tmp43_) {
		GtkApplicationWindow* _tmp44_ = NULL;
		_tmp44_ = self->priv->window;
		gtk_window_maximize ((GtkWindow*) _tmp44_);
	}
	_tmp45_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp45_);
	_tmp46_ = builder;
	_tmp47_ = gtk_builder_get_object (_tmp46_, "headerbar");
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_header_bar_get_type (), GtkHeaderBar));
	_g_object_unref0 (self->priv->header_bar);
	self->priv->header_bar = _tmp48_;
	_tmp49_ = builder;
	_tmp50_ = gtk_builder_get_object (_tmp49_, "main_stack");
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->main_stack);
	self->priv->main_stack = _tmp51_;
	_tmp52_ = builder;
	_tmp53_ = gtk_builder_get_object (_tmp52_, "game_box");
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->game_box);
	self->priv->game_box = _tmp54_;
	_tmp55_ = builder;
	_tmp56_ = gtk_builder_get_object (_tmp55_, "undo_redo_box");
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->undo_redo_box);
	self->priv->undo_redo_box = _tmp57_;
	_tmp58_ = builder;
	_tmp59_ = gtk_builder_get_object (_tmp58_, "back_button");
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->back_button);
	self->priv->back_button = _tmp60_;
	_tmp61_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp62_;
	_tmp63_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp64_;
	_tmp65_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->clear_action);
	self->priv->clear_action = _tmp66_;
	_tmp67_ = g_action_map_lookup_action ((GActionMap*) self, "print");
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->print_action);
	self->priv->print_action = _tmp68_;
	_tmp69_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->print_multiple_action);
	self->priv->print_multiple_action = _tmp70_;
	_tmp71_ = sudoku_saver_new ();
	_g_object_unref0 (self->priv->saver);
	self->priv->saver = _tmp71_;
	_tmp72_ = self->priv->saver;
	_tmp73_ = sudoku_saver_get_savedgame (_tmp72_);
	savegame = _tmp73_;
	_tmp74_ = savegame;
	if (_tmp74_ != NULL) {
		SudokuGame* _tmp75_ = NULL;
		SudokuBoard* _tmp76_ = NULL;
		_tmp75_ = savegame;
		_tmp76_ = _tmp75_->board;
		sudoku_start_game (self, _tmp76_);
	} else {
		sudoku_show_new_game_screen (self);
	}
	_g_object_unref0 (savegame);
	_g_object_unref0 (builder);
	_g_object_unref0 (css_provider);
	_g_object_unref0 (action);
}


static void sudoku_real_activate (GApplication* base) {
	Sudoku * self;
	GtkApplicationWindow* _tmp0_ = NULL;
	self = (Sudoku*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void sudoku_real_shutdown (GApplication* base) {
	Sudoku * self;
	SudokuGame* _tmp0_ = NULL;
	GSettings* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	GSettings* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (Sudoku*) base;
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp11_ = FALSE;
		SudokuGame* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp2_ = self->priv->game;
		_tmp3_ = _tmp2_->board;
		_tmp4_ = sudoku_board_is_empty (_tmp3_);
		if (!_tmp4_) {
			SudokuGame* _tmp5_ = NULL;
			SudokuBoard* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			_tmp5_ = self->priv->game;
			_tmp6_ = _tmp5_->board;
			_tmp7_ = sudoku_board_get_complete (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp1_ = !_tmp8_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			SudokuSaver* _tmp9_ = NULL;
			SudokuGame* _tmp10_ = NULL;
			_tmp9_ = self->priv->saver;
			_tmp10_ = self->priv->game;
			sudoku_saver_save_game (_tmp9_, _tmp10_);
		}
		_tmp12_ = self->priv->game;
		_tmp13_ = _tmp12_->board;
		_tmp14_ = sudoku_board_is_empty (_tmp13_);
		if (_tmp14_) {
			SudokuSaver* _tmp15_ = NULL;
			SudokuGame* _tmp16_ = NULL;
			SudokuGame* _tmp17_ = NULL;
			_tmp15_ = self->priv->saver;
			_tmp16_ = sudoku_saver_get_savedgame (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp11_ = _tmp17_ != NULL;
			_g_object_unref0 (_tmp17_);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			GFile* file = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GFile* _tmp20_ = NULL;
			_tmp18_ = sudoku_saver_get_savegame_file ();
			_tmp19_ = _tmp18_;
			_tmp20_ = g_file_new_for_path (_tmp19_);
			file = _tmp20_;
			{
				GFile* _tmp21_ = NULL;
				_tmp21_ = file;
				g_file_delete (_tmp21_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp22_ = e;
				_tmp23_ = _tmp22_->message;
				g_warning ("gnome-sudoku.vala:180: Failed to delete saved game: %s", _tmp23_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (file);
		}
	}
	_tmp24_ = self->priv->settings;
	_tmp25_ = self->priv->window_width;
	g_settings_set_int (_tmp24_, "window-width", _tmp25_);
	_tmp26_ = self->priv->settings;
	_tmp27_ = self->priv->window_height;
	g_settings_set_int (_tmp26_, "window-height", _tmp27_);
	_tmp28_ = self->priv->settings;
	_tmp29_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp28_, "window-is-maximized", _tmp29_);
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}


static gboolean sudoku_window_configure_event_cb (Sudoku* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->is_maximized;
	if (!_tmp0_) {
		GdkEventConfigure* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp1_ = event;
		_tmp2_ = _tmp1_->width;
		self->priv->window_width = _tmp2_;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->height;
		self->priv->window_height = _tmp4_;
	}
	result = FALSE;
	return result;
}


static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Sudoku* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->board);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda14_ (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	_tmp0_ = self->priv->undo_action;
	_tmp1_ = self->priv->game;
	_tmp2_ = sudoku_game_is_undostack_null (_tmp1_);
	g_simple_action_set_enabled (_tmp0_, !_tmp2_);
	_tmp3_ = self->priv->redo_action;
	_tmp4_ = self->priv->game;
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
	_tmp6_ = self->priv->clear_action;
	_tmp7_ = self->priv->game;
	_tmp8_ = _tmp7_->board;
	_tmp9_ = sudoku_board_is_empty (_tmp8_);
	g_simple_action_set_enabled (_tmp6_, !_tmp9_);
}


static void ___lambda14__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
	__lambda14_ ((Sudoku*) self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Sudoku* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->dialog);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda16_ (Block2Data* _data2_, gint response_id) {
	Block1Data* _data1_;
	Sudoku* self;
	gint _tmp0_ = 0;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = response_id;
	switch (_tmp0_) {
		case 0:
		{
			SudokuBoard* _tmp1_ = NULL;
			DifficultyCategory _tmp2_ = 0;
			DifficultyCategory _tmp3_ = 0;
			SudokuBoard* _tmp4_ = NULL;
			SudokuBoard* _tmp5_ = NULL;
			_tmp1_ = _data1_->board;
			_tmp2_ = sudoku_board_get_difficulty_category (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = sudoku_generator_generate_board (_tmp3_);
			_tmp5_ = _tmp4_;
			sudoku_start_game (self, _tmp5_);
			_g_object_unref0 (_tmp5_);
			break;
		}
		case 1:
		{
			sudoku_show_new_game_screen (self);
			break;
		}
		default:
		break;
	}
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
}


static void ___lambda16__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda16_ (self, response_id);
}


static void __lambda15_ (Block1Data* _data1_) {
	Sudoku* self;
	Block2Data* _data2_;
	SudokuSaver* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	gint minutes = 0;
	SudokuGame* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
	gint _tmp19_ = 0;
	gchar* time_str = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkApplicationWindow* _tmp22_ = NULL;
	GtkMessageDialog* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	self = _data1_->self;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->_data1_ = block1_data_ref (_data1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->game;
				_tmp4_ = _tmp3_->board;
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuView* _tmp14_ = NULL;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = j;
							_tmp10_ = self->priv->game;
							_tmp11_ = _tmp10_->board;
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(_tmp9_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->view;
							g_object_set ((GtkWidget*) _tmp14_, "can-focus", FALSE, NULL);
						}
					}
				}
			}
		}
	}
	_tmp15_ = self->priv->saver;
	_tmp16_ = self->priv->game;
	sudoku_saver_add_game_to_finished (_tmp15_, _tmp16_, TRUE);
	_tmp17_ = self->priv->game;
	_tmp18_ = sudoku_game_get_total_time_played (_tmp17_);
	_tmp19_ = MAX (1, ((gint) _tmp18_) / 60);
	minutes = _tmp19_;
	_tmp20_ = ngettext ("Well done, you completed the puzzle in %d minute", "Well done, you completed the puzzle in %d minutes", (gulong) minutes);
	_tmp21_ = g_strdup_printf (_tmp20_, minutes);
	time_str = _tmp21_;
	_tmp22_ = self->priv->window;
	_tmp23_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp22_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, time_str);
	g_object_ref_sink (_tmp23_);
	_data2_->dialog = _tmp23_;
	_tmp24_ = _ ("Same difficulty again");
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _tmp24_, 0);
	_tmp25_ = _ ("New difficulty");
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _tmp25_, 1);
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda16__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
	_g_free0 (time_str);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void ___lambda15__sudoku_board_completed (SudokuBoard* _sender, gpointer self) {
	__lambda15_ (self);
}


static void sudoku_start_game (Sudoku* self, SudokuBoard* board) {
	Block1Data* _data1_;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuView* _tmp4_ = NULL;
	SudokuBoard* _tmp7_ = NULL;
	DifficultyCategory _tmp8_ = 0;
	DifficultyCategory _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	SudokuBoard* _tmp11_ = NULL;
	SudokuGame* _tmp12_ = NULL;
	SudokuGame* _tmp13_ = NULL;
	GTimer* _tmp14_ = NULL;
	SudokuGame* _tmp15_ = NULL;
	SudokuView* _tmp16_ = NULL;
	SudokuView* _tmp17_ = NULL;
	SudokuView* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	SudokuView* _tmp20_ = NULL;
	GSettings* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	SudokuView* _tmp23_ = NULL;
	GtkBox* _tmp24_ = NULL;
	SudokuView* _tmp25_ = NULL;
	SudokuGame* _tmp26_ = NULL;
	SudokuGame* _tmp27_ = NULL;
	SudokuBoard* _tmp28_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = board;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data1_->board);
	_data1_->board = _tmp1_;
	_tmp2_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_tmp4_ = self->priv->view;
	if (_tmp4_ != NULL) {
		GtkBox* _tmp5_ = NULL;
		SudokuView* _tmp6_ = NULL;
		_tmp5_ = self->priv->game_box;
		_tmp6_ = self->priv->view;
		gtk_container_remove ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	}
	_tmp7_ = _data1_->board;
	_tmp8_ = sudoku_board_get_difficulty_category (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = difficulty_category_to_string (_tmp9_);
	_g_free0 (self->priv->header_bar_subtitle);
	self->priv->header_bar_subtitle = _tmp10_;
	_tmp11_ = _data1_->board;
	_tmp12_ = sudoku_game_new (_tmp11_);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp12_;
	sudoku_back_cb (self);
	_tmp13_ = self->priv->game;
	_tmp14_ = _tmp13_->timer;
	g_timer_start (_tmp14_);
	_tmp15_ = self->priv->game;
	_tmp16_ = sudoku_view_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp16_;
	_tmp17_ = self->priv->view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp17_, 480, 480);
	_tmp18_ = self->priv->view;
	_tmp19_ = self->priv->show_possibilities;
	sudoku_view_set_show_possibilities (_tmp18_, _tmp19_);
	_tmp20_ = self->priv->view;
	_tmp21_ = self->priv->settings;
	_tmp22_ = g_settings_get_boolean (_tmp21_, "show-warnings");
	sudoku_view_set_show_warnings (_tmp20_, _tmp22_);
	_tmp23_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->game_box;
	_tmp25_ = self->priv->view;
	gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, TRUE, TRUE, (guint) 0);
	_tmp26_ = self->priv->game;
	g_signal_connect_object (_tmp26_, "cell-changed", (GCallback) ___lambda14__sudoku_game_cell_changed, self, 0);
	_tmp27_ = self->priv->game;
	_tmp28_ = _tmp27_->board;
	g_signal_connect_data (_tmp28_, "completed", (GCallback) ___lambda15__sudoku_board_completed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void sudoku_show_new_game_screen (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	SudokuGame* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkHeaderBar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkHeaderBar* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "start_box");
	_tmp1_ = self->priv->clear_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->back_button;
	_tmp3_ = self->priv->game;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _tmp3_ != NULL);
	_tmp4_ = self->priv->undo_redo_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, FALSE);
	_tmp5_ = self->priv->header_bar;
	_tmp6_ = gtk_header_bar_get_subtitle (_tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->header_bar_subtitle);
	self->priv->header_bar_subtitle = _tmp7_;
	_tmp8_ = self->priv->header_bar;
	gtk_header_bar_set_subtitle (_tmp8_, NULL);
	_tmp9_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp9_, FALSE);
}


static void sudoku_new_game_cb (Sudoku* self) {
	g_return_if_fail (self != NULL);
	sudoku_show_new_game_screen (self);
}


static void __lambda13_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SudokuBoard** gen_boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		SudokuBoard** _tmp2_ = NULL;
		gint gen_boards_length1 = 0;
		gint _gen_boards_size_ = 0;
		GtkButton* _tmp3_ = NULL;
		SudokuBoard* _tmp4_ = NULL;
		_tmp0_ = res;
		_tmp2_ = sudoku_generator_generate_boards_finish (_tmp0_, &_tmp1_, &_inner_error_);
		gen_boards = _tmp2_;
		gen_boards_length1 = _tmp1_;
		_gen_boards_size_ = gen_boards_length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch2_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->back_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
		_tmp4_ = gen_boards[0];
		sudoku_start_game (self, _tmp4_);
		gen_boards = (_vala_array_free (gen_boards, gen_boards_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	goto __finally2;
	__catch2_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e->message;
		g_error ("gnome-sudoku.vala:307: Thread error: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda13_ ((Sudoku*) self, source_object, res);
	g_object_unref (self);
}


static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty) {
	DifficultyCategory selected_difficulty = 0;
	GVariant* _tmp0_ = NULL;
	gint32 _tmp1_ = 0;
	GtkButton* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = difficulty;
	_tmp1_ = g_variant_get_int32 (_tmp0_);
	selected_difficulty = (DifficultyCategory) _tmp1_;
	_tmp2_ = self->priv->back_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	sudoku_generator_generate_boards_async (1, selected_difficulty, ___lambda13__gasync_ready_callback, g_object_ref (self));
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Sudoku* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda17_ (Block3Data* _data3_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
	self = _data3_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		SudokuView* _tmp1_ = NULL;
		SudokuGame* _tmp2_ = NULL;
		GSimpleAction* _tmp3_ = NULL;
		GSimpleAction* _tmp4_ = NULL;
		_tmp1_ = self->priv->view;
		sudoku_view_clear (_tmp1_);
		_tmp2_ = self->priv->game;
		sudoku_game_reset (_tmp2_);
		_tmp3_ = self->priv->undo_action;
		g_simple_action_set_enabled (_tmp3_, FALSE);
		_tmp4_ = self->priv->redo_action;
		g_simple_action_set_enabled (_tmp4_, FALSE);
	}
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
}


static void ___lambda17__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda17_ (self, response_id);
}


static void sudoku_reset_cb (Sudoku* self) {
	Block3Data* _data3_;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->window;
	_tmp1_ = _ ("Reset the board to its original state?");
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_data3_->dialog = _tmp2_;
	g_signal_connect_data ((GtkDialog*) _data3_->dialog, "response", (GCallback) ___lambda17__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data3_->dialog);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void sudoku_back_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkButton* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkHeaderBar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
	_tmp1_ = self->priv->clear_action;
	_tmp2_ = self->priv->game;
	_tmp3_ = _tmp2_->board;
	_tmp4_ = sudoku_board_is_empty (_tmp3_);
	g_simple_action_set_enabled (_tmp1_, !_tmp4_);
	_tmp5_ = self->priv->back_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
	_tmp6_ = self->priv->undo_redo_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->header_bar;
	_tmp8_ = self->priv->header_bar_subtitle;
	gtk_header_bar_set_subtitle (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp9_, TRUE);
}


static void sudoku_undo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
		return;
	}
	_tmp2_ = self->priv->game;
	sudoku_game_undo (_tmp2_);
	_tmp3_ = self->priv->undo_action;
	_tmp4_ = self->priv->game;
	_tmp5_ = sudoku_game_is_undostack_null (_tmp4_);
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
	_tmp6_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
}


static void sudoku_redo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
		return;
	}
	_tmp2_ = self->priv->game;
	sudoku_game_redo (_tmp2_);
	_tmp3_ = self->priv->redo_action;
	_tmp4_ = self->priv->game;
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
	_tmp6_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
}


static void sudoku_print_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuPrinter* printer = NULL;
	SudokuGame* _tmp4_ = NULL;
	SudokuBoard* _tmp5_ = NULL;
	SudokuBoard* _tmp6_ = NULL;
	SudokuBoard** _tmp7_ = NULL;
	SudokuBoard** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GtkApplicationWindow* _tmp9_ = NULL;
	SudokuPrinter* _tmp10_ = NULL;
	SudokuPrinter* _tmp11_ = NULL;
	SudokuPrinter* _tmp12_ = NULL;
	GSimpleAction* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
		return;
	}
	_tmp2_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_tmp4_ = self->priv->game;
	_tmp5_ = _tmp4_->board;
	_tmp6_ = sudoku_board_clone (_tmp5_);
	_tmp7_ = g_new0 (SudokuBoard*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	_tmp9_ = self->priv->window;
	_tmp10_ = sudoku_printer_new (_tmp8_, 1, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_window_get_type (), GtkWindow));
	_tmp11_ = _tmp10_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_object_unref), NULL);
	printer = _tmp11_;
	_tmp12_ = printer;
	sudoku_printer_print_sudoku (_tmp12_);
	_tmp13_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp13_, TRUE);
	_tmp14_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp14_, TRUE);
	_g_object_unref0 (printer);
}


static void __lambda20_ (Sudoku* self, GamePrinter* p) {
	GSimpleAction* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->print_action;
	_tmp1_ = self->priv->main_stack;
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
	g_simple_action_set_enabled (_tmp0_, g_strcmp0 (_tmp2_, "frame") == 0);
	_tmp3_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
}


static void ___lambda20__game_printer_game_printer_closed (GamePrinter* _sender, gpointer self) {
	__lambda20_ ((Sudoku*) self, _sender);
}


static void sudoku_print_multiple_cb (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GamePrinter* printer = NULL;
	SudokuSaver* _tmp2_ = NULL;
	GamePrinter* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->saver;
	_tmp3_ = game_printer_new (_tmp2_, &self->priv->window);
	printer = _tmp3_;
	game_printer_run_dialog (printer);
	g_signal_connect_object (printer, "game-printer-closed", (GCallback) ___lambda20__game_printer_game_printer_closed, self, 0);
	_g_object_unref0 (printer);
}


static void sudoku_help_cb (Sudoku* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-sudoku", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-sudoku.vala:390: Unable to open help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void sudoku_about_cb (Sudoku* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = _ ("Sudoku");
	_tmp2_ = sudoku_generator_qqwing_version ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _ (_tmp5_);
	_tmp7_ = _ ("translator-credits");
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _tmp1_, "logo-icon-name", "gnome-sudoku", "version", VERSION, "comments", _tmp6_, "copyright", "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha", "license-type", GTK_LICENSE_GPL_2_0, "authors", SUDOKU_authors, "artists", NULL, "translator-credits", _tmp7_, "website", "https://wiki.gnome.org/Apps/Sudoku/", NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}


gint sudoku_main (gchar** args, int args_length1) {
	gint result = 0;
	Sudoku* _tmp0_ = NULL;
	Sudoku* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	_tmp0_ = sudoku_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return sudoku_main (argv, argc);
}


static void sudoku_class_init (SudokuClass * klass) {
	sudoku_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuPrivate));
	((GApplicationClass *) klass)->handle_local_options = sudoku_real_handle_local_options;
	((GApplicationClass *) klass)->startup = sudoku_real_startup;
	((GApplicationClass *) klass)->activate = sudoku_real_activate;
	((GApplicationClass *) klass)->shutdown = sudoku_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
}


static void sudoku_instance_init (Sudoku * self) {
	self->priv = SUDOKU_GET_PRIVATE (self);
	self->priv->show_possibilities = FALSE;
}


static void sudoku_finalize (GObject* obj) {
	Sudoku * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->header_bar);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->game_box);
	_g_object_unref0 (self->priv->undo_redo_box);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->redo_action);
	_g_object_unref0 (self->priv->clear_action);
	_g_object_unref0 (self->priv->print_action);
	_g_object_unref0 (self->priv->print_multiple_action);
	_g_free0 (self->priv->header_bar_subtitle);
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
}


GType sudoku_get_type (void) {
	static volatile gsize sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
		GType sudoku_type_id;
		sudoku_type_id = g_type_register_static (gtk_application_get_type (), "Sudoku", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_type_id__volatile, sudoku_type_id);
	}
	return sudoku_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



