/* chess-scene.c generated by valac 0.25.3.3-7022, the Vala compiler
 * generated from chess-scene.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include "libchess.h"
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
typedef struct _ChessScenePrivate ChessScenePrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ChessModel {
	GObject parent_instance;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GObjectClass parent_class;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessScenePrivate {
	gboolean _can_move[64];
	GTimer* animation_timer;
	gdouble animation_time;
	guint animate_timeout_id;
	ChessGame* _game;
	gint _move_number;
	gboolean _show_numbering;
	gboolean _show_move_hints;
	gchar* _theme_name;
	gboolean _show_3d_smooth;
	gchar* _board_side;
	gchar* _move_format;
};


static gpointer chess_model_parent_class = NULL;
static gpointer chess_scene_parent_class = NULL;

GType chess_model_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_MODEL_DUMMY_PROPERTY,
	CHESS_MODEL_MOVING
};
ChessModel* chess_model_new (ChessPiece* piece, gdouble x, gdouble y);
ChessModel* chess_model_construct (GType object_type, ChessPiece* piece, gdouble x, gdouble y);
gboolean chess_model_move_to (ChessModel* self, gdouble x, gdouble y);
gboolean chess_model_animate (ChessModel* self, gdouble timestep);
gboolean chess_model_get_moving (ChessModel* self);
static gdouble chess_model_update_position (ChessModel* self, gdouble timestep, gdouble value, gdouble target);
static void chess_model_finalize (GObject* obj);
static void _vala_chess_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType chess_scene_get_type (void) G_GNUC_CONST;
#define CHESS_SCENE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_SCENE, ChessScenePrivate))
enum  {
	CHESS_SCENE_DUMMY_PROPERTY,
	CHESS_SCENE_GAME,
	CHESS_SCENE_MOVE_NUMBER,
	CHESS_SCENE_SHOW_NUMBERING,
	CHESS_SCENE_SHOW_MOVE_HINTS,
	CHESS_SCENE_THEME_NAME,
	CHESS_SCENE_SHOW_3D_SMOOTH,
	CHESS_SCENE_BOARD_SIDE,
	CHESS_SCENE_BOARD_ANGLE,
	CHESS_SCENE_MOVE_FORMAT
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
ChessGame* chess_scene_get_game (ChessScene* self);
gint chess_scene_get_move_number (ChessScene* self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static void chess_scene_update_board (ChessScene* self);
static void chess_scene_moved_cb (ChessScene* self, ChessGame* game, ChessMove* move);
static void chess_scene_paused_cb (ChessScene* self, ChessGame* game);
static void chess_scene_unpaused_cb (ChessScene* self, ChessGame* game);
static void chess_scene_undo_cb (ChessScene* self, ChessGame* game);
static ChessModel* chess_scene_find_model (ChessScene* self, ChessPiece* piece);
static gboolean chess_scene_animate_cb (ChessScene* self);
static gboolean _chess_scene_animate_cb_gsource_func (gpointer self);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void _chess_scene_moved_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void _chess_scene_paused_cb_chess_game_paused (ChessGame* _sender, gpointer self);
static void _chess_scene_unpaused_cb_chess_game_unpaused (ChessGame* _sender, gpointer self);
static void _chess_scene_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
void chess_scene_set_move_number (ChessScene* self, gint value);
gboolean chess_scene_get_show_numbering (ChessScene* self);
void chess_scene_set_show_numbering (ChessScene* self, gboolean value);
gboolean chess_scene_get_show_move_hints (ChessScene* self);
void chess_scene_set_show_move_hints (ChessScene* self, gboolean value);
const gchar* chess_scene_get_theme_name (ChessScene* self);
void chess_scene_set_theme_name (ChessScene* self, const gchar* value);
gboolean chess_scene_get_show_3d_smooth (ChessScene* self);
void chess_scene_set_show_3d_smooth (ChessScene* self, gboolean value);
const gchar* chess_scene_get_board_side (ChessScene* self);
void chess_scene_set_board_side (ChessScene* self, const gchar* value);
gdouble chess_scene_get_board_angle (ChessScene* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
void chess_scene_set_move_format (ChessScene* self, const gchar* value);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_ENUM__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_scene_finalize (GObject* obj);
static void _vala_chess_scene_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_scene_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ChessModel* chess_model_construct (GType object_type, ChessPiece* piece, gdouble x, gdouble y) {
	ChessModel * self = NULL;
	ChessPiece* _tmp0_ = NULL;
	ChessPiece* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_val_if_fail (piece != NULL, NULL);
	self = (ChessModel*) g_object_new (object_type, NULL);
	_tmp0_ = piece;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->piece);
	self->piece = _tmp1_;
	_tmp2_ = x;
	self->target_x = _tmp2_;
	_tmp3_ = self->target_x;
	self->x = _tmp3_;
	_tmp4_ = y;
	self->target_y = _tmp4_;
	_tmp5_ = self->target_y;
	self->y = _tmp5_;
	return self;
}


ChessModel* chess_model_new (ChessPiece* piece, gdouble x, gdouble y) {
	return chess_model_construct (TYPE_CHESS_MODEL, piece, x, y);
}


gboolean chess_model_move_to (ChessModel* self, gdouble x, gdouble y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->target_x;
	_tmp2_ = x;
	if (_tmp1_ == _tmp2_) {
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		_tmp3_ = self->target_y;
		_tmp4_ = y;
		_tmp0_ = _tmp3_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = x;
	self->target_x = _tmp5_;
	_tmp6_ = y;
	self->target_y = _tmp6_;
	result = TRUE;
	return result;
}


gboolean chess_model_animate (ChessModel* self, gdouble timestep) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = chess_model_get_moving (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = timestep;
	_tmp3_ = self->x;
	_tmp4_ = self->target_x;
	_tmp5_ = chess_model_update_position (self, _tmp2_, _tmp3_, _tmp4_);
	self->x = _tmp5_;
	_tmp6_ = timestep;
	_tmp7_ = self->y;
	_tmp8_ = self->target_y;
	_tmp9_ = chess_model_update_position (self, _tmp6_, _tmp7_, _tmp8_);
	self->y = _tmp9_;
	result = TRUE;
	return result;
}


static gdouble chess_model_update_position (ChessModel* self, gdouble timestep, gdouble value, gdouble target) {
	gdouble result = 0.0;
	gdouble distance = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble step = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = target;
	_tmp1_ = value;
	_tmp2_ = fabs (_tmp0_ - _tmp1_);
	distance = _tmp2_;
	_tmp3_ = timestep;
	step = _tmp3_ * 4.0;
	_tmp4_ = step;
	_tmp5_ = distance;
	if (_tmp4_ > _tmp5_) {
		gdouble _tmp6_ = 0.0;
		_tmp6_ = distance;
		step = _tmp6_;
	}
	_tmp7_ = target;
	_tmp8_ = value;
	if (_tmp7_ > _tmp8_) {
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		_tmp9_ = value;
		_tmp10_ = step;
		result = _tmp9_ + _tmp10_;
		return result;
	} else {
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		_tmp11_ = value;
		_tmp12_ = step;
		result = _tmp11_ - _tmp12_;
		return result;
	}
}


gboolean chess_model_get_moving (ChessModel* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->x;
	_tmp2_ = self->target_x;
	if (_tmp1_ != _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		_tmp3_ = self->y;
		_tmp4_ = self->target_y;
		_tmp0_ = _tmp3_ != _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static void chess_model_class_init (ChessModelClass * klass) {
	chess_model_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_model_get_property;
	G_OBJECT_CLASS (klass)->finalize = chess_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_MODEL_MOVING, g_param_spec_boolean ("moving", "moving", "moving", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void chess_model_instance_init (ChessModel * self) {
}


static void chess_model_finalize (GObject* obj) {
	ChessModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_MODEL, ChessModel);
	_g_object_unref0 (self->piece);
	G_OBJECT_CLASS (chess_model_parent_class)->finalize (obj);
}


GType chess_model_get_type (void) {
	static volatile gsize chess_model_type_id__volatile = 0;
	if (g_once_init_enter (&chess_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessModel), 0, (GInstanceInitFunc) chess_model_instance_init, NULL };
		GType chess_model_type_id;
		chess_model_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessModel", &g_define_type_info, 0);
		g_once_init_leave (&chess_model_type_id__volatile, chess_model_type_id);
	}
	return chess_model_type_id__volatile;
}


static void _vala_chess_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_MODEL, ChessModel);
	switch (property_id) {
		case CHESS_MODEL_MOVING:
		g_value_set_boolean (value, chess_model_get_moving (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


ChessPiece* chess_scene_get_selected_piece (ChessScene* self) {
	ChessPiece* result = NULL;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessGame* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	ChessPiece* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = chess_scene_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp3_ = 0;
		_tmp3_ = self->selected_rank;
		_tmp0_ = _tmp3_ < 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp4_ = chess_scene_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->selected_rank;
	_tmp7_ = self->selected_file;
	_tmp8_ = chess_scene_get_move_number (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = chess_game_get_piece (_tmp5_, _tmp6_, _tmp7_, _tmp9_);
	result = _tmp10_;
	return result;
}


ChessScene* chess_scene_construct (GType object_type) {
	ChessScene * self = NULL;
	GTimer* _tmp0_ = NULL;
	self = (ChessScene*) g_object_new (object_type, NULL);
	_tmp0_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->animation_timer);
	self->priv->animation_timer = _tmp0_;
	return self;
}


ChessScene* chess_scene_new (void) {
	return chess_scene_construct (TYPE_CHESS_SCENE);
}


void chess_scene_select_square (ChessScene* self, gint file, gint rank) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	ChessPiece* piece = NULL;
	ChessGame* _tmp11_ = NULL;
	ChessGame* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	ChessPiece* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = chess_scene_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ChessGame* _tmp3_ = NULL;
		ChessGame* _tmp4_ = NULL;
		ChessPlayer* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = chess_scene_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = chess_game_get_current_player (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = chess_player_get_local_human (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = !_tmp8_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp9_ = chess_scene_get_move_number (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != (-1)) {
		return;
	}
	_tmp11_ = chess_scene_get_game (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = rank;
	_tmp14_ = file;
	_tmp15_ = chess_scene_get_move_number (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = chess_game_get_piece (_tmp12_, _tmp13_, _tmp14_, _tmp16_);
	piece = _tmp17_;
	_tmp19_ = file;
	_tmp20_ = self->selected_file;
	if (_tmp19_ == _tmp20_) {
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		_tmp21_ = rank;
		_tmp22_ = self->selected_rank;
		_tmp18_ = _tmp21_ == _tmp22_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gint _tmp23_ = 0;
		self->selected_file = -1;
		_tmp23_ = self->selected_file;
		self->selected_rank = _tmp23_;
	} else {
		gboolean _tmp24_ = FALSE;
		ChessPiece* _tmp25_ = NULL;
		_tmp25_ = piece;
		if (_tmp25_ != NULL) {
			ChessPiece* _tmp26_ = NULL;
			ChessPlayer* _tmp27_ = NULL;
			ChessGame* _tmp28_ = NULL;
			ChessGame* _tmp29_ = NULL;
			ChessPlayer* _tmp30_ = NULL;
			ChessPlayer* _tmp31_ = NULL;
			_tmp26_ = piece;
			_tmp27_ = _tmp26_->player;
			_tmp28_ = chess_scene_get_game (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = chess_game_get_current_player (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp24_ = _tmp27_ == _tmp31_;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			_tmp32_ = rank;
			self->selected_rank = _tmp32_;
			_tmp33_ = file;
			self->selected_file = _tmp33_;
		} else {
			gint _tmp34_ = 0;
			_tmp34_ = self->selected_file;
			if (_tmp34_ != (-1)) {
				gboolean can_move = FALSE;
				ChessGame* _tmp35_ = NULL;
				ChessGame* _tmp36_ = NULL;
				ChessPlayer* _tmp37_ = NULL;
				ChessPlayer* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gboolean _tmp43_ = FALSE;
				gboolean _tmp44_ = FALSE;
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
				ChessGame* _tmp64_ = NULL;
				ChessGame* _tmp65_ = NULL;
				ChessPlayer* _tmp66_ = NULL;
				ChessPlayer* _tmp67_ = NULL;
				gint _tmp68_ = 0;
				gint _tmp69_ = 0;
				gint _tmp70_ = 0;
				gint _tmp71_ = 0;
				gboolean _tmp72_ = FALSE;
				_tmp35_ = chess_scene_get_game (self);
				_tmp36_ = _tmp35_;
				_tmp37_ = chess_game_get_current_player (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = self->selected_rank;
				_tmp40_ = self->selected_file;
				_tmp41_ = rank;
				_tmp42_ = file;
				_tmp43_ = chess_player_move_with_coords (_tmp38_, _tmp39_, _tmp40_, _tmp41_, _tmp42_, FALSE, PIECE_TYPE_QUEEN);
				can_move = _tmp43_;
				_tmp46_ = can_move;
				if (_tmp46_) {
					ChessPiece* _tmp47_ = NULL;
					ChessPiece* _tmp48_ = NULL;
					PieceType _tmp49_ = 0;
					_tmp47_ = chess_scene_get_selected_piece (self);
					_tmp48_ = _tmp47_;
					_tmp49_ = _tmp48_->type;
					_tmp45_ = _tmp49_ == PIECE_TYPE_PAWN;
					_g_object_unref0 (_tmp48_);
				} else {
					_tmp45_ = FALSE;
				}
				if (_tmp45_) {
					gboolean _tmp50_ = FALSE;
					gint _tmp51_ = 0;
					_tmp51_ = rank;
					if (_tmp51_ == 0) {
						_tmp50_ = TRUE;
					} else {
						gint _tmp52_ = 0;
						_tmp52_ = rank;
						_tmp50_ = _tmp52_ == 7;
					}
					_tmp44_ = _tmp50_;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					PieceType promotion_selection = 0;
					PieceType _tmp53_ = 0;
					ChessGame* _tmp54_ = NULL;
					ChessGame* _tmp55_ = NULL;
					ChessPlayer* _tmp56_ = NULL;
					ChessPlayer* _tmp57_ = NULL;
					gint _tmp58_ = 0;
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
					gint _tmp61_ = 0;
					PieceType _tmp62_ = 0;
					gint _tmp63_ = 0;
					g_signal_emit_by_name (self, "choose-promotion-type", &_tmp53_);
					promotion_selection = _tmp53_;
					_tmp54_ = chess_scene_get_game (self);
					_tmp55_ = _tmp54_;
					_tmp56_ = chess_game_get_current_player (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = self->selected_rank;
					_tmp59_ = self->selected_file;
					_tmp60_ = rank;
					_tmp61_ = file;
					_tmp62_ = promotion_selection;
					chess_player_move_with_coords (_tmp57_, _tmp58_, _tmp59_, _tmp60_, _tmp61_, TRUE, _tmp62_);
					self->selected_file = -1;
					_tmp63_ = self->selected_file;
					self->selected_rank = _tmp63_;
				}
				_tmp64_ = chess_scene_get_game (self);
				_tmp65_ = _tmp64_;
				_tmp66_ = chess_game_get_current_player (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = self->selected_rank;
				_tmp69_ = self->selected_file;
				_tmp70_ = rank;
				_tmp71_ = file;
				_tmp72_ = chess_player_move_with_coords (_tmp67_, _tmp68_, _tmp69_, _tmp70_, _tmp71_, TRUE, PIECE_TYPE_QUEEN);
				if (_tmp72_) {
					gint _tmp73_ = 0;
					self->selected_file = -1;
					_tmp73_ = self->selected_file;
					self->selected_rank = _tmp73_;
				}
			}
		}
	}
	chess_scene_update_board (self);
	g_signal_emit_by_name (self, "changed");
	_g_object_unref0 (piece);
}


static void chess_scene_moved_cb (ChessScene* self, ChessGame* game, ChessMove* move) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	chess_scene_update_board (self);
}


static void chess_scene_paused_cb (ChessScene* self, ChessGame* game) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_signal_emit_by_name (self, "changed");
}


static void chess_scene_unpaused_cb (ChessScene* self, ChessGame* game) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_signal_emit_by_name (self, "changed");
}


static void chess_scene_undo_cb (ChessScene* self, ChessGame* game) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	chess_scene_update_board (self);
}


static ChessModel* chess_scene_find_model (ChessScene* self, ChessPiece* piece) {
	ChessModel* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (piece != NULL, NULL);
	_tmp0_ = self->pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp0_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp1_ = NULL;
			ChessModel* model = NULL;
			_tmp1_ = _g_object_ref0 ((ChessModel*) model_it->data);
			model = _tmp1_;
			{
				ChessModel* _tmp2_ = NULL;
				ChessPiece* _tmp3_ = NULL;
				ChessPiece* _tmp4_ = NULL;
				_tmp2_ = model;
				_tmp3_ = _tmp2_->piece;
				_tmp4_ = piece;
				if (_tmp3_ == _tmp4_) {
					result = model;
					return result;
				}
				_g_object_unref0 (model);
			}
		}
	}
	result = NULL;
	return result;
}


static gboolean _chess_scene_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_scene_animate_cb ((ChessScene*) self);
	return result;
}


static void chess_scene_update_board (ChessScene* self) {
	ChessGame* _tmp0_ = NULL;
	ChessGame* _tmp1_ = NULL;
	gboolean board_changed = FALSE;
	gboolean need_animation = FALSE;
	GList* new_pieces = NULL;
	GList* _tmp59_ = NULL;
	guint _tmp60_ = 0U;
	GList* _tmp61_ = NULL;
	guint _tmp62_ = 0U;
	gboolean _tmp63_ = FALSE;
	GList* _tmp64_ = NULL;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_scene_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	board_changed = FALSE;
	need_animation = FALSE;
	new_pieces = NULL;
	{
		gint rank = 0;
		rank = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = rank;
					rank = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = rank;
				if (!(_tmp4_ < 8)) {
					break;
				}
				{
					gint file = 0;
					file = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							gboolean can_move = FALSE;
							gboolean _tmp8_ = FALSE;
							gboolean _tmp9_ = FALSE;
							gint _tmp10_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gboolean _tmp24_ = FALSE;
							gboolean _tmp25_ = FALSE;
							ChessPiece* piece = NULL;
							ChessGame* _tmp26_ = NULL;
							ChessGame* _tmp27_ = NULL;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							ChessPiece* _tmp32_ = NULL;
							ChessPiece* _tmp33_ = NULL;
							ChessModel* model = NULL;
							ChessPiece* _tmp34_ = NULL;
							ChessModel* _tmp35_ = NULL;
							ChessModel* _tmp36_ = NULL;
							ChessModel* _tmp41_ = NULL;
							gboolean _tmp42_ = FALSE;
							ChessModel* _tmp43_ = NULL;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gboolean _tmp46_ = FALSE;
							gboolean _tmp47_ = FALSE;
							gboolean _tmp48_ = FALSE;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							ChessModel* _tmp57_ = NULL;
							ChessModel* _tmp58_ = NULL;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = file;
								file = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = file;
							if (!(_tmp7_ < 8)) {
								break;
							}
							can_move = FALSE;
							_tmp10_ = self->selected_rank;
							if (_tmp10_ >= 0) {
								gint _tmp11_ = 0;
								gint _tmp12_ = 0;
								_tmp11_ = chess_scene_get_move_number (self);
								_tmp12_ = _tmp11_;
								_tmp9_ = _tmp12_ == (-1);
							} else {
								_tmp9_ = FALSE;
							}
							if (_tmp9_) {
								ChessGame* _tmp13_ = NULL;
								ChessGame* _tmp14_ = NULL;
								ChessPlayer* _tmp15_ = NULL;
								ChessPlayer* _tmp16_ = NULL;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gboolean _tmp21_ = FALSE;
								_tmp13_ = chess_scene_get_game (self);
								_tmp14_ = _tmp13_;
								_tmp15_ = chess_game_get_current_player (_tmp14_);
								_tmp16_ = _tmp15_;
								_tmp17_ = self->selected_rank;
								_tmp18_ = self->selected_file;
								_tmp19_ = rank;
								_tmp20_ = file;
								_tmp21_ = chess_player_move_with_coords (_tmp16_, _tmp17_, _tmp18_, _tmp19_, _tmp20_, FALSE, PIECE_TYPE_QUEEN);
								_tmp8_ = _tmp21_;
							} else {
								_tmp8_ = FALSE;
							}
							if (_tmp8_) {
								can_move = TRUE;
							}
							_tmp22_ = rank;
							_tmp23_ = file;
							_tmp24_ = can_move;
							self->priv->_can_move[(_tmp22_ * 8) + _tmp23_] = _tmp24_;
							_tmp25_ = self->priv->_can_move[(_tmp22_ * 8) + _tmp23_];
							_tmp26_ = chess_scene_get_game (self);
							_tmp27_ = _tmp26_;
							_tmp28_ = rank;
							_tmp29_ = file;
							_tmp30_ = chess_scene_get_move_number (self);
							_tmp31_ = _tmp30_;
							_tmp32_ = chess_game_get_piece (_tmp27_, _tmp28_, _tmp29_, _tmp31_);
							piece = _tmp32_;
							_tmp33_ = piece;
							if (_tmp33_ == NULL) {
								_g_object_unref0 (piece);
								continue;
							}
							_tmp34_ = piece;
							_tmp35_ = chess_scene_find_model (self, _tmp34_);
							model = _tmp35_;
							_tmp36_ = model;
							if (_tmp36_ == NULL) {
								ChessPiece* _tmp37_ = NULL;
								gint _tmp38_ = 0;
								gint _tmp39_ = 0;
								ChessModel* _tmp40_ = NULL;
								_tmp37_ = piece;
								_tmp38_ = file;
								_tmp39_ = rank;
								_tmp40_ = chess_model_new (_tmp37_, (gdouble) _tmp38_, (gdouble) _tmp39_);
								_g_object_unref0 (model);
								model = _tmp40_;
								board_changed = TRUE;
							}
							_tmp41_ = model;
							_tmp42_ = can_move;
							_tmp41_->under_threat = _tmp42_;
							_tmp43_ = model;
							_tmp44_ = file;
							_tmp45_ = rank;
							_tmp46_ = chess_model_move_to (_tmp43_, (gdouble) _tmp44_, (gdouble) _tmp45_);
							if (_tmp46_) {
								board_changed = TRUE;
								need_animation = TRUE;
							}
							_tmp49_ = chess_scene_get_move_number (self);
							_tmp50_ = _tmp49_;
							if (_tmp50_ == (-1)) {
								gint _tmp51_ = 0;
								gint _tmp52_ = 0;
								_tmp51_ = rank;
								_tmp52_ = self->selected_rank;
								_tmp48_ = _tmp51_ == _tmp52_;
							} else {
								_tmp48_ = FALSE;
							}
							if (_tmp48_) {
								gint _tmp53_ = 0;
								gint _tmp54_ = 0;
								_tmp53_ = file;
								_tmp54_ = self->selected_file;
								_tmp47_ = _tmp53_ == _tmp54_;
							} else {
								_tmp47_ = FALSE;
							}
							if (_tmp47_) {
								ChessModel* _tmp55_ = NULL;
								_tmp55_ = model;
								_tmp55_->is_selected = TRUE;
							} else {
								ChessModel* _tmp56_ = NULL;
								_tmp56_ = model;
								_tmp56_->is_selected = FALSE;
							}
							_tmp57_ = model;
							_tmp58_ = _g_object_ref0 (_tmp57_);
							new_pieces = g_list_append (new_pieces, _tmp58_);
							_g_object_unref0 (model);
							_g_object_unref0 (piece);
						}
					}
				}
			}
		}
	}
	_tmp59_ = new_pieces;
	_tmp60_ = g_list_length (_tmp59_);
	_tmp61_ = self->pieces;
	_tmp62_ = g_list_length (_tmp61_);
	if (_tmp60_ != _tmp62_) {
		board_changed = TRUE;
	}
	_tmp63_ = board_changed;
	if (!_tmp63_) {
		__g_list_free__g_object_unref0_0 (new_pieces);
		return;
	}
	__g_list_free__g_object_unref0_0 (self->pieces);
	self->pieces = NULL;
	_tmp64_ = new_pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp64_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp65_ = NULL;
			ChessModel* model = NULL;
			_tmp65_ = _g_object_ref0 ((ChessModel*) model_it->data);
			model = _tmp65_;
			{
				ChessModel* _tmp66_ = NULL;
				ChessModel* _tmp67_ = NULL;
				_tmp66_ = model;
				_tmp67_ = _g_object_ref0 (_tmp66_);
				self->pieces = g_list_append (self->pieces, _tmp67_);
				_g_object_unref0 (model);
			}
		}
	}
	g_signal_emit_by_name (self, "changed");
	_tmp69_ = need_animation;
	if (_tmp69_) {
		gboolean _tmp70_ = FALSE;
		_tmp70_ = self->animating;
		_tmp68_ = !_tmp70_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		GTimer* _tmp71_ = NULL;
		ChessGame* _tmp72_ = NULL;
		ChessGame* _tmp73_ = NULL;
		guint _tmp74_ = 0U;
		self->animating = TRUE;
		_tmp71_ = self->priv->animation_timer;
		g_timer_start (_tmp71_);
		self->priv->animation_time = (gdouble) 0;
		_tmp72_ = chess_scene_get_game (self);
		_tmp73_ = _tmp72_;
		chess_game_add_hold (_tmp73_);
		_tmp74_ = g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, (guint) 10, _chess_scene_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->animate_timeout_id = _tmp74_;
	}
	__g_list_free__g_object_unref0_0 (new_pieces);
}


gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rank;
	_tmp1_ = file;
	_tmp2_ = self->priv->_can_move[(_tmp0_ * 8) + _tmp1_];
	result = _tmp2_;
	return result;
}


static gboolean chess_scene_animate_cb (ChessScene* self) {
	gboolean result = FALSE;
	gdouble old_time = 0.0;
	gdouble _tmp0_ = 0.0;
	GTimer* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble timestep = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gint animate_count = 0;
	GList* _tmp5_ = NULL;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	ChessGame* _tmp13_ = NULL;
	ChessGame* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->animation_time;
	old_time = _tmp0_;
	_tmp1_ = self->priv->animation_timer;
	_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
	self->priv->animation_time = _tmp2_;
	_tmp3_ = self->priv->animation_time;
	_tmp4_ = old_time;
	timestep = _tmp3_ - _tmp4_;
	animate_count = 0;
	_tmp5_ = self->pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp5_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp6_ = NULL;
			ChessModel* model = NULL;
			_tmp6_ = _g_object_ref0 ((ChessModel*) model_it->data);
			model = _tmp6_;
			{
				ChessModel* _tmp7_ = NULL;
				gdouble _tmp8_ = 0.0;
				gboolean _tmp9_ = FALSE;
				_tmp7_ = model;
				_tmp8_ = timestep;
				_tmp9_ = chess_model_animate (_tmp7_, _tmp8_);
				if (_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = animate_count;
					animate_count = _tmp10_ + 1;
				}
				_g_object_unref0 (model);
			}
		}
	}
	_tmp11_ = animate_count;
	self->animating = _tmp11_ > 0;
	g_signal_emit_by_name (self, "changed");
	_tmp12_ = self->animating;
	if (_tmp12_) {
		result = TRUE;
		return result;
	}
	_tmp13_ = chess_scene_get_game (self);
	_tmp14_ = _tmp13_;
	chess_game_remove_hold (_tmp14_);
	result = FALSE;
	return result;
}


ChessGame* chess_scene_get_game (ChessScene* self) {
	ChessGame* result;
	ChessGame* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static void _chess_scene_moved_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
	chess_scene_moved_cb ((ChessScene*) self, _sender, move);
}


static void _chess_scene_paused_cb_chess_game_paused (ChessGame* _sender, gpointer self) {
	chess_scene_paused_cb ((ChessScene*) self, _sender);
}


static void _chess_scene_unpaused_cb_chess_game_unpaused (ChessGame* _sender, gpointer self) {
	chess_scene_unpaused_cb ((ChessScene*) self, _sender);
}


static void _chess_scene_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
	chess_scene_undo_cb ((ChessScene*) self, _sender);
}


void chess_scene_set_game (ChessScene* self, ChessGame* value) {
	guint _tmp0_ = 0U;
	ChessGame* _tmp2_ = NULL;
	ChessGame* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessGame* _tmp5_ = NULL;
	ChessGame* _tmp6_ = NULL;
	ChessGame* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->animate_timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->animate_timeout_id;
		g_source_remove (_tmp1_);
		self->priv->animate_timeout_id = (guint) 0;
		self->animating = FALSE;
	}
	_tmp2_ = value;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp3_;
	self->priv->_move_number = -1;
	self->selected_rank = -1;
	self->selected_file = -1;
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (_tmp4_, "moved", (GCallback) _chess_scene_moved_cb_chess_game_moved, self, 0);
	_tmp5_ = self->priv->_game;
	g_signal_connect_object (_tmp5_, "paused", (GCallback) _chess_scene_paused_cb_chess_game_paused, self, 0);
	_tmp6_ = self->priv->_game;
	g_signal_connect_object (_tmp6_, "unpaused", (GCallback) _chess_scene_unpaused_cb_chess_game_unpaused, self, 0);
	_tmp7_ = self->priv->_game;
	g_signal_connect_object (_tmp7_, "undo", (GCallback) _chess_scene_undo_cb_chess_game_undo, self, 0);
	chess_scene_update_board (self);
	g_object_notify ((GObject *) self, "game");
}


gint chess_scene_get_move_number (ChessScene* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_move_number;
	result = _tmp0_;
	return result;
}


void chess_scene_set_move_number (ChessScene* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_move_number;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_move_number = _tmp2_;
	chess_scene_update_board (self);
	g_object_notify ((GObject *) self, "move-number");
}


gboolean chess_scene_get_show_numbering (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_numbering;
	result = _tmp0_;
	return result;
}


void chess_scene_set_show_numbering (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_numbering = _tmp0_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "show-numbering");
}


gboolean chess_scene_get_show_move_hints (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_move_hints;
	result = _tmp0_;
	return result;
}


void chess_scene_set_show_move_hints (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_move_hints = _tmp0_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "show-move-hints");
}


const gchar* chess_scene_get_theme_name (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme_name;
	result = _tmp0_;
	return result;
}


void chess_scene_set_theme_name (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_theme_name);
	self->priv->_theme_name = _tmp1_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "theme-name");
}


gboolean chess_scene_get_show_3d_smooth (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_3d_smooth;
	result = _tmp0_;
	return result;
}


void chess_scene_set_show_3d_smooth (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_3d_smooth = _tmp0_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "show-3d-smooth");
}


const gchar* chess_scene_get_board_side (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_board_side;
	result = _tmp0_;
	return result;
}


void chess_scene_set_board_side (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_board_side);
	self->priv->_board_side = _tmp1_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "board-side");
}


gdouble chess_scene_get_board_angle (ChessScene* self) {
	gdouble result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = chess_scene_get_board_side (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("black")))) {
		switch (0) {
			default:
			{
				result = 180.0;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				ChessGame* _tmp5_ = NULL;
				ChessGame* _tmp6_ = NULL;
				ChessPlayer* _tmp7_ = NULL;
				ChessPlayer* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				_tmp5_ = chess_scene_get_game (self);
				_tmp6_ = _tmp5_;
				_tmp7_ = chess_game_get_black (_tmp6_);
				_tmp8_ = _tmp7_;
				g_signal_emit_by_name (self, "is-human", _tmp8_, &_tmp9_);
				if (_tmp9_) {
					result = 180.0;
					return result;
				} else {
					result = 0.0;
					return result;
				}
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("current")))) {
		switch (0) {
			default:
			{
				gdouble _tmp10_ = 0.0;
				ChessGame* _tmp11_ = NULL;
				ChessGame* _tmp12_ = NULL;
				ChessPlayer* _tmp13_ = NULL;
				ChessPlayer* _tmp14_ = NULL;
				Color _tmp15_ = 0;
				_tmp11_ = chess_scene_get_game (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = chess_game_get_current_player (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_->color;
				if (_tmp15_ == COLOR_WHITE) {
					_tmp10_ = 0.0;
				} else {
					_tmp10_ = 180.0;
				}
				result = _tmp10_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = 0.0;
				return result;
			}
		}
	}
}


const gchar* chess_scene_get_move_format (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_move_format;
	result = _tmp0_;
	return result;
}


void chess_scene_set_move_format (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_move_format);
	self->priv->_move_format = _tmp1_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "move-format");
}


static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__OBJECT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_object (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_ENUM__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gint (*GMarshalFunc_ENUM__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_ENUM__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_ENUM__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_enum (return_value, v_return);
}


static void chess_scene_class_init (ChessSceneClass * klass) {
	chess_scene_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessScenePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_scene_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_scene_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_scene_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_GAME, g_param_spec_object ("game", "game", "game", TYPE_CHESS_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_MOVE_NUMBER, g_param_spec_int ("move-number", "move-number", "move-number", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_NUMBERING, g_param_spec_boolean ("show-numbering", "show-numbering", "show-numbering", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_MOVE_HINTS, g_param_spec_boolean ("show-move-hints", "show-move-hints", "show-move-hints", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_THEME_NAME, g_param_spec_string ("theme-name", "theme-name", "theme-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_3D_SMOOTH, g_param_spec_boolean ("show-3d-smooth", "show-3d-smooth", "show-3d-smooth", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_BOARD_SIDE, g_param_spec_string ("board-side", "board-side", "board-side", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_BOARD_ANGLE, g_param_spec_double ("board-angle", "board-angle", "board-angle", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_MOVE_FORMAT, g_param_spec_string ("move-format", "move-format", "move-format", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("is_human", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT, G_TYPE_BOOLEAN, 1, TYPE_CHESS_PLAYER);
	g_signal_new ("choose_promotion_type", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_ENUM__VOID, TYPE_PIECE_TYPE, 0);
	g_signal_new ("changed", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_scene_instance_init (ChessScene * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self->priv = CHESS_SCENE_GET_PRIVATE (self);
	self->pieces = NULL;
	self->animating = FALSE;
	self->selected_rank = -1;
	self->selected_file = -1;
	self->priv->animate_timeout_id = (guint) 0;
	self->priv->_game = NULL;
	self->priv->_move_number = -1;
	self->priv->_show_numbering = TRUE;
	self->priv->_show_move_hints = TRUE;
	_tmp0_ = g_strdup ("simple");
	self->priv->_theme_name = _tmp0_;
	self->priv->_show_3d_smooth = FALSE;
	_tmp1_ = g_strdup ("human");
	self->priv->_board_side = _tmp1_;
	_tmp2_ = g_strdup ("human");
	self->priv->_move_format = _tmp2_;
}


static void chess_scene_finalize (GObject* obj) {
	ChessScene * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_SCENE, ChessScene);
	__g_list_free__g_object_unref0_0 (self->pieces);
	_g_timer_destroy0 (self->priv->animation_timer);
	_g_object_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme_name);
	_g_free0 (self->priv->_board_side);
	_g_free0 (self->priv->_move_format);
	G_OBJECT_CLASS (chess_scene_parent_class)->finalize (obj);
}


GType chess_scene_get_type (void) {
	static volatile gsize chess_scene_type_id__volatile = 0;
	if (g_once_init_enter (&chess_scene_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessSceneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_scene_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessScene), 0, (GInstanceInitFunc) chess_scene_instance_init, NULL };
		GType chess_scene_type_id;
		chess_scene_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessScene", &g_define_type_info, 0);
		g_once_init_leave (&chess_scene_type_id__volatile, chess_scene_type_id);
	}
	return chess_scene_type_id__volatile;
}


static void _vala_chess_scene_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessScene * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_SCENE, ChessScene);
	switch (property_id) {
		case CHESS_SCENE_GAME:
		g_value_set_object (value, chess_scene_get_game (self));
		break;
		case CHESS_SCENE_MOVE_NUMBER:
		g_value_set_int (value, chess_scene_get_move_number (self));
		break;
		case CHESS_SCENE_SHOW_NUMBERING:
		g_value_set_boolean (value, chess_scene_get_show_numbering (self));
		break;
		case CHESS_SCENE_SHOW_MOVE_HINTS:
		g_value_set_boolean (value, chess_scene_get_show_move_hints (self));
		break;
		case CHESS_SCENE_THEME_NAME:
		g_value_set_string (value, chess_scene_get_theme_name (self));
		break;
		case CHESS_SCENE_SHOW_3D_SMOOTH:
		g_value_set_boolean (value, chess_scene_get_show_3d_smooth (self));
		break;
		case CHESS_SCENE_BOARD_SIDE:
		g_value_set_string (value, chess_scene_get_board_side (self));
		break;
		case CHESS_SCENE_BOARD_ANGLE:
		g_value_set_double (value, chess_scene_get_board_angle (self));
		break;
		case CHESS_SCENE_MOVE_FORMAT:
		g_value_set_string (value, chess_scene_get_move_format (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_scene_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessScene * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_SCENE, ChessScene);
	switch (property_id) {
		case CHESS_SCENE_GAME:
		chess_scene_set_game (self, g_value_get_object (value));
		break;
		case CHESS_SCENE_MOVE_NUMBER:
		chess_scene_set_move_number (self, g_value_get_int (value));
		break;
		case CHESS_SCENE_SHOW_NUMBERING:
		chess_scene_set_show_numbering (self, g_value_get_boolean (value));
		break;
		case CHESS_SCENE_SHOW_MOVE_HINTS:
		chess_scene_set_show_move_hints (self, g_value_get_boolean (value));
		break;
		case CHESS_SCENE_THEME_NAME:
		chess_scene_set_theme_name (self, g_value_get_string (value));
		break;
		case CHESS_SCENE_SHOW_3D_SMOOTH:
		chess_scene_set_show_3d_smooth (self, g_value_get_boolean (value));
		break;
		case CHESS_SCENE_BOARD_SIDE:
		chess_scene_set_board_side (self, g_value_get_string (value));
		break;
		case CHESS_SCENE_MOVE_FORMAT:
		chess_scene_set_move_format (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



