/* libsudoku.vapi generated by valac 0.23.3.24-5b8db, do not modify. */

[CCode (cheader_filename = "libsudoku.h")]
public enum House {
	ROW,
	COLUMN,
	BLOCK
}
[CCode (cheader_filename = "libsudoku.h")]
public enum DifficultyCategory {
	EASY,
	MEDIUM,
	HARD,
	VERY_HARD;
	public string to_string ();
}
[CCode (cheader_filename = "libsudoku.h")]
protected errordomain SudokuError {
	UNSOLVABLE_PUZZLE,
	CONFLICT_ERROR,
	ALREADY_SET_ERROR
}
[CCode (cheader_filename = "libsudoku.h")]
public class SudokuBoard : GLib.Object {
	public Gee.Set<Coord?> broken_coords;
	protected int[,] cells;
	public Gee.Map<Coord?,Gee.List<Coord?>> coords_for_block;
	public Gee.List<Gee.List<Coord?>> coords_for_col;
	public Gee.List<Gee.List<Coord?>> coords_for_row;
	public double difficulty_rating;
	public bool[,,] earmarks;
	public bool[,] is_fixed;
	public SudokuBoard (int block_rows = 3, int block_cols = 3);
	public bool block_contains (Coord block, int val);
	public Gee.HashMap<Coord?,Gee.ArrayList<int>> calculate_open_squares ();
	public SudokuBoard clone ();
	public bool col_contains (int col, int val);
	public int count_possibilities (int row, int col);
	public int @get (int row, int col);
	public Coord get_block_for (int row, int col);
	public int[,] get_cells ();
	public DifficultyCategory get_difficulty_category ();
	public string get_earmarks_string (int row, int col);
	public Gee.Set<Coord?> get_occurances (Gee.List<Coord?> coords, int val);
	public int[] get_possibilities (int row, int col);
	public bool[] get_possibilities_as_bool_array (int row, int col);
	public void get_string ();
	public void insert (int row, int col, int val, bool is_fixed = false);
	public bool is_finished ();
	public bool is_possible (int row, int col, int val);
	public void print (int indent = 0);
	public void remove (int row, int col, bool is_fixed = false);
	public bool row_contains (int row, int val);
	public void @set (int row, int col, int val);
	public void set_from_string (string s, string delimiter = "", string empty_value = "0", string rating_delimiter = "\t");
	public void to_initial_state ();
	public string to_string (bool get_original_state = false);
	public int block_cols { get; }
	public int block_rows { get; }
	public bool broken { get; }
	public int cols { get; }
	public bool complete { get; }
	public int filled { get; }
	public int max_val { get; }
	public double previous_played_time { get; set; }
	public int rows { get; }
	public signal void completed ();
}
[CCode (cheader_filename = "libsudoku.h")]
public class SudokuGame : GLib.Object {
	public SudokuBoard board;
	public GLib.Timer timer;
	public SudokuGame (SudokuBoard board);
	public void cell_changed_cb (int row, int col, int old_val, int new_val);
	public double get_total_time_played ();
	public void insert (int row, int col, int val);
	public bool is_redostack_null ();
	public bool is_undostack_null ();
	public void redo ();
	public void remove (int row, int col);
	public void reset ();
	public static string seconds_to_hms_string (double time_in_seconds);
	public void undo ();
	public void update_undo (int row, int col, int old_val, int new_val);
	public signal void cell_changed (int row, int col, int old_val, int new_val);
}
[CCode (cheader_filename = "libsudoku.h")]
public class SudokuGenerator : GLib.Object {
	public struct RatedSudoku {
		public SudokuBoard board;
		public DifficultyRating diff;
		public RatedSudoku (SudokuBoard board, DifficultyRating diff);
	}
	public int clues;
	public SudokuBoard start_board;
	public SudokuGenerator ();
	public static void gen_stats ();
	public SudokuBoard generate (float[] difficulty_range, bool symmetric = true);
	public SudokuBoard make_puzzle_by_boxes (float skew_by = 0.0f);
	public SudokuBoard make_symmetric_puzzle (int line);
	public SudokuGenerator.RatedSudoku? make_unique_puzzle (int line = -1, bool strict_number_of_clues = false);
}
[CCode (cheader_filename = "libsudoku.h")]
public class SudokuSaver : GLib.Object {
	public SudokuSaver ();
	public void add_game_to_finished (SudokuGame game, bool delete_savegame = false);
	public SudokuGame? get_savedgame ();
	public void save_game (SudokuGame game);
	public static string finishgame_dir { get; private set; }
	public static string savegame_file { get; private set; }
}
[CCode (cheader_filename = "libsudoku.h")]
public class SudokuSolver : GLib.Object {
	public class Iterator : GLib.Object {
		public Iterator (SudokuSolver solver);
		public SudokuBoard? @get ();
		public bool next ();
	}
	protected int backtraces;
	protected SudokuBoard board;
	public BreadcrumbTrail breadcrumbs;
	protected GuessList guesses;
	protected bool solved;
	public SudokuSolver (ref SudokuBoard board);
	protected Gee.ArrayList<Cell?> fill_deterministically ();
	protected Gee.ArrayList<Cell?> fill_must_fills () throws SudokuError;
	protected virtual bool guess_least_open_square () throws SudokuError;
	public bool has_unique_solution ();
	protected virtual void insert (int row, int col, int val);
	public SudokuSolver.Iterator iterator ();
	public int quick_count_solutions (int break_at = 100);
	public bool quick_has_many_solution ();
	public bool quick_has_solution ();
	public bool quick_has_unique_solution ();
	public SudokuBoard solve ();
}
[CCode (cheader_filename = "libsudoku.h")]
public class SudokuRater : SudokuSolver {
	public SudokuRater (ref SudokuBoard board);
	public DifficultyRating get_difficulty ();
	protected override bool guess_least_open_square () throws SudokuError;
	protected override void insert (int row, int col, int val);
}
[CCode (cheader_filename = "libsudoku.h")]
public class Guess : GLib.Object {
	public Gee.ArrayList<Guess> children;
	public Gee.HashMap<Coord?,int> consequences;
	public Guess (int row, int col, int val);
	public void add_consequence (int row, int col, int val);
	public int col { get; }
	public int row { get; }
	public int val { get; }
}
[CCode (cheader_filename = "libsudoku.h")]
public class GuessList : Gee.ArrayList<Guess> {
	public GuessList ();
	public Guess[] guesses_for (int row, int col);
	public Guess[] remove_children (Guess guess);
	public Guess[] remove_guesses_for (int row, int col);
}
[CCode (cheader_filename = "libsudoku.h")]
public class BreadcrumbTrail : GuessList {
	public BreadcrumbTrail ();
	public new void append (Guess guess);
}
[CCode (cheader_filename = "libsudoku.h")]
public class ParallelDict : GLib.Object {
	public ParallelDict ();
	public bool contains (Coord key);
	public void @set (Coord k, Gee.HashSet<Coord?> v);
	public void unset (Coord k);
}
[CCode (cheader_filename = "libsudoku.h")]
public class DifficultyRating : GLib.Object {
	public float rating;
	public const float[] EASY_RANGE;
	public const float[] HARD_RANGE;
	public const float[] MEDIUM_RANGE;
	public const float[] VERY_HARD_RANGE;
	public DifficultyRating (Gee.HashMap<int,Gee.HashSet<Cell?>> fill_must_fillables, Gee.HashMap<int,Gee.HashSet<Cell?>> elimination_fillables, GuessList guesses, int backtraces, int squares_filled);
	public DifficultyCategory get_category ();
	public bool in_range (float[] range);
	public string to_string ();
}
[CCode (cheader_filename = "libsudoku.h")]
public struct Coord {
	public int row;
	public int col;
	public Coord (int row, int col);
	public static bool equal (Coord a, Coord b);
	public static int hash (Coord coord);
}
[CCode (cheader_filename = "libsudoku.h")]
public struct Cell {
	public Coord coord;
	public int val;
	public Cell (Coord coord, int val);
	public static bool equal (Cell a, Cell b);
	public static int hash (Cell cell);
}
