/* exportable.c generated by valac 0.22.1, the Vala compiler
 * generated from exportable.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2004,2005 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2012 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-common.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

typedef struct _Block3Data Block3Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block6Data Block6Data;

struct _Block3Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* _result_;
};

struct _Block4Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* _result_;
};

struct _Block5Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* _result_;
};

struct _Block6Data {
	int _ref_count_;
	GtkFileChooserDialog* chooser;
	GHashTable* filters;
};



static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda2_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res);
static void _____lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda3_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
static void ____lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ____lambda5_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
static void _____lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gchar* seahorse_exportable_calculate_basename (GFile* file, const gchar* extension);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda4_ (Block6Data* _data6_, GObject* obj, GParamSpec* prop);
static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);


GList* seahorse_exportable_create_exporters (SeahorseExportable* self, SeahorseExporterType type) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEAHORSE_EXPORTABLE_GET_INTERFACE (self)->create_exporters (self, type);
}


gboolean seahorse_exportable_can_export (GObject* object) {
	gboolean result = FALSE;
	GObject* _tmp0_ = NULL;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, SEAHORSE_TYPE_EXPORTABLE)) {
		GObject* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = object;
		_tmp2_ = seahorse_exportable_get_exportable (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_TYPE_EXPORTABLE, SeahorseExportable));
		_tmp3_ = _tmp2_;
		result = _tmp3_;
		return result;
	}
	result = FALSE;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->_result_);
		_g_main_loop_unref0 (_data3_->loop);
		g_slice_free (Block3Data, _data3_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void ____lambda2_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data3_->_result_);
	_data3_->_result_ = _tmp1_;
	_tmp2_ = _data3_->loop;
	g_main_loop_quit (_tmp2_);
}


static void _____lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda2_ (self, source_object, res);
	block3_data_unref (self);
}


gint seahorse_exportable_export_to_directory_wait (GList* objects, const gchar* directory, GError** error) {
	gint result = 0;
	Block3Data* _data3_;
	GMainLoop* _tmp0_ = NULL;
	gint count = 0;
	GList* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (directory != NULL, 0);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data3_->loop = _tmp0_;
	_data3_->_result_ = NULL;
	count = 0;
	_tmp1_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp1_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp2_ = NULL;
			GObject* object = NULL;
			_tmp2_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp2_;
			{
				GObject* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				GList* exporters = NULL;
				GObject* _tmp5_ = NULL;
				GList* _tmp6_ = NULL;
				GList* _tmp7_ = NULL;
				SeahorseExporter* exporter = NULL;
				GList* _tmp8_ = NULL;
				gconstpointer _tmp9_ = NULL;
				SeahorseExporter* _tmp10_ = NULL;
				gchar* filename = NULL;
				const gchar* _tmp11_ = NULL;
				SeahorseExporter* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				GFile* file = NULL;
				const gchar* _tmp18_ = NULL;
				GFile* _tmp19_ = NULL;
				SeahorseExporter* _tmp20_ = NULL;
				GFile* _tmp21_ = NULL;
				GMainLoop* _tmp22_ = NULL;
				SeahorseExporter* _tmp23_ = NULL;
				GAsyncResult* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				_tmp3_ = object;
				_tmp4_ = seahorse_exportable_can_export (_tmp3_);
				if (!_tmp4_) {
					_g_object_unref0 (object);
					continue;
				}
				_tmp5_ = object;
				_tmp6_ = seahorse_exportable_create_exporters (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SEAHORSE_TYPE_EXPORTABLE, SeahorseExportable), SEAHORSE_EXPORTER_TYPE_ANY);
				exporters = _tmp6_;
				_tmp7_ = exporters;
				if (_tmp7_ == NULL) {
					__g_list_free__g_object_unref0_0 (exporters);
					_g_object_unref0 (object);
					continue;
				}
				_tmp8_ = exporters;
				_tmp9_ = _tmp8_->data;
				_tmp10_ = _g_object_ref0 ((SeahorseExporter*) _tmp9_);
				exporter = _tmp10_;
				_tmp11_ = directory;
				_tmp12_ = exporter;
				_tmp13_ = seahorse_exporter_get_filename (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_;
				_tmp16_ = g_build_filename (_tmp11_, _tmp15_, NULL, NULL);
				_tmp17_ = _tmp16_;
				_g_free0 (_tmp15_);
				filename = _tmp17_;
				_tmp18_ = filename;
				_tmp19_ = g_file_new_for_uri (_tmp18_);
				file = _tmp19_;
				_tmp20_ = exporter;
				_tmp21_ = file;
				seahorse_exporter_export_to_file (_tmp20_, _tmp21_, FALSE, NULL, _____lambda2__gasync_ready_callback, block3_data_ref (_data3_));
				_tmp22_ = _data3_->loop;
				g_main_loop_run (_tmp22_);
				_tmp23_ = exporter;
				_tmp24_ = _data3_->_result_;
				seahorse_exporter_export_to_file_finish (_tmp23_, _tmp24_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (file);
					_g_free0 (filename);
					_g_object_unref0 (exporter);
					__g_list_free__g_object_unref0_0 (exporters);
					_g_object_unref0 (object);
					block3_data_unref (_data3_);
					_data3_ = NULL;
					return 0;
				}
				_tmp25_ = count;
				count = _tmp25_ + 1;
				_g_object_unref0 (file);
				_g_free0 (filename);
				_g_object_unref0 (exporter);
				__g_list_free__g_object_unref0_0 (exporters);
				_g_object_unref0 (object);
			}
		}
	}
	result = count;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->_result_);
		_g_main_loop_unref0 (_data4_->loop);
		g_slice_free (Block4Data, _data4_);
	}
}


static void ___lambda3_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data4_->_result_);
	_data4_->_result_ = _tmp1_;
	_tmp2_ = _data4_->loop;
	g_main_loop_quit (_tmp2_);
}


static void ____lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda3_ (self, source_object, res);
	block4_data_unref (self);
}


guint seahorse_exportable_export_to_text_wait (GList* objects, guint8** output, size_t* output_length1, GError** error) {
	guint8* _vala_output = NULL;
	int _vala_output_length1 = 0;
	guint result = 0U;
	GList* exporters = NULL;
	GList* _tmp0_ = NULL;
	SeahorseExporter* chosen = NULL;
	guint total = 0U;
	GList* _tmp11_ = NULL;
	SeahorseExporter* _tmp21_ = NULL;
	guint8* _tmp30_ = NULL;
	GError * _inner_error_ = NULL;
	exporters = NULL;
	_tmp0_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp0_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp1_ = NULL;
			GObject* object = NULL;
			_tmp1_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp1_;
			{
				GObject* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				GList* _tmp4_ = NULL;
				_tmp2_ = object;
				_tmp3_ = seahorse_exportable_can_export (_tmp2_);
				if (!_tmp3_) {
					_g_object_unref0 (object);
					continue;
				}
				_tmp4_ = exporters;
				if (_tmp4_ != NULL) {
					GList* _tmp5_ = NULL;
					_tmp5_ = exporters;
					{
						GList* exporter_collection = NULL;
						GList* exporter_it = NULL;
						exporter_collection = _tmp5_;
						for (exporter_it = exporter_collection; exporter_it != NULL; exporter_it = exporter_it->next) {
							SeahorseExporter* _tmp6_ = NULL;
							SeahorseExporter* exporter = NULL;
							_tmp6_ = _g_object_ref0 ((SeahorseExporter*) exporter_it->data);
							exporter = _tmp6_;
							{
								SeahorseExporter* _tmp7_ = NULL;
								GObject* _tmp8_ = NULL;
								_tmp7_ = exporter;
								_tmp8_ = object;
								seahorse_exporter_add_object (_tmp7_, _tmp8_);
								_g_object_unref0 (exporter);
							}
						}
					}
				} else {
					GObject* _tmp9_ = NULL;
					GList* _tmp10_ = NULL;
					_tmp9_ = object;
					_tmp10_ = seahorse_exportable_create_exporters (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, SEAHORSE_TYPE_EXPORTABLE, SeahorseExportable), SEAHORSE_EXPORTER_TYPE_TEXTUAL);
					__g_list_free__g_object_unref0_0 (exporters);
					exporters = _tmp10_;
				}
				_g_object_unref0 (object);
			}
		}
	}
	chosen = NULL;
	total = (guint) 0;
	_tmp11_ = exporters;
	{
		GList* exporter_collection = NULL;
		GList* exporter_it = NULL;
		exporter_collection = _tmp11_;
		for (exporter_it = exporter_collection; exporter_it != NULL; exporter_it = exporter_it->next) {
			SeahorseExporter* _tmp12_ = NULL;
			SeahorseExporter* exporter = NULL;
			_tmp12_ = _g_object_ref0 ((SeahorseExporter*) exporter_it->data);
			exporter = _tmp12_;
			{
				guint count = 0U;
				SeahorseExporter* _tmp13_ = NULL;
				GList* _tmp14_ = NULL;
				guint _tmp15_ = 0U;
				guint _tmp16_ = 0U;
				guint _tmp17_ = 0U;
				_tmp13_ = exporter;
				_tmp14_ = seahorse_exporter_get_objects (_tmp13_);
				_tmp15_ = g_list_length (_tmp14_);
				count = _tmp15_;
				_tmp16_ = count;
				_tmp17_ = total;
				if (_tmp16_ > _tmp17_) {
					guint _tmp18_ = 0U;
					SeahorseExporter* _tmp19_ = NULL;
					SeahorseExporter* _tmp20_ = NULL;
					_tmp18_ = count;
					total = _tmp18_;
					_tmp19_ = exporter;
					_tmp20_ = _g_object_ref0 (_tmp19_);
					_g_object_unref0 (chosen);
					chosen = _tmp20_;
				}
				_g_object_unref0 (exporter);
			}
		}
	}
	_tmp21_ = chosen;
	if (_tmp21_ != NULL) {
		Block4Data* _data4_;
		GMainLoop* _tmp22_ = NULL;
		SeahorseExporter* _tmp23_ = NULL;
		GMainLoop* _tmp24_ = NULL;
		guint8* _tmp25_ = NULL;
		SeahorseExporter* _tmp26_ = NULL;
		GAsyncResult* _tmp27_ = NULL;
		size_t _tmp28_;
		guint8* _tmp29_ = NULL;
		gint _tmp25__length1 = 0;
		gint __tmp25__size_ = 0;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_tmp22_ = g_main_loop_new (NULL, FALSE);
		_data4_->loop = _tmp22_;
		_data4_->_result_ = NULL;
		_tmp23_ = chosen;
		seahorse_exporter_export (_tmp23_, NULL, ____lambda3__gasync_ready_callback, block4_data_ref (_data4_));
		_tmp24_ = _data4_->loop;
		g_main_loop_run (_tmp24_);
		_tmp26_ = chosen;
		_tmp27_ = _data4_->_result_;
		_tmp29_ = seahorse_exporter_export_finish (_tmp26_, _tmp27_, &_tmp28_, &_inner_error_);
		_tmp25_ = _tmp29_;
		_tmp25__length1 = _tmp28_;
		__tmp25__size_ = _tmp25__length1;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			_g_object_unref0 (chosen);
			__g_list_free__g_object_unref0_0 (exporters);
			return 0U;
		}
		_vala_output = (g_free (_vala_output), NULL);
		_vala_output = _tmp25_;
		_vala_output_length1 = _tmp25__length1;
		result = total;
		block4_data_unref (_data4_);
		_data4_ = NULL;
		_g_object_unref0 (chosen);
		__g_list_free__g_object_unref0_0 (exporters);
		if (output) {
			*output = _vala_output;
		} else {
			_vala_output = (g_free (_vala_output), NULL);
		}
		if (output_length1) {
			*output_length1 = _vala_output_length1;
		}
		return result;
	}
	_tmp30_ = g_new0 (guint8, 0);
	_vala_output = (g_free (_vala_output), NULL);
	_vala_output = _tmp30_;
	_vala_output_length1 = 0;
	result = (guint) 0;
	_g_object_unref0 (chosen);
	__g_list_free__g_object_unref0_0 (exporters);
	if (output) {
		*output = _vala_output;
	} else {
		_vala_output = (g_free (_vala_output), NULL);
	}
	if (output_length1) {
		*output_length1 = _vala_output_length1;
	}
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->_result_);
		_g_main_loop_unref0 (_data5_->loop);
		g_slice_free (Block5Data, _data5_);
	}
}


static void ____lambda5_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->_result_);
	_data5_->_result_ = _tmp1_;
	_tmp2_ = _data5_->loop;
	g_main_loop_quit (_tmp2_);
}


static void _____lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda5_ (self, source_object, res);
	block5_data_unref (self);
}


gint seahorse_exportable_export_to_prompt_wait (GList* objects, GtkWindow* parent, GError** error) {
	gint result = 0;
	gint count = 0;
	GHashTable* pending = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	count = 0;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, NULL);
	pending = _tmp2_;
	_tmp3_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp3_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp4_ = NULL;
			GObject* object = NULL;
			_tmp4_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp4_;
			{
				GHashTable* _tmp5_ = NULL;
				GObject* _tmp6_ = NULL;
				_tmp5_ = pending;
				_tmp6_ = object;
				g_hash_table_add (_tmp5_, _tmp6_);
				_g_object_unref0 (object);
			}
		}
	}
	_tmp7_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp7_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp8_ = NULL;
			GObject* object = NULL;
			_tmp8_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp8_;
			{
				Block5Data* _data5_;
				GHashTable* _tmp9_ = NULL;
				GObject* _tmp10_ = NULL;
				gconstpointer _tmp11_ = NULL;
				GObject* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				GList* exporters = NULL;
				GObject* _tmp16_ = NULL;
				GList* _tmp17_ = NULL;
				GList* _tmp18_ = NULL;
				GList* _tmp19_ = NULL;
				gchar* directory = NULL;
				GFile* file = NULL;
				SeahorseExporter* exporter = NULL;
				gboolean ret = FALSE;
				GList* _tmp30_ = NULL;
				GtkWindow* _tmp31_ = NULL;
				GFile* _tmp32_ = NULL;
				SeahorseExporter* _tmp33_ = NULL;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				GMainLoop* _tmp36_ = NULL;
				SeahorseExporter* _tmp37_ = NULL;
				GFile* _tmp38_ = NULL;
				GMainLoop* _tmp39_ = NULL;
				SeahorseExporter* _tmp40_ = NULL;
				GAsyncResult* _tmp41_ = NULL;
				SeahorseExporter* _tmp42_ = NULL;
				GList* _tmp43_ = NULL;
				_data5_ = g_slice_new0 (Block5Data);
				_data5_->_ref_count_ = 1;
				_tmp9_ = pending;
				_tmp10_ = object;
				_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
				if (((GObject*) _tmp11_) == NULL) {
					_g_object_unref0 (object);
					block5_data_unref (_data5_);
					_data5_ = NULL;
					continue;
				}
				_tmp12_ = object;
				_tmp13_ = seahorse_exportable_can_export (_tmp12_);
				if (!_tmp13_) {
					GHashTable* _tmp14_ = NULL;
					GObject* _tmp15_ = NULL;
					_tmp14_ = pending;
					_tmp15_ = object;
					g_hash_table_remove (_tmp14_, _tmp15_);
					_g_object_unref0 (object);
					block5_data_unref (_data5_);
					_data5_ = NULL;
					continue;
				}
				_tmp16_ = object;
				_tmp17_ = seahorse_exportable_create_exporters (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, SEAHORSE_TYPE_EXPORTABLE, SeahorseExportable), SEAHORSE_EXPORTER_TYPE_ANY);
				exporters = _tmp17_;
				_tmp18_ = exporters;
				if (_tmp18_ == NULL) {
					__g_list_free__g_object_unref0_0 (exporters);
					_g_object_unref0 (object);
					block5_data_unref (_data5_);
					_data5_ = NULL;
					continue;
				}
				_tmp19_ = objects;
				{
					GList* x_collection = NULL;
					GList* x_it = NULL;
					x_collection = _tmp19_;
					for (x_it = x_collection; x_it != NULL; x_it = x_it->next) {
						GObject* _tmp20_ = NULL;
						GObject* x = NULL;
						_tmp20_ = _g_object_ref0 ((GObject*) x_it->data);
						x = _tmp20_;
						{
							GObject* _tmp21_ = NULL;
							GObject* _tmp22_ = NULL;
							GHashTable* _tmp23_ = NULL;
							GObject* _tmp24_ = NULL;
							gconstpointer _tmp25_ = NULL;
							_tmp21_ = x;
							_tmp22_ = object;
							if (_tmp21_ == _tmp22_) {
								_g_object_unref0 (x);
								continue;
							}
							_tmp23_ = pending;
							_tmp24_ = x;
							_tmp25_ = g_hash_table_lookup (_tmp23_, _tmp24_);
							if (((GObject*) _tmp25_) != NULL) {
								GList* _tmp26_ = NULL;
								_tmp26_ = exporters;
								{
									GList* exporter_collection = NULL;
									GList* exporter_it = NULL;
									exporter_collection = _tmp26_;
									for (exporter_it = exporter_collection; exporter_it != NULL; exporter_it = exporter_it->next) {
										SeahorseExporter* _tmp27_ = NULL;
										SeahorseExporter* exporter = NULL;
										_tmp27_ = _g_object_ref0 ((SeahorseExporter*) exporter_it->data);
										exporter = _tmp27_;
										{
											SeahorseExporter* _tmp28_ = NULL;
											GObject* _tmp29_ = NULL;
											_tmp28_ = exporter;
											_tmp29_ = x;
											seahorse_exporter_add_object (_tmp28_, _tmp29_);
											_g_object_unref0 (exporter);
										}
									}
								}
							}
							_g_object_unref0 (x);
						}
					}
				}
				directory = NULL;
				_tmp30_ = exporters;
				_tmp31_ = parent;
				_tmp34_ = seahorse_exportable_prompt (_tmp30_, _tmp31_, &directory, &_tmp32_, &_tmp33_);
				_g_object_unref0 (file);
				file = _tmp32_;
				_g_object_unref0 (exporter);
				exporter = _tmp33_;
				ret = _tmp34_;
				_tmp35_ = ret;
				if (!_tmp35_) {
					_g_object_unref0 (exporter);
					_g_object_unref0 (file);
					_g_free0 (directory);
					__g_list_free__g_object_unref0_0 (exporters);
					_g_object_unref0 (object);
					block5_data_unref (_data5_);
					_data5_ = NULL;
					break;
				}
				_tmp36_ = g_main_loop_new (NULL, FALSE);
				_data5_->loop = _tmp36_;
				_data5_->_result_ = NULL;
				_tmp37_ = exporter;
				_tmp38_ = file;
				seahorse_exporter_export_to_file (_tmp37_, _tmp38_, TRUE, NULL, _____lambda5__gasync_ready_callback, block5_data_ref (_data5_));
				_tmp39_ = _data5_->loop;
				g_main_loop_run (_tmp39_);
				_tmp40_ = exporter;
				_tmp41_ = _data5_->_result_;
				seahorse_exporter_export_to_file_finish (_tmp40_, _tmp41_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (exporter);
					_g_object_unref0 (file);
					_g_free0 (directory);
					__g_list_free__g_object_unref0_0 (exporters);
					_g_object_unref0 (object);
					block5_data_unref (_data5_);
					_data5_ = NULL;
					_g_hash_table_unref0 (pending);
					return 0;
				}
				_tmp42_ = exporter;
				_tmp43_ = seahorse_exporter_get_objects (_tmp42_);
				{
					GList* e_collection = NULL;
					GList* e_it = NULL;
					e_collection = _tmp43_;
					for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
						GObject* e = NULL;
						e = (GObject*) e_it->data;
						{
							GHashTable* _tmp44_ = NULL;
							GObject* _tmp45_ = NULL;
							gint _tmp46_ = 0;
							_tmp44_ = pending;
							_tmp45_ = e;
							g_hash_table_remove (_tmp44_, _tmp45_);
							_tmp46_ = count;
							count = _tmp46_ + 1;
						}
					}
				}
				_g_object_unref0 (exporter);
				_g_object_unref0 (file);
				_g_free0 (directory);
				__g_list_free__g_object_unref0_0 (exporters);
				_g_object_unref0 (object);
				block5_data_unref (_data5_);
				_data5_ = NULL;
			}
		}
	}
	result = count;
	_g_hash_table_unref0 (pending);
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar* seahorse_exportable_calculate_basename (GFile* file, const gchar* extension) {
	gchar* result = NULL;
	gchar* basename = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint dot = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_basename (_tmp0_);
	basename = _tmp1_;
	_tmp2_ = basename;
	_tmp3_ = string_last_index_of_char (_tmp2_, (gunichar) '.', 0);
	dot = _tmp3_;
	_tmp4_ = dot;
	if (_tmp4_ != (-1)) {
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		_tmp5_ = basename;
		_tmp6_ = dot;
		_tmp7_ = string_substring (_tmp5_, (glong) 0, (glong) _tmp6_);
		_g_free0 (basename);
		basename = _tmp7_;
	}
	_tmp8_ = basename;
	_tmp9_ = extension;
	_tmp10_ = g_strdup_printf ("%s%s", _tmp8_, _tmp9_);
	result = _tmp10_;
	_g_free0 (basename);
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_hash_table_unref0 (_data6_->filters);
		_g_object_unref0 (_data6_->chooser);
		g_slice_free (Block6Data, _data6_);
	}
}


static void __lambda4_ (Block6Data* _data6_, GObject* obj, GParamSpec* prop) {
	SeahorseExporter* exporter = NULL;
	GHashTable* _tmp0_ = NULL;
	GtkFileChooserDialog* _tmp1_ = NULL;
	GtkFileFilter* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	SeahorseExporter* _tmp4_ = NULL;
	gchar* name = NULL;
	SeahorseExporter* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint dot = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = _data6_->filters;
	_tmp1_ = _data6_->chooser;
	_tmp2_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp1_);
	_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((SeahorseExporter*) _tmp3_);
	exporter = _tmp4_;
	_tmp5_ = exporter;
	_tmp6_ = seahorse_exporter_get_filename (_tmp5_);
	_tmp7_ = _tmp6_;
	name = _tmp7_;
	_tmp8_ = name;
	_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '.', 0);
	dot = _tmp9_;
	_tmp10_ = dot;
	if (_tmp10_ != (-1)) {
		GFile* file = NULL;
		GtkFileChooserDialog* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		GFile* _tmp14_ = NULL;
		_tmp11_ = _data6_->chooser;
		_tmp12_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp11_);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		file = _tmp13_;
		_tmp14_ = file;
		if (_tmp14_ != NULL) {
			gchar* basename = NULL;
			GFile* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			GtkFileChooserDialog* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			_tmp15_ = file;
			_tmp16_ = name;
			_tmp17_ = dot;
			_tmp18_ = string_substring (_tmp16_, (glong) _tmp17_, (glong) (-1));
			_tmp19_ = _tmp18_;
			_tmp20_ = seahorse_exportable_calculate_basename (_tmp15_, _tmp19_);
			_tmp21_ = _tmp20_;
			_g_free0 (_tmp19_);
			basename = _tmp21_;
			_tmp22_ = _data6_->chooser;
			_tmp23_ = basename;
			gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp22_, _tmp23_);
			_g_free0 (basename);
		} else {
			GtkFileChooserDialog* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			_tmp24_ = _data6_->chooser;
			_tmp25_ = name;
			gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp24_, _tmp25_);
		}
		_g_object_unref0 (file);
	}
	_g_free0 (name);
	_g_object_unref0 (exporter);
}


static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda4_ (self, _sender, pspec);
}


gboolean seahorse_exportable_prompt (GList* exporters, GtkWindow* parent, gchar** directory, GFile** chosen_file, SeahorseExporter** chosen_exporter) {
	GFile* _vala_chosen_file = NULL;
	SeahorseExporter* _vala_chosen_exporter = NULL;
	gboolean result = FALSE;
	Block6Data* _data6_;
	GtkWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkFileChooserDialog* _tmp2_ = NULL;
	GtkFileChooserDialog* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_ = NULL;
	GtkFileChooserDialog* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GtkFileFilter* first = NULL;
	GHashFunc _tmp9_ = NULL;
	GEqualFunc _tmp10_ = NULL;
	GHashTable* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp28_ = NULL;
	GtkFileChooserDialog* _tmp29_ = NULL;
	GtkFileFilter* _tmp30_ = NULL;
	GtkFileChooserDialog* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	GtkFileChooserDialog* _tmp44_ = NULL;
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_tmp0_ = parent;
	_tmp1_ = _ ("Export");
	_tmp2_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (NULL, _tmp0_, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, _tmp1_, GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_object_ref_sink (_tmp2_);
	_data6_->chooser = _tmp2_;
	_tmp3_ = _data6_->chooser;
	gtk_dialog_set_default_response ((GtkDialog*) _tmp3_, (gint) GTK_RESPONSE_ACCEPT);
	_tmp4_ = _data6_->chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp4_, FALSE);
	_tmp5_ = _data6_->chooser;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp5_, TRUE);
	_tmp6_ = *directory;
	if (_tmp6_ != NULL) {
		GtkFileChooserDialog* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = _data6_->chooser;
		_tmp8_ = *directory;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp7_, _tmp8_);
	}
	first = NULL;
	_tmp9_ = g_direct_hash;
	_tmp10_ = g_direct_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, _g_object_unref0_, _g_object_unref0_);
	_data6_->filters = _tmp11_;
	_tmp12_ = exporters;
	{
		GList* exporter_collection = NULL;
		GList* exporter_it = NULL;
		exporter_collection = _tmp12_;
		for (exporter_it = exporter_collection; exporter_it != NULL; exporter_it = exporter_it->next) {
			SeahorseExporter* _tmp13_ = NULL;
			SeahorseExporter* exporter = NULL;
			_tmp13_ = _g_object_ref0 ((SeahorseExporter*) exporter_it->data);
			exporter = _tmp13_;
			{
				GtkFileFilter* filter = NULL;
				SeahorseExporter* _tmp14_ = NULL;
				GtkFileFilter* _tmp15_ = NULL;
				GtkFileFilter* _tmp16_ = NULL;
				GHashTable* _tmp17_ = NULL;
				GtkFileFilter* _tmp18_ = NULL;
				GtkFileFilter* _tmp19_ = NULL;
				SeahorseExporter* _tmp20_ = NULL;
				SeahorseExporter* _tmp21_ = NULL;
				GtkFileChooserDialog* _tmp22_ = NULL;
				GtkFileFilter* _tmp23_ = NULL;
				GtkFileFilter* _tmp24_ = NULL;
				GtkFileFilter* _tmp25_ = NULL;
				_tmp14_ = exporter;
				_tmp15_ = seahorse_exporter_get_file_filter (_tmp14_);
				_tmp16_ = _tmp15_;
				filter = _tmp16_;
				_tmp17_ = _data6_->filters;
				_tmp18_ = filter;
				_tmp19_ = _g_object_ref0 (_tmp18_);
				_tmp20_ = exporter;
				_tmp21_ = _g_object_ref0 (_tmp20_);
				g_hash_table_replace (_tmp17_, _tmp19_, _tmp21_);
				_tmp22_ = _data6_->chooser;
				_tmp23_ = filter;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp22_, _tmp24_);
				_tmp25_ = first;
				if (_tmp25_ == NULL) {
					GtkFileFilter* _tmp26_ = NULL;
					GtkFileFilter* _tmp27_ = NULL;
					_tmp26_ = filter;
					_tmp27_ = _g_object_ref0 (_tmp26_);
					_g_object_unref0 (first);
					first = _tmp27_;
				}
				_g_object_unref0 (filter);
				_g_object_unref0 (exporter);
			}
		}
	}
	_tmp28_ = _data6_->chooser;
	g_signal_connect_data ((GObject*) _tmp28_, "notify", (GCallback) ___lambda4__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp29_ = _data6_->chooser;
	_tmp30_ = first;
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp29_, _tmp30_);
	_tmp31_ = _data6_->chooser;
	_tmp32_ = gtk_dialog_run ((GtkDialog*) _tmp31_);
	if (_tmp32_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp33_ = NULL;
		GFile* _tmp34_ = NULL;
		GFile* _tmp35_ = NULL;
		GHashTable* _tmp36_ = NULL;
		GtkFileChooserDialog* _tmp37_ = NULL;
		GtkFileFilter* _tmp38_ = NULL;
		gconstpointer _tmp39_ = NULL;
		SeahorseExporter* _tmp40_ = NULL;
		GtkFileChooserDialog* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		GtkFileChooserDialog* _tmp43_ = NULL;
		_tmp33_ = _data6_->chooser;
		_tmp34_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp33_);
		_tmp35_ = _g_object_ref0 (_tmp34_);
		_g_object_unref0 (_vala_chosen_file);
		_vala_chosen_file = _tmp35_;
		_tmp36_ = _data6_->filters;
		_tmp37_ = _data6_->chooser;
		_tmp38_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp37_);
		_tmp39_ = g_hash_table_lookup (_tmp36_, _tmp38_);
		_tmp40_ = _g_object_ref0 ((SeahorseExporter*) _tmp39_);
		_g_object_unref0 (_vala_chosen_exporter);
		_vala_chosen_exporter = _tmp40_;
		_tmp41_ = _data6_->chooser;
		_tmp42_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp41_);
		_g_free0 (*directory);
		*directory = _tmp42_;
		_tmp43_ = _data6_->chooser;
		gtk_widget_destroy ((GtkWidget*) _tmp43_);
		result = TRUE;
		_g_object_unref0 (first);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		if (chosen_file) {
			*chosen_file = _vala_chosen_file;
		} else {
			_g_object_unref0 (_vala_chosen_file);
		}
		if (chosen_exporter) {
			*chosen_exporter = _vala_chosen_exporter;
		} else {
			_g_object_unref0 (_vala_chosen_exporter);
		}
		return result;
	}
	_g_object_unref0 (_vala_chosen_file);
	_vala_chosen_file = NULL;
	_g_object_unref0 (_vala_chosen_exporter);
	_vala_chosen_exporter = NULL;
	_tmp44_ = _data6_->chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp44_);
	result = FALSE;
	_g_object_unref0 (first);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	if (chosen_file) {
		*chosen_file = _vala_chosen_file;
	} else {
		_g_object_unref0 (_vala_chosen_file);
	}
	if (chosen_exporter) {
		*chosen_exporter = _vala_chosen_exporter;
	} else {
		_g_object_unref0 (_vala_chosen_exporter);
	}
	return result;
}


gboolean seahorse_exportable_get_exportable (SeahorseExportable* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return SEAHORSE_EXPORTABLE_GET_INTERFACE (self)->get_exportable (self);
}


static void seahorse_exportable_base_init (SeahorseExportableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_boolean ("exportable", "exportable", "exportable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType seahorse_exportable_get_type (void) {
	static volatile gsize seahorse_exportable_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_exportable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseExportableIface), (GBaseInitFunc) seahorse_exportable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType seahorse_exportable_type_id;
		seahorse_exportable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SeahorseExportable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (seahorse_exportable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&seahorse_exportable_type_id__volatile, seahorse_exportable_type_id);
	}
	return seahorse_exportable_type_id__volatile;
}



