/* theme.c generated by valac 0.24.0.38-0a8fb, the Vala compiler
 * generated from theme.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
typedef struct _ThemePrivate ThemePrivate;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecTheme ParamSpecTheme;

struct _Theme {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThemePrivate * priv;
};

struct _ThemeClass {
	GTypeClass parent_class;
	void (*finalize) (Theme *self);
};

struct _ThemePrivate {
	cairo_pattern_t* tile_colors[10];
	cairo_pattern_t* paused_color;
	cairo_pattern_t* text_colors[10];
};

struct _Tile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TilePrivate * priv;
	gint north;
	gint west;
	gint east;
	gint south;
	guint x;
	guint y;
};

struct _TileClass {
	GTypeClass parent_class;
	void (*finalize) (Tile *self);
};

struct _ParamSpecTheme {
	GParamSpec parent_instance;
};


static gpointer theme_parent_class = NULL;

gpointer theme_ref (gpointer instance);
void theme_unref (gpointer instance);
GParamSpec* param_spec_theme (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_theme (GValue* value, gpointer v_object);
void value_take_theme (GValue* value, gpointer v_object);
gpointer value_get_theme (const GValue* value);
GType theme_get_type (void) G_GNUC_CONST;
#define THEME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THEME, ThemePrivate))
enum  {
	THEME_DUMMY_PROPERTY
};
Theme* theme_new (void);
Theme* theme_construct (GType object_type);
static cairo_pattern_t* theme_make_color_pattern (Theme* self, const gchar* color);
static gdouble theme_hex_value (Theme* self, gchar c);
void theme_draw_arrow (Theme* self, cairo_t* context, guint size, guint gap);
void theme_draw_socket (Theme* self, cairo_t* context, guint size);
void theme_draw_paused_tile (Theme* self, cairo_t* context, guint size);
static void theme_draw_tile_background (Theme* self, cairo_t* context, guint size, cairo_pattern_t* north_color, cairo_pattern_t* east_color, cairo_pattern_t* south_color, cairo_pattern_t* west_color);
gpointer tile_ref (gpointer instance);
void tile_unref (gpointer instance);
GParamSpec* param_spec_tile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tile (GValue* value, gpointer v_object);
void value_take_tile (GValue* value, gpointer v_object);
gpointer value_get_tile (const GValue* value);
GType tile_get_type (void) G_GNUC_CONST;
void theme_draw_tile (Theme* self, cairo_t* context, guint size, Tile* tile);
static void theme_draw_number (Theme* self, cairo_t* context, gdouble x, gdouble y, guint number);
static void theme_finalize (Theme* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Theme* theme_construct (GType object_type) {
	Theme* self = NULL;
	cairo_pattern_t* _tmp0_ = NULL;
	cairo_pattern_t* _tmp1_ = NULL;
	cairo_pattern_t* _tmp2_ = NULL;
	cairo_pattern_t* _tmp3_ = NULL;
	cairo_pattern_t* _tmp4_ = NULL;
	cairo_pattern_t* _tmp5_ = NULL;
	cairo_pattern_t* _tmp6_ = NULL;
	cairo_pattern_t* _tmp7_ = NULL;
	cairo_pattern_t* _tmp8_ = NULL;
	cairo_pattern_t* _tmp9_ = NULL;
	cairo_pattern_t* _tmp10_ = NULL;
	cairo_pattern_t* _tmp11_ = NULL;
	cairo_pattern_t* _tmp12_ = NULL;
	cairo_pattern_t* _tmp13_ = NULL;
	cairo_pattern_t* _tmp14_ = NULL;
	cairo_pattern_t* _tmp15_ = NULL;
	cairo_pattern_t* _tmp16_ = NULL;
	cairo_pattern_t* _tmp17_ = NULL;
	cairo_pattern_t* _tmp18_ = NULL;
	cairo_pattern_t* _tmp19_ = NULL;
	cairo_pattern_t* _tmp20_ = NULL;
	cairo_pattern_t* _tmp21_ = NULL;
	cairo_pattern_t* _tmp22_ = NULL;
	cairo_pattern_t* _tmp23_ = NULL;
	cairo_pattern_t* _tmp24_ = NULL;
	cairo_pattern_t* _tmp25_ = NULL;
	cairo_pattern_t* _tmp26_ = NULL;
	cairo_pattern_t* _tmp27_ = NULL;
	cairo_pattern_t* _tmp28_ = NULL;
	cairo_pattern_t* _tmp29_ = NULL;
	cairo_pattern_t* _tmp30_ = NULL;
	cairo_pattern_t* _tmp31_ = NULL;
	cairo_pattern_t* _tmp32_ = NULL;
	cairo_pattern_t* _tmp33_ = NULL;
	cairo_pattern_t* _tmp34_ = NULL;
	cairo_pattern_t* _tmp35_ = NULL;
	cairo_pattern_t* _tmp36_ = NULL;
	cairo_pattern_t* _tmp37_ = NULL;
	cairo_pattern_t* _tmp38_ = NULL;
	cairo_pattern_t* _tmp39_ = NULL;
	cairo_pattern_t* _tmp40_ = NULL;
	self = (Theme*) g_type_create_instance (object_type);
	_tmp0_ = theme_make_color_pattern (self, "#000000");
	_cairo_pattern_destroy0 (self->priv->tile_colors[0]);
	self->priv->tile_colors[0] = _tmp0_;
	_tmp1_ = self->priv->tile_colors[0];
	_tmp2_ = theme_make_color_pattern (self, "#C17D11");
	_cairo_pattern_destroy0 (self->priv->tile_colors[1]);
	self->priv->tile_colors[1] = _tmp2_;
	_tmp3_ = self->priv->tile_colors[1];
	_tmp4_ = theme_make_color_pattern (self, "#CC0000");
	_cairo_pattern_destroy0 (self->priv->tile_colors[2]);
	self->priv->tile_colors[2] = _tmp4_;
	_tmp5_ = self->priv->tile_colors[2];
	_tmp6_ = theme_make_color_pattern (self, "#F57900");
	_cairo_pattern_destroy0 (self->priv->tile_colors[3]);
	self->priv->tile_colors[3] = _tmp6_;
	_tmp7_ = self->priv->tile_colors[3];
	_tmp8_ = theme_make_color_pattern (self, "#EDD400");
	_cairo_pattern_destroy0 (self->priv->tile_colors[4]);
	self->priv->tile_colors[4] = _tmp8_;
	_tmp9_ = self->priv->tile_colors[4];
	_tmp10_ = theme_make_color_pattern (self, "#73D216");
	_cairo_pattern_destroy0 (self->priv->tile_colors[5]);
	self->priv->tile_colors[5] = _tmp10_;
	_tmp11_ = self->priv->tile_colors[5];
	_tmp12_ = theme_make_color_pattern (self, "#3465A4");
	_cairo_pattern_destroy0 (self->priv->tile_colors[6]);
	self->priv->tile_colors[6] = _tmp12_;
	_tmp13_ = self->priv->tile_colors[6];
	_tmp14_ = theme_make_color_pattern (self, "#75507B");
	_cairo_pattern_destroy0 (self->priv->tile_colors[7]);
	self->priv->tile_colors[7] = _tmp14_;
	_tmp15_ = self->priv->tile_colors[7];
	_tmp16_ = theme_make_color_pattern (self, "#BABDB6");
	_cairo_pattern_destroy0 (self->priv->tile_colors[8]);
	self->priv->tile_colors[8] = _tmp16_;
	_tmp17_ = self->priv->tile_colors[8];
	_tmp18_ = theme_make_color_pattern (self, "#FFFFFF");
	_cairo_pattern_destroy0 (self->priv->tile_colors[9]);
	self->priv->tile_colors[9] = _tmp18_;
	_tmp19_ = self->priv->tile_colors[9];
	_tmp20_ = theme_make_color_pattern (self, "#CCCCCC");
	_cairo_pattern_destroy0 (self->priv->paused_color);
	self->priv->paused_color = _tmp20_;
	_tmp21_ = cairo_pattern_create_rgb ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	_cairo_pattern_destroy0 (self->priv->text_colors[0]);
	self->priv->text_colors[0] = _tmp21_;
	_tmp22_ = self->priv->text_colors[0];
	_tmp23_ = cairo_pattern_create_rgb ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	_cairo_pattern_destroy0 (self->priv->text_colors[1]);
	self->priv->text_colors[1] = _tmp23_;
	_tmp24_ = self->priv->text_colors[1];
	_tmp25_ = cairo_pattern_create_rgb ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	_cairo_pattern_destroy0 (self->priv->text_colors[2]);
	self->priv->text_colors[2] = _tmp25_;
	_tmp26_ = self->priv->text_colors[2];
	_tmp27_ = cairo_pattern_create_rgb ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	_cairo_pattern_destroy0 (self->priv->text_colors[3]);
	self->priv->text_colors[3] = _tmp27_;
	_tmp28_ = self->priv->text_colors[3];
	_tmp29_ = cairo_pattern_create_rgb ((gdouble) 0, (gdouble) 0, (gdouble) 0);
	_cairo_pattern_destroy0 (self->priv->text_colors[4]);
	self->priv->text_colors[4] = _tmp29_;
	_tmp30_ = self->priv->text_colors[4];
	_tmp31_ = cairo_pattern_create_rgb ((gdouble) 0, (gdouble) 0, (gdouble) 0);
	_cairo_pattern_destroy0 (self->priv->text_colors[5]);
	self->priv->text_colors[5] = _tmp31_;
	_tmp32_ = self->priv->text_colors[5];
	_tmp33_ = cairo_pattern_create_rgb ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	_cairo_pattern_destroy0 (self->priv->text_colors[6]);
	self->priv->text_colors[6] = _tmp33_;
	_tmp34_ = self->priv->text_colors[6];
	_tmp35_ = cairo_pattern_create_rgb ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	_cairo_pattern_destroy0 (self->priv->text_colors[7]);
	self->priv->text_colors[7] = _tmp35_;
	_tmp36_ = self->priv->text_colors[7];
	_tmp37_ = cairo_pattern_create_rgb ((gdouble) 0, (gdouble) 0, (gdouble) 0);
	_cairo_pattern_destroy0 (self->priv->text_colors[8]);
	self->priv->text_colors[8] = _tmp37_;
	_tmp38_ = self->priv->text_colors[8];
	_tmp39_ = cairo_pattern_create_rgb ((gdouble) 0, (gdouble) 0, (gdouble) 0);
	_cairo_pattern_destroy0 (self->priv->text_colors[9]);
	self->priv->text_colors[9] = _tmp39_;
	_tmp40_ = self->priv->text_colors[9];
	return self;
}


Theme* theme_new (void) {
	return theme_construct (TYPE_THEME);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static cairo_pattern_t* theme_make_color_pattern (Theme* self, const gchar* color) {
	cairo_pattern_t* result = NULL;
	gdouble r = 0.0;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	gdouble _tmp2_ = 0.0;
	const gchar* _tmp3_ = NULL;
	gchar _tmp4_ = '\0';
	gdouble _tmp5_ = 0.0;
	gdouble g = 0.0;
	const gchar* _tmp6_ = NULL;
	gchar _tmp7_ = '\0';
	gdouble _tmp8_ = 0.0;
	const gchar* _tmp9_ = NULL;
	gchar _tmp10_ = '\0';
	gdouble _tmp11_ = 0.0;
	gdouble b = 0.0;
	const gchar* _tmp12_ = NULL;
	gchar _tmp13_ = '\0';
	gdouble _tmp14_ = 0.0;
	const gchar* _tmp15_ = NULL;
	gchar _tmp16_ = '\0';
	gdouble _tmp17_ = 0.0;
	cairo_pattern_t* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	_tmp0_ = color;
	_tmp1_ = string_get (_tmp0_, (glong) 1);
	_tmp2_ = theme_hex_value (self, _tmp1_);
	_tmp3_ = color;
	_tmp4_ = string_get (_tmp3_, (glong) 2);
	_tmp5_ = theme_hex_value (self, _tmp4_);
	r = ((_tmp2_ * 16) + _tmp5_) / 255.0;
	_tmp6_ = color;
	_tmp7_ = string_get (_tmp6_, (glong) 3);
	_tmp8_ = theme_hex_value (self, _tmp7_);
	_tmp9_ = color;
	_tmp10_ = string_get (_tmp9_, (glong) 4);
	_tmp11_ = theme_hex_value (self, _tmp10_);
	g = ((_tmp8_ * 16) + _tmp11_) / 255.0;
	_tmp12_ = color;
	_tmp13_ = string_get (_tmp12_, (glong) 5);
	_tmp14_ = theme_hex_value (self, _tmp13_);
	_tmp15_ = color;
	_tmp16_ = string_get (_tmp15_, (glong) 6);
	_tmp17_ = theme_hex_value (self, _tmp16_);
	b = ((_tmp14_ * 16) + _tmp17_) / 255.0;
	_tmp18_ = cairo_pattern_create_rgb (r, g, b);
	result = _tmp18_;
	return result;
}


static gdouble theme_hex_value (Theme* self, gchar c) {
	gdouble result = 0.0;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = c;
	if (_tmp1_ >= '0') {
		gchar _tmp2_ = '\0';
		_tmp2_ = c;
		_tmp0_ = _tmp2_ <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar _tmp3_ = '\0';
		_tmp3_ = c;
		result = (gdouble) (_tmp3_ - '0');
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gchar _tmp5_ = '\0';
		_tmp5_ = c;
		if (_tmp5_ >= 'a') {
			gchar _tmp6_ = '\0';
			_tmp6_ = c;
			_tmp4_ = _tmp6_ <= 'f';
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gchar _tmp7_ = '\0';
			_tmp7_ = c;
			result = (gdouble) ((_tmp7_ - 'a') + 10);
			return result;
		} else {
			gboolean _tmp8_ = FALSE;
			gchar _tmp9_ = '\0';
			_tmp9_ = c;
			if (_tmp9_ >= 'A') {
				gchar _tmp10_ = '\0';
				_tmp10_ = c;
				_tmp8_ = _tmp10_ <= 'F';
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				gchar _tmp11_ = '\0';
				_tmp11_ = c;
				result = (gdouble) ((_tmp11_ - 'A') + 10);
				return result;
			} else {
				result = (gdouble) 0;
				return result;
			}
		}
	}
}


void theme_draw_arrow (Theme* self, cairo_t* context, guint size, guint gap) {
	gdouble w = 0.0;
	guint _tmp0_ = 0U;
	gdouble h = 0.0;
	guint _tmp1_ = 0U;
	guint depth = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	cairo_t* _tmp4_ = NULL;
	cairo_t* _tmp5_ = NULL;
	cairo_t* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	cairo_t* _tmp12_ = NULL;
	cairo_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	cairo_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	cairo_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
	cairo_t* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = gap;
	w = _tmp0_ * 0.5;
	_tmp1_ = size;
	h = _tmp1_ * 1.5;
	_tmp2_ = size;
	_tmp3_ = MIN ((guint) (_tmp2_ * 0.025), (guint) 2);
	depth = _tmp3_;
	dx = 1.4142 * depth;
	dy = 6.1623 * depth;
	_tmp4_ = context;
	cairo_move_to (_tmp4_, (gdouble) 0, (gdouble) 0);
	_tmp5_ = context;
	cairo_line_to (_tmp5_, w, h * 0.5);
	_tmp6_ = context;
	cairo_line_to (_tmp6_, w, (-h) * 0.5);
	_tmp7_ = context;
	cairo_close_path (_tmp7_);
	_tmp8_ = context;
	cairo_set_source_rgba (_tmp8_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.125);
	_tmp9_ = context;
	cairo_fill (_tmp9_);
	_tmp10_ = context;
	cairo_move_to (_tmp10_, w, (-h) * 0.5);
	_tmp11_ = context;
	cairo_line_to (_tmp11_, w, h * 0.5);
	_tmp12_ = context;
	cairo_line_to (_tmp12_, w - depth, (h * 0.5) - dy);
	_tmp13_ = context;
	cairo_line_to (_tmp13_, w - depth, ((-h) * 0.5) + dy);
	_tmp14_ = context;
	cairo_close_path (_tmp14_);
	_tmp15_ = context;
	cairo_set_source_rgba (_tmp15_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.125);
	_tmp16_ = context;
	cairo_fill (_tmp16_);
	_tmp17_ = context;
	cairo_move_to (_tmp17_, w, (-h) * 0.5);
	_tmp18_ = context;
	cairo_line_to (_tmp18_, (gdouble) 0, (gdouble) 0);
	_tmp19_ = context;
	cairo_line_to (_tmp19_, w, h * 0.5);
	_tmp20_ = context;
	cairo_line_to (_tmp20_, w - depth, (h * 0.5) - dy);
	_tmp21_ = context;
	cairo_line_to (_tmp21_, dx, (gdouble) 0);
	_tmp22_ = context;
	cairo_line_to (_tmp22_, w - depth, ((-h) * 0.5) + dy);
	_tmp23_ = context;
	cairo_close_path (_tmp23_);
	_tmp24_ = context;
	cairo_set_source_rgba (_tmp24_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
	_tmp25_ = context;
	cairo_fill (_tmp25_);
}


void theme_draw_socket (Theme* self, cairo_t* context, guint size) {
	guint depth = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	cairo_t* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	cairo_t* _tmp5_ = NULL;
	cairo_t* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	cairo_t* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	cairo_t* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	cairo_t* _tmp14_ = NULL;
	cairo_t* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	cairo_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	cairo_t* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	cairo_t* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	cairo_t* _tmp27_ = NULL;
	guint _tmp28_ = 0U;
	cairo_t* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	guint _tmp31_ = 0U;
	cairo_t* _tmp32_ = NULL;
	guint _tmp33_ = 0U;
	cairo_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = size;
	_tmp1_ = MIN ((guint) (_tmp0_ * 0.05), (guint) 4);
	depth = _tmp1_;
	_tmp2_ = context;
	_tmp3_ = size;
	_tmp4_ = size;
	cairo_rectangle (_tmp2_, (gdouble) depth, (gdouble) depth, (gdouble) (_tmp3_ - (depth * 2)), (gdouble) (_tmp4_ - (depth * 2)));
	_tmp5_ = context;
	cairo_set_source_rgba (_tmp5_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.125);
	_tmp6_ = context;
	cairo_fill (_tmp6_);
	_tmp7_ = context;
	_tmp8_ = size;
	cairo_move_to (_tmp7_, (gdouble) _tmp8_, (gdouble) 0);
	_tmp9_ = context;
	cairo_line_to (_tmp9_, (gdouble) 0, (gdouble) 0);
	_tmp10_ = context;
	_tmp11_ = size;
	cairo_line_to (_tmp10_, (gdouble) 0, (gdouble) _tmp11_);
	_tmp12_ = context;
	_tmp13_ = size;
	cairo_line_to (_tmp12_, (gdouble) depth, (gdouble) (_tmp13_ - depth));
	_tmp14_ = context;
	cairo_line_to (_tmp14_, (gdouble) depth, (gdouble) depth);
	_tmp15_ = context;
	_tmp16_ = size;
	cairo_line_to (_tmp15_, (gdouble) (_tmp16_ - depth), (gdouble) depth);
	_tmp17_ = context;
	cairo_close_path (_tmp17_);
	_tmp18_ = context;
	cairo_set_source_rgba (_tmp18_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
	_tmp19_ = context;
	cairo_fill (_tmp19_);
	_tmp20_ = context;
	_tmp21_ = size;
	cairo_move_to (_tmp20_, (gdouble) 0, (gdouble) _tmp21_);
	_tmp22_ = context;
	_tmp23_ = size;
	_tmp24_ = size;
	cairo_line_to (_tmp22_, (gdouble) _tmp23_, (gdouble) _tmp24_);
	_tmp25_ = context;
	_tmp26_ = size;
	cairo_line_to (_tmp25_, (gdouble) _tmp26_, (gdouble) 0);
	_tmp27_ = context;
	_tmp28_ = size;
	cairo_line_to (_tmp27_, (gdouble) (_tmp28_ - depth), (gdouble) depth);
	_tmp29_ = context;
	_tmp30_ = size;
	_tmp31_ = size;
	cairo_line_to (_tmp29_, (gdouble) (_tmp30_ - depth), (gdouble) (_tmp31_ - depth));
	_tmp32_ = context;
	_tmp33_ = size;
	cairo_line_to (_tmp32_, (gdouble) depth, (gdouble) (_tmp33_ - depth));
	_tmp34_ = context;
	cairo_close_path (_tmp34_);
	_tmp35_ = context;
	cairo_set_source_rgba (_tmp35_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.125);
	_tmp36_ = context;
	cairo_fill (_tmp36_);
}


void theme_draw_paused_tile (Theme* self, cairo_t* context, guint size) {
	cairo_t* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	cairo_pattern_t* _tmp2_ = NULL;
	cairo_pattern_t* _tmp3_ = NULL;
	cairo_pattern_t* _tmp4_ = NULL;
	cairo_pattern_t* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = size;
	_tmp2_ = self->priv->paused_color;
	_tmp3_ = self->priv->paused_color;
	_tmp4_ = self->priv->paused_color;
	_tmp5_ = self->priv->paused_color;
	theme_draw_tile_background (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
}


void theme_draw_tile (Theme* self, cairo_t* context, guint size, Tile* tile) {
	cairo_t* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Tile* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	cairo_pattern_t* _tmp4_ = NULL;
	Tile* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	cairo_pattern_t* _tmp7_ = NULL;
	Tile* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	cairo_pattern_t* _tmp10_ = NULL;
	Tile* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	cairo_pattern_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	cairo_t* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	cairo_t* _tmp17_ = NULL;
	Tile* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	cairo_pattern_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	guint _tmp23_ = 0U;
	Tile* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	cairo_t* _tmp26_ = NULL;
	Tile* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	cairo_pattern_t* _tmp29_ = NULL;
	cairo_t* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
	guint _tmp32_ = 0U;
	Tile* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	cairo_t* _tmp35_ = NULL;
	Tile* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	cairo_pattern_t* _tmp38_ = NULL;
	cairo_t* _tmp39_ = NULL;
	guint _tmp40_ = 0U;
	guint _tmp41_ = 0U;
	Tile* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	cairo_t* _tmp44_ = NULL;
	Tile* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	cairo_pattern_t* _tmp47_ = NULL;
	cairo_t* _tmp48_ = NULL;
	guint _tmp49_ = 0U;
	guint _tmp50_ = 0U;
	Tile* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = size;
	_tmp2_ = tile;
	_tmp3_ = _tmp2_->north;
	_tmp4_ = self->priv->tile_colors[_tmp3_];
	_tmp5_ = tile;
	_tmp6_ = _tmp5_->east;
	_tmp7_ = self->priv->tile_colors[_tmp6_];
	_tmp8_ = tile;
	_tmp9_ = _tmp8_->south;
	_tmp10_ = self->priv->tile_colors[_tmp9_];
	_tmp11_ = tile;
	_tmp12_ = _tmp11_->west;
	_tmp13_ = self->priv->tile_colors[_tmp12_];
	theme_draw_tile_background (self, _tmp0_, _tmp1_, _tmp4_, _tmp7_, _tmp10_, _tmp13_);
	_tmp14_ = context;
	cairo_select_font_face (_tmp14_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	_tmp15_ = context;
	_tmp16_ = size;
	cairo_set_font_size (_tmp15_, _tmp16_ / 3.5);
	_tmp17_ = context;
	_tmp18_ = tile;
	_tmp19_ = _tmp18_->north;
	_tmp20_ = self->priv->text_colors[_tmp19_];
	cairo_set_source (_tmp17_, _tmp20_);
	_tmp21_ = context;
	_tmp22_ = size;
	_tmp23_ = size;
	_tmp24_ = tile;
	_tmp25_ = _tmp24_->north;
	theme_draw_number (self, _tmp21_, _tmp22_ * 0.5, (gdouble) (_tmp23_ / 5), (guint) _tmp25_);
	_tmp26_ = context;
	_tmp27_ = tile;
	_tmp28_ = _tmp27_->south;
	_tmp29_ = self->priv->text_colors[_tmp28_];
	cairo_set_source (_tmp26_, _tmp29_);
	_tmp30_ = context;
	_tmp31_ = size;
	_tmp32_ = size;
	_tmp33_ = tile;
	_tmp34_ = _tmp33_->south;
	theme_draw_number (self, _tmp30_, _tmp31_ * 0.5, (gdouble) ((_tmp32_ * 4) / 5), (guint) _tmp34_);
	_tmp35_ = context;
	_tmp36_ = tile;
	_tmp37_ = _tmp36_->east;
	_tmp38_ = self->priv->text_colors[_tmp37_];
	cairo_set_source (_tmp35_, _tmp38_);
	_tmp39_ = context;
	_tmp40_ = size;
	_tmp41_ = size;
	_tmp42_ = tile;
	_tmp43_ = _tmp42_->east;
	theme_draw_number (self, _tmp39_, (gdouble) ((_tmp40_ * 4) / 5), _tmp41_ * 0.5, (guint) _tmp43_);
	_tmp44_ = context;
	_tmp45_ = tile;
	_tmp46_ = _tmp45_->west;
	_tmp47_ = self->priv->text_colors[_tmp46_];
	cairo_set_source (_tmp44_, _tmp47_);
	_tmp48_ = context;
	_tmp49_ = size;
	_tmp50_ = size;
	_tmp51_ = tile;
	_tmp52_ = _tmp51_->west;
	theme_draw_number (self, _tmp48_, (gdouble) (_tmp49_ / 5), _tmp50_ * 0.5, (guint) _tmp52_);
}


static void theme_draw_tile_background (Theme* self, cairo_t* context, guint size, cairo_pattern_t* north_color, cairo_pattern_t* east_color, cairo_pattern_t* south_color, cairo_pattern_t* west_color) {
	guint depth = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	cairo_t* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	cairo_t* _tmp5_ = NULL;
	cairo_pattern_t* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	cairo_t* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	cairo_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	cairo_t* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	cairo_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	cairo_t* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	cairo_t* _tmp28_ = NULL;
	guint _tmp29_ = 0U;
	guint _tmp30_ = 0U;
	cairo_t* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	cairo_t* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	guint _tmp37_ = 0U;
	guint _tmp38_ = 0U;
	guint _tmp39_ = 0U;
	cairo_t* _tmp40_ = NULL;
	cairo_pattern_t* _tmp41_ = NULL;
	cairo_t* _tmp42_ = NULL;
	cairo_t* _tmp43_ = NULL;
	guint _tmp44_ = 0U;
	cairo_t* _tmp45_ = NULL;
	guint _tmp46_ = 0U;
	cairo_t* _tmp47_ = NULL;
	guint _tmp48_ = 0U;
	guint _tmp49_ = 0U;
	cairo_t* _tmp50_ = NULL;
	guint _tmp51_ = 0U;
	guint _tmp52_ = 0U;
	cairo_t* _tmp53_ = NULL;
	cairo_t* _tmp54_ = NULL;
	cairo_t* _tmp55_ = NULL;
	cairo_t* _tmp56_ = NULL;
	guint _tmp57_ = 0U;
	cairo_t* _tmp58_ = NULL;
	guint _tmp59_ = 0U;
	guint _tmp60_ = 0U;
	cairo_t* _tmp61_ = NULL;
	guint _tmp62_ = 0U;
	guint _tmp63_ = 0U;
	cairo_t* _tmp64_ = NULL;
	guint _tmp65_ = 0U;
	guint _tmp66_ = 0U;
	cairo_t* _tmp67_ = NULL;
	guint _tmp68_ = 0U;
	guint _tmp69_ = 0U;
	cairo_t* _tmp70_ = NULL;
	guint _tmp71_ = 0U;
	cairo_t* _tmp72_ = NULL;
	cairo_t* _tmp73_ = NULL;
	cairo_t* _tmp74_ = NULL;
	cairo_t* _tmp75_ = NULL;
	guint _tmp76_ = 0U;
	cairo_t* _tmp77_ = NULL;
	guint _tmp78_ = 0U;
	guint _tmp79_ = 0U;
	cairo_t* _tmp80_ = NULL;
	guint _tmp81_ = 0U;
	guint _tmp82_ = 0U;
	cairo_t* _tmp83_ = NULL;
	cairo_t* _tmp84_ = NULL;
	cairo_pattern_t* _tmp85_ = NULL;
	cairo_t* _tmp86_ = NULL;
	cairo_t* _tmp87_ = NULL;
	guint _tmp88_ = 0U;
	cairo_t* _tmp89_ = NULL;
	guint _tmp90_ = 0U;
	guint _tmp91_ = 0U;
	cairo_t* _tmp92_ = NULL;
	guint _tmp93_ = 0U;
	guint _tmp94_ = 0U;
	cairo_t* _tmp95_ = NULL;
	guint _tmp96_ = 0U;
	guint _tmp97_ = 0U;
	cairo_t* _tmp98_ = NULL;
	guint _tmp99_ = 0U;
	guint _tmp100_ = 0U;
	cairo_t* _tmp101_ = NULL;
	guint _tmp102_ = 0U;
	cairo_t* _tmp103_ = NULL;
	cairo_t* _tmp104_ = NULL;
	cairo_t* _tmp105_ = NULL;
	cairo_t* _tmp106_ = NULL;
	guint _tmp107_ = 0U;
	cairo_t* _tmp108_ = NULL;
	guint _tmp109_ = 0U;
	guint _tmp110_ = 0U;
	cairo_t* _tmp111_ = NULL;
	guint _tmp112_ = 0U;
	guint _tmp113_ = 0U;
	cairo_t* _tmp114_ = NULL;
	guint _tmp115_ = 0U;
	cairo_t* _tmp116_ = NULL;
	cairo_t* _tmp117_ = NULL;
	cairo_t* _tmp118_ = NULL;
	cairo_t* _tmp119_ = NULL;
	cairo_t* _tmp120_ = NULL;
	guint _tmp121_ = 0U;
	cairo_t* _tmp122_ = NULL;
	guint _tmp123_ = 0U;
	guint _tmp124_ = 0U;
	cairo_t* _tmp125_ = NULL;
	cairo_t* _tmp126_ = NULL;
	cairo_pattern_t* _tmp127_ = NULL;
	cairo_t* _tmp128_ = NULL;
	cairo_t* _tmp129_ = NULL;
	cairo_t* _tmp130_ = NULL;
	guint _tmp131_ = 0U;
	cairo_t* _tmp132_ = NULL;
	guint _tmp133_ = 0U;
	cairo_t* _tmp134_ = NULL;
	cairo_t* _tmp135_ = NULL;
	cairo_t* _tmp136_ = NULL;
	cairo_t* _tmp137_ = NULL;
	cairo_t* _tmp138_ = NULL;
	cairo_t* _tmp139_ = NULL;
	guint _tmp140_ = 0U;
	guint _tmp141_ = 0U;
	cairo_t* _tmp142_ = NULL;
	guint _tmp143_ = 0U;
	cairo_t* _tmp144_ = NULL;
	guint _tmp145_ = 0U;
	cairo_t* _tmp146_ = NULL;
	guint _tmp147_ = 0U;
	guint _tmp148_ = 0U;
	cairo_t* _tmp149_ = NULL;
	cairo_t* _tmp150_ = NULL;
	cairo_t* _tmp151_ = NULL;
	cairo_t* _tmp152_ = NULL;
	cairo_t* _tmp153_ = NULL;
	cairo_t* _tmp154_ = NULL;
	cairo_t* _tmp155_ = NULL;
	guint _tmp156_ = 0U;
	guint _tmp157_ = 0U;
	cairo_t* _tmp158_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (north_color != NULL);
	g_return_if_fail (east_color != NULL);
	g_return_if_fail (south_color != NULL);
	g_return_if_fail (west_color != NULL);
	_tmp0_ = size;
	_tmp1_ = MIN ((guint) (_tmp0_ * 0.05), (guint) 4);
	depth = _tmp1_;
	dx = 2.4142 * depth;
	dy = 1.4142 * depth;
	_tmp2_ = context;
	_tmp3_ = size;
	_tmp4_ = size;
	cairo_rectangle (_tmp2_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp3_, _tmp4_ * 0.5);
	_tmp5_ = context;
	_tmp6_ = north_color;
	cairo_set_source (_tmp5_, _tmp6_);
	_tmp7_ = context;
	cairo_fill (_tmp7_);
	_tmp8_ = context;
	cairo_move_to (_tmp8_, (gdouble) 0, (gdouble) 0);
	_tmp9_ = context;
	_tmp10_ = size;
	cairo_line_to (_tmp9_, (gdouble) _tmp10_, (gdouble) 0);
	_tmp11_ = context;
	_tmp12_ = size;
	cairo_line_to (_tmp11_, _tmp12_ - dx, (gdouble) depth);
	_tmp13_ = context;
	cairo_line_to (_tmp13_, dx, (gdouble) depth);
	_tmp14_ = context;
	_tmp15_ = size;
	_tmp16_ = size;
	cairo_line_to (_tmp14_, _tmp15_ * 0.5, (_tmp16_ * 0.5) - dy);
	_tmp17_ = context;
	_tmp18_ = size;
	_tmp19_ = size;
	cairo_line_to (_tmp17_, _tmp18_ * 0.5, _tmp19_ * 0.5);
	_tmp20_ = context;
	cairo_close_path (_tmp20_);
	_tmp21_ = context;
	cairo_set_source_rgba (_tmp21_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.125);
	_tmp22_ = context;
	cairo_fill (_tmp22_);
	_tmp23_ = context;
	_tmp24_ = size;
	cairo_move_to (_tmp23_, (gdouble) _tmp24_, (gdouble) 0);
	_tmp25_ = context;
	_tmp26_ = size;
	_tmp27_ = size;
	cairo_line_to (_tmp25_, _tmp26_ * 0.5, _tmp27_ * 0.5);
	_tmp28_ = context;
	_tmp29_ = size;
	_tmp30_ = size;
	cairo_line_to (_tmp28_, _tmp29_ * 0.5, (_tmp30_ * 0.5) - dy);
	_tmp31_ = context;
	_tmp32_ = size;
	cairo_line_to (_tmp31_, _tmp32_ - dx, (gdouble) depth);
	_tmp33_ = context;
	cairo_close_path (_tmp33_);
	_tmp34_ = context;
	cairo_set_source_rgba (_tmp34_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
	_tmp35_ = context;
	cairo_fill (_tmp35_);
	_tmp36_ = context;
	_tmp37_ = size;
	_tmp38_ = size;
	_tmp39_ = size;
	cairo_rectangle (_tmp36_, (gdouble) 0, _tmp37_ * 0.5, (gdouble) _tmp38_, _tmp39_ * 0.5);
	_tmp40_ = context;
	_tmp41_ = south_color;
	cairo_set_source (_tmp40_, _tmp41_);
	_tmp42_ = context;
	cairo_fill (_tmp42_);
	_tmp43_ = context;
	_tmp44_ = size;
	cairo_move_to (_tmp43_, (gdouble) 0, (gdouble) _tmp44_);
	_tmp45_ = context;
	_tmp46_ = size;
	cairo_line_to (_tmp45_, dx, (gdouble) (_tmp46_ - depth));
	_tmp47_ = context;
	_tmp48_ = size;
	_tmp49_ = size;
	cairo_line_to (_tmp47_, _tmp48_ * 0.5, (_tmp49_ * 0.5) + dy);
	_tmp50_ = context;
	_tmp51_ = size;
	_tmp52_ = size;
	cairo_line_to (_tmp50_, _tmp51_ * 0.5, _tmp52_ * 0.5);
	_tmp53_ = context;
	cairo_close_path (_tmp53_);
	_tmp54_ = context;
	cairo_set_source_rgba (_tmp54_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.125);
	_tmp55_ = context;
	cairo_fill (_tmp55_);
	_tmp56_ = context;
	_tmp57_ = size;
	cairo_move_to (_tmp56_, (gdouble) 0, (gdouble) _tmp57_);
	_tmp58_ = context;
	_tmp59_ = size;
	_tmp60_ = size;
	cairo_line_to (_tmp58_, (gdouble) _tmp59_, (gdouble) _tmp60_);
	_tmp61_ = context;
	_tmp62_ = size;
	_tmp63_ = size;
	cairo_line_to (_tmp61_, _tmp62_ * 0.5, _tmp63_ * 0.5);
	_tmp64_ = context;
	_tmp65_ = size;
	_tmp66_ = size;
	cairo_line_to (_tmp64_, _tmp65_ * 0.5, (_tmp66_ * 0.5) + dy);
	_tmp67_ = context;
	_tmp68_ = size;
	_tmp69_ = size;
	cairo_line_to (_tmp67_, _tmp68_ - dx, (gdouble) (_tmp69_ - depth));
	_tmp70_ = context;
	_tmp71_ = size;
	cairo_line_to (_tmp70_, dx, (gdouble) (_tmp71_ - depth));
	_tmp72_ = context;
	cairo_close_path (_tmp72_);
	_tmp73_ = context;
	cairo_set_source_rgba (_tmp73_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
	_tmp74_ = context;
	cairo_fill (_tmp74_);
	_tmp75_ = context;
	_tmp76_ = size;
	cairo_move_to (_tmp75_, (gdouble) _tmp76_, (gdouble) 0);
	_tmp77_ = context;
	_tmp78_ = size;
	_tmp79_ = size;
	cairo_line_to (_tmp77_, (gdouble) _tmp78_, (gdouble) _tmp79_);
	_tmp80_ = context;
	_tmp81_ = size;
	_tmp82_ = size;
	cairo_line_to (_tmp80_, _tmp81_ * 0.5, _tmp82_ * 0.5);
	_tmp83_ = context;
	cairo_close_path (_tmp83_);
	_tmp84_ = context;
	_tmp85_ = east_color;
	cairo_set_source (_tmp84_, _tmp85_);
	_tmp86_ = context;
	cairo_fill (_tmp86_);
	_tmp87_ = context;
	_tmp88_ = size;
	cairo_move_to (_tmp87_, (gdouble) _tmp88_, (gdouble) 0);
	_tmp89_ = context;
	_tmp90_ = size;
	_tmp91_ = size;
	cairo_line_to (_tmp89_, _tmp90_ * 0.5, _tmp91_ * 0.5);
	_tmp92_ = context;
	_tmp93_ = size;
	_tmp94_ = size;
	cairo_line_to (_tmp92_, (gdouble) _tmp93_, (gdouble) _tmp94_);
	_tmp95_ = context;
	_tmp96_ = size;
	_tmp97_ = size;
	cairo_line_to (_tmp95_, (gdouble) (_tmp96_ - depth), _tmp97_ - dx);
	_tmp98_ = context;
	_tmp99_ = size;
	_tmp100_ = size;
	cairo_line_to (_tmp98_, (_tmp99_ * 0.5) + dy, _tmp100_ * 0.5);
	_tmp101_ = context;
	_tmp102_ = size;
	cairo_line_to (_tmp101_, (gdouble) (_tmp102_ - depth), dx);
	_tmp103_ = context;
	cairo_close_path (_tmp103_);
	_tmp104_ = context;
	cairo_set_source_rgba (_tmp104_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.125);
	_tmp105_ = context;
	cairo_fill (_tmp105_);
	_tmp106_ = context;
	_tmp107_ = size;
	cairo_move_to (_tmp106_, (gdouble) _tmp107_, (gdouble) 0);
	_tmp108_ = context;
	_tmp109_ = size;
	_tmp110_ = size;
	cairo_line_to (_tmp108_, (gdouble) _tmp109_, (gdouble) _tmp110_);
	_tmp111_ = context;
	_tmp112_ = size;
	_tmp113_ = size;
	cairo_line_to (_tmp111_, (gdouble) (_tmp112_ - depth), _tmp113_ - dx);
	_tmp114_ = context;
	_tmp115_ = size;
	cairo_line_to (_tmp114_, (gdouble) (_tmp115_ - depth), dx);
	_tmp116_ = context;
	cairo_close_path (_tmp116_);
	_tmp117_ = context;
	cairo_set_source_rgba (_tmp117_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
	_tmp118_ = context;
	cairo_fill (_tmp118_);
	_tmp119_ = context;
	cairo_move_to (_tmp119_, (gdouble) 0, (gdouble) 0);
	_tmp120_ = context;
	_tmp121_ = size;
	cairo_line_to (_tmp120_, (gdouble) 0, (gdouble) _tmp121_);
	_tmp122_ = context;
	_tmp123_ = size;
	_tmp124_ = size;
	cairo_line_to (_tmp122_, _tmp123_ * 0.5, _tmp124_ * 0.5);
	_tmp125_ = context;
	cairo_close_path (_tmp125_);
	_tmp126_ = context;
	_tmp127_ = west_color;
	cairo_set_source (_tmp126_, _tmp127_);
	_tmp128_ = context;
	cairo_fill (_tmp128_);
	_tmp129_ = context;
	cairo_move_to (_tmp129_, (gdouble) 0, (gdouble) 0);
	_tmp130_ = context;
	_tmp131_ = size;
	cairo_line_to (_tmp130_, (gdouble) 0, (gdouble) _tmp131_);
	_tmp132_ = context;
	_tmp133_ = size;
	cairo_line_to (_tmp132_, (gdouble) depth, _tmp133_ - dx);
	_tmp134_ = context;
	cairo_line_to (_tmp134_, (gdouble) depth, dx);
	_tmp135_ = context;
	cairo_close_path (_tmp135_);
	_tmp136_ = context;
	cairo_set_source_rgba (_tmp136_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.125);
	_tmp137_ = context;
	cairo_fill (_tmp137_);
	_tmp138_ = context;
	cairo_move_to (_tmp138_, (gdouble) 0, (gdouble) 0);
	_tmp139_ = context;
	_tmp140_ = size;
	_tmp141_ = size;
	cairo_line_to (_tmp139_, _tmp140_ * 0.5, _tmp141_ * 0.5);
	_tmp142_ = context;
	_tmp143_ = size;
	cairo_line_to (_tmp142_, (gdouble) 0, (gdouble) _tmp143_);
	_tmp144_ = context;
	_tmp145_ = size;
	cairo_line_to (_tmp144_, (gdouble) depth, _tmp145_ - dx);
	_tmp146_ = context;
	_tmp147_ = size;
	_tmp148_ = size;
	cairo_line_to (_tmp146_, (_tmp147_ * 0.5) - dy, _tmp148_ * 0.5);
	_tmp149_ = context;
	cairo_line_to (_tmp149_, (gdouble) depth, dx);
	_tmp150_ = context;
	cairo_close_path (_tmp150_);
	_tmp151_ = context;
	cairo_set_source_rgba (_tmp151_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
	_tmp152_ = context;
	cairo_fill (_tmp152_);
	_tmp153_ = context;
	cairo_set_line_width (_tmp153_, 1.0);
	_tmp154_ = context;
	cairo_set_source_rgb (_tmp154_, 0.0, 0.0, 0.0);
	_tmp155_ = context;
	_tmp156_ = size;
	_tmp157_ = size;
	cairo_rectangle (_tmp155_, 0.5, 0.5, _tmp156_ - 1.0, _tmp157_ - 1.0);
	_tmp158_ = context;
	cairo_stroke (_tmp158_);
}


static void theme_draw_number (Theme* self, cairo_t* context, gdouble x, gdouble y, guint number) {
	gchar* text = NULL;
	guint _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp2_ = NULL;
	cairo_text_extents_t _tmp3_ = {0};
	cairo_t* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	cairo_text_extents_t _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	cairo_text_extents_t _tmp9_ = {0};
	gdouble _tmp10_ = 0.0;
	cairo_t* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = number;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	text = _tmp1_;
	_tmp2_ = context;
	cairo_text_extents (_tmp2_, text, &_tmp3_);
	extents = _tmp3_;
	_tmp4_ = context;
	_tmp5_ = x;
	_tmp6_ = extents;
	_tmp7_ = _tmp6_.width;
	_tmp8_ = y;
	_tmp9_ = extents;
	_tmp10_ = _tmp9_.height;
	cairo_move_to (_tmp4_, _tmp5_ - (_tmp7_ / 2.0), _tmp8_ + (_tmp10_ / 2.0));
	_tmp11_ = context;
	cairo_show_text (_tmp11_, text);
	_g_free0 (text);
}


static void value_theme_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_theme_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		theme_unref (value->data[0].v_pointer);
	}
}


static void value_theme_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = theme_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_theme_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_theme_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Theme* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = theme_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_theme_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Theme** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = theme_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_theme (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTheme* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_THEME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_theme (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME), NULL);
	return value->data[0].v_pointer;
}


void value_set_theme (GValue* value, gpointer v_object) {
	Theme* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THEME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		theme_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		theme_unref (old);
	}
}


void value_take_theme (GValue* value, gpointer v_object) {
	Theme* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THEME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		theme_unref (old);
	}
}


static void theme_class_init (ThemeClass * klass) {
	theme_parent_class = g_type_class_peek_parent (klass);
	THEME_CLASS (klass)->finalize = theme_finalize;
	g_type_class_add_private (klass, sizeof (ThemePrivate));
}


static void theme_instance_init (Theme * self) {
	self->priv = THEME_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void theme_finalize (Theme* obj) {
	Theme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME, Theme);
	_vala_array_destroy (self->priv->tile_colors, 10, (GDestroyNotify) cairo_pattern_destroy);
	_cairo_pattern_destroy0 (self->priv->paused_color);
	_vala_array_destroy (self->priv->text_colors, 10, (GDestroyNotify) cairo_pattern_destroy);
}


GType theme_get_type (void) {
	static volatile gsize theme_type_id__volatile = 0;
	if (g_once_init_enter (&theme_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_theme_init, value_theme_free_value, value_theme_copy_value, value_theme_peek_pointer, "p", value_theme_collect_value, "p", value_theme_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Theme), 0, (GInstanceInitFunc) theme_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType theme_type_id;
		theme_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Theme", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&theme_type_id__volatile, theme_type_id);
	}
	return theme_type_id__volatile;
}


gpointer theme_ref (gpointer instance) {
	Theme* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void theme_unref (gpointer instance) {
	Theme* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		THEME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



