/* cheese-countdown.c generated by valac 0.22.0.45-383d, the Vala compiler
 * generated from cheese-countdown.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <gio/gio.h>


#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

typedef void (*CheeseCountdownCountdownCallback) (void* user_data);
struct _CheeseCountdownPrivate {
	ClutterText* countdown_actor;
	CheeseCountdownCountdownCallback completed_callback;
	gpointer completed_callback_target;
	gint current_value;
	GSettings* settings;
};


static gpointer cheese_countdown_parent_class = NULL;

GType cheese_countdown_get_type (void) G_GNUC_CONST;
#define CHEESE_COUNTDOWN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_COUNTDOWN, CheeseCountdownPrivate))
enum  {
	CHEESE_COUNTDOWN_DUMMY_PROPERTY
};
void cheese_countdown_stop (CheeseCountdown* self);
CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
CheeseCountdown* cheese_countdown_construct (GType object_type, ClutterText* countdown_actor);
static void cheese_countdown_fade_out (CheeseCountdown* self);
static void cheese_countdown_fade_in (CheeseCountdown* self);
static void _cheese_countdown_fade_in_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void _cheese_countdown_fade_out_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
void cheese_countdown_start (CheeseCountdown* self, CheeseCountdownCountdownCallback completed_callback, void* completed_callback_target);
static void cheese_countdown_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CheeseCountdown* cheese_countdown_construct (GType object_type, ClutterText* countdown_actor) {
	CheeseCountdown * self = NULL;
	ClutterText* _tmp0_ = NULL;
	ClutterText* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	g_return_val_if_fail (countdown_actor != NULL, NULL);
	self = (CheeseCountdown*) g_object_new (object_type, NULL);
	_tmp0_ = countdown_actor;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->countdown_actor);
	self->priv->countdown_actor = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	return self;
}


CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor) {
	return cheese_countdown_construct (CHEESE_TYPE_COUNTDOWN, countdown_actor);
}


/**
   * Fade the countdown text out, over 500 milliseconds.
   *
   * Once the fade-out is complete, this method calls fade_in().
   */
static void _cheese_countdown_fade_in_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	cheese_countdown_fade_in (self);
}


static void cheese_countdown_fade_out (CheeseCountdown* self) {
	ClutterPropertyTransition* pulse_out = NULL;
	ClutterPropertyTransition* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	ClutterText* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
	pulse_out = _tmp0_;
	clutter_timeline_set_duration ((ClutterTimeline*) pulse_out, (guint) 500);
	g_value_init (&_tmp1_, G_TYPE_INT);
	g_value_set_int (&_tmp1_, 255);
	clutter_transition_set_from_value ((ClutterTransition*) pulse_out, &_tmp1_);
	G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL;
	g_value_init (&_tmp2_, G_TYPE_INT);
	g_value_set_int (&_tmp2_, 0);
	clutter_transition_set_to_value ((ClutterTransition*) pulse_out, &_tmp2_);
	G_IS_VALUE (&_tmp2_) ? (g_value_unset (&_tmp2_), NULL) : NULL;
	clutter_transition_set_remove_on_complete ((ClutterTransition*) pulse_out, TRUE);
	g_signal_connect_object ((ClutterTimeline*) pulse_out, "completed", (GCallback) _cheese_countdown_fade_in_clutter_timeline_completed, self, 0);
	_tmp3_ = self->priv->countdown_actor;
	clutter_actor_add_transition ((ClutterActor*) _tmp3_, "pulse-out", (ClutterTransition*) pulse_out);
	_g_object_unref0 (pulse_out);
}


/**
   * Decrement the countdown text and fade it in, over 500 milliseconds.
   *
   * Once the fade-in is complete, this method calls fade_out().
   */
static void _cheese_countdown_fade_out_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	cheese_countdown_fade_out (self);
}


static void cheese_countdown_fade_in (CheeseCountdown* self) {
	gint _tmp0_ = 0;
	ClutterText* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	ClutterPropertyTransition* pulse_in = NULL;
	ClutterPropertyTransition* _tmp7_ = NULL;
	ClutterPropertyTransition* _tmp8_ = NULL;
	ClutterPropertyTransition* _tmp9_ = NULL;
	GValue _tmp10_ = {0};
	ClutterPropertyTransition* _tmp11_ = NULL;
	GValue _tmp12_ = {0};
	ClutterPropertyTransition* _tmp13_ = NULL;
	ClutterPropertyTransition* _tmp14_ = NULL;
	ClutterText* _tmp15_ = NULL;
	ClutterPropertyTransition* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_value;
	if (_tmp0_ <= 0) {
		CheeseCountdownCountdownCallback _tmp1_ = NULL;
		void* _tmp1__target = NULL;
		_tmp1_ = self->priv->completed_callback;
		_tmp1__target = self->priv->completed_callback_target;
		_tmp1_ (_tmp1__target);
		self->running = FALSE;
		return;
	}
	_tmp2_ = self->priv->countdown_actor;
	_tmp3_ = self->priv->current_value;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	clutter_text_set_text (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->current_value;
	self->priv->current_value = _tmp6_ - 1;
	_tmp7_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
	pulse_in = _tmp7_;
	_tmp8_ = pulse_in;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp8_, (guint) 500);
	_tmp9_ = pulse_in;
	g_value_init (&_tmp10_, G_TYPE_INT);
	g_value_set_int (&_tmp10_, 0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp9_, &_tmp10_);
	G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
	_tmp11_ = pulse_in;
	g_value_init (&_tmp12_, G_TYPE_INT);
	g_value_set_int (&_tmp12_, 255);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp11_, &_tmp12_);
	G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
	_tmp13_ = pulse_in;
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp13_, TRUE);
	_tmp14_ = pulse_in;
	g_signal_connect_object ((ClutterTimeline*) _tmp14_, "completed", (GCallback) _cheese_countdown_fade_out_clutter_timeline_completed, self, 0);
	_tmp15_ = self->priv->countdown_actor;
	_tmp16_ = pulse_in;
	clutter_actor_add_transition ((ClutterActor*) _tmp15_, "pulse-in", (ClutterTransition*) _tmp16_);
	_g_object_unref0 (pulse_in);
}


/**
   * Start the countdown, using the countdown-duration GSetting for the time.
   *
   * @param completed_callback the callback to call upon countdown completion
   */
void cheese_countdown_start (CheeseCountdown* self, CheeseCountdownCountdownCallback completed_callback, void* completed_callback_target) {
	CheeseCountdownCountdownCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ClutterText* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = completed_callback;
	_tmp0__target = completed_callback_target;
	self->priv->completed_callback = _tmp0_;
	self->priv->completed_callback_target = _tmp0__target;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_int (_tmp1_, "countdown-duration");
	self->priv->current_value = _tmp2_;
	self->running = TRUE;
	_tmp3_ = self->priv->countdown_actor;
	clutter_actor_show ((ClutterActor*) _tmp3_);
	cheese_countdown_fade_in (self);
}


/**
   * Stop the countdown, for example if it was interrupted by the user.
   */
void cheese_countdown_stop (CheeseCountdown* self) {
	ClutterText* _tmp0_ = NULL;
	ClutterText* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->countdown_actor;
	clutter_actor_hide ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->countdown_actor;
	clutter_actor_remove_all_transitions ((ClutterActor*) _tmp1_);
	self->running = FALSE;
}


static void cheese_countdown_class_init (CheeseCountdownClass * klass) {
	cheese_countdown_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseCountdownPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_countdown_finalize;
}


static void cheese_countdown_instance_init (CheeseCountdown * self) {
	self->priv = CHEESE_COUNTDOWN_GET_PRIVATE (self);
	self->priv->current_value = 0;
}


static void cheese_countdown_finalize (GObject* obj) {
	CheeseCountdown * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_COUNTDOWN, CheeseCountdown);
	cheese_countdown_stop (self);
	_g_object_unref0 (self->priv->countdown_actor);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (cheese_countdown_parent_class)->finalize (obj);
}


GType cheese_countdown_get_type (void) {
	static volatile gsize cheese_countdown_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_countdown_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseCountdownClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_countdown_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseCountdown), 0, (GInstanceInitFunc) cheese_countdown_instance_init, NULL };
		GType cheese_countdown_type_id;
		cheese_countdown_type_id = g_type_register_static (G_TYPE_OBJECT, "CheeseCountdown", &g_define_type_info, 0);
		g_once_init_leave (&cheese_countdown_type_id__volatile, cheese_countdown_type_id);
	}
	return cheese_countdown_type_id__volatile;
}



