/* catalog.c generated by valac 0.20.1.64-fa28c, the Vala compiler
 * generated from catalog.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-internal.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _SeahorseCatalogPrivate {
	gchar* _ui_name;
	GtkBuilder* _builder;
	GtkUIManager* _ui_manager;
	GHashTable* _actions;
	GtkAction* _edit_delete;
	GtkAction* _properties_object;
	GtkAction* _file_export;
	GtkAction* _edit_copy;
	GList* _selection_actions;
	gboolean _disposed;
	GSettings* _settings;
};

struct _Block1Data {
	int _ref_count_;
	SeahorseCatalog * self;
	GtkAboutDialog* about;
};


static gpointer seahorse_catalog_parent_class = NULL;

#define SEAHORSE_CATALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_TYPE_CATALOG, SeahorseCatalogPrivate))
enum  {
	SEAHORSE_CATALOG_DUMMY_PROPERTY,
	SEAHORSE_CATALOG_WINDOW,
	SEAHORSE_CATALOG_UI_NAME
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_catalog_on_key_export_file (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_key_export_file_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_key_export_clipboard (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_key_export_clipboard_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_object_delete (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_object_delete_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_properties_object (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_properties_object_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_properties_place (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_properties_place_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_app_preferences (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_app_preferences_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_app_about (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_app_about_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_help_show (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_help_show_gtk_action_callback (GtkAction* action, gpointer self);
static GList* seahorse_catalog_real_get_backends (SeahorseCatalog* self);
static SeahorsePlace* seahorse_catalog_real_get_focused_place (SeahorseCatalog* self);
static GList* seahorse_catalog_real_get_selected_objects (SeahorseCatalog* self);
static void seahorse_catalog_real_dispose (GObject* base);
static GList* seahorse_catalog_lookup_actions_for_objects (SeahorseCatalog* self, GList* objects);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda8_ (Block1Data* _data1_, gint response);
static void ___lambda8__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void seahorse_catalog_real_selection_changed (SeahorseCatalog* self);
static GObject * seahorse_catalog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_catalog___lambda9_ (SeahorseCatalog* self, GtkWidget* widget);
static void __seahorse_catalog___lambda9__gtk_ui_manager_add_widget (GtkUIManager* _sender, GtkWidget* widget, gpointer self);
static void _seahorse_catalog___lambda10_ (SeahorseCatalog* self, GtkAction* action);
static void __seahorse_catalog___lambda10__gtk_ui_manager_pre_activate (GtkUIManager* _sender, GtkAction* action, gpointer self);
static void _seahorse_catalog___lambda11_ (SeahorseCatalog* self, GtkAction* action);
static void __seahorse_catalog___lambda11__gtk_ui_manager_post_activate (GtkUIManager* _sender, GtkAction* action, gpointer self);
static void seahorse_catalog_finalize (GObject* obj);
static void _vala_seahorse_catalog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_catalog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* SEAHORSE_CATALOG_AUTHORS[10] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Jose Carlos Garcia Sogo <jsogo@users.sourceforge.net>", "Jean Schurger <yshark@schurger.org>", "Stef Walter <stef@memberwebs.com>", "Adam Schreiber <sadam@clemson.edu>", "", "Contributions:", "Albrecht Dreß <albrecht.dress@arcor.de>", "Jim Pharis <binbrain@gmail.com>", NULL};
static const gchar* SEAHORSE_CATALOG_DOCUMENTERS[4] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Adam Schreiber <sadam@clemson.edu>", "Milo Casagrande <milo_casagrande@yahoo.it>", NULL};
static const gchar* SEAHORSE_CATALOG_ARTISTS[3] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Stef Walter <stef@memberwebs.com>", NULL};
static const GtkActionEntry SEAHORSE_CATALOG_UI_ENTRIES[12] = {{"file-menu", NULL, "_File"}, {"file-export", GTK_STOCK_SAVE_AS, "E_xport...", NULL, "Export to a file", (GCallback) _seahorse_catalog_on_key_export_file_gtk_action_callback}, {"edit-menu", NULL, "_Edit"}, {"edit-export-clipboard", GTK_STOCK_COPY, NULL, "<control>C", "Copy to the clipboard", (GCallback) _seahorse_catalog_on_key_export_clipboard_gtk_action_callback}, {"edit-delete", GTK_STOCK_DELETE, "_Delete", NULL, "Delete selected items", (GCallback) _seahorse_catalog_on_object_delete_gtk_action_callback}, {"properties-object", GTK_STOCK_PROPERTIES, NULL, NULL, "Show the properties of this item", (GCallback) _seahorse_catalog_on_properties_object_gtk_action_callback}, {"properties-keyring", GTK_STOCK_PROPERTIES, NULL, NULL, "Show the properties of this keyring", (GCallback) _seahorse_catalog_on_properties_place_gtk_action_callback}, {"app-preferences", GTK_STOCK_PREFERENCES, "Prefere_nces", NULL, "Change preferences for this program", (GCallback) _seahorse_catalog_on_app_preferences_gtk_action_callback}, {"view-menu", NULL, "_View"}, {"help-menu", NULL, "_Help"}, {"app-about", GTK_STOCK_ABOUT, NULL, NULL, "About this program", (GCallback) _seahorse_catalog_on_app_about_gtk_action_callback}, {"help-show", GTK_STOCK_HELP, "_Contents", "F1", "Show Seahorse help", (GCallback) _seahorse_catalog_on_help_show_gtk_action_callback}};

static void _g_object_unref0_ (gpointer var) {
#line 43 "/data/projects/seahorse/common/catalog.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 122 "catalog.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 43 "/data/projects/seahorse/common/catalog.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 43 "/data/projects/seahorse/common/catalog.vala"
	g_list_free (self);
#line 131 "catalog.c"
}


static void _seahorse_catalog_on_key_export_file_gtk_action_callback (GtkAction* action, gpointer self) {
#line 364 "/data/projects/seahorse/common/catalog.vala"
	seahorse_catalog_on_key_export_file (action, self);
#line 138 "catalog.c"
}


static void _seahorse_catalog_on_key_export_clipboard_gtk_action_callback (GtkAction* action, gpointer self) {
#line 364 "/data/projects/seahorse/common/catalog.vala"
	seahorse_catalog_on_key_export_clipboard (action, self);
#line 145 "catalog.c"
}


static void _seahorse_catalog_on_object_delete_gtk_action_callback (GtkAction* action, gpointer self) {
#line 364 "/data/projects/seahorse/common/catalog.vala"
	seahorse_catalog_on_object_delete (action, self);
#line 152 "catalog.c"
}


static void _seahorse_catalog_on_properties_object_gtk_action_callback (GtkAction* action, gpointer self) {
#line 364 "/data/projects/seahorse/common/catalog.vala"
	seahorse_catalog_on_properties_object (action, self);
#line 159 "catalog.c"
}


static void _seahorse_catalog_on_properties_place_gtk_action_callback (GtkAction* action, gpointer self) {
#line 364 "/data/projects/seahorse/common/catalog.vala"
	seahorse_catalog_on_properties_place (action, self);
#line 166 "catalog.c"
}


static void _seahorse_catalog_on_app_preferences_gtk_action_callback (GtkAction* action, gpointer self) {
#line 364 "/data/projects/seahorse/common/catalog.vala"
	seahorse_catalog_on_app_preferences (action, self);
#line 173 "catalog.c"
}


static void _seahorse_catalog_on_app_about_gtk_action_callback (GtkAction* action, gpointer self) {
#line 364 "/data/projects/seahorse/common/catalog.vala"
	seahorse_catalog_on_app_about (action, self);
#line 180 "catalog.c"
}


static void _seahorse_catalog_on_help_show_gtk_action_callback (GtkAction* action, gpointer self) {
#line 364 "/data/projects/seahorse/common/catalog.vala"
	seahorse_catalog_on_help_show (action, self);
#line 187 "catalog.c"
}


static GList* seahorse_catalog_real_get_backends (SeahorseCatalog* self) {
#line 47 "/data/projects/seahorse/common/catalog.vala"
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_backends'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 47 "/data/projects/seahorse/common/catalog.vala"
	return NULL;
#line 196 "catalog.c"
}


GList* seahorse_catalog_get_backends (SeahorseCatalog* self) {
#line 47 "/data/projects/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/data/projects/seahorse/common/catalog.vala"
	return SEAHORSE_CATALOG_GET_CLASS (self)->get_backends (self);
#line 205 "catalog.c"
}


static SeahorsePlace* seahorse_catalog_real_get_focused_place (SeahorseCatalog* self) {
#line 48 "/data/projects/seahorse/common/catalog.vala"
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_focused_place'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 48 "/data/projects/seahorse/common/catalog.vala"
	return NULL;
#line 214 "catalog.c"
}


SeahorsePlace* seahorse_catalog_get_focused_place (SeahorseCatalog* self) {
#line 48 "/data/projects/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "/data/projects/seahorse/common/catalog.vala"
	return SEAHORSE_CATALOG_GET_CLASS (self)->get_focused_place (self);
#line 223 "catalog.c"
}


static GList* seahorse_catalog_real_get_selected_objects (SeahorseCatalog* self) {
#line 49 "/data/projects/seahorse/common/catalog.vala"
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_selected_objects'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 49 "/data/projects/seahorse/common/catalog.vala"
	return NULL;
#line 232 "catalog.c"
}


GList* seahorse_catalog_get_selected_objects (SeahorseCatalog* self) {
#line 49 "/data/projects/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 49 "/data/projects/seahorse/common/catalog.vala"
	return SEAHORSE_CATALOG_GET_CLASS (self)->get_selected_objects (self);
#line 241 "catalog.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 122 "/data/projects/seahorse/common/catalog.vala"
	return self ? g_object_ref (self) : NULL;
#line 248 "catalog.c"
}


static void seahorse_catalog_real_dispose (GObject* base) {
	SeahorseCatalog * self;
	GList* _tmp0_ = NULL;
	GHashTable* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 116 "/data/projects/seahorse/common/catalog.vala"
	self = (SeahorseCatalog*) base;
#line 117 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_copy);
#line 117 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_edit_copy = NULL;
#line 118 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_delete);
#line 118 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_edit_delete = NULL;
#line 119 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_file_export);
#line 119 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_file_export = NULL;
#line 120 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_properties_object);
#line 120 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_properties_object = NULL;
#line 122 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_selection_actions;
#line 277 "catalog.c"
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
#line 122 "/data/projects/seahorse/common/catalog.vala"
		group_collection = _tmp0_;
#line 122 "/data/projects/seahorse/common/catalog.vala"
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
#line 285 "catalog.c"
			GtkActionGroup* _tmp1_ = NULL;
			GtkActionGroup* group = NULL;
#line 122 "/data/projects/seahorse/common/catalog.vala"
			_tmp1_ = _g_object_ref0 ((GtkActionGroup*) group_it->data);
#line 122 "/data/projects/seahorse/common/catalog.vala"
			group = _tmp1_;
#line 292 "catalog.c"
			{
				GtkUIManager* _tmp2_ = NULL;
				GtkActionGroup* _tmp3_ = NULL;
#line 123 "/data/projects/seahorse/common/catalog.vala"
				_tmp2_ = self->priv->_ui_manager;
#line 123 "/data/projects/seahorse/common/catalog.vala"
				_tmp3_ = group;
#line 123 "/data/projects/seahorse/common/catalog.vala"
				gtk_ui_manager_remove_action_group (_tmp2_, _tmp3_);
#line 122 "/data/projects/seahorse/common/catalog.vala"
				_g_object_unref0 (group);
#line 304 "catalog.c"
			}
		}
	}
#line 124 "/data/projects/seahorse/common/catalog.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_selection_actions);
#line 124 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_selection_actions = NULL;
#line 126 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 126 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_ui_manager = NULL;
#line 127 "/data/projects/seahorse/common/catalog.vala"
	_tmp4_ = self->priv->_actions;
#line 127 "/data/projects/seahorse/common/catalog.vala"
	g_hash_table_remove_all (_tmp4_);
#line 129 "/data/projects/seahorse/common/catalog.vala"
	_tmp5_ = self->priv->_disposed;
#line 129 "/data/projects/seahorse/common/catalog.vala"
	if (!_tmp5_) {
#line 324 "catalog.c"
		gint width = 0;
		gint height = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		GSettings* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		GSettings* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		GtkApplication* _tmp12_ = NULL;
#line 130 "/data/projects/seahorse/common/catalog.vala"
		self->priv->_disposed = TRUE;
#line 133 "/data/projects/seahorse/common/catalog.vala"
		gtk_window_get_size ((GtkWindow*) self, &_tmp6_, &_tmp7_);
#line 133 "/data/projects/seahorse/common/catalog.vala"
		width = _tmp6_;
#line 133 "/data/projects/seahorse/common/catalog.vala"
		height = _tmp7_;
#line 134 "/data/projects/seahorse/common/catalog.vala"
		_tmp8_ = self->priv->_settings;
#line 134 "/data/projects/seahorse/common/catalog.vala"
		_tmp9_ = width;
#line 134 "/data/projects/seahorse/common/catalog.vala"
		g_settings_set_int (_tmp8_, "width", _tmp9_);
#line 135 "/data/projects/seahorse/common/catalog.vala"
		_tmp10_ = self->priv->_settings;
#line 135 "/data/projects/seahorse/common/catalog.vala"
		_tmp11_ = height;
#line 135 "/data/projects/seahorse/common/catalog.vala"
		g_settings_set_int (_tmp10_, "height", _tmp11_);
#line 136 "/data/projects/seahorse/common/catalog.vala"
		_tmp12_ = seahorse_application_get ();
#line 136 "/data/projects/seahorse/common/catalog.vala"
		gtk_application_remove_window (_tmp12_, (GtkWindow*) self);
#line 358 "catalog.c"
	}
#line 139 "/data/projects/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (seahorse_catalog_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WINDOW, GtkWindow));
#line 362 "catalog.c"
}


GtkBuilder* seahorse_catalog_get_builder (SeahorseCatalog* self) {
	GtkBuilder* result = NULL;
	GtkBuilder* _tmp0_ = NULL;
#line 171 "/data/projects/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 172 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_builder;
#line 172 "/data/projects/seahorse/common/catalog.vala"
	result = _tmp0_;
#line 172 "/data/projects/seahorse/common/catalog.vala"
	return result;
#line 377 "catalog.c"
}


gconstpointer seahorse_catalog_get_widget (SeahorseCatalog* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* name) {
	gconstpointer result = NULL;
	GtkBuilder* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
#line 175 "/data/projects/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 175 "/data/projects/seahorse/common/catalog.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 176 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_builder;
#line 176 "/data/projects/seahorse/common/catalog.vala"
	_tmp1_ = name;
#line 176 "/data/projects/seahorse/common/catalog.vala"
	_tmp2_ = gtk_builder_get_object (_tmp0_, _tmp1_);
#line 176 "/data/projects/seahorse/common/catalog.vala"
	result = (gconstpointer) _tmp2_;
#line 176 "/data/projects/seahorse/common/catalog.vala"
	return result;
#line 400 "catalog.c"
}


void seahorse_catalog_ensure_updated (SeahorseCatalog* self) {
	GtkUIManager* _tmp0_ = NULL;
#line 179 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 180 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 180 "/data/projects/seahorse/common/catalog.vala"
	gtk_ui_manager_ensure_update (_tmp0_);
#line 412 "catalog.c"
}


void seahorse_catalog_include_actions (SeahorseCatalog* self, GtkActionGroup* group) {
	GtkUIManager* _tmp0_ = NULL;
	GtkActionGroup* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	GHashTable* _tmp17_ = NULL;
	GtkActionGroup* _tmp18_ = NULL;
	GtkActionGroup* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
#line 183 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 183 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (group != NULL);
#line 184 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 184 "/data/projects/seahorse/common/catalog.vala"
	_tmp1_ = group;
#line 184 "/data/projects/seahorse/common/catalog.vala"
	gtk_ui_manager_insert_action_group (_tmp0_, _tmp1_, 10);
#line 186 "/data/projects/seahorse/common/catalog.vala"
	_tmp2_ = group;
#line 186 "/data/projects/seahorse/common/catalog.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, SEAHORSE_TYPE_ACTIONS)) {
#line 438 "catalog.c"
		SeahorseActions* actions = NULL;
		GtkActionGroup* _tmp3_ = NULL;
		SeahorseActions* _tmp4_ = NULL;
		SeahorseActions* _tmp5_ = NULL;
		gchar* definition = NULL;
		SeahorseActions* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 187 "/data/projects/seahorse/common/catalog.vala"
		_tmp3_ = group;
#line 187 "/data/projects/seahorse/common/catalog.vala"
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SEAHORSE_TYPE_ACTIONS, SeahorseActions));
#line 187 "/data/projects/seahorse/common/catalog.vala"
		actions = _tmp4_;
#line 188 "/data/projects/seahorse/common/catalog.vala"
		_tmp5_ = actions;
#line 188 "/data/projects/seahorse/common/catalog.vala"
		seahorse_actions_set_catalog (_tmp5_, self);
#line 190 "/data/projects/seahorse/common/catalog.vala"
		_tmp6_ = actions;
#line 190 "/data/projects/seahorse/common/catalog.vala"
		_tmp7_ = seahorse_actions_get_definition (_tmp6_);
#line 190 "/data/projects/seahorse/common/catalog.vala"
		_tmp8_ = _tmp7_;
#line 190 "/data/projects/seahorse/common/catalog.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 190 "/data/projects/seahorse/common/catalog.vala"
		definition = _tmp9_;
#line 191 "/data/projects/seahorse/common/catalog.vala"
		_tmp10_ = definition;
#line 191 "/data/projects/seahorse/common/catalog.vala"
		if (_tmp10_ != NULL) {
#line 473 "catalog.c"
			{
				GtkUIManager* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
#line 193 "/data/projects/seahorse/common/catalog.vala"
				_tmp11_ = self->priv->_ui_manager;
#line 193 "/data/projects/seahorse/common/catalog.vala"
				_tmp12_ = definition;
#line 193 "/data/projects/seahorse/common/catalog.vala"
				gtk_ui_manager_add_ui_from_string (_tmp11_, _tmp12_, (gssize) (-1), &_inner_error_);
#line 193 "/data/projects/seahorse/common/catalog.vala"
				if (_inner_error_ != NULL) {
#line 485 "catalog.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				SeahorseActions* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
#line 192 "/data/projects/seahorse/common/catalog.vala"
				err = _inner_error_;
#line 192 "/data/projects/seahorse/common/catalog.vala"
				_inner_error_ = NULL;
#line 195 "/data/projects/seahorse/common/catalog.vala"
				_tmp13_ = actions;
#line 195 "/data/projects/seahorse/common/catalog.vala"
				_tmp14_ = gtk_action_group_get_name ((GtkActionGroup*) _tmp13_);
#line 195 "/data/projects/seahorse/common/catalog.vala"
				_tmp15_ = _tmp14_;
#line 195 "/data/projects/seahorse/common/catalog.vala"
				_tmp16_ = definition;
#line 195 "/data/projects/seahorse/common/catalog.vala"
				g_warning ("catalog.vala:195: couldn't add ui defintion for action group: %s: %s", _tmp15_, _tmp16_);
#line 192 "/data/projects/seahorse/common/catalog.vala"
				_g_error_free0 (err);
#line 513 "catalog.c"
			}
			__finally0:
#line 192 "/data/projects/seahorse/common/catalog.vala"
			if (_inner_error_ != NULL) {
#line 192 "/data/projects/seahorse/common/catalog.vala"
				_g_free0 (definition);
#line 192 "/data/projects/seahorse/common/catalog.vala"
				_g_object_unref0 (actions);
#line 192 "/data/projects/seahorse/common/catalog.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/data/projects/seahorse/common/catalog.vala"
				g_clear_error (&_inner_error_);
#line 192 "/data/projects/seahorse/common/catalog.vala"
				return;
#line 528 "catalog.c"
			}
		}
#line 186 "/data/projects/seahorse/common/catalog.vala"
		_g_free0 (definition);
#line 186 "/data/projects/seahorse/common/catalog.vala"
		_g_object_unref0 (actions);
#line 535 "catalog.c"
	}
#line 201 "/data/projects/seahorse/common/catalog.vala"
	_tmp17_ = self->priv->_actions;
#line 201 "/data/projects/seahorse/common/catalog.vala"
	_tmp18_ = group;
#line 201 "/data/projects/seahorse/common/catalog.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 201 "/data/projects/seahorse/common/catalog.vala"
	g_hash_table_add (_tmp17_, _tmp19_);
#line 545 "catalog.c"
}


void seahorse_catalog_show_properties (SeahorseCatalog* self, GObject* obj) {
	GObject* _tmp0_ = NULL;
#line 204 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 204 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (obj != NULL);
#line 205 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = obj;
#line 205 "/data/projects/seahorse/common/catalog.vala"
	seahorse_viewable_view (_tmp0_, (GtkWindow*) self);
#line 559 "catalog.c"
}


void seahorse_catalog_show_context_menu (SeahorseCatalog* self, const gchar* name, guint button, guint time) {
	gchar* path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkWidget* menu = NULL;
	GtkUIManager* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
#line 208 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 208 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (name != NULL);
#line 212 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = name;
#line 212 "/data/projects/seahorse/common/catalog.vala"
	_tmp1_ = g_strdup_printf ("/%s", _tmp0_);
#line 212 "/data/projects/seahorse/common/catalog.vala"
	path = _tmp1_;
#line 213 "/data/projects/seahorse/common/catalog.vala"
	_tmp2_ = self->priv->_ui_manager;
#line 213 "/data/projects/seahorse/common/catalog.vala"
	_tmp3_ = path;
#line 213 "/data/projects/seahorse/common/catalog.vala"
	_tmp4_ = gtk_ui_manager_get_widget (_tmp2_, _tmp3_);
#line 213 "/data/projects/seahorse/common/catalog.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 213 "/data/projects/seahorse/common/catalog.vala"
	menu = _tmp5_;
#line 215 "/data/projects/seahorse/common/catalog.vala"
	_tmp6_ = menu;
#line 215 "/data/projects/seahorse/common/catalog.vala"
	if (_tmp6_ == NULL) {
#line 216 "/data/projects/seahorse/common/catalog.vala"
		_g_object_unref0 (menu);
#line 216 "/data/projects/seahorse/common/catalog.vala"
		_g_free0 (path);
#line 216 "/data/projects/seahorse/common/catalog.vala"
		return;
#line 604 "catalog.c"
	}
#line 217 "/data/projects/seahorse/common/catalog.vala"
	_tmp7_ = menu;
#line 217 "/data/projects/seahorse/common/catalog.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_MENU)) {
#line 610 "catalog.c"
		GtkWidget* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		GtkWidget* _tmp11_ = NULL;
#line 218 "/data/projects/seahorse/common/catalog.vala"
		_tmp8_ = menu;
#line 218 "/data/projects/seahorse/common/catalog.vala"
		_tmp9_ = button;
#line 218 "/data/projects/seahorse/common/catalog.vala"
		_tmp10_ = time;
#line 218 "/data/projects/seahorse/common/catalog.vala"
		gtk_menu_popup (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_MENU, GtkMenu), NULL, NULL, NULL, NULL, _tmp9_, (guint32) _tmp10_);
#line 219 "/data/projects/seahorse/common/catalog.vala"
		_tmp11_ = menu;
#line 219 "/data/projects/seahorse/common/catalog.vala"
		gtk_widget_show (_tmp11_);
#line 627 "catalog.c"
	} else {
		const gchar* _tmp12_ = NULL;
#line 221 "/data/projects/seahorse/common/catalog.vala"
		_tmp12_ = name;
#line 221 "/data/projects/seahorse/common/catalog.vala"
		g_warning ("catalog.vala:221: the object /%s isn't a menu", _tmp12_);
#line 634 "catalog.c"
	}
#line 208 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (menu);
#line 208 "/data/projects/seahorse/common/catalog.vala"
	_g_free0 (path);
#line 640 "catalog.c"
}


static GList* seahorse_catalog_lookup_actions_for_objects (SeahorseCatalog* self, GList* objects) {
	GList* result = NULL;
	GHashTable* table = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp14_ = NULL;
	GList* results = NULL;
	GtkActionGroup* group = NULL;
#line 225 "/data/projects/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 226 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = g_direct_hash;
#line 226 "/data/projects/seahorse/common/catalog.vala"
	_tmp1_ = g_direct_equal;
#line 226 "/data/projects/seahorse/common/catalog.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, NULL);
#line 226 "/data/projects/seahorse/common/catalog.vala"
	table = _tmp2_;
#line 227 "/data/projects/seahorse/common/catalog.vala"
	_tmp3_ = objects;
#line 667 "catalog.c"
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
#line 227 "/data/projects/seahorse/common/catalog.vala"
		object_collection = _tmp3_;
#line 227 "/data/projects/seahorse/common/catalog.vala"
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
#line 675 "catalog.c"
			GObject* _tmp4_ = NULL;
			GObject* object = NULL;
#line 227 "/data/projects/seahorse/common/catalog.vala"
			_tmp4_ = _g_object_ref0 ((GObject*) object_it->data);
#line 227 "/data/projects/seahorse/common/catalog.vala"
			object = _tmp4_;
#line 682 "catalog.c"
			{
				GtkActionGroup* actions = NULL;
				GObject* _tmp5_ = NULL;
				GtkActionGroup* _tmp6_ = NULL;
				GHashTable* _tmp7_ = NULL;
				GtkActionGroup* _tmp8_ = NULL;
				gconstpointer _tmp9_ = NULL;
				GHashTable* _tmp11_ = NULL;
				GtkActionGroup* _tmp12_ = NULL;
				GtkActionGroup* _tmp13_ = NULL;
#line 228 "/data/projects/seahorse/common/catalog.vala"
				actions = NULL;
#line 229 "/data/projects/seahorse/common/catalog.vala"
				_tmp5_ = object;
#line 229 "/data/projects/seahorse/common/catalog.vala"
				g_object_get (_tmp5_, "actions", &actions, NULL, NULL);
#line 230 "/data/projects/seahorse/common/catalog.vala"
				_tmp6_ = actions;
#line 230 "/data/projects/seahorse/common/catalog.vala"
				if (_tmp6_ == NULL) {
#line 231 "/data/projects/seahorse/common/catalog.vala"
					_g_object_unref0 (actions);
#line 231 "/data/projects/seahorse/common/catalog.vala"
					_g_object_unref0 (object);
#line 231 "/data/projects/seahorse/common/catalog.vala"
					continue;
#line 709 "catalog.c"
				}
#line 232 "/data/projects/seahorse/common/catalog.vala"
				_tmp7_ = self->priv->_actions;
#line 232 "/data/projects/seahorse/common/catalog.vala"
				_tmp8_ = actions;
#line 232 "/data/projects/seahorse/common/catalog.vala"
				_tmp9_ = g_hash_table_lookup (_tmp7_, _tmp8_);
#line 232 "/data/projects/seahorse/common/catalog.vala"
				if (((GtkActionGroup*) _tmp9_) == NULL) {
#line 719 "catalog.c"
					GtkActionGroup* _tmp10_ = NULL;
#line 233 "/data/projects/seahorse/common/catalog.vala"
					_tmp10_ = actions;
#line 233 "/data/projects/seahorse/common/catalog.vala"
					seahorse_catalog_include_actions (self, _tmp10_);
#line 725 "catalog.c"
				}
#line 234 "/data/projects/seahorse/common/catalog.vala"
				_tmp11_ = self->priv->_actions;
#line 234 "/data/projects/seahorse/common/catalog.vala"
				_tmp12_ = actions;
#line 234 "/data/projects/seahorse/common/catalog.vala"
				_tmp13_ = _g_object_ref0 (_tmp12_);
#line 234 "/data/projects/seahorse/common/catalog.vala"
				g_hash_table_add (_tmp11_, _tmp13_);
#line 227 "/data/projects/seahorse/common/catalog.vala"
				_g_object_unref0 (actions);
#line 227 "/data/projects/seahorse/common/catalog.vala"
				_g_object_unref0 (object);
#line 739 "catalog.c"
			}
		}
	}
#line 237 "/data/projects/seahorse/common/catalog.vala"
	_tmp14_ = table;
#line 237 "/data/projects/seahorse/common/catalog.vala"
	g_hash_table_iter_init (&iter, _tmp14_);
#line 238 "/data/projects/seahorse/common/catalog.vala"
	results = NULL;
#line 240 "/data/projects/seahorse/common/catalog.vala"
	while (TRUE) {
#line 751 "catalog.c"
		gconstpointer _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		GtkActionGroup* _tmp17_ = NULL;
		GtkActionGroup* _tmp18_ = NULL;
		GtkActionGroup* _tmp19_ = NULL;
#line 240 "/data/projects/seahorse/common/catalog.vala"
		_tmp16_ = g_hash_table_iter_next (&iter, &_tmp15_, NULL);
#line 240 "/data/projects/seahorse/common/catalog.vala"
		_g_object_unref0 (group);
#line 240 "/data/projects/seahorse/common/catalog.vala"
		_tmp17_ = _g_object_ref0 (_tmp15_);
#line 240 "/data/projects/seahorse/common/catalog.vala"
		group = _tmp17_;
#line 240 "/data/projects/seahorse/common/catalog.vala"
		if (!_tmp16_) {
#line 240 "/data/projects/seahorse/common/catalog.vala"
			break;
#line 769 "catalog.c"
		}
#line 241 "/data/projects/seahorse/common/catalog.vala"
		_tmp18_ = group;
#line 241 "/data/projects/seahorse/common/catalog.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 241 "/data/projects/seahorse/common/catalog.vala"
		results = g_list_prepend (results, _tmp19_);
#line 777 "catalog.c"
	}
#line 243 "/data/projects/seahorse/common/catalog.vala"
	result = results;
#line 243 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (group);
#line 243 "/data/projects/seahorse/common/catalog.vala"
	_g_hash_table_unref0 (table);
#line 243 "/data/projects/seahorse/common/catalog.vala"
	return result;
#line 787 "catalog.c"
}


static void seahorse_catalog_on_app_preferences (GtkAction* action, SeahorseCatalog* self) {
#line 247 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 247 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 249 "/data/projects/seahorse/common/catalog.vala"
	seahorse_prefs_show ((GtkWindow*) self, NULL);
#line 798 "catalog.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 279 "/data/projects/seahorse/common/catalog.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 279 "/data/projects/seahorse/common/catalog.vala"
	return _data1_;
#line 807 "catalog.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 279 "/data/projects/seahorse/common/catalog.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 816 "catalog.c"
		SeahorseCatalog * self;
#line 279 "/data/projects/seahorse/common/catalog.vala"
		self = _data1_->self;
#line 279 "/data/projects/seahorse/common/catalog.vala"
		_g_object_unref0 (_data1_->about);
#line 279 "/data/projects/seahorse/common/catalog.vala"
		_g_object_unref0 (self);
#line 279 "/data/projects/seahorse/common/catalog.vala"
		g_slice_free (Block1Data, _data1_);
#line 826 "catalog.c"
	}
}


static void __lambda8_ (Block1Data* _data1_, gint response) {
	SeahorseCatalog * self;
#line 294 "/data/projects/seahorse/common/catalog.vala"
	self = _data1_->self;
#line 295 "/data/projects/seahorse/common/catalog.vala"
	gtk_widget_hide ((GtkWidget*) _data1_->about);
#line 837 "catalog.c"
}


static void ___lambda8__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 294 "/data/projects/seahorse/common/catalog.vala"
	__lambda8_ (self, response_id);
#line 844 "catalog.c"
}


static void seahorse_catalog_on_app_about (GtkAction* action, SeahorseCatalog* self) {
	Block1Data* _data1_;
	GtkAboutDialog* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 279 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 279 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 279 "/data/projects/seahorse/common/catalog.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 279 "/data/projects/seahorse/common/catalog.vala"
	_data1_->_ref_count_ = 1;
#line 279 "/data/projects/seahorse/common/catalog.vala"
	_data1_->self = g_object_ref (self);
#line 282 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
#line 282 "/data/projects/seahorse/common/catalog.vala"
	g_object_ref_sink (_tmp0_);
#line 282 "/data/projects/seahorse/common/catalog.vala"
	_data1_->about = _tmp0_;
#line 283 "/data/projects/seahorse/common/catalog.vala"
	gtk_about_dialog_set_artists (_data1_->about, SEAHORSE_CATALOG_ARTISTS);
#line 284 "/data/projects/seahorse/common/catalog.vala"
	gtk_about_dialog_set_authors (_data1_->about, SEAHORSE_CATALOG_AUTHORS);
#line 285 "/data/projects/seahorse/common/catalog.vala"
	gtk_about_dialog_set_documenters (_data1_->about, SEAHORSE_CATALOG_DOCUMENTERS);
#line 286 "/data/projects/seahorse/common/catalog.vala"
	gtk_about_dialog_set_version (_data1_->about, VERSION);
#line 287 "/data/projects/seahorse/common/catalog.vala"
	_tmp1_ = _ ("Passwords and Keys");
#line 287 "/data/projects/seahorse/common/catalog.vala"
	gtk_about_dialog_set_comments (_data1_->about, _tmp1_);
#line 288 "/data/projects/seahorse/common/catalog.vala"
	gtk_about_dialog_set_copyright (_data1_->about, "Copyright \xc2\xa9 2002 - 2010 Seahorse Project");
#line 289 "/data/projects/seahorse/common/catalog.vala"
	_tmp2_ = _ ("translator-credits");
#line 289 "/data/projects/seahorse/common/catalog.vala"
	gtk_about_dialog_set_translator_credits (_data1_->about, _tmp2_);
#line 290 "/data/projects/seahorse/common/catalog.vala"
	gtk_about_dialog_set_logo_icon_name (_data1_->about, "seahorse");
#line 291 "/data/projects/seahorse/common/catalog.vala"
	gtk_about_dialog_set_website (_data1_->about, "http://www.gnome.org/projects/seahorse");
#line 292 "/data/projects/seahorse/common/catalog.vala"
	_tmp3_ = _ ("Seahorse Project Homepage");
#line 292 "/data/projects/seahorse/common/catalog.vala"
	gtk_about_dialog_set_website_label (_data1_->about, _tmp3_);
#line 294 "/data/projects/seahorse/common/catalog.vala"
	g_signal_connect_data ((GtkDialog*) _data1_->about, "response", (GCallback) ___lambda8__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 298 "/data/projects/seahorse/common/catalog.vala"
	gtk_window_set_transient_for ((GtkWindow*) _data1_->about, (GtkWindow*) self);
#line 299 "/data/projects/seahorse/common/catalog.vala"
	gtk_dialog_run ((GtkDialog*) _data1_->about);
#line 300 "/data/projects/seahorse/common/catalog.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->about);
#line 279 "/data/projects/seahorse/common/catalog.vala"
	block1_data_unref (_data1_);
#line 279 "/data/projects/seahorse/common/catalog.vala"
	_data1_ = NULL;
#line 908 "catalog.c"
}


static void seahorse_catalog_on_object_delete (GtkAction* action, SeahorseCatalog* self) {
	GError * _inner_error_ = NULL;
#line 304 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 304 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 918 "catalog.c"
	{
		GList* objects = NULL;
		GList* _tmp0_ = NULL;
#line 307 "/data/projects/seahorse/common/catalog.vala"
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
#line 307 "/data/projects/seahorse/common/catalog.vala"
		objects = _tmp0_;
#line 308 "/data/projects/seahorse/common/catalog.vala"
		seahorse_deletable_delete_with_prompt_wait (objects, (GtkWindow*) self, &_inner_error_);
#line 308 "/data/projects/seahorse/common/catalog.vala"
		if (_inner_error_ != NULL) {
#line 308 "/data/projects/seahorse/common/catalog.vala"
			_g_list_free0 (objects);
#line 932 "catalog.c"
			goto __catch1_g_error;
		}
#line 306 "/data/projects/seahorse/common/catalog.vala"
		_g_list_free0 (objects);
#line 937 "catalog.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GtkWindow* _tmp1_ = NULL;
		GtkWindow* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 306 "/data/projects/seahorse/common/catalog.vala"
		err = _inner_error_;
#line 306 "/data/projects/seahorse/common/catalog.vala"
		_inner_error_ = NULL;
#line 310 "/data/projects/seahorse/common/catalog.vala"
		_tmp1_ = seahorse_catalog_get_window (self);
#line 310 "/data/projects/seahorse/common/catalog.vala"
		_tmp2_ = _tmp1_;
#line 310 "/data/projects/seahorse/common/catalog.vala"
		_tmp3_ = _ ("Cannot delete");
#line 310 "/data/projects/seahorse/common/catalog.vala"
		_tmp4_ = err;
#line 310 "/data/projects/seahorse/common/catalog.vala"
		_tmp5_ = _tmp4_->message;
#line 310 "/data/projects/seahorse/common/catalog.vala"
		seahorse_util_show_error ((GtkWidget*) _tmp2_, _tmp3_, _tmp5_);
#line 306 "/data/projects/seahorse/common/catalog.vala"
		_g_error_free0 (err);
#line 966 "catalog.c"
	}
	__finally1:
#line 306 "/data/projects/seahorse/common/catalog.vala"
	if (_inner_error_ != NULL) {
#line 306 "/data/projects/seahorse/common/catalog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 306 "/data/projects/seahorse/common/catalog.vala"
		g_clear_error (&_inner_error_);
#line 306 "/data/projects/seahorse/common/catalog.vala"
		return;
#line 977 "catalog.c"
	}
}


static void seahorse_catalog_on_properties_object (GtkAction* action, SeahorseCatalog* self) {
	GList* objects = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 315 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 315 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 316 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = seahorse_catalog_get_selected_objects (self);
#line 316 "/data/projects/seahorse/common/catalog.vala"
	objects = _tmp0_;
#line 317 "/data/projects/seahorse/common/catalog.vala"
	_tmp1_ = objects;
#line 317 "/data/projects/seahorse/common/catalog.vala"
	_tmp2_ = g_list_length (_tmp1_);
#line 317 "/data/projects/seahorse/common/catalog.vala"
	if (_tmp2_ > ((guint) 0)) {
#line 1001 "catalog.c"
		GList* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
#line 318 "/data/projects/seahorse/common/catalog.vala"
		_tmp3_ = objects;
#line 318 "/data/projects/seahorse/common/catalog.vala"
		_tmp4_ = _tmp3_->data;
#line 318 "/data/projects/seahorse/common/catalog.vala"
		seahorse_catalog_show_properties (self, (GObject*) _tmp4_);
#line 1010 "catalog.c"
	}
#line 315 "/data/projects/seahorse/common/catalog.vala"
	_g_list_free0 (objects);
#line 1014 "catalog.c"
}


static void seahorse_catalog_on_properties_place (GtkAction* action, SeahorseCatalog* self) {
	SeahorsePlace* place = NULL;
	SeahorsePlace* _tmp0_ = NULL;
	SeahorsePlace* _tmp1_ = NULL;
#line 322 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 322 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 323 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = seahorse_catalog_get_focused_place (self);
#line 323 "/data/projects/seahorse/common/catalog.vala"
	place = _tmp0_;
#line 324 "/data/projects/seahorse/common/catalog.vala"
	_tmp1_ = place;
#line 324 "/data/projects/seahorse/common/catalog.vala"
	if (_tmp1_ != NULL) {
#line 1034 "catalog.c"
		SeahorsePlace* _tmp2_ = NULL;
#line 325 "/data/projects/seahorse/common/catalog.vala"
		_tmp2_ = place;
#line 325 "/data/projects/seahorse/common/catalog.vala"
		seahorse_catalog_show_properties (self, (GObject*) _tmp2_);
#line 1040 "catalog.c"
	}
#line 322 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (place);
#line 1044 "catalog.c"
}


static void seahorse_catalog_on_key_export_file (GtkAction* action, SeahorseCatalog* self) {
	GError * _inner_error_ = NULL;
#line 329 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 329 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 1054 "catalog.c"
	{
		GList* _tmp0_ = NULL;
		GList* _tmp1_ = NULL;
#line 331 "/data/projects/seahorse/common/catalog.vala"
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
#line 331 "/data/projects/seahorse/common/catalog.vala"
		_tmp1_ = _tmp0_;
#line 331 "/data/projects/seahorse/common/catalog.vala"
		seahorse_exportable_export_to_prompt_wait (_tmp1_, (GtkWindow*) self, &_inner_error_);
#line 331 "/data/projects/seahorse/common/catalog.vala"
		_g_list_free0 (_tmp1_);
#line 331 "/data/projects/seahorse/common/catalog.vala"
		if (_inner_error_ != NULL) {
#line 1068 "catalog.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GtkWindow* _tmp2_ = NULL;
		GtkWindow* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 330 "/data/projects/seahorse/common/catalog.vala"
		err = _inner_error_;
#line 330 "/data/projects/seahorse/common/catalog.vala"
		_inner_error_ = NULL;
#line 333 "/data/projects/seahorse/common/catalog.vala"
		_tmp2_ = seahorse_catalog_get_window (self);
#line 333 "/data/projects/seahorse/common/catalog.vala"
		_tmp3_ = _tmp2_;
#line 333 "/data/projects/seahorse/common/catalog.vala"
		_tmp4_ = _ ("Couldn't export keys");
#line 333 "/data/projects/seahorse/common/catalog.vala"
		_tmp5_ = err;
#line 333 "/data/projects/seahorse/common/catalog.vala"
		_tmp6_ = _tmp5_->message;
#line 333 "/data/projects/seahorse/common/catalog.vala"
		seahorse_util_show_error ((GtkWidget*) _tmp3_, _tmp4_, _tmp6_);
#line 330 "/data/projects/seahorse/common/catalog.vala"
		_g_error_free0 (err);
#line 1099 "catalog.c"
	}
	__finally2:
#line 330 "/data/projects/seahorse/common/catalog.vala"
	if (_inner_error_ != NULL) {
#line 330 "/data/projects/seahorse/common/catalog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 330 "/data/projects/seahorse/common/catalog.vala"
		g_clear_error (&_inner_error_);
#line 330 "/data/projects/seahorse/common/catalog.vala"
		return;
#line 1110 "catalog.c"
	}
}


static void seahorse_catalog_on_key_export_clipboard (GtkAction* action, SeahorseCatalog* self) {
	guint8* output = NULL;
	gint output_length1 = 0;
	gint _output_size_ = 0;
	GtkClipboard* board = NULL;
	GtkClipboard* _tmp7_ = NULL;
	GtkClipboard* _tmp8_ = NULL;
	GtkClipboard* _tmp9_ = NULL;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	guint8* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GError * _inner_error_ = NULL;
#line 338 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 338 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 1132 "catalog.c"
	{
		GList* objects = NULL;
		GList* _tmp0_ = NULL;
		GList* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		size_t _tmp3_;
#line 341 "/data/projects/seahorse/common/catalog.vala"
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
#line 341 "/data/projects/seahorse/common/catalog.vala"
		objects = _tmp0_;
#line 342 "/data/projects/seahorse/common/catalog.vala"
		_tmp1_ = objects;
#line 342 "/data/projects/seahorse/common/catalog.vala"
		seahorse_exportable_export_to_text_wait (_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
#line 342 "/data/projects/seahorse/common/catalog.vala"
		output = (g_free (output), NULL);
#line 342 "/data/projects/seahorse/common/catalog.vala"
		output = _tmp2_;
#line 342 "/data/projects/seahorse/common/catalog.vala"
		output_length1 = _tmp3_;
#line 342 "/data/projects/seahorse/common/catalog.vala"
		_output_size_ = output_length1;
#line 342 "/data/projects/seahorse/common/catalog.vala"
		if (_inner_error_ != NULL) {
#line 342 "/data/projects/seahorse/common/catalog.vala"
			_g_list_free0 (objects);
#line 1159 "catalog.c"
			goto __catch3_g_error;
		}
#line 340 "/data/projects/seahorse/common/catalog.vala"
		_g_list_free0 (objects);
#line 1164 "catalog.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 340 "/data/projects/seahorse/common/catalog.vala"
		err = _inner_error_;
#line 340 "/data/projects/seahorse/common/catalog.vala"
		_inner_error_ = NULL;
#line 344 "/data/projects/seahorse/common/catalog.vala"
		_tmp4_ = _ ("Couldn't export data");
#line 344 "/data/projects/seahorse/common/catalog.vala"
		_tmp5_ = err;
#line 344 "/data/projects/seahorse/common/catalog.vala"
		_tmp6_ = _tmp5_->message;
#line 344 "/data/projects/seahorse/common/catalog.vala"
		seahorse_util_show_error ((GtkWidget*) self, _tmp4_, _tmp6_);
#line 345 "/data/projects/seahorse/common/catalog.vala"
		_g_error_free0 (err);
#line 345 "/data/projects/seahorse/common/catalog.vala"
		output = (g_free (output), NULL);
#line 345 "/data/projects/seahorse/common/catalog.vala"
		return;
#line 1191 "catalog.c"
	}
	__finally3:
#line 340 "/data/projects/seahorse/common/catalog.vala"
	if (_inner_error_ != NULL) {
#line 340 "/data/projects/seahorse/common/catalog.vala"
		output = (g_free (output), NULL);
#line 340 "/data/projects/seahorse/common/catalog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 340 "/data/projects/seahorse/common/catalog.vala"
		g_clear_error (&_inner_error_);
#line 340 "/data/projects/seahorse/common/catalog.vala"
		return;
#line 1204 "catalog.c"
	}
#line 350 "/data/projects/seahorse/common/catalog.vala"
	_tmp7_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
#line 350 "/data/projects/seahorse/common/catalog.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 350 "/data/projects/seahorse/common/catalog.vala"
	board = _tmp8_;
#line 351 "/data/projects/seahorse/common/catalog.vala"
	_tmp9_ = board;
#line 351 "/data/projects/seahorse/common/catalog.vala"
	_tmp10_ = output;
#line 351 "/data/projects/seahorse/common/catalog.vala"
	_tmp10__length1 = output_length1;
#line 351 "/data/projects/seahorse/common/catalog.vala"
	_tmp11_ = output;
#line 351 "/data/projects/seahorse/common/catalog.vala"
	_tmp11__length1 = output_length1;
#line 351 "/data/projects/seahorse/common/catalog.vala"
	gtk_clipboard_set_text (_tmp9_, (const gchar*) _tmp10_, _tmp11__length1);
#line 338 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (board);
#line 338 "/data/projects/seahorse/common/catalog.vala"
	output = (g_free (output), NULL);
#line 1228 "catalog.c"
}


static void seahorse_catalog_on_help_show (GtkAction* action, SeahorseCatalog* self) {
	GError * _inner_error_ = NULL;
#line 355 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 355 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 1238 "catalog.c"
	{
		gchar* document = NULL;
		gchar* _tmp0_ = NULL;
#line 357 "/data/projects/seahorse/common/catalog.vala"
		_tmp0_ = g_strdup_printf ("help:%s/introduction", PACKAGE);
#line 357 "/data/projects/seahorse/common/catalog.vala"
		document = _tmp0_;
#line 358 "/data/projects/seahorse/common/catalog.vala"
		g_app_info_launch_default_for_uri (document, NULL, &_inner_error_);
#line 358 "/data/projects/seahorse/common/catalog.vala"
		if (_inner_error_ != NULL) {
#line 358 "/data/projects/seahorse/common/catalog.vala"
			_g_free0 (document);
#line 1252 "catalog.c"
			goto __catch4_g_error;
		}
#line 356 "/data/projects/seahorse/common/catalog.vala"
		_g_free0 (document);
#line 1257 "catalog.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 356 "/data/projects/seahorse/common/catalog.vala"
		err = _inner_error_;
#line 356 "/data/projects/seahorse/common/catalog.vala"
		_inner_error_ = NULL;
#line 360 "/data/projects/seahorse/common/catalog.vala"
		_tmp1_ = _ ("Could not display help: %s");
#line 360 "/data/projects/seahorse/common/catalog.vala"
		_tmp2_ = err;
#line 360 "/data/projects/seahorse/common/catalog.vala"
		_tmp3_ = _tmp2_->message;
#line 360 "/data/projects/seahorse/common/catalog.vala"
		seahorse_util_show_error ((GtkWidget*) self, _tmp1_, _tmp3_);
#line 356 "/data/projects/seahorse/common/catalog.vala"
		_g_error_free0 (err);
#line 1280 "catalog.c"
	}
	__finally4:
#line 356 "/data/projects/seahorse/common/catalog.vala"
	if (_inner_error_ != NULL) {
#line 356 "/data/projects/seahorse/common/catalog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 356 "/data/projects/seahorse/common/catalog.vala"
		g_clear_error (&_inner_error_);
#line 356 "/data/projects/seahorse/common/catalog.vala"
		return;
#line 1291 "catalog.c"
	}
}


SeahorseCatalog* seahorse_catalog_construct (GType object_type) {
	SeahorseCatalog * self = NULL;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	self = (SeahorseCatalog*) g_object_new (object_type, NULL);
#line 25 "/data/projects/seahorse/common/catalog.vala"
	return self;
#line 1302 "catalog.c"
}


GtkWindow* seahorse_catalog_get_window (SeahorseCatalog* self) {
	GtkWindow* result;
#line 30 "/data/projects/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "/data/projects/seahorse/common/catalog.vala"
	result = (GtkWindow*) self;
#line 30 "/data/projects/seahorse/common/catalog.vala"
	return result;
#line 1314 "catalog.c"
}


const gchar* seahorse_catalog_get_ui_name (SeahorseCatalog* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 34 "/data/projects/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_ui_name;
#line 34 "/data/projects/seahorse/common/catalog.vala"
	result = _tmp0_;
#line 34 "/data/projects/seahorse/common/catalog.vala"
	return result;
#line 1329 "catalog.c"
}


static void seahorse_catalog_set_ui_name (SeahorseCatalog* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 34 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 34 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = value;
#line 34 "/data/projects/seahorse/common/catalog.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 34 "/data/projects/seahorse/common/catalog.vala"
	_g_free0 (self->priv->_ui_name);
#line 34 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_ui_name = _tmp1_;
#line 34 "/data/projects/seahorse/common/catalog.vala"
	g_object_notify ((GObject *) self, "ui-name");
#line 1348 "catalog.c"
}


static void seahorse_catalog_real_selection_changed (SeahorseCatalog* self) {
	gboolean can_properties = FALSE;
	gboolean can_delete = FALSE;
	gboolean can_export = FALSE;
	GList* objects = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GtkAction* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GtkAction* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GtkAction* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GtkAction* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GList* _tmp23_ = NULL;
	GList* _tmp26_ = NULL;
	GList* _tmp27_ = NULL;
	GList* _tmp28_ = NULL;
#line 143 "/data/projects/seahorse/common/catalog.vala"
	can_properties = FALSE;
#line 144 "/data/projects/seahorse/common/catalog.vala"
	can_delete = FALSE;
#line 145 "/data/projects/seahorse/common/catalog.vala"
	can_export = FALSE;
#line 147 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = seahorse_catalog_get_selected_objects (self);
#line 147 "/data/projects/seahorse/common/catalog.vala"
	objects = _tmp0_;
#line 148 "/data/projects/seahorse/common/catalog.vala"
	_tmp1_ = objects;
#line 1383 "catalog.c"
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
#line 148 "/data/projects/seahorse/common/catalog.vala"
		object_collection = _tmp1_;
#line 148 "/data/projects/seahorse/common/catalog.vala"
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
#line 1391 "catalog.c"
			GObject* object = NULL;
#line 148 "/data/projects/seahorse/common/catalog.vala"
			object = (GObject*) object_it->data;
#line 1395 "catalog.c"
			{
				GObject* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				GObject* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				GObject* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp14_ = FALSE;
#line 149 "/data/projects/seahorse/common/catalog.vala"
				_tmp2_ = object;
#line 149 "/data/projects/seahorse/common/catalog.vala"
				_tmp3_ = seahorse_exportable_can_export (_tmp2_);
#line 149 "/data/projects/seahorse/common/catalog.vala"
				if (_tmp3_) {
#line 150 "/data/projects/seahorse/common/catalog.vala"
					can_export = TRUE;
#line 1416 "catalog.c"
				}
#line 151 "/data/projects/seahorse/common/catalog.vala"
				_tmp4_ = object;
#line 151 "/data/projects/seahorse/common/catalog.vala"
				_tmp5_ = seahorse_deletable_can_delete (_tmp4_);
#line 151 "/data/projects/seahorse/common/catalog.vala"
				if (_tmp5_) {
#line 152 "/data/projects/seahorse/common/catalog.vala"
					can_delete = TRUE;
#line 1426 "catalog.c"
				}
#line 153 "/data/projects/seahorse/common/catalog.vala"
				_tmp6_ = object;
#line 153 "/data/projects/seahorse/common/catalog.vala"
				_tmp7_ = seahorse_viewable_can_view (_tmp6_);
#line 153 "/data/projects/seahorse/common/catalog.vala"
				if (_tmp7_) {
#line 154 "/data/projects/seahorse/common/catalog.vala"
					can_properties = TRUE;
#line 1436 "catalog.c"
				}
#line 155 "/data/projects/seahorse/common/catalog.vala"
				_tmp10_ = can_export;
#line 155 "/data/projects/seahorse/common/catalog.vala"
				if (_tmp10_) {
#line 1442 "catalog.c"
					gboolean _tmp11_ = FALSE;
#line 155 "/data/projects/seahorse/common/catalog.vala"
					_tmp11_ = can_delete;
#line 155 "/data/projects/seahorse/common/catalog.vala"
					_tmp9_ = _tmp11_;
#line 1448 "catalog.c"
				} else {
#line 155 "/data/projects/seahorse/common/catalog.vala"
					_tmp9_ = FALSE;
#line 1452 "catalog.c"
				}
#line 155 "/data/projects/seahorse/common/catalog.vala"
				_tmp12_ = _tmp9_;
#line 155 "/data/projects/seahorse/common/catalog.vala"
				if (_tmp12_) {
#line 1458 "catalog.c"
					gboolean _tmp13_ = FALSE;
#line 155 "/data/projects/seahorse/common/catalog.vala"
					_tmp13_ = can_properties;
#line 155 "/data/projects/seahorse/common/catalog.vala"
					_tmp8_ = _tmp13_;
#line 1464 "catalog.c"
				} else {
#line 155 "/data/projects/seahorse/common/catalog.vala"
					_tmp8_ = FALSE;
#line 1468 "catalog.c"
				}
#line 155 "/data/projects/seahorse/common/catalog.vala"
				_tmp14_ = _tmp8_;
#line 155 "/data/projects/seahorse/common/catalog.vala"
				if (_tmp14_) {
#line 156 "/data/projects/seahorse/common/catalog.vala"
					break;
#line 1476 "catalog.c"
				}
			}
		}
	}
#line 159 "/data/projects/seahorse/common/catalog.vala"
	_tmp15_ = self->priv->_properties_object;
#line 159 "/data/projects/seahorse/common/catalog.vala"
	_tmp16_ = can_properties;
#line 159 "/data/projects/seahorse/common/catalog.vala"
	gtk_action_set_sensitive (_tmp15_, _tmp16_);
#line 160 "/data/projects/seahorse/common/catalog.vala"
	_tmp17_ = self->priv->_edit_delete;
#line 160 "/data/projects/seahorse/common/catalog.vala"
	_tmp18_ = can_delete;
#line 160 "/data/projects/seahorse/common/catalog.vala"
	gtk_action_set_sensitive (_tmp17_, _tmp18_);
#line 161 "/data/projects/seahorse/common/catalog.vala"
	_tmp19_ = self->priv->_edit_copy;
#line 161 "/data/projects/seahorse/common/catalog.vala"
	_tmp20_ = can_export;
#line 161 "/data/projects/seahorse/common/catalog.vala"
	gtk_action_set_sensitive (_tmp19_, _tmp20_);
#line 162 "/data/projects/seahorse/common/catalog.vala"
	_tmp21_ = self->priv->_file_export;
#line 162 "/data/projects/seahorse/common/catalog.vala"
	_tmp22_ = can_export;
#line 162 "/data/projects/seahorse/common/catalog.vala"
	gtk_action_set_sensitive (_tmp21_, _tmp22_);
#line 164 "/data/projects/seahorse/common/catalog.vala"
	_tmp23_ = self->priv->_selection_actions;
#line 1507 "catalog.c"
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
#line 164 "/data/projects/seahorse/common/catalog.vala"
		group_collection = _tmp23_;
#line 164 "/data/projects/seahorse/common/catalog.vala"
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
#line 1515 "catalog.c"
			GtkActionGroup* _tmp24_ = NULL;
			GtkActionGroup* group = NULL;
#line 164 "/data/projects/seahorse/common/catalog.vala"
			_tmp24_ = _g_object_ref0 ((GtkActionGroup*) group_it->data);
#line 164 "/data/projects/seahorse/common/catalog.vala"
			group = _tmp24_;
#line 1522 "catalog.c"
			{
				GtkActionGroup* _tmp25_ = NULL;
#line 165 "/data/projects/seahorse/common/catalog.vala"
				_tmp25_ = group;
#line 165 "/data/projects/seahorse/common/catalog.vala"
				gtk_action_group_set_visible (_tmp25_, FALSE);
#line 164 "/data/projects/seahorse/common/catalog.vala"
				_g_object_unref0 (group);
#line 1531 "catalog.c"
			}
		}
	}
#line 166 "/data/projects/seahorse/common/catalog.vala"
	_tmp26_ = objects;
#line 166 "/data/projects/seahorse/common/catalog.vala"
	_tmp27_ = seahorse_catalog_lookup_actions_for_objects (self, _tmp26_);
#line 166 "/data/projects/seahorse/common/catalog.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_selection_actions);
#line 166 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_selection_actions = _tmp27_;
#line 167 "/data/projects/seahorse/common/catalog.vala"
	_tmp28_ = self->priv->_selection_actions;
#line 1545 "catalog.c"
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
#line 167 "/data/projects/seahorse/common/catalog.vala"
		group_collection = _tmp28_;
#line 167 "/data/projects/seahorse/common/catalog.vala"
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
#line 1553 "catalog.c"
			GtkActionGroup* _tmp29_ = NULL;
			GtkActionGroup* group = NULL;
#line 167 "/data/projects/seahorse/common/catalog.vala"
			_tmp29_ = _g_object_ref0 ((GtkActionGroup*) group_it->data);
#line 167 "/data/projects/seahorse/common/catalog.vala"
			group = _tmp29_;
#line 1560 "catalog.c"
			{
				GtkActionGroup* _tmp30_ = NULL;
#line 168 "/data/projects/seahorse/common/catalog.vala"
				_tmp30_ = group;
#line 168 "/data/projects/seahorse/common/catalog.vala"
				gtk_action_group_set_visible (_tmp30_, TRUE);
#line 167 "/data/projects/seahorse/common/catalog.vala"
				_g_object_unref0 (group);
#line 1569 "catalog.c"
			}
		}
	}
#line 142 "/data/projects/seahorse/common/catalog.vala"
	_g_list_free0 (objects);
#line 1575 "catalog.c"
}


static void _seahorse_catalog___lambda9_ (SeahorseCatalog* self, GtkWidget* widget) {
	const gchar* name = NULL;
	GtkWidget* _tmp0_ = NULL;
	GObject* holder = NULL;
	GtkBuilder* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_ = NULL;
#line 57 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (widget != NULL);
#line 59 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = widget;
#line 59 "/data/projects/seahorse/common/catalog.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_MENU_BAR)) {
#line 60 "/data/projects/seahorse/common/catalog.vala"
		name = "menu-placeholder";
#line 1596 "catalog.c"
	} else {
		GtkWidget* _tmp1_ = NULL;
#line 61 "/data/projects/seahorse/common/catalog.vala"
		_tmp1_ = widget;
#line 61 "/data/projects/seahorse/common/catalog.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GTK_TYPE_TOOLBAR)) {
#line 62 "/data/projects/seahorse/common/catalog.vala"
			name = "toolbar-placeholder";
#line 1605 "catalog.c"
		} else {
#line 64 "/data/projects/seahorse/common/catalog.vala"
			name = NULL;
#line 1609 "catalog.c"
		}
	}
#line 65 "/data/projects/seahorse/common/catalog.vala"
	_tmp2_ = self->priv->_builder;
#line 65 "/data/projects/seahorse/common/catalog.vala"
	_tmp3_ = name;
#line 65 "/data/projects/seahorse/common/catalog.vala"
	_tmp4_ = gtk_builder_get_object (_tmp2_, _tmp3_);
#line 65 "/data/projects/seahorse/common/catalog.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 65 "/data/projects/seahorse/common/catalog.vala"
	holder = _tmp5_;
#line 66 "/data/projects/seahorse/common/catalog.vala"
	_tmp6_ = holder;
#line 66 "/data/projects/seahorse/common/catalog.vala"
	if (_tmp6_ != NULL) {
#line 1626 "catalog.c"
		GObject* _tmp7_ = NULL;
		GtkWidget* _tmp8_ = NULL;
		GtkWidget* _tmp9_ = NULL;
#line 67 "/data/projects/seahorse/common/catalog.vala"
		_tmp7_ = holder;
#line 67 "/data/projects/seahorse/common/catalog.vala"
		_tmp8_ = widget;
#line 67 "/data/projects/seahorse/common/catalog.vala"
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_CONTAINER, GtkContainer), _tmp8_);
#line 68 "/data/projects/seahorse/common/catalog.vala"
		_tmp9_ = widget;
#line 68 "/data/projects/seahorse/common/catalog.vala"
		gtk_widget_show (_tmp9_);
#line 1640 "catalog.c"
	} else {
		const gchar* _tmp10_ = NULL;
#line 70 "/data/projects/seahorse/common/catalog.vala"
		_tmp10_ = name;
#line 70 "/data/projects/seahorse/common/catalog.vala"
		g_warning ("catalog.vala:70: no place holder found for: %s", _tmp10_);
#line 1647 "catalog.c"
	}
#line 57 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (holder);
#line 1651 "catalog.c"
}


static void __seahorse_catalog___lambda9__gtk_ui_manager_add_widget (GtkUIManager* _sender, GtkWidget* widget, gpointer self) {
#line 57 "/data/projects/seahorse/common/catalog.vala"
	_seahorse_catalog___lambda9_ (self, widget);
#line 1658 "catalog.c"
}


static void _seahorse_catalog___lambda10_ (SeahorseCatalog* self, GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
#line 74 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 75 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = action;
#line 75 "/data/projects/seahorse/common/catalog.vala"
	seahorse_action_pre_activate (_tmp0_, self, (GtkWindow*) self);
#line 1670 "catalog.c"
}


static void __seahorse_catalog___lambda10__gtk_ui_manager_pre_activate (GtkUIManager* _sender, GtkAction* action, gpointer self) {
#line 74 "/data/projects/seahorse/common/catalog.vala"
	_seahorse_catalog___lambda10_ (self, action);
#line 1677 "catalog.c"
}


static void _seahorse_catalog___lambda11_ (SeahorseCatalog* self, GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
#line 78 "/data/projects/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 79 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = action;
#line 79 "/data/projects/seahorse/common/catalog.vala"
	seahorse_action_post_activate (_tmp0_);
#line 1689 "catalog.c"
}


static void __seahorse_catalog___lambda11__gtk_ui_manager_post_activate (GtkUIManager* _sender, GtkAction* action, gpointer self) {
#line 78 "/data/projects/seahorse/common/catalog.vala"
	_seahorse_catalog___lambda11_ (self, action);
#line 1696 "catalog.c"
}


static GObject * seahorse_catalog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseCatalog * self;
	const gchar* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GtkUIManager* _tmp5_ = NULL;
	GtkUIManager* _tmp6_ = NULL;
	GtkUIManager* _tmp7_ = NULL;
	GtkUIManager* _tmp8_ = NULL;
	gchar* key = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GSettings* _tmp12_ = NULL;
	gint width = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint height = 0;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_ = 0;
	gboolean _tmp20_ = FALSE;
	GtkUIManager* _tmp33_ = NULL;
	GtkAccelGroup* _tmp34_ = NULL;
	GtkActionGroup* actions = NULL;
	GtkActionGroup* _tmp35_ = NULL;
	GtkActionGroup* _tmp36_ = NULL;
	GtkActionGroup* _tmp37_ = NULL;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp38_ = NULL;
	GtkAction* _tmp39_ = NULL;
	GtkAction* _tmp40_ = NULL;
	GtkAction* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	GtkActionGroup* _tmp43_ = NULL;
	GtkAction* _tmp44_ = NULL;
	GtkAction* _tmp45_ = NULL;
	GtkActionGroup* _tmp46_ = NULL;
	GtkAction* _tmp47_ = NULL;
	GtkAction* _tmp48_ = NULL;
	GtkActionGroup* _tmp49_ = NULL;
	GtkAction* _tmp50_ = NULL;
	GtkAction* _tmp51_ = NULL;
	GtkActionGroup* _tmp52_ = NULL;
	GtkAction* _tmp53_ = NULL;
	GtkAction* _tmp54_ = NULL;
	GtkUIManager* _tmp55_ = NULL;
	GtkActionGroup* _tmp56_ = NULL;
	GtkApplication* _tmp57_ = NULL;
	GError * _inner_error_ = NULL;
#line 51 "/data/projects/seahorse/common/catalog.vala"
	parent_class = G_OBJECT_CLASS (seahorse_catalog_parent_class);
#line 51 "/data/projects/seahorse/common/catalog.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 51 "/data/projects/seahorse/common/catalog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
#line 52 "/data/projects/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_ui_name;
#line 52 "/data/projects/seahorse/common/catalog.vala"
	_tmp1_ = seahorse_util_load_built_contents ((GtkContainer*) self, _tmp0_);
#line 52 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_builder);
#line 52 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_builder = _tmp1_;
#line 54 "/data/projects/seahorse/common/catalog.vala"
	_tmp2_ = g_direct_hash;
#line 54 "/data/projects/seahorse/common/catalog.vala"
	_tmp3_ = g_direct_equal;
#line 54 "/data/projects/seahorse/common/catalog.vala"
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_object_unref0_, NULL);
#line 54 "/data/projects/seahorse/common/catalog.vala"
	_g_hash_table_unref0 (self->priv->_actions);
#line 54 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_actions = _tmp4_;
#line 55 "/data/projects/seahorse/common/catalog.vala"
	_tmp5_ = gtk_ui_manager_new ();
#line 55 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 55 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_ui_manager = _tmp5_;
#line 57 "/data/projects/seahorse/common/catalog.vala"
	_tmp6_ = self->priv->_ui_manager;
#line 57 "/data/projects/seahorse/common/catalog.vala"
	g_signal_connect_object (_tmp6_, "add-widget", (GCallback) __seahorse_catalog___lambda9__gtk_ui_manager_add_widget, self, 0);
#line 74 "/data/projects/seahorse/common/catalog.vala"
	_tmp7_ = self->priv->_ui_manager;
#line 74 "/data/projects/seahorse/common/catalog.vala"
	g_signal_connect_object (_tmp7_, "pre-activate", (GCallback) __seahorse_catalog___lambda10__gtk_ui_manager_pre_activate, self, 0);
#line 78 "/data/projects/seahorse/common/catalog.vala"
	_tmp8_ = self->priv->_ui_manager;
#line 78 "/data/projects/seahorse/common/catalog.vala"
	g_signal_connect_object (_tmp8_, "post-activate", (GCallback) __seahorse_catalog___lambda11__gtk_ui_manager_post_activate, self, 0);
#line 83 "/data/projects/seahorse/common/catalog.vala"
	_tmp9_ = self->priv->_ui_name;
#line 83 "/data/projects/seahorse/common/catalog.vala"
	_tmp10_ = g_strdup_printf ("/apps/seahorse/windows/%s/", _tmp9_);
#line 83 "/data/projects/seahorse/common/catalog.vala"
	key = _tmp10_;
#line 84 "/data/projects/seahorse/common/catalog.vala"
	_tmp11_ = key;
#line 84 "/data/projects/seahorse/common/catalog.vala"
	_tmp12_ = g_settings_new_with_path ("org.gnome.seahorse.window", _tmp11_);
#line 84 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_settings);
#line 84 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_settings = _tmp12_;
#line 85 "/data/projects/seahorse/common/catalog.vala"
	_tmp13_ = self->priv->_settings;
#line 85 "/data/projects/seahorse/common/catalog.vala"
	_tmp14_ = g_settings_get_int (_tmp13_, "width");
#line 85 "/data/projects/seahorse/common/catalog.vala"
	width = _tmp14_;
#line 86 "/data/projects/seahorse/common/catalog.vala"
	_tmp15_ = self->priv->_settings;
#line 86 "/data/projects/seahorse/common/catalog.vala"
	_tmp16_ = g_settings_get_int (_tmp15_, "height");
#line 86 "/data/projects/seahorse/common/catalog.vala"
	height = _tmp16_;
#line 87 "/data/projects/seahorse/common/catalog.vala"
	_tmp18_ = width;
#line 87 "/data/projects/seahorse/common/catalog.vala"
	if (_tmp18_ > 0) {
#line 1827 "catalog.c"
		gint _tmp19_ = 0;
#line 87 "/data/projects/seahorse/common/catalog.vala"
		_tmp19_ = height;
#line 87 "/data/projects/seahorse/common/catalog.vala"
		_tmp17_ = _tmp19_ > 0;
#line 1833 "catalog.c"
	} else {
#line 87 "/data/projects/seahorse/common/catalog.vala"
		_tmp17_ = FALSE;
#line 1837 "catalog.c"
	}
#line 87 "/data/projects/seahorse/common/catalog.vala"
	_tmp20_ = _tmp17_;
#line 87 "/data/projects/seahorse/common/catalog.vala"
	if (_tmp20_) {
#line 1843 "catalog.c"
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
#line 88 "/data/projects/seahorse/common/catalog.vala"
		_tmp21_ = width;
#line 88 "/data/projects/seahorse/common/catalog.vala"
		_tmp22_ = height;
#line 88 "/data/projects/seahorse/common/catalog.vala"
		gtk_window_resize ((GtkWindow*) self, _tmp21_, _tmp22_);
#line 1852 "catalog.c"
	}
	{
		gchar* path = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		GtkUIManager* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
#line 92 "/data/projects/seahorse/common/catalog.vala"
		_tmp23_ = self->priv->_ui_name;
#line 92 "/data/projects/seahorse/common/catalog.vala"
		_tmp24_ = g_strdup_printf ("seahorse-%s.ui", _tmp23_);
#line 92 "/data/projects/seahorse/common/catalog.vala"
		_tmp25_ = _tmp24_;
#line 92 "/data/projects/seahorse/common/catalog.vala"
		_tmp26_ = g_build_filename (UIDIR, _tmp25_, NULL);
#line 92 "/data/projects/seahorse/common/catalog.vala"
		_tmp27_ = _tmp26_;
#line 92 "/data/projects/seahorse/common/catalog.vala"
		_g_free0 (_tmp25_);
#line 92 "/data/projects/seahorse/common/catalog.vala"
		path = _tmp27_;
#line 93 "/data/projects/seahorse/common/catalog.vala"
		_tmp28_ = self->priv->_ui_manager;
#line 93 "/data/projects/seahorse/common/catalog.vala"
		_tmp29_ = path;
#line 93 "/data/projects/seahorse/common/catalog.vala"
		gtk_ui_manager_add_ui_from_file (_tmp28_, _tmp29_, &_inner_error_);
#line 93 "/data/projects/seahorse/common/catalog.vala"
		if (_inner_error_ != NULL) {
#line 93 "/data/projects/seahorse/common/catalog.vala"
			_g_free0 (path);
#line 1887 "catalog.c"
			goto __catch5_g_error;
		}
#line 91 "/data/projects/seahorse/common/catalog.vala"
		_g_free0 (path);
#line 1892 "catalog.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
#line 91 "/data/projects/seahorse/common/catalog.vala"
		err = _inner_error_;
#line 91 "/data/projects/seahorse/common/catalog.vala"
		_inner_error_ = NULL;
#line 95 "/data/projects/seahorse/common/catalog.vala"
		_tmp30_ = self->priv->_ui_name;
#line 95 "/data/projects/seahorse/common/catalog.vala"
		_tmp31_ = err;
#line 95 "/data/projects/seahorse/common/catalog.vala"
		_tmp32_ = _tmp31_->message;
#line 95 "/data/projects/seahorse/common/catalog.vala"
		g_warning ("catalog.vala:95: couldn't load ui description for '%s': %s", _tmp30_, _tmp32_);
#line 91 "/data/projects/seahorse/common/catalog.vala"
		_g_error_free0 (err);
#line 1915 "catalog.c"
	}
	__finally5:
#line 91 "/data/projects/seahorse/common/catalog.vala"
	if (_inner_error_ != NULL) {
#line 91 "/data/projects/seahorse/common/catalog.vala"
		_g_free0 (key);
#line 91 "/data/projects/seahorse/common/catalog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 91 "/data/projects/seahorse/common/catalog.vala"
		g_clear_error (&_inner_error_);
#line 1926 "catalog.c"
	}
#line 99 "/data/projects/seahorse/common/catalog.vala"
	_tmp33_ = self->priv->_ui_manager;
#line 99 "/data/projects/seahorse/common/catalog.vala"
	_tmp34_ = gtk_ui_manager_get_accel_group (_tmp33_);
#line 99 "/data/projects/seahorse/common/catalog.vala"
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp34_);
#line 101 "/data/projects/seahorse/common/catalog.vala"
	_tmp35_ = gtk_action_group_new ("main");
#line 101 "/data/projects/seahorse/common/catalog.vala"
	actions = _tmp35_;
#line 102 "/data/projects/seahorse/common/catalog.vala"
	_tmp36_ = actions;
#line 102 "/data/projects/seahorse/common/catalog.vala"
	gtk_action_group_set_translation_domain (_tmp36_, GETTEXT_PACKAGE);
#line 103 "/data/projects/seahorse/common/catalog.vala"
	_tmp37_ = actions;
#line 103 "/data/projects/seahorse/common/catalog.vala"
	gtk_action_group_add_actions (_tmp37_, SEAHORSE_CATALOG_UI_ENTRIES, G_N_ELEMENTS (SEAHORSE_CATALOG_UI_ENTRIES), self);
#line 105 "/data/projects/seahorse/common/catalog.vala"
	_tmp38_ = actions;
#line 105 "/data/projects/seahorse/common/catalog.vala"
	_tmp39_ = gtk_action_group_get_action (_tmp38_, "app-preferences");
#line 105 "/data/projects/seahorse/common/catalog.vala"
	_tmp40_ = _g_object_ref0 (_tmp39_);
#line 105 "/data/projects/seahorse/common/catalog.vala"
	action = _tmp40_;
#line 106 "/data/projects/seahorse/common/catalog.vala"
	_tmp41_ = action;
#line 106 "/data/projects/seahorse/common/catalog.vala"
	_tmp42_ = seahorse_prefs_available ();
#line 106 "/data/projects/seahorse/common/catalog.vala"
	gtk_action_set_visible (_tmp41_, _tmp42_);
#line 107 "/data/projects/seahorse/common/catalog.vala"
	_tmp43_ = actions;
#line 107 "/data/projects/seahorse/common/catalog.vala"
	_tmp44_ = gtk_action_group_get_action (_tmp43_, "edit-delete");
#line 107 "/data/projects/seahorse/common/catalog.vala"
	_tmp45_ = _g_object_ref0 (_tmp44_);
#line 107 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_delete);
#line 107 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_edit_delete = _tmp45_;
#line 108 "/data/projects/seahorse/common/catalog.vala"
	_tmp46_ = actions;
#line 108 "/data/projects/seahorse/common/catalog.vala"
	_tmp47_ = gtk_action_group_get_action (_tmp46_, "properties-object");
#line 108 "/data/projects/seahorse/common/catalog.vala"
	_tmp48_ = _g_object_ref0 (_tmp47_);
#line 108 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_properties_object);
#line 108 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_properties_object = _tmp48_;
#line 109 "/data/projects/seahorse/common/catalog.vala"
	_tmp49_ = actions;
#line 109 "/data/projects/seahorse/common/catalog.vala"
	_tmp50_ = gtk_action_group_get_action (_tmp49_, "edit-export-clipboard");
#line 109 "/data/projects/seahorse/common/catalog.vala"
	_tmp51_ = _g_object_ref0 (_tmp50_);
#line 109 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_copy);
#line 109 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_edit_copy = _tmp51_;
#line 110 "/data/projects/seahorse/common/catalog.vala"
	_tmp52_ = actions;
#line 110 "/data/projects/seahorse/common/catalog.vala"
	_tmp53_ = gtk_action_group_get_action (_tmp52_, "file-export");
#line 110 "/data/projects/seahorse/common/catalog.vala"
	_tmp54_ = _g_object_ref0 (_tmp53_);
#line 110 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_file_export);
#line 110 "/data/projects/seahorse/common/catalog.vala"
	self->priv->_file_export = _tmp54_;
#line 111 "/data/projects/seahorse/common/catalog.vala"
	_tmp55_ = self->priv->_ui_manager;
#line 111 "/data/projects/seahorse/common/catalog.vala"
	_tmp56_ = actions;
#line 111 "/data/projects/seahorse/common/catalog.vala"
	gtk_ui_manager_insert_action_group (_tmp55_, _tmp56_, 0);
#line 113 "/data/projects/seahorse/common/catalog.vala"
	_tmp57_ = seahorse_application_get ();
#line 113 "/data/projects/seahorse/common/catalog.vala"
	gtk_application_add_window (_tmp57_, (GtkWindow*) self);
#line 51 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (action);
#line 51 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (actions);
#line 51 "/data/projects/seahorse/common/catalog.vala"
	_g_free0 (key);
#line 51 "/data/projects/seahorse/common/catalog.vala"
	return obj;
#line 2018 "catalog.c"
}


static void seahorse_catalog_class_init (SeahorseCatalogClass * klass) {
#line 25 "/data/projects/seahorse/common/catalog.vala"
	seahorse_catalog_parent_class = g_type_class_peek_parent (klass);
#line 25 "/data/projects/seahorse/common/catalog.vala"
	g_type_class_add_private (klass, sizeof (SeahorseCatalogPrivate));
#line 25 "/data/projects/seahorse/common/catalog.vala"
	SEAHORSE_CATALOG_CLASS (klass)->get_backends = seahorse_catalog_real_get_backends;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	SEAHORSE_CATALOG_CLASS (klass)->get_focused_place = seahorse_catalog_real_get_focused_place;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	SEAHORSE_CATALOG_CLASS (klass)->get_selected_objects = seahorse_catalog_real_get_selected_objects;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (klass)->dispose = seahorse_catalog_real_dispose;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	SEAHORSE_CATALOG_CLASS (klass)->selection_changed = seahorse_catalog_real_selection_changed;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_catalog_get_property;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_catalog_set_property;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (klass)->constructor = seahorse_catalog_constructor;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_catalog_finalize;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_CATALOG_WINDOW, g_param_spec_object ("window", "window", "window", GTK_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/data/projects/seahorse/common/catalog.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_CATALOG_UI_NAME, g_param_spec_string ("ui-name", "ui-name", "ui-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 25 "/data/projects/seahorse/common/catalog.vala"
	g_signal_new ("selection_changed", SEAHORSE_TYPE_CATALOG, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SeahorseCatalogClass, selection_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2051 "catalog.c"
}


static void seahorse_catalog_instance_init (SeahorseCatalog * self) {
#line 25 "/data/projects/seahorse/common/catalog.vala"
	self->priv = SEAHORSE_CATALOG_GET_PRIVATE (self);
#line 2058 "catalog.c"
}


static void seahorse_catalog_finalize (GObject* obj) {
	SeahorseCatalog * self;
#line 25 "/data/projects/seahorse/common/catalog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
#line 34 "/data/projects/seahorse/common/catalog.vala"
	_g_free0 (self->priv->_ui_name);
#line 36 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_builder);
#line 37 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 38 "/data/projects/seahorse/common/catalog.vala"
	_g_hash_table_unref0 (self->priv->_actions);
#line 39 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_delete);
#line 40 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_properties_object);
#line 41 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_file_export);
#line 42 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_copy);
#line 43 "/data/projects/seahorse/common/catalog.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_selection_actions);
#line 45 "/data/projects/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_settings);
#line 25 "/data/projects/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (seahorse_catalog_parent_class)->finalize (obj);
#line 2088 "catalog.c"
}


GType seahorse_catalog_get_type (void) {
	static volatile gsize seahorse_catalog_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_catalog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseCatalogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_catalog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseCatalog), 0, (GInstanceInitFunc) seahorse_catalog_instance_init, NULL };
		GType seahorse_catalog_type_id;
		seahorse_catalog_type_id = g_type_register_static (GTK_TYPE_WINDOW, "SeahorseCatalog", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&seahorse_catalog_type_id__volatile, seahorse_catalog_type_id);
	}
	return seahorse_catalog_type_id__volatile;
}


static void _vala_seahorse_catalog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
#line 25 "/data/projects/seahorse/common/catalog.vala"
	switch (property_id) {
#line 25 "/data/projects/seahorse/common/catalog.vala"
		case SEAHORSE_CATALOG_WINDOW:
#line 25 "/data/projects/seahorse/common/catalog.vala"
		g_value_set_object (value, seahorse_catalog_get_window (self));
#line 25 "/data/projects/seahorse/common/catalog.vala"
		break;
#line 25 "/data/projects/seahorse/common/catalog.vala"
		case SEAHORSE_CATALOG_UI_NAME:
#line 25 "/data/projects/seahorse/common/catalog.vala"
		g_value_set_string (value, seahorse_catalog_get_ui_name (self));
#line 25 "/data/projects/seahorse/common/catalog.vala"
		break;
#line 2121 "catalog.c"
		default:
#line 25 "/data/projects/seahorse/common/catalog.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/data/projects/seahorse/common/catalog.vala"
		break;
#line 2127 "catalog.c"
	}
}


static void _vala_seahorse_catalog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorseCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
#line 25 "/data/projects/seahorse/common/catalog.vala"
	switch (property_id) {
#line 25 "/data/projects/seahorse/common/catalog.vala"
		case SEAHORSE_CATALOG_UI_NAME:
#line 25 "/data/projects/seahorse/common/catalog.vala"
		seahorse_catalog_set_ui_name (self, g_value_get_string (value));
#line 25 "/data/projects/seahorse/common/catalog.vala"
		break;
#line 2143 "catalog.c"
		default:
#line 25 "/data/projects/seahorse/common/catalog.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/data/projects/seahorse/common/catalog.vala"
		break;
#line 2149 "catalog.c"
	}
}



