/* chess-engine-uci.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from chess-engine-uci.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _ChessEngineUCIPrivate ChessEngineUCIPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
};

struct _ChessEngineUCI {
	ChessEngine parent_instance;
	ChessEngineUCIPrivate * priv;
};

struct _ChessEngineUCIClass {
	ChessEngineClass parent_class;
};

struct _ChessEngineUCIPrivate {
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* moves;
	gchar** options;
	gint options_length1;
	gint _options_size_;
	gchar* go_options;
	gboolean waiting_for_move;
};


static gpointer chess_engine_uci_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_UCI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIPrivate))
enum  {
	CHESS_ENGINE_UCI_DUMMY_PROPERTY
};
ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1);
static gchar** _vala_array_dup23 (gchar** self, int length);
static void chess_engine_uci_start_cb (ChessEngineUCI* self);
static void _chess_engine_uci_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
static void chess_engine_uci_real_start_game (ChessEngine* base);
static void chess_engine_uci_real_request_move (ChessEngine* base);
static void chess_engine_uci_real_report_move (ChessEngine* base, ChessMove* move);
gchar* chess_move_get_engine (ChessMove* self);
static void chess_engine_uci_real_undo (ChessEngine* base);
static void chess_engine_uci_real_process_input (ChessEngine* base, gchar* data, int data_length1);
static void chess_engine_uci_configure (ChessEngineUCI* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static gchar* _vala_array_dup24 (gchar* self, int length);
static gchar** _vala_array_dup25 (gchar** self, int length);
static void chess_engine_uci_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar** _vala_array_dup23 (gchar** self, int length) {
	gchar** result;
	int i;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	result = g_new0 (gchar*, length + 1);
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	for (i = 0; i < length; i++) {
#line 135 "chess-engine-uci.c"
		gchar* _tmp0_ = NULL;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp0_ = g_strdup (self[i]);
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		result[i] = _tmp0_;
#line 141 "chess-engine-uci.c"
	}
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	return result;
#line 145 "chess-engine-uci.c"
}


static void _chess_engine_uci_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self) {
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	chess_engine_uci_start_cb (self);
#line 152 "chess-engine-uci.c"
}


ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1) {
	ChessEngineUCI * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 19 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	g_return_val_if_fail (binary != NULL, NULL);
#line 21 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp0_ = binary;
#line 21 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp1_ = args;
#line 21 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp1__length1 = args_length1;
#line 21 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self = (ChessEngineUCI*) chess_engine_construct (object_type, _tmp0_, _tmp1_, _tmp1__length1);
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp2_ = options;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp2__length1 = options_length1;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup23 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp3__length1 = _tmp2__length1;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->options = _tmp3_;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->options_length1 = _tmp3__length1;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->_options_size_ = self->priv->options_length1;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp4_ = go_options;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp4__length1 = go_options_length1;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp5_ = g_strjoinv (" ", _tmp4_);
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_g_free0 (self->priv->go_options);
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->go_options = _tmp5_;
#line 24 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp6_ = g_new0 (gchar, 0);
#line 24 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 24 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->buffer = _tmp6_;
#line 24 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->buffer_length1 = 0;
#line 24 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp7_ = g_strdup ("");
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_g_free0 (self->priv->moves);
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->moves = _tmp7_;
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	g_signal_connect_object ((ChessEngine*) self, "starting", (GCallback) _chess_engine_uci_start_cb_chess_engine_starting, self, 0);
#line 19 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	return self;
#line 226 "chess-engine-uci.c"
}


ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1) {
#line 19 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	return chess_engine_uci_construct (TYPE_CHESS_ENGINE_UCI, binary, args, args_length1, options, options_length1, go_options, go_options_length1);
#line 233 "chess-engine-uci.c"
}


static void chess_engine_uci_start_cb (ChessEngineUCI* self) {
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	g_return_if_fail (self != NULL);
#line 31 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	chess_engine_write_line ((ChessEngine*) self, "uci");
#line 242 "chess-engine-uci.c"
}


static void chess_engine_uci_real_start_game (ChessEngine* base) {
	ChessEngineUCI * self;
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self = (ChessEngineUCI*) base;
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	chess_engine_write_line ((ChessEngine*) self, "ucinewgame");
#line 252 "chess-engine-uci.c"
}


static void chess_engine_uci_real_request_move (ChessEngine* base) {
	ChessEngineUCI * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self = (ChessEngineUCI*) base;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp0_ = self->priv->moves;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	if (g_strcmp0 (_tmp0_, "") != 0) {
#line 268 "chess-engine-uci.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 42 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp1_ = self->priv->moves;
#line 42 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp2_ = g_strconcat ("position startpos moves", _tmp1_, NULL);
#line 42 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp3_ = _tmp2_;
#line 42 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		chess_engine_write_line ((ChessEngine*) self, _tmp3_);
#line 42 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_g_free0 (_tmp3_);
#line 282 "chess-engine-uci.c"
	} else {
#line 44 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		chess_engine_write_line ((ChessEngine*) self, "position startpos");
#line 286 "chess-engine-uci.c"
	}
#line 45 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->waiting_for_move = TRUE;
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp4_ = self->priv->go_options;
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp5_ = g_strdup_printf ("go wtime 30000 btime 30000 %s", _tmp4_);
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp6_ = _tmp5_;
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	chess_engine_write_line ((ChessEngine*) self, _tmp6_);
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_g_free0 (_tmp6_);
#line 300 "chess-engine-uci.c"
}


static void chess_engine_uci_real_report_move (ChessEngine* base, ChessMove* move) {
	ChessEngineUCI * self;
	const gchar* _tmp0_ = NULL;
	ChessMove* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self = (ChessEngineUCI*) base;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	g_return_if_fail (move != NULL);
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp0_ = self->priv->moves;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp1_ = move;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp2_ = chess_move_get_engine (_tmp1_);
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp3_ = _tmp2_;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp4_ = g_strconcat (" ", _tmp3_, NULL);
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp5_ = _tmp4_;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp6_ = g_strconcat (_tmp0_, _tmp5_, NULL);
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_g_free0 (self->priv->moves);
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->moves = _tmp6_;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_g_free0 (_tmp5_);
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_g_free0 (_tmp3_);
#line 339 "chess-engine-uci.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1189 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1190 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1190 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1190 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1191 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1191 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 374 "chess-engine-uci.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1192 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1192 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1192 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 383 "chess-engine-uci.c"
	}
#line 1194 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1194 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 389 "chess-engine-uci.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1195 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1195 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1195 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 398 "chess-engine-uci.c"
	}
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 404 "chess-engine-uci.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 413 "chess-engine-uci.c"
	} else {
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 417 "chess-engine-uci.c"
	}
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 427 "chess-engine-uci.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 436 "chess-engine-uci.c"
	} else {
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 440 "chess-engine-uci.c"
	}
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1200 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1200 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1200 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1200 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1200 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1200 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 464 "chess-engine-uci.c"
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 908 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 908 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 909 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 909 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 909 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 909 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 911 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 911 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 491 "chess-engine-uci.c"
		gchar* _tmp4_ = NULL;
#line 912 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 912 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 912 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 499 "chess-engine-uci.c"
	} else {
#line 914 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		result = -1;
#line 914 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 505 "chess-engine-uci.c"
	}
}


static void chess_engine_uci_real_undo (ChessEngine* base) {
	ChessEngineUCI * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
#line 54 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self = (ChessEngineUCI*) base;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp0_ = self->priv->waiting_for_move;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	if (_tmp0_) {
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		chess_engine_write_line ((ChessEngine*) self, "stop");
#line 525 "chess-engine-uci.c"
	}
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->waiting_for_move = FALSE;
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp1_ = self->priv->moves;
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp2_ = self->priv->moves;
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp3_ = string_last_index_of (_tmp2_, " ", 0);
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp4_ = string_slice (_tmp1_, (glong) 0, (glong) _tmp3_);
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_g_free0 (self->priv->moves);
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->moves = _tmp4_;
#line 541 "chess-engine-uci.c"
}


static gchar* _vala_array_dup24 (gchar* self, int length) {
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 548 "chess-engine-uci.c"
}


static void chess_engine_uci_real_process_input (ChessEngine* base, gchar* data, int data_length1) {
	ChessEngineUCI * self;
	gint current = 0;
	gchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self = (ChessEngineUCI*) base;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp0_ = self->priv->buffer;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp0__length1 = self->priv->buffer_length1;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	current = _tmp0__length1;
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp1_ = self->priv->buffer;
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp1__length1 = self->priv->buffer_length1;
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp2_ = data;
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp2__length1 = data_length1;
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp3_ = (gint) (_tmp1__length1 + _tmp2__length1);
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->buffer = g_renew (gchar, self->priv->buffer, (gint) (_tmp1__length1 + _tmp2__length1));
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	(_tmp3_ > self->priv->buffer_length1) ? memset (self->priv->buffer + self->priv->buffer_length1, 0, sizeof (gchar) * (_tmp3_ - self->priv->buffer_length1)) : NULL;
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->buffer_length1 = _tmp3_;
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->_buffer_size_ = _tmp3_;
#line 588 "chess-engine-uci.c"
	{
		gint i = 0;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		i = 0;
#line 593 "chess-engine-uci.c"
		{
			gboolean _tmp4_ = FALSE;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			_tmp4_ = TRUE;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			while (TRUE) {
#line 600 "chess-engine-uci.c"
				gboolean _tmp5_ = FALSE;
				gint _tmp7_ = 0;
				gchar* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gchar* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gchar* _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
				gchar _tmp15_ = '\0';
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp5_ = _tmp4_;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				if (!_tmp5_) {
#line 618 "chess-engine-uci.c"
					gint _tmp6_ = 0;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					_tmp6_ = i;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					i = _tmp6_ + 1;
#line 624 "chess-engine-uci.c"
				}
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp4_ = FALSE;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp7_ = i;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp8_ = data;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp8__length1 = data_length1;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				if (!(_tmp7_ < _tmp8__length1)) {
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					break;
#line 638 "chess-engine-uci.c"
				}
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp9_ = self->priv->buffer;
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp9__length1 = self->priv->buffer_length1;
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp10_ = current;
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp11_ = i;
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp12_ = data;
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp12__length1 = data_length1;
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp13_ = i;
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp14_ = _tmp12_[_tmp13_];
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp9_[_tmp10_ + _tmp11_] = _tmp14_;
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp15_ = _tmp9_[_tmp10_ + _tmp11_];
#line 660 "chess-engine-uci.c"
			}
		}
	}
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	while (TRUE) {
#line 666 "chess-engine-uci.c"
		gint offset = 0;
		gint _tmp26_ = 0;
		gchar* _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gchar* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp29_ = 0;
		gchar _tmp30_ = '\0';
		gchar* line = NULL;
		gchar* _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gchar** tokens = NULL;
		const gchar* _tmp34_ = NULL;
		gchar** _tmp35_ = NULL;
		gchar** _tmp36_ = NULL;
		gint tokens_length1 = 0;
		gint _tokens_size_ = 0;
		gchar** _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
		gchar* _tmp54_ = NULL;
		gint _tmp54__length1 = 0;
		gint _tmp55_ = 0;
		gchar* _tmp56_ = NULL;
		gint _tmp56__length1 = 0;
		gchar* _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		{
			gboolean _tmp16_ = FALSE;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			offset = 0;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			_tmp16_ = TRUE;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			while (TRUE) {
#line 703 "chess-engine-uci.c"
				gboolean _tmp17_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gint _tmp20_ = 0;
				gchar* _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gboolean _tmp25_ = FALSE;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp17_ = _tmp16_;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				if (!_tmp17_) {
#line 714 "chess-engine-uci.c"
					gint _tmp18_ = 0;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					_tmp18_ = offset;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					offset = _tmp18_ + 1;
#line 720 "chess-engine-uci.c"
				}
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp16_ = FALSE;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp20_ = offset;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp21_ = self->priv->buffer;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp21__length1 = self->priv->buffer_length1;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				if (_tmp20_ < _tmp21__length1) {
#line 732 "chess-engine-uci.c"
					gchar* _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					gint _tmp23_ = 0;
					gchar _tmp24_ = '\0';
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					_tmp22_ = self->priv->buffer;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					_tmp22__length1 = self->priv->buffer_length1;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					_tmp23_ = offset;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					_tmp24_ = _tmp22_[_tmp23_];
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					_tmp19_ = _tmp24_ != '\n';
#line 747 "chess-engine-uci.c"
				} else {
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					_tmp19_ = FALSE;
#line 751 "chess-engine-uci.c"
				}
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp25_ = _tmp19_;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				if (!_tmp25_) {
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
					break;
#line 759 "chess-engine-uci.c"
				}
			}
		}
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp26_ = offset;
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp27_ = self->priv->buffer;
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp27__length1 = self->priv->buffer_length1;
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		if (_tmp26_ >= _tmp27__length1) {
#line 77 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			return;
#line 773 "chess-engine-uci.c"
		}
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp28_ = self->priv->buffer;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp28__length1 = self->priv->buffer_length1;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp29_ = offset;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp28_[_tmp29_] = '\0';
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp30_ = _tmp28_[_tmp29_];
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp31_ = self->priv->buffer;
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp31__length1 = self->priv->buffer_length1;
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp32_ = g_strdup ((const gchar*) _tmp31_);
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		line = _tmp32_;
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp33_ = line;
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		g_debug ("chess-engine-uci.vala:82: Read from engine: '%s'", _tmp33_);
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp34_ = line;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, " ", 0);
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		tokens = _tmp36_;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		tokens_length1 = _vala_array_length (_tmp35_);
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tokens_size_ = tokens_length1;
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp37_ = tokens;
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp37__length1 = tokens_length1;
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		if (_tmp37__length1 > 0) {
#line 813 "chess-engine-uci.c"
			gchar** _tmp38_ = NULL;
			gint _tmp38__length1 = 0;
			const gchar* _tmp39_ = NULL;
			const gchar* _tmp40_ = NULL;
			GQuark _tmp42_ = 0U;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			static GQuark _tmp41_label0 = 0;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			static GQuark _tmp41_label1 = 0;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			static GQuark _tmp41_label2 = 0;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			static GQuark _tmp41_label3 = 0;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			static GQuark _tmp41_label4 = 0;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			static GQuark _tmp41_label5 = 0;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			_tmp38_ = tokens;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			_tmp38__length1 = tokens_length1;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			_tmp39_ = _tmp38_[0];
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			_tmp40_ = _tmp39_;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			_tmp42_ = (NULL == _tmp40_) ? 0 : g_quark_from_string (_tmp40_);
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			if (_tmp42_ == ((0 != _tmp41_label0) ? _tmp41_label0 : (_tmp41_label0 = g_quark_from_static_string ("id")))) {
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				switch (0) {
#line 845 "chess-engine-uci.c"
					default:
					{
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						break;
#line 850 "chess-engine-uci.c"
					}
				}
			} else if (_tmp42_ == ((0 != _tmp41_label1) ? _tmp41_label1 : (_tmp41_label1 = g_quark_from_static_string ("uciok")))) {
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				switch (0) {
#line 856 "chess-engine-uci.c"
					default:
					{
						gchar** _tmp43_ = NULL;
						gint _tmp43__length1 = 0;
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp43_ = tokens;
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp43__length1 = tokens_length1;
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						if (_tmp43__length1 != 1) {
#line 867 "chess-engine-uci.c"
							const gchar* _tmp44_ = NULL;
#line 94 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
							_tmp44_ = line;
#line 94 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
							g_warning ("chess-engine-uci.vala:94: Unexpected arguments on uciok: %s", _tmp44_);
#line 873 "chess-engine-uci.c"
						}
#line 96 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						chess_engine_uci_configure (self);
#line 97 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						break;
#line 879 "chess-engine-uci.c"
					}
				}
			} else if (_tmp42_ == ((0 != _tmp41_label2) ? _tmp41_label2 : (_tmp41_label2 = g_quark_from_static_string ("readyok")))) {
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				switch (0) {
#line 885 "chess-engine-uci.c"
					default:
					{
						gchar** _tmp45_ = NULL;
						gint _tmp45__length1 = 0;
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp45_ = tokens;
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp45__length1 = tokens_length1;
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						if (_tmp45__length1 != 1) {
#line 896 "chess-engine-uci.c"
							const gchar* _tmp46_ = NULL;
#line 101 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
							_tmp46_ = line;
#line 101 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
							g_warning ("chess-engine-uci.vala:101: Unexpected arguments on readyok: %s", _tmp46_);
#line 902 "chess-engine-uci.c"
						}
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						chess_engine_set_ready ((ChessEngine*) self, TRUE);
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						break;
#line 908 "chess-engine-uci.c"
					}
				}
			} else if (_tmp42_ == ((0 != _tmp41_label3) ? _tmp41_label3 : (_tmp41_label3 = g_quark_from_static_string ("bestmove")))) {
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				switch (0) {
#line 914 "chess-engine-uci.c"
					default:
					{
						gchar** _tmp47_ = NULL;
						gint _tmp47__length1 = 0;
						gchar** _tmp49_ = NULL;
						gint _tmp49__length1 = 0;
						const gchar* _tmp50_ = NULL;
						gchar** _tmp51_ = NULL;
						gint _tmp51__length1 = 0;
						const gchar* _tmp52_ = NULL;
#line 107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp47_ = tokens;
#line 107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp47__length1 = tokens_length1;
#line 107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						if (_tmp47__length1 < 2) {
#line 931 "chess-engine-uci.c"
							const gchar* _tmp48_ = NULL;
#line 108 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
							_tmp48_ = line;
#line 108 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
							g_warning ("chess-engine-uci.vala:108: No move with bestmove: %s", _tmp48_);
#line 937 "chess-engine-uci.c"
						}
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp49_ = tokens;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp49__length1 = tokens_length1;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp50_ = _tmp49_[1];
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						g_debug ("chess-engine-uci.vala:109: Engine moves %s", _tmp50_);
#line 110 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						self->priv->waiting_for_move = FALSE;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp51_ = tokens;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp51__length1 = tokens_length1;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp52_ = _tmp51_[1];
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						g_signal_emit_by_name ((ChessEngine*) self, "moved", _tmp52_);
#line 112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						break;
#line 959 "chess-engine-uci.c"
					}
				}
			} else if (_tmp42_ == ((0 != _tmp41_label4) ? _tmp41_label4 : (_tmp41_label4 = g_quark_from_static_string ("info")))) {
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				switch (0) {
#line 965 "chess-engine-uci.c"
					default:
					{
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						break;
#line 970 "chess-engine-uci.c"
					}
				}
			} else if (_tmp42_ == ((0 != _tmp41_label5) ? _tmp41_label5 : (_tmp41_label5 = g_quark_from_static_string ("option")))) {
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				switch (0) {
#line 976 "chess-engine-uci.c"
					default:
					{
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						break;
#line 981 "chess-engine-uci.c"
					}
				}
			} else {
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				switch (0) {
#line 987 "chess-engine-uci.c"
					default:
					{
						const gchar* _tmp53_ = NULL;
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						_tmp53_ = line;
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						g_warning ("chess-engine-uci.vala:121: Unknown command: '%s'", _tmp53_);
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
						break;
#line 997 "chess-engine-uci.c"
					}
				}
			}
		}
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp54_ = self->priv->buffer;
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp54__length1 = self->priv->buffer_length1;
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp55_ = offset;
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp56_ = self->priv->buffer;
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp56__length1 = self->priv->buffer_length1;
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp57_ = ((_tmp54_ + (_tmp55_ + 1)) != NULL) ? _vala_array_dup24 (_tmp54_ + (_tmp55_ + 1), _tmp56__length1 - (_tmp55_ + 1)) : ((gpointer) (_tmp54_ + (_tmp55_ + 1)));
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp57__length1 = _tmp56__length1 - (_tmp55_ + 1);
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		self->priv->buffer = _tmp57_;
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		self->priv->buffer_length1 = _tmp57__length1;
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_g_free0 (line);
#line 1028 "chess-engine-uci.c"
	}
}


static gchar** _vala_array_dup25 (gchar** self, int length) {
	gchar** result;
	int i;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	result = g_new0 (gchar*, length + 1);
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	for (i = 0; i < length; i++) {
#line 1040 "chess-engine-uci.c"
		gchar* _tmp0_ = NULL;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		_tmp0_ = g_strdup (self[i]);
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		result[i] = _tmp0_;
#line 1046 "chess-engine-uci.c"
	}
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	return result;
#line 1050 "chess-engine-uci.c"
}


static void chess_engine_uci_configure (ChessEngineUCI* self) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	g_return_if_fail (self != NULL);
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp0_ = self->priv->options;
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_tmp0__length1 = self->priv->options_length1;
#line 1063 "chess-engine-uci.c"
	{
		gchar** o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		o_collection = _tmp0_;
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		o_collection_length1 = _tmp0__length1;
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
		for (o_it = 0; o_it < _tmp0__length1; o_it = o_it + 1) {
#line 1075 "chess-engine-uci.c"
			gchar* _tmp1_ = NULL;
			gchar* o = NULL;
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			_tmp1_ = g_strdup (o_collection[o_it]);
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
			o = _tmp1_;
#line 1082 "chess-engine-uci.c"
			{
				gchar** line = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint line_length1 = 0;
				gint _line_size_ = 0;
				gchar* option_value = NULL;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gchar* option_name = NULL;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp2_ = o;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				line = _tmp4_;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				line_length1 = _vala_array_length (_tmp3_);
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_line_size_ = line_length1;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp5_ = line;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp5__length1 = line_length1;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp6_ = line;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp6__length1 = line_length1;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp7_ = _tmp5_[_tmp6__length1 - 1];
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp8_ = g_strdup (_tmp7_);
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				option_value = _tmp8_;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp9_ = line;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp9__length1 = line_length1;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp10_ = line;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp10__length1 = line_length1;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp11_ = ((_tmp9_ + 0) != NULL) ? _vala_array_dup25 (_tmp9_ + 0, (_tmp10__length1 - 1) - 0) : ((gpointer) (_tmp9_ + 0));
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp11__length1 = (_tmp10__length1 - 1) - 0;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				line = _tmp11_;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				line_length1 = _tmp11__length1;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_line_size_ = line_length1;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp12_ = line;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp12__length1 = line_length1;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp13_ = g_strjoinv (" ", _tmp12_);
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				option_name = _tmp13_;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp14_ = option_name;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp15_ = option_value;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp16_ = g_strdup_printf ("setoption name %s value %s", _tmp14_, _tmp15_);
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_tmp17_ = _tmp16_;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				chess_engine_write_line ((ChessEngine*) self, _tmp17_);
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_g_free0 (_tmp17_);
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_g_free0 (option_name);
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_g_free0 (option_value);
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
				_g_free0 (o);
#line 1183 "chess-engine-uci.c"
			}
		}
	}
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	chess_engine_write_line ((ChessEngine*) self, "isready");
#line 1189 "chess-engine-uci.c"
}


static void chess_engine_uci_class_init (ChessEngineUCIClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	chess_engine_uci_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	g_type_class_add_private (klass, sizeof (ChessEngineUCIPrivate));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	CHESS_ENGINE_CLASS (klass)->start_game = chess_engine_uci_real_start_game;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	CHESS_ENGINE_CLASS (klass)->request_move = chess_engine_uci_real_request_move;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	CHESS_ENGINE_CLASS (klass)->report_move = chess_engine_uci_real_report_move;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	CHESS_ENGINE_CLASS (klass)->undo = chess_engine_uci_real_undo;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	CHESS_ENGINE_CLASS (klass)->process_input = chess_engine_uci_real_process_input;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_engine_uci_finalize;
#line 1210 "chess-engine-uci.c"
}


static void chess_engine_uci_instance_init (ChessEngineUCI * self) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv = CHESS_ENGINE_UCI_GET_PRIVATE (self);
#line 1217 "chess-engine-uci.c"
}


static void chess_engine_uci_finalize (GObject* obj) {
	ChessEngineUCI * self;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE_UCI, ChessEngineUCI);
#line 13 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_g_free0 (self->priv->moves);
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
#line 16 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	_g_free0 (self->priv->go_options);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine-uci.vala"
	G_OBJECT_CLASS (chess_engine_uci_parent_class)->finalize (obj);
#line 1235 "chess-engine-uci.c"
}


GType chess_engine_uci_get_type (void) {
	static volatile gsize chess_engine_uci_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_uci_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineUCIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_uci_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngineUCI), 0, (GInstanceInitFunc) chess_engine_uci_instance_init, NULL };
		GType chess_engine_uci_type_id;
		chess_engine_uci_type_id = g_type_register_static (TYPE_CHESS_ENGINE, "ChessEngineUCI", &g_define_type_info, 0);
		g_once_init_leave (&chess_engine_uci_type_id__volatile, chess_engine_uci_type_id);
	}
	return chess_engine_uci_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



