/* rygel-http-response-test.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-response-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_HTTP_RESPONSE_TEST (rygel_http_response_test_get_type ())
#define RYGEL_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTest))
#define RYGEL_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))
#define RYGEL_IS_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_IS_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_HTTP_RESPONSE_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))

typedef struct _RygelHTTPResponseTest RygelHTTPResponseTest;
typedef struct _RygelHTTPResponseTestClass RygelHTTPResponseTestClass;
typedef struct _RygelHTTPResponseTestPrivate RygelHTTPResponseTestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_media_item_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_item_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;
typedef struct _RygelHTTPByteSeekPrivate RygelHTTPByteSeekPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
typedef struct _RygelHTTPTimeSeekPrivate RygelHTTPTimeSeekPrivate;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_TEST_DATA_SOURCE (rygel_test_data_source_get_type ())
#define RYGEL_TEST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TEST_DATA_SOURCE, RygelTestDataSource))
#define RYGEL_TEST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TEST_DATA_SOURCE, RygelTestDataSourceClass))
#define RYGEL_IS_TEST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TEST_DATA_SOURCE))
#define RYGEL_IS_TEST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TEST_DATA_SOURCE))
#define RYGEL_TEST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TEST_DATA_SOURCE, RygelTestDataSourceClass))

typedef struct _RygelTestDataSource RygelTestDataSource;
typedef struct _RygelTestDataSourceClass RygelTestDataSourceClass;
typedef struct _RygelTestDataSourcePrivate RygelTestDataSourcePrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelParamSpecMediaItem RygelParamSpecMediaItem;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPResponseTest {
	GObject parent_instance;
	RygelHTTPResponseTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
	GCancellable* cancellable;
};

struct _RygelHTTPResponseTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponseTest* self, GError** error);
};

struct _RygelHTTPResponseTestPrivate {
	gboolean server_done;
	gboolean client_done;
	RygelMediaItem* item;
	GMainLoop* main_loop;
	GError* error;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
	gsize total_bytes;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gsize bytes_received;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	SoupMessage* _tmp0_;
	GUPnPContext* _tmp1_;
	SoupSession* _tmp2_;
	SoupSession* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
};

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
};

struct _RygelHTTPSeekPrivate {
	gint64 _start;
	gint64 _stop;
	gint64 _length;
	gint64 _total_length;
};

struct _RygelHTTPByteSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPByteSeekPrivate * priv;
};

struct _RygelHTTPByteSeekClass {
	RygelHTTPSeekClass parent_class;
};

struct _RygelHTTPTimeSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPTimeSeekPrivate * priv;
};

struct _RygelHTTPTimeSeekClass {
	RygelHTTPSeekClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupServer* server;
	SoupMessage* msg;
	GCancellable* cancellable;
	RygelMediaItem* item;
	RygelHTTPSeek* seek;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
};

struct _RygelTestDataSource {
	GObject parent_instance;
	RygelTestDataSourcePrivate * priv;
};

struct _RygelTestDataSourceClass {
	GObjectClass parent_class;
};

struct _RygelTestDataSourcePrivate {
	glong block_size;
	glong buffers;
	guint64 data_sent;
	gboolean frozen;
};

struct _RygelMediaItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaItem *self);
};

struct _RygelMediaItemPrivate {
	RygelDataSource* src;
	gboolean is_live;
};

struct _RygelParamSpecMediaItem {
	GParamSpec parent_instance;
};


static gpointer rygel_http_response_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_http_seek_parent_class = NULL;
static gpointer rygel_http_byte_seek_parent_class = NULL;
static gpointer rygel_http_time_seek_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_get_handler_parent_class = NULL;
static gpointer rygel_test_data_source_parent_class = NULL;
static RygelDataSourceIface* rygel_test_data_source_rygel_data_source_parent_iface = NULL;
static gpointer rygel_media_item_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_test_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
gpointer rygel_media_item_ref (gpointer instance);
void rygel_media_item_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_item (GValue* value, gpointer v_object);
void rygel_value_take_media_item (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_item (const GValue* value);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_RESPONSE_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestPrivate))
enum  {
	RYGEL_HTTP_RESPONSE_TEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES ((glong) 102400)
gint rygel_http_response_test_main (gchar** args, int args_length1);
RygelHTTPResponseTest* rygel_http_response_test_new_complete (GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct_complete (GType object_type, GError** error);
void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_new_abort (GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct_abort (GType object_type, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_new (GCancellable* cancellable, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GCancellable* cancellable, GError** error);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active);
RygelMediaItem* rygel_media_item_new_fixed_size (void);
RygelMediaItem* rygel_media_item_construct_fixed_size (GType object_type);
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_http_response_test_real_run (RygelHTTPResponseTest* self, GError** error);
static gboolean rygel_http_response_test_on_timeout (RygelHTTPResponseTest* self);
static gboolean _rygel_http_response_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_response_test_on_message_received (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_response_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
static void rygel_http_response_test_on_message_aborted (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_http_response_test_on_client_completed (RygelHTTPResponseTest* self, RygelStateMachine* client);
static void _rygel_http_response_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
static RygelHTTPResponse* rygel_http_response_test_create_response (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
RygelHTTPByteSeek* rygel_http_byte_seek_new (gint64 start, gint64 stop, gint64 total_length);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length);
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
RygelHTTPGet* rygel_http_get_new (SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable);
RygelHTTPGet* rygel_http_get_construct (GType object_type, SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
RygelHTTPGetHandler* rygel_http_get_handler_new (GCancellable* cancellable);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_data_source_get_type (void) G_GNUC_CONST;
RygelDataSource* rygel_media_item_create_stream_source (RygelMediaItem* self);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
static void rygel_http_response_test_on_response_completed (RygelHTTPResponseTest* self, RygelStateMachine* response);
static void _rygel_http_response_test_on_response_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static void rygel_http_response_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_client_on_cancelled (RygelHTTPClient* self, GCancellable* cancellable);
static void _rygel_http_client_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void __lambda2_ (Block1Data* _data1_, SoupMessage* msg, SoupBuffer* chunk);
static void ___lambda2__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void __lambda3_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg);
static void ___lambda3__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_SEEK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekPrivate))
enum  {
	RYGEL_HTTP_SEEK_DUMMY_PROPERTY,
	RYGEL_HTTP_SEEK_START,
	RYGEL_HTTP_SEEK_STOP,
	RYGEL_HTTP_SEEK_LENGTH,
	RYGEL_HTTP_SEEK_TOTAL_LENGTH
};
RygelHTTPSeek* rygel_http_seek_new (gint64 start, gint64 stop, gint64 total_length);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length);
static void rygel_http_seek_set_start (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_stop (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_total_length (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_length (RygelHTTPSeek* self, gint64 value);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
static void rygel_http_seek_finalize (GObject* obj);
static void _vala_rygel_http_seek_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_seek_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_HTTP_BYTE_SEEK_DUMMY_PROPERTY
};
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_DUMMY_PROPERTY
};
RygelHTTPTimeSeek* rygel_http_time_seek_new (gint64 start, gint64 stop, gint64 total_length);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length);
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
static void rygel_http_get_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY
};
static void rygel_http_get_handler_finalize (GObject* obj);
GType rygel_test_data_source_get_type (void) G_GNUC_CONST;
#define RYGEL_TEST_DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TEST_DATA_SOURCE, RygelTestDataSourcePrivate))
enum  {
	RYGEL_TEST_DATA_SOURCE_DUMMY_PROPERTY
};
RygelTestDataSource* rygel_test_data_source_new (glong block_size, glong buffers);
RygelTestDataSource* rygel_test_data_source_construct (GType object_type, glong block_size, glong buffers);
static void rygel_test_data_source_real_start (RygelDataSource* base, RygelHTTPSeek* seek, GError** error);
static gboolean __lambda4_ (RygelTestDataSource* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static void rygel_test_data_source_real_freeze (RygelDataSource* base);
static void rygel_test_data_source_real_thaw (RygelDataSource* base);
void rygel_data_source_start (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
static void rygel_test_data_source_real_stop (RygelDataSource* base);
void rygel_data_source_freeze (RygelDataSource* self);
static void rygel_test_data_source_finalize (GObject* obj);
#define RYGEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemPrivate))
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_ITEM_BLOCK_SIZE (RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES / 16)
#define RYGEL_MEDIA_ITEM_MAX_BUFFERS ((glong) 25)
static void rygel_media_item_finalize (RygelMediaItem* obj);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


gint rygel_http_response_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPResponseTest* test = NULL;
		RygelHTTPResponseTest* _tmp0_ = NULL;
		RygelHTTPResponseTest* _tmp1_ = NULL;
		RygelHTTPResponseTest* _tmp2_ = NULL;
		RygelHTTPResponseTest* _tmp3_ = NULL;
		RygelHTTPResponseTest* _tmp4_ = NULL;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp0_ = rygel_http_response_test_new_complete (&_inner_error_);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		test = _tmp0_;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 53 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 580 "rygel-http-response-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 54 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp1_ = test;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_response_test_run (_tmp1_, &_inner_error_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			_g_object_unref0 (test);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 595 "rygel-http-response-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp3_ = rygel_http_response_test_new_abort (&_inner_error_);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp2_ = _tmp3_;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			_g_object_unref0 (test);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 610 "rygel-http-response-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (test);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		test = _tmp2_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp4_ = test;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_response_test_run (_tmp4_, &_inner_error_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			_g_object_unref0 (test);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 629 "rygel-http-response-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (test);
#line 636 "rygel-http-response-test.c"
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
		GError* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_error_ = _inner_error_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = NULL;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp5_ = _error_;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp6_ = _tmp5_->code;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		result = _tmp6_;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (_error_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return result;
#line 658 "rygel-http-response-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_error_ = _inner_error_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = NULL;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp7_ = _error_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp8_ = _tmp7_->message;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_critical ("rygel-http-response-test.vala:61: %s", _tmp8_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		result = -1;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (_error_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return result;
#line 682 "rygel-http-response-test.c"
	}
	__finally0:
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_clear_error (&_inner_error_);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return 0;
#line 693 "rygel-http-response-test.c"
	}
#line 66 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = 0;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 699 "rygel-http-response-test.c"
}


int main (int argc, char ** argv) {
#line 51 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_init ();
#line 51 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_response_test_main (argv, argc);
#line 708 "rygel-http-response-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 715 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GCancellable* cancellable, GError** error) {
	RygelHTTPResponseTest * self = NULL;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	RygelHTTPServer* _tmp3_ = NULL;
	RygelHTTPServer* _tmp4_ = NULL;
	GUPnPContext* _tmp5_ = NULL;
	RygelHTTPServer* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GCancellable* _tmp10_ = NULL;
	RygelHTTPClient* _tmp11_ = NULL;
	GMainLoop* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPResponseTest*) g_object_new (object_type, NULL);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = cancellable;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->cancellable = _tmp1_;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = rygel_http_server_new (&_inner_error_);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = _tmp3_;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_propagate_error (error, _inner_error_);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (self);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return NULL;
#line 757 "rygel-http-response-test.c"
	}
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->server);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->server = _tmp2_;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = self->server;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = _tmp4_->context;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = self->server;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp7_ = rygel_http_server_get_uri (_tmp6_);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp8_ = _tmp7_;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp9_ = _tmp8_;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp10_ = cancellable;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp11_ = rygel_http_client_new (_tmp5_, _tmp9_, (gsize) RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES, _tmp10_ != NULL);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->client);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->client = _tmp11_;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_free0 (_tmp9_);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp12_ = g_main_loop_new (NULL, FALSE);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->main_loop = _tmp12_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 793 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_new (GCancellable* cancellable, GError** error) {
#line 69 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_response_test_construct (RYGEL_TYPE_HTTP_RESPONSE_TEST, cancellable, error);
#line 800 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_construct_complete (GType object_type, GError** error) {
	RygelHTTPResponseTest * self = NULL;
	RygelMediaItem* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPResponseTest*) rygel_http_response_test_construct (object_type, NULL, &_inner_error_);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_propagate_error (error, _inner_error_);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (self);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return NULL;
#line 818 "rygel-http-response-test.c"
	}
#line 83 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = rygel_media_item_new_fixed_size ();
#line 83 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_rygel_media_item_unref0 (self->priv->item);
#line 83 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->item = _tmp0_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 828 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_new_complete (GError** error) {
#line 80 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_response_test_construct_complete (RYGEL_TYPE_HTTP_RESPONSE_TEST, error);
#line 835 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_construct_abort (GType object_type, GError** error) {
	RygelHTTPResponseTest * self = NULL;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	RygelMediaItem* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = g_cancellable_new ();
#line 87 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _tmp0_;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPResponseTest*) rygel_http_response_test_construct (object_type, _tmp1_, &_inner_error_);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (_tmp1_);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 87 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_propagate_error (error, _inner_error_);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (self);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return NULL;
#line 861 "rygel-http-response-test.c"
	}
#line 89 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = rygel_media_item_new ();
#line 89 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_rygel_media_item_unref0 (self->priv->item);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->item = _tmp2_;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 871 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_new_abort (GError** error) {
#line 86 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_response_test_construct_abort (RYGEL_TYPE_HTTP_RESPONSE_TEST, error);
#line 878 "rygel-http-response-test.c"
}


static gboolean _rygel_http_response_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_test_on_timeout (self);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 887 "rygel-http-response-test.c"
}


static void _rygel_http_response_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 94 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_response_test_on_message_received (self, _sender, message);
#line 894 "rygel-http-response-test.c"
}


static void _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 95 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_response_test_on_message_aborted (self, _sender, message);
#line 901 "rygel-http-response-test.c"
}


static void _rygel_http_response_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 97 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_response_test_on_client_completed (self, _sender);
#line 908 "rygel-http-response-test.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 107 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self ? g_error_copy (self) : NULL;
#line 915 "rygel-http-response-test.c"
}


static void rygel_http_response_test_real_run (RygelHTTPResponseTest* self, GError** error) {
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	RygelHTTPClient* _tmp4_ = NULL;
	GMainLoop* _tmp5_ = NULL;
	GError* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_response_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->server;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_connect_object (_tmp0_, "message-received", (GCallback) _rygel_http_response_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = self->server;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_connect_object (_tmp1_, "message-aborted", (GCallback) _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted, self, 0);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = self->cancellable;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp2_ == NULL) {
#line 941 "rygel-http-response-test.c"
		RygelHTTPClient* _tmp3_ = NULL;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp3_ = self->client;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_signal_connect_object ((RygelStateMachine*) _tmp3_, "completed", (GCallback) _rygel_http_response_test_on_client_completed_rygel_state_machine_completed, self, 0);
#line 947 "rygel-http-response-test.c"
	} else {
#line 99 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		self->priv->client_done = TRUE;
#line 951 "rygel-http-response-test.c"
	}
#line 102 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = self->client;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp4_, NULL, NULL);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = self->priv->main_loop;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_main_loop_run (_tmp5_);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = self->priv->error;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp6_ != NULL) {
#line 965 "rygel-http-response-test.c"
		GError* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp7_ = self->priv->error;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp8_ = _g_error_copy0 (_tmp7_);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = _tmp8_;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_propagate_error (error, _inner_error_);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return;
#line 978 "rygel-http-response-test.c"
	}
}


void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error) {
#line 92 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	RYGEL_HTTP_RESPONSE_TEST_GET_CLASS (self)->run (self, error);
#line 988 "rygel-http-response-test.c"
}


static RygelHTTPResponse* rygel_http_response_test_create_response (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPResponse* result = NULL;
	RygelHTTPSeek* seek = NULL;
	gpointer _tmp0_ = NULL;
	RygelHTTPSeek* _tmp1_ = NULL;
	RygelMediaItem* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	RygelHTTPGet* request = NULL;
	RygelHTTPServer* _tmp13_ = NULL;
	GUPnPContext* _tmp14_ = NULL;
	SoupServer* _tmp15_ = NULL;
	SoupServer* _tmp16_ = NULL;
	SoupMessage* _tmp17_ = NULL;
	RygelMediaItem* _tmp18_ = NULL;
	RygelHTTPSeek* _tmp19_ = NULL;
	GCancellable* _tmp20_ = NULL;
	RygelHTTPGet* _tmp21_ = NULL;
	RygelHTTPGetHandler* handler = NULL;
	GCancellable* _tmp22_ = NULL;
	RygelHTTPGetHandler* _tmp23_ = NULL;
	RygelDataSource* src = NULL;
	RygelMediaItem* _tmp24_ = NULL;
	RygelDataSource* _tmp25_ = NULL;
	RygelHTTPResponse* _tmp26_ = NULL;
	RygelHTTPResponse* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 111 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = NULL;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_HTTP_SEEK) ? ((RygelHTTPSeek*) _tmp0_) : NULL);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	seek = _tmp1_;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = self->priv->item;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = rygel_media_item_is_live_stream (_tmp2_);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (!_tmp3_) {
#line 1034 "rygel-http-response-test.c"
		RygelMediaItem* _tmp4_ = NULL;
		gint64 _tmp5_ = 0LL;
		gint64 _tmp6_ = 0LL;
		RygelHTTPByteSeek* _tmp7_ = NULL;
		SoupMessage* _tmp8_ = NULL;
		SoupMessageHeaders* _tmp9_ = NULL;
		RygelHTTPSeek* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		gint64 _tmp12_ = 0LL;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp4_ = self->priv->item;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp5_ = rygel_media_item_get_size (_tmp4_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp6_ = _tmp5_;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp7_ = rygel_http_byte_seek_new ((gint64) 0, (gint64) (RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES - 1), _tmp6_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (seek);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		seek = (RygelHTTPSeek*) _tmp7_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp8_ = msg;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp9_ = _tmp8_->response_headers;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp10_ = seek;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp11_ = rygel_http_seek_get_length (_tmp10_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp12_ = _tmp11_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		soup_message_headers_set_content_length (_tmp9_, _tmp12_);
#line 1068 "rygel-http-response-test.c"
	}
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp13_ = self->server;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp14_ = _tmp13_->context;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp15_ = gupnp_context_get_server (_tmp14_);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp16_ = _tmp15_;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp17_ = msg;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp18_ = self->priv->item;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp19_ = seek;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp20_ = self->cancellable;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp21_ = rygel_http_get_new (_tmp16_, _tmp17_, _tmp18_, _tmp19_, _tmp20_);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	request = _tmp21_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp22_ = self->cancellable;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp23_ = rygel_http_get_handler_new (_tmp22_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	handler = _tmp23_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp24_ = self->priv->item;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp25_ = rygel_media_item_create_stream_source (_tmp24_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	src = _tmp25_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp27_ = rygel_http_response_new (request, handler, src, &_inner_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp26_ = _tmp27_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_propagate_error (error, _inner_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (src);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (handler);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (request);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (seek);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return NULL;
#line 1120 "rygel-http-response-test.c"
	}
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp26_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (src);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (handler);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (request);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (seek);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 1134 "rygel-http-response-test.c"
}


static void rygel_http_response_test_on_client_completed (RygelHTTPResponseTest* self, RygelStateMachine* client) {
	gboolean _tmp0_ = FALSE;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (client != NULL);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->server_done;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp0_) {
#line 1148 "rygel-http-response-test.c"
		GMainLoop* _tmp1_ = NULL;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp1_ = self->priv->main_loop;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_main_loop_quit (_tmp1_);
#line 1154 "rygel-http-response-test.c"
	}
#line 135 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->client_done = TRUE;
#line 1158 "rygel-http-response-test.c"
}


static void rygel_http_response_test_on_response_completed (RygelHTTPResponseTest* self, RygelStateMachine* response) {
	gboolean _tmp0_ = FALSE;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (response != NULL);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->client_done;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp0_) {
#line 1172 "rygel-http-response-test.c"
		GMainLoop* _tmp1_ = NULL;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp1_ = self->priv->main_loop;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_main_loop_quit (_tmp1_);
#line 1178 "rygel-http-response-test.c"
	}
#line 143 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->server_done = TRUE;
#line 1182 "rygel-http-response-test.c"
}


static void _rygel_http_response_test_on_response_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 153 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_response_test_on_response_completed (self, _sender);
#line 1189 "rygel-http-response-test.c"
}


static void rygel_http_response_test_on_message_received (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	GError * _inner_error_ = NULL;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (server != NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 1201 "rygel-http-response-test.c"
	{
		RygelHTTPResponse* response = NULL;
		SoupMessage* _tmp0_ = NULL;
		RygelHTTPResponse* _tmp1_ = NULL;
		RygelHTTPResponse* _tmp2_ = NULL;
		RygelHTTPResponse* _tmp3_ = NULL;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp0_ = msg;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp1_ = rygel_http_response_test_create_response (self, _tmp0_, &_inner_error_);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		response = _tmp1_;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 1216 "rygel-http-response-test.c"
			goto __catch1_g_error;
		}
#line 151 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp2_ = response;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_state_machine_run ((RygelStateMachine*) _tmp2_, NULL, NULL);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp3_ = response;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_signal_connect_object ((RygelStateMachine*) _tmp3_, "completed", (GCallback) _rygel_http_response_test_on_response_completed_rygel_state_machine_completed, self, 0);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (response);
#line 1229 "rygel-http-response-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		GMainLoop* _tmp6_ = NULL;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_error_ = _inner_error_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = NULL;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp4_ = _error_;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (self->priv->error);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		self->priv->error = _tmp5_;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp6_ = self->priv->main_loop;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_main_loop_quit (_tmp6_);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (_error_);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return;
#line 1258 "rygel-http-response-test.c"
	}
	__finally1:
#line 148 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 148 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_clear_error (&_inner_error_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return;
#line 1269 "rygel-http-response-test.c"
	}
}


static void rygel_http_response_test_on_message_aborted (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	GCancellable* _tmp0_ = NULL;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (server != NULL);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->cancellable;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_cancellable_cancel (_tmp0_);
#line 1286 "rygel-http-response-test.c"
}


static gboolean rygel_http_response_test_on_timeout (RygelHTTPResponseTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
#line 168 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_error_free0 (self->priv->error);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->error = _tmp0_;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = self->priv->main_loop;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_main_loop_quit (_tmp1_);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = FALSE;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 1310 "rygel-http-response-test.c"
}


static void rygel_http_response_test_class_init (RygelHTTPResponseTestClass * klass) {
#line 35 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_response_test_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPResponseTestPrivate));
#line 35 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	RYGEL_HTTP_RESPONSE_TEST_CLASS (klass)->run = rygel_http_response_test_real_run;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_test_finalize;
#line 1323 "rygel-http-response-test.c"
}


static void rygel_http_response_test_instance_init (RygelHTTPResponseTest * self) {
#line 35 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv = RYGEL_HTTP_RESPONSE_TEST_GET_PRIVATE (self);
#line 1330 "rygel-http-response-test.c"
}


static void rygel_http_response_test_finalize (GObject* obj) {
	RygelHTTPResponseTest * self;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTest);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->server);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->client);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_rygel_media_item_unref0 (self->priv->item);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 48 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_error_free0 (self->priv->error);
#line 35 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_response_test_parent_class)->finalize (obj);
#line 1352 "rygel-http-response-test.c"
}


GType rygel_http_response_test_get_type (void) {
	static volatile gsize rygel_http_response_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponseTest), 0, (GInstanceInitFunc) rygel_http_response_test_instance_init, NULL };
		GType rygel_http_response_test_type_id;
		rygel_http_response_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponseTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_response_test_type_id__volatile, rygel_http_response_test_type_id);
	}
	return rygel_http_response_test_type_id__volatile;
}


static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 202 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_server_server_cb (self, server, msg, path, query, client);
#line 1371 "rygel-http-response-test.c"
}


static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 203 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_server_on_request_aborted (self, _sender, msg, client);
#line 1378 "rygel-http-response-test.c"
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp3_ = NULL;
	GUPnPContext* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GUPnPContext* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	GUPnPContext* _tmp10_ = NULL;
	SoupServer* _tmp11_ = NULL;
	SoupServer* _tmp12_ = NULL;
	GUPnPContext* _tmp13_ = NULL;
	SoupServer* _tmp14_ = NULL;
	SoupServer* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 1400 "rygel-http-response-test.c"
	{
		GUPnPContext* _tmp0_ = NULL;
		GUPnPContext* _tmp1_ = NULL;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp1_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp0_ = _tmp1_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 1410 "rygel-http-response-test.c"
			goto __catch2_g_error;
		}
#line 193 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (self->context);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		self->context = _tmp0_;
#line 1417 "rygel-http-response-test.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_ = NULL;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_error_ = _inner_error_;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = NULL;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = _tmp2_;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (_error_);
#line 1434 "rygel-http-response-test.c"
		goto __finally2;
	}
	__finally2:
#line 192 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 192 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 192 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			_g_object_unref0 (self);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			return NULL;
#line 1448 "rygel-http-response-test.c"
		} else {
#line 192 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			g_clear_error (&_inner_error_);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			return NULL;
#line 1456 "rygel-http-response-test.c"
		}
	}
#line 198 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = self->context;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_vala_assert (_tmp3_ != NULL, "this.context != null");
#line 199 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = self->context;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp4_);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = _tmp5_;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_vala_assert (_tmp6_ != NULL, "this.context.host_ip != null");
#line 200 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp7_ = self->context;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp9_ = _tmp8_;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_vala_assert (_tmp9_ > ((guint) 0), "this.context.port > 0");
#line 202 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp10_ = self->context;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp11_ = gupnp_context_get_server (_tmp10_);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp12_ = _tmp11_;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_server_add_handler (_tmp12_, RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp13_ = self->context;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp14_ = gupnp_context_get_server (_tmp13_);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp15_ = _tmp14_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_connect_object (_tmp15_, "request-aborted", (GCallback) _rygel_http_server_on_request_aborted_soup_server_request_aborted, self, 0);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 1497 "rygel-http-response-test.c"
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 191 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 1504 "rygel-http-response-test.c"
}


static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client) {
	GUPnPContext* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	SoupServer* _tmp2_ = NULL;
	SoupMessage* _tmp3_ = NULL;
	SoupMessage* _tmp4_ = NULL;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (server != NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (path != NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (client != NULL);
#line 211 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->context;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = gupnp_context_get_server (_tmp0_);
#line 211 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = _tmp1_;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = msg;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_server_pause_message (_tmp2_, _tmp3_);
#line 212 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = msg;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_emit_by_name (self, "message-received", _tmp4_);
#line 1538 "rygel-http-response-test.c"
}


static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
	SoupMessage* _tmp0_ = NULL;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (server != NULL);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (message != NULL);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (client != NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = message;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_emit_by_name (self, "message-aborted", _tmp0_);
#line 1556 "rygel-http-response-test.c"
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	GUPnPContext* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GUPnPContext* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->context;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp0_);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = _tmp1_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = g_strconcat ("http://", _tmp2_, NULL);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = _tmp3_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = g_strconcat (_tmp4_, ":", NULL);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = _tmp5_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp7_ = self->context;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp9_ = _tmp8_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp10_ = g_strdup_printf ("%u", _tmp9_);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp11_ = _tmp10_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp12_ = g_strconcat (_tmp6_, _tmp11_, NULL);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp13_ = _tmp12_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp14_ = g_strconcat (_tmp13_, RYGEL_HTTP_SERVER_SERVER_PATH, NULL);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp15_ = _tmp14_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_free0 (_tmp13_);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_free0 (_tmp11_);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_free0 (_tmp6_);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_free0 (_tmp4_);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp15_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 1624 "rygel-http-response-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_new ("message_aborted", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
#line 1641 "rygel-http-response-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->context);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 1657 "rygel-http-response-test.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (property_id) {
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SERVER_URI:
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_take_string (value, rygel_http_server_get_uri (self));
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 1684 "rygel-http-response-test.c"
		default:
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 1690 "rygel-http-response-test.c"
	}
}


static void _rygel_http_client_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
#line 242 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_client_on_cancelled (self, _sender);
#line 1698 "rygel-http-response-test.c"
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
	gsize _tmp2_ = 0UL;
	const gchar* _tmp3_ = NULL;
	SoupMessage* _tmp4_ = NULL;
	SoupMessage* _tmp5_ = NULL;
	SoupMessage* _tmp6_ = NULL;
	SoupMessageBody* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 229 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 229 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 233 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = context;
#line 233 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 233 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->context);
#line 233 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->context = _tmp1_;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = total_bytes;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->total_bytes = _tmp2_;
#line 236 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = uri;
#line 236 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = soup_message_new ("HTTP", _tmp3_);
#line 236 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->msg);
#line 236 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->msg = _tmp4_;
#line 237 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = self->msg;
#line 237 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_vala_assert (_tmp5_ != NULL, "this.msg != null");
#line 238 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = self->msg;
#line 238 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp7_ = _tmp6_->response_body;
#line 238 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_message_body_set_accumulate (_tmp7_, FALSE);
#line 240 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp8_ = active;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp8_) {
#line 1753 "rygel-http-response-test.c"
		GCancellable* _tmp9_ = NULL;
		GCancellable* _tmp10_ = NULL;
		GCancellable* _tmp11_ = NULL;
		GCancellable* _tmp12_ = NULL;
#line 241 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp9_ = g_cancellable_new ();
#line 241 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp10_ = _tmp9_;
#line 241 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp10_);
#line 241 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (_tmp10_);
#line 242 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp11_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 242 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp12_ = _tmp11_;
#line 242 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_signal_connect_object (_tmp12_, "cancelled", (GCallback) _rygel_http_client_on_cancelled_g_cancellable_cancelled, self, 0);
#line 1772 "rygel-http-response-test.c"
	}
#line 229 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 1776 "rygel-http-response-test.c"
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active) {
#line 229 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context, uri, total_bytes, active);
#line 1783 "rygel-http-response-test.c"
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* _data_;
	_data_ = _data;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (_data_->self);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_slice_free (RygelHttpClientRunData, _data_);
#line 1794 "rygel-http-response-test.c"
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	RygelHTTPClient* _tmp0_ = NULL;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPClient*) base;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_ = g_slice_new0 (RygelHttpClientRunData);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->self = _tmp0_;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_client_real_run_co (_data_);
#line 1816 "rygel-http-response-test.c"
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1824 "rygel-http-response-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return _data1_;
#line 1833 "rygel-http-response-test.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1842 "rygel-http-response-test.c"
		RygelHTTPClient * self;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		self = _data1_->self;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_data1_->run_continue = NULL;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_data1_->run_continue_target = NULL;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_data1_->run_continue_target_destroy_notify = NULL;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (self);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 1858 "rygel-http-response-test.c"
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 1868 "rygel-http-response-test.c"
}


static void __lambda2_ (Block1Data* _data1_, SoupMessage* msg, SoupBuffer* chunk) {
	RygelHTTPClient * self;
	SoupBuffer* _tmp0_ = NULL;
	gsize _tmp1_ = 0UL;
	gboolean _tmp2_ = FALSE;
	gsize _tmp3_ = 0UL;
	gboolean _tmp6_ = FALSE;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = _data1_->self;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (chunk != NULL);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = chunk;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _tmp0_->length;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data1_->bytes_received = _data1_->bytes_received + _tmp1_;
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = self->total_bytes;
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_data1_->bytes_received >= _tmp3_) {
#line 1895 "rygel-http-response-test.c"
		GCancellable* _tmp4_ = NULL;
		GCancellable* _tmp5_ = NULL;
#line 254 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp4_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 254 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp5_ = _tmp4_;
#line 254 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp2_ = _tmp5_ != NULL;
#line 1904 "rygel-http-response-test.c"
	} else {
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp2_ = FALSE;
#line 1908 "rygel-http-response-test.c"
	}
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = _tmp2_;
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp6_) {
#line 1914 "rygel-http-response-test.c"
		GCancellable* _tmp7_ = NULL;
		GCancellable* _tmp8_ = NULL;
#line 256 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp7_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 256 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp8_ = _tmp7_;
#line 256 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_cancellable_cancel (_tmp8_);
#line 1923 "rygel-http-response-test.c"
	}
}


static void ___lambda2__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	__lambda2_ (self, _sender, chunk);
#line 1931 "rygel-http-response-test.c"
}


static void __lambda3_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg) {
	RygelHTTPClient * self;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = _data1_->self;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (session != NULL);
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 261 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 261 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = _tmp1_;
#line 261 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp2_ != NULL) {
#line 261 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp0_ = TRUE;
#line 1955 "rygel-http-response-test.c"
	} else {
		gsize _tmp3_ = 0UL;
#line 261 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp3_ = self->total_bytes;
#line 261 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp0_ = _data1_->bytes_received == _tmp3_;
#line 1962 "rygel-http-response-test.c"
	}
#line 261 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = _tmp0_;
#line 261 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_vala_assert (_tmp4_, "cancellable != null || bytes_received == this.total_bytes");
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data1_->run_continue (_data1_->run_continue_target);
#line 1970 "rygel-http-response-test.c"
}


static void ___lambda3__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	__lambda3_ (self, session, msg);
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	block1_data_unref (self);
#line 1979 "rygel-http-response-test.c"
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_) {
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (_data_->_state_) {
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case 0:
#line 1988 "rygel-http-response-test.c"
		goto _state_0;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case 1:
#line 1992 "rygel-http-response-test.c"
		goto _state_1;
		default:
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_assert_not_reached ();
#line 1997 "rygel-http-response-test.c"
	}
	_state_0:
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->run_continue_target = _data_;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->run_continue_target_destroy_notify = NULL;
#line 248 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->bytes_received = (gsize) 0;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp0_ = NULL;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp0_ = _data_->self->msg;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_connect_data (_data_->_tmp0_, "got-chunk", (GCallback) ___lambda2__soup_message_got_chunk, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp1_ = NULL;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp1_ = _data_->self->context;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp2_ = NULL;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp2_ = gupnp_context_get_session (_data_->_tmp1_);
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp3_ = NULL;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp4_ = NULL;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp4_ = _data_->self->msg;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp5_ = NULL;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
#line 260 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_session_queue_message (_data_->_tmp3_, _data_->_tmp5_, ___lambda3__soup_session_callback, block1_data_ref (_data_->_data1_));
#line 266 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_state_ = 1;
#line 266 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return FALSE;
#line 2048 "rygel-http-response-test.c"
	_state_1:
	;
#line 268 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	block1_data_unref (_data_->_data1_);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_ = NULL;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_data_->_state_ == 0) {
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2061 "rygel-http-response-test.c"
	} else {
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2065 "rygel-http-response-test.c"
	}
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_unref (_data_->_async_result);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return FALSE;
#line 2071 "rygel-http-response-test.c"
}


static void rygel_http_client_on_cancelled (RygelHTTPClient* self, GCancellable* cancellable) {
	GUPnPContext* _tmp0_ = NULL;
	SoupSession* _tmp1_ = NULL;
	SoupSession* _tmp2_ = NULL;
	SoupMessage* _tmp3_ = NULL;
#line 271 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 271 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (cancellable != NULL);
#line 272 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->context;
#line 272 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = gupnp_context_get_session (_tmp0_);
#line 272 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = _tmp1_;
#line 272 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = self->msg;
#line 272 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_session_cancel_message (_tmp2_, _tmp3_, (guint) SOUP_STATUS_CANCELLED);
#line 274 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 2096 "rygel-http-response-test.c"
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	GCancellable* _tmp0_ = NULL;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPClient*) base;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2112 "rygel-http-response-test.c"
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPClient*) base;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = value;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 2132 "rygel-http-response-test.c"
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2149 "rygel-http-response-test.c"
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->run_finish = rygel_http_client_real_run_finish;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
#line 2164 "rygel-http-response-test.c"
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
#line 2171 "rygel-http-response-test.c"
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->context);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->msg);
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
#line 2187 "rygel-http-response-test.c"
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (property_id) {
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2216 "rygel-http-response-test.c"
		default:
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2222 "rygel-http-response-test.c"
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (property_id) {
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2238 "rygel-http-response-test.c"
		default:
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2244 "rygel-http-response-test.c"
	}
}


RygelHTTPSeek* rygel_http_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length) {
	RygelHTTPSeek * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPSeek*) g_object_new (object_type, NULL);
#line 285 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = start;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_seek_set_start (self, _tmp0_);
#line 286 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = stop;
#line 286 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_seek_set_stop (self, _tmp1_);
#line 287 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = total_length;
#line 287 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_seek_set_total_length (self, _tmp2_);
#line 289 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = stop;
#line 289 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = start;
#line 289 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_seek_set_length (self, (_tmp3_ - _tmp4_) + 1);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2278 "rygel-http-response-test.c"
}


RygelHTTPSeek* rygel_http_seek_new (gint64 start, gint64 stop, gint64 total_length) {
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_seek_construct (RYGEL_TYPE_HTTP_SEEK, start, stop, total_length);
#line 2285 "rygel-http-response-test.c"
}


gint64 rygel_http_seek_get_start (RygelHTTPSeek* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 279 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 279 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->_start;
#line 279 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 279 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2300 "rygel-http-response-test.c"
}


static void rygel_http_seek_set_start (RygelHTTPSeek* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 279 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 279 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = value;
#line 279 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->_start = _tmp0_;
#line 279 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_notify ((GObject *) self, "start");
#line 2314 "rygel-http-response-test.c"
}


gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 280 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 280 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->_stop;
#line 280 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 280 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2329 "rygel-http-response-test.c"
}


static void rygel_http_seek_set_stop (RygelHTTPSeek* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 280 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 280 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = value;
#line 280 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->_stop = _tmp0_;
#line 280 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_notify ((GObject *) self, "stop");
#line 2343 "rygel-http-response-test.c"
}


gint64 rygel_http_seek_get_length (RygelHTTPSeek* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->_length;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2358 "rygel-http-response-test.c"
}


static void rygel_http_seek_set_length (RygelHTTPSeek* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = value;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->_length = _tmp0_;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_notify ((GObject *) self, "length");
#line 2372 "rygel-http-response-test.c"
}


gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->_total_length;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2387 "rygel-http-response-test.c"
}


static void rygel_http_seek_set_total_length (RygelHTTPSeek* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = value;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->_total_length = _tmp0_;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_notify ((GObject *) self, "total-length");
#line 2401 "rygel-http-response-test.c"
}


static void rygel_http_seek_class_init (RygelHTTPSeekClass * klass) {
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_seek_parent_class = g_type_class_peek_parent (klass);
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPSeekPrivate));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_seek_get_property;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_seek_set_property;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_seek_finalize;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_START, g_param_spec_int64 ("start", "start", "start", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_STOP, g_param_spec_int64 ("stop", "stop", "stop", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_LENGTH, g_param_spec_int64 ("length", "length", "length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_TOTAL_LENGTH, g_param_spec_int64 ("total-length", "total-length", "total-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2424 "rygel-http-response-test.c"
}


static void rygel_http_seek_instance_init (RygelHTTPSeek * self) {
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv = RYGEL_HTTP_SEEK_GET_PRIVATE (self);
#line 2431 "rygel-http-response-test.c"
}


static void rygel_http_seek_finalize (GObject* obj) {
	RygelHTTPSeek * self;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek);
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_seek_parent_class)->finalize (obj);
#line 2441 "rygel-http-response-test.c"
}


GType rygel_http_seek_get_type (void) {
	static volatile gsize rygel_http_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPSeek), 0, (GInstanceInitFunc) rygel_http_seek_instance_init, NULL };
		GType rygel_http_seek_type_id;
		rygel_http_seek_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_seek_type_id__volatile, rygel_http_seek_type_id);
	}
	return rygel_http_seek_type_id__volatile;
}


static void _vala_rygel_http_seek_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPSeek * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek);
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (property_id) {
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_START:
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_set_int64 (value, rygel_http_seek_get_start (self));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_STOP:
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_set_int64 (value, rygel_http_seek_get_stop (self));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_LENGTH:
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_set_int64 (value, rygel_http_seek_get_length (self));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_TOTAL_LENGTH:
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_set_int64 (value, rygel_http_seek_get_total_length (self));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2486 "rygel-http-response-test.c"
		default:
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2492 "rygel-http-response-test.c"
	}
}


static void _vala_rygel_http_seek_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPSeek * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek);
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (property_id) {
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_START:
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_seek_set_start (self, g_value_get_int64 (value));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_STOP:
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_seek_set_stop (self, g_value_get_int64 (value));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_LENGTH:
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_seek_set_length (self, g_value_get_int64 (value));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_TOTAL_LENGTH:
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_seek_set_total_length (self, g_value_get_int64 (value));
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2526 "rygel-http-response-test.c"
		default:
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 278 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2532 "rygel-http-response-test.c"
	}
}


RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length) {
	RygelHTTPByteSeek * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = start;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = stop;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = total_length;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPByteSeek*) rygel_http_seek_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 294 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2552 "rygel-http-response-test.c"
}


RygelHTTPByteSeek* rygel_http_byte_seek_new (gint64 start, gint64 stop, gint64 total_length) {
#line 294 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_byte_seek_construct (RYGEL_TYPE_HTTP_BYTE_SEEK, start, stop, total_length);
#line 2559 "rygel-http-response-test.c"
}


static void rygel_http_byte_seek_class_init (RygelHTTPByteSeekClass * klass) {
#line 293 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_byte_seek_parent_class = g_type_class_peek_parent (klass);
#line 2566 "rygel-http-response-test.c"
}


static void rygel_http_byte_seek_instance_init (RygelHTTPByteSeek * self) {
}


GType rygel_http_byte_seek_get_type (void) {
	static volatile gsize rygel_http_byte_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeek), 0, (GInstanceInitFunc) rygel_http_byte_seek_instance_init, NULL };
		GType rygel_http_byte_seek_type_id;
		rygel_http_byte_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPByteSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_type_id__volatile, rygel_http_byte_seek_type_id);
	}
	return rygel_http_byte_seek_type_id__volatile;
}


RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length) {
	RygelHTTPTimeSeek * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
#line 301 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = start;
#line 301 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = stop;
#line 301 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = total_length;
#line 301 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPTimeSeek*) rygel_http_seek_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 300 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2601 "rygel-http-response-test.c"
}


RygelHTTPTimeSeek* rygel_http_time_seek_new (gint64 start, gint64 stop, gint64 total_length) {
#line 300 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_time_seek_construct (RYGEL_TYPE_HTTP_TIME_SEEK, start, stop, total_length);
#line 2608 "rygel-http-response-test.c"
}


static void rygel_http_time_seek_class_init (RygelHTTPTimeSeekClass * klass) {
#line 299 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_time_seek_parent_class = g_type_class_peek_parent (klass);
#line 2615 "rygel-http-response-test.c"
}


static void rygel_http_time_seek_instance_init (RygelHTTPTimeSeek * self) {
}


GType rygel_http_time_seek_get_type (void) {
	static volatile gsize rygel_http_time_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeek), 0, (GInstanceInitFunc) rygel_http_time_seek_instance_init, NULL };
		GType rygel_http_time_seek_type_id;
		rygel_http_time_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPTimeSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_type_id__volatile, rygel_http_time_seek_type_id);
	}
	return rygel_http_time_seek_type_id__volatile;
}


static gpointer _rygel_media_item_ref0 (gpointer self) {
#line 322 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self ? rygel_media_item_ref (self) : NULL;
#line 2638 "rygel-http-response-test.c"
}


RygelHTTPGet* rygel_http_get_construct (GType object_type, SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable) {
	RygelHTTPGet * self = NULL;
	SoupServer* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	SoupMessage* _tmp3_ = NULL;
	RygelMediaItem* _tmp4_ = NULL;
	RygelMediaItem* _tmp5_ = NULL;
	RygelHTTPSeek* _tmp6_ = NULL;
	RygelHTTPSeek* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	SoupMessage* _tmp10_ = NULL;
	SoupMessageHeaders* _tmp11_ = NULL;
	SoupMessage* _tmp12_ = NULL;
#line 315 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 315 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 315 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 315 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = server;
#line 320 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->server);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->server = _tmp1_;
#line 321 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = msg;
#line 321 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 321 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->msg);
#line 321 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->msg = _tmp3_;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = item;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = _rygel_media_item_ref0 (_tmp4_);
#line 322 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_rygel_media_item_unref0 (self->item);
#line 322 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->item = _tmp5_;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = seek;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->seek);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->seek = _tmp7_;
#line 324 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp8_ = cancellable;
#line 324 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 324 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 324 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->cancellable = _tmp9_;
#line 325 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp10_ = self->msg;
#line 325 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp11_ = _tmp10_->response_headers;
#line 325 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_message_headers_set_encoding (_tmp11_, SOUP_ENCODING_EOF);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp12_ = self->msg;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_message_set_status (_tmp12_, (guint) SOUP_STATUS_OK);
#line 315 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2717 "rygel-http-response-test.c"
}


RygelHTTPGet* rygel_http_get_new (SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable) {
#line 315 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, server, msg, item, seek, cancellable);
#line 2724 "rygel-http-response-test.c"
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
#line 305 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
#line 305 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
#line 2733 "rygel-http-response-test.c"
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
#line 305 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET, RygelHTTPGet);
#line 306 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->server);
#line 307 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->msg);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 311 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_rygel_media_item_unref0 (self->item);
#line 313 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->seek);
#line 305 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
#line 2757 "rygel-http-response-test.c"
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type, GCancellable* cancellable) {
	RygelHTTPGetHandler * self = NULL;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPGetHandler*) g_object_new (object_type, NULL);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = cancellable;
#line 334 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->cancellable = _tmp1_;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2789 "rygel-http-response-test.c"
}


RygelHTTPGetHandler* rygel_http_get_handler_new (GCancellable* cancellable) {
#line 333 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_get_handler_construct (RYGEL_TYPE_HTTP_GET_HANDLER, cancellable);
#line 2796 "rygel-http-response-test.c"
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
#line 330 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
#line 330 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
#line 2805 "rygel-http-response-test.c"
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
}


static void rygel_http_get_handler_finalize (GObject* obj) {
	RygelHTTPGetHandler * self;
#line 330 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
#line 331 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 330 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_get_handler_parent_class)->finalize (obj);
#line 2821 "rygel-http-response-test.c"
}


GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, NULL };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


RygelTestDataSource* rygel_test_data_source_construct (GType object_type, glong block_size, glong buffers) {
	RygelTestDataSource * self = NULL;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelTestDataSource*) g_object_new (object_type, NULL);
#line 345 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = block_size;
#line 345 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->block_size = _tmp0_;
#line 346 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = buffers;
#line 346 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->buffers = _tmp1_;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->data_sent = (guint64) 0;
#line 344 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2855 "rygel-http-response-test.c"
}


RygelTestDataSource* rygel_test_data_source_new (glong block_size, glong buffers) {
#line 344 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_test_data_source_construct (RYGEL_TYPE_TEST_DATA_SOURCE, block_size, buffers);
#line 2862 "rygel-http-response-test.c"
}


static gboolean __lambda4_ (RygelTestDataSource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint8* data = NULL;
	glong _tmp1_ = 0L;
	guint8* _tmp2_ = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guint64 _tmp3_ = 0ULL;
	glong _tmp4_ = 0L;
	guint64 _tmp5_ = 0ULL;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
#line 352 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->frozen;
#line 352 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp0_) {
#line 353 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		result = FALSE;
#line 353 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return result;
#line 2887 "rygel-http-response-test.c"
	}
#line 356 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = self->priv->block_size;
#line 356 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = g_new0 (guint8, _tmp1_);
#line 356 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	data = _tmp2_;
#line 356 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	data_length1 = _tmp1_;
#line 356 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_size_ = data_length1;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = self->priv->data_sent;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = self->priv->block_size;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->data_sent = _tmp3_ + _tmp4_;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = self->priv->data_sent;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp5_ > ((guint64) RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES)) {
#line 359 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 361 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		result = FALSE;
#line 361 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		data = (g_free (data), NULL);
#line 361 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return result;
#line 2917 "rygel-http-response-test.c"
	}
#line 364 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = data;
#line 364 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6__length1 = data_length1;
#line 364 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_emit_by_name ((RygelDataSource*) self, "data-available", _tmp6_, _tmp6__length1);
#line 366 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = TRUE;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	data = (g_free (data), NULL);
#line 366 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2931 "rygel-http-response-test.c"
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
#line 351 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2940 "rygel-http-response-test.c"
}


static void rygel_test_data_source_real_start (RygelDataSource* base, RygelHTTPSeek* seek, GError** error) {
	RygelTestDataSource * self;
#line 350 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelTestDataSource*) base;
#line 351 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
#line 2950 "rygel-http-response-test.c"
}


static void rygel_test_data_source_real_freeze (RygelDataSource* base) {
	RygelTestDataSource * self;
#line 370 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelTestDataSource*) base;
#line 371 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->frozen = TRUE;
#line 2960 "rygel-http-response-test.c"
}


static void rygel_test_data_source_real_thaw (RygelDataSource* base) {
	RygelTestDataSource * self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 374 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelTestDataSource*) base;
#line 375 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->frozen;
#line 375 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (!_tmp0_) {
#line 376 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return;
#line 2976 "rygel-http-response-test.c"
	}
#line 379 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->frozen = FALSE;
#line 2980 "rygel-http-response-test.c"
	{
#line 382 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_data_source_start ((RygelDataSource*) self, NULL, &_inner_error_);
#line 382 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 2986 "rygel-http-response-test.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
#line 381 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_error_ = _inner_error_;
#line 381 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = NULL;
#line 384 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_assert_not_reached ();
#line 381 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (_error_);
#line 3002 "rygel-http-response-test.c"
	}
	__finally3:
#line 381 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 381 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 381 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_clear_error (&_inner_error_);
#line 381 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return;
#line 3013 "rygel-http-response-test.c"
	}
}


static void rygel_test_data_source_real_stop (RygelDataSource* base) {
	RygelTestDataSource * self;
#line 388 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelTestDataSource*) base;
#line 389 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_data_source_freeze ((RygelDataSource*) self);
#line 3024 "rygel-http-response-test.c"
}


static void rygel_test_data_source_class_init (RygelTestDataSourceClass * klass) {
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_test_data_source_parent_class = g_type_class_peek_parent (klass);
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_class_add_private (klass, sizeof (RygelTestDataSourcePrivate));
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_test_data_source_finalize;
#line 3035 "rygel-http-response-test.c"
}


static void rygel_test_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface) {
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_test_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->start = (void (*)(RygelDataSource*, RygelHTTPSeek*, GError**)) rygel_test_data_source_real_start;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->freeze = (void (*)(RygelDataSource*)) rygel_test_data_source_real_freeze;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->thaw = (void (*)(RygelDataSource*)) rygel_test_data_source_real_thaw;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->stop = (void (*)(RygelDataSource*)) rygel_test_data_source_real_stop;
#line 3050 "rygel-http-response-test.c"
}


static void rygel_test_data_source_instance_init (RygelTestDataSource * self) {
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv = RYGEL_TEST_DATA_SOURCE_GET_PRIVATE (self);
#line 3057 "rygel-http-response-test.c"
}


static void rygel_test_data_source_finalize (GObject* obj) {
	RygelTestDataSource * self;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TEST_DATA_SOURCE, RygelTestDataSource);
#line 338 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_test_data_source_parent_class)->finalize (obj);
#line 3067 "rygel-http-response-test.c"
}


GType rygel_test_data_source_get_type (void) {
	static volatile gsize rygel_test_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_test_data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTestDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_test_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTestDataSource), 0, (GInstanceInitFunc) rygel_test_data_source_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_test_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_test_data_source_type_id;
		rygel_test_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTestDataSource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_test_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_test_data_source_type_id__volatile, rygel_test_data_source_type_id);
	}
	return rygel_test_data_source_type_id__volatile;
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem* self = NULL;
	RygelTestDataSource* _tmp0_ = NULL;
#line 406 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelMediaItem*) g_type_create_instance (object_type);
#line 407 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = rygel_test_data_source_new (RYGEL_MEDIA_ITEM_BLOCK_SIZE, RYGEL_MEDIA_ITEM_MAX_BUFFERS);
#line 407 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->priv->src);
#line 407 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->src = (RygelDataSource*) _tmp0_;
#line 408 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->is_live = TRUE;
#line 406 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 3100 "rygel-http-response-test.c"
}


RygelMediaItem* rygel_media_item_new (void) {
#line 406 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
#line 3107 "rygel-http-response-test.c"
}


RygelMediaItem* rygel_media_item_construct_fixed_size (GType object_type) {
	RygelMediaItem* self = NULL;
#line 412 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelMediaItem*) rygel_media_item_construct (object_type);
#line 411 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 3117 "rygel-http-response-test.c"
}


RygelMediaItem* rygel_media_item_new_fixed_size (void) {
#line 411 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_media_item_construct_fixed_size (RYGEL_TYPE_MEDIA_ITEM);
#line 3124 "rygel-http-response-test.c"
}


RygelDataSource* rygel_media_item_create_stream_source (RygelMediaItem* self) {
	RygelDataSource* result = NULL;
	RygelDataSource* _tmp0_ = NULL;
	RygelDataSource* _tmp1_ = NULL;
#line 415 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 416 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->src;
#line 416 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 416 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp1_;
#line 416 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 3142 "rygel-http-response-test.c"
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 419 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 420 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->is_live;
#line 420 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 420 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 3157 "rygel-http-response-test.c"
}


gint64 rygel_media_item_get_size (RygelMediaItem* self) {
	gint64 result;
#line 398 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 399 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = (gint64) (RYGEL_MEDIA_ITEM_MAX_BUFFERS * RYGEL_MEDIA_ITEM_BLOCK_SIZE);
#line 399 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 3169 "rygel-http-response-test.c"
}


static void rygel_value_media_item_init (GValue* value) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	value->data[0].v_pointer = NULL;
#line 3176 "rygel-http-response-test.c"
}


static void rygel_value_media_item_free_value (GValue* value) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (value->data[0].v_pointer) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_media_item_unref (value->data[0].v_pointer);
#line 3185 "rygel-http-response-test.c"
	}
}


static void rygel_value_media_item_copy_value (const GValue* src_value, GValue* dest_value) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (src_value->data[0].v_pointer) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		dest_value->data[0].v_pointer = rygel_media_item_ref (src_value->data[0].v_pointer);
#line 3195 "rygel-http-response-test.c"
	} else {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3199 "rygel-http-response-test.c"
	}
}


static gpointer rygel_value_media_item_peek_pointer (const GValue* value) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return value->data[0].v_pointer;
#line 3207 "rygel-http-response-test.c"
}


static gchar* rygel_value_media_item_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (collect_values[0].v_pointer) {
#line 3214 "rygel-http-response-test.c"
		RygelMediaItem* object;
		object = collect_values[0].v_pointer;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3221 "rygel-http-response-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3225 "rygel-http-response-test.c"
		}
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = rygel_media_item_ref (object);
#line 3229 "rygel-http-response-test.c"
	} else {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = NULL;
#line 3233 "rygel-http-response-test.c"
	}
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return NULL;
#line 3237 "rygel-http-response-test.c"
}


static gchar* rygel_value_media_item_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaItem** object_p;
	object_p = collect_values[0].v_pointer;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (!object_p) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3248 "rygel-http-response-test.c"
	}
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (!value->data[0].v_pointer) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		*object_p = NULL;
#line 3254 "rygel-http-response-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		*object_p = value->data[0].v_pointer;
#line 3258 "rygel-http-response-test.c"
	} else {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		*object_p = rygel_media_item_ref (value->data[0].v_pointer);
#line 3262 "rygel-http-response-test.c"
	}
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return NULL;
#line 3266 "rygel-http-response-test.c"
}


GParamSpec* rygel_param_spec_media_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaItem* spec;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_ITEM), NULL);
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return G_PARAM_SPEC (spec);
#line 3280 "rygel-http-response-test.c"
}


gpointer rygel_value_get_media_item (const GValue* value) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_ITEM), NULL);
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return value->data[0].v_pointer;
#line 3289 "rygel-http-response-test.c"
}


void rygel_value_set_media_item (GValue* value, gpointer v_object) {
	RygelMediaItem* old;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_ITEM));
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	old = value->data[0].v_pointer;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (v_object) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_ITEM));
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = v_object;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_media_item_ref (value->data[0].v_pointer);
#line 3309 "rygel-http-response-test.c"
	} else {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = NULL;
#line 3313 "rygel-http-response-test.c"
	}
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (old) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_media_item_unref (old);
#line 3319 "rygel-http-response-test.c"
	}
}


void rygel_value_take_media_item (GValue* value, gpointer v_object) {
	RygelMediaItem* old;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_ITEM));
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	old = value->data[0].v_pointer;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (v_object) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_ITEM));
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = v_object;
#line 3338 "rygel-http-response-test.c"
	} else {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = NULL;
#line 3342 "rygel-http-response-test.c"
	}
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (old) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_media_item_unref (old);
#line 3348 "rygel-http-response-test.c"
	}
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaItemPrivate));
#line 3360 "rygel-http-response-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv = RYGEL_MEDIA_ITEM_GET_PRIVATE (self);
#line 404 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->is_live = FALSE;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->ref_count = 1;
#line 3371 "rygel-http-response-test.c"
}


static void rygel_media_item_finalize (RygelMediaItem* obj) {
	RygelMediaItem * self;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 403 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->priv->src);
#line 3381 "rygel-http-response-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_item_init, rygel_value_media_item_free_value, rygel_value_media_item_copy_value, rygel_value_media_item_peek_pointer, "p", rygel_value_media_item_collect_value, "p", rygel_value_media_item_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


gpointer rygel_media_item_ref (gpointer instance) {
	RygelMediaItem* self;
	self = instance;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return instance;
#line 3406 "rygel-http-response-test.c"
}


void rygel_media_item_unref (gpointer instance) {
	RygelMediaItem* self;
	self = instance;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		RYGEL_MEDIA_ITEM_GET_CLASS (self)->finalize (self);
#line 393 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3419 "rygel-http-response-test.c"
	}
}



