/* rygel-http-byte-seek.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-byte-seek.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
typedef struct _RygelHTTPByteSeekPrivate RygelHTTPByteSeekPrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK_TYPE (rygel_http_seek_type_get_type ())

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPSeek* self);
};

struct _RygelHTTPByteSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPByteSeekPrivate * priv;
};

struct _RygelHTTPByteSeekClass {
	RygelHTTPSeekClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaObject* object;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPIdentityHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
	gint64 size;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gint64 size;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gint64 size;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_TYPE_BYTE,
	RYGEL_HTTP_SEEK_TYPE_TIME
} RygelHTTPSeekType;


static gpointer rygel_http_byte_seek_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_BYTE_SEEK_DUMMY_PROPERTY
};
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 step, gint64 total_length, GError** error);
GType rygel_http_seek_type_get_type (void) G_GNUC_CONST;
void rygel_http_seek_set_seek_type (RygelHTTPSeek* self, RygelHTTPSeekType value);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
RygelClientHacks* rygel_client_hacks_create (SoupMessage* msg, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
static void rygel_http_byte_seek_real_add_response_headers (RygelHTTPSeek* base);
SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);


RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPByteSeek * self = NULL;
	SoupRange* ranges = NULL;
	gint ranges_length1 = 0;
	gint _ranges_size_ = 0;
	gint64 start = 0LL;
	gint64 total_length = 0LL;
	const gchar* range = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelHTTPGet* _tmp4_ = NULL;
	RygelThumbnail* _tmp5_ = NULL;
	gint64 stop = 0LL;
	gint64 _tmp17_ = 0LL;
	const gchar* _tmp18_ = NULL;
	RygelHTTPGet* _tmp40_ = NULL;
	SoupMessage* _tmp41_ = NULL;
	gint64 _tmp42_ = 0LL;
	gint64 _tmp43_ = 0LL;
	gint64 _tmp44_ = 0LL;
	GError * _inner_error_ = NULL;
#line 27 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	start = (gint64) 0;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp0_ = request;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp1_ = _tmp0_->msg;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	range = _tmp3_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp4_ = request;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp5_ = _tmp4_->thumbnail;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	if (_tmp5_ != NULL) {
#line 299 "rygel-http-byte-seek.c"
		RygelHTTPGet* _tmp6_ = NULL;
		RygelThumbnail* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp6_ = request;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp7_ = _tmp6_->thumbnail;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp8_ = _tmp7_->size;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		total_length = _tmp8_;
#line 311 "rygel-http-byte-seek.c"
	} else {
		RygelHTTPGet* _tmp9_ = NULL;
		RygelSubtitle* _tmp10_ = NULL;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp9_ = request;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp10_ = _tmp9_->subtitle;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		if (_tmp10_ != NULL) {
#line 321 "rygel-http-byte-seek.c"
			RygelHTTPGet* _tmp11_ = NULL;
			RygelSubtitle* _tmp12_ = NULL;
			gint64 _tmp13_ = 0LL;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp11_ = request;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp12_ = _tmp11_->subtitle;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp13_ = _tmp12_->size;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			total_length = _tmp13_;
#line 333 "rygel-http-byte-seek.c"
		} else {
			RygelHTTPGet* _tmp14_ = NULL;
			RygelMediaObject* _tmp15_ = NULL;
			gint64 _tmp16_ = 0LL;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp14_ = request;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp15_ = _tmp14_->object;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp16_ = ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp15_) : NULL))->size;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			total_length = _tmp16_;
#line 346 "rygel-http-byte-seek.c"
		}
	}
#line 39 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp17_ = total_length;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	stop = _tmp17_ - 1;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp18_ = range;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	if (_tmp18_ != NULL) {
#line 357 "rygel-http-byte-seek.c"
		RygelHTTPGet* _tmp19_ = NULL;
		SoupMessage* _tmp20_ = NULL;
		SoupMessageHeaders* _tmp21_ = NULL;
		gint64 _tmp22_ = 0LL;
		SoupRange* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gboolean _tmp25_ = FALSE;
		gint64 _tmp35_ = 0LL;
		gint64 _tmp36_ = 0LL;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp19_ = request;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp20_ = _tmp19_->msg;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp21_ = _tmp20_->request_headers;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp22_ = total_length;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp25_ = soup_message_headers_get_ranges (_tmp21_, _tmp22_, (SoupRange**) (&_tmp23_), &_tmp24_);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		ranges = (g_free (ranges), NULL);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		ranges = _tmp23_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		ranges_length1 = _tmp24_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_ranges_size_ = ranges_length1;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		if (_tmp25_) {
#line 387 "rygel-http-byte-seek.c"
			SoupRange* _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			SoupRange _tmp27_ = {0};
			gint64 _tmp28_ = 0LL;
			SoupRange* _tmp29_ = NULL;
			gint _tmp29__length1 = 0;
			SoupRange _tmp30_ = {0};
			gint64 _tmp31_ = 0LL;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp26_ = ranges;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp26__length1 = ranges_length1;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp27_ = _tmp26_[0];
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp28_ = _tmp27_.start;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			start = _tmp28_;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp29_ = ranges;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp29__length1 = ranges_length1;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp30_ = _tmp29_[0];
#line 46 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp31_ = _tmp30_.end;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			stop = _tmp31_;
#line 416 "rygel-http-byte-seek.c"
		} else {
			const gchar* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			GError* _tmp34_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp32_ = _ ("Invalid Range '%s'");
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp33_ = range;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp34_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp32_, _tmp33_);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_inner_error_ = _tmp34_;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				g_propagate_error (error, _inner_error_);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				ranges = (g_free (ranges), NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_g_object_unref0 (self);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				return NULL;
#line 439 "rygel-http-byte-seek.c"
			} else {
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				ranges = (g_free (ranges), NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				g_clear_error (&_inner_error_);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				return NULL;
#line 449 "rygel-http-byte-seek.c"
			}
		}
#line 53 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp35_ = start;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp36_ = stop;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		if (_tmp35_ > _tmp36_) {
#line 458 "rygel-http-byte-seek.c"
			const gchar* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			GError* _tmp39_ = NULL;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp37_ = _ ("Invalid Range '%s'");
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp38_ = range;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp39_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp37_, _tmp38_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_inner_error_ = _tmp39_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				g_propagate_error (error, _inner_error_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				ranges = (g_free (ranges), NULL);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_g_object_unref0 (self);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				return NULL;
#line 480 "rygel-http-byte-seek.c"
			} else {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				ranges = (g_free (ranges), NULL);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				g_clear_error (&_inner_error_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				return NULL;
#line 490 "rygel-http-byte-seek.c"
			}
		}
	}
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp40_ = request;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp41_ = _tmp40_->msg;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp42_ = start;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp43_ = stop;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp44_ = total_length;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	self = (RygelHTTPByteSeek*) rygel_http_seek_construct (object_type, _tmp41_, _tmp42_, _tmp43_, (gint64) 1, _tmp44_, &_inner_error_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	if (_inner_error_ != NULL) {
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			g_propagate_error (error, _inner_error_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			ranges = (g_free (ranges), NULL);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_g_object_unref0 (self);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			return NULL;
#line 518 "rygel-http-byte-seek.c"
		} else {
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			ranges = (g_free (ranges), NULL);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			g_clear_error (&_inner_error_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			return NULL;
#line 528 "rygel-http-byte-seek.c"
		}
	}
#line 60 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	rygel_http_seek_set_seek_type ((RygelHTTPSeek*) self, RYGEL_HTTP_SEEK_TYPE_BYTE);
#line 27 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	ranges = (g_free (ranges), NULL);
#line 27 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	return self;
#line 537 "rygel-http-byte-seek.c"
}


RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error) {
#line 27 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	return rygel_http_byte_seek_construct (RYGEL_TYPE_HTTP_BYTE_SEEK, request, error);
#line 544 "rygel-http-byte-seek.c"
}


gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GError * _inner_error_ = NULL;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	force_seek = FALSE;
#line 559 "rygel-http-byte-seek.c"
	{
		RygelClientHacks* hack = NULL;
		RygelHTTPGet* _tmp0_ = NULL;
		SoupMessage* _tmp1_ = NULL;
		RygelClientHacks* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp0_ = request;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp1_ = _tmp0_->msg;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp2_ = rygel_client_hacks_create (_tmp1_, &_inner_error_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		hack = _tmp2_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		if (_inner_error_ != NULL) {
#line 576 "rygel-http-byte-seek.c"
			goto __catch4_g_error;
		}
#line 68 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp3_ = rygel_client_hacks_force_seek (hack);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		force_seek = _tmp3_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_g_object_unref0 (hack);
#line 585 "rygel-http-byte-seek.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_error_ = _inner_error_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_inner_error_ = NULL;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_g_error_free0 (_error_);
#line 597 "rygel-http-byte-seek.c"
	}
	__finally4:
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	if (_inner_error_ != NULL) {
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		g_clear_error (&_inner_error_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		return FALSE;
#line 608 "rygel-http-byte-seek.c"
	}
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp5_ = force_seek;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	if (_tmp5_) {
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp4_ = TRUE;
#line 616 "rygel-http-byte-seek.c"
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		RygelHTTPGet* _tmp9_ = NULL;
		RygelMediaObject* _tmp10_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp34_ = FALSE;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp9_ = request;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp10_ = _tmp9_->object;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 632 "rygel-http-byte-seek.c"
			gboolean _tmp11_ = FALSE;
			RygelHTTPGet* _tmp12_ = NULL;
			RygelMediaObject* _tmp13_ = NULL;
			gint64 _tmp14_ = 0LL;
			gboolean _tmp17_ = FALSE;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp12_ = request;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp13_ = _tmp12_->object;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp14_ = ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp13_) : NULL))->size;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			if (_tmp14_ > ((gint64) 0)) {
#line 646 "rygel-http-byte-seek.c"
				RygelHTTPGet* _tmp15_ = NULL;
				RygelHTTPIdentityHandler* _tmp16_ = NULL;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp15_ = request;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp16_ = _tmp15_->handler;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_HTTP_IDENTITY_HANDLER);
#line 655 "rygel-http-byte-seek.c"
			} else {
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp11_ = FALSE;
#line 659 "rygel-http-byte-seek.c"
			}
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp17_ = _tmp11_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp8_ = _tmp17_;
#line 665 "rygel-http-byte-seek.c"
		} else {
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp8_ = FALSE;
#line 669 "rygel-http-byte-seek.c"
		}
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp18_ = _tmp8_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		if (_tmp18_) {
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp7_ = TRUE;
#line 677 "rygel-http-byte-seek.c"
		} else {
			gboolean _tmp19_ = FALSE;
			RygelHTTPGet* _tmp20_ = NULL;
			RygelThumbnail* _tmp21_ = NULL;
			gboolean _tmp25_ = FALSE;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp20_ = request;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp21_ = _tmp20_->thumbnail;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			if (_tmp21_ != NULL) {
#line 689 "rygel-http-byte-seek.c"
				RygelHTTPGet* _tmp22_ = NULL;
				RygelThumbnail* _tmp23_ = NULL;
				gint64 _tmp24_ = 0LL;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp22_ = request;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp23_ = _tmp22_->thumbnail;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp24_ = _tmp23_->size;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp19_ = _tmp24_ > ((gint64) 0);
#line 701 "rygel-http-byte-seek.c"
			} else {
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp19_ = FALSE;
#line 705 "rygel-http-byte-seek.c"
			}
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp25_ = _tmp19_;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp7_ = _tmp25_;
#line 711 "rygel-http-byte-seek.c"
		}
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp26_ = _tmp7_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		if (_tmp26_) {
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp6_ = TRUE;
#line 719 "rygel-http-byte-seek.c"
		} else {
			gboolean _tmp27_ = FALSE;
			RygelHTTPGet* _tmp28_ = NULL;
			RygelSubtitle* _tmp29_ = NULL;
			gboolean _tmp33_ = FALSE;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp28_ = request;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp29_ = _tmp28_->subtitle;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			if (_tmp29_ != NULL) {
#line 731 "rygel-http-byte-seek.c"
				RygelHTTPGet* _tmp30_ = NULL;
				RygelSubtitle* _tmp31_ = NULL;
				gint64 _tmp32_ = 0LL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp30_ = request;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp31_ = _tmp30_->subtitle;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp32_ = _tmp31_->size;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp27_ = _tmp32_ > ((gint64) 0);
#line 743 "rygel-http-byte-seek.c"
			} else {
#line 75 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
				_tmp27_ = FALSE;
#line 747 "rygel-http-byte-seek.c"
			}
#line 75 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp33_ = _tmp27_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
			_tmp6_ = _tmp33_;
#line 753 "rygel-http-byte-seek.c"
		}
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp34_ = _tmp6_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp4_ = _tmp34_;
#line 759 "rygel-http-byte-seek.c"
	}
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp35_ = _tmp4_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	result = _tmp35_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	return result;
#line 767 "rygel-http-byte-seek.c"
}


gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 78 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp0_ = request;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp1_ = _tmp0_->msg;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	result = _tmp3_ != NULL;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	return result;
#line 791 "rygel-http-byte-seek.c"
}


static void rygel_http_byte_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelHTTPByteSeek * self;
	gchar* range = NULL;
	gchar* _tmp0_ = NULL;
	SoupMessageHeaders* headers = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	SoupMessageHeaders* _tmp3_ = NULL;
	SoupMessage* _tmp4_ = NULL;
	SoupMessage* _tmp5_ = NULL;
	SoupMessageHeaders* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	SoupMessageHeaders* _tmp33_ = NULL;
	gint64 _tmp34_ = 0LL;
	gint64 _tmp35_ = 0LL;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	self = (RygelHTTPByteSeek*) base;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp0_ = g_strdup ("bytes ");
#line 84 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	range = _tmp0_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp1_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp2_ = _tmp1_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp3_ = _tmp2_->response_headers;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	headers = _tmp3_;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp4_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp5_ = _tmp4_;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp6_ = _tmp5_->request_headers;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp7_ = soup_message_headers_get_one (_tmp6_, "Range");
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	if (_tmp7_ != NULL) {
#line 834 "rygel-http-byte-seek.c"
		SoupMessageHeaders* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		gint64 _tmp11_ = 0LL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
		gint64 _tmp17_ = 0LL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gint64 _tmp24_ = 0LL;
		gint64 _tmp25_ = 0LL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		SoupMessageHeaders* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp8_ = headers;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		soup_message_headers_append (_tmp8_, "Accept-Ranges", "bytes");
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp9_ = range;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp10_ = rygel_http_seek_get_start ((RygelHTTPSeek*) self);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp11_ = _tmp10_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp11_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp13_ = _tmp12_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp14_ = g_strconcat (_tmp13_, "-", NULL);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp15_ = _tmp14_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp16_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) self);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp17_ = _tmp16_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp17_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp19_ = _tmp18_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp21_ = _tmp20_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp22_ = g_strconcat (_tmp21_, "/", NULL);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp23_ = _tmp22_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp24_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) self);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp25_ = _tmp24_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp26_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp25_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp27_ = _tmp26_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp28_ = g_strconcat (_tmp23_, _tmp27_, NULL);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp29_ = _tmp28_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp30_ = g_strconcat (_tmp9_, _tmp29_, NULL);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_g_free0 (range);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		range = _tmp30_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_g_free0 (_tmp29_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_g_free0 (_tmp27_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_g_free0 (_tmp23_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_g_free0 (_tmp21_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_g_free0 (_tmp19_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_g_free0 (_tmp15_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_g_free0 (_tmp13_);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp31_ = headers;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		_tmp32_ = range;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
		soup_message_headers_append (_tmp31_, "Content-Range", _tmp32_);
#line 932 "rygel-http-byte-seek.c"
	}
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp33_ = headers;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp34_ = rygel_http_seek_get_length ((RygelHTTPSeek*) self);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_tmp35_ = _tmp34_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	soup_message_headers_set_content_length (_tmp33_, _tmp35_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	_g_free0 (range);
#line 944 "rygel-http-byte-seek.c"
}


static void rygel_http_byte_seek_class_init (RygelHTTPByteSeekClass * klass) {
#line 26 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	rygel_http_byte_seek_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/tests/rygel-http-byte-seek.vala"
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_http_byte_seek_real_add_response_headers;
#line 953 "rygel-http-byte-seek.c"
}


static void rygel_http_byte_seek_instance_init (RygelHTTPByteSeek * self) {
}


GType rygel_http_byte_seek_get_type (void) {
	static volatile gsize rygel_http_byte_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeek), 0, (GInstanceInitFunc) rygel_http_byte_seek_instance_init, NULL };
		GType rygel_http_byte_seek_type_id;
		rygel_http_byte_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPByteSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_type_id__volatile, rygel_http_byte_seek_type_id);
	}
	return rygel_http_byte_seek_type_id__volatile;
}



