/* rygel-media-item.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-media-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;

#define RYGEL_TYPE_TRACKABLE_ITEM (rygel_trackable_item_get_type ())
#define RYGEL_TRACKABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_ITEM, RygelTrackableItem))
#define RYGEL_IS_TRACKABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_ITEM))
#define RYGEL_TRACKABLE_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_ITEM, RygelTrackableItemIface))

typedef struct _RygelTrackableItem RygelTrackableItem;
typedef struct _RygelTrackableItemIface RygelTrackableItemIface;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	RygelDataSource* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelMediaItemPrivate {
	gchar* _date;
	gchar* _creator;
	gchar* _mime_type;
	gchar* _dlna_profile;
	gint64 _size;
	gboolean _place_holder;
	gchar* _description;
};

struct _RygelTrackableItemIface {
	GTypeInterface parent_iface;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_media_item_parent_class = NULL;
extern GRegex* rygel_media_item_address_regex;
GRegex* rygel_media_item_address_regex = NULL;

GQuark rygel_media_item_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemPrivate))
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY,
	RYGEL_MEDIA_ITEM_DATE,
	RYGEL_MEDIA_ITEM_CREATOR,
	RYGEL_MEDIA_ITEM_MIME_TYPE,
	RYGEL_MEDIA_ITEM_DLNA_PROFILE,
	RYGEL_MEDIA_ITEM_SIZE,
	RYGEL_MEDIA_ITEM_PLACE_HOLDER,
	RYGEL_MEDIA_ITEM_DESCRIPTION,
	RYGEL_MEDIA_ITEM_OCM_FLAGS
};
RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelDataSource* rygel_media_item_create_stream_source (RygelMediaItem* self, const gchar* host_ip);
static RygelDataSource* rygel_media_item_real_create_stream_source (RygelMediaItem* self, const gchar* host_ip);
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
RygelDataSource* rygel_media_engine_create_data_source (RygelMediaEngine* self, const gchar* uri);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static gboolean rygel_media_item_real_streamable (RygelMediaItem* self);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
static void rygel_media_item_real_add_uri (RygelMediaItem* self, const gchar* uri);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_trackable_item_get_type (void) G_GNUC_CONST;
GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_media_item_get_creator (RygelMediaItem* self);
static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static void rygel_media_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_media_item_set_creator (RygelMediaItem* self, const gchar* value);
void rygel_media_item_set_date (RygelMediaItem* self, const gchar* value);
void rygel_media_item_set_description (RygelMediaItem* self, const gchar* value);
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteItem* rygel_serializer_add_item (RygelSerializer* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
const gchar* rygel_media_item_get_date (RygelMediaItem* self);
const gchar* rygel_media_item_get_description (RygelMediaItem* self);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
const gchar* rygel_media_item_get_mime_type (RygelMediaItem* self);
const gchar* rygel_media_item_get_dlna_profile (RygelMediaItem* self);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b);
void rygel_media_item_set_mime_type (RygelMediaItem* self, const gchar* value);
void rygel_media_item_set_dlna_profile (RygelMediaItem* self, const gchar* value);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
static void rygel_media_item_finalize (GObject* obj);
static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_media_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_item_error-quark");
}


RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMediaItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = id;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = parent;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = title;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = upnp_class;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "upnp-class", _tmp3_, NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return self;
#line 375 "rygel-media-item.c"
}


static RygelDataSource* rygel_media_item_real_create_stream_source (RygelMediaItem* self, const gchar* host_ip) {
	RygelDataSource* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* translated_uri = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelMediaEngine* _tmp14_ = NULL;
	RygelMediaEngine* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	RygelDataSource* _tmp17_ = NULL;
	RygelDataSource* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = ((RygelMediaObject*) self)->uris;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = _tmp1_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp2_ == 0) {
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = NULL;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 406 "rygel-media-item.c"
	}
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = ((RygelMediaObject*) self)->uris;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	translated_uri = (gchar*) _tmp4_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp5_ = host_ip;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp5_ != NULL) {
#line 418 "rygel-media-item.c"
		{
			gchar* _tmp6_ = NULL;
			GRegex* _tmp7_ = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp7_ = rygel_media_item_address_regex;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp8_ = ((RygelMediaObject*) self)->uris;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, 0);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp10_ = (gchar*) _tmp9_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp11_ = host_ip;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp12_ = g_regex_replace_literal (_tmp7_, _tmp10_, (gssize) (-1), 0, _tmp11_, 0, &_inner_error_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp13_ = _tmp12_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (_tmp10_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp6_ = _tmp13_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_inner_error_ != NULL) {
#line 448 "rygel-media-item.c"
				goto __catch7_g_error;
			}
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (translated_uri);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			translated_uri = _tmp6_;
#line 455 "rygel-media-item.c"
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* _error_ = NULL;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_error_ = _inner_error_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_inner_error_ = NULL;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_assert_not_reached ();
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_error_free0 (_error_);
#line 469 "rygel-media-item.c"
		}
		__finally7:
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_inner_error_ != NULL) {
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (translated_uri);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_clear_error (&_inner_error_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return NULL;
#line 482 "rygel-media-item.c"
		}
	}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp14_ = rygel_media_engine_get_default ();
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp15_ = _tmp14_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp16_ = translated_uri;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp17_ = rygel_media_engine_create_data_source (_tmp15_, _tmp16_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp18_ = _tmp17_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_object_unref0 (_tmp15_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp18_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (translated_uri);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 503 "rygel-media-item.c"
}


RygelDataSource* rygel_media_item_create_stream_source (RygelMediaItem* self, const gchar* host_ip) {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->create_stream_source (self, host_ip);
#line 512 "rygel-media-item.c"
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = rygel_media_item_streamable (self);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp1_) {
#line 527 "rygel-media-item.c"
		gint64 _tmp2_ = 0LL;
		gint64 _tmp3_ = 0LL;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = rygel_media_item_get_size (self);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = _tmp2_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp0_ = _tmp3_ <= ((gint64) 0);
#line 536 "rygel-media-item.c"
	} else {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp0_ = FALSE;
#line 540 "rygel-media-item.c"
	}
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = _tmp0_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp4_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 548 "rygel-media-item.c"
}


static gboolean rygel_media_item_real_streamable (RygelMediaItem* self) {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_media_item_streamable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return FALSE;
#line 557 "rygel-media-item.c"
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->streamable (self);
#line 566 "rygel-media-item.c"
}


static void rygel_media_item_real_add_uri (RygelMediaItem* self, const gchar* uri) {
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (uri != NULL);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = ((RygelMediaObject*) self)->uris;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = uri;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 581 "rygel-media-item.c"
}


void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri) {
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_uri (self, uri);
#line 590 "rygel-media-item.c"
}


gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2) {
	gint result = 0;
	RygelTranscoder* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelTranscoder* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (transcoder1 != NULL, 0);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (transcoder2 != NULL, 0);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = transcoder1;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = rygel_transcoder_get_distance (_tmp0_, self);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = transcoder2;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = rygel_transcoder_get_distance (_tmp2_, self);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = ((gint) _tmp1_) - ((gint) _tmp3_);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 618 "rygel-media-item.c"
}


static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	RygelMediaItem * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* res = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp13_ = FALSE;
	gint64 _tmp15_ = 0LL;
	gint64 _tmp16_ = 0LL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GUPnPProtocolInfo* _tmp19_ = NULL;
	GUPnPProtocolInfo* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) base;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (didl_object != NULL, NULL);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = didl_object;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = uri;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = protocol;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = import_uri;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->add_resource (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), _tmp0_, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	res = _tmp4_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_inner_error_ != NULL) {
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_propagate_error (error, _inner_error_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return NULL;
#line 668 "rygel-media-item.c"
	}
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = uri;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp6_ != NULL) {
#line 674 "rygel-media-item.c"
		gboolean _tmp7_ = FALSE;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp7_ = self->priv->_place_holder;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp5_ = !_tmp7_;
#line 680 "rygel-media-item.c"
	} else {
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp5_ = FALSE;
#line 684 "rygel-media-item.c"
	}
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp8_ = _tmp5_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp8_) {
#line 690 "rygel-media-item.c"
		const gchar* _tmp9_ = NULL;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp9_ = uri;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_resource_set_uri (res, _tmp9_);
#line 696 "rygel-media-item.c"
	} else {
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_resource_set_uri (res, "");
#line 700 "rygel-media-item.c"
	}
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp11_ = import_uri;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp11_ != NULL) {
#line 706 "rygel-media-item.c"
		gboolean _tmp12_ = FALSE;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp12_ = self->priv->_place_holder;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp10_ = _tmp12_;
#line 712 "rygel-media-item.c"
	} else {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp10_ = FALSE;
#line 716 "rygel-media-item.c"
	}
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp13_ = _tmp10_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp13_) {
#line 722 "rygel-media-item.c"
		const gchar* _tmp14_ = NULL;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp14_ = import_uri;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_resource_set_import_uri (res, _tmp14_);
#line 728 "rygel-media-item.c"
	}
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_TRACKABLE_ITEM)) {
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_resource_set_update_count (res, (guint) 0);
#line 734 "rygel-media-item.c"
	}
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp15_ = rygel_media_item_get_size (self);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp16_ = _tmp15_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_resource_set_size64 (res, _tmp16_);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp17_ = uri;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp18_ = protocol;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp19_ = rygel_media_item_get_protocol_info (self, _tmp17_, _tmp18_);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp20_ = _tmp19_;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_resource_set_protocol_info (res, _tmp20_);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_object_unref0 (_tmp20_);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = res;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 758 "rygel-media-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return self ? g_object_ref (self) : NULL;
#line 765 "rygel-media-item.c"
}


static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelMediaItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaItem* item = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	static GQuark _tmp5_label0 = 0;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	static GQuark _tmp5_label1 = 0;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) base;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = media_object;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = 1;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 797 "rygel-media-item.c"
	}
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = media_object;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp1_) : NULL);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	item = _tmp2_;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = property;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = _tmp3_;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("dc:creator")))) {
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		switch (0) {
#line 815 "rygel-media-item.c"
			default:
			{
				const gchar* _tmp7_ = NULL;
				RygelMediaItem* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp7_ = self->priv->_creator;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp8_ = item;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp9_ = _tmp8_->priv->_creator;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp10_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				result = _tmp10_;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_object_unref0 (item);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return result;
#line 836 "rygel-media-item.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("dc:date")))) {
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		switch (0) {
#line 842 "rygel-media-item.c"
			default:
			{
				RygelMediaItem* _tmp11_ = NULL;
				gint _tmp12_ = 0;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp11_ = item;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp12_ = rygel_media_item_compare_by_date (self, _tmp11_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				result = _tmp12_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_object_unref0 (item);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return result;
#line 857 "rygel-media-item.c"
			}
		}
	} else {
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		switch (0) {
#line 863 "rygel-media-item.c"
			default:
			{
				RygelMediaItem* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp13_ = item;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp14_ = property;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp15_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->compare_by_property (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), (RygelMediaObject*) _tmp13_, _tmp14_);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				result = _tmp15_;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_object_unref0 (item);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return result;
#line 881 "rygel-media-item.c"
			}
		}
	}
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_object_unref0 (item);
#line 887 "rygel-media-item.c"
}


static void rygel_media_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object) {
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPDIDLLiteObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPDIDLLiteObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) base;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (didl_object != NULL);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = didl_object;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->apply_didl_lite (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), _tmp0_);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = didl_object;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = gupnp_didl_lite_object_get_creator (_tmp1_);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_item_set_creator (self, _tmp2_);
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = didl_object;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = gupnp_didl_lite_object_get_date (_tmp3_);
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp5_ = _tmp4_;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_item_set_date (self, _tmp5_);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = didl_object;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp7_ = gupnp_didl_lite_object_get_description (_tmp6_);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp8_ = _tmp7_;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_item_set_description (self, _tmp8_);
#line 932 "rygel-media-item.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 939 "rygel-media-item.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_list_free (self);
#line 948 "rygel-media-item.c"
}


static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteItem* didl_item = NULL;
	RygelSerializer* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	GUPnPDIDLLiteItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaContainer* _tmp10_ = NULL;
	RygelMediaContainer* _tmp11_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GUPnPDIDLLiteItem* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GUPnPDIDLLiteItem* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gboolean _tmp34_ = FALSE;
	const gchar* _tmp35_ = NULL;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp42_ = NULL;
	RygelHTTPServer* _tmp48_ = NULL;
	GUPnPDIDLLiteItem* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	GError * _inner_error_ = NULL;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) base;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (serializer != NULL, NULL);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = serializer;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = rygel_serializer_add_item (_tmp0_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	didl_item = _tmp1_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = didl_item;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = rygel_media_object_get_id ((RygelMediaObject*) self);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = _tmp3_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp2_, _tmp4_);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp5_ = rygel_media_object_get_ref_id ((RygelMediaObject*) self);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = _tmp5_;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp6_ != NULL) {
#line 1008 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp7_ = didl_item;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp8_ = rygel_media_object_get_ref_id ((RygelMediaObject*) self);
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp9_ = _tmp8_;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_item_set_ref_id (_tmp7_, _tmp9_);
#line 1020 "rygel-media-item.c"
	}
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp10_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp11_ = _tmp10_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp11_ != NULL) {
#line 1028 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp12_ = NULL;
		RygelMediaContainer* _tmp13_ = NULL;
		RygelMediaContainer* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp12_ = didl_item;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp13_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp14_ = _tmp13_;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp15_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp14_);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp16_ = _tmp15_;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp12_, _tmp16_);
#line 1046 "rygel-media-item.c"
	} else {
		GUPnPDIDLLiteItem* _tmp17_ = NULL;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp17_ = didl_item;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp17_, "0");
#line 1053 "rygel-media-item.c"
	}
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp18_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp19_ = _tmp18_;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp19_) {
#line 1061 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp20_ = NULL;
#line 233 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp20_ = didl_item;
#line 233 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp20_, TRUE);
#line 1067 "rygel-media-item.c"
	} else {
		GUPnPDIDLLiteItem* _tmp21_ = NULL;
		GUPnPDIDLLiteItem* _tmp22_ = NULL;
		GUPnPOCMFlags _tmp23_ = 0;
		GUPnPOCMFlags _tmp24_ = 0;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp21_ = didl_item;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp21_, FALSE);
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp22_ = didl_item;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp23_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp24_ = _tmp23_;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp22_, _tmp24_);
#line 1085 "rygel-media-item.c"
	}
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp25_ = didl_item;
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp26_ = rygel_media_object_get_title ((RygelMediaObject*) self);
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp27_ = _tmp26_;
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp25_, _tmp27_);
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp28_ = didl_item;
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp29_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp30_ = _tmp29_;
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp28_, _tmp30_);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp31_ = self->priv->_date;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp31_ != NULL) {
#line 1107 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp32_ = didl_item;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp33_ = self->priv->_date;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_date ((GUPnPDIDLLiteObject*) _tmp32_, _tmp33_);
#line 1116 "rygel-media-item.c"
	}
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp35_ = self->priv->_creator;
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp35_ != NULL) {
#line 1122 "rygel-media-item.c"
		const gchar* _tmp36_ = NULL;
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp36_ = self->priv->_creator;
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp34_ = g_strcmp0 (_tmp36_, "") != 0;
#line 1128 "rygel-media-item.c"
	} else {
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp34_ = FALSE;
#line 1132 "rygel-media-item.c"
	}
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp37_ = _tmp34_;
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp37_) {
#line 1138 "rygel-media-item.c"
		GUPnPDIDLLiteContributor* creator = NULL;
		GUPnPDIDLLiteItem* _tmp38_ = NULL;
		GUPnPDIDLLiteContributor* _tmp39_ = NULL;
		GUPnPDIDLLiteContributor* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp38_ = didl_item;
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp39_ = gupnp_didl_lite_object_add_creator ((GUPnPDIDLLiteObject*) _tmp38_);
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		creator = _tmp39_;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp40_ = creator;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp41_ = self->priv->_creator;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_contributor_set_name (_tmp40_, _tmp41_);
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (creator);
#line 1158 "rygel-media-item.c"
	}
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp42_ = self->priv->_description;
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp42_ != NULL) {
#line 1164 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp43_ = didl_item;
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp44_ = self->priv->_description;
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_description ((GUPnPDIDLLiteObject*) _tmp43_, _tmp44_);
#line 1173 "rygel-media-item.c"
	}
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_TRACKABLE_ITEM)) {
#line 1177 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp45_ = NULL;
		guint _tmp46_ = 0U;
		guint _tmp47_ = 0U;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp45_ = didl_item;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp46_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) self);
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp47_ = _tmp46_;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_update_id ((GUPnPDIDLLiteObject*) _tmp45_, _tmp47_);
#line 1189 "rygel-media-item.c"
	}
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp48_ = http_server;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp49_ = didl_item;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_item_add_proxy_resources (self, _tmp48_, _tmp49_, &_inner_error_);
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_inner_error_ != NULL) {
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_propagate_error (error, _inner_error_);
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (didl_item);
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return NULL;
#line 1205 "rygel-media-item.c"
	}
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp50_ = self->priv->_place_holder;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (!_tmp50_) {
#line 1211 "rygel-media-item.c"
		gchar* host_ip = NULL;
		RygelHTTPServer* _tmp51_ = NULL;
		GUPnPContext* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gboolean internal_allowed = FALSE;
		gboolean _tmp56_ = FALSE;
		RygelHTTPServer* _tmp57_ = NULL;
		GUPnPContext* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		gboolean _tmp62_ = FALSE;
		GUPnPDIDLLiteItem* _tmp63_ = NULL;
		gboolean _tmp64_ = FALSE;
		GUPnPDIDLLiteItem* _tmp65_ = NULL;
		GList* _tmp66_ = NULL;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp51_ = http_server;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp52_ = _tmp51_->context;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp53_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp52_);
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp54_ = _tmp53_;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp55_ = g_strdup (_tmp54_);
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		host_ip = _tmp55_;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp57_ = http_server;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp58_ = _tmp57_->context;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp59_ = gssdp_client_get_interface ((GSSDPClient*) _tmp58_);
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp60_ = _tmp59_;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (g_strcmp0 (_tmp60_, "lo") == 0) {
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp56_ = TRUE;
#line 1253 "rygel-media-item.c"
		} else {
			const gchar* _tmp61_ = NULL;
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp61_ = host_ip;
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp56_ = g_strcmp0 (_tmp61_, "127.0.0.1") == 0;
#line 1260 "rygel-media-item.c"
		}
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp62_ = _tmp56_;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		internal_allowed = _tmp62_;
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp63_ = didl_item;
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp64_ = internal_allowed;
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_add_resources (self, _tmp63_, _tmp64_, &_inner_error_);
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_inner_error_ != NULL) {
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_propagate_error (error, _inner_error_);
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (host_ip);
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_object_unref0 (didl_item);
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return NULL;
#line 1282 "rygel-media-item.c"
		}
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp65_ = didl_item;
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp66_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _tmp65_);
#line 1288 "rygel-media-item.c"
		{
			GList* res_collection = NULL;
			GList* res_it = NULL;
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			res_collection = _tmp66_;
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			for (res_it = res_collection; res_it != NULL; res_it = res_it->next) {
#line 1296 "rygel-media-item.c"
				GUPnPDIDLLiteResource* _tmp67_ = NULL;
				GUPnPDIDLLiteResource* res = NULL;
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp67_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) res_it->data);
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				res = _tmp67_;
#line 1303 "rygel-media-item.c"
				{
					gchar* _tmp68_ = NULL;
					GRegex* _tmp69_ = NULL;
					GUPnPDIDLLiteResource* _tmp70_ = NULL;
					const gchar* _tmp71_ = NULL;
					const gchar* _tmp72_ = NULL;
					const gchar* _tmp73_ = NULL;
					gchar* _tmp74_ = NULL;
					GUPnPDIDLLiteResource* _tmp75_ = NULL;
					gchar* _tmp76_ = NULL;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp69_ = rygel_media_item_address_regex;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp70_ = res;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp71_ = gupnp_didl_lite_resource_get_uri (_tmp70_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp72_ = _tmp71_;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp73_ = host_ip;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp74_ = g_regex_replace_literal (_tmp69_, _tmp72_, (gssize) (-1), 0, _tmp73_, 0, &_inner_error_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp68_ = _tmp74_;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					if (_inner_error_ != NULL) {
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						g_propagate_error (error, _inner_error_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						_g_object_unref0 (res);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						__g_list_free__g_object_unref0_0 (res_collection);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						_g_free0 (host_ip);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						_g_object_unref0 (didl_item);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						return NULL;
#line 1342 "rygel-media-item.c"
					}
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp75_ = res;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp76_ = _tmp68_;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					gupnp_didl_lite_resource_set_uri (_tmp75_, _tmp76_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_g_free0 (_tmp76_);
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_g_object_unref0 (res);
#line 1354 "rygel-media-item.c"
				}
			}
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			__g_list_free__g_object_unref0_0 (res_collection);
#line 1359 "rygel-media-item.c"
		}
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_free0 (host_ip);
#line 1363 "rygel-media-item.c"
	}
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = (GUPnPDIDLLiteObject*) didl_item;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 1369 "rygel-media-item.c"
}


static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelHTTPServer* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (server != NULL);
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = server;
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = didl_item;
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_http_server_add_proxy_resource (_tmp0_, _tmp1_, self, &_inner_error_);
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_inner_error_ != NULL) {
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_propagate_error (error, _inner_error_);
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return;
#line 1394 "rygel-media-item.c"
	}
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = self->priv->_place_holder;
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (!_tmp2_) {
#line 1400 "rygel-media-item.c"
		RygelHTTPServer* _tmp3_ = NULL;
		GUPnPDIDLLiteItem* _tmp4_ = NULL;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = server;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp4_ = didl_item;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_transcode_manager_add_resources ((RygelTranscodeManager*) _tmp3_, _tmp4_, self, &_inner_error_);
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_inner_error_ != NULL) {
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_propagate_error (error, _inner_error_);
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return;
#line 1415 "rygel-media-item.c"
		}
	}
}


void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_proxy_resources (self, server, didl_item, error);
#line 1426 "rygel-media-item.c"
}


static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp0_ = NULL;
	GUPnPProtocolInfo* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPProtocolInfo* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GUPnPProtocolInfo* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GUPnPProtocolInfo* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	gboolean _tmp11_ = FALSE;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = gupnp_protocol_info_new ();
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	protocol_info = _tmp0_;
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = protocol_info;
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = self->priv->_mime_type;
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_protocol_info_set_mime_type (_tmp1_, _tmp2_);
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = protocol_info;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = self->priv->_dlna_profile;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_profile (_tmp3_, _tmp4_);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp5_ = protocol_info;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = protocol;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_protocol_info_set_protocol (_tmp5_, _tmp6_);
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp7_ = protocol_info;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_flags (_tmp7_, (GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp8_ = rygel_media_item_get_size (self);
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp9_ = _tmp8_;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp9_ > ((gint64) 0)) {
#line 1478 "rygel-media-item.c"
		GUPnPProtocolInfo* _tmp10_ = NULL;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp10_ = protocol_info;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_operation (_tmp10_, GUPNP_DLNA_OPERATION_RANGE);
#line 1484 "rygel-media-item.c"
	}
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp11_ = rygel_media_item_streamable (self);
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp11_) {
#line 1490 "rygel-media-item.c"
		GUPnPProtocolInfo* _tmp12_ = NULL;
		GUPnPProtocolInfo* _tmp13_ = NULL;
		GUPnPDLNAFlags _tmp14_ = 0;
		GUPnPDLNAFlags _tmp15_ = 0;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp12_ = protocol_info;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp13_ = protocol_info;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp14_ = gupnp_protocol_info_get_dlna_flags (_tmp13_);
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp15_ = _tmp14_;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_flags (_tmp13_, _tmp15_ | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
#line 1505 "rygel-media-item.c"
	}
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = protocol_info;
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 1511 "rygel-media-item.c"
}


GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->get_protocol_info (self, uri, protocol);
#line 1520 "rygel-media-item.c"
}


gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error) {
	gchar* result = NULL;
	gchar* scheme = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = uri;
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = g_uri_parse_scheme (_tmp0_);
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	scheme = _tmp1_;
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = scheme;
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp2_ == NULL) {
#line 1546 "rygel-media-item.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 322 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = _ ("Bad URI: %s");
#line 322 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp4_ = uri;
#line 322 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp5_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _tmp3_, _tmp4_);
#line 322 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_inner_error_ = _tmp5_;
#line 322 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_propagate_error (error, _inner_error_);
#line 322 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_free0 (scheme);
#line 322 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return NULL;
#line 1564 "rygel-media-item.c"
	}
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = scheme;
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (g_strcmp0 (_tmp6_, "http") == 0) {
#line 1570 "rygel-media-item.c"
		gchar* _tmp7_ = NULL;
#line 326 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp7_ = g_strdup ("http-get");
#line 326 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = _tmp7_;
#line 326 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_free0 (scheme);
#line 326 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 1580 "rygel-media-item.c"
	} else {
		const gchar* _tmp8_ = NULL;
#line 327 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp8_ = scheme;
#line 327 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (g_strcmp0 (_tmp8_, "file") == 0) {
#line 1587 "rygel-media-item.c"
			gchar* _tmp9_ = NULL;
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp9_ = g_strdup ("internal");
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			result = _tmp9_;
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (scheme);
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return result;
#line 1597 "rygel-media-item.c"
		} else {
			const gchar* _tmp10_ = NULL;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp10_ = scheme;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (g_strcmp0 (_tmp10_, "rtsp") == 0) {
#line 1604 "rygel-media-item.c"
				gchar* _tmp11_ = NULL;
#line 331 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp11_ = g_strdup ("rtsp-rtp-udp");
#line 331 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				result = _tmp11_;
#line 331 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (scheme);
#line 331 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return result;
#line 1614 "rygel-media-item.c"
			} else {
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp12_ = _ ("Failed to probe protocol for URI %s. Assuming '%s'");
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp13_ = uri;
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp14_ = scheme;
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				g_warning (_tmp12_, _tmp13_, _tmp14_);
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				result = scheme;
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return result;
#line 1631 "rygel-media-item.c"
			}
		}
	}
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (scheme);
#line 1637 "rygel-media-item.c"
}


static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	GError * _inner_error_ = NULL;
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 1645 "rygel-media-item.c"
	{
		GeeArrayList* _uri_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _uri_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _uri_index = 0;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp0_ = ((RygelMediaObject*) self)->uris;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_uri_list = _tmp1_;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = _uri_list;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp4_ = _tmp3_;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_uri_size = _tmp4_;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_uri_index = -1;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		while (TRUE) {
#line 1673 "rygel-media-item.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gchar* uri = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gchar* protocol = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp16_ = FALSE;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp5_ = _uri_index;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_uri_index = _tmp5_ + 1;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp6_ = _uri_index;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp7_ = _uri_size;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				break;
#line 1699 "rygel-media-item.c"
			}
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp8_ = _uri_list;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp9_ = _uri_index;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			uri = (gchar*) _tmp10_;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp11_ = uri;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp12_ = rygel_media_item_get_protocol_for_uri (self, _tmp11_, &_inner_error_);
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			protocol = _tmp12_;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_inner_error_ != NULL) {
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				g_propagate_error (error, _inner_error_);
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (uri);
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_object_unref0 (_uri_list);
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return;
#line 1725 "rygel-media-item.c"
			}
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp14_ = allow_internal;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_tmp14_) {
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp13_ = TRUE;
#line 1733 "rygel-media-item.c"
			} else {
				const gchar* _tmp15_ = NULL;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp15_ = protocol;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp13_ = g_strcmp0 (_tmp15_, "internal") != 0;
#line 1740 "rygel-media-item.c"
			}
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp16_ = _tmp13_;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_tmp16_) {
#line 1746 "rygel-media-item.c"
				GUPnPDIDLLiteItem* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				GUPnPDIDLLiteResource* _tmp20_ = NULL;
				GUPnPDIDLLiteResource* _tmp21_ = NULL;
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp17_ = didl_item;
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp18_ = uri;
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp19_ = protocol;
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp20_ = rygel_media_object_add_resource ((RygelMediaObject*) self, (GUPnPDIDLLiteObject*) _tmp17_, _tmp18_, _tmp19_, NULL, &_inner_error_);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp21_ = _tmp20_;
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_object_unref0 (_tmp21_);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				if (_inner_error_ != NULL) {
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					g_propagate_error (error, _inner_error_);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_g_free0 (protocol);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_g_free0 (uri);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_g_object_unref0 (_uri_list);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					return;
#line 1776 "rygel-media-item.c"
				}
			}
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (protocol);
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (uri);
#line 1783 "rygel-media-item.c"
		}
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (_uri_list);
#line 1787 "rygel-media-item.c"
	}
}


void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resources (self, didl_item, allow_internal, error);
#line 1797 "rygel-media-item.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1237 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1237 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 1817 "rygel-media-item.c"
}


static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (item != NULL, 0);
#line 355 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_date;
#line 355 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp0_ == NULL) {
#line 356 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = -1;
#line 356 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 1836 "rygel-media-item.c"
	} else {
		RygelMediaItem* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp1_ = item;
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = _tmp1_->priv->_date;
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_tmp2_ == NULL) {
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			result = 1;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return result;
#line 1850 "rygel-media-item.c"
		} else {
			gchar* our_date = NULL;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* other_date = NULL;
			RygelMediaItem* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			const gchar* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			GTimeVal tv1 = {0};
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			GTimeVal tv2 = {0};
			RygelMediaItem* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			gint ret = 0;
			GTimeVal _tmp21_ = {0};
			glong _tmp22_ = 0L;
			GTimeVal _tmp23_ = {0};
			glong _tmp24_ = 0L;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp3_ = self->priv->_date;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			our_date = _tmp4_;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp5_ = item;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp6_ = _tmp5_->priv->_date;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			other_date = _tmp7_;
#line 363 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp8_ = our_date;
#line 363 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp9_ = string_contains (_tmp8_, "T");
#line 363 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (!_tmp9_) {
#line 1897 "rygel-media-item.c"
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp10_ = our_date;
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp11_ = g_strconcat (_tmp10_, "T00:00:00Z", NULL);
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (our_date);
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				our_date = _tmp11_;
#line 1908 "rygel-media-item.c"
			}
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp12_ = other_date;
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp13_ = string_contains (_tmp12_, "T");
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (!_tmp13_) {
#line 1916 "rygel-media-item.c"
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp14_ = other_date;
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp15_ = g_strconcat (_tmp14_, "T00:00:00Z", NULL);
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (other_date);
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				other_date = _tmp15_;
#line 1927 "rygel-media-item.c"
			}
#line 371 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_get_current_time (&tv1);
#line 372 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp16_ = self->priv->_date;
#line 372 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp17_ = g_time_val_from_iso8601 (_tmp16_, &tv1);
#line 372 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_vala_assert (_tmp17_, "tv1.from_iso8601 (this.date)");
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_get_current_time (&tv2);
#line 375 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp18_ = item;
#line 375 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp19_ = _tmp18_->priv->_date;
#line 375 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp20_ = g_time_val_from_iso8601 (_tmp19_, &tv2);
#line 375 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_vala_assert (_tmp20_, "tv2.from_iso8601 (item.date)");
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp21_ = tv1;
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp22_ = _tmp21_.tv_sec;
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp23_ = tv2;
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp24_ = _tmp23_.tv_sec;
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp25_ = rygel_media_item_compare_long (self, _tmp22_, _tmp24_);
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			ret = _tmp25_;
#line 378 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp26_ = ret;
#line 378 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_tmp26_ == 0) {
#line 1963 "rygel-media-item.c"
				GTimeVal _tmp27_ = {0};
				glong _tmp28_ = 0L;
				GTimeVal _tmp29_ = {0};
				glong _tmp30_ = 0L;
				gint _tmp31_ = 0;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp27_ = tv1;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp28_ = _tmp27_.tv_usec;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp29_ = tv2;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp30_ = _tmp29_.tv_usec;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp31_ = rygel_media_item_compare_long (self, _tmp28_, _tmp30_);
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				ret = _tmp31_;
#line 1981 "rygel-media-item.c"
			}
#line 382 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			result = ret;
#line 382 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (other_date);
#line 382 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (our_date);
#line 382 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return result;
#line 1991 "rygel-media-item.c"
		}
	}
}


static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b) {
	gint result = 0;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 387 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = a;
#line 387 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = b;
#line 387 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp0_ < _tmp1_) {
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = -1;
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 2013 "rygel-media-item.c"
	} else {
		glong _tmp2_ = 0L;
		glong _tmp3_ = 0L;
#line 389 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = a;
#line 389 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = b;
#line 389 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_tmp2_ > _tmp3_) {
#line 390 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			result = 1;
#line 390 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return result;
#line 2027 "rygel-media-item.c"
		} else {
#line 392 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			result = 0;
#line 392 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return result;
#line 2033 "rygel-media-item.c"
		}
	}
}


const gchar* rygel_media_item_get_date (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_date;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 2050 "rygel-media-item.c"
}


void rygel_media_item_set_date (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_date);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_date = _tmp1_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "date");
#line 2069 "rygel-media-item.c"
}


const gchar* rygel_media_item_get_creator (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_creator;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 2084 "rygel-media-item.c"
}


void rygel_media_item_set_creator (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_creator);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_creator = _tmp1_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "creator");
#line 2103 "rygel-media-item.c"
}


const gchar* rygel_media_item_get_mime_type (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_mime_type;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 2118 "rygel-media-item.c"
}


void rygel_media_item_set_mime_type (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_mime_type);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_mime_type = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "mime-type");
#line 2137 "rygel-media-item.c"
}


const gchar* rygel_media_item_get_dlna_profile (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_dlna_profile;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 2152 "rygel-media-item.c"
}


void rygel_media_item_set_dlna_profile (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_dlna_profile);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_dlna_profile = _tmp1_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "dlna-profile");
#line 2171 "rygel-media-item.c"
}


gint64 rygel_media_item_get_size (RygelMediaItem* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_size;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 2186 "rygel-media-item.c"
}


void rygel_media_item_set_size (RygelMediaItem* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp0_ == ((gint64) 0)) {
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_place_holder (self, TRUE);
#line 2201 "rygel-media-item.c"
	}
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = value;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_size = _tmp1_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "size");
#line 2209 "rygel-media-item.c"
}


gboolean rygel_media_item_get_place_holder (RygelMediaItem* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_place_holder;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 2224 "rygel-media-item.c"
}


void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_place_holder = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "place-holder");
#line 2238 "rygel-media-item.c"
}


const gchar* rygel_media_item_get_description (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_description;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 2253 "rygel-media-item.c"
}


void rygel_media_item_set_description (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_description);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_description = _tmp1_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "description");
#line 2272 "rygel-media-item.c"
}


static GUPnPOCMFlags rygel_media_item_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaItem* self;
	GUPnPOCMFlags flags = 0;
	gboolean _tmp0_ = FALSE;
	GUPnPOCMFlags _tmp9_ = 0;
	GError * _inner_error_ = NULL;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) base;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	flags = GUPNP_OCM_FLAGS_NONE;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_place_holder;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp0_) {
#line 2291 "rygel-media-item.c"
		GUPnPOCMFlags _tmp1_ = 0;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp1_ = flags;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		flags = _tmp1_ | GUPNP_OCM_FLAGS_DESTROYABLE;
#line 2297 "rygel-media-item.c"
	} else {
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp2_ = NULL;
		gboolean allow_deletion = FALSE;
		gboolean _tmp6_ = FALSE;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = rygel_meta_config_get_default ();
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		config = _tmp2_;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		allow_deletion = TRUE;
#line 2309 "rygel-media-item.c"
		{
			gboolean _tmp3_ = FALSE;
			RygelMetaConfig* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp4_ = config;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp5_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp4_, &_inner_error_);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp3_ = _tmp5_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_inner_error_ != NULL) {
#line 2322 "rygel-media-item.c"
				goto __catch8_g_error;
			}
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			allow_deletion = _tmp3_;
#line 2327 "rygel-media-item.c"
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* _error_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_error_ = _inner_error_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_inner_error_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_error_free0 (_error_);
#line 2339 "rygel-media-item.c"
		}
		__finally8:
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_inner_error_ != NULL) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_object_unref0 (config);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_clear_error (&_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return 0;
#line 2352 "rygel-media-item.c"
		}
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp6_ = allow_deletion;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_tmp6_) {
#line 2358 "rygel-media-item.c"
			GUPnPOCMFlags _tmp7_ = 0;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp7_ = flags;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			flags = _tmp7_ | GUPNP_OCM_FLAGS_DESTROYABLE;
#line 2364 "rygel-media-item.c"
		}
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (config);
#line 2368 "rygel-media-item.c"
	}
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
#line 2372 "rygel-media-item.c"
		GUPnPOCMFlags _tmp8_ = 0;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp8_ = flags;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		flags = _tmp8_ | GUPNP_OCM_FLAGS_CHANGE_METADATA;
#line 2378 "rygel-media-item.c"
	}
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp9_ = flags;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp9_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 2386 "rygel-media-item.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	GError * _inner_error_ = NULL;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaItemPrivate));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->create_stream_source = rygel_media_item_real_create_stream_source;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_media_item_real_streamable;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_media_item_real_add_uri;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->add_resource = rygel_media_item_real_add_resource;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_item_real_compare_by_property;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->apply_didl_lite = rygel_media_item_real_apply_didl_lite;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_item_real_serialize;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_media_item_real_add_proxy_resources;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->get_protocol_info = rygel_media_item_real_get_protocol_info;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_media_item_real_add_resources;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_item_real_get_ocm_flags;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_item_get_property;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_item_set_property;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_DATE, g_param_spec_string ("date", "date", "date", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_CREATOR, g_param_spec_string ("creator", "creator", "creator", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_DLNA_PROFILE, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_PLACE_HOLDER, g_param_spec_boolean ("place-holder", "place-holder", "place-holder", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2440 "rygel-media-item.c"
	{
		GRegex* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp1_ = g_regex_escape_string ("@ADDRESS@", -1);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = _tmp1_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp4_ = _tmp3_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_free0 (_tmp2_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp0_ = _tmp4_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_inner_error_ != NULL) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2463 "rygel-media-item.c"
				goto __catch9_g_regex_error;
			}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_clear_error (&_inner_error_);
#line 2470 "rygel-media-item.c"
		}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_regex_unref0 (rygel_media_item_address_regex);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_address_regex = _tmp0_;
#line 2476 "rygel-media-item.c"
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* err = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		err = _inner_error_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_inner_error_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_assert_not_reached ();
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_error_free0 (err);
#line 2490 "rygel-media-item.c"
	}
	__finally9:
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_inner_error_ != NULL) {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_clear_error (&_inner_error_);
#line 2499 "rygel-media-item.c"
	}
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv = RYGEL_MEDIA_ITEM_GET_PRIVATE (self);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_size = (gint64) (-1);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_place_holder = FALSE;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_description = NULL;
#line 2513 "rygel-media-item.c"
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_date);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_creator);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_mime_type);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_dlna_profile);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_description);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 2533 "rygel-media-item.c"
}


/**
 * Represents a media item (Music, Video or Image).
 *
 * These objects correspond to items in the UPnP ContentDirectory's DIDL-Lite XML.
 */
GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	switch (property_id) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_DATE:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_string (value, rygel_media_item_get_date (self));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_CREATOR:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_string (value, rygel_media_item_get_creator (self));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_MIME_TYPE:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_string (value, rygel_media_item_get_mime_type (self));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_DLNA_PROFILE:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_string (value, rygel_media_item_get_dlna_profile (self));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_SIZE:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_int64 (value, rygel_media_item_get_size (self));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_PLACE_HOLDER:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_boolean (value, rygel_media_item_get_place_holder (self));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_DESCRIPTION:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_string (value, rygel_media_item_get_description (self));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_OCM_FLAGS:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 2607 "rygel-media-item.c"
		default:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 2613 "rygel-media-item.c"
	}
}


static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	switch (property_id) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_DATE:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_date (self, g_value_get_string (value));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_CREATOR:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_creator (self, g_value_get_string (value));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_MIME_TYPE:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_mime_type (self, g_value_get_string (value));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_DLNA_PROFILE:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_dlna_profile (self, g_value_get_string (value));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_SIZE:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_size (self, g_value_get_int64 (value));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_PLACE_HOLDER:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_place_holder (self, g_value_get_boolean (value));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_DESCRIPTION:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_description (self, g_value_get_string (value));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 2665 "rygel-media-item.c"
		default:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 2671 "rygel-media-item.c"
	}
}



