/* rygel-root-device-factory.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-root-device-factory.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2007 OpenedHand Ltd.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                                <zeeshan.ali@nokia.com>
 *          Jorn Baayen <jorn@openedhand.com>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <uuid/uuid.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_DESCRIPTION_FILE (rygel_description_file_get_type ())
#define RYGEL_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile))
#define RYGEL_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))
#define RYGEL_IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))

typedef struct _RygelDescriptionFile RygelDescriptionFile;
typedef struct _RygelDescriptionFileClass RygelDescriptionFileClass;

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

typedef enum  {
	ROOT_DEVICE_FACTORY_ERROR_XML_PARSE
} RootDeviceFactoryError;
#define ROOT_DEVICE_FACTORY_ERROR root_device_factory_error_quark ()
struct _RygelRootDeviceFactory {
	GObject parent_instance;
	RygelRootDeviceFactoryPrivate * priv;
};

struct _RygelRootDeviceFactoryClass {
	GObjectClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelRootDeviceFactoryPrivate {
	GUPnPContext* _context;
	RygelConfiguration* config;
	gchar* desc_dir;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4
} RygelPluginCapabilities;

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


static gpointer rygel_root_device_factory_parent_class = NULL;
static GInitableIface* rygel_root_device_factory_g_initable_parent_iface = NULL;

GQuark root_device_factory_error_quark (void);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryPrivate))
enum  {
	RYGEL_ROOT_DEVICE_FACTORY_DUMMY_PROPERTY,
	RYGEL_ROOT_DEVICE_FACTORY_CONTEXT
};
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
static gboolean rygel_root_device_factory_real_init (GInitable* base, GCancellable* cancellable, GError** error);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
const gchar* rygel_plugin_get_name (RygelPlugin* self);
const gchar* rygel_plugin_get_desc_path (RygelPlugin* self);
static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error);
GUPnPContext* rygel_root_device_factory_get_context (RygelRootDeviceFactory* self);
RygelRootDevice* rygel_root_device_new (GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
RygelRootDevice* rygel_root_device_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
void rygel_plugin_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error);
RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc);
RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
GType rygel_description_file_get_type (void) G_GNUC_CONST;
static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin);
static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin);
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name);
static gchar* rygel_root_device_factory_get_friendly_name (RygelRootDeviceFactory* self, RygelPlugin* plugin);
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities);
RygelPluginCapabilities rygel_plugin_get_capabilities (RygelPlugin* self);
const gchar* rygel_plugin_get_description (RygelPlugin* self);
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description);
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self);
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn);
void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error);
gchar* rygel_configuration_get_title (RygelConfiguration* self, const gchar* section, GError** error);
const gchar* rygel_plugin_get_title (RygelPlugin* self);
void rygel_description_file_clear_service_list (RygelDescriptionFile* self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_plugin_get_resource_infos (RygelPlugin* self);
void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_plugin_get_icon_infos (RygelPlugin* self);
GeeArrayList* rygel_plugin_get_default_icons (RygelPlugin* self);
void rygel_description_file_clear_icon_list (RygelDescriptionFile* self);
static gchar* rygel_root_device_factory_get_icon_remote_path (RygelRootDeviceFactory* self, RygelIconInfo* icon_info, RygelPlugin* plugin);
void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url);
static void rygel_root_device_factory_set_context (RygelRootDeviceFactory* self, GUPnPContext* value);
static void rygel_root_device_factory_finalize (GObject* obj);
static void _vala_rygel_root_device_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_root_device_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark root_device_factory_error_quark (void) {
	return g_quark_from_static_string ("root_device_factory_error-quark");
}


RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error) {
	RygelRootDeviceFactory * self = NULL;
	GUPnPContext* _tmp0_;
	GError * _inner_error_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = context;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self = (RygelRootDeviceFactory*) g_object_new (object_type, "context", _tmp0_, NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_initable_init ((GInitable*) self, NULL, &_inner_error_);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (self);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 320 "rygel-root-device-factory.c"
	}
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return self;
#line 324 "rygel-root-device-factory.c"
}


RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error) {
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return rygel_root_device_factory_construct (RYGEL_TYPE_ROOT_DEVICE_FACTORY, context, error);
#line 331 "rygel-root-device-factory.c"
}


static gboolean rygel_root_device_factory_real_init (GInitable* base, GCancellable* cancellable, GError** error) {
	RygelRootDeviceFactory * self;
	gboolean result = FALSE;
	RygelConfiguration* _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* config_dir;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	GError * _inner_error_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self = (RygelRootDeviceFactory*) base;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = self->priv->config;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp0_ != NULL) {
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		result = TRUE;
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return result;
#line 359 "rygel-root-device-factory.c"
	}
#line 60 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = rygel_meta_config_get_default ();
#line 60 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (self->priv->config);
#line 60 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self->priv->config = (RygelConfiguration*) _tmp1_;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = g_get_user_config_dir ();
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	config_dir = _tmp3_;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp4_ = config_dir;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_ensure_dir_exists (self, _tmp4_, &_inner_error_);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (config_dir);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return FALSE;
#line 385 "rygel-root-device-factory.c"
	}
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp5_ = config_dir;
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp6_ = g_get_application_name ();
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp7_ = g_build_filename (_tmp5_, _tmp6_, NULL);
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (self->priv->desc_dir);
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self->priv->desc_dir = _tmp7_;
#line 67 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp8_ = self->priv->desc_dir;
#line 67 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_ensure_dir_exists (self, _tmp8_, &_inner_error_);
#line 67 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 67 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 67 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (config_dir);
#line 67 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return FALSE;
#line 409 "rygel-root-device-factory.c"
	}
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = TRUE;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (config_dir);
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 417 "rygel-root-device-factory.c"
}


RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error) {
	RygelRootDevice* result = NULL;
	const gchar* _tmp0_;
	RygelPlugin* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* desc_path;
	RygelPlugin* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* template_path;
	RygelPlugin* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GUPnPXMLDoc* _tmp15_ = NULL;
	GUPnPXMLDoc* doc;
	GUPnPContext* _tmp16_;
	RygelPlugin* _tmp17_;
	GUPnPXMLDoc* _tmp18_;
	const gchar* _tmp19_;
	RygelRootDevice* _tmp20_;
	RygelRootDevice* device;
	RygelPlugin* _tmp21_;
	RygelRootDevice* _tmp22_;
	const gchar* _tmp23_;
	GError * _inner_error_ = NULL;
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = self->priv->desc_dir;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = plugin;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = rygel_plugin_get_name (_tmp1_);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = _tmp2_;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp4_ = g_strconcat (_tmp3_, ".xml", NULL);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp5_ = _tmp4_;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp6_ = g_build_filename (_tmp0_, _tmp5_, NULL);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp7_ = _tmp6_;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (_tmp5_);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	desc_path = _tmp7_;
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp8_ = plugin;
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp9_ = rygel_plugin_get_desc_path (_tmp8_);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp10_ = _tmp9_;
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	template_path = _tmp11_;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp12_ = plugin;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp13_ = desc_path;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp14_ = template_path;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp15_ = rygel_root_device_factory_create_desc (self, _tmp12_, _tmp13_, _tmp14_, &_inner_error_);
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	doc = _tmp15_;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (template_path);
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (desc_path);
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 506 "rygel-root-device-factory.c"
	}
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp16_ = self->priv->_context;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp17_ = plugin;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp18_ = doc;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp19_ = desc_path;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp20_ = rygel_root_device_new (_tmp16_, _tmp17_, _tmp18_, _tmp19_, DATA_DIR);
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	device = _tmp20_;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp21_ = plugin;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp22_ = device;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp23_ = desc_path;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_plugin_apply_hacks (_tmp21_, _tmp22_, _tmp23_, &_inner_error_);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (device);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (doc);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (template_path);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (desc_path);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 542 "rygel-root-device-factory.c"
	}
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = device;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (doc);
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (template_path);
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (desc_path);
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 554 "rygel-root-device-factory.c"
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* _tmp0_ = NULL;
	guchar* id;
	gint id_length1;
	gint _id_size_;
	guchar* _tmp1_ = NULL;
	guchar* unparsed;
	gint unparsed_length1;
	gint _unparsed_size_;
	guchar* _tmp2_;
	gint _tmp2__length1;
	guchar* _tmp3_;
	gint _tmp3__length1;
	guchar* _tmp4_;
	gint _tmp4__length1;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar _tmp6_;
	guchar* _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
#line 8 "./uuid.vapi"
	_tmp0_ = g_new0 (guchar, 16);
#line 8 "./uuid.vapi"
	id = _tmp0_;
#line 8 "./uuid.vapi"
	id_length1 = 16;
#line 8 "./uuid.vapi"
	_id_size_ = id_length1;
#line 9 "./uuid.vapi"
	_tmp1_ = g_new0 (guchar, 51);
#line 9 "./uuid.vapi"
	unparsed = _tmp1_;
#line 9 "./uuid.vapi"
	unparsed_length1 = 51;
#line 9 "./uuid.vapi"
	_unparsed_size_ = unparsed_length1;
#line 11 "./uuid.vapi"
	_tmp2_ = id;
#line 11 "./uuid.vapi"
	_tmp2__length1 = id_length1;
#line 11 "./uuid.vapi"
	uuid_generate (_tmp2_);
#line 12 "./uuid.vapi"
	_tmp3_ = id;
#line 12 "./uuid.vapi"
	_tmp3__length1 = id_length1;
#line 12 "./uuid.vapi"
	_tmp4_ = unparsed;
#line 12 "./uuid.vapi"
	_tmp4__length1 = unparsed_length1;
#line 12 "./uuid.vapi"
	uuid_unparse (_tmp3_, _tmp4_);
#line 13 "./uuid.vapi"
	_tmp5_ = unparsed;
#line 13 "./uuid.vapi"
	_tmp5__length1 = unparsed_length1;
#line 13 "./uuid.vapi"
	_tmp5_[50] = (guchar) '\0';
#line 13 "./uuid.vapi"
	_tmp6_ = _tmp5_[50];
#line 15 "./uuid.vapi"
	_tmp7_ = unparsed;
#line 15 "./uuid.vapi"
	_tmp7__length1 = unparsed_length1;
#line 15 "./uuid.vapi"
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 15 "./uuid.vapi"
	result = _tmp8_;
#line 15 "./uuid.vapi"
	unparsed = (g_free (unparsed), NULL);
#line 15 "./uuid.vapi"
	id = (g_free (id), NULL);
#line 15 "./uuid.vapi"
	return result;
#line 634 "rygel-root-device-factory.c"
}


static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error) {
	GUPnPXMLDoc* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GUPnPXMLDoc* _tmp2_ = NULL;
	GUPnPXMLDoc* doc;
	GUPnPXMLDoc* _tmp3_;
	RygelDescriptionFile* _tmp4_;
	RygelDescriptionFile* file;
	RygelDescriptionFile* _tmp5_;
	RygelPlugin* _tmp6_;
	RygelDescriptionFile* _tmp7_;
	RygelPlugin* _tmp8_;
	RygelDescriptionFile* _tmp9_;
	RygelPlugin* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	RygelDescriptionFile* _tmp13_;
	RygelPlugin* _tmp14_;
	RygelPluginCapabilities _tmp15_;
	RygelPluginCapabilities _tmp16_;
	RygelPlugin* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	RygelDescriptionFile* _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* udn;
	gboolean _tmp26_ = FALSE;
	const gchar* _tmp27_;
	gboolean _tmp29_;
	RygelDescriptionFile* _tmp35_;
	const gchar* _tmp36_;
	GError * _inner_error_ = NULL;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (desc_path != NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (template_path != NULL, NULL);
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = desc_path;
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = template_path;
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = rygel_root_device_factory_get_latest_doc (self, _tmp0_, _tmp1_, &_inner_error_);
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	doc = _tmp2_;
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 693 "rygel-root-device-factory.c"
	}
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = doc;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp4_ = rygel_description_file_new_from_xml_document (_tmp3_);
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	file = _tmp4_;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp5_ = file;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp6_ = plugin;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_add_services_to_desc (self, _tmp5_, _tmp6_);
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp7_ = file;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp8_ = plugin;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_add_icons_to_desc (self, _tmp7_, _tmp8_);
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp9_ = file;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp10_ = plugin;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp11_ = rygel_root_device_factory_get_friendly_name (self, _tmp10_);
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp12_ = _tmp11_;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_description_file_set_friendly_name (_tmp9_, _tmp12_);
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (_tmp12_);
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp13_ = file;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp14_ = plugin;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp15_ = rygel_plugin_get_capabilities (_tmp14_);
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp16_ = _tmp15_;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_description_file_set_dlna_caps (_tmp13_, _tmp16_);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp17_ = plugin;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp18_ = rygel_plugin_get_description (_tmp17_);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp19_ = _tmp18_;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp19_ != NULL) {
#line 743 "rygel-root-device-factory.c"
		RygelDescriptionFile* _tmp20_;
		RygelPlugin* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp20_ = file;
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp21_ = plugin;
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp22_ = rygel_plugin_get_description (_tmp21_);
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp23_ = _tmp22_;
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		rygel_description_file_set_model_description (_tmp20_, _tmp23_);
#line 758 "rygel-root-device-factory.c"
	}
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp24_ = file;
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp25_ = rygel_description_file_get_udn (_tmp24_);
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	udn = _tmp25_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp27_ = udn;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp27_ == NULL) {
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp26_ = TRUE;
#line 772 "rygel-root-device-factory.c"
	} else {
		const gchar* _tmp28_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp28_ = udn;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp26_ = g_strcmp0 (_tmp28_, "") == 0;
#line 779 "rygel-root-device-factory.c"
	}
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp29_ = _tmp26_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp29_) {
#line 785 "rygel-root-device-factory.c"
		RygelDescriptionFile* _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp30_ = file;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp31_ = uuid_get ();
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp32_ = _tmp31_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp33_ = g_strconcat ("uuid:", _tmp32_, NULL);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp34_ = _tmp33_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		rygel_description_file_set_udn (_tmp30_, _tmp34_);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp34_);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp32_);
#line 807 "rygel-root-device-factory.c"
	}
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp35_ = file;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp36_ = desc_path;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_description_file_save (_tmp35_, _tmp36_, &_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (udn);
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (doc);
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 827 "rygel-root-device-factory.c"
	}
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = doc;
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (udn);
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 837 "rygel-root-device-factory.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 850 "rygel-root-device-factory.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 880 "rygel-root-device-factory.c"
				goto __catch3_g_regex_error;
			}
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			return NULL;
#line 889 "rygel-root-device-factory.c"
		}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 905 "rygel-root-device-factory.c"
				goto __catch3_g_regex_error;
			}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			return NULL;
#line 916 "rygel-root-device-factory.c"
		}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 924 "rygel-root-device-factory.c"
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1247 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 938 "rygel-root-device-factory.c"
	}
	__finally3:
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return NULL;
#line 949 "rygel-root-device-factory.c"
	}
}


static gchar* rygel_root_device_factory_get_friendly_name (RygelRootDeviceFactory* self, RygelPlugin* plugin) {
	gchar* result = NULL;
	gchar* title = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 971 "rygel-root-device-factory.c"
	{
		RygelConfiguration* _tmp0_;
		RygelPlugin* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp0_ = self->priv->config;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp1_ = plugin;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp2_ = rygel_plugin_get_name (_tmp1_);
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp3_ = _tmp2_;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = rygel_configuration_get_title (_tmp0_, _tmp3_, &_inner_error_);
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp5_ = _tmp4_;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		if (_inner_error_ != NULL) {
#line 993 "rygel-root-device-factory.c"
			goto __catch2_g_error;
		}
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (title);
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		title = _tmp5_;
#line 1000 "rygel-root-device-factory.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		RygelPlugin* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		err = _inner_error_;
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_inner_error_ = NULL;
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp6_ = plugin;
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp7_ = rygel_plugin_get_title (_tmp6_);
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp8_ = _tmp7_;
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (title);
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		title = _tmp9_;
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_error_free0 (err);
#line 1028 "rygel-root-device-factory.c"
	}
	__finally2:
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (title);
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_clear_error (&_inner_error_);
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 1041 "rygel-root-device-factory.c"
	}
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp10_ = title;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp11_ = g_get_real_name ();
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp12_ = string_replace (_tmp10_, "@REALNAME@", _tmp11_);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	title = _tmp12_;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp13_ = title;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp14_ = g_get_user_name ();
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp15_ = string_replace (_tmp13_, "@USERNAME@", _tmp14_);
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	title = _tmp15_;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp16_ = title;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp17_ = g_get_host_name ();
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp18_ = string_replace (_tmp16_, "@HOSTNAME@", _tmp17_);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	title = _tmp18_;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = title;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 1077 "rygel-root-device-factory.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return self ? g_object_ref (self) : NULL;
#line 1084 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin) {
	RygelDescriptionFile* _tmp0_;
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (file != NULL);
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = file;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_description_file_clear_service_list (_tmp0_);
#line 1100 "rygel-root-device-factory.c"
	{
		RygelPlugin* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _resource_info_list;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _resource_info_size;
		gint _resource_info_index;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp1_ = plugin;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp2_ = rygel_plugin_get_resource_infos (_tmp1_);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp3_ = _tmp2_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_resource_info_list = _tmp4_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp5_ = _resource_info_list;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp7_ = _tmp6_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_resource_info_size = _tmp7_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_resource_info_index = -1;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		while (TRUE) {
#line 1134 "rygel-root-device-factory.c"
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			RygelResourceInfo* resource_info;
			RygelResourceInfo* _tmp14_;
			GType _tmp15_;
			gboolean _tmp16_ = FALSE;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp8_ = _resource_info_index;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_resource_info_index = _tmp8_ + 1;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp9_ = _resource_info_index;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp10_ = _resource_info_size;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				break;
#line 1157 "rygel-root-device-factory.c"
			}
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp11_ = _resource_info_list;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp12_ = _resource_info_index;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			resource_info = (RygelResourceInfo*) _tmp13_;
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp14_ = resource_info;
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp15_ = _tmp14_->type;
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp16_ = g_type_is_a (_tmp15_, gupnp_service_get_type ());
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (_tmp16_) {
#line 1175 "rygel-root-device-factory.c"
				RygelDescriptionFile* _tmp17_;
				RygelPlugin* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				RygelResourceInfo* _tmp21_;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp17_ = file;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp18_ = plugin;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp19_ = rygel_plugin_get_name (_tmp18_);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp20_ = _tmp19_;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp21_ = resource_info;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				rygel_description_file_add_service (_tmp17_, _tmp20_, _tmp21_);
#line 1193 "rygel-root-device-factory.c"
			}
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_rygel_resource_info_unref0 (resource_info);
#line 1197 "rygel-root-device-factory.c"
		}
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (_resource_info_list);
#line 1201 "rygel-root-device-factory.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1225 "rygel-root-device-factory.c"
		glong _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1233 "rygel-root-device-factory.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1245 "rygel-root-device-factory.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1168 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1270 "rygel-root-device-factory.c"
		glong _tmp2_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1276 "rygel-root-device-factory.c"
	} else {
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1280 "rygel-root-device-factory.c"
	}
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 1286 "rygel-root-device-factory.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 1298 "rygel-root-device-factory.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 1308 "rygel-root-device-factory.c"
	}
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 1314 "rygel-root-device-factory.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 1328 "rygel-root-device-factory.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 1338 "rygel-root-device-factory.c"
	}
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 1344 "rygel-root-device-factory.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 1353 "rygel-root-device-factory.c"
	}
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1373 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin) {
	RygelPlugin* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* icons;
	gboolean _tmp4_ = FALSE;
	GeeArrayList* _tmp5_;
	gboolean _tmp9_;
	RygelDescriptionFile* _tmp17_;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (file != NULL);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = plugin;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = rygel_plugin_get_icon_infos (_tmp0_);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = _tmp1_;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	icons = _tmp3_;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp5_ = icons;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp5_ == NULL) {
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = TRUE;
#line 1409 "rygel-root-device-factory.c"
	} else {
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp6_ = icons;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp8_ = _tmp7_;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = _tmp8_ == 0;
#line 1422 "rygel-root-device-factory.c"
	}
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp9_ = _tmp4_;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp9_) {
#line 1428 "rygel-root-device-factory.c"
		RygelPlugin* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		RygelPlugin* _tmp13_;
		GeeArrayList* _tmp14_;
		GeeArrayList* _tmp15_;
		GeeArrayList* _tmp16_;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp10_ = plugin;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp11_ = rygel_plugin_get_name (_tmp10_);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp12_ = _tmp11_;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_debug ("rygel-root-device-factory.vala:148: No icon provided by plugin '%s'. U" \
"sing Rygel logo.", _tmp12_);
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp13_ = plugin;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp14_ = rygel_plugin_get_default_icons (_tmp13_);
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp15_ = _tmp14_;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp16_ = _g_object_ref0 (_tmp15_);
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (icons);
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		icons = _tmp16_;
#line 1456 "rygel-root-device-factory.c"
	}
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp17_ = file;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_description_file_clear_icon_list (_tmp17_);
#line 1462 "rygel-root-device-factory.c"
	{
		GeeArrayList* _tmp18_;
		GeeArrayList* _tmp19_;
		GeeArrayList* _icon_list;
		GeeArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _icon_size;
		gint _icon_index;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp18_ = icons;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_icon_list = _tmp19_;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp20_ = _icon_list;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp22_ = _tmp21_;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_icon_size = _tmp22_;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_icon_index = -1;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		while (TRUE) {
#line 1490 "rygel-root-device-factory.c"
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			GeeArrayList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_ = NULL;
			RygelIconInfo* icon;
			RygelIconInfo* _tmp29_;
			RygelPlugin* _tmp30_;
			gchar* _tmp31_ = NULL;
			gchar* remote_path;
			RygelIconInfo* _tmp32_;
			const gchar* _tmp33_;
			gboolean _tmp34_ = FALSE;
			RygelDescriptionFile* _tmp41_;
			RygelPlugin* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			RygelIconInfo* _tmp45_;
			const gchar* _tmp46_;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp23_ = _icon_index;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_icon_index = _tmp23_ + 1;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp24_ = _icon_index;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp25_ = _icon_size;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (!(_tmp24_ < _tmp25_)) {
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				break;
#line 1523 "rygel-root-device-factory.c"
			}
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp26_ = _icon_list;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp27_ = _icon_index;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _tmp27_);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			icon = (RygelIconInfo*) _tmp28_;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp29_ = icon;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp30_ = plugin;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp31_ = rygel_root_device_factory_get_icon_remote_path (self, _tmp29_, _tmp30_);
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			remote_path = _tmp31_;
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp32_ = icon;
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp33_ = _tmp32_->uri;
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp34_ = g_str_has_prefix (_tmp33_, "file://");
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (_tmp34_) {
#line 1549 "rygel-root-device-factory.c"
				RygelIconInfo* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_ = NULL;
				gchar* local_path;
				GUPnPContext* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp35_ = icon;
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp36_ = _tmp35_->uri;
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp37_ = string_substring (_tmp36_, (glong) 7, (glong) (-1));
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				local_path = _tmp37_;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp38_ = self->priv->_context;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp39_ = local_path;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp40_ = remote_path;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				gupnp_context_host_path (_tmp38_, _tmp39_, _tmp40_);
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_g_free0 (local_path);
#line 1575 "rygel-root-device-factory.c"
			}
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp41_ = file;
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp42_ = plugin;
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp43_ = rygel_plugin_get_name (_tmp42_);
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp44_ = _tmp43_;
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp45_ = icon;
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp46_ = remote_path;
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			rygel_description_file_add_icon (_tmp41_, _tmp44_, _tmp45_, _tmp46_);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_free0 (remote_path);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_rygel_icon_info_unref0 (icon);
#line 1595 "rygel-root-device-factory.c"
		}
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (_icon_list);
#line 1599 "rygel-root-device-factory.c"
	}
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (icons);
#line 1603 "rygel-root-device-factory.c"
}


static gchar* rygel_root_device_factory_get_icon_remote_path (RygelRootDeviceFactory* self, RygelIconInfo* icon_info, RygelPlugin* plugin) {
	gchar* result = NULL;
	RygelIconInfo* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 166 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 166 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (icon_info != NULL, NULL);
#line 166 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = icon_info;
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = _tmp0_->uri;
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = g_str_has_prefix (_tmp1_, "file://");
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp2_) {
#line 1626 "rygel-root-device-factory.c"
		RygelPlugin* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		RygelIconInfo* _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		RygelIconInfo* _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		RygelIconInfo* _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		RygelIconInfo* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp3_ = plugin;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = rygel_plugin_get_name (_tmp3_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp5_ = _tmp4_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp6_ = g_strconcat ("/", _tmp5_, NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp7_ = _tmp6_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp8_ = g_strconcat (_tmp7_, "-", NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp9_ = _tmp8_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp10_ = icon_info;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp11_ = _tmp10_->width;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp13_ = _tmp12_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp15_ = _tmp14_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp16_ = g_strconcat (_tmp15_, "x", NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp17_ = _tmp16_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp18_ = icon_info;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp19_ = _tmp18_->height;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp21_ = _tmp20_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp22_ = g_strconcat (_tmp17_, _tmp21_, NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp23_ = _tmp22_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp24_ = g_strconcat (_tmp23_, "x", NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp25_ = _tmp24_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp26_ = icon_info;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp27_ = _tmp26_->depth;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp29_ = _tmp28_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp30_ = g_strconcat (_tmp25_, _tmp29_, NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp31_ = _tmp30_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp32_ = g_strconcat (_tmp31_, ".", NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp33_ = _tmp32_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp34_ = icon_info;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp35_ = _tmp34_->file_extension;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp36_ = g_strconcat (_tmp33_, _tmp35_, NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp37_ = _tmp36_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp33_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp31_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp29_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp25_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp23_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp21_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp17_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp15_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp13_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp9_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp7_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		result = _tmp37_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return result;
#line 1758 "rygel-root-device-factory.c"
	} else {
		RygelIconInfo* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* uri;
		const gchar* _tmp41_;
		GUPnPContext* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_;
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp38_ = icon_info;
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp39_ = _tmp38_->uri;
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp40_ = g_strdup (_tmp39_);
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		uri = _tmp40_;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp41_ = uri;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp42_ = self->priv->_context;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp43_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp42_);
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp44_ = _tmp43_;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp45_ = string_replace (_tmp41_, "@ADDRESS@", _tmp44_);
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp46_ = _tmp45_;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp46_);
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		result = uri;
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return result;
#line 1796 "rygel-root-device-factory.c"
	}
}


static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error) {
	GUPnPXMLDoc* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp7_;
	GFileInfo* _tmp8_ = NULL;
	GFileInfo* info;
	GFileInfo* _tmp9_;
	guint64 _tmp10_ = 0ULL;
	guint64 mod1;
	const gchar* _tmp11_;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_;
	GFileInfo* _tmp14_ = NULL;
	GFileInfo* _tmp15_;
	GFileInfo* _tmp16_;
	guint64 _tmp17_ = 0ULL;
	guint64 mod2;
	guint64 _tmp18_;
	guint64 _tmp19_;
	GError * _inner_error_ = NULL;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (path1 != NULL, NULL);
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (path2 != NULL, NULL);
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = path1;
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	file = _tmp1_;
#line 185 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = file;
#line 185 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
#line 185 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (!_tmp3_) {
#line 1843 "rygel-root-device-factory.c"
		const gchar* _tmp4_;
		GUPnPXMLDoc* _tmp5_;
		GUPnPXMLDoc* _tmp6_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = path2;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp5_ = gupnp_xml_doc_new_from_path (_tmp4_, &_inner_error_);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp6_ = _tmp5_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		if (_inner_error_ != NULL) {
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			g_propagate_error (error, _inner_error_);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return NULL;
#line 1861 "rygel-root-device-factory.c"
		}
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		result = _tmp6_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return result;
#line 1869 "rygel-root-device-factory.c"
	}
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp7_ = file;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp8_ = g_file_query_info (_tmp7_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	info = _tmp8_;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 1885 "rygel-root-device-factory.c"
	}
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp9_ = info;
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp10_ = g_file_info_get_attribute_uint64 (_tmp9_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	mod1 = _tmp10_;
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp11_ = path2;
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp12_ = g_file_new_for_path (_tmp11_);
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	file = _tmp12_;
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp13_ = file;
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp14_ = g_file_query_info (_tmp13_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp15_ = _tmp14_;
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (info);
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 1917 "rygel-root-device-factory.c"
	}
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (info);
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	info = _tmp15_;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp16_ = info;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp17_ = g_file_info_get_attribute_uint64 (_tmp16_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	mod2 = _tmp17_;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp18_ = mod1;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp19_ = mod2;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp18_ > _tmp19_) {
#line 1935 "rygel-root-device-factory.c"
		{
			const gchar* _tmp20_;
			GUPnPXMLDoc* _tmp21_;
			GUPnPXMLDoc* _tmp22_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp20_ = path1;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp21_ = gupnp_xml_doc_new_from_path (_tmp20_, &_inner_error_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp22_ = _tmp21_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (_inner_error_ != NULL) {
#line 1948 "rygel-root-device-factory.c"
				goto __catch4_g_error;
			}
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			result = _tmp22_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (info);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return result;
#line 1959 "rygel-root-device-factory.c"
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp23_;
			GUPnPXMLDoc* _tmp24_;
			GUPnPXMLDoc* _tmp25_;
#line 201 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_error_ = _inner_error_;
#line 201 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_inner_error_ = NULL;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp23_ = path2;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp24_ = gupnp_xml_doc_new_from_path (_tmp23_, &_inner_error_);
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp25_ = _tmp24_;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (_inner_error_ != NULL) {
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_g_error_free0 (_error_);
#line 1982 "rygel-root-device-factory.c"
				goto __finally4;
			}
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			result = _tmp25_;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_error_free0 (_error_);
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (info);
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return result;
#line 1995 "rygel-root-device-factory.c"
		}
		__finally4:
#line 201 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 201 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (info);
#line 201 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 201 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 2006 "rygel-root-device-factory.c"
	} else {
		const gchar* _tmp26_;
		GUPnPXMLDoc* _tmp27_;
		GUPnPXMLDoc* _tmp28_;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp26_ = path2;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp27_ = gupnp_xml_doc_new_from_path (_tmp26_, &_inner_error_);
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp28_ = _tmp27_;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		if (_inner_error_ != NULL) {
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			g_propagate_error (error, _inner_error_);
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (info);
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return NULL;
#line 2027 "rygel-root-device-factory.c"
		}
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		result = _tmp28_;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (info);
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return result;
#line 2037 "rygel-root-device-factory.c"
	}
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (info);
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 2043 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error) {
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
#line 211 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 211 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (dir_path != NULL);
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = dir_path;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	file = _tmp1_;
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = file;
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (!_tmp3_) {
#line 2070 "rygel-root-device-factory.c"
		GFile* _tmp4_;
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = file;
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_file_make_directory (_tmp4_, NULL, &_inner_error_);
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		if (_inner_error_ != NULL) {
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			g_propagate_error (error, _inner_error_);
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return;
#line 2084 "rygel-root-device-factory.c"
		}
	}
#line 211 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 2089 "rygel-root-device-factory.c"
}


GUPnPContext* rygel_root_device_factory_get_context (RygelRootDeviceFactory* self) {
	GUPnPContext* result;
	GUPnPContext* _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = self->priv->_context;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 2104 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_set_context (RygelRootDeviceFactory* self, GUPnPContext* value) {
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = value;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (self->priv->_context);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self->priv->_context = _tmp1_;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_object_notify ((GObject *) self, "context");
#line 2123 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_class_init (RygelRootDeviceFactoryClass * klass) {
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_parent_class = g_type_class_peek_parent (klass);
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_type_class_add_private (klass, sizeof (RygelRootDeviceFactoryPrivate));
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_root_device_factory_get_property;
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_root_device_factory_set_property;
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_root_device_factory_finalize;
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ROOT_DEVICE_FACTORY_CONTEXT, g_param_spec_object ("context", "context", "context", gupnp_context_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2140 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_g_initable_interface_init (GInitableIface * iface) {
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_g_initable_parent_iface = g_type_interface_peek_parent (iface);
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	iface->init = (gboolean (*)(GInitable*, GCancellable*, GError**)) rygel_root_device_factory_real_init;
#line 2149 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_instance_init (RygelRootDeviceFactory * self) {
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self->priv = RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE (self);
#line 2156 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_finalize (GObject* obj) {
	RygelRootDeviceFactory * self;
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (self->priv->_context);
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (self->priv->config);
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (self->priv->desc_dir);
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	G_OBJECT_CLASS (rygel_root_device_factory_parent_class)->finalize (obj);
#line 2172 "rygel-root-device-factory.c"
}


/**
 * This is a factory to create #RygelRootDevice objects for
 * a given UPnP context.
 *
 * Call rygel_root_device_factory_create() with a plugin
 * to create a root device for the plugin.
 */
GType rygel_root_device_factory_get_type (void) {
	static volatile gsize rygel_root_device_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_root_device_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRootDeviceFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_root_device_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRootDeviceFactory), 0, (GInstanceInitFunc) rygel_root_device_factory_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) rygel_root_device_factory_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_root_device_factory_type_id;
		rygel_root_device_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelRootDeviceFactory", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_root_device_factory_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&rygel_root_device_factory_type_id__volatile, rygel_root_device_factory_type_id);
	}
	return rygel_root_device_factory_type_id__volatile;
}


static void _vala_rygel_root_device_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	switch (property_id) {
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		case RYGEL_ROOT_DEVICE_FACTORY_CONTEXT:
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_value_set_object (value, rygel_root_device_factory_get_context (self));
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		break;
#line 2208 "rygel-root-device-factory.c"
		default:
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		break;
#line 2214 "rygel-root-device-factory.c"
	}
}


static void _vala_rygel_root_device_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	switch (property_id) {
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		case RYGEL_ROOT_DEVICE_FACTORY_CONTEXT:
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		rygel_root_device_factory_set_context (self, g_value_get_object (value));
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		break;
#line 2230 "rygel-root-device-factory.c"
		default:
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		break;
#line 2236 "rygel-root-device-factory.c"
	}
}



