/* cheese-effects-manager.c generated by valac 0.12.0, the Vala compiler
 * generated from cheese-effects-manager.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <cheese-effect.h>
#include <locale.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>


#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GeeArrayList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_effects_manager_parent_class = NULL;

#define GROUP_NAME "Effect"
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
enum  {
	CHEESE_EFFECTS_MANAGER_DUMMY_PROPERTY
};
CheeseEffect* cheese_effects_manager_parse_effect_file (const gchar* filename);
static GeeArrayList* cheese_effects_manager_load_effects_from_directory (CheeseEffectsManager* self, const gchar* directory);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
static gboolean cheese_effects_manager_cmp_value (CheeseEffect* a, CheeseEffect* b);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static gint cheese_effects_manager_sort_value (CheeseEffect* a, CheeseEffect* b);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name);
static void cheese_effects_manager_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);


CheeseEffect* cheese_effects_manager_parse_effect_file (const gchar* filename) {
	CheeseEffect* result = NULL;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* kf;
	CheeseEffect* _tmp1_ = NULL;
	CheeseEffect* eff;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* locale;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = g_key_file_new ();
	kf = _tmp0_;
	_tmp1_ = cheese_effect_new ();
	eff = _tmp1_;
	_tmp2_ = setlocale (LC_ALL, "");
	_tmp3_ = g_strdup (_tmp2_);
	locale = _tmp3_;
	g_key_file_load_from_file (kf, filename, G_KEY_FILE_NONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch11_g_key_file_error;
		}
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch11_g_file_error;
		}
		_g_free0 (locale);
		_g_object_unref0 (eff);
		_g_key_file_free0 (kf);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_key_file_get_locale_string (kf, GROUP_NAME, "Name", locale, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch11_g_key_file_error;
		}
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch11_g_file_error;
		}
		_g_free0 (locale);
		_g_object_unref0 (eff);
		_g_key_file_free0 (kf);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = _tmp5_;
	g_object_set (eff, "name", _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_tmp7_ = g_key_file_get_string (kf, GROUP_NAME, "PipelineDescription", &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch11_g_key_file_error;
		}
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch11_g_file_error;
		}
		_g_free0 (locale);
		_g_object_unref0 (eff);
		_g_key_file_free0 (kf);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = _tmp8_;
	g_object_set (eff, "pipeline-desc", _tmp9_, NULL);
	_g_free0 (_tmp9_);
	goto __finally11;
	__catch11_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("cheese-effects-manager.vala:43: Error: %s\n", err->message);
		result = NULL;
		_g_error_free0 (err);
		_g_free0 (locale);
		_g_object_unref0 (eff);
		_g_key_file_free0 (kf);
		return result;
	}
	goto __finally11;
	__catch11_g_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("cheese-effects-manager.vala:48: Error: %s\n", err->message);
		result = NULL;
		_g_error_free0 (err);
		_g_free0 (locale);
		_g_object_unref0 (eff);
		_g_key_file_free0 (kf);
		return result;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_free0 (locale);
		_g_object_unref0 (eff);
		_g_key_file_free0 (kf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = eff;
	_g_free0 (locale);
	_g_key_file_free0 (kf);
	return result;
}


static GeeArrayList* cheese_effects_manager_load_effects_from_directory (CheeseEffectsManager* self, const gchar* directory) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* list;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	_tmp0_ = gee_array_list_new (CHEESE_TYPE_EFFECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	list = _tmp0_;
	_tmp1_ = g_file_test (directory, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR);
	if (_tmp1_) {
		GDir* dir = NULL;
		gchar* cur_file = NULL;
		GDir* _tmp2_ = NULL;
		GDir* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp2_ = g_dir_open (directory, (guint) 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch12_g_file_error;
			}
			_g_free0 (cur_file);
			_g_dir_close0 (dir);
			_g_object_unref0 (list);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_dir_close0 (dir);
		dir = _tmp3_;
		goto __finally12;
		__catch12_g_file_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("cheese-effects-manager.vala:71: Error: %s\n", err->message);
			result = NULL;
			_g_error_free0 (err);
			_g_free0 (cur_file);
			_g_dir_close0 (dir);
			_g_object_unref0 (list);
			return result;
		}
		__finally12:
		if (_inner_error_ != NULL) {
			_g_free0 (cur_file);
			_g_dir_close0 (dir);
			_g_object_unref0 (list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = g_dir_read_name (dir);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (cur_file);
		cur_file = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			if (!(cur_file != NULL)) {
				break;
			}
			_tmp6_ = g_str_has_suffix (cur_file, ".effect");
			if (_tmp6_) {
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				CheeseEffect* _tmp9_ = NULL;
				CheeseEffect* _tmp10_;
				CheeseEffect* effect;
				gboolean _tmp11_;
				_tmp7_ = g_build_filename (directory, cur_file, NULL);
				_tmp8_ = _tmp7_;
				_tmp9_ = cheese_effects_manager_parse_effect_file (_tmp8_);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp8_);
				effect = _tmp10_;
				_tmp11_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->effects, effect);
				if (!_tmp11_) {
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					g_object_get (effect, "name", &_tmp12_, NULL);
					_tmp13_ = _tmp12_;
					g_object_get (effect, "pipeline-desc", &_tmp14_, NULL);
					_tmp15_ = _tmp14_;
					g_message ("cheese-effects-manager.vala:84: Found %s (%s)", _tmp13_, _tmp15_);
					_g_free0 (_tmp15_);
					_g_free0 (_tmp13_);
					gee_abstract_collection_add ((GeeAbstractCollection*) list, effect);
				}
				_g_object_unref0 (effect);
			}
			_tmp16_ = g_dir_read_name (dir);
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (cur_file);
			cur_file = _tmp17_;
		}
		_g_free0 (cur_file);
		_g_dir_close0 (dir);
	}
	result = list;
	return result;
}


CheeseEffectsManager* cheese_effects_manager_construct (GType object_type) {
	CheeseEffectsManager * self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	self = (CheeseEffectsManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (CHEESE_TYPE_EFFECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GEqualFunc) cheese_effects_manager_cmp_value);
	_g_object_unref0 (self->effects);
	self->effects = _tmp0_;
	return self;
}


CheeseEffectsManager* cheese_effects_manager_new (void) {
	return cheese_effects_manager_construct (CHEESE_TYPE_EFFECTS_MANAGER);
}


void cheese_effects_manager_load_effects (CheeseEffectsManager* self) {
	gchar* system_effects = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* user_effects;
	GeeArrayList* _tmp8_ = NULL;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _tmp0_ = g_get_system_data_dirs ();
	{
		gchar** dir_collection;
		int dir_collection_length1;
		int dir_it;
		dir_collection = _tmp1_;
		dir_collection_length1 = _vala_array_length (_tmp0_);
		for (dir_it = 0; dir_it < _vala_array_length (_tmp0_); dir_it = dir_it + 1) {
			gchar* _tmp2_;
			gchar* dir;
			_tmp2_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp2_;
			{
				gchar* _tmp3_ = NULL;
				GeeArrayList* _tmp4_ = NULL;
				GeeArrayList* _tmp5_;
				_tmp3_ = g_build_filename (dir, "gnome-video-effects", NULL);
				_g_free0 (system_effects);
				system_effects = _tmp3_;
				_tmp4_ = cheese_effects_manager_load_effects_from_directory (self, system_effects);
				_tmp5_ = _tmp4_;
				gee_abstract_collection_add_all ((GeeAbstractCollection*) self->effects, (GeeCollection*) _tmp5_);
				_g_object_unref0 (_tmp5_);
				_g_free0 (dir);
			}
		}
	}
	_tmp6_ = g_get_user_data_dir ();
	_tmp7_ = g_build_filename (_tmp6_, "gnome-video-effects", NULL);
	user_effects = _tmp7_;
	_tmp8_ = cheese_effects_manager_load_effects_from_directory (self, user_effects);
	_tmp9_ = _tmp8_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) self->effects, (GeeCollection*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	gee_list_sort ((GeeList*) self->effects, (GCompareFunc) cheese_effects_manager_sort_value);
	_tmp10_ = gee_collection_get_size ((GeeCollection*) self->effects);
	if (_tmp10_ > 0) {
		CheeseEffect* _tmp11_ = NULL;
		CheeseEffect* e;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = cheese_effect_new ();
		e = _tmp11_;
		_tmp12_ = _ ("No Effect");
		g_object_set (e, "name", _tmp12_, NULL);
		g_object_set (e, "pipeline-desc", "identity", NULL);
		gee_abstract_list_insert ((GeeAbstractList*) self->effects, 0, e);
		_g_object_unref0 (e);
	}
	_g_free0 (user_effects);
	_g_free0 (system_effects);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name) {
	CheeseEffect* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _eff_list;
		gint _tmp1_;
		gint _eff_size;
		gint _eff_index;
		_tmp0_ = _g_object_ref0 (self->effects);
		_eff_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _eff_list);
		_eff_size = _tmp1_;
		_eff_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			CheeseEffect* eff;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gboolean _tmp5_;
			_eff_index = _eff_index + 1;
			if (!(_eff_index < _eff_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _eff_list, _eff_index);
			eff = (CheeseEffect*) _tmp2_;
			g_object_get (eff, "name", &_tmp3_, NULL);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strcmp0 (_tmp4_, name) == 0;
			_g_free0 (_tmp4_);
			if (_tmp5_) {
				result = eff;
				_g_object_unref0 (_eff_list);
				return result;
			}
			_g_object_unref0 (eff);
		}
		_g_object_unref0 (_eff_list);
	}
	result = NULL;
	return result;
}


static gboolean cheese_effects_manager_cmp_value (CheeseEffect* a, CheeseEffect* b) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	g_object_get (a, "pipeline-desc", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	g_object_get (b, "pipeline-desc", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}


static gint cheese_effects_manager_sort_value (CheeseEffect* a, CheeseEffect* b) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	g_object_get (a, "name", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) (-1));
	_tmp3_ = _tmp2_;
	g_object_get (b, "name", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) (-1));
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strcmp0 (_tmp3_, _tmp7_) < 0;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (_tmp8_) {
		result = -1;
		return result;
	} else {
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gboolean _tmp17_;
		g_object_get (a, "name", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) (-1));
		_tmp12_ = _tmp11_;
		g_object_get (b, "name", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_utf8_strdown (_tmp14_, (gssize) (-1));
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strcmp0 (_tmp12_, _tmp16_) > 0;
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		if (_tmp17_) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static void cheese_effects_manager_class_init (CheeseEffectsManagerClass * klass) {
	cheese_effects_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = cheese_effects_manager_finalize;
}


static void cheese_effects_manager_instance_init (CheeseEffectsManager * self) {
}


static void cheese_effects_manager_finalize (GObject* obj) {
	CheeseEffectsManager * self;
	self = CHEESE_EFFECTS_MANAGER (obj);
	_g_object_unref0 (self->effects);
	G_OBJECT_CLASS (cheese_effects_manager_parent_class)->finalize (obj);
}


GType cheese_effects_manager_get_type (void) {
	static volatile gsize cheese_effects_manager_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_effects_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseEffectsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_effects_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseEffectsManager), 0, (GInstanceInitFunc) cheese_effects_manager_instance_init, NULL };
		GType cheese_effects_manager_type_id;
		cheese_effects_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "CheeseEffectsManager", &g_define_type_info, 0);
		g_once_init_leave (&cheese_effects_manager_type_id__volatile, cheese_effects_manager_type_id);
	}
	return cheese_effects_manager_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



