/* libanjuta.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Anjuta", lower_case_cprefix = "anjuta_", gir_namespace = "Anjuta", gir_version = "3.0")]
namespace Anjuta {
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class AsyncCommand : Anjuta.Command {
		public static string get_error_message (Anjuta.Command command);
		public void @lock ();
		public static void set_error_message (Anjuta.Command command, string error_message);
		public void unlock ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class AsyncNotify : GLib.Object {
		[CCode (has_construct_function = false)]
		public AsyncNotify ();
		public void get_error () throws GLib.Error;
		public void notify_finished ();
		public void set_error (GLib.Error error);
		public virtual signal void finished ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class CModule : GLib.TypeModule, GLib.TypePlugin {
		[CCode (cname = "anjuta_c_module_new", has_construct_function = false)]
		public CModule (string path, string name);
		[CCode (cname = "anjuta_c_module_get_last_error")]
		public bool get_last_error () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class CPluginFactory : GLib.Object {
		[CCode (cname = "anjuta_c_plugin_factory_new", has_construct_function = false)]
		public CPluginFactory ();
		[CCode (cname = "anjuta_c_plugin_factory_free")]
		public void free ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class CellRendererCaptionedImage : Gtk.CellRenderer {
		public weak Gtk.CellRenderer caption;
		public weak Gtk.CellRenderer image;
		[CCode (type = "GtkCellRenderer*", has_construct_function = false)]
		public CellRendererCaptionedImage ();
		[NoAccessorMethod]
		public Gdk.Pixbuf pixbuf { owned get; set; }
		[NoAccessorMethod]
		public string text { owned get; set; }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ColumnTextView : Gtk.VBox, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public ColumnTextView ();
		public string get_text ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Command : GLib.Object {
		public virtual void cancel ();
		public virtual string get_error_message ();
		public bool is_running ();
		public virtual void notify_complete (uint return_code);
		public virtual void notify_data_arrived ();
		public virtual void notify_progress (float progress);
		[NoWrapper]
		public virtual uint run ();
		public virtual void set_error_message (string error_message);
		public virtual void start ();
		public virtual bool start_automatic_monitor ();
		public virtual void stop_automatic_monitor ();
		public virtual signal void command_finished (uint return_code);
		public virtual signal void command_started ();
		public virtual signal void data_arrived ();
		public virtual signal void progress (float progress);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class CommandBar : Gtk.Notebook, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public CommandBar ();
		public void add_action_group (string group_name, Anjuta.CommandBarEntry entries, int num_entries, void* user_data);
		public void remove_action_group (string group_name);
		public void show_action_group (string group_name);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class CommandQueue : GLib.Object {
		[CCode (has_construct_function = false)]
		public CommandQueue (Anjuta.CommandQueueExecuteMode mode);
		public void push (Anjuta.Command command);
		public bool start ();
		public virtual signal void finished ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Dock : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Dock ();
		public void hide_pane (Anjuta.DockPane pane);
		public void remove_pane (Anjuta.DockPane pane);
		public void set_command_bar (Anjuta.CommandBar command_bar);
		public void show_pane (Anjuta.DockPane pane);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class DockPane : GLib.Object {
		public void notify_multiple_selection_changed ();
		public void notify_single_selection_changed ();
		public virtual void refresh ();
		[NoAccessorMethod]
		public Anjuta.Plugin plugin { owned get; set; }
		public virtual signal void multiple_selection_changed ();
		public virtual signal void single_selection_changed ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class DropEntry : Anjuta.Entry, Atk.Implementor, Gtk.Buildable, Gtk.CellEditable, Gtk.Editable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public DropEntry ();
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "anjuta_encoding_get_type ()", cheader_filename = "libanjuta/libanjuta.h")]
	public class Encoding {
		public Anjuta.Encoding copy ();
		public void free ();
		public unowned string get_charset ();
		public static unowned Anjuta.Encoding get_current ();
		public static unowned Anjuta.Encoding get_from_charset (string charset);
		public static unowned Anjuta.Encoding get_from_index (int index);
		public unowned string get_name ();
		public static unowned Anjuta.Encoding get_utf8 ();
		public string to_string ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Entry : Gtk.Entry, Atk.Implementor, Gtk.Buildable, Gtk.CellEditable, Gtk.Editable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Entry ();
		public string dup_text ();
		public unowned string get_text ();
		public bool is_showing_help_text ();
		public void set_text (string text);
		[NoAccessorMethod]
		public string help_text { owned get; set; }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class FileDropEntry : Anjuta.DropEntry, Atk.Implementor, Gtk.Buildable, Gtk.CellEditable, Gtk.Editable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public FileDropEntry ();
		public void set_relative_path (string path);
		[NoAccessorMethod]
		public string relative_path { }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class FileList : Gtk.VBox, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public FileList ();
		public void clear ();
		public void set_relative_path (string path);
		[NoAccessorMethod]
		public string relative_path { owned get; set; }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class GluePlugin : GLib.TypeModule {
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Launcher : GLib.Object {
		[CCode (has_construct_function = false)]
		public Launcher ();
		public int get_child_pid ();
		public bool is_busy ();
		public void reset ();
		public void send_ptyin (string input_str);
		public void send_stdin (string input_str);
		public void send_stdin_eof ();
		public bool set_buffered_output (bool buffered);
		public bool set_check_passwd_prompt (bool check_passwd);
		public void set_encoding (string charset);
		public bool set_terminal_echo (bool echo_on);
		public bool set_terminate_on_exit (bool terminate_on_exit);
		public void @signal (int sig);
		public virtual signal void busy (bool busy_flag);
		public virtual signal void child_exited (int child_pid, int exit_status, ulong time_taken_in_seconds);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class PkgConfigChooser : Gtk.TreeView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public PkgConfigChooser ();
		public string get_selected_package ();
		public void set_active_packages (GLib.List<weak void*> packages);
		public void show_active_column (bool show_column);
		public void show_active_only (bool show_selected);
		public virtual signal void package_activated (string package);
		public virtual signal void package_deactivated (string package);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Plugin : GLib.Object {
		public virtual bool activate ();
		public uint add_watch (string name, [CCode (delegate_target_pos = 3.1)] Anjuta.PluginValueAdded added, [CCode (delegate_target_pos = 3.1)] Anjuta.PluginValueRemoved removed);
		public virtual bool deactivate ();
		public bool is_active ();
		public void remove_watch (uint id, bool send_remove);
		[NoAccessorMethod]
		public Anjuta.Shell shell { owned get; set construct; }
		public virtual signal void activated ();
		public virtual signal void deactivated ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class PluginHandle : GLib.Object {
		[CCode (has_construct_function = false)]
		public PluginHandle (string plugin_desc_path);
		public unowned string get_about ();
		public bool get_can_load ();
		public bool get_checked ();
		public unowned string get_icon_path ();
		public unowned string get_id ();
		public unowned string get_language ();
		public unowned string get_name ();
		public unowned string get_path ();
		public bool get_resident ();
		public int get_resolve_pass ();
		public bool get_user_activatable ();
		public void set_can_load (bool can_load);
		public void set_checked (bool checked);
		public void set_resolve_pass (bool resolve_pass);
		public void unresolve_dependencies ();
		public string about { get; }
		public bool can_load { get; }
		public bool checked { get; }
		[NoAccessorMethod]
		public void* dependencies { get; }
		[NoAccessorMethod]
		public void* dependency_names { get; }
		[NoAccessorMethod]
		public void* dependents { get; }
		[NoAccessorMethod]
		public void* description { get; }
		public string icon_path { get; }
		public string id { get; }
		[NoAccessorMethod]
		public void* interfaces { get; }
		public string language { get; }
		public string name { get; }
		public string path { get; }
		public bool resident { get; }
		public int resolve_pass { get; }
		public bool user_activatable { get; }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class PluginManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public PluginManager (GLib.Object shell, Anjuta.Status status, GLib.List<weak void*> plugin_search_paths);
		public void activate_plugins (GLib.List<weak void*> plugin_descs);
		public static GLib.Quark error_quark ();
		public string get_remembered_plugins ();
		public bool is_active_plugin (string iface_name);
		public void set_remembered_plugins (string remembered_plugins);
		public void unload_all_plugins ();
		public bool unload_plugin (GLib.Object plugin);
		public bool unload_plugin_by_id (string plugin_id);
		[NoAccessorMethod]
		public void* activated_plugins { get; }
		[NoAccessorMethod]
		public void* available_plugins { get; }
		[NoAccessorMethod]
		public void* profiles { get; }
		[NoAccessorMethod]
		public GLib.Object shell { owned get; set construct; }
		[NoAccessorMethod]
		public Anjuta.Status status { owned get; set construct; }
		public virtual signal void plugin_activated (void* plugin_desc, Anjuta.Plugin plugin);
		public virtual signal void plugin_deactivated (void* plugin_desc, Anjuta.Plugin plugin);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Preferences : GLib.Object {
		[CCode (has_construct_function = false)]
		public Preferences (Anjuta.PluginManager plugin_manager);
		public void add_from_builder (Gtk.Builder builder, GLib.Settings settings, string glade_widget_name, string stitle, string icon_filename);
		public bool is_dialog_created ();
		public void register_all_properties_from_builder_xml (Gtk.Builder builder, GLib.Settings settings, Gtk.Widget parent);
		public bool register_property_from_string (GLib.Settings settings, Gtk.Widget object, string property_desc);
		public bool register_property_raw (GLib.Settings settings, Gtk.Widget object, string key, string default_value, uint flags, Anjuta.PropertyObjectType object_type, Anjuta.PropertyDataType data_type);
		public void remove_page (string page_name);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class PreferencesDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public PreferencesDialog ();
		public void add_page (string name, string title, Gdk.Pixbuf icon, Gtk.Widget page);
		public void remove_page (string title);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Profile : GLib.Object {
		[CCode (has_construct_function = false)]
		public Profile (string name, Anjuta.PluginManager plugin_manager);
		public void add_plugin (Anjuta.PluginDescription plugin);
		public bool add_plugins_from_xml (GLib.File profile_xml_file, bool exclude_from_sync) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public unowned string get_name ();
		public bool has_plugin (Anjuta.PluginDescription plugin);
		public void remove_plugin (Anjuta.PluginDescription plugin);
		public void set_sync_file (GLib.File sync_file);
		public bool sync () throws GLib.Error;
		[NoAccessorMethod]
		public Anjuta.PluginManager plugin_manager { owned get; set construct; }
		[NoAccessorMethod]
		public void* plugins { get; set construct; }
		[NoAccessorMethod]
		public string profile_name { owned get; set construct; }
		[NoAccessorMethod]
		public GLib.File sync_file { owned get; set construct; }
		public virtual signal void changed (void* plugins);
		public virtual signal void plugin_added (void* plugin);
		public virtual signal void plugin_removed (void* plugin);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProfileManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public ProfileManager (Anjuta.PluginManager plugin_manager);
		public void freeze ();
		public bool pop (string profile_name) throws GLib.Error;
		public bool push (Anjuta.Profile profile) throws GLib.Error;
		public bool thaw () throws GLib.Error;
		[NoAccessorMethod]
		public Anjuta.PluginManager plugin_manager { owned get; set construct; }
		public virtual signal void profile_descoped (Anjuta.Profile profile);
		public virtual signal void profile_popped (Anjuta.Profile profile);
		public virtual signal void profile_pushed (Anjuta.Profile profile);
		public virtual signal void profile_scoped (Anjuta.Profile profile);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectNode : GLib.InitiallyUnowned {
		public weak Anjuta.ProjectNode children;
		public weak GLib.List<weak void*> custom_properties;
		public weak GLib.List<weak void*> native_properties;
		public weak Anjuta.ProjectNode next;
		public weak Anjuta.ProjectNode parent;
		public weak Anjuta.ProjectNode prev;
		public void check ();
		public bool clear_state (Anjuta.ProjectNodeState state);
		public void dump ();
		public Anjuta.ProjectNodeType get_full_type ();
		public unowned string get_name ();
		public Anjuta.ProjectNodeType get_node_type ();
		public Anjuta.ProjectProperty get_property (Anjuta.ProjectProperty property);
		public Anjuta.ProjectNodeState get_state ();
		public unowned Anjuta.ProjectNode insert_after (Anjuta.ProjectNode? sibling, Anjuta.ProjectNode node);
		public unowned Anjuta.ProjectNode insert_before (Anjuta.ProjectNode? sibling, Anjuta.ProjectNode node);
		public Anjuta.ProjectProperty insert_property (Anjuta.ProjectProperty native, Anjuta.ProjectProperty property);
		public Anjuta.ProjectNode remove ();
		public Anjuta.ProjectProperty remove_property (Anjuta.ProjectProperty property);
		public bool set_state (Anjuta.ProjectNodeState state);
		[NoAccessorMethod]
		public GLib.File file { owned get; set; }
		public string name { get; set; }
		[NoAccessorMethod]
		public void* project { get; set; }
		public void* state { get; set; }
		[NoAccessorMethod]
		public void* type { get; set; }
		public virtual signal void loaded (void* object, GLib.Error p0);
		public virtual signal void updated (void* object, GLib.Error p0);
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "anjuta_project_node_info_get_type ()", cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectNodeInfo {
		public weak string mime_type;
		public weak string name;
		public Anjuta.ProjectNodeType type;
		public Anjuta.ProjectNodeInfo copy ();
		public void free ();
		public unowned string mime ();
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "anjuta_project_property_get_type ()", cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectProperty {
		public weak string detail;
		public Anjuta.ProjectPropertyFlags flags;
		public weak string name;
		public weak Anjuta.ProjectProperty native;
		public Anjuta.ProjectValueType type;
		public weak string value;
		public Anjuta.ProjectProperty copy ();
		public void free ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class SavePrompt : Gtk.MessageDialog, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public SavePrompt (Gtk.Window parent);
		public int get_items_count ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Serializer : GLib.Object {
		[CCode (has_construct_function = false)]
		public Serializer (string filepath, Anjuta.SerializerMode mode);
		public bool read_float (string name, float value);
		public bool read_int (string name, int value);
		public bool read_string (string name, string value, bool replace);
		public bool write_float (string name, float value);
		public bool write_int (string name, int value);
		public bool write_string (string name, string value);
		[NoAccessorMethod]
		public string filepath { owned get; construct; }
		[NoAccessorMethod]
		public Anjuta.SerializerMode mode { get; construct; }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Session : GLib.Object {
		[CCode (has_construct_function = false)]
		public Session (string session_directory);
		public void clear ();
		public void clear_section (string section);
		public float get_float (string section, string key);
		public int get_int (string section, string key);
		public unowned string get_session_directory ();
		public string get_session_filename ();
		public string get_string (string section, string key);
		public void set_float (string section, string key, float value);
		public void set_int (string section, string key, int value);
		public void set_string (string section, string key, string value);
		public void set_string_list (string section, string key, GLib.List<weak void*> value);
		public void sync ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Status : Gtk.HBox, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Status ();
		public void add_widget (Gtk.Widget widget);
		public void busy_pop ();
		public void busy_push ();
		public void clear_stack ();
		public void disable_splash (bool disable_splash);
		public void pop ();
		public void progress_add_ticks (int ticks);
		public void progress_increment_ticks (int ticks, string text);
		public void progress_pulse (string text);
		public void progress_reset ();
		public void progress_tick (Gdk.Pixbuf icon, string text);
		public void set_splash (string splash_file, int splash_progress_position);
		public void set_title (string title);
		public void set_title_window (Gtk.Widget window);
		public virtual signal void busy (bool state);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class SyncCommand : Anjuta.Command {
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Tabber : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Tabber (Gtk.Notebook notebook);
		public void add_tab (Gtk.Widget tab_label);
		[NoAccessorMethod]
		public GLib.Object notebook { construct; }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class TokenFile : GLib.Object {
		[CCode (has_construct_function = false)]
		public TokenFile (GLib.File file);
		public void free ();
		public bool get_token_location (Anjuta.TokenFileLocation location, Anjuta.Token token);
		public bool is_dirty ();
		public void move (GLib.File new_file);
		public bool save () throws GLib.Error;
		public bool unload ();
		public bool update (Anjuta.Token token);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class UI : Gtk.UIManager, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public UI ();
		public void activate_action_by_group (Gtk.ActionGroup action_group, string action_name);
		public void activate_action_by_path (string action_path);
		public void add_action_group (string action_group_name, string action_group_label, Gtk.ActionGroup action_group, bool can_customize);
		public void dump_tree ();
		public static void load_accels (string filename);
		public int merge (string ui_filename);
		public void remove_action_group (Gtk.ActionGroup action_group);
		public static void save_accels (string filename);
		public void unload_accels ();
		public void unmerge (int id);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class VcsStatusTreeView : Gtk.TreeView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public VcsStatusTreeView ();
		public void add (string path, Anjuta.VcsStatus status, bool selected);
		public void destroy ();
		public void select_all ();
		public void unselect_all ();
		[NoAccessorMethod]
		public bool conflicted_selectable { get; construct; }
		[NoAccessorMethod]
		public bool show_status { get; set; }
		[NoAccessorMethod]
		public Anjuta.VcsStatus status_codes { get; construct; }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public interface Shell : GLib.Object {
		public abstract void add_value (string name, GLib.Value value) throws GLib.Error;
		public void add_widget (Gtk.Widget widget, string name, string title, string stock_id, Anjuta.ShellPlacement placement) throws GLib.Error;
		public abstract void add_widget_custom (Gtk.Widget widget, string name, string title, string stock_id, Gtk.Widget label, Anjuta.ShellPlacement placement) throws GLib.Error;
		public abstract void add_widget_full (Gtk.Widget widget, string name, string title, string stock_id, Anjuta.ShellPlacement placement, bool locked) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public void freeze () throws GLib.Error;
		public abstract unowned GLib.Object get_object (string iface_name) throws GLib.Error;
		public abstract void get_value (string name, GLib.Value value) throws GLib.Error;
		public abstract void hide_dockable_widget (Gtk.Widget widget) throws GLib.Error;
		public abstract void iconify_dockable_widget (Gtk.Widget widget) throws GLib.Error;
		public abstract void maximize_widget (string widget_name) throws GLib.Error;
		public void notify_exit () throws GLib.Error;
		public abstract void present_widget (Gtk.Widget widget) throws GLib.Error;
		public abstract void remove_value (string name) throws GLib.Error;
		public abstract void remove_widget (Gtk.Widget widget) throws GLib.Error;
		public abstract void saving_pop ();
		public abstract void saving_push ();
		public void session_load (string session_directory) throws GLib.Error;
		public void session_save (string session_directory) throws GLib.Error;
		public abstract void show_dockable_widget (Gtk.Widget widget) throws GLib.Error;
		public void thaw () throws GLib.Error;
		public abstract void unmaximize () throws GLib.Error;
		public virtual signal void exiting ();
		public virtual signal void load_session (int phase, GLib.Object session);
		[HasEmitter]
		public virtual signal void save_prompt (GLib.Object save_prompt);
		public virtual signal void save_session (int phase, GLib.Object session);
		public virtual signal void value_added (string name, GLib.Value value);
		public virtual signal void value_removed (string name);
	}
	[CCode (type_id = "ANJUTA_TYPE_ASYNC_COMMAND_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct AsyncCommandPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_ASYNC_NOTIFY_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct AsyncNotifyPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_COLUMN_TEXT_VIEW_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct ColumnTextViewPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_COMMAND_BAR_ENTRY", cheader_filename = "libanjuta/libanjuta.h")]
	public struct CommandBarEntry {
		public Anjuta.CommandBarEntryType type;
		public weak string action_name;
		public weak string label;
		public weak string tooltip;
		public weak string stock_icon;
		public weak GLib.Callback callback;
	}
	[CCode (type_id = "ANJUTA_TYPE_COMMAND_BAR_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct CommandBarPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_COMMAND_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct CommandPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_COMMAND_QUEUE_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct CommandQueuePriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_DOCK_PANE_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct DockPanePriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_DOCK_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct DockPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_ENTRY_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct EntryPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_FILE_DROP_ENTRY_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct FileDropEntryPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_FILE_LIST_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct FileListPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_LAUNCHER_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct LauncherPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_PLUGIN_DESCRIPTION", cheader_filename = "libanjuta/libanjuta.h")]
	public struct PluginDescription {
		public void free ();
		public bool get_boolean (string section, string keyname, bool val);
		public bool get_integer (string section, string keyname, int val);
		public bool get_locale_string (string section, string keyname, string val);
		public bool get_raw (string section_name, string keyname, string locale, string val);
		public bool get_string (string section, string keyname, string val);
		public static GLib.Quark parse_error_quark ();
		public string to_string ();
	}
	[CCode (type_id = "ANJUTA_TYPE_PLUGIN_HANDLE_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct PluginHandlePriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_PLUGIN_MANAGER_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct PluginManagerPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_PREFERENCES_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct PreferencesPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_PROFILE_MANAGER_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct ProfileManagerPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_PROFILE_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct ProfilePriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_PROPERTY", cheader_filename = "libanjuta/libanjuta.h")]
	public struct Property {
	}
	[CCode (type_id = "ANJUTA_TYPE_SESSION_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct SessionPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_STATUS_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct StatusPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_TABBER_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct TabberPriv {
	}
	[CCode (type_id = "ANJUTA_TYPE_TOKEN", cheader_filename = "libanjuta/libanjuta.h")]
	public struct Token {
		public bool check ();
		public void clear_flags (int flags);
		public bool compare (Anjuta.Token tokenb);
		public void dump ();
		public void dump_link ();
		public string evaluate ();
		public int get_flags ();
		public uint get_length ();
		public unowned string get_string ();
		public int get_type ();
		public bool is_empty ();
		public void set_flags (int flags);
		public void set_string (string value, uint length);
		public void set_type (int type);
	}
	[CCode (type_id = "ANJUTA_TYPE_TOKEN_FILE_LOCATION", cheader_filename = "libanjuta/libanjuta.h")]
	public struct TokenFileLocation {
		public weak string filename;
		public uint line;
		public uint column;
	}
	[CCode (type_id = "ANJUTA_TYPE_TOKEN_STREAM", cheader_filename = "libanjuta/libanjuta.h")]
	public struct TokenStream {
		public void append_token (Anjuta.Token token);
		public int read (string buffer, size_t max_size);
	}
	[CCode (type_id = "ANJUTA_TYPE_TOKEN_STYLE", cheader_filename = "libanjuta/libanjuta.h")]
	public struct TokenStyle {
		public void format (Anjuta.Token list);
		public void free ();
		public void update (Anjuta.Token list);
	}
	[CCode (type_id = "ANJUTA_TYPE_VCS_STATUS_TREE_VIEW_PRIV", cheader_filename = "libanjuta/libanjuta.h")]
	public struct VcsStatusTreeViewPriv {
	}
	[CCode (cname = "_AnjutaUtilStringMap", type_id = "ANJUTA_TYPE__UTILSTRINGMAP", cheader_filename = "libanjuta/libanjuta.h")]
	public struct _UtilStringMap {
		public int type;
		public weak string name;
	}
	[CCode (cprefix = "ANJUTA_COMMAND_BAR_ENTRY_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum CommandBarEntryType {
		FRAME,
		BUTTON
	}
	[CCode (cprefix = "ANJUTA_COMMAND_QUEUE_EXECUTE_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum CommandQueueExecuteMode {
		AUTOMATIC,
		MANUAL
	}
	[CCode (cprefix = "ANJUTA_LAUNCHER_OUTPUT_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum LauncherOutputType {
		STDOUT,
		STDERR,
		PTY
	}
	[CCode (cprefix = "ANJUTA_PROJECT_", cheader_filename = "libanjuta/libanjuta.h")]
	[Flags]
	public enum ProjectNodeState {
		OK,
		MODIFIED,
		INCOMPLETE,
		LOADING,
		REMOVED,
		CAN_ADD_GROUP,
		CAN_ADD_TARGET,
		CAN_ADD_SOURCE,
		CAN_ADD_MODULE,
		CAN_ADD_PACKAGE,
		CAN_REMOVE,
		CAN_SAVE,
		REMOVE_FILE
	}
	[CCode (cprefix = "ANJUTA_PROJECT_", cheader_filename = "libanjuta/libanjuta.h")]
	[Flags]
	public enum ProjectNodeType {
		UNKNOWN,
		SHAREDLIB,
		STATICLIB,
		PROGRAM,
		PYTHON,
		JAVA,
		LISP,
		HEADER,
		MAN,
		INFO,
		GENERIC,
		DATA,
		EXTRA,
		INTLTOOL,
		CONFIGURE,
		IDL,
		MKENUMS,
		GENMARSHAL,
		SCRIPT,
		PROXY,
		PROJECT,
		PRIMARY,
		EXECUTABLE,
		ID_MASK,
		FLAG_MASK,
		TYPE_MASK,
		ROOT,
		GROUP,
		TARGET,
		SOURCE,
		MODULE,
		PACKAGE,
		VARIABLE
	}
	[CCode (cprefix = "ANJUTA_PROJECT_PROPERTY_READ_", cheader_filename = "libanjuta/libanjuta.h")]
	[Flags]
	public enum ProjectPropertyFlags {
		ONLY,
		WRITE
	}
	[CCode (cprefix = "ANJUTA_PROJECT_PROPERTY_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum ProjectValueType {
		STRING,
		LIST,
		BOOLEAN,
		MAP
	}
	[CCode (cprefix = "ANJUTA_PROPERTY_DATA_TYPE_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum PropertyDataType {
		BOOL,
		INT,
		TEXT,
		COLOR,
		FONT
	}
	[CCode (cprefix = "ANJUTA_PROPERTY_OBJECT_TYPE_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum PropertyObjectType {
		TOGGLE,
		SPIN,
		ENTRY,
		COMBO,
		COLOR,
		FONT,
		FILE,
		FOLDER
	}
	[CCode (cprefix = "ANJUTA_SERIALIZER_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum SerializerMode {
		READ,
		WRITE
	}
	[CCode (cprefix = "ANJUTA_SESSION_PHASE_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum SessionPhase {
		START,
		FIRST,
		NORMAL,
		LAST,
		END
	}
	[CCode (cprefix = "ANJUTA_SHELL_PLACEMENT_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum ShellPlacement {
		NONE,
		TOP,
		BOTTOM,
		RIGHT,
		LEFT,
		CENTER,
		FLOATING
	}
	[CCode (cprefix = "ANJUTA_TOKEN_", cheader_filename = "libanjuta/libanjuta.h")]
	[Flags]
	public enum TokenType {
		NONE,
		EOL,
		COMMA,
		TYPE,
		FIRST,
		FILE,
		MACRO,
		CONTENT,
		ARGUMENT,
		VALUE,
		EOV,
		PARSED,
		KEYWORD,
		OPERATOR,
		NAME,
		VARIABLE,
		DEFINITION,
		STATEMENT,
		NUMBER,
		JUNK,
		COMMENT,
		OPEN_QUOTE,
		CLOSE_QUOTE,
		ESCAPE,
		FUNCTION,
		SPACE,
		START,
		NEXT,
		LAST,
		ITEM,
		STRING,
		ERROR,
		WORD,
		LIST,
		ANY,
		USER,
		FLAGS,
		PUBLIC_FLAGS,
		IRRELEVANT,
		OPEN,
		CLOSE,
		SIGNIFICANT,
		PRIVATE_FLAGS,
		CASE_INSENSITIVE,
		STATIC,
		REMOVED,
		ADDED
	}
	[CCode (cprefix = "ANJUTA_VCS_STATUS_", cheader_filename = "libanjuta/libanjuta.h")]
	[Flags]
	public enum VcsStatus {
		MODIFIED,
		ADDED,
		DELETED,
		CONFLICTED,
		UPTODATE,
		LOCKED,
		MISSING,
		UNVERSIONED,
		IGNORED,
		ALL
	}
	[CCode (cprefix = "ANJUTA_CONVERT_ERROR_AUTO_DETECTION_", cheader_filename = "libanjuta/libanjuta.h")]
	public errordomain ConvertError {
		FAILED,
	}
	[CCode (cprefix = "ANJUTA_PLUGIN_DESCRIPTION_PARSE_ERROR_INVALID_", cheader_filename = "libanjuta/libanjuta.h")]
	public errordomain PluginDescriptionParseError {
		SYNTAX,
		ESCAPES,
		CHARS,
	}
	[CCode (cprefix = "ANJUTA_PLUGIN_MANAGER_", cheader_filename = "libanjuta/libanjuta.h")]
	public errordomain PluginManagerError {
		MISSING_FACTORY,
		ERROR_UNKNOWN,
	}
	[CCode (cprefix = "ANJUTA_PROFILE_ERROR_URI_", cheader_filename = "libanjuta/libanjuta.h")]
	public errordomain ProfileError {
		READ_FAILED,
		WRITE_FAILED,
	}
	[CCode (cprefix = "ANJUTA_SHELL_ERROR_DOESNT_", cheader_filename = "libanjuta/libanjuta.h")]
	public errordomain ShellError {
		EXIST,
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h", instance_pos = 3.9)]
	public delegate void LauncherOutputCallback (Anjuta.Launcher launcher, Anjuta.LauncherOutputType output_type, string chars);
	[CCode (cheader_filename = "libanjuta/libanjuta.h", has_target = false)]
	public delegate void PluginDescriptionLineFunc (Anjuta.PluginDescription df, string key, string locale, string value, void* data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h", instance_pos = 2.9)]
	public delegate void PluginDescriptionSectionFunc (Anjuta.PluginDescription df, string name);
	[CCode (cheader_filename = "libanjuta/libanjuta.h", instance_pos = 3.9)]
	public delegate void PluginValueAdded (Anjuta.Plugin plugin, string name, GLib.Value value);
	[CCode (cheader_filename = "libanjuta/libanjuta.h", instance_pos = 2.9)]
	public delegate void PluginValueRemoved (Anjuta.Plugin plugin, string name);
	[CCode (cheader_filename = "libanjuta/libanjuta.h", has_target = false)]
	public delegate bool PreferencesCallback (Anjuta.Preferences pr, string key, void* data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h", has_target = false)]
	public delegate void ProjectNodeForeachFunc (Anjuta.ProjectNode node, void* data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h", has_target = false)]
	public delegate bool ProjectNodeTraverseFunc (Anjuta.ProjectNode node, void* data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h", instance_pos = 2.9)]
	public delegate bool SavePromptSaveFunc (Anjuta.SavePrompt save_prompt, void* item);
	[CCode (cheader_filename = "libanjuta/libanjuta.h", has_target = false)]
	public delegate void TokenForeachFunc (Anjuta.Token token, void* data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public const string PLUGIN_REGISTRATION;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public const int VCS_DEFAULT_STATUS_CODES;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void cclosure_marshal_VOID__BOXED_ENUM (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void cclosure_marshal_VOID__INT_INT_ULONG (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void cclosure_marshal_VOID__INT_OBJECT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void cclosure_marshal_VOID__INT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void cclosure_marshal_VOID__POINTER_OBJECT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void cclosure_marshal_VOID__STRING_BOXED (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void cclosure_marshal_VOID__STRING_INT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void cclosure_marshal_VOID__STRING_INT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void cclosure_marshal_VOID__STRING_POINTER (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static GLib.Quark convert_error_quark ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string convert_from_utf8 (string content, size_t len, Anjuta.Encoding encoding, size_t new_len) throws GLib.Error;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string convert_to_utf8 (string content, size_t len, Anjuta.Encoding encoding, size_t new_len) throws GLib.Error;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void debug_init ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool pkg_config_ignore_package (string name);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string res_get_data_dir ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string res_get_data_file (string pixfile);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string res_get_doc_dir ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string res_get_doc_file (string docfile);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string res_get_help_dir ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string res_get_help_dir_locale (string locale);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string res_get_help_file (string helpfile);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string res_get_help_file_locale (string helpfile, string locale);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string res_get_pixmap_dir ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string res_get_pixmap_file (string pixfile);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void res_help_search (string word);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void res_url_show (string url);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_color_from_string (string val, uint16 r, uint16 g, uint16 b);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_convert_to_utf8 (string str);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_copy_file (string src, string dest, bool show_error);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_create_dir (string d);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_dialog_input (Gtk.Window parent, string label, string default_value, string value);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_diff (string uri, string text);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_escape_quotes (string str);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static int util_execute_shell (string dir, string command);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static int util_execute_terminal_shell (string dir, string command);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_get_a_tmp_file ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_get_current_dir ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_get_file_mime_type (GLib.File file);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_get_local_path_from_uri (string uri);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_get_real_path (string path);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_get_user_mail ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_glist_strings_free (GLib.List<weak void*> list);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_glist_strings_join (GLib.List<weak void*> list, string delimiter);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_glist_strings_prefix (GLib.List<weak void*> list, string prefix);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_glist_strings_sufix (GLib.List<weak void*> list, string sufix);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_help_display (Gtk.Widget parent, string doc_id, string file_name);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_install_files (string names);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_is_project_file (string filename);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_is_template_file (string filename);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_package_is_installed (string lib, bool show);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_prog_is_installed (string prog, bool show);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_replace_home_dir_with_tilde (string uri);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_shell_expand (string string);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_str_middle_truncate (string string, uint truncate_length);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_string_from_color (uint16 r, uint16 g, uint16 b);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_uri_get_dirname (string uri);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static string util_user_shell ();
}
/* libanjuta-interfaces.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "IAnjuta", lower_case_cprefix = "ianjuta_", gir_namespace = "IAnjuta", gir_version = "3.0")]
namespace IAnjuta {
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Buildable : GLib.Object {
		public abstract void build (string uri) throws GLib.Error;
		public abstract void clean (string uri) throws GLib.Error;
		public abstract void configure (string uri) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void execute (string uri) throws GLib.Error;
		public abstract void generate (string uri) throws GLib.Error;
		public abstract unowned string get_command (IAnjuta.BuildableCommand command_id) throws GLib.Error;
		public abstract void install (string uri) throws GLib.Error;
		public abstract void reset_commands () throws GLib.Error;
		public abstract void set_command (IAnjuta.BuildableCommand command_id, string command) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Builder : GLib.Object {
		public abstract void cancel (IAnjuta.BuilderHandle handle) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned string get_uri_configuration (string uri) throws GLib.Error;
		public abstract GLib.List<weak string> list_configuration () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebugManager : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool quit () throws GLib.Error;
		public abstract bool start (string uri) throws GLib.Error;
		public abstract bool start_remote (string server, string uri) throws GLib.Error;
		public virtual signal void breakpoint_changed (void* breakpoint);
		public virtual signal void debugger_started ();
		public virtual signal void debugger_stopped (GLib.Error err);
		public virtual signal void frame_changed (uint frame, int thread);
		public virtual signal void location_changed (ulong address, string uri, uint line);
		public virtual signal void program_exited ();
		public virtual signal void program_loaded ();
		public virtual signal void program_moved (int pid, int tid, ulong address, string file, uint line);
		public virtual signal void program_running ();
		public virtual signal void program_started ();
		public virtual signal void program_stopped ();
		public virtual signal void program_unloaded ();
		public virtual signal void sharedlib_event ();
		public virtual signal void signal_received (string name, string description);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Debugger : GLib.Object {
		public abstract bool abort () throws GLib.Error;
		public abstract bool attach (int pid, GLib.List<weak string> source_search_directories) throws GLib.Error;
		public abstract bool connect (string server, string args, bool terminal, bool stop) throws GLib.Error;
		public abstract void disable_log () throws GLib.Error;
		public abstract void enable_log (IAnjuta.MessageView log) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool exit () throws GLib.Error;
		public abstract IAnjuta.DebuggerState get_state () throws GLib.Error;
		public abstract bool handle_signal (string name, bool stop, bool print, bool ignore) throws GLib.Error;
		public abstract bool interrupt () throws GLib.Error;
		public abstract bool load (string file, string mime_type, GLib.List<weak string> source_search_directories) throws GLib.Error;
		public abstract bool quit () throws GLib.Error;
		public abstract bool run () throws GLib.Error;
		public abstract bool run_from (string file, int line) throws GLib.Error;
		public abstract bool run_to (string file, int line) throws GLib.Error;
		public abstract bool send_command (string command) throws GLib.Error;
		public abstract bool set_environment (string env) throws GLib.Error;
		public abstract bool set_frame (uint frame) throws GLib.Error;
		public abstract bool set_thread (int thread) throws GLib.Error;
		public abstract bool set_working_directory (string dir) throws GLib.Error;
		public abstract bool start (string args, bool terminal, bool stop) throws GLib.Error;
		public abstract bool step_in () throws GLib.Error;
		public abstract bool step_out () throws GLib.Error;
		public abstract bool step_over () throws GLib.Error;
		public abstract bool unload () throws GLib.Error;
		public virtual signal void debugger_ready (IAnjuta.DebuggerState state);
		public virtual signal void debugger_started ();
		public virtual signal void debugger_stopped (GLib.Error err);
		public virtual signal void frame_changed (uint frame, int thread);
		public virtual signal void program_exited ();
		public virtual signal void program_loaded ();
		public virtual signal void program_moved (int pid, int tid, ulong address, string file, uint line);
		public virtual signal void program_running ();
		public virtual signal void program_stopped ();
		public virtual signal void sharedlib_event ();
		public virtual signal void signal_received (string name, string description);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebuggerBreakpoint : IAnjuta.Debugger, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract int implement_breakpoint () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebuggerInstruction : IAnjuta.Debugger, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool run_from_address (ulong address) throws GLib.Error;
		public abstract bool run_to_address (ulong address) throws GLib.Error;
		public abstract bool step_in_instruction () throws GLib.Error;
		public abstract bool step_over_instruction () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebuggerMemory : IAnjuta.Debugger, GLib.Object {
		public static GLib.Quark error_quark ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebuggerRegister : IAnjuta.Debugger, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool write_register (IAnjuta.DebuggerRegisterData value) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebuggerVariable : IAnjuta.Debugger, GLib.Object {
		public abstract bool assign (string name, string value) throws GLib.Error;
		public abstract bool destroy (string name) throws GLib.Error;
		public static GLib.Quark error_quark ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Document : GLib.Object {
		public abstract void begin_undo_action () throws GLib.Error;
		public abstract bool can_redo () throws GLib.Error;
		public abstract bool can_undo () throws GLib.Error;
		public abstract void clear () throws GLib.Error;
		public abstract void copy () throws GLib.Error;
		public abstract void cut () throws GLib.Error;
		public abstract void end_undo_action () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned string get_filename () throws GLib.Error;
		public abstract void grab_focus () throws GLib.Error;
		public abstract void paste () throws GLib.Error;
		public abstract void redo () throws GLib.Error;
		public abstract void undo () throws GLib.Error;
		public virtual signal void update_ui ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DocumentManager : GLib.Object {
		public abstract void add_bookmark (GLib.File file, int line) throws GLib.Error;
		public abstract IAnjuta.Editor add_buffer (string name, string content) throws GLib.Error;
		public abstract void add_document (IAnjuta.Document document) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned IAnjuta.Document find_document_with_file (GLib.File file) throws GLib.Error;
		public abstract unowned IAnjuta.Document get_current_document () throws GLib.Error;
		public abstract GLib.List<weak Gtk.Widget> get_doc_widgets () throws GLib.Error;
		public abstract GLib.File get_file (string filename) throws GLib.Error;
		public abstract unowned IAnjuta.Editor goto_file_line (GLib.File file, int lineno) throws GLib.Error;
		public abstract unowned IAnjuta.Editor goto_file_line_mark (GLib.File file, int lineno, bool mark) throws GLib.Error;
		public abstract bool remove_document (IAnjuta.Document document, bool save_before) throws GLib.Error;
		public abstract void set_current_document (IAnjuta.Document document) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Editor : GLib.Object {
		public abstract void append (string text, int length) throws GLib.Error;
		public abstract void erase (IAnjuta.Iterable position_start, IAnjuta.Iterable position_end) throws GLib.Error;
		public abstract void erase_all () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract int get_column () throws GLib.Error;
		public abstract string get_current_word () throws GLib.Error;
		public abstract int get_length () throws GLib.Error;
		public abstract IAnjuta.Iterable get_line_begin_position (int line) throws GLib.Error;
		public abstract int get_line_from_position (IAnjuta.Iterable position) throws GLib.Error;
		public abstract int get_lineno () throws GLib.Error;
		public abstract int get_offset () throws GLib.Error;
		public abstract bool get_overwrite () throws GLib.Error;
		public abstract IAnjuta.Iterable get_position () throws GLib.Error;
		public abstract int get_tabsize () throws GLib.Error;
		public abstract string get_text (IAnjuta.Iterable begin, IAnjuta.Iterable end) throws GLib.Error;
		public abstract string get_text_all () throws GLib.Error;
		public abstract bool get_use_spaces () throws GLib.Error;
		public abstract void goto_end () throws GLib.Error;
		public abstract void goto_line (int lineno) throws GLib.Error;
		public abstract void goto_position (IAnjuta.Iterable position) throws GLib.Error;
		public abstract void goto_start () throws GLib.Error;
		public abstract void insert (IAnjuta.Iterable position, string text, int length) throws GLib.Error;
		public abstract void set_auto_indent (bool auto_indent) throws GLib.Error;
		public abstract void set_popup_menu (Gtk.Widget menu) throws GLib.Error;
		public abstract void set_tabsize (int tabsize) throws GLib.Error;
		public abstract void set_use_spaces (bool use_spaces) throws GLib.Error;
		public virtual signal void backspace ();
		public virtual signal void changed (IAnjuta.Iterable position, bool added, int length, int lines, string text);
		public virtual signal void char_added (IAnjuta.Iterable position, char ch);
		public virtual signal void cursor_moved ();
		public virtual signal void line_marks_gutter_clicked (int location);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorAssist : IAnjuta.Editor, GLib.Object {
		public abstract void add (IAnjuta.Provider provider) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void invoke (IAnjuta.Provider provider) throws GLib.Error;
		public abstract void proposals (IAnjuta.Provider provider, GLib.List<weak IAnjuta.EditorAssistProposal> proposals, bool finished) throws GLib.Error;
		public abstract void remove (IAnjuta.Provider provider) throws GLib.Error;
		public virtual signal void cancelled ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorCell : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract IAnjuta.EditorAttribute get_attribute () throws GLib.Error;
		public abstract char get_char (int char_index) throws GLib.Error;
		public abstract string get_character () throws GLib.Error;
		public abstract int get_length () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorCellStyle : IAnjuta.EditorCell, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract string get_background_color () throws GLib.Error;
		public abstract string get_color () throws GLib.Error;
		public abstract string get_font_description () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorComment : IAnjuta.Editor, GLib.Object {
		public abstract void block () throws GLib.Error;
		public abstract void box () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void stream () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorConvert : IAnjuta.Editor, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void to_lower (IAnjuta.Iterable start_position, IAnjuta.Iterable end_position) throws GLib.Error;
		public abstract void to_upper (IAnjuta.Iterable start_position, IAnjuta.Iterable end_position) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorFactory : GLib.Object {
		public static GLib.Quark error_quark ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorFolds : IAnjuta.Editor, GLib.Object {
		public abstract void close_all () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void open_all () throws GLib.Error;
		public abstract void toggle_current () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorGoto : IAnjuta.Editor, GLib.Object {
		public abstract void end_block () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void matching_brace () throws GLib.Error;
		public abstract void start_block () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorHover : IAnjuta.Editor, GLib.Object {
		public abstract void display (IAnjuta.Iterable position, string info) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public virtual signal void hover_leave (IAnjuta.Iterable position);
		public virtual signal void hover_over (IAnjuta.Iterable position);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorLanguage : IAnjuta.Editor, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned string get_language () throws GLib.Error;
		public abstract unowned string get_language_name (string language) throws GLib.Error;
		public abstract unowned GLib.List<weak string> get_supported_languages () throws GLib.Error;
		public abstract void set_language (string language) throws GLib.Error;
		public virtual signal void language_changed (string language);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorLineMode : IAnjuta.Editor, GLib.Object {
		public abstract void convert (IAnjuta.EditorLineModeType mode) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void fix () throws GLib.Error;
		public abstract IAnjuta.EditorLineModeType @get () throws GLib.Error;
		public abstract void @set (IAnjuta.EditorLineModeType mode) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorSearch : IAnjuta.Editor, GLib.Object {
		public abstract bool backward (string search, bool case_sensitive, IAnjuta.EditorCell start, IAnjuta.EditorCell end, IAnjuta.EditorCell result_start, IAnjuta.EditorCell result_end) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool forward (string search, bool case_sensitive, IAnjuta.EditorCell start, IAnjuta.EditorCell end, IAnjuta.EditorCell result_start, IAnjuta.EditorCell result_end) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorSelection : IAnjuta.Editor, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract string @get () throws GLib.Error;
		public abstract bool has_selection () throws GLib.Error;
		public abstract void replace (string text, int length) throws GLib.Error;
		public abstract void select_all () throws GLib.Error;
		public abstract void select_block () throws GLib.Error;
		public abstract void select_function () throws GLib.Error;
		public abstract void @set (IAnjuta.Iterable start, IAnjuta.Iterable end, bool scroll) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorTip : IAnjuta.Editor, GLib.Object {
		public abstract void cancel () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void show (GLib.List<weak string> tips, IAnjuta.Iterable position) throws GLib.Error;
		public abstract bool visible () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorView : IAnjuta.Editor, GLib.Object {
		public abstract void create () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract int get_count () throws GLib.Error;
		public abstract void remove_current () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorZoom : IAnjuta.Editor, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void @in () throws GLib.Error;
		public abstract void @out () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Environment : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract string get_real_directory (string dir) throws GLib.Error;
		public abstract bool @override (string dirp, string argvp, string envp) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface File : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract GLib.File get_file () throws GLib.Error;
		public abstract void open (GLib.File file) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface FileLoader : IAnjuta.Loader, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract string peek_interface (GLib.File file) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface FileManager : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void set_root (string root_uri) throws GLib.Error;
		public abstract void set_selected (GLib.File file) throws GLib.Error;
		public virtual signal void section_changed (GLib.File file);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface FileSavable : IAnjuta.File, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool is_conflict () throws GLib.Error;
		public abstract bool is_dirty () throws GLib.Error;
		public abstract bool is_read_only () throws GLib.Error;
		public abstract void save () throws GLib.Error;
		public abstract void save_as (GLib.File file) throws GLib.Error;
		public abstract void set_dirty (bool dirty) throws GLib.Error;
		public virtual signal void saved (GLib.File file);
		public virtual signal void update_save_ui ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Help : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void search (string query) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Indicable : GLib.Object {
		public abstract void clear () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void @set (IAnjuta.Iterable begin_location, IAnjuta.Iterable end_location, IAnjuta.IndicableIndicator indicator) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Iterable : GLib.Object {
		public abstract void assign (IAnjuta.Iterable src_iter) throws GLib.Error;
		public abstract IAnjuta.Iterable clone () throws GLib.Error;
		public abstract int compare (IAnjuta.Iterable iter2) throws GLib.Error;
		public abstract int diff (IAnjuta.Iterable iter2) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool first () throws GLib.Error;
		public abstract int get_length () throws GLib.Error;
		public abstract int get_position () throws GLib.Error;
		public abstract bool last () throws GLib.Error;
		public abstract bool next () throws GLib.Error;
		public abstract bool previous () throws GLib.Error;
		public abstract bool set_position (int position) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface IterableTree : IAnjuta.Iterable, GLib.Object {
		public abstract bool children () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool has_children () throws GLib.Error;
		public abstract bool parent () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Language : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract IAnjuta.LanguageId get_from_editor (IAnjuta.EditorLanguage editor) throws GLib.Error;
		public abstract IAnjuta.LanguageId get_from_mime_type (string mime_type) throws GLib.Error;
		public abstract IAnjuta.LanguageId get_from_string (string string) throws GLib.Error;
		public abstract GLib.List<weak int> get_languages () throws GLib.Error;
		public abstract unowned string get_make_target (IAnjuta.LanguageId id) throws GLib.Error;
		public abstract unowned string get_name (IAnjuta.LanguageId id) throws GLib.Error;
		public abstract unowned string get_name_from_editor (IAnjuta.EditorLanguage editor) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Loader : GLib.Object {
		public static GLib.Quark error_quark ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Markable : GLib.Object {
		public abstract void delete_all_markers (IAnjuta.MarkableMarker marker) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool is_marker_set (int location, IAnjuta.MarkableMarker marker) throws GLib.Error;
		public abstract int location_from_handle (int handle) throws GLib.Error;
		public abstract int mark (int location, IAnjuta.MarkableMarker marker, string? tooltip) throws GLib.Error;
		public abstract void unmark (int location, IAnjuta.MarkableMarker marker) throws GLib.Error;
		public virtual signal void marker_clicked (bool double_click, int location);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface MessageManager : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void remove_view (IAnjuta.MessageView view) throws GLib.Error;
		public abstract void set_current_view (IAnjuta.MessageView view) throws GLib.Error;
		public abstract void set_view_icon (IAnjuta.MessageView view, Gdk.PixbufAnimation icon) throws GLib.Error;
		public abstract void set_view_icon_from_stock (IAnjuta.MessageView view, string icon) throws GLib.Error;
		public abstract void set_view_title (IAnjuta.MessageView view, string title) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface MessageView : GLib.Object {
		public abstract void append (IAnjuta.MessageViewType type, string summary, string details) throws GLib.Error;
		public abstract void buffer_append (string text) throws GLib.Error;
		public abstract void clear () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned string get_current_message () throws GLib.Error;
		public abstract void select_next () throws GLib.Error;
		public abstract void select_previous () throws GLib.Error;
		public virtual signal void buffer_flushed (string line);
		public virtual signal void message_clicked (string message);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface PluginFactory : GLib.Object {
		public static GLib.Quark error_quark ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Preferences : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void merge (Anjuta.Preferences prefs) throws GLib.Error;
		public abstract void unmerge (Anjuta.Preferences prefs) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Print : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void print () throws GLib.Error;
		public abstract void print_preview () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Project : GLib.Object {
		public abstract unowned Anjuta.ProjectNode add_node_after (Anjuta.ProjectNode parent, Anjuta.ProjectNode? sibling, Anjuta.ProjectNodeType type, GLib.File? file, string? name) throws GLib.Error;
		public abstract unowned Anjuta.ProjectNode add_node_before (Anjuta.ProjectNode parent, Anjuta.ProjectNode? sibling, Anjuta.ProjectNodeType type, GLib.File? file, string? name) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned GLib.List<weak Anjuta.ProjectNodeInfo> get_node_info () throws GLib.Error;
		public abstract unowned Anjuta.ProjectNode get_root () throws GLib.Error;
		public abstract bool is_loaded () throws GLib.Error;
		public abstract bool load_node (Anjuta.ProjectNode node) throws GLib.Error;
		public abstract bool remove_node (Anjuta.ProjectNode node) throws GLib.Error;
		public abstract bool remove_property (Anjuta.ProjectNode node, Anjuta.ProjectProperty property) throws GLib.Error;
		public abstract bool save_node (Anjuta.ProjectNode node) throws GLib.Error;
		public abstract unowned Anjuta.ProjectProperty set_property (Anjuta.ProjectNode parent, Anjuta.ProjectProperty property, string value) throws GLib.Error;
		public virtual signal void file_changed (void* node);
		public virtual signal void node_changed (void* node, GLib.Error error);
		public virtual signal void node_loaded (void* node, GLib.Error error);
		public virtual signal void node_saved (void* node, GLib.Error error);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface ProjectBackend : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract IAnjuta.Project new_project (GLib.File file) throws GLib.Error;
		public abstract int probe (GLib.File directory) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface ProjectManager : GLib.Object {
		public abstract GLib.File add_group (string name, GLib.File? default_group) throws GLib.Error;
		public abstract GLib.File add_source (string name, GLib.File? default_target) throws GLib.Error;
		public abstract GLib.File add_source_quiet (string name, GLib.File target) throws GLib.Error;
		public abstract GLib.List<GLib.File> add_sources (GLib.List<weak string> names, GLib.File? default_target) throws GLib.Error;
		public abstract GLib.File add_target (string name, GLib.File? default_group) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract uint get_capabilities () throws GLib.Error;
		public abstract GLib.List<GLib.File> get_children (GLib.File element) throws GLib.Error;
		public abstract unowned IAnjuta.Project get_current_project () throws GLib.Error;
		public abstract GLib.List<GLib.File> get_elements (Anjuta.ProjectNodeType element_type) throws GLib.Error;
		public abstract GLib.List<weak string> get_packages () throws GLib.Error;
		public abstract GLib.File get_selected () throws GLib.Error;
		public abstract Anjuta.ProjectNodeType get_target_type (GLib.File target) throws GLib.Error;
		public abstract GLib.List<GLib.File> get_targets (Anjuta.ProjectNodeType target_type) throws GLib.Error;
		public abstract bool is_open () throws GLib.Error;
		public virtual signal void element_added (GLib.File element);
		public virtual signal void element_removed (GLib.File element);
		public virtual signal void element_selected (GLib.File element);
		public virtual signal void project_loaded (GLib.Error error);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Provider : GLib.Object {
		public abstract void activate (IAnjuta.Iterable iter, void* data) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned string get_name () throws GLib.Error;
		public abstract unowned IAnjuta.Iterable get_start_iter () throws GLib.Error;
		public abstract void populate (IAnjuta.Iterable iter) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface SnippetsManager : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool insert (string key) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Stream : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void open (void* stream) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface StreamLoader : IAnjuta.Loader, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract string peek_interface (void* stream) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface StreamSavable : IAnjuta.Stream, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void save (void* stream) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Symbol : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool get_boolean (IAnjuta.SymbolField field) throws GLib.Error;
		public abstract unowned Gdk.Pixbuf get_icon () throws GLib.Error;
		public abstract int get_int (IAnjuta.SymbolField field) throws GLib.Error;
		public abstract unowned string get_string (IAnjuta.SymbolField field) throws GLib.Error;
		public abstract IAnjuta.SymbolType get_sym_type () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface SymbolManager : GLib.Object {
		public abstract bool activate_package (string pkg_name, string pkg_version) throws GLib.Error;
		public abstract bool add_and_activate_package (string pkg_name, string pkg_version, GLib.List<weak void*> files) throws GLib.Error;
		public abstract bool add_package (string pkg_name, string pkg_version, GLib.List<weak void*> files) throws GLib.Error;
		public abstract bool deactivate_package (string pkg_name, string pkg_version) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public virtual signal void prj_scan_end (int process_id);
		public virtual signal void sys_scan_end (int process_id);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface SymbolQuery : GLib.Object {
		public abstract void cancel () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void set_fields (int n_fields, IAnjuta.SymbolField fields) throws GLib.Error;
		public abstract void set_file_scope (IAnjuta.SymbolQueryFileScope filescope_search) throws GLib.Error;
		public abstract void set_filters (IAnjuta.SymbolType filters, bool includes_types) throws GLib.Error;
		public abstract void set_group_by (IAnjuta.SymbolField field) throws GLib.Error;
		public abstract void set_limit (int limit) throws GLib.Error;
		public abstract void set_mode (IAnjuta.SymbolQueryMode mode) throws GLib.Error;
		public abstract void set_offset (int offset) throws GLib.Error;
		public abstract void set_order_by (IAnjuta.SymbolField field) throws GLib.Error;
		public virtual signal void async_result (GLib.Object result);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Terminal : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract int execute_command (string directory, string command, string environment) throws GLib.Error;
		public virtual signal void child_exited (int pid, int status);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Todo : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void load (GLib.File file) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Vcs : GLib.Object {
		public abstract void add (GLib.List<weak GLib.File> files, Anjuta.AsyncNotify notify) throws GLib.Error;
		public abstract void checkout (string repository_location, GLib.File dest, GLib.Cancellable? cancel, Anjuta.AsyncNotify notify) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void remove (GLib.List<weak GLib.File> files, Anjuta.AsyncNotify notify) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Wizard : GLib.Object {
		public abstract void activate () throws GLib.Error;
		public static GLib.Quark error_quark ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	[SimpleType]
	public struct BuilderHandle {
	}
	[CCode (type_id = "IANJUTA_TYPE_DEBUGGER_BREAKPOINT_ITEM", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public struct DebuggerBreakpointItem {
		public int type;
		public uint id;
		public weak string file;
		public uint line;
		public weak string function;
		public ulong address;
		public bool enable;
		public uint ignore;
		public uint times;
		public weak string condition;
		public bool temporary;
		public bool pending;
	}
	[CCode (type_id = "IANJUTA_TYPE_DEBUGGER_FRAME", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public struct DebuggerFrame {
		public int thread;
		public uint level;
		public weak string args;
		public weak string file;
		public uint line;
		public weak string function;
		public weak string library;
		public ulong address;
	}
	[CCode (type_id = "IANJUTA_TYPE_DEBUGGER_INSTRUCTION_ALINE", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public struct DebuggerInstructionALine {
		public ulong address;
		public weak string label;
		public weak string text;
	}
	[CCode (type_id = "IANJUTA_TYPE_DEBUGGER_INSTRUCTION_DISASSEMBLY", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public struct DebuggerInstructionDisassembly {
		public uint size;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak IAnjuta.DebuggerInstructionALine[] data;
	}
	[CCode (type_id = "IANJUTA_TYPE_DEBUGGER_MEMORY_BLOCK", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public struct DebuggerMemoryBlock {
		public ulong address;
		public uint length;
		public weak string data;
	}
	[CCode (type_id = "IANJUTA_TYPE_DEBUGGER_REGISTER_DATA", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public struct DebuggerRegisterData {
		public uint num;
		public weak string name;
		public weak string value;
	}
	[CCode (type_id = "IANJUTA_TYPE_DEBUGGER_VARIABLE_OBJECT", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public struct DebuggerVariableObject {
		public weak string name;
		public weak string expression;
		public weak string type;
		public weak string value;
		public bool changed;
		public bool exited;
		public bool deleted;
		public int children;
		public bool has_more;
	}
	[CCode (type_id = "IANJUTA_TYPE_EDITOR_ASSIST_PROPOSAL", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public struct EditorAssistProposal {
		public weak string label;
		public weak string markup;
		public weak string info;
		public weak string text;
		public weak Gdk.Pixbuf icon;
		public void* data;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	[SimpleType]
	[IntegerType (rank = 0)]
	public struct LanguageId : int {
	}
	[CCode (cprefix = "IANJUTA_BUILDABLE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum BuildableCommand {
		COMMAND_COMPILE,
		COMMAND_BUILD,
		COMMAND_BUILD_TARBALL,
		COMMAND_INSTALL,
		COMMAND_CONFIGURE,
		COMMAND_GENERATE,
		COMMAND_CLEAN,
		COMMAND_EXECUTE,
		COMMAND_IS_BUILT,
		COMMAND_AUTORECONF,
		COMMAND_DISTCLEAN,
		N_COMMANDS
	}
	[CCode (cprefix = "IANJUTA_BUILDER_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum BuilderError {
		SUCCEED,
		FAILED,
		CANCELED,
		ABORTED,
		INTERRUPTED,
		TERMINATED,
		UNKNOWN_TARGET,
		UNKNOWN_ERROR,
		OTHER_ERROR
	}
	[CCode (cprefix = "IANJUTA_DEBUGGER_BREAKPOINT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DebuggerBreakpointMethod {
		SET_AT_ADDRESS,
		SET_AT_FUNCTION,
		ENABLE,
		IGNORE,
		CONDITION
	}
	[CCode (cprefix = "IANJUTA_DEBUGGER_BREAKPOINT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DebuggerBreakpointType {
		REMOVED,
		UPDATED,
		ON_LINE,
		ON_ADDRESS,
		ON_FUNCTION,
		ON_READ,
		ON_WRITE,
		WITH_ENABLE,
		WITH_IGNORE,
		WITH_TIME,
		WITH_CONDITION,
		WITH_TEMPORARY,
		WITH_PENDING
	}
	[CCode (cprefix = "IANJUTA_DEBUGGER_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DebuggerError {
		OK,
		NOT_READY,
		NOT_RUNNING,
		NOT_STOPPED,
		NOT_LOADED,
		NOT_STARTED,
		NOT_CONNECTED,
		NOT_IMPLEMENTED,
		CANCEL,
		UNABLE_TO_CREATE_VARIABLE,
		UNABLE_TO_ACCESS_MEMORY,
		UNABLE_TO_OPEN_FILE,
		UNSUPPORTED_FILE_TYPE,
		UNSUPPORTED_VERSION,
		UNABLE_TO_FIND_DEBUGGER,
		ALREADY_DONE,
		PROGRAM_NOT_FOUND,
		UNABLE_TO_CONNECT,
		UNKNOWN_ERROR,
		OTHER_ERROR
	}
	[CCode (cprefix = "IANJUTA_DEBUGGER_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DebuggerOutputType {
		OUTPUT,
		WARNING_OUTPUT,
		ERROR_OUTPUT,
		INFO_OUTPUT
	}
	[CCode (cprefix = "IANJUTA_DEBUGGER_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DebuggerState {
		BUSY,
		STOPPED,
		STARTED,
		PROGRAM_LOADED,
		PROGRAM_STOPPED,
		PROGRAM_RUNNING
	}
	[CCode (cprefix = "IANJUTA_DOCUMENT_MANAGER_DOESNT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DocumentManagerError {
		[CCode (cname = "IANJUTA_DOCUMENT_MANAGER_DOESNT_EXIST")]
		DOESNT_EXIST
	}
	[CCode (cprefix = "IANJUTA_EDITOR_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum EditorAttribute {
		TEXT,
		KEYWORD,
		COMMENT,
		STRING
	}
	[CCode (cprefix = "IANJUTA_EDITOR_DOESNT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum EditorError {
		[CCode (cname = "IANJUTA_EDITOR_DOESNT_EXIST")]
		DOESNT_EXIST
	}
	[CCode (cprefix = "IANJUTA_EDITOR_LINE_MODE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum EditorLineModeType {
		LF,
		CR,
		CRLF
	}
	[CCode (cprefix = "IANJUTA_ENVIRONMENT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum EnvironmentError {
		CONFIG,
		OTHER_ERROR
	}
	[CCode (cprefix = "IANJUTA_INDICABLE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum IndicableIndicator {
		NONE,
		IMPORTANT,
		WARNING,
		CRITICAL
	}
	[CCode (cprefix = "IANJUTA_MARKABLE_INVALID_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum MarkableError {
		[CCode (cname = "IANJUTA_MARKABLE_INVALID_LOCATION")]
		INVALID_LOCATION
	}
	[CCode (cprefix = "IANJUTA_MARKABLE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum MarkableMarker {
		LINEMARKER,
		BOOKMARK,
		MESSAGE,
		BREAKPOINT_DISABLED,
		BREAKPOINT_ENABLED,
		PROGRAM_COUNTER
	}
	[CCode (cprefix = "IANJUTA_MESSAGE_MANAGER_DOESNT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum MessageManagerError {
		[CCode (cname = "IANJUTA_MESSAGE_MANAGER_DOESNT_EXIST")]
		DOESNT_EXIST
	}
	[CCode (cprefix = "IANJUTA_MESSAGE_VIEW_TYPE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum MessageViewType {
		[CCode (cname = "IANJUTA_MESSAGE_VIEW_TYPE_NORMAL")]
		TYPE_NORMAL,
		[CCode (cname = "IANJUTA_MESSAGE_VIEW_TYPE_INFO")]
		TYPE_INFO,
		[CCode (cname = "IANJUTA_MESSAGE_VIEW_TYPE_WARNING")]
		TYPE_WARNING,
		[CCode (cname = "IANJUTA_MESSAGE_VIEW_TYPE_ERROR")]
		TYPE_ERROR
	}
	[CCode (cprefix = "IANJUTA_PLUGIN_FACTORY_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum PluginFactoryError {
		OK,
		MISSING_LOCATION,
		MISSING_TYPE,
		MISSING_MODULE,
		INVALID_MODULE,
		MISSING_FUNCTION,
		INVALID_TYPE,
		UNKNOWN_ERROR
	}
	[CCode (cprefix = "IANJUTA_PROJECT_ERROR_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum ProjectError {
		[CCode (cname = "IANJUTA_PROJECT_ERROR_SUCCESS")]
		ERROR_SUCCESS,
		[CCode (cname = "IANJUTA_PROJECT_ERROR_DOESNT_EXIST")]
		ERROR_DOESNT_EXIST,
		[CCode (cname = "IANJUTA_PROJECT_ERROR_ALREADY_EXISTS")]
		ERROR_ALREADY_EXISTS,
		[CCode (cname = "IANJUTA_PROJECT_ERROR_VALIDATION_FAILED")]
		ERROR_VALIDATION_FAILED,
		[CCode (cname = "IANJUTA_PROJECT_ERROR_PROJECT_MALFORMED")]
		ERROR_PROJECT_MALFORMED,
		[CCode (cname = "IANJUTA_PROJECT_ERROR_NOT_SUPPORTED")]
		ERROR_NOT_SUPPORTED,
		[CCode (cname = "IANJUTA_PROJECT_ERROR_GENERAL_FAILURE")]
		ERROR_GENERAL_FAILURE
	}
	[CCode (cprefix = "IANJUTA_PROJECT_PROBE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum ProjectProbe {
		[CCode (cname = "IANJUTA_PROJECT_PROBE_FILES")]
		PROBE_FILES,
		[CCode (cname = "IANJUTA_PROJECT_PROBE_MAKE_FILES")]
		PROBE_MAKE_FILES,
		[CCode (cname = "IANJUTA_PROJECT_PROBE_PROJECT_FILES")]
		PROBE_PROJECT_FILES
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolField {
		FIELD_ID,
		FIELD_NAME,
		FIELD_FILE_POS,
		FILED_SCOPE_DEF_ID,
		FIELD_FILE_SCOPE,
		FIELD_SIGNATURE,
		FIELD_RETURNTYPE,
		FIELD_TYPE,
		FIELD_TYPE_NAME,
		FIELD_FILE_PATH,
		FIELD_IMPLEMENTATION,
		FIELD_ACCESS,
		FIELD_KIND,
		FIELD_IS_CONTAINER,
		FIELD_END
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_QUERY_DB_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolQueryDb {
		[CCode (cname = "IANJUTA_SYMBOL_QUERY_DB_PROJECT")]
		DB_PROJECT,
		[CCode (cname = "IANJUTA_SYMBOL_QUERY_DB_SYSTEM")]
		DB_SYSTEM
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_QUERY_SEARCH_FS_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolQueryFileScope {
		[CCode (cname = "IANJUTA_SYMBOL_QUERY_SEARCH_FS_IGNORE")]
		SEARCH_FS_IGNORE,
		[CCode (cname = "IANJUTA_SYMBOL_QUERY_SEARCH_FS_PUBLIC")]
		SEARCH_FS_PUBLIC,
		[CCode (cname = "IANJUTA_SYMBOL_QUERY_SEARCH_FS_PRIVATE")]
		SEARCH_FS_PRIVATE
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_QUERY_MODE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolQueryMode {
		[CCode (cname = "IANJUTA_SYMBOL_QUERY_MODE_SYNC")]
		MODE_SYNC,
		[CCode (cname = "IANJUTA_SYMBOL_QUERY_MODE_ASYNC")]
		MODE_ASYNC,
		[CCode (cname = "IANJUTA_SYMBOL_QUERY_MODE_QUEUED")]
		MODE_QUEUED
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_QUERY_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolQueryName {
		SEARCH,
		SEARCH_ALL,
		SEARCH_FILE,
		SEARCH_IN_SCOPE,
		SEARCH_ID,
		SEARCH_MEMBERS,
		SEARCH_CLASS_PARENTS,
		SEARCH_SCOPE,
		SEARCH_PARENT_SCOPE,
		SEARCH_PARENT_SCOPE_FILE
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_TYPE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolType {
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_NONE")]
		TYPE_NONE,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_UNDEF")]
		TYPE_UNDEF,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_CLASS")]
		TYPE_CLASS,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_ENUM")]
		TYPE_ENUM,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_ENUMERATOR")]
		TYPE_ENUMERATOR,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_FIELD")]
		TYPE_FIELD,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_FUNCTION")]
		TYPE_FUNCTION,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_INTERFACE")]
		TYPE_INTERFACE,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_MEMBER")]
		TYPE_MEMBER,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_METHOD")]
		TYPE_METHOD,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_NAMESPACE")]
		TYPE_NAMESPACE,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_PACKAGE")]
		TYPE_PACKAGE,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_PROTOTYPE")]
		TYPE_PROTOTYPE,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_STRUCT")]
		TYPE_STRUCT,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_TYPEDEF")]
		TYPE_TYPEDEF,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_UNION")]
		TYPE_UNION,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_VARIABLE")]
		TYPE_VARIABLE,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_EXTERNVAR")]
		TYPE_EXTERNVAR,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_MACRO")]
		TYPE_MACRO,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_MACRO_WITH_ARG")]
		TYPE_MACRO_WITH_ARG,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_FILE")]
		TYPE_FILE,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_OTHER")]
		TYPE_OTHER,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_SCOPE_CONTAINER")]
		TYPE_SCOPE_CONTAINER,
		[CCode (cname = "IANJUTA_SYMBOL_TYPE_MAX")]
		TYPE_MAX
	}
	[CCode (cprefix = "IANJUTA_VCS_UNKOWN_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum VcsError {
		[CCode (cname = "IANJUTA_VCS_UNKOWN_ERROR")]
		UNKOWN_ERROR
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 3.9)]
	public delegate void BuilderCallback (GLib.Object sender, IAnjuta.BuilderHandle command, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 1.9)]
	public delegate void DebuggerBreakpointCallback (IAnjuta.DebuggerBreakpointItem data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 1.9)]
	public delegate void DebuggerCallback (void* data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 1.9)]
	public delegate void DebuggerGCharCallback (string value, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 1.9)]
	public delegate void DebuggerGListCallback (GLib.List<weak void*> list, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 1.9)]
	public delegate void DebuggerInstructionCallback (IAnjuta.DebuggerInstructionDisassembly data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 1.9)]
	public delegate void DebuggerMemoryCallback (IAnjuta.DebuggerMemoryBlock data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 2.9)]
	public delegate void DebuggerOutputCallback (IAnjuta.DebuggerOutputType type, string output);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 1.9)]
	public delegate void DebuggerVariableCallback (IAnjuta.DebuggerVariableObject data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 2.9)]
	public delegate void VcsDiffCallback (GLib.File file, string diff);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", instance_pos = 2.9)]
	public delegate void VcsStatusCallback (GLib.File file, Anjuta.VcsStatus status);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string BUILDER_CONFIGURATION_DEBUG;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string BUILDER_CONFIGURATION_OPTIMIZED;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string BUILDER_CONFIGURATION_PROFILING;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string BUILDER_ROOT_URI;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string DOCUMENT_MANAGER_CURRENT_DOCUMENT;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string FILE_MANAGER_SELECTED_FILE;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string PROJECT_MANAGER_CURRENT_PROJECT;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string PROJECT_MANAGER_CURRENT_URI;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string PROJECT_MANAGER_PROJECT_ROOT_URI;
}
