/* cheese-preferences.c generated by valac 0.10.0, the Vala compiler
 * generated from cheese-preferences.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <cheese-camera.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <cheese-config.h>
#include <float.h>
#include <math.h>
#include <cheese-camera-device.h>
#include <stdlib.h>
#include <string.h>


#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;
typedef struct _CheesePreferencesDialogPrivate CheesePreferencesDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CheesePreferencesDialog {
	GObject parent_instance;
	CheesePreferencesDialogPrivate * priv;
};

struct _CheesePreferencesDialogClass {
	GObjectClass parent_class;
};

struct _CheesePreferencesDialogPrivate {
	CheeseCamera* camera;
	GSettings* settings;
	GtkDialog* dialog;
	GtkComboBox* resolution_combo;
	GtkComboBox* source_combo;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* hue_adjustment;
	GtkAdjustment* saturation_adjustment;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkScale* hue_scale;
	GtkScale* saturation_scale;
	GtkSpinButton* burst_repeat_spin;
	GtkSpinButton* burst_delay_spin;
	GtkCheckButton* countdown_check;
	GtkCheckButton* flash_check;
};


static gpointer cheese_preferences_dialog_parent_class = NULL;

GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CHEESE_PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogPrivate))
enum  {
	CHEESE_PREFERENCES_DIALOG_DUMMY_PROPERTY
};
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera, GSettings* settings);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera, GSettings* settings);
static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self, CheeseCameraDevice* device);
void cheese_preferences_dialog_on_source_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_dialog_close (GtkButton* button, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_countdown_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_flash_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_burst_repeat_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_burst_delay_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_brightness_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_contrast_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_hue_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_saturation_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_show (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera, GSettings* settings) {
	CheesePreferencesDialog * self;
	CheeseCamera* _tmp0_;
	GSettings* _tmp1_;
	GtkBuilder* builder;
	GtkDialog* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkScale* _tmp8_;
	GtkScale* _tmp9_;
	GtkScale* _tmp10_;
	GtkScale* _tmp11_;
	GtkComboBox* _tmp12_;
	GtkComboBox* _tmp13_;
	GtkSpinButton* _tmp14_;
	GtkSpinButton* _tmp15_;
	GtkCheckButton* _tmp16_;
	GtkCheckButton* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (CheesePreferencesDialog*) g_object_new (object_type, NULL);
	self->priv->camera = (_tmp0_ = _g_object_ref0 (camera), _g_object_unref0 (self->priv->camera), _tmp0_);
	self->priv->settings = (_tmp1_ = _g_object_ref0 (settings), _g_object_unref0 (self->priv->settings), _tmp1_);
	builder = gtk_builder_new ();
	{
		char* _tmp2_;
		gtk_builder_add_from_file (builder, _tmp2_ = g_build_filename (PACKAGE_DATADIR, "cheese-prefs.ui", NULL), &_inner_error_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("cheese-preferences.vala:63: Error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->dialog = (_tmp3_ = _g_object_ref0 (GTK_DIALOG (gtk_builder_get_object (builder, "cheese_prefs_dialog"))), _g_object_unref0 (self->priv->dialog), _tmp3_);
	self->priv->brightness_adjustment = (_tmp4_ = _g_object_ref0 (GTK_ADJUSTMENT (gtk_builder_get_object (builder, "brightness_adjustment"))), _g_object_unref0 (self->priv->brightness_adjustment), _tmp4_);
	self->priv->contrast_adjustment = (_tmp5_ = _g_object_ref0 (GTK_ADJUSTMENT (gtk_builder_get_object (builder, "contrast_adjustment"))), _g_object_unref0 (self->priv->contrast_adjustment), _tmp5_);
	self->priv->hue_adjustment = (_tmp6_ = _g_object_ref0 (GTK_ADJUSTMENT (gtk_builder_get_object (builder, "hue_adjustment"))), _g_object_unref0 (self->priv->hue_adjustment), _tmp6_);
	self->priv->saturation_adjustment = (_tmp7_ = _g_object_ref0 (GTK_ADJUSTMENT (gtk_builder_get_object (builder, "saturation_adjustment"))), _g_object_unref0 (self->priv->saturation_adjustment), _tmp7_);
	self->priv->brightness_scale = (_tmp8_ = _g_object_ref0 (GTK_SCALE (gtk_builder_get_object (builder, "brightness_scale"))), _g_object_unref0 (self->priv->brightness_scale), _tmp8_);
	self->priv->contrast_scale = (_tmp9_ = _g_object_ref0 (GTK_SCALE (gtk_builder_get_object (builder, "contrast_scale"))), _g_object_unref0 (self->priv->contrast_scale), _tmp9_);
	self->priv->hue_scale = (_tmp10_ = _g_object_ref0 (GTK_SCALE (gtk_builder_get_object (builder, "hue_scale"))), _g_object_unref0 (self->priv->hue_scale), _tmp10_);
	self->priv->saturation_scale = (_tmp11_ = _g_object_ref0 (GTK_SCALE (gtk_builder_get_object (builder, "saturation_scale"))), _g_object_unref0 (self->priv->saturation_scale), _tmp11_);
	gtk_scale_add_mark (self->priv->brightness_scale, (double) 0, GTK_POS_BOTTOM, NULL);
	gtk_scale_add_mark (self->priv->contrast_scale, (double) 1, GTK_POS_BOTTOM, NULL);
	gtk_scale_add_mark (self->priv->hue_scale, (double) 0, GTK_POS_BOTTOM, NULL);
	gtk_scale_add_mark (self->priv->saturation_scale, (double) 1, GTK_POS_BOTTOM, NULL);
	self->priv->resolution_combo = (_tmp12_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (builder, "resolution_combo_box"))), _g_object_unref0 (self->priv->resolution_combo), _tmp12_);
	self->priv->source_combo = (_tmp13_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (builder, "camera_combo_box"))), _g_object_unref0 (self->priv->source_combo), _tmp13_);
	self->priv->burst_repeat_spin = (_tmp14_ = _g_object_ref0 (GTK_SPIN_BUTTON (gtk_builder_get_object (builder, "burst_repeat"))), _g_object_unref0 (self->priv->burst_repeat_spin), _tmp14_);
	self->priv->burst_delay_spin = (_tmp15_ = _g_object_ref0 (GTK_SPIN_BUTTON (gtk_builder_get_object (builder, "burst_delay"))), _g_object_unref0 (self->priv->burst_delay_spin), _tmp15_);
	self->priv->countdown_check = (_tmp16_ = _g_object_ref0 (GTK_CHECK_BUTTON (gtk_builder_get_object (builder, "countdown"))), _g_object_unref0 (self->priv->countdown_check), _tmp16_);
	self->priv->flash_check = (_tmp17_ = _g_object_ref0 (GTK_CHECK_BUTTON (gtk_builder_get_object (builder, "flash"))), _g_object_unref0 (self->priv->flash_check), _tmp17_);
	cheese_preferences_dialog_setup_combo_box_models (self);
	cheese_preferences_dialog_initialize_camera_devices (self);
	cheese_preferences_dialog_initialize_values_from_settings (self);
	gtk_builder_connect_signals (builder, self);
	_g_object_unref0 (builder);
	return self;
}


CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera, GSettings* settings) {
	return cheese_preferences_dialog_construct (CHEESE_TYPE_PREFERENCES_DIALOG, camera, settings);
}


static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self) {
	GtkCellRendererText* cell;
	g_return_if_fail (self != NULL);
	cell = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->resolution_combo, (GtkCellRenderer*) cell, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->resolution_combo, (GtkCellRenderer*) cell, "text", 0, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->source_combo, (GtkCellRenderer*) cell, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->source_combo, (GtkCellRenderer*) cell, "text", 0, NULL);
	_g_object_unref0 (cell);
}


static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self) {
	CheeseCameraDevice* dev;
	GPtrArray* devices;
	GtkListStore* camera_model;
	g_return_if_fail (self != NULL);
	dev = NULL;
	devices = cheese_camera_get_camera_devices (self->priv->camera);
	camera_model = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_CAMERA_DEVICE);
	gtk_combo_box_set_model (self->priv->source_combo, (GtkTreeModel*) camera_model);
	if (devices->len <= 1) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->source_combo, FALSE);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkTreeIter iter = {0};
				CheeseCameraDevice* _tmp1_;
				char* _tmp2_;
				char* _tmp3_;
				char* _tmp4_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < devices->len)) {
					break;
				}
				dev = (_tmp1_ = _g_object_ref0 (CHEESE_CAMERA_DEVICE (g_ptr_array_index (devices, (guint) i))), _g_object_unref0 (dev), _tmp1_);
				gtk_list_store_append (camera_model, &iter);
				gtk_list_store_set (camera_model, &iter, 0, _tmp4_ = g_strconcat (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (cheese_camera_device_get_name (dev), " (", NULL), cheese_camera_device_get_device_file (dev), NULL), " )", NULL), 1, dev, -1);
				_g_free0 (_tmp4_);
				_g_free0 (_tmp3_);
				_g_free0 (_tmp2_);
				if (_vala_strcmp0 (cheese_camera_device_get_device_file (cheese_camera_get_selected_device (self->priv->camera)), cheese_camera_device_get_device_file (dev)) == 0) {
					gtk_combo_box_set_active_iter (self->priv->source_combo, &iter);
				}
			}
		}
	}
	g_settings_set_string (self->priv->settings, "camera", cheese_camera_device_get_device_file (cheese_camera_get_selected_device (self->priv->camera)));
	cheese_preferences_dialog_setup_resolutions_for_device (self, cheese_camera_get_selected_device (self->priv->camera));
	_g_object_unref0 (camera_model);
	_g_object_unref0 (dev);
}


static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self, CheeseCameraDevice* device) {
	GList* formats;
	CheeseVideoFormat* format;
	GtkListStore* resolution_model;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	formats = cheese_camera_device_get_format_list (device);
	format = NULL;
	resolution_model = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_VIDEO_FORMAT);
	gtk_combo_box_set_model (self->priv->resolution_combo, (GtkTreeModel*) resolution_model);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkTreeIter iter = {0};
				char* _tmp1_;
				char* _tmp2_;
				char* _tmp3_;
				char* _tmp4_;
				gboolean _tmp5_ = FALSE;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < g_list_length (formats))) {
					break;
				}
				format = (CheeseVideoFormat*) g_list_nth (formats, (guint) i)->data;
				gtk_list_store_append (resolution_model, &iter);
				gtk_list_store_set (resolution_model, &iter, 0, _tmp4_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strdup_printf ("%i", format->width), " x ", NULL), _tmp3_ = g_strdup_printf ("%i", format->height), NULL), 1, format, -1);
				_g_free0 (_tmp4_);
				_g_free0 (_tmp3_);
				_g_free0 (_tmp2_);
				_g_free0 (_tmp1_);
				if (cheese_camera_get_current_video_format (self->priv->camera)->width == format->width) {
					_tmp5_ = cheese_camera_get_current_video_format (self->priv->camera)->height == format->height;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gtk_combo_box_set_active_iter (self->priv->resolution_combo, &iter);
					g_settings_set_int (self->priv->settings, "x-resolution", format->width);
					g_settings_set_int (self->priv->settings, "y-resolution", format->height);
				}
			}
		}
	}
	_g_object_unref0 (resolution_model);
}


static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_adjustment_set_value (self->priv->brightness_adjustment, g_settings_get_double (self->priv->settings, "brightness"));
	gtk_adjustment_set_value (self->priv->contrast_adjustment, g_settings_get_double (self->priv->settings, "contrast"));
	gtk_adjustment_set_value (self->priv->hue_adjustment, g_settings_get_double (self->priv->settings, "hue"));
	gtk_adjustment_set_value (self->priv->saturation_adjustment, g_settings_get_double (self->priv->settings, "saturation"));
	gtk_spin_button_set_value (self->priv->burst_repeat_spin, (double) g_settings_get_int (self->priv->settings, "burst-repeat"));
	gtk_spin_button_set_value (self->priv->burst_delay_spin, (double) (g_settings_get_int (self->priv->settings, "burst-delay") / 1000));
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->countdown_check, g_settings_get_boolean (self->priv->settings, "countdown"));
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->flash_check, g_settings_get_boolean (self->priv->settings, "flash"));
}


void cheese_preferences_dialog_on_source_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	GtkTreeIter iter = {0};
	CheeseCameraDevice* dev;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	dev = NULL;
	gtk_combo_box_get_active_iter (combo, &iter);
	gtk_tree_model_get (gtk_combo_box_get_model (combo), &iter, 1, &dev, -1);
	cheese_camera_set_device_by_dev_file (self->priv->camera, cheese_camera_device_get_device_file (dev));
	cheese_camera_switch_camera_device (self->priv->camera);
	cheese_preferences_dialog_setup_resolutions_for_device (self, cheese_camera_get_selected_device (self->priv->camera));
	g_settings_set_string (self->priv->settings, "camera", cheese_camera_device_get_device_file (dev));
	_g_object_unref0 (dev);
}


void cheese_preferences_dialog_on_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	format = NULL;
	gtk_combo_box_get_active_iter (combo, &iter);
	gtk_tree_model_get (gtk_combo_box_get_model (combo), &iter, 1, &format, -1);
	cheese_camera_set_video_format (self->priv->camera, format);
	g_settings_set_int (self->priv->settings, "x-resolution", format->width);
	g_settings_set_int (self->priv->settings, "y-resolution", format->height);
}


void cheese_preferences_dialog_on_dialog_close (GtkButton* button, CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
}


void cheese_preferences_dialog_on_countdown_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (checkbutton != NULL);
	g_settings_set_boolean (self->priv->settings, "countdown", gtk_toggle_button_get_active ((GtkToggleButton*) checkbutton));
}


void cheese_preferences_dialog_on_flash_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (checkbutton != NULL);
	g_settings_set_boolean (self->priv->settings, "flash", gtk_toggle_button_get_active ((GtkToggleButton*) checkbutton));
}


void cheese_preferences_dialog_on_burst_repeat_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (spinbutton != NULL);
	g_settings_set_int (self->priv->settings, "burst-repeat", (gint) gtk_spin_button_get_value (spinbutton));
}


void cheese_preferences_dialog_on_burst_delay_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (spinbutton != NULL);
	g_settings_set_int (self->priv->settings, "burst-delay", ((gint) gtk_spin_button_get_value (spinbutton)) * 1000);
}


void cheese_preferences_dialog_on_brightness_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	cheese_camera_set_balance_property (self->priv->camera, "brightness", gtk_adjustment_get_value (adjustment));
	g_settings_set_double (self->priv->settings, "brightness", gtk_adjustment_get_value (adjustment));
}


void cheese_preferences_dialog_on_contrast_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	cheese_camera_set_balance_property (self->priv->camera, "contrast", gtk_adjustment_get_value (adjustment));
	g_settings_set_double (self->priv->settings, "contrast", gtk_adjustment_get_value (adjustment));
}


void cheese_preferences_dialog_on_hue_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	cheese_camera_set_balance_property (self->priv->camera, "hue", gtk_adjustment_get_value (adjustment));
	g_settings_set_double (self->priv->settings, "hue", gtk_adjustment_get_value (adjustment));
}


void cheese_preferences_dialog_on_saturation_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	cheese_camera_set_balance_property (self->priv->camera, "saturation", gtk_adjustment_get_value (adjustment));
	g_settings_set_double (self->priv->settings, "saturation", gtk_adjustment_get_value (adjustment));
}


void cheese_preferences_dialog_show (CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
}


static void cheese_preferences_dialog_class_init (CheesePreferencesDialogClass * klass) {
	cheese_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheesePreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_preferences_dialog_finalize;
}


static void cheese_preferences_dialog_instance_init (CheesePreferencesDialog * self) {
	self->priv = CHEESE_PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void cheese_preferences_dialog_finalize (GObject* obj) {
	CheesePreferencesDialog * self;
	self = CHEESE_PREFERENCES_DIALOG (obj);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->resolution_combo);
	_g_object_unref0 (self->priv->source_combo);
	_g_object_unref0 (self->priv->brightness_adjustment);
	_g_object_unref0 (self->priv->contrast_adjustment);
	_g_object_unref0 (self->priv->hue_adjustment);
	_g_object_unref0 (self->priv->saturation_adjustment);
	_g_object_unref0 (self->priv->brightness_scale);
	_g_object_unref0 (self->priv->contrast_scale);
	_g_object_unref0 (self->priv->hue_scale);
	_g_object_unref0 (self->priv->saturation_scale);
	_g_object_unref0 (self->priv->burst_repeat_spin);
	_g_object_unref0 (self->priv->burst_delay_spin);
	_g_object_unref0 (self->priv->countdown_check);
	_g_object_unref0 (self->priv->flash_check);
	G_OBJECT_CLASS (cheese_preferences_dialog_parent_class)->finalize (obj);
}


GType cheese_preferences_dialog_get_type (void) {
	static volatile gsize cheese_preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheesePreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheesePreferencesDialog), 0, (GInstanceInitFunc) cheese_preferences_dialog_instance_init, NULL };
		GType cheese_preferences_dialog_type_id;
		cheese_preferences_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "CheesePreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&cheese_preferences_dialog_type_id__volatile, cheese_preferences_dialog_type_id);
	}
	return cheese_preferences_dialog_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




