/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.woden.ErrorHandler;
import org.apache.woden.ErrorInfo;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ant.XMLWriter;

public class Report
extends XMLWriter
implements ErrorHandler {
    private final String NS = "http://www.w3.org/2006/06/wsdl/ValidationReport";
    private final String REPORT = "report";
    private final String WSDL = "wsdl";
    private final String URI = "uri";
    private final String SUCCESS = "success";
    private final String WARNING = "warning";
    private final String ERROR = "error";
    private final String FATAL_ERROR = "fatalError";
    private final String ERROR_LOCATOR = "errorLocator";
    private final String KEY = "key";
    private final String MESSAGE = "message";
    private final String EXCEPTION = "exception";
    private final String DOCUMENT_BASE_URI = "documentBaseUri";
    private final String LOCATION_URI = "locationUri";
    private final String LINE_NUMBER = "lineNumber";
    private final String COLUMN_NUMBER = "columnNumber";
    private final String DETAIL_MESSAGE = "detailMessage";
    private boolean success = true;
    private Vector errorInfos = null;
    private Vector severities = null;

    public static Report openReport(File report) {
        FileOutputStream fos;
        if (report == null) {
            return new Report(null);
        }
        try {
            fos = new FileOutputStream(report);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new Report(null);
        }
        PrintWriter reportOut = new PrintWriter(fos);
        Report reportWriter = new Report(reportOut);
        reportWriter.xmlDeclaration("UTF-8");
        reportWriter.beginReport();
        return reportWriter;
    }

    public void closeReport() {
        this.endReport();
        this.close();
    }

    public Report(PrintWriter out) {
        super(out);
    }

    public void beginReport() {
        this.beginElement("report", "xmlns='http://www.w3.org/2006/06/wsdl/ValidationReport'");
    }

    public void endReport() {
        this.endAllElements();
    }

    public void beginWsdl(String uri) {
        this.success = true;
        this.errorInfos = new Vector();
        this.severities = new Vector();
        this.beginElement("wsdl");
        this.element("uri", uri);
    }

    public void endWsdl() {
        this.write("success", this.success);
        for (int i = 0; i < this.errorInfos.size(); ++i) {
            ErrorInfo errorInfo = (ErrorInfo)this.errorInfos.elementAt(i);
            String severity = (String)this.severities.elementAt(i);
            this.write(severity, errorInfo);
        }
        this.endElement();
        this.success = true;
        this.errorInfos = null;
        this.severities = null;
    }

    public void warning(ErrorInfo errorInfo) {
        this.errorInfos.add(errorInfo);
        this.severities.add("warning");
    }

    public void error(ErrorInfo errorInfo) {
        this.success = false;
        this.errorInfos.add(errorInfo);
        this.severities.add("error");
    }

    public void fatalError(ErrorInfo errorInfo) {
        this.success = false;
        this.errorInfos.add(errorInfo);
        this.severities.add("fatalError");
    }

    public void write(String tag, ErrorInfo errorInfo) {
        if (errorInfo == null) {
            return;
        }
        this.beginElement(tag);
        this.write("errorLocator", errorInfo.getErrorLocator());
        this.element("key", errorInfo.getKey());
        this.element("message", errorInfo.getMessage());
        this.write("exception", errorInfo.getException());
        this.endElement();
    }

    public void write(String tag, ErrorLocator errorLocator) {
        if (errorLocator == null) {
            return;
        }
        this.beginElement(tag);
        this.write("documentBaseUri", errorLocator.getDocumentBaseURI());
        this.write("locationUri", errorLocator.getLocationURI());
        this.write("lineNumber", errorLocator.getLineNumber());
        this.write("columnNumber", errorLocator.getColumnNumber());
        this.endElement();
    }

    public void write(String tag, Exception e) {
        if (e == null) {
            return;
        }
        this.beginElement(tag);
        this.write("detailMessage", e.getMessage());
        this.endElement();
    }
}

