/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.core.request.handler.IComponentRequestHandler;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.http.WebResponse;

public class ComponentRenderingRequestHandler
implements IComponentRequestHandler {
    private final Component component;

    public ComponentRenderingRequestHandler(Component component) {
        this.component = component;
    }

    @Override
    public IRequestableComponent getComponent() {
        return this.component;
    }

    public void detach(IRequestCycle requestCycle) {
        this.component.getPage().detach();
    }

    public void respond(IRequestCycle requestCycle) {
        if (requestCycle.getResponse() instanceof WebResponse) {
            WebResponse response = (WebResponse)requestCycle.getResponse();
            response.disableCaching();
        }
        Page page = this.component.getPage();
        page.startComponentRender(this.component);
        this.component.render();
        page.endComponentRender(this.component);
    }

    @Override
    public final String getComponentPath() {
        return this.component.getPageRelativePath();
    }
}

