/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.protocol.ws.api.WicketWebSocketJQueryResourceReference;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWebSocketBehavior
extends Behavior {
    private static final Logger LOG = LoggerFactory.getLogger(BaseWebSocketBehavior.class);
    private static boolean USING_JAVAX_WEB_SOCKET = false;
    private final String resourceName;

    protected BaseWebSocketBehavior() {
        this.resourceName = null;
    }

    public BaseWebSocketBehavior(String resourceName) {
        this.resourceName = (String)Args.notEmpty((CharSequence)resourceName, (String)"resourceName");
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)WicketWebSocketJQueryResourceReference.get()));
        PackageTextTemplate webSocketSetupTemplate = new PackageTextTemplate(WicketWebSocketJQueryResourceReference.class, "res/js/wicket-websocket-setup.js.tmpl");
        HashMap variables = Generics.newHashMap();
        if (Strings.isEmpty((CharSequence)this.resourceName)) {
            int pageId = component.getPage().getPageId();
            variables.put("pageId", pageId);
            variables.put("resourceName", "");
        } else {
            variables.put("resourceName", this.resourceName);
            variables.put("pageId", false);
        }
        Url baseUrl = component.getRequestCycle().getUrlRenderer().getBaseUrl();
        CharSequence ajaxBaseUrl = Strings.escapeMarkup((CharSequence)baseUrl.toString());
        variables.put("baseUrl", ajaxBaseUrl);
        String contextPath = component.getRequest().getContextPath();
        variables.put("contextPath", contextPath);
        variables.put("applicationName", component.getApplication().getName());
        if (USING_JAVAX_WEB_SOCKET) {
            variables.put("filterPrefix", "");
        } else {
            variables.put("filterPrefix", component.getRequest().getFilterPath());
        }
        String webSocketSetupScript = webSocketSetupTemplate.asString((Map)variables);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)webSocketSetupScript));
    }

    public boolean getStatelessHint(Component component) {
        return false;
    }

    static {
        try {
            Class.forName("org.apache.wicket.protocol.ws.javax.JavaxWebSocketFilter");
            USING_JAVAX_WEB_SOCKET = true;
            LOG.debug("Using JSR356 Native WebSocket implementation!");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Using non-JSR356 Native WebSocket implementation!");
        }
    }
}

