/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.markup.IMarkupCacheKeyProvider;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentRenderer.class);
    @Deprecated
    public static final String COMP_ID = "compId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence renderPage(PageProvider pageProvider) {
        Application application = Application.get();
        RequestCycle originalRequestCycle = RequestCycle.get();
        BufferedWebResponse tempResponse = new BufferedWebResponse(null);
        RequestCycle tempRequestCycle = application.createRequestCycle(originalRequestCycle.getRequest(), (Response)tempResponse);
        try {
            ThreadContext.setRequestCycle(tempRequestCycle);
            pageProvider.getPageInstance().renderPage();
        }
        finally {
            ThreadContext.setRequestCycle(originalRequestCycle);
        }
        return tempResponse.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CharSequence renderComponent(Component component) {
        BufferedWebResponse tempResponse;
        Response originalResponse;
        RequestCycle requestCycle;
        block4: {
            requestCycle = RequestCycle.get();
            originalResponse = requestCycle.getResponse();
            tempResponse = new BufferedWebResponse(null);
            MarkupContainer oldParent = component.getParent();
            if (oldParent != null && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Component '{}' with a parent '{}' is passed for standalone rendering. It is recommended to render only orphan components because they are not cleaned up/detached after the rendering.", (Object)component, (Object)oldParent);
            }
            try {
                requestCycle.setResponse((Response)tempResponse);
                RenderPage page = new RenderPage(component);
                page.internalInitialize();
                component.render();
                if (oldParent == null) break block4;
            }
            catch (Throwable throwable) {
                if (oldParent != null) {
                    oldParent.add(component);
                }
                requestCycle.setResponse(originalResponse);
                throw throwable;
            }
            oldParent.add(component);
        }
        requestCycle.setResponse(originalResponse);
        return tempResponse.getText();
    }

    private static class RenderPage
    extends WebPage
    implements IMarkupResourceStreamProvider,
    IMarkupCacheKeyProvider {
        private static final String DEFAULT_MARKUP = "<wicket:container wicket:id='%s'></wicket:container>";
        private final String markup;

        private RenderPage(Component component) {
            String componentMarkup;
            this.setStatelessHint(true);
            try {
                componentMarkup = component.getMarkup().toString(true);
            }
            catch (MarkupNotFoundException mnfx) {
                componentMarkup = String.format(DEFAULT_MARKUP, component.getId());
            }
            this.markup = componentMarkup;
            this.add(component);
        }

        @Override
        public IResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> containerClass) {
            return new StringResourceStream((CharSequence)this.markup);
        }

        @Override
        public String getCacheKey(MarkupContainer container, Class<?> containerClass) {
            return null;
        }

        @Override
        public boolean isBookmarkable() {
            return true;
        }
    }
}

