/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;

public class AlterConfigsResponse
extends AbstractResponse {
    private static final String RESOURCES_KEY_NAME = "resources";
    private static final String RESOURCE_TYPE_KEY_NAME = "resource_type";
    private static final String RESOURCE_NAME_KEY_NAME = "resource_name";
    private final int throttleTimeMs;
    private final Map<Resource, ApiError> errors;

    public AlterConfigsResponse(int throttleTimeMs, Map<Resource, ApiError> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public AlterConfigsResponse(Struct struct) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] resourcesArray = struct.getArray(RESOURCES_KEY_NAME);
        this.errors = new HashMap<Resource, ApiError>(resourcesArray.length);
        for (Object resourceObj : resourcesArray) {
            Struct resourceStruct = (Struct)resourceObj;
            ApiError error = new ApiError(resourceStruct);
            ResourceType resourceType = ResourceType.forId(resourceStruct.getByte(RESOURCE_TYPE_KEY_NAME));
            String resourceName = resourceStruct.getString(RESOURCE_NAME_KEY_NAME);
            this.errors.put(new Resource(resourceType, resourceName), error);
        }
    }

    public Map<Resource, ApiError> errors() {
        return this.errors;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.ALTER_CONFIGS.responseSchema(version));
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        ArrayList<Struct> resourceStructs = new ArrayList<Struct>(this.errors.size());
        for (Map.Entry<Resource, ApiError> entry : this.errors.entrySet()) {
            Struct resourceStruct = struct.instance(RESOURCES_KEY_NAME);
            Resource resource = entry.getKey();
            entry.getValue().write(resourceStruct);
            resourceStruct.set(RESOURCE_TYPE_KEY_NAME, (Object)resource.type().id());
            resourceStruct.set(RESOURCE_NAME_KEY_NAME, (Object)resource.name());
            resourceStructs.add(resourceStruct);
        }
        struct.set(RESOURCES_KEY_NAME, (Object)resourceStructs.toArray(new Struct[0]));
        return struct;
    }

    public static AlterConfigsResponse parse(ByteBuffer buffer, short version) {
        return new AlterConfigsResponse(ApiKeys.ALTER_CONFIGS.parseResponse(version, buffer));
    }
}

