/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class ContainmentIndex<S extends AnnotationFS, U extends AnnotationFS> {
    private final Map<AnnotationFS, Collection<AnnotationFS>> data = new LinkedHashMap<AnnotationFS, Collection<AnnotationFS>>();
    private final Map<AnnotationFS, Collection<AnnotationFS>> dataRev = new LinkedHashMap<AnnotationFS, Collection<AnnotationFS>>();

    protected ContainmentIndex(CAS cas, org.apache.uima.cas.Type aSuper, org.apache.uima.cas.Type aUnder, Type aType) {
        Collection<AnnotationFS> over = CasUtil.select(cas, aSuper);
        for (AnnotationFS s : over) {
            List<AnnotationFS> under = CasUtil.selectCovered(cas, aUnder, s);
            for (AnnotationFS u : under) {
                switch (aType.ordinal()) {
                    case 0: {
                        this.put(this.data, s, u);
                        break;
                    }
                    case 1: {
                        this.put(this.dataRev, u, s);
                        break;
                    }
                    case 2: {
                        this.put(this.data, s, u);
                        this.put(this.dataRev, u, s);
                    }
                }
            }
        }
    }

    private <X, Y> void put(Map<X, Collection<Y>> map, X key, Y value) {
        Collection<Y> c = map.get(key);
        if (c == null) {
            c = new LinkedList<Y>();
            map.put(key, c);
        }
        c.add(value);
    }

    public Collection<U> containedIn(S aSuper) {
        Collection<AnnotationFS> c = this.data.get(aSuper);
        if (c == null) {
            return Collections.emptySet();
        }
        return c;
    }

    public Collection<S> containing(U aUnder) {
        Collection<AnnotationFS> c = this.dataRev.get(aUnder);
        if (c == null) {
            return Collections.emptySet();
        }
        return c;
    }

    public boolean isContainedIn(S aSuper, U aUnder) {
        return this.containedIn(aSuper).contains(aUnder);
    }

    public boolean isContainedInAny(U aUnder) {
        Collection<S> containers = this.containing(aUnder);
        return containers != null && !containers.isEmpty();
    }

    public static <A extends AnnotationFS, B extends AnnotationFS> ContainmentIndex<A, B> create(JCas aJcas, Class<A> aSuper, Class<B> aUnder, Type aType) {
        return ContainmentIndex.create(aJcas.getCas(), JCasUtil.getType(aJcas, aSuper), JCasUtil.getType(aJcas, aUnder), aType);
    }

    public static ContainmentIndex<AnnotationFS, AnnotationFS> create(CAS cas, org.apache.uima.cas.Type aSuper, org.apache.uima.cas.Type aUnder, Type aType) {
        return new ContainmentIndex<AnnotationFS, AnnotationFS>(cas, aSuper, aUnder, aType);
    }

    public static enum Type {
        DIRECT,
        REVERSE,
        BOTH;

    }
}

