/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.actions;

import java.util.ArrayList;
import org.apache.uima.pear.actions.PearProjectCustomizationException;
import org.apache.uima.pear.generate.GeneratePearWizard;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class GeneratePearFileAction
implements IObjectActionDelegate {
    private IStructuredSelection ssel;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Shell shell = new Shell();
        try {
            IAdaptable a = (IAdaptable)this.ssel.getFirstElement();
            IProject selectedProject = (IProject)a.getAdapter(IProject.class);
            this.ssel = this.convertToResources(this.ssel);
            if (selectedProject != null) {
                try {
                    GeneratePearWizard wizard = new GeneratePearWizard((IContainer)selectedProject);
                    wizard.init(PlatformUI.getWorkbench(), this.ssel);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.open();
                }
                catch (Throwable e) {
                    PearProjectCustomizationException pcEx = new PearProjectCustomizationException("An error occured during the PEAR generation process.", e);
                    pcEx.openErrorDialog(shell);
                }
            } else {
                MessageDialog.openWarning((Shell)shell, (String)"Action not supported", (String)"This action is not supported for the selected item. ");
            }
        }
        catch (Throwable e) {
            MessageDialog.openWarning((Shell)shell, (String)"Action not supported", (String)"This action was not supported for the selected item. ");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.ssel = null;
        if (selection instanceof IStructuredSelection) {
            this.ssel = (IStructuredSelection)selection;
        }
    }

    private IStructuredSelection convertToResources(IStructuredSelection originalSelection) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object currentElement : originalSelection) {
            if (currentElement instanceof IResource) {
                result.add(currentElement);
                continue;
            }
            if (!(currentElement instanceof IAdaptable)) {
                return StructuredSelection.EMPTY;
            }
            Object adapter = ((IAdaptable)currentElement).getAdapter(IResource.class);
            if (!(adapter instanceof IResource)) {
                return StructuredSelection.EMPTY;
            }
            result.add(adapter);
        }
        return new StructuredSelection(result.toArray());
    }
}

