/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.casMultiplier;

import java.util.HashSet;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasMultiplier_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasCopier;

public class SimpleTextMerger
extends JCasMultiplier_ImplBase {
    public static final String MESSAGE_DIGEST = "org.apache.uima.examples.casMultiplier.ExampleCasMultiplierMessages";
    public static final String MISSING_SOURCE_DOCUMENT_INFO = "missing_source_document_info";
    public static final String NO_NEXT_CAS = "no_next_cas";
    private StringBuffer mDocBuf = new StringBuffer();
    private JCas mMergedCas;
    private boolean mReadyToOutput = false;
    private String[] mAnnotationTypesToCopy;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mAnnotationTypesToCopy = (String[])aContext.getConfigParameterValue("AnnotationTypesToCopy");
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        if (this.mMergedCas == null) {
            this.mMergedCas = this.getEmptyJCas();
        }
        String docText = aJCas.getDocumentText();
        int prevDocLen = this.mDocBuf.length();
        this.mDocBuf.append(docText);
        CasCopier copier = new CasCopier(aJCas.getCas(), this.mMergedCas.getCas());
        HashSet<FeatureStructure> copiedIndexedFs = new HashSet<FeatureStructure>();
        for (int i = 0; i < this.mAnnotationTypesToCopy.length; ++i) {
            Type type = this.mMergedCas.getTypeSystem().getType(this.mAnnotationTypesToCopy[i]);
            AnnotationIndex index = aJCas.getCas().getAnnotationIndex(type);
            for (FeatureStructure fs : index) {
                if (copiedIndexedFs.contains(fs)) continue;
                Annotation copyOfFs = (Annotation)copier.copyFs(fs);
                copyOfFs.setBegin(copyOfFs.getBegin() + prevDocLen);
                copyOfFs.setEnd(copyOfFs.getEnd() + prevDocLen);
                this.mMergedCas.addFsToIndexes((FeatureStructure)copyOfFs);
                copiedIndexedFs.add(fs);
            }
        }
        FSIterator it = aJCas.getAnnotationIndex(SourceDocumentInformation.type).iterator();
        if (!it.hasNext()) {
            throw new AnalysisEngineProcessException(MESSAGE_DIGEST, MISSING_SOURCE_DOCUMENT_INFO, new Object[0]);
        }
        SourceDocumentInformation sourceDocInfo = (SourceDocumentInformation)((Object)it.next());
        if (sourceDocInfo.getLastSegment()) {
            this.mMergedCas.setDocumentText(this.mDocBuf.toString());
            SourceDocumentInformation destSDI = new SourceDocumentInformation(this.mMergedCas);
            destSDI.setUri(sourceDocInfo.getUri());
            destSDI.setOffsetInSource(0);
            destSDI.setLastSegment(true);
            destSDI.addToIndexes();
            this.mDocBuf = new StringBuffer();
            this.mReadyToOutput = true;
        }
    }

    public boolean hasNext() throws AnalysisEngineProcessException {
        return this.mReadyToOutput;
    }

    public AbstractCas next() throws AnalysisEngineProcessException {
        if (!this.mReadyToOutput) {
            throw new AnalysisEngineProcessException(MESSAGE_DIGEST, NO_NEXT_CAS, new Object[0]);
        }
        JCas casToReturn = this.mMergedCas;
        this.mMergedCas = null;
        this.mReadyToOutput = false;
        return casToReturn;
    }
}

