/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.exception.PathsException;
import org.assertj.core.error.ShouldBeAbsolutePath;
import org.assertj.core.error.ShouldBeCanonicalPath;
import org.assertj.core.error.ShouldBeDirectory;
import org.assertj.core.error.ShouldBeEmptyDirectory;
import org.assertj.core.error.ShouldBeExecutable;
import org.assertj.core.error.ShouldBeNormalized;
import org.assertj.core.error.ShouldBeReadable;
import org.assertj.core.error.ShouldBeRegularFile;
import org.assertj.core.error.ShouldBeRelativePath;
import org.assertj.core.error.ShouldBeSymbolicLink;
import org.assertj.core.error.ShouldBeWritable;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldEndWithPath;
import org.assertj.core.error.ShouldExist;
import org.assertj.core.error.ShouldHaveBinaryContent;
import org.assertj.core.error.ShouldHaveContent;
import org.assertj.core.error.ShouldHaveDigest;
import org.assertj.core.error.ShouldHaveName;
import org.assertj.core.error.ShouldHaveNoParent;
import org.assertj.core.error.ShouldHaveParent;
import org.assertj.core.error.ShouldHaveSameContent;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotExist;
import org.assertj.core.error.ShouldStartWithPath;
import org.assertj.core.internal.BinaryDiff;
import org.assertj.core.internal.BinaryDiffResult;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.DigestDiff;
import org.assertj.core.internal.Digests;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.NioFilesWrapper;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.diff.Delta;

public class Paths {
    private static final String FAILED_TO_RESOLVE_ARGUMENT_REAL_PATH = "failed to resolve argument real path";
    private static final String FAILED_TO_RESOLVE_ACTUAL_REAL_PATH = "failed to resolve actual real path";
    private static final String UNABLE_TO_COMPARE_PATH_CONTENTS = "Unable to compare contents of paths:<%s> and:<%s>";
    public static final String IOERROR_FORMAT = "I/O error attempting to process assertion for path: <%s>";
    private static final Paths INSTANCE = new Paths();
    private static final Predicate<Path> ANY = any -> true;
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    BinaryDiff binaryDiff = new BinaryDiff();
    @VisibleForTesting
    Failures failures = Failures.instance();
    private NioFilesWrapper nioFilesWrapper;

    public static Paths instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Paths(NioFilesWrapper nioFilesWrapper) {
        this.nioFilesWrapper = nioFilesWrapper;
    }

    private Paths() {
        this(NioFilesWrapper.instance());
    }

    public void assertIsReadable(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        this.assertExists(info, actual);
        if (!this.nioFilesWrapper.isReadable(actual)) {
            throw this.failures.failure(info, ShouldBeReadable.shouldBeReadable(actual));
        }
    }

    public void assertIsWritable(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        this.assertExists(info, actual);
        if (!this.nioFilesWrapper.isWritable(actual)) {
            throw this.failures.failure(info, ShouldBeWritable.shouldBeWritable(actual));
        }
    }

    public void assertIsExecutable(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        this.assertExists(info, actual);
        if (!this.nioFilesWrapper.isExecutable(actual)) {
            throw this.failures.failure(info, ShouldBeExecutable.shouldBeExecutable(actual));
        }
    }

    public void assertExists(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        if (!this.nioFilesWrapper.exists(actual, new LinkOption[0])) {
            throw this.failures.failure(info, ShouldExist.shouldExist(actual));
        }
    }

    public void assertExistsNoFollowLinks(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        if (!this.nioFilesWrapper.exists(actual, LinkOption.NOFOLLOW_LINKS)) {
            throw this.failures.failure(info, ShouldExist.shouldExistNoFollowLinks(actual));
        }
    }

    public void assertDoesNotExist(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        if (!this.nioFilesWrapper.notExists(actual, LinkOption.NOFOLLOW_LINKS)) {
            throw this.failures.failure(info, ShouldNotExist.shouldNotExist(actual));
        }
    }

    public void assertIsRegularFile(AssertionInfo info, Path actual) {
        this.assertExists(info, actual);
        if (!this.nioFilesWrapper.isRegularFile(actual)) {
            throw this.failures.failure(info, ShouldBeRegularFile.shouldBeRegularFile(actual));
        }
    }

    public void assertIsDirectory(AssertionInfo info, Path actual) {
        this.assertExists(info, actual);
        if (!this.nioFilesWrapper.isDirectory(actual)) {
            throw this.failures.failure(info, ShouldBeDirectory.shouldBeDirectory(actual));
        }
    }

    public void assertIsSymbolicLink(AssertionInfo info, Path actual) {
        this.assertExistsNoFollowLinks(info, actual);
        if (!this.nioFilesWrapper.isSymbolicLink(actual)) {
            throw this.failures.failure(info, ShouldBeSymbolicLink.shouldBeSymbolicLink(actual));
        }
    }

    public void assertIsAbsolute(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        if (!actual.isAbsolute()) {
            throw this.failures.failure(info, ShouldBeAbsolutePath.shouldBeAbsolutePath(actual));
        }
    }

    public void assertIsRelative(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        if (actual.isAbsolute()) {
            throw this.failures.failure(info, ShouldBeRelativePath.shouldBeRelativePath(actual));
        }
    }

    public void assertIsNormalized(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        if (!actual.normalize().equals(actual)) {
            throw this.failures.failure(info, ShouldBeNormalized.shouldBeNormalized(actual));
        }
    }

    public void assertIsCanonical(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        try {
            if (!actual.equals(actual.toRealPath(new LinkOption[0]))) {
                throw this.failures.failure(info, ShouldBeCanonicalPath.shouldBeCanonicalPath(actual));
            }
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ACTUAL_REAL_PATH, e);
        }
    }

    public void assertHasParent(AssertionInfo info, Path actual, Path expected) {
        Path canonicalExpected;
        Path canonicalActual;
        Paths.assertNotNull(info, actual);
        Paths.checkExpectedParentPathIsNotNull(expected);
        try {
            canonicalActual = actual.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ACTUAL_REAL_PATH, e);
        }
        try {
            canonicalExpected = expected.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ARGUMENT_REAL_PATH, e);
        }
        Path actualParent = canonicalActual.getParent();
        if (actualParent == null) {
            throw this.failures.failure(info, ShouldHaveParent.shouldHaveParent(actual, expected));
        }
        if (!actualParent.equals(canonicalExpected)) {
            throw this.failures.failure(info, ShouldHaveParent.shouldHaveParent(actual, actualParent, expected));
        }
    }

    public void assertHasParentRaw(AssertionInfo info, Path actual, Path expected) {
        Paths.assertNotNull(info, actual);
        Paths.checkExpectedParentPathIsNotNull(expected);
        Path actualParent = actual.getParent();
        if (actualParent == null) {
            throw this.failures.failure(info, ShouldHaveParent.shouldHaveParent(actual, expected));
        }
        if (!actualParent.equals(expected)) {
            throw this.failures.failure(info, ShouldHaveParent.shouldHaveParent(actual, actualParent, expected));
        }
    }

    public void assertHasNoParent(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        try {
            Path canonicalActual = actual.toRealPath(new LinkOption[0]);
            if (canonicalActual.getParent() != null) {
                throw this.failures.failure(info, ShouldHaveNoParent.shouldHaveNoParent(actual));
            }
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ACTUAL_REAL_PATH, e);
        }
    }

    public void assertHasNoParentRaw(AssertionInfo info, Path actual) {
        Paths.assertNotNull(info, actual);
        if (actual.getParent() != null) {
            throw this.failures.failure(info, ShouldHaveNoParent.shouldHaveNoParent(actual));
        }
    }

    public void assertStartsWith(AssertionInfo info, Path actual, Path start) {
        Path canonicalOther;
        Path canonicalActual;
        Paths.assertNotNull(info, actual);
        Paths.assertExpectedStartPathIsNotNull(start);
        try {
            canonicalActual = actual.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ACTUAL_REAL_PATH, e);
        }
        try {
            canonicalOther = start.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ARGUMENT_REAL_PATH, e);
        }
        if (!canonicalActual.startsWith(canonicalOther)) {
            throw this.failures.failure(info, ShouldStartWithPath.shouldStartWith(actual, start));
        }
    }

    public void assertStartsWithRaw(AssertionInfo info, Path actual, Path other) {
        Paths.assertNotNull(info, actual);
        Paths.assertExpectedStartPathIsNotNull(other);
        if (!actual.startsWith(other)) {
            throw this.failures.failure(info, ShouldStartWithPath.shouldStartWith(actual, other));
        }
    }

    public void assertEndsWith(AssertionInfo info, Path actual, Path end) {
        Paths.assertNotNull(info, actual);
        Paths.assertExpectedEndPathIsNotNull(end);
        try {
            Path canonicalActual = actual.toRealPath(new LinkOption[0]);
            if (!canonicalActual.endsWith(end.normalize())) {
                throw this.failures.failure(info, ShouldEndWithPath.shouldEndWith(actual, end));
            }
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ACTUAL_REAL_PATH, e);
        }
    }

    public void assertEndsWithRaw(AssertionInfo info, Path actual, Path end) {
        Paths.assertNotNull(info, actual);
        Paths.assertExpectedEndPathIsNotNull(end);
        if (!actual.endsWith(end)) {
            throw this.failures.failure(info, ShouldEndWithPath.shouldEndWith(actual, end));
        }
    }

    public void assertHasFileName(AssertionInfo info, Path actual, String fileName) {
        Paths.assertNotNull(info, actual);
        java.util.Objects.requireNonNull(fileName, "expected fileName should not be null");
        if (!actual.getFileName().endsWith(fileName)) {
            throw this.failures.failure(info, ShouldHaveName.shouldHaveName(actual, fileName));
        }
    }

    public void assertHasContent(AssertionInfo info, Path actual, String expected, Charset charset) {
        java.util.Objects.requireNonNull(expected, "The text to compare to should not be null");
        this.assertIsReadable(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected, charset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveContent.shouldHaveContent(actual, charset, diffs));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to verify text contents of path:<%s>", actual), e);
        }
    }

    public void assertHasBinaryContent(AssertionInfo info, Path actual, byte[] expected) {
        java.util.Objects.requireNonNull(expected, "The binary content to compare to should not be null");
        this.assertIsReadable(info, actual);
        try {
            BinaryDiffResult diffResult = this.binaryDiff.diff(actual, expected);
            if (diffResult.hasNoDiff()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, diffResult));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to verify binary contents of path:<%s>", actual), e);
        }
    }

    public void assertHasSameBinaryContentAs(AssertionInfo info, Path actual, Path expected) {
        java.util.Objects.requireNonNull(expected, "The given Path to compare actual content to should not be null");
        this.assertIsReadable(info, actual);
        Preconditions.checkArgument(this.nioFilesWrapper.exists(expected, new LinkOption[0]), "The given Path <%s> to compare actual content to should exist", expected);
        Preconditions.checkArgument(this.nioFilesWrapper.isReadable(expected), "The given Path <%s> to compare actual content to should be readable", expected);
        try {
            BinaryDiffResult binaryDiffResult = this.binaryDiff.diff(actual, Files.readAllBytes(expected));
            if (binaryDiffResult.hasDiff()) {
                throw this.failures.failure(info, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, binaryDiffResult));
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_PATH_CONTENTS, actual, expected), ioe);
        }
    }

    public void assertHasSameContentAs(AssertionInfo info, Path actual, Charset actualCharset, Path expected, Charset expectedCharset) {
        java.util.Objects.requireNonNull(expected, "The given Path to compare actual content to should not be null");
        Preconditions.checkArgument(this.nioFilesWrapper.exists(expected, new LinkOption[0]), "The given Path <%s> to compare actual content to should exist", expected);
        Preconditions.checkArgument(this.nioFilesWrapper.isReadable(expected), "The given Path <%s> to compare actual content to should be readable", expected);
        this.assertIsReadable(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, actualCharset, expected, expectedCharset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_PATH_CONTENTS, actual, expected), e);
        }
    }

    public void assertHasDigest(AssertionInfo info, Path actual, MessageDigest digest, byte[] expected) {
        java.util.Objects.requireNonNull(digest, "The message digest algorithm should not be null");
        java.util.Objects.requireNonNull(expected, "The binary representation of digest to compare to should not be null");
        this.assertIsRegularFile(info, actual);
        this.assertIsReadable(info, actual);
        try (InputStream actualStream = this.nioFilesWrapper.newInputStream(actual, new OpenOption[0]);){
            DigestDiff diff = Digests.digestDiff(actualStream, digest, expected);
            if (diff.digestsDiffer()) {
                throw this.failures.failure(info, ShouldHaveDigest.shouldHaveDigest(actual, diff));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to calculate digest of path:<%s>", actual), e);
        }
    }

    public void assertHasDigest(AssertionInfo info, Path actual, MessageDigest digest, String expected) {
        java.util.Objects.requireNonNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info, actual, digest, Digests.fromHex(expected));
    }

    public void assertHasDigest(AssertionInfo info, Path actual, String algorithm, byte[] expected) {
        java.util.Objects.requireNonNull(algorithm, "The message digest algorithm should not be null");
        try {
            this.assertHasDigest(info, actual, MessageDigest.getInstance(algorithm), expected);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Unable to find digest implementation for: <%s>", algorithm), e);
        }
    }

    public void assertHasDigest(AssertionInfo info, Path actual, String algorithm, String expected) {
        java.util.Objects.requireNonNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info, actual, algorithm, Digests.fromHex(expected));
    }

    public void assertIsDirectoryContaining(AssertionInfo info, Path actual, Predicate<Path> filter) {
        java.util.Objects.requireNonNull(filter, "The paths filter should not be null");
        this.assertIsDirectoryContaining(info, actual, filter, "the given filter");
    }

    public void assertIsDirectoryContaining(AssertionInfo info, Path actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern to build PathMatcher should not be null");
        PathMatcher pathMatcher = this.pathMatcher(info, actual, syntaxAndPattern);
        this.assertIsDirectoryContaining(info, actual, pathMatcher::matches, String.format("the '%s' pattern", syntaxAndPattern));
    }

    public void assertIsDirectoryNotContaining(AssertionInfo info, Path actual, Predicate<Path> filter) {
        java.util.Objects.requireNonNull(filter, "The paths filter should not be null");
        this.assertIsDirectoryNotContaining(info, actual, filter, "the given filter");
    }

    public void assertIsDirectoryNotContaining(AssertionInfo info, Path actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern to build PathMatcher should not be null");
        PathMatcher pathMatcher = this.pathMatcher(info, actual, syntaxAndPattern);
        this.assertIsDirectoryNotContaining(info, actual, pathMatcher::matches, String.format("the '%s' pattern", syntaxAndPattern));
    }

    public void assertIsEmptyDirectory(AssertionInfo info, Path actual) {
        List<Path> items = this.directoryContent(info, actual);
        if (!items.isEmpty()) {
            throw this.failures.failure(info, ShouldBeEmptyDirectory.shouldBeEmptyDirectory(actual, items));
        }
    }

    public void assertIsNotEmptyDirectory(AssertionInfo info, Path actual) {
        boolean isEmptyDirectory = this.directoryContent(info, actual).isEmpty();
        if (isEmptyDirectory) {
            throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    public static List<String> toFileNames(List<Path> files) {
        return files.stream().map(Path::toString).collect(Collectors.toList());
    }

    private List<Path> filterDirectory(AssertionInfo info, Path actual, Predicate<Path> filter) {
        List<Path> list;
        block8: {
            this.assertIsDirectory(info, actual);
            DirectoryStream<Path> stream = this.nioFilesWrapper.newDirectoryStream(actual, filter);
            try {
                list = StreamSupport.stream(stream.spliterator(), false).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(String.format("Unable to list directory content: <%s>", actual), e);
                }
            }
            stream.close();
        }
        return list;
    }

    private List<Path> directoryContent(AssertionInfo info, Path actual) {
        return this.filterDirectory(info, actual, ANY);
    }

    private void assertIsDirectoryContaining(AssertionInfo info, Path actual, Predicate<Path> filter, String filterPresentation) {
        List<Path> matchingFiles = this.filterDirectory(info, actual, filter);
        if (matchingFiles.isEmpty()) {
            throw this.failures.failure(info, ShouldContain.directoryShouldContain(actual, this.directoryContentDescription(info, actual), filterPresentation));
        }
    }

    private void assertIsDirectoryNotContaining(AssertionInfo info, Path actual, Predicate<Path> filter, String filterPresentation) {
        List<Path> matchingFiles = this.filterDirectory(info, actual, filter);
        if (matchingFiles.size() > 0) {
            throw this.failures.failure(info, ShouldNotContain.directoryShouldNotContain(actual, Paths.toFileNames(matchingFiles), filterPresentation));
        }
    }

    private List<String> directoryContentDescription(AssertionInfo info, Path actual) {
        return Paths.toFileNames(this.directoryContent(info, actual));
    }

    private PathMatcher pathMatcher(AssertionInfo info, Path actual, String syntaxAndPattern) {
        Paths.assertNotNull(info, actual);
        return actual.getFileSystem().getPathMatcher(syntaxAndPattern);
    }

    private static void assertNotNull(AssertionInfo info, Path actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private static void checkExpectedParentPathIsNotNull(Path expected) {
        java.util.Objects.requireNonNull(expected, "expected parent path should not be null");
    }

    private static void assertExpectedStartPathIsNotNull(Path start) {
        java.util.Objects.requireNonNull(start, "the expected start path should not be null");
    }

    private static void assertExpectedEndPathIsNotNull(Path end) {
        java.util.Objects.requireNonNull(end, "the expected end path should not be null");
    }
}

