/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortedTupleIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class TupleSorter
extends Expression {
    private Expression base;
    private SortKeyDefinition[] sortKeys;
    private AtomicComparer[] comparators;

    public TupleSorter(Expression expression, SortKeyDefinition[] sortKeyDefinitionArray) {
        this.base = expression;
        this.sortKeys = sortKeyDefinitionArray;
        this.adoptChildExpression(expression);
    }

    public AtomicComparer[] getComparators() {
        return this.comparators;
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.base = this.base.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.base = this.base.typeCheck(staticContext, itemType);
        this.comparators = new AtomicComparer[this.sortKeys.length];
        XPathContext xPathContext = staticContext.makeEarlyEvaluationContext();
        for (int i = 0; i < this.sortKeys.length; ++i) {
            this.sortKeys[i].getSortKey().typeCheck(staticContext, itemType);
            this.comparators[i] = this.sortKeys[i].makeComparator(xPathContext);
            this.sortKeys[i].setSortKey(new StringLiteral(StringValue.EMPTY_STRING));
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.base = this.base.optimize(optimizer, staticContext, itemType);
        if (Literal.isEmptySequence(this.base)) {
            return this.base;
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return AnyItemType.getInstance();
    }

    public int computeCardinality() {
        return 57344;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.base);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.base == expression) {
            this.base = expression2;
            bl = true;
        }
        return bl;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.base = this.base.promote(promotionOffer);
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SortedTupleIterator sortedTupleIterator = new SortedTupleIterator(xPathContext, this.base.iterate(xPathContext), this.comparators);
        MappingIterator mappingIterator = new MappingIterator(sortedTupleIterator, TupleUnwrapper.getInstance());
        return mappingIterator;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
        ItemType itemType = this.base.getItemType(typeHierarchy);
        if (itemType == Type.ITEM_TYPE) {
            return super.effectiveBooleanValue(xPathContext);
        }
        return this.base.effectiveBooleanValue(xPathContext);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "TupleSorter");
        this.base.display(n + 1, printStream, configuration);
    }

    public static class TupleUnwrapper
    implements MappingFunction {
        private static TupleUnwrapper THE_INSTANCE = new TupleUnwrapper();

        private TupleUnwrapper() {
        }

        public static TupleUnwrapper getInstance() {
            return THE_INSTANCE;
        }

        public SequenceIterator map(Item item) throws XPathException {
            ObjectValue objectValue = (ObjectValue)item;
            Object object = objectValue.getObject();
            if (object == null) {
                return null;
            }
            if (object instanceof Item) {
                return SingletonIterator.makeIterator((Item)object);
            }
            Value value = (Value)object;
            return value.iterate();
        }
    }
}

