/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class LazyExpression
extends UnaryExpression {
    public LazyExpression(Expression expression) {
        super(expression);
    }

    public static Expression makeLazyExpression(Expression expression) {
        if (expression instanceof LazyExpression || expression instanceof Literal) {
            return expression;
        }
        return new LazyExpression(expression);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.operand.evaluateItem(xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return this.operand.iterate(xPathContext);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        this.operand.process(xPathContext);
    }

    protected String displayOperator(Configuration configuration) {
        return "lazy";
    }
}

