/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;

public class Copy
extends ElementCreator {
    private boolean copyNamespaces;
    private ItemType contextItemType;

    public Copy(boolean bl, boolean bl2, SchemaType schemaType, int n) {
        this.copyNamespaces = bl;
        this.inheritNamespaces = bl2;
        this.setSchemaType(schemaType);
        this.validation = n;
        boolean bl3 = this.validating = schemaType != null || n != 3;
        if (bl) {
            this.setLazyConstruction(false);
        }
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.validating &= staticContext.getConfiguration().isSchemaAware(52);
        return super.simplify(staticContext);
    }

    public int getInstructionNameCode() {
        return 139;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.contextItemType == null) {
            return AnyItemType.getInstance();
        }
        return this.contextItemType;
    }

    public int getNameCode(XPathContext xPathContext) throws XPathException {
        return ((NodeInfo)xPathContext.getContextItem()).getNameCode();
    }

    public String getNewBaseURI(XPathContext xPathContext) {
        return ((NodeInfo)xPathContext.getContextItem()).getBaseURI();
    }

    protected void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver) throws XPathException {
        if (this.copyNamespaces) {
            NodeInfo nodeInfo = (NodeInfo)xPathContext.getContextItem();
            nodeInfo.sendNamespaceDeclarations(receiver, true);
        }
    }

    public int[] getActiveNamespaces() throws XPathException {
        if (this.copyNamespaces) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceReceiver sequenceReceiver = xPathContextMinor.getReceiver();
        Item item = xPathContext.getContextItem();
        if (!(item instanceof NodeInfo)) {
            sequenceReceiver.append(item, this.locationId, 2);
            return null;
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        switch (nodeInfo.getNodeKind()) {
            case 1: {
                return super.processLeavingTail(xPathContextMinor);
            }
            case 2: {
                try {
                    CopyOf.copyAttribute(nodeInfo, this.getSchemaType(), this.validation, this, xPathContextMinor, false);
                    break;
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    noOpenStartTagException.setXPathContext(xPathContext);
                    throw Copy.dynamicError(this, noOpenStartTagException, xPathContextMinor);
                }
            }
            case 3: {
                sequenceReceiver.characters(nodeInfo.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 7: {
                sequenceReceiver.processingInstruction(nodeInfo.getDisplayName(), nodeInfo.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 8: {
                sequenceReceiver.comment(nodeInfo.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 13: {
                try {
                    nodeInfo.copy(sequenceReceiver, 0, false, this.locationId);
                    break;
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    DynamicError dynamicError = new DynamicError(noOpenStartTagException.getMessage());
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode(noOpenStartTagException.getErrorCodeLocalPart());
                    throw Copy.dynamicError(this, dynamicError, xPathContext);
                }
            }
            case 9: {
                Receiver receiver;
                if (this.validating && (receiver = controller.getConfiguration().getDocumentValidator(sequenceReceiver, nodeInfo.getBaseURI(), this.validation, 10, this.getSchemaType())) != sequenceReceiver) {
                    TreeReceiver treeReceiver = new TreeReceiver(receiver);
                    treeReceiver.setPipelineConfiguration(sequenceReceiver.getPipelineConfiguration());
                    xPathContextMinor.setReceiver(treeReceiver);
                    sequenceReceiver = treeReceiver;
                }
                sequenceReceiver.startDocument(0);
                this.content.process(xPathContextMinor);
                sequenceReceiver.endDocument();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + nodeInfo.getNodeKind());
            }
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceOutputter sequenceOutputter = controller.allocateSequenceOutputter(1);
        PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
        pipelineConfiguration.setHostLanguage(this.getHostLanguage());
        sequenceOutputter.setPipelineConfiguration(pipelineConfiguration);
        xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
        this.process(xPathContextMinor);
        sequenceOutputter.close();
        Item item = sequenceOutputter.getFirstItem();
        sequenceOutputter.reset();
        return item;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "copy");
        this.content.display(n + 1, printStream, configuration);
    }
}

