/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.conceptMapper.support.dictionaryResource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.conceptMapper.Logger;
import org.apache.uima.conceptMapper.support.dictionaryResource.DictionaryLoaderException;
import org.apache.uima.conceptMapper.support.dictionaryResource.DictionaryResource;
import org.apache.uima.conceptMapper.support.dictionaryResource.DictionaryToken;
import org.apache.uima.conceptMapper.support.dictionaryResource.EntryProperties;
import org.apache.uima.conceptMapper.support.dictionaryResource.EntryPropertiesRoot;
import org.apache.uima.conceptMapper.support.dictionaryResource.annotatorAdaptor.AnnotatorAdaptor;
import org.apache.uima.conceptMapper.support.tokens.TokenFilter;
import org.apache.uima.conceptMapper.support.tokens.TokenNormalizer;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.SharedResourceObject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DictionaryResource_impl
implements DictionaryResource,
SharedResourceObject {
    public static final String SAVE_COMPILED = "uima.conceptmapper.compiled_dictionary_directory";
    private static final File compDictDir;
    protected DictLoader dictLoader;
    protected Hashtable<String, DictionaryResource.DictEntriesByLength> dictImpl;
    protected EntryPropertiesRoot entryPropertiesRoot;
    protected static final int NumOfInitialDictEntries = 500000;
    boolean loaded;
    private static final Pattern ltPattern;
    private static final Pattern gtPattern;
    private static final Pattern aposPattern;
    private static final Pattern quotPattern;
    private static final Pattern ampPattern;
    public static final String PARAM_ORDERINDEPENDENTLOOKUP = "OrderIndependentLookup";
    private boolean sortElements = false;
    public static final String PARAM_DUMPDICT = "PrintDictionary";
    private boolean dumpDict = false;
    public static final String PARAM_CASE_MATCH = "caseMatch";
    public static final String PARAM_STEMMER_CLASS = "Stemmer";
    public static final String PARAM_STEMMER_DICT = "StemmerDictionary";
    private static final String PARAM_LANGID = "LanguageID";
    private static final String DEFAULT_LANGID = "en";
    public static final String PARAM_ATTRIBUTE_LIST = "AttributeList";
    public static final String PARAM_XML_PARSER = "XMLParserName";
    private String XMLParserName = null;
    public int entryNum = 0;

    public DictionaryResource_impl() {
        this.dictImpl = new Hashtable();
        this.loaded = false;
    }

    public DictionaryResource_impl(int initialDictEntries) {
        this.dictImpl = new Hashtable(initialDictEntries);
        this.loaded = false;
    }

    public DictLoader getDictLoader() {
        return this.dictLoader;
    }

    @Override
    public DictionaryResource.DictEntriesByLength getEntries(String key) {
        return this.dictImpl.get(key);
    }

    @Override
    public void putEntry(String key, String[] elements, String unsorted, int length, EntryProperties props) {
        DictionaryResource.DictEntriesByLength entry = this.getEntries(key);
        if (entry == null) {
            entry = new DictEntriesByLength_impl();
            this.dictImpl.put(key, entry);
        }
        entry.putEntry(length, elements, unsorted, props);
    }

    @Override
    public void load(DataResource data) throws ResourceInitializationException {
        try {
            Logger logger = new Logger("Dictionary Resource Loader", data.getLogger());
            this.dictLoader = new DictLoader(logger, this, data);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    @Override
    public void loadDictionaryContents(UimaContext aContext, Logger logger, String tokenAnnotationName, String tokenTypeFeatureName, String tokenClassFeatureName, String tokenizerDescriptor) throws ResourceInitializationException {
        InputStream dictStream = null;
        try {
            this.dictLoader.setLogger(logger);
            Boolean sortElementsParam = false;
            sortElementsParam = (Boolean)aContext.getConfigParameterValue(PARAM_ORDERINDEPENDENTLOOKUP);
            this.sortElements = sortElementsParam == null ? false : sortElementsParam;
            Boolean dumpDictParam = (Boolean)aContext.getConfigParameterValue(PARAM_DUMPDICT);
            this.dumpDict = dumpDictParam == null ? false : dumpDictParam;
            TokenNormalizer tokenNormalizer = new TokenNormalizer(aContext, logger);
            dictStream = this.dictLoader.getInputStream();
            TokenFilter tokenFilter = new TokenFilter(tokenAnnotationName, tokenTypeFeatureName, tokenClassFeatureName, logger);
            tokenFilter.initConfig(aContext);
            String langID = (String)aContext.getConfigParameterValue(PARAM_LANGID);
            if (langID == null || langID == "") {
                langID = DEFAULT_LANGID;
            }
            this.XMLParserName = (String)aContext.getConfigParameterValue(PARAM_XML_PARSER);
            String[] entryPropertyNames = (String[])aContext.getConfigParameterValue(PARAM_ATTRIBUTE_LIST);
            this.entryPropertiesRoot = new EntryPropertiesRoot(entryPropertyNames);
            URL dictUrl = this.dictLoader.dataResource.getUrl();
            String loadPath = null != dictUrl ? " from " + this.dictLoader.dataResource.getUrl().toString() : "";
            logger.logInfo("Loading Dictionary" + loadPath);
            this.dictLoader.setDictionary(dictStream, 500000, tokenAnnotationName, tokenTypeFeatureName, tokenClassFeatureName, tokenizerDescriptor, tokenFilter, tokenNormalizer, langID, this.entryPropertiesRoot);
            logger.logInfo("...done loading dictionary" + loadPath);
            if (compDictDir != null) {
                if (!compDictDir.exists() && !compDictDir.mkdirs()) {
                    logger.logError("Cannot create compiled dictionary output directory: " + compDictDir.toString());
                } else {
                    String n = dictUrl.getPath();
                    int i = n.lastIndexOf(File.separator);
                    n = i >= 0 ? n.substring(i + 1) : n;
                    BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(new File(compDictDir, n)));
                    this.serializeEntries(output);
                    output.close();
                }
            }
            this.setLoaded(true);
            if (this.dumpDict) {
                System.err.println("BEGIN DUMPING DICTIONARY:");
                System.err.println(this.toString());
                System.err.println("DONE DUMPING DICTIONARY! ");
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        finally {
            if (dictStream != null) {
                try {
                    dictStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    protected String convertEntities(String input) {
        String result = ltPattern.matcher(input).replaceAll("<");
        result = gtPattern.matcher(result).replaceAll(">");
        result = aposPattern.matcher(result).replaceAll("'");
        result = quotPattern.matcher(result).replaceAll("\"");
        result = ampPattern.matcher(result).replaceAll("&");
        return result;
    }

    @Override
    public DictionaryResource newDictionaryResource(int initialDictEntries) {
        return new DictionaryResource_impl(initialDictEntries);
    }

    @Override
    public Enumeration<String> keys() {
        return this.dictImpl.keys();
    }

    public static String stringTogetherTokens(String[] elements) {
        StringBuilder tokenString = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                tokenString.append(" ");
            }
            tokenString.append(elements[i]);
        }
        return tokenString.toString();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        Enumeration<String> e = this.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            result.append("<DictionaryItem key='" + key + "'>\n");
            DictEntriesByLength_impl item = (DictEntriesByLength_impl)this.getEntries(key);
            result.append(item.toString());
            result.append("</DictionaryItem>\n");
        }
        return result.toString();
    }

    public void serializeEntries(OutputStream output) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(output);
        oos.writeObject(this.entryPropertiesRoot);
        oos.writeObject(this.dictImpl);
        oos.close();
    }

    @Override
    public EntryPropertiesRoot getEntryPropertiesRoot() {
        return this.entryPropertiesRoot;
    }

    static {
        String p = System.getProperty(SAVE_COMPILED);
        compDictDir = p == null ? null : new File(p);
        ltPattern = Pattern.compile("&lt;");
        gtPattern = Pattern.compile("&gt;");
        aposPattern = Pattern.compile("&apos;");
        quotPattern = Pattern.compile("&quot;");
        ampPattern = Pattern.compile("&amp;");
    }

    private class DictLoader
    extends DefaultHandler {
        protected static final String DEFAULT_TOKEN_ELEM = "token";
        protected static final String DEFAULT_VARIANT_ELEM = "variant";
        protected static final String DEFAULT_KEY_ATTR = "base";
        private XMLReader parser = null;
        private String token_elem = "token";
        private String variant_elem = "variant";
        private String key_attribute = "base";
        private int term_cnt = 0;
        private Logger logger;
        private DictionaryResource dict;
        private EntryProperties props;
        private AnnotatorAdaptor adaptor;
        private String tokenAnnotationName;
        private String tokenizerDescriptor;
        private TokenFilter tokenFilter;
        private TokenNormalizer tokenNormalizer;
        private EntryPropertiesRoot entryPropertiesRoot;
        DataResource dataResource;
        private Vector<DictionaryToken> result;

        public DictLoader(Logger log, DictionaryResource dict, DataResource data) throws Exception {
            this.setLogger(log);
            this.dict = dict;
            this.dataResource = data;
            try {
                this.parser = DictionaryResource_impl.this.XMLParserName != null ? XMLReaderFactory.createXMLReader(DictionaryResource_impl.this.XMLParserName) : XMLReaderFactory.createXMLReader();
            }
            catch (Exception e) {
                log.logError("Unable to instantiate dictionary parser (" + (DictionaryResource_impl.this.XMLParserName == null ? "default XML parser" : DictionaryResource_impl.this.XMLParserName) + ")");
                throw e;
            }
            this.parser.setContentHandler(this);
            this.parser.setErrorHandler(this);
        }

        protected String getTokenAnnotationName() {
            return this.tokenAnnotationName;
        }

        protected void setTokenAnnotationName(String tokenAnnotationName) {
            this.tokenAnnotationName = tokenAnnotationName;
        }

        protected String getTokenizerDescriptor() {
            return this.tokenizerDescriptor;
        }

        protected void setTokenizerDescriptor(String tokenizerDescriptor) {
            this.tokenizerDescriptor = tokenizerDescriptor;
        }

        protected void setTokenFilter(TokenFilter tokenFilter) {
            this.tokenFilter = tokenFilter;
        }

        protected TokenFilter getTokenFilter() {
            return this.tokenFilter;
        }

        protected void setTokenNormalizer(TokenNormalizer tokenNormalizer) {
            this.tokenNormalizer = tokenNormalizer;
        }

        protected void setEntryPropertiesRoot(EntryPropertiesRoot entryPropertiesRoot) {
            this.entryPropertiesRoot = entryPropertiesRoot;
        }

        protected EntryPropertiesRoot getPropertiesRoot() {
            return this.entryPropertiesRoot;
        }

        protected TokenNormalizer getTokenNormalizer() {
            return this.tokenNormalizer;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public void setLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
            DictionaryToken token = null;
            int length = 0;
            if (raw.equals(this.token_elem)) {
                if (attrs != null) {
                    this.props = this.getPropertiesRoot().newEntryProperties();
                    int attrCount = attrs.getLength();
                    for (int i = 0; i < attrCount; ++i) {
                        this.props.setProperty(attrs.getQName(i), DictionaryResource_impl.this.convertEntities(attrs.getValue(i)));
                    }
                }
            } else if (raw.equals(this.variant_elem) && attrs != null) {
                int attrCount = attrs.getLength();
                ArrayList<String> tokens = new ArrayList<String>();
                EntryProperties variantProperties = new EntryProperties(this.props);
                for (int i = 0; i < attrCount; ++i) {
                    if (attrs.getQName(i).equals(this.key_attribute)) {
                        this.adaptor.runCPM(DictionaryResource_impl.this.convertEntities(attrs.getValue(i)));
                        Iterator<DictionaryToken> tokenIter = this.result.iterator();
                        token = null;
                        while (tokenIter.hasNext() && !this.tokenFilter.isOK_Token(token = tokenIter.next(), this.tokenNormalizer)) {
                        }
                        if (token == null) {
                            return;
                        }
                        tokens.add(this.tokenNormalizer.normalize(token.getText()));
                        length = 1;
                        while (tokenIter.hasNext()) {
                            token = tokenIter.next();
                            String tokenText = this.tokenNormalizer.normalize(token.getText());
                            if (!this.tokenFilter.isOK_Token(token, this.tokenNormalizer)) continue;
                            tokens.add(tokenText);
                            ++length;
                        }
                        continue;
                    }
                    variantProperties.setProperty(attrs.getQName(i), DictionaryResource_impl.this.convertEntities(attrs.getValue(i)));
                }
                Object[] elements = tokens.toArray(new String[tokens.size()]);
                String unsorted = null;
                if (DictionaryResource_impl.this.sortElements) {
                    unsorted = DictionaryResource_impl.stringTogetherTokens((String[])elements);
                    Arrays.sort(elements);
                }
                if (DictionaryResource_impl.this.sortElements) {
                    for (int i = 0; i < tokens.size(); ++i) {
                        this.dict.putEntry((String)tokens.get(i), (String[])elements, unsorted, elements.length, variantProperties);
                    }
                } else {
                    this.dict.putEntry((String)tokens.get(0), (String[])elements, unsorted, elements.length, variantProperties);
                }
                ++this.term_cnt;
                if (this.term_cnt % 10000 == 0) {
                    this.getLogger().logInfo("processed " + this.term_cnt + " entries");
                }
            }
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            this.getLogger().logWarning(this.errorString("Warning", ex));
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this.getLogger().logError(this.errorString("Fatal Error", ex));
            throw ex;
        }

        protected String errorString(String type, SAXParseException ex) {
            String errorMsg = "[" + type + "]";
            if (ex == null) {
                return errorMsg + "!!!";
            }
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                errorMsg = errorMsg + systemId;
            }
            errorMsg = errorMsg + ":" + ex.getLineNumber() + ":" + ex.getColumnNumber() + ": " + ex.getMessage();
            return errorMsg;
        }

        public void setDictionary(InputStream dictStream, int initialDictEntries, String tokenAnnotationName, String tokenTypeFeatureName, String tokenClassFeatureName, String tokenizerDescriptor, TokenFilter tokenFilter, TokenNormalizer tokenNormalizer, String langID, EntryPropertiesRoot entryPropertiesRoot) throws DictionaryLoaderException {
            this.term_cnt = 0;
            this.setTokenAnnotationName(tokenAnnotationName);
            this.setTokenizerDescriptor(tokenizerDescriptor);
            this.setTokenFilter(tokenFilter);
            this.setTokenNormalizer(tokenNormalizer);
            this.result = new Vector();
            this.setEntryPropertiesRoot(entryPropertiesRoot);
            this.getLogger().logInfo("Loading dictionary");
            try {
                this.adaptor = new AnnotatorAdaptor(this.getTokenizerDescriptor(), this.result, tokenAnnotationName, tokenFilter, langID, this.getLogger());
                this.adaptor.initCPM();
                this.parser.parse(new InputSource(dictStream));
            }
            catch (SAXException e) {
                this.getLogger().logError("Parse error occurred - " + e.getMessage());
                throw new DictionaryLoaderException(e);
            }
            catch (IOException e) {
                throw new DictionaryLoaderException(e);
            }
            this.getLogger().logInfo("Finished loading " + this.term_cnt + " entries");
        }

        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(this.dataResource.getInputStream());
        }
    }

    public static class DictEntryImpl
    implements DictionaryResource.DictEntry {
        private static final long serialVersionUID = -7723934333674544157L;
        String[] elements;
        String unsorted;
        EntryProperties properties;

        public DictEntryImpl(String[] elements, String unsorted, EntryProperties properties) {
            this.properties = properties;
            this.unsorted = unsorted;
            this.elements = elements;
        }

        @Override
        public void setProperties(EntryProperties properties) {
            this.properties = properties;
        }

        @Override
        public EntryProperties getProperties() {
            return this.properties;
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder("<DictEntry Text ='[");
            boolean firstTime = true;
            for (String element : this.getElements()) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    result.append(", ");
                }
                result.append(element);
            }
            result.append("''>");
            result.append("</DictEntry>\n");
            return result.toString();
        }

        @Override
        public String getUnsorted() {
            return this.unsorted;
        }

        @Override
        public void setUnsorted(String unsorted) {
            this.unsorted = unsorted;
        }

        @Override
        public String[] getElements() {
            return this.elements;
        }

        @Override
        public void setElements(String[] elements) {
            this.elements = elements;
        }
    }

    public static class DictEntriesImpl
    extends ArrayList<DictionaryResource.DictEntry>
    implements DictionaryResource.DictEntries {
        private static final long serialVersionUID = 1L;

        @Override
        public void putEntry(String[] elements, String unsorted, EntryProperties props) {
            this.add(new DictEntryImpl(elements, unsorted, props));
        }

        @Override
        public ArrayList<DictionaryResource.DictEntry> getEntries() {
            return this;
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder("<DictEntries>");
            for (int i = 0; i < this.size(); ++i) {
                result.append(((DictEntryImpl)this.get(i)).toString());
            }
            result.append("</DictEntries>");
            return result.toString();
        }
    }

    private static class DictEntriesByLength_impl
    implements DictionaryResource.DictEntriesByLength {
        private static final long serialVersionUID = -8150386021246495622L;
        TreeMap<Integer, DictionaryResource.DictEntries> entries = new TreeMap(new ReverseOrderIntegerComparator());

        @Override
        public DictionaryResource.DictEntries getEntries(int length) {
            return this.entries.get(length);
        }

        @Override
        public void putEntry(int length, String[] elements, String unsorted, EntryProperties props) {
            DictionaryResource.DictEntries entry = this.getEntries(length);
            if (entry == null) {
                entry = new DictEntriesImpl();
                this.entries.put(length, entry);
            }
            entry.putEntry(elements, unsorted, props);
        }

        @Override
        public Integer getLongest() {
            return this.entries.firstKey();
        }

        @Override
        public Integer getShortest() {
            return this.entries.lastKey();
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            int last = this.getShortest();
            for (int i = this.getLongest().intValue(); i >= last; --i) {
                DictEntriesImpl entries = (DictEntriesImpl)this.getEntries(i);
                if (entries == null) continue;
                result.append("<DictEntriesByLength length='" + i + "'>\n");
                result.append(entries.toString());
                result.append("</DictEntriesByLength>\n");
            }
            return result.toString();
        }

        private static class ReverseOrderIntegerComparator
        implements Comparator<Integer>,
        Serializable {
            private static final long serialVersionUID = -805437355806223406L;

            private ReverseOrderIntegerComparator() {
            }

            @Override
            public int compare(Integer left, Integer right) {
                return right.compareTo(left);
            }
        }
    }
}

