/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.uima.ruta.resource.RutaTable;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.resource.TreeWordList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVTable
implements RutaTable {
    private List<List<String>> tableData;
    private Map<Integer, RutaWordList> columnWordLists = new HashMap<Integer, RutaWordList>(2);

    public CSVTable(String location) {
        try {
            this.buildTable(location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildTable(String location) throws Exception {
        FileInputStream in = new FileInputStream(location);
        Scanner sc = new Scanner((InputStream)in, Charset.forName("UTF-8").name());
        sc.useDelimiter("\\n");
        this.tableData = new ArrayList<List<String>>();
        while (sc.hasNext()) {
            String line = sc.next().trim();
            line = line.replaceAll(";;", "; ;");
            String[] lineElements = line.split(";");
            List<String> row = Arrays.asList(lineElements);
            this.tableData.add(row);
        }
    }

    @Override
    public RutaWordList getWordList(int index) {
        RutaWordList list = this.columnWordLists.get(index);
        if (list == null && index > 0 && index <= this.tableData.get(0).size()) {
            list = new TreeWordList(this.getColumnData(index - 1));
            this.columnWordLists.put(index, list);
        }
        return list;
    }

    private List<String> getColumnData(int i) {
        LinkedList<String> result = new LinkedList<String>();
        for (List<String> each : this.tableData) {
            if (each.size() > i) {
                result.add(each.get(i));
                continue;
            }
            result.add("");
        }
        return result;
    }

    @Override
    public String getEntry(int row, int column) {
        return this.tableData.get(row).get(column);
    }

    @Override
    public List<String> getRowWhere(int column, String value) {
        List<String> columnData = this.getColumnData(column);
        int i = 0;
        for (String string : columnData) {
            if (string.toLowerCase().equals(value.toLowerCase())) {
                return this.tableData.get(i);
            }
            ++i;
        }
        return new ArrayList<String>();
    }
}

