/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.ruta.engine.HtmlConverterPSpan;
import org.apache.uima.ruta.engine.HtmlConverterPSpanReplacement;
import org.apache.uima.ruta.engine.HtmlConverterVisitor;
import org.apache.uima.util.CasCopier;
import org.apache.uima.util.Level;
import org.htmlparser.Parser;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlConverter
extends JCasAnnotator_ImplBase {
    public static final String NAMESPACE = "org.apache.uima.ruta.type.html.";
    public static final String OUTPUT_VIEW = "outputView";
    public static final String INPUT_VIEW = "inputView";
    public static final String REPLACE_LINEBREAKS = "replaceLinebreaks";
    public static final String LINEBREAK = "\n";
    public static final String NEWLINE_INDUCING_TAGS = "newlineInducingTags";
    public static final String CONVERSION_POLICY = "conversionPolicy";
    public static final String CONVERSION_PATTERNS = "conversionPatterns";
    public static final String CONVERSION_REPLACEMENTS = "conversionReplacements";
    private static final String DEFAULT_MODIFIED_VIEW = "plaintext";
    private String inputViewName;
    private String modifiedViewName;
    private Set<String> newlineInducingTags;
    private String[] conversionPatterns;
    private String[] conversionReplacements;
    private Boolean replaceLinebreaks;
    private StringConversionPolicy conversionPolicy;
    private int[] map;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.inputViewName = (String)aContext.getConfigParameterValue(INPUT_VIEW);
        this.inputViewName = StringUtils.isBlank(this.inputViewName) ? null : this.inputViewName;
        this.modifiedViewName = (String)aContext.getConfigParameterValue(OUTPUT_VIEW);
        this.modifiedViewName = StringUtils.isBlank(this.modifiedViewName) ? DEFAULT_MODIFIED_VIEW : this.modifiedViewName;
        this.replaceLinebreaks = (Boolean)aContext.getConfigParameterValue(REPLACE_LINEBREAKS);
        this.replaceLinebreaks = this.replaceLinebreaks == null ? true : this.replaceLinebreaks;
        String conversionPolicyString = (String)aContext.getConfigParameterValue(CONVERSION_POLICY);
        String string = conversionPolicyString = conversionPolicyString == null ? null : conversionPolicyString.toLowerCase();
        if (StringUtils.isBlank(conversionPolicyString) || conversionPolicyString.equals("heuristic")) {
            this.conversionPolicy = StringConversionPolicy.HEURISTIC;
        } else if (conversionPolicyString.equals("explicit")) {
            this.conversionPolicy = StringConversionPolicy.EXPLICIT;
        } else if (conversionPolicyString.equals("none")) {
            this.conversionPolicy = StringConversionPolicy.NONE;
        } else {
            throw new ResourceInitializationException("illegal conversionPolicy parameter value", new Object[0]);
        }
        this.newlineInducingTags = new HashSet<String>();
        String[] nlTags = (String[])aContext.getConfigParameterValue(NEWLINE_INDUCING_TAGS);
        if (nlTags == null || nlTags.length == 0) {
            this.newlineInducingTags.add("br");
            this.newlineInducingTags.add("p");
            this.newlineInducingTags.add("div");
            this.newlineInducingTags.add("ul");
            this.newlineInducingTags.add("ol");
            this.newlineInducingTags.add("dl");
            this.newlineInducingTags.add("li");
            this.newlineInducingTags.add("h1");
            this.newlineInducingTags.add("h2");
            this.newlineInducingTags.add("h3");
            this.newlineInducingTags.add("h4");
            this.newlineInducingTags.add("h5");
            this.newlineInducingTags.add("h6");
            this.newlineInducingTags.add("blockquote");
        } else {
            for (String nlTag : nlTags) {
                this.newlineInducingTags.add(nlTag);
            }
            if (this.modifiedViewName.equals(this.inputViewName)) {
                throw new ResourceInitializationException("input and output view names must differ!", new Object[0]);
            }
        }
        this.conversionPatterns = (String[])aContext.getConfigParameterValue(CONVERSION_PATTERNS);
        if (this.conversionPatterns == null) {
            this.conversionPatterns = new String[]{"&nbsp;", "&laquo;", "&raquo;", "&quot;", "&amp;", "&lt;", "&gt;", "&apos;", "&sect;", "&uml;", "&copy;", "&trade;", "&reg;", "&ouml;", "&auml;", "&uuml;", "&#160;"};
        }
        this.conversionReplacements = (String[])aContext.getConfigParameterValue(CONVERSION_REPLACEMENTS);
        if (this.conversionReplacements == null) {
            this.conversionReplacements = new String[this.conversionPatterns.length];
            for (int i = 0; i < this.conversionPatterns.length; ++i) {
                String rep;
                String c = this.conversionPatterns[i];
                this.conversionReplacements[i] = rep = StringEscapeUtils.unescapeHtml4(c);
            }
        }
    }

    public void process(JCas jcaz) throws AnalysisEngineProcessException {
        JCas jcas;
        try {
            jcas = this.inputViewName != null ? jcaz.getView(this.inputViewName) : jcaz;
        }
        catch (CASException e1) {
            throw new AnalysisEngineProcessException(e1.getCause());
        }
        String documentText = jcas.getDocumentText();
        String splitSeq = documentText.contains("\r\n") ? "\r\n" : LINEBREAK;
        this.map = new int[documentText.length() + 1];
        JCas modview = null;
        try {
            Iterator viewIterator = jcas.getViewIterator();
            while (viewIterator.hasNext()) {
                JCas jCas2 = (JCas)viewIterator.next();
                if (!jCas2.getViewName().equals(this.modifiedViewName)) continue;
                modview = jCas2;
                this.getContext().getLogger().log(Level.WARNING, "view with name \"" + this.modifiedViewName + "\" already exists.");
            }
            if (modview == null) {
                modview = jcas.createView(this.modifiedViewName);
            }
        }
        catch (CASException e) {
            e.printStackTrace();
            return;
        }
        SortedSet<Object> visibleSpansSoFar = new TreeSet();
        SortedSet<Object> linebreaksFromHtmlTags = new TreeSet();
        try {
            Parser parser = new Parser(documentText);
            NodeList list = parser.parse(null);
            HtmlConverterVisitor visitor = new HtmlConverterVisitor(this.newlineInducingTags);
            list.visitAllNodesWith(visitor);
            visibleSpansSoFar = visitor.getTextSpans();
            linebreaksFromHtmlTags = visitor.getLinebreaksFromHtmlTags();
        }
        catch (ParserException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        if (this.replaceLinebreaks.booleanValue()) {
            visibleSpansSoFar = this.handleLinebreaksInDocumentText(visibleSpansSoFar, splitSeq);
        }
        if (this.conversionPolicy == StringConversionPolicy.HEURISTIC) {
            visibleSpansSoFar = this.htmlDecoding(visibleSpansSoFar);
        } else if (this.conversionPolicy == StringConversionPolicy.EXPLICIT) {
            for (int i = 0; i < this.conversionPatterns.length; ++i) {
                String pat = this.conversionPatterns[i];
                String rep = this.conversionReplacements[i];
                visibleSpansSoFar = this.handleConversion(visibleSpansSoFar, pat, rep);
            }
        }
        visibleSpansSoFar.addAll(linebreaksFromHtmlTags);
        StringBuffer sbu = new StringBuffer(documentText.length());
        int originalOffsetI = 0;
        int outOffset = 0;
        for (HtmlConverterPSpan htmlConverterPSpan : visibleSpansSoFar) {
            int begin = htmlConverterPSpan.getBegin();
            int end = htmlConverterPSpan.getEnd();
            while (originalOffsetI < begin) {
                this.map[originalOffsetI++] = outOffset;
            }
            String s = "";
            if (htmlConverterPSpan instanceof HtmlConverterPSpanReplacement) {
                s = htmlConverterPSpan.getTxt();
                while (originalOffsetI < begin + s.length()) {
                    this.map[originalOffsetI++] = outOffset++;
                }
                while (originalOffsetI < end) {
                    this.map[originalOffsetI++] = outOffset;
                }
            } else {
                s = documentText.substring(begin, end);
                while (originalOffsetI < end) {
                    this.map[originalOffsetI++] = outOffset++;
                }
            }
            sbu.append(s);
        }
        while (originalOffsetI < documentText.length()) {
            this.map[originalOffsetI++] = outOffset;
        }
        this.map[documentText.length()] = outOffset + 1;
        String modTxt = sbu.toString();
        modview.setDocumentText(modTxt);
        try {
            this.mapAnnotations(jcas, this.map, this.modifiedViewName);
        }
        catch (CASException cASException) {
            cASException.printStackTrace();
        }
    }

    private void mapAnnotations(JCas fromJcas, int[] map, String toView) throws CASException {
        JCas modview = fromJcas.getView(toView);
        HashSet<Annotation> indexedFs = new HashSet<Annotation>();
        AnnotationIndex annotationIndex = fromJcas.getAnnotationIndex();
        CasCopier casCopier = new CasCopier(fromJcas.getCas(), modview.getCas());
        for (Annotation annotation : annotationIndex) {
            int mappedEnd;
            if (annotation instanceof DocumentAnnotation) continue;
            Annotation clone = (Annotation)casCopier.copyFs((FeatureStructure)annotation);
            clone.setFeatureValue(modview.getTypeSystem().getFeatureByFullName("uima.tcas.Annotation:sofa"), (FeatureStructure)modview.getSofa());
            int mappedBegin = map[clone.getBegin()];
            if (mappedBegin >= (mappedEnd = map[clone.getEnd()])) continue;
            if (mappedEnd > fromJcas.getCas().getDocumentAnnotation().getEnd()) {
                this.getContext().getLogger().log(Level.WARNING, "illegal annotation offset mapping");
                continue;
            }
            clone.setBegin(mappedBegin);
            clone.setEnd(mappedEnd);
            modview.addFsToIndexes((FeatureStructure)clone);
            indexedFs.add(clone);
        }
    }

    private SortedSet<HtmlConverterPSpan> handleLinebreaksInDocumentText(SortedSet<HtmlConverterPSpan> visibleSpansSoFar, String splitSeq) {
        return this.handleConversion(visibleSpansSoFar, splitSeq, "");
    }

    private SortedSet<HtmlConverterPSpan> htmlDecoding(SortedSet<HtmlConverterPSpan> visibleSpansSoFar) {
        TreeSet<HtmlConverterPSpan> copy = new TreeSet<HtmlConverterPSpan>(visibleSpansSoFar);
        Pattern patt = Pattern.compile("(&[a-zA-Z]{2,5};)|(&#\\d{2,5};)");
        for (HtmlConverterPSpan pSpan : visibleSpansSoFar) {
            String spanTxt = pSpan.getTxt();
            Matcher matcher = patt.matcher(spanTxt);
            if (!matcher.find()) continue;
            copy.remove(pSpan);
            int pSpanBegin = pSpan.getBegin();
            int ioff = pSpan.getBegin();
            do {
                String sourceString = matcher.group();
                String replacement = StringEscapeUtils.unescapeHtml4(sourceString);
                HtmlConverterPSpanReplacement replacementSpan = new HtmlConverterPSpanReplacement(pSpanBegin + matcher.start(), pSpanBegin + matcher.end(), replacement);
                copy.add(replacementSpan);
                int replacementLength = sourceString.length();
                if (pSpanBegin + matcher.end() > ioff + replacementLength) {
                    int ib = ioff;
                    int ie = pSpanBegin + matcher.start();
                    String newTxt = spanTxt.substring(ib - pSpanBegin, ie - pSpanBegin);
                    copy.add(new HtmlConverterPSpan(ib, ie, newTxt));
                    ioff = ie;
                }
                ioff += replacementLength;
            } while (matcher.find());
            if (ioff >= pSpan.getEnd()) continue;
            int ib = ioff;
            int ie = pSpan.getEnd();
            String newTxt = spanTxt.substring(ib - pSpanBegin, ie - pSpanBegin);
            copy.add(new HtmlConverterPSpan(ioff, pSpan.getEnd(), newTxt));
        }
        return copy;
    }

    private SortedSet<HtmlConverterPSpan> handleConversion(SortedSet<HtmlConverterPSpan> visibleSpansSoFar, String patternString, String replacement) {
        TreeSet<HtmlConverterPSpan> copy = new TreeSet<HtmlConverterPSpan>(visibleSpansSoFar);
        Pattern patt = Pattern.compile(patternString);
        int replacementLength = patternString.length();
        for (HtmlConverterPSpan pSpan : visibleSpansSoFar) {
            String newTxt;
            int ie;
            String spanTxt = pSpan.getTxt();
            Matcher matcher = patt.matcher(spanTxt);
            if (!matcher.find()) continue;
            copy.remove(pSpan);
            int pSpanBegin = pSpan.getBegin();
            int ioff = pSpan.getBegin();
            do {
                if (!StringUtils.isEmpty(replacement)) {
                    HtmlConverterPSpanReplacement replacementSpan = new HtmlConverterPSpanReplacement(pSpanBegin + matcher.start(), pSpanBegin + matcher.end(), replacement);
                    copy.add(replacementSpan);
                }
                if (pSpanBegin + matcher.end() > ioff + replacementLength) {
                    int ib = ioff;
                    ie = pSpanBegin + matcher.start();
                    newTxt = spanTxt.substring(ib - pSpanBegin, ie - pSpanBegin);
                    copy.add(new HtmlConverterPSpan(ib, ie, newTxt));
                    ioff = ie;
                }
                ioff += replacementLength;
            } while (matcher.find());
            if (ioff >= pSpan.getEnd()) continue;
            int ib = ioff;
            ie = pSpan.getEnd();
            newTxt = spanTxt.substring(ib - pSpanBegin, ie - pSpanBegin);
            copy.add(new HtmlConverterPSpan(ioff, pSpan.getEnd(), newTxt));
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StringConversionPolicy {
        HEURISTIC,
        EXPLICIT,
        NONE;

    }
}

