/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql.whereclausebuilder;

import java.util.stream.Stream;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.WhereClauseExpression;
import org.apache.torque.sql.whereclausebuilder.AbstractWhereClausePsPartBuilder;
import org.apache.torque.sql.whereclausebuilder.CombinedPreparedStatementPart;

public class LikeBuilder
extends AbstractWhereClausePsPartBuilder {
    private static final char BACKSLASH = '\\';

    @Override
    public PreparedStatementPart buildPs(WhereClauseExpression whereClausePart, boolean ignoreCase, Query query, Adapter adapter) throws TorqueException {
        CombinedPreparedStatementPart result;
        int position;
        if (!(whereClausePart.getRValue() instanceof String)) {
            throw new TorqueException("rValue must be a String for the operator " + whereClausePart.getOperator());
        }
        String value = (String)whereClausePart.getRValue();
        StringBuilder sb = new StringBuilder();
        boolean replaceWithEquals = true;
        for (position = 0; position < value.length(); ++position) {
            char checkWildcard = value.charAt(position);
            switch (checkWildcard) {
                case '\\': {
                    char escapedChar;
                    if (position + 1 >= value.length()) break;
                    if ((escapedChar = value.charAt(++position)) != '*' && escapedChar != '?') {
                        sb.append(checkWildcard);
                    }
                    checkWildcard = escapedChar;
                    break;
                }
                case '%': 
                case '_': {
                    replaceWithEquals = false;
                    break;
                }
                case '*': {
                    replaceWithEquals = false;
                    checkWildcard = '%';
                    break;
                }
                case '?': {
                    replaceWithEquals = false;
                    checkWildcard = '_';
                    break;
                }
            }
            sb.append(checkWildcard);
        }
        value = sb.toString();
        if (ignoreCase) {
            if (adapter.useIlike() && !replaceWithEquals) {
                if (SqlEnum.LIKE.equals(whereClausePart.getOperator())) {
                    whereClausePart.setOperator(SqlEnum.ILIKE);
                } else if (SqlEnum.NOT_LIKE.equals(whereClausePart.getOperator())) {
                    whereClausePart.setOperator(SqlEnum.NOT_ILIKE);
                }
                result = new CombinedPreparedStatementPart(LikeBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), false, query, adapter));
            } else {
                result = new CombinedPreparedStatementPart(LikeBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), true, query, adapter));
            }
        } else {
            result = new CombinedPreparedStatementPart(LikeBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), ignoreCase, query, adapter));
        }
        if (replaceWithEquals && !whereClausePart.getOperator().equals(SqlEnum.NOT_ILIKE) && !whereClausePart.getOperator().equals(SqlEnum.ILIKE)) {
            if (whereClausePart.getOperator().equals(SqlEnum.NOT_LIKE) || whereClausePart.getOperator().equals(SqlEnum.NOT_ILIKE)) {
                result.appendSql(SqlEnum.NOT_EQUAL.toString());
            } else {
                result.appendSql(SqlEnum.EQUAL.toString());
            }
            sb = new StringBuilder();
            for (position = 0; position < value.length(); ++position) {
                char checkWildcard = value.charAt(position);
                if (checkWildcard == '\\' && position + 1 < value.length()) {
                    checkWildcard = value.charAt(++position);
                }
                sb.append(checkWildcard);
            }
            value = sb.toString();
        } else {
            result.appendSql(whereClausePart.getOperator().toString());
        }
        String rValueSql = "?";
        if (ignoreCase && (!adapter.useIlike() || replaceWithEquals)) {
            rValueSql = adapter.ignoreCase(rValueSql);
        }
        if (!replaceWithEquals && adapter.useEscapeClauseForLike()) {
            rValueSql = rValueSql + SqlEnum.ESCAPE + "'\\'";
        }
        result.addPreparedStatementReplacement(value);
        result.appendSql(rValueSql);
        return result;
    }

    @Override
    public boolean isApplicable(WhereClauseExpression whereClauseExpression, Adapter adapter) {
        return Stream.of(SqlEnum.LIKE, SqlEnum.NOT_LIKE, SqlEnum.ILIKE, SqlEnum.NOT_ILIKE).anyMatch(sqlEnum -> whereClauseExpression.getOperator().equals(sqlEnum));
    }
}

