/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.pool.InstrumentedResourceLimitingPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Poolable;

public class TraceableResourceLimitingPool
extends InstrumentedResourceLimitingPool {
    private boolean m_tracing;
    private Map m_elementMap;

    public TraceableResourceLimitingPool(ObjectFactory factory, int max, boolean maxStrict, boolean blocking, long blockTimeout, long trimInterval, boolean trace) {
        super(factory, max, maxStrict, blocking, blockTimeout, trimInterval);
        this.m_tracing = trace;
        if (this.m_tracing) {
            this.m_elementMap = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Poolable get() throws Exception {
        if (this.m_tracing) {
            Object object = this.m_semaphore;
            synchronized (object) {
                Poolable poolable = super.get();
                PoolElement element = (PoolElement)this.m_elementMap.get(poolable);
                if (element == null) {
                    element = new PoolElement(poolable);
                    this.m_elementMap.put(poolable, element);
                }
                element.trace();
                return poolable;
            }
        }
        return super.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Poolable poolable) {
        if (this.m_tracing) {
            Object object = this.m_semaphore;
            synchronized (object) {
                PoolElement element = (PoolElement)this.m_elementMap.get(poolable);
                if (element == null) {
                    this.getLogger().error("PoolElement not found in put for poolable: " + poolable);
                } else {
                    element.clear();
                }
                super.put(poolable);
            }
        } else {
            super.put(poolable);
        }
    }

    protected void removePoolable(Poolable poolable) {
        PoolElement element;
        if (this.m_tracing && (element = (PoolElement)this.m_elementMap.remove(poolable)) == null) {
            this.getLogger().error("PoolElement not found in removePoolable for poolable: " + poolable);
        }
        super.removePoolable(poolable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        if (this.m_tracing) {
            Object object = this.m_semaphore;
            synchronized (object) {
                int count = 0;
                Iterator iter = this.m_elementMap.values().iterator();
                while (iter.hasNext()) {
                    PoolElement element = (PoolElement)iter.next();
                    if (element.m_thread == null) continue;
                    ++count;
                }
                Thread[] threads = new Thread[count];
                TraceException[] traceExceptions = new TraceException[count];
                long[] traceTimes = new long[count];
                if (count > 0) {
                    int i = 0;
                    Iterator iter2 = this.m_elementMap.values().iterator();
                    while (iter2.hasNext()) {
                        PoolElement element = (PoolElement)iter2.next();
                        if (element.m_thread == null) continue;
                        threads[i] = element.m_thread;
                        traceExceptions[i] = element.m_traceException;
                        traceTimes[i] = element.m_time;
                        ++i;
                    }
                }
                return new State(this.getSize(), this.getReadySize(), threads, traceExceptions, traceTimes);
            }
        }
        throw new IllegalStateException("Trace is disabled for this pool.");
    }

    public static class TraceException
    extends RuntimeException {
        private TraceException() {
        }
    }

    private static class PoolElement {
        private Poolable m_poolable;
        private Thread m_thread;
        private TraceException m_traceException;
        private long m_time;

        private PoolElement(Poolable poolable) {
            this.m_poolable = poolable;
        }

        private void trace() {
            this.m_thread = Thread.currentThread();
            this.m_traceException = new TraceException();
            this.m_traceException.fillInStackTrace();
            this.m_time = System.currentTimeMillis();
        }

        private void clear() {
            this.m_thread = null;
            this.m_traceException = null;
        }
    }

    public static class State {
        private int m_size;
        private int m_readySize;
        private Thread[] m_threads;
        private TraceException[] m_traceExceptions;
        private long[] m_traceTimes;

        private State(int size, int readySize, Thread[] threads, TraceException[] traceExceptions, long[] traceTimes) {
            this.m_size = size;
            this.m_readySize = readySize;
            this.m_threads = threads;
            this.m_traceExceptions = traceExceptions;
            this.m_traceTimes = traceTimes;
        }

        public int getSize() {
            return this.m_size;
        }

        public int getReadySize() {
            return this.m_readySize;
        }

        public Thread[] getTraceThreads() {
            return this.m_threads;
        }

        public TraceException[] getTraceExceptions() {
            return this.m_traceExceptions;
        }

        public long[] getTraceTimes() {
            return this.m_traceTimes;
        }
    }
}

