/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import com.workingdogs.village.DataSetException;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueRuntimeException;
import org.apache.torque.map.MapBuilder;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.JobEntryPeer;

public abstract class BaseJobEntryPeer
extends BasePeer {
    private static final long serialVersionUID = 1308842746584L;
    public static final String DATABASE_NAME = "default";
    public static final String TABLE_NAME = "TURBINE_SCHEDULED_JOB";
    public static final String JOB_ID = "TURBINE_SCHEDULED_JOB.JOB_ID";
    public static final String SECOND = "TURBINE_SCHEDULED_JOB.SECOND";
    public static final String MINUTE = "TURBINE_SCHEDULED_JOB.MINUTE";
    public static final String HOUR = "TURBINE_SCHEDULED_JOB.HOUR";
    public static final String WEEK_DAY = "TURBINE_SCHEDULED_JOB.WEEK_DAY";
    public static final String DAY_OF_MONTH = "TURBINE_SCHEDULED_JOB.DAY_OF_MONTH";
    public static final String TASK = "TURBINE_SCHEDULED_JOB.TASK";
    public static final String EMAIL = "TURBINE_SCHEDULED_JOB.EMAIL";
    public static final String PROPERTY = "TURBINE_SCHEDULED_JOB.PROPERTY";
    public static final int numColumns = 9;
    protected static final String CLASSNAME_DEFAULT = "org.apache.turbine.services.schedule.JobEntry";
    protected static final Class CLASS_DEFAULT;

    public static MapBuilder getMapBuilder() throws TorqueException {
        return Torque.getMapBuilder((String)"org.apache.turbine.services.schedule.map.JobEntryMapBuilder");
    }

    private static Class initClass(String className) {
        Class<?> c;
        block2: {
            c = null;
            try {
                c = Class.forName(className);
            }
            catch (Throwable t) {
                log.error((Object)"A FATAL ERROR has occurred which should not have happened under any circumstance.  Please notify the Torque developers <torque-dev@db.apache.org> and give as many details as possible (including the error stack trace).", t);
                if (!(t instanceof Error)) break block2;
                throw (Error)t.fillInStackTrace();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JobEntry> resultSet2Objects(ResultSet results) throws TorqueException {
        try {
            QueryDataSet qds = null;
            List<Record> rows = null;
            try {
                qds = new QueryDataSet(results);
                rows = BaseJobEntryPeer.getSelectResults(qds);
            }
            finally {
                if (qds != null) {
                    qds.close();
                }
            }
            return BaseJobEntryPeer.populateObjects(rows);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
        catch (DataSetException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static ObjectKey doInsert(Criteria criteria) throws TorqueException {
        return BaseJobEntryPeer.doInsert(criteria, (Connection)null);
    }

    public static ObjectKey doInsert(Criteria criteria, Connection con) throws TorqueException {
        BaseJobEntryPeer.correctBooleans(criteria);
        BaseJobEntryPeer.setDbName(criteria);
        if (con == null) {
            return BasePeer.doInsert((Criteria)criteria);
        }
        return BasePeer.doInsert((Criteria)criteria, (Connection)con);
    }

    public static void addSelectColumns(Criteria criteria) throws TorqueException {
        criteria.addSelectColumn(JOB_ID);
        criteria.addSelectColumn(SECOND);
        criteria.addSelectColumn(MINUTE);
        criteria.addSelectColumn(HOUR);
        criteria.addSelectColumn(WEEK_DAY);
        criteria.addSelectColumn(DAY_OF_MONTH);
        criteria.addSelectColumn(TASK);
        criteria.addSelectColumn(EMAIL);
        criteria.addSelectColumn(PROPERTY);
    }

    public static void correctBooleans(Criteria criteria) throws TorqueException {
        BaseJobEntryPeer.correctBooleans((Criteria)criteria, (TableMap)BaseJobEntryPeer.getTableMap());
    }

    public static JobEntry row2Object(Record row, int offset, Class cls) throws TorqueException {
        try {
            JobEntry obj = (JobEntry)((Object)cls.newInstance());
            JobEntryPeer.populateObject(row, offset, obj);
            obj.setModified(false);
            obj.setNew(false);
            return obj;
        }
        catch (InstantiationException e) {
            throw new TorqueException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static void populateObject(Record row, int offset, JobEntry obj) throws TorqueException {
        try {
            obj.setJobId(row.getValue(offset + 0).asInt());
            obj.setSecond(row.getValue(offset + 1).asInt());
            obj.setMinute(row.getValue(offset + 2).asInt());
            obj.setHour(row.getValue(offset + 3).asInt());
            obj.setWeekDay(row.getValue(offset + 4).asInt());
            obj.setDayOfMonth(row.getValue(offset + 5).asInt());
            obj.setTask(row.getValue(offset + 6).asString());
            obj.setEmail(row.getValue(offset + 7).asString());
            obj.setProperty(row.getValue(offset + 8).asBytes());
        }
        catch (DataSetException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static List<JobEntry> doSelect(Criteria criteria) throws TorqueException {
        return BaseJobEntryPeer.populateObjects(BaseJobEntryPeer.doSelectVillageRecords(criteria));
    }

    public static List<JobEntry> doSelect(Criteria criteria, Connection con) throws TorqueException {
        return BaseJobEntryPeer.populateObjects(BaseJobEntryPeer.doSelectVillageRecords(criteria, con));
    }

    public static List<Record> doSelectVillageRecords(Criteria criteria) throws TorqueException {
        return BaseJobEntryPeer.doSelectVillageRecords(criteria, null);
    }

    public static List<Record> doSelectVillageRecords(Criteria criteria, Connection con) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            BaseJobEntryPeer.addSelectColumns(criteria);
        }
        BaseJobEntryPeer.correctBooleans(criteria);
        BaseJobEntryPeer.setDbName(criteria);
        if (con == null) {
            return BasePeer.doSelect((Criteria)criteria);
        }
        return BasePeer.doSelect((Criteria)criteria, (Connection)con);
    }

    public static List<JobEntry> populateObjects(List<Record> records) throws TorqueException {
        ArrayList<JobEntry> results = new ArrayList<JobEntry>(records.size());
        for (int i = 0; i < records.size(); ++i) {
            Record row = records.get(i);
            results.add(JobEntryPeer.row2Object(row, 1, JobEntryPeer.getOMClass()));
        }
        return results;
    }

    public static Class getOMClass() throws TorqueException {
        return CLASS_DEFAULT;
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        BaseJobEntryPeer.doUpdate(criteria, (Connection)null);
    }

    public static void doUpdate(Criteria criteria, Connection con) throws TorqueException {
        Criteria selectCriteria = new Criteria(DATABASE_NAME, 2);
        BaseJobEntryPeer.correctBooleans(criteria);
        selectCriteria.put((Object)JOB_ID, criteria.remove(JOB_ID));
        BaseJobEntryPeer.setDbName(criteria);
        if (con == null) {
            BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
        } else {
            BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria, (Connection)con);
        }
    }

    public static void doDelete(Criteria criteria) throws TorqueException {
        JobEntryPeer.doDelete(criteria, (Connection)null);
    }

    public static void doDelete(Criteria criteria, Connection con) throws TorqueException {
        BaseJobEntryPeer.correctBooleans(criteria);
        BaseJobEntryPeer.setDbName(criteria);
        if (con == null) {
            BasePeer.doDelete((Criteria)criteria, (String)TABLE_NAME);
        } else {
            BasePeer.doDelete((Criteria)criteria, (String)TABLE_NAME, (Connection)con);
        }
    }

    public static List<JobEntry> doSelect(JobEntry obj) throws TorqueException {
        return BaseJobEntryPeer.doSelect(BaseJobEntryPeer.buildSelectCriteria(obj));
    }

    public static void doInsert(JobEntry obj) throws TorqueException {
        obj.setPrimaryKey(BaseJobEntryPeer.doInsert(BaseJobEntryPeer.buildCriteria(obj)));
        obj.setNew(false);
        obj.setModified(false);
    }

    public static void doUpdate(JobEntry obj) throws TorqueException {
        BaseJobEntryPeer.doUpdate(BaseJobEntryPeer.buildCriteria(obj));
        obj.setModified(false);
    }

    public static void doDelete(JobEntry obj) throws TorqueException {
        BaseJobEntryPeer.doDelete(BaseJobEntryPeer.buildSelectCriteria(obj));
    }

    public static void doInsert(JobEntry obj, Connection con) throws TorqueException {
        obj.setPrimaryKey(BaseJobEntryPeer.doInsert(BaseJobEntryPeer.buildCriteria(obj), con));
        obj.setNew(false);
        obj.setModified(false);
    }

    public static void doUpdate(JobEntry obj, Connection con) throws TorqueException {
        BaseJobEntryPeer.doUpdate(BaseJobEntryPeer.buildCriteria(obj), con);
        obj.setModified(false);
    }

    public static void doDelete(JobEntry obj, Connection con) throws TorqueException {
        BaseJobEntryPeer.doDelete(BaseJobEntryPeer.buildSelectCriteria(obj), con);
    }

    public static void doDelete(ObjectKey pk) throws TorqueException {
        BaseJobEntryPeer.doDelete(pk, (Connection)null);
    }

    public static void doDelete(ObjectKey pk, Connection con) throws TorqueException {
        BaseJobEntryPeer.doDelete(BaseJobEntryPeer.buildCriteria(pk), con);
    }

    public static Criteria buildCriteria(ObjectKey pk) {
        Criteria criteria = new Criteria();
        criteria.add(JOB_ID, (Object)pk);
        return criteria;
    }

    public static Criteria buildCriteria(JobEntry obj) {
        Criteria criteria = new Criteria(DATABASE_NAME);
        if (!obj.isNew()) {
            criteria.add(JOB_ID, obj.getJobId());
        }
        criteria.add(SECOND, obj.getSecond());
        criteria.add(MINUTE, obj.getMinute());
        criteria.add(HOUR, obj.getHour());
        criteria.add(WEEK_DAY, obj.getWeekDay());
        criteria.add(DAY_OF_MONTH, obj.getDayOfMonth());
        criteria.add(TASK, (Object)obj.getTask());
        criteria.add(EMAIL, (Object)obj.getEmail());
        criteria.add(PROPERTY, (Object)obj.getProperty());
        return criteria;
    }

    public static Criteria buildSelectCriteria(JobEntry obj) {
        Criteria criteria = new Criteria(DATABASE_NAME);
        if (!obj.isNew()) {
            criteria.add(JOB_ID, obj.getJobId());
        }
        criteria.add(SECOND, obj.getSecond());
        criteria.add(MINUTE, obj.getMinute());
        criteria.add(HOUR, obj.getHour());
        criteria.add(WEEK_DAY, obj.getWeekDay());
        criteria.add(DAY_OF_MONTH, obj.getDayOfMonth());
        criteria.add(TASK, (Object)obj.getTask());
        criteria.add(EMAIL, (Object)obj.getEmail());
        return criteria;
    }

    public static JobEntry retrieveByPK(int pk) throws TorqueException, NoRowsException, TooManyRowsException {
        return BaseJobEntryPeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)pk));
    }

    public static JobEntry retrieveByPK(int pk, Connection con) throws TorqueException, NoRowsException, TooManyRowsException {
        return BaseJobEntryPeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)pk), con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobEntry retrieveByPK(ObjectKey pk) throws TorqueException, NoRowsException, TooManyRowsException {
        Connection db = null;
        JobEntry retVal = null;
        try {
            db = Torque.getConnection((String)DATABASE_NAME);
            retVal = BaseJobEntryPeer.retrieveByPK(pk, db);
        }
        finally {
            Torque.closeConnection((Connection)db);
        }
        return retVal;
    }

    public static JobEntry retrieveByPK(ObjectKey pk, Connection con) throws TorqueException, NoRowsException, TooManyRowsException {
        Criteria criteria = BaseJobEntryPeer.buildCriteria(pk);
        List<JobEntry> v = BaseJobEntryPeer.doSelect(criteria, con);
        if (v.size() == 0) {
            throw new NoRowsException("Failed to select a row.");
        }
        if (v.size() > 1) {
            throw new TooManyRowsException("Failed to select only one row.");
        }
        return v.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JobEntry> retrieveByPKs(List<ObjectKey> pks) throws TorqueException {
        Connection db = null;
        List<JobEntry> retVal = null;
        try {
            db = Torque.getConnection((String)DATABASE_NAME);
            retVal = BaseJobEntryPeer.retrieveByPKs(pks, db);
        }
        finally {
            Torque.closeConnection((Connection)db);
        }
        return retVal;
    }

    public static List<JobEntry> retrieveByPKs(List<ObjectKey> pks, Connection dbcon) throws TorqueException {
        List<JobEntry> objs = null;
        if (pks == null || pks.size() == 0) {
            objs = new LinkedList<JobEntry>();
        } else {
            Criteria criteria = new Criteria();
            criteria.addIn(JOB_ID, pks);
            objs = BaseJobEntryPeer.doSelect(criteria, dbcon);
        }
        return objs;
    }

    public static TableMap getTableMap() throws TorqueException {
        return Torque.getDatabaseMap((String)DATABASE_NAME).getTable(TABLE_NAME);
    }

    private static void setDbName(Criteria crit) {
        if (crit.getDbName() == Torque.getDefaultDB()) {
            crit.setDbName(DATABASE_NAME);
        }
    }

    public static List<Record> executeQuery(String queryString) throws TorqueException {
        return BasePeer.executeQuery((String)queryString);
    }

    public static List<Record> executeQuery(String queryString, String dbName) throws TorqueException {
        return BasePeer.executeQuery((String)queryString, (String)dbName);
    }

    public static List<Record> executeQuery(String queryString, String dbName, boolean singleRecord) throws TorqueException {
        return BasePeer.executeQuery((String)queryString, (String)dbName, (boolean)singleRecord);
    }

    public static List<Record> executeQuery(String queryString, boolean singleRecord, Connection con) throws TorqueException {
        return BasePeer.executeQuery((String)queryString, (boolean)singleRecord, (Connection)con);
    }

    public static List<Record> executeQuery(String queryString, int start, int numberOfResults, String dbName, boolean singleRecord) throws TorqueException {
        return BasePeer.executeQuery((String)queryString, (int)start, (int)numberOfResults, (String)dbName, (boolean)singleRecord);
    }

    public static List<Record> executeQuery(String queryString, int start, int numberOfResults, boolean singleRecord, Connection con) throws TorqueException {
        return BasePeer.executeQuery((String)queryString, (int)start, (int)numberOfResults, (boolean)singleRecord, (Connection)con);
    }

    public static List<Record> getSelectResults(QueryDataSet qds) throws TorqueException {
        return BasePeer.getSelectResults((QueryDataSet)qds);
    }

    public static List<Record> getSelectResults(QueryDataSet qds, boolean singleRecord) throws TorqueException {
        return BasePeer.getSelectResults((QueryDataSet)qds, (boolean)singleRecord);
    }

    public static List<Record> getSelectResults(QueryDataSet qds, int numberOfResults, boolean singleRecord) throws TorqueException {
        return BasePeer.getSelectResults((QueryDataSet)qds, (int)numberOfResults, (boolean)singleRecord);
    }

    public static List getSelectResults(QueryDataSet qds, int start, int numberOfResults, boolean singleRecord) throws TorqueException {
        return BasePeer.getSelectResults((QueryDataSet)qds, (int)start, (int)numberOfResults, (boolean)singleRecord);
    }

    public static List<Record> doPSSelect(Criteria criteria, Connection con) throws TorqueException {
        return BasePeer.doPSSelect((Criteria)criteria, (Connection)con);
    }

    public static List<Record> doPSSelect(Criteria criteria) throws TorqueException {
        return BasePeer.doPSSelect((Criteria)criteria);
    }

    static {
        if (Torque.isInit()) {
            try {
                Torque.getMapBuilder((String)"org.apache.turbine.services.schedule.map.JobEntryMapBuilder");
            }
            catch (TorqueException e) {
                log.error((Object)"Could not initialize Peer", (Throwable)e);
                throw new TorqueRuntimeException((Throwable)e);
            }
        } else {
            Torque.registerMapBuilder((String)"org.apache.turbine.services.schedule.map.JobEntryMapBuilder");
        }
        CLASS_DEFAULT = BaseJobEntryPeer.initClass(CLASSNAME_DEFAULT);
    }
}

