/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ecs.ConcreteElement;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.screens.VelocityScreen;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class VelocityDirectScreen
extends VelocityScreen {
    private String prefix = this.getPrefix() + "/";

    @Override
    public ConcreteElement buildTemplate(RunData data) throws Exception {
        Context context = TurbineVelocity.getContext(data);
        String screenTemplate = data.getTemplateInfo().getScreenTemplate();
        String templateName = TurbineTemplate.getScreenTemplateName(screenTemplate);
        if (StringUtils.isEmpty((String)templateName)) {
            this.log.error((Object)("Screen " + screenTemplate + " not found!"));
            throw new Exception("Could not find screen for " + screenTemplate);
        }
        try {
            TurbineVelocity.handleRequest(context, this.prefix + templateName, (OutputStream)data.getResponse().getOutputStream());
        }
        catch (Exception e) {
            context.put("processingException", (Object)e.toString());
            context.put("stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            templateName = Turbine.getConfiguration().getString("template.error", "error.vm");
            TurbineVelocity.handleRequest(context, this.prefix + templateName, (OutputStream)data.getResponse().getOutputStream());
        }
        return null;
    }

    @Override
    public ConcreteElement buildTemplate(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        Context context = TurbineVelocity.getContext(pipelineData);
        String screenTemplate = data.getTemplateInfo().getScreenTemplate();
        String templateName = TurbineTemplate.getScreenTemplateName(screenTemplate);
        if (StringUtils.isEmpty((String)templateName)) {
            this.log.error((Object)("Screen " + screenTemplate + " not found!"));
            throw new Exception("Could not find screen for " + screenTemplate);
        }
        try {
            TurbineVelocity.handleRequest(context, this.prefix + templateName, (OutputStream)data.getResponse().getOutputStream());
        }
        catch (Exception e) {
            context.put("processingException", (Object)e.toString());
            context.put("stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            templateName = Turbine.getConfiguration().getString("template.error", "error.vm");
            TurbineVelocity.handleRequest(context, this.prefix + templateName, (OutputStream)data.getResponse().getOutputStream());
        }
        return null;
    }
}

