/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.velocity;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.parser.ParameterParser;
import org.apache.velocity.context.Context;

public abstract class VelocityActionEvent
extends ActionEvent {
    private static final Class[] methodParams = new Class[]{RunData.class, Context.class};

    public abstract void doPerform(RunData var1) throws Exception;

    protected void perform(RunData data) throws Exception {
        try {
            this.executeEvents(data, TurbineVelocity.getContext(data));
        }
        catch (NoSuchMethodException e) {
            this.doPerform(data);
        }
    }

    public void executeEvents(RunData data, Context context) throws Exception {
        String theButton = null;
        ParameterParser pp = data.getParameters();
        String button = pp.convert("eventSubmit_");
        String key = null;
        Iterator it = pp.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            if (!key.startsWith(button) || !this.considerKey(key, pp)) continue;
            theButton = this.formatString(key);
            break;
        }
        if (theButton == null) {
            throw new NoSuchMethodException("ActionEvent: The button was null");
        }
        try {
            Method method = this.getClass().getMethod(theButton, methodParams);
            Object[] methodArgs = new Object[]{data, context};
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking " + method));
            }
            method.invoke((Object)this, methodArgs);
        }
        catch (NoSuchMethodException nsme) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Couldn't locate the Event ( " + theButton + "), running executeEvents() in " + super.getClass().getName()));
            }
            super.executeEvents(data);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw ite;
        }
        finally {
            pp.remove(key);
        }
    }
}

