/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.Layout;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class LayoutLoader
extends GenericLoader
implements Loader {
    private static final long serialVersionUID = -1996918946937639892L;
    private static Log log = LogFactory.getLog((Class)LayoutLoader.class);
    private static LayoutLoader instance = new LayoutLoader(Turbine.getConfiguration().getInt("layout.cache.size", 10));
    private static AssemblerBrokerService ab = TurbineAssemblerBroker.getService();

    private LayoutLoader() {
    }

    private LayoutLoader(int i) {
        super(i);
    }

    private void addInstance(String name, Layout layout) {
        if (this.cache()) {
            this.put(name, layout);
        }
    }

    public void exec(RunData data, String name) throws Exception {
        this.getInstance(name).build(data);
    }

    public Assembler getAssembler(String name) throws Exception {
        return this.getInstance(name);
    }

    public Layout getInstance(String name) throws Exception {
        Layout layout = null;
        if (this.cache() && this.containsKey(name)) {
            layout = (Layout)this.get(name);
            log.debug((Object)("Found Layout " + name + " in the cache!"));
        } else {
            log.debug((Object)("Loading Layout " + name + " from the Assembler Broker"));
            try {
                if (ab != null) {
                    layout = (Layout)ab.getAssembler("layout", name);
                }
            }
            catch (ClassCastException cce) {
                layout = null;
            }
            if (layout == null) {
                List packages = Turbine.getConfiguration().getList("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested Layout not found: " + name + "\n\tTurbine looked in the following " + "modules.packages path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, layout);
            }
        }
        return layout;
    }

    public static LayoutLoader getInstance() {
        return instance;
    }
}

