/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xmlrpc;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.xmlrpc.XmlRpcService;
import org.apache.turbine.services.xmlrpc.util.FileTransfer;
import org.apache.turbine.util.TurbineException;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcServer;
import org.apache.xmlrpc.secure.SecureWebServer;

public class TurbineXmlRpcService
extends TurbineBaseService
implements XmlRpcService {
    private static Log log = LogFactory.getLog((Class)TurbineXmlRpcService.class);
    protected boolean isModernVersion = false;
    protected WebServer webserver = null;
    protected XmlRpcServer server = null;
    private InetAddress address = null;
    protected int port = 0;

    public void init() throws InitializationException {
        Configuration conf = this.getConfiguration();
        try {
            String saxParserClass;
            this.server = new XmlRpcServer();
            Configuration secureServerOptions = conf.subset("secure.server.option");
            if (secureServerOptions != null) {
                this.setSystemPropertiesFromConfiguration(secureServerOptions);
            }
            String addr = conf.getString("address", "0.0.0.0");
            this.port = conf.getInt("port", 0);
            if (this.port != 0) {
                if (addr != null && addr.length() > 0) {
                    try {
                        this.address = InetAddress.getByName(addr);
                    }
                    catch (UnknownHostException useDefault) {
                        this.address = null;
                    }
                }
                log.debug((Object)("Port: " + this.port + ", Address: " + this.address));
                this.webserver = conf.getBoolean("secure.server", false) ? new SecureWebServer(this.port, this.address) : new WebServer(this.port, this.address);
            }
            if ((saxParserClass = conf.getString("parser", null)) != null) {
                XmlRpc.setDriver((String)saxParserClass);
            }
            Iterator keys = conf.getKeys("handler");
            while (keys.hasNext()) {
                String handler = (String)keys.next();
                String handlerName = handler.substring(handler.indexOf(46) + 1);
                String handlerClass = conf.getString(handler);
                log.debug((Object)("Found Handler " + handler + " as " + handlerName + " / " + handlerClass));
                this.registerHandler(handlerName, handlerClass);
            }
            boolean stateOfParanoia = conf.getBoolean("paranoid", false);
            if (stateOfParanoia) {
                this.webserver.setParanoid(stateOfParanoia);
                log.info((Object)"XmlRpcService: Operating in a state of paranoia");
                List acceptedClients = conf.getList("acceptClient");
                for (int i = 0; i < acceptedClients.size(); ++i) {
                    String acceptClient = (String)acceptedClients.get(i);
                    if (!StringUtils.isNotEmpty((String)acceptClient)) continue;
                    this.webserver.acceptClient(acceptClient);
                    log.info((Object)("XmlRpcService: Accepting client -> " + acceptClient));
                }
                List deniedClients = conf.getList("denyClient");
                for (int i = 0; i < deniedClients.size(); ++i) {
                    String denyClient = (String)deniedClients.get(i);
                    if (!StringUtils.isNotEmpty((String)denyClient)) continue;
                    this.webserver.denyClient(denyClient);
                    log.info((Object)("XmlRpcService: Denying client -> " + denyClient));
                }
            }
            try {
                Class.forName("org.apache.xmlrpc.XmlRpcRequest");
                this.isModernVersion = true;
                this.webserver.start();
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            log.debug((Object)("XmlRpcService: Using Apache XML-RPC version " + (this.isModernVersion ? "greater than 1.1" : "1.1 or lower")));
        }
        catch (Exception e) {
            String errorMessage = "XMLRPCService failed to initialize";
            log.error((Object)errorMessage, (Throwable)e);
            throw new InitializationException(errorMessage, e);
        }
        this.setInit(true);
    }

    public void init(ServletConfig config) throws InitializationException {
        this.init();
    }

    private void setSystemPropertiesFromConfiguration(Configuration configuration) {
        Iterator i = configuration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = configuration.getString(key);
            log.debug((Object)("JSSE option: " + key + " => " + value));
            System.setProperty(key, value);
        }
    }

    public void registerHandler(Object handler) {
        this.registerHandler("$default", handler);
    }

    public void registerHandler(String handlerName, Object handler) {
        if (this.webserver != null) {
            this.webserver.addHandler(handlerName, handler);
        }
        this.server.addHandler(handlerName, handler);
        log.debug((Object)("Registered Handler " + handlerName + " as " + handler.getClass().getName() + ", Server: " + this.server + ", Webserver: " + this.webserver));
    }

    public void registerHandler(String handlerName, String handlerClass) throws TurbineException {
        try {
            Object handler = Class.forName(handlerClass).newInstance();
            if (this.webserver != null) {
                this.webserver.addHandler(handlerName, handler);
            }
            this.server.addHandler(handlerName, handler);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (OutOfMemoryError t) {
            throw t;
        }
        catch (Throwable t) {
            throw new TurbineException("Failed to instantiate " + handlerClass, t);
        }
    }

    public void unregisterHandler(String handlerName) {
        if (this.webserver != null) {
            this.webserver.removeHandler(handlerName);
        }
        this.server.removeHandler(handlerName);
    }

    public byte[] handleRequest(InputStream is) {
        return this.server.execute(is);
    }

    public byte[] handleRequest(InputStream is, String user, String password) {
        return this.server.execute(is, user, password);
    }

    public Object executeRpc(URL url, String methodName, Vector params) throws TurbineException {
        try {
            XmlRpcClient client = new XmlRpcClient(url);
            return client.execute(methodName, params);
        }
        catch (Exception e) {
            throw new TurbineException("XML-RPC call failed", e);
        }
    }

    public Object executeAuthenticatedRpc(URL url, String username, String password, String methodName, Vector params) throws TurbineException {
        try {
            XmlRpcClient client = new XmlRpcClient(url);
            client.setBasicAuthentication(username, password);
            return client.execute(methodName, params);
        }
        catch (Exception e) {
            throw new TurbineException("XML-RPC call failed", e);
        }
    }

    public void send(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        FileTransfer.send(serverURL, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public void send(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        FileTransfer.send(serverURL, username, password, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public void get(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        FileTransfer.get(serverURL, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public void get(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        FileTransfer.get(serverURL, username, password, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public void remove(String serverURL, String sourceLocationProperty, String sourceFileName) throws TurbineException {
        FileTransfer.remove(serverURL, sourceLocationProperty, sourceFileName);
    }

    public void remove(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName) throws TurbineException {
        FileTransfer.remove(serverURL, username, password, sourceLocationProperty, sourceFileName);
    }

    public void setParanoid(boolean state) {
        this.webserver.setParanoid(state);
    }

    public void acceptClient(String address) {
        this.webserver.acceptClient(address);
    }

    public void denyClient(String address) {
        this.webserver.denyClient(address);
    }

    public void shutdown() {
        this.webserver.shutdown();
        if (!this.isModernVersion) {
            try {
                Socket interrupt = new Socket(this.address, this.port);
                interrupt.close();
            }
            catch (Exception notShutdown) {
                log.warn((Object)("XmlRpcServiceIt's possible the xmlrpc server was not shutdown: " + notShutdown.getMessage()));
            }
        }
        this.setInit(false);
    }
}

