/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.json.jackson;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fulcrum.json.JsonService;
import org.apache.fulcrum.json.jackson.CustomIntrospector;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.BeanPropertyFilter;
import org.codehaus.jackson.map.ser.FilterProvider;
import org.codehaus.jackson.map.ser.StdSerializerProvider;
import org.codehaus.jackson.map.ser.impl.SimpleBeanPropertyFilter;
import org.codehaus.jackson.map.ser.impl.SimpleFilterProvider;
import org.codehaus.jackson.type.JavaType;

public class JacksonMapperService
extends AbstractLogEnabled
implements JsonService,
Initializable,
Configurable {
    private static final String DEFAULT_TYPING = "defaultTyping";
    private static final String CACHE_FILTERS = "cacheFilters";
    private static final String DATE_FORMAT = "dateFormat";
    ObjectMapper mapper;
    AnnotationIntrospector primary;
    AnnotationIntrospector secondary;
    public String ANNOTATIONINSPECTOR = "annotationInspectors";
    private Hashtable<String, String> annotationInspectors = null;
    private Hashtable<String, Boolean> features = null;
    private Map<String, FilterProvider> filters;
    private String dateFormat;
    final String DEFAULTDATEFORMAT = "MM/dd/yyyy";
    final boolean defaultType = false;
    public boolean cacheFilters = true;
    String[] defaultTypeDefs = null;

    public synchronized String ser(Object src) throws Exception {
        return this.ser(src, false);
    }

    public <T> String ser(Object src, Class<T> type) throws Exception {
        return this.ser(src, type, false);
    }

    public synchronized <T> String ser(Object src, FilterProvider filters) throws Exception {
        if (filters == null) {
            this.getLogger().debug("ser class::" + src.getClass() + " without filter ");
            return this.ser(src);
        }
        this.getLogger().debug("ser::" + src + " with filters " + filters);
        String serResult = this.mapper.writer(filters).writeValueAsString(src);
        return serResult;
    }

    public String ser(Object src, Boolean cleanCache) throws Exception {
        if (src.getClass() != null && this.filters.containsKey(src.getClass().getName())) {
            this.getLogger().warn("Found registered filter - using instead of default view filter for class:" + src.getClass().getName());
        }
        if (!this.cacheFilters || cleanCache.booleanValue()) {
            this.cleanSerializerCache();
        }
        return this.mapper.writer().writeValueAsString(src);
    }

    public <T> String ser(Object src, Class<T> type, Boolean cleanCache) throws Exception {
        this.getLogger().debug("ser::" + src + " with type" + type);
        if (src.getClass() != null && this.filters.containsKey(src.getClass().getName())) {
            this.getLogger().warn("Found registered filter - could not use custom view and custom filter for class:" + src.getClass().getName());
        }
        if (!this.cacheFilters || cleanCache.booleanValue()) {
            this.cleanSerializerCache();
        }
        return this.mapper.writerWithView(type).writeValueAsString(src);
    }

    public <T> T deSer(String src, Class<T> type) throws Exception {
        ObjectReader reader = this.mapper.reader(type);
        return (T)reader.readValue(src);
    }

    public <T> Collection<T> deSerCollection(String json, Object collectionType, Class<T> elementType) throws Exception {
        return (Collection)this.mapper.readValue(json, (JavaType)this.mapper.getTypeFactory().constructCollectionType(((Collection)collectionType).getClass(), elementType));
    }

    public <T> T deSer(String json, Class<? extends Collection> collectionType, Class<T> type) throws Exception {
        return (T)this.mapper.readValue(json, (JavaType)this.mapper.getTypeFactory().constructCollectionType(collectionType, type));
    }

    public <T> String serializeAllExceptFilter(Object src, String ... filterAttr) throws Exception {
        return this.serializeAllExceptFilter(src, src.getClass(), true, filterAttr);
    }

    public <T> String serializeAllExceptFilter(Object src, Boolean refresh, String ... filterAttr) throws Exception {
        return this.serializeAllExceptFilter(src, src.getClass(), refresh, filterAttr);
    }

    public synchronized <T> String serializeAllExceptFilter(Object src, Class<T> filterClass, String ... filterAttr) throws Exception {
        return this.serializeAllExceptFilter(src, filterClass, true, filterAttr);
    }

    public <T> String serializeAllExceptFilter(Object src, Class<T> filterClass, Boolean refreshFilter, String ... filterAttr) throws Exception {
        this.setCustomIntrospectorWithExternalFilterId(filterClass);
        FilterProvider filter = null;
        if (filterClass != null) {
            if (filterAttr != null && filterAttr.length > 0 && (refreshFilter.booleanValue() || !this.filters.containsKey(filterClass.getName()))) {
                filter = new SimpleFilterProvider().addFilter(filterClass.getName(), (BeanPropertyFilter)SimpleBeanPropertyFilter.serializeAllExcept((String[])filterAttr));
                this.filters.put(filterClass.getName(), filter);
            } else {
                filter = this.filters.get(filterClass.getName());
            }
        }
        String serialized = this.ser(src, filter);
        if (!this.cacheFilters || refreshFilter.booleanValue()) {
            this.removeFilterClass(filterClass);
            this.cleanSerializerCache();
        }
        return serialized;
    }

    public <T> String serializeOnlyFilter(Object src, String ... filterAttr) throws Exception {
        return this.serializeOnlyFilter(src, src.getClass(), true, filterAttr);
    }

    public <T> String serializeOnlyFilter(Object src, Boolean refresh, String ... filterAttr) throws Exception {
        return this.serializeOnlyFilter(src, src.getClass(), refresh, filterAttr);
    }

    public synchronized <T> String serializeOnlyFilter(Object src, Class<T> filterClass, String ... filterAttr) throws Exception {
        return this.serializeOnlyFilter(src, filterClass, true, filterAttr);
    }

    public <T> String serializeOnlyFilter(Object src, Class<T> filterClass, Boolean refreshFilter, String ... filterAttr) throws Exception {
        this.setCustomIntrospectorWithExternalFilterId(filterClass);
        FilterProvider filter = null;
        if (filterClass == null && src != null && src.getClass() != null) {
            filterClass = src.getClass();
        }
        if (filterClass != null) {
            if (!this.filters.containsKey(filterClass.getName())) {
                this.getLogger().debug("filterClass::" + filterClass.getName() + " with filterAttr: " + filterAttr);
                if (filterAttr != null) {
                    filter = new SimpleFilterProvider().addFilter(filterClass.getName(), (BeanPropertyFilter)SimpleBeanPropertyFilter.filterOutAllExcept((String[])filterAttr));
                    this.filters.put(filterClass.getName(), filter);
                } else {
                    filter = new SimpleFilterProvider();
                    this.filters.put(filterClass.getName(), filter);
                }
            } else {
                filter = this.filters.get(filterClass.getName());
            }
        }
        String serialized = this.ser(src, filter);
        this.getLogger().debug("serialized " + serialized);
        if (!this.cacheFilters || refreshFilter.booleanValue()) {
            this.removeFilterClass(filterClass);
            this.cleanSerializerCache();
        }
        return serialized;
    }

    private <T> void removeFilterClass(Class<T> filterClass) {
        if (this.filters.containsKey(filterClass.getName())) {
            this.removeCustomIntrospectorWithExternalFilterId(filterClass);
            this.filters.remove(filterClass.getName());
            this.mapper.getSerializerProvider().flushCachedSerializers();
            this.getLogger().debug("removed from  SimpleFilterProvider filters " + filterClass.getName());
        }
    }

    private void cleanSerializerCache() {
        int cachedSerProvs;
        if (this.mapper.getSerializerProvider() instanceof StdSerializerProvider && (cachedSerProvs = ((StdSerializerProvider)this.mapper.getSerializerProvider()).cachedSerializersCount()) > 0) {
            this.getLogger().debug("flushing cachedSerializersCount:" + cachedSerProvs);
            ((StdSerializerProvider)this.mapper.getSerializerProvider()).flushCachedSerializers();
        }
    }

    private <T> void setCustomIntrospectorWithExternalFilterId(Class<T> externalFilterId) {
        if (this.primary instanceof CustomIntrospector && externalFilterId != null) {
            ((CustomIntrospector)this.primary).setExternalFilterClasses(externalFilterId);
            this.getLogger().debug("added class from filters " + externalFilterId.getName());
        }
    }

    private <T> void removeCustomIntrospectorWithExternalFilterId(Class<T> externalFilterId) {
        if (this.primary instanceof CustomIntrospector && externalFilterId != null) {
            ((CustomIntrospector)this.primary).removeExternalFilterClass(externalFilterId);
            this.getLogger().debug("removed from introspector filter id  " + externalFilterId.getName());
        }
    }

    public JacksonMapperService registerModule(Module module) {
        this.mapper.withModule(module);
        return this;
    }

    public <T> void addSimpleModule(SimpleModule module, Class<T> type, JsonSerializer<T> ser) {
        module.addSerializer(type, ser);
    }

    public <T> void addSimpleModule(SimpleModule module, Class<T> type, JsonDeserializer<T> deSer) {
        module.addDeserializer(type, deSer);
    }

    public void setDateFormat(DateFormat df) {
        this.mapper.setDateFormat(df);
    }

    public JsonService addAdapter(String name, Class target, Object mixin) throws Exception {
        return this.addAdapter(name, target, mixin.getClass());
    }

    public JsonService addAdapter(String name, Class target, Class mixin) throws Exception {
        MixinModule mx = new MixinModule(name, target, mixin);
        this.getLogger().debug("registering module " + (Object)((Object)mx) + "  for: " + mixin);
        this.mapper.withModule((Module)mx);
        return this;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration configuredDefaultType;
        this.getLogger().debug("conf.getName()" + conf.getName());
        this.annotationInspectors = new Hashtable();
        Configuration configuredAnnotationInspectors = conf.getChild(this.ANNOTATIONINSPECTOR, false);
        if (configuredAnnotationInspectors != null) {
            Configuration[] nameVal = configuredAnnotationInspectors.getChildren();
            for (int i = 0; i < nameVal.length; ++i) {
                String key = nameVal[i].getName();
                this.getLogger().debug("configured key: " + key);
                if (key.equals("features")) {
                    this.features = new Hashtable();
                    Configuration[] features = nameVal[i].getChildren();
                    for (int j = 0; j < features.length; ++j) {
                        boolean featureValue = features[j].getAttributeAsBoolean("value", false);
                        String feature = features[j].getValue();
                        this.getLogger().debug("configuredAnnotationInspectors " + feature + ":" + featureValue);
                        this.features.put(feature, featureValue);
                    }
                    continue;
                }
                String val = nameVal[i].getValue();
                this.getLogger().debug("configuredAnnotationInspectors " + key + ":" + val);
                this.annotationInspectors.put(key, val);
            }
        }
        Configuration configuredDateFormat = conf.getChild(DATE_FORMAT, true);
        this.dateFormat = configuredDateFormat.getValue("MM/dd/yyyy");
        Configuration configuredKeepFilter = conf.getChild(CACHE_FILTERS, false);
        if (configuredKeepFilter != null) {
            this.cacheFilters = configuredKeepFilter.getValueAsBoolean();
        }
        if ((configuredDefaultType = conf.getChild(DEFAULT_TYPING, false)) != null) {
            this.defaultTypeDefs = new String[]{configuredDefaultType.getAttribute("type"), configuredDefaultType.getAttribute("key")};
        }
    }

    public void initialize() throws Exception {
        this.mapper = new ObjectMapper();
        Enumeration<String> enumKey = this.annotationInspectors.keys();
        while (enumKey.hasMoreElements()) {
            String key = enumKey.nextElement();
            String avClass = this.annotationInspectors.get(key);
            if (key.equals("primary") && avClass != null) {
                try {
                    this.primary = (AnnotationIntrospector)Class.forName(avClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("JsonMapperService: Error instantiating " + avClass + " for " + key);
                }
            }
            if (!key.equals("secondary") || avClass == null) continue;
            try {
                this.secondary = (AnnotationIntrospector)Class.forName(avClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new Exception("JsonMapperService: Error instantiating " + avClass + " for " + key);
            }
        }
        if (this.primary == null) {
            this.primary = new JacksonAnnotationIntrospector();
            this.getLogger().info("using default introspector:" + this.primary.getClass().getName());
            this.mapper.setAnnotationIntrospector(this.primary);
        } else {
            AnnotationIntrospector.Pair pair = new AnnotationIntrospector.Pair(this.primary, this.secondary);
            this.mapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        }
        if (this.features != null) {
            Enumeration<String> enumFeatureKey = this.features.keys();
            while (enumFeatureKey.hasMoreElements()) {
                String featureKey = enumFeatureKey.nextElement();
                Boolean featureValue = this.features.get(featureKey);
                if (featureKey == null || featureValue == null) continue;
                try {
                    String[] featureParts = featureKey.split("\\.");
                    this.getLogger().info("initializing mapper feature: " + featureParts[featureParts.length - 1] + " with " + featureValue);
                    SerializationConfig.Feature feature = SerializationConfig.Feature.valueOf((String)featureParts[featureParts.length - 1]);
                    this.mapper.configure(feature, featureValue.booleanValue());
                    assert (this.mapper.getSerializationConfig().isEnabled(feature) == featureValue.booleanValue());
                }
                catch (Exception e) {
                    throw new Exception("JsonMapperService: Error instantiating feature " + featureKey + " with  " + featureValue, e);
                }
            }
        }
        if (this.defaultTypeDefs != null && this.defaultTypeDefs.length == 2) {
            ObjectMapper.DefaultTyping defaultTyping = ObjectMapper.DefaultTyping.valueOf((String)this.defaultTypeDefs[0]);
            this.mapper.enableDefaultTypingAsProperty(defaultTyping, this.defaultTypeDefs[1]);
            this.getLogger().info("default typing is " + this.defaultTypeDefs[0] + " with key:" + this.defaultTypeDefs[1]);
        }
        this.getLogger().info("setting date format to:" + this.dateFormat);
        this.getLogger().info("keepFilters is:" + this.cacheFilters);
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat(this.dateFormat));
        this.filters = Collections.synchronizedMap(new HashMap());
        this.getLogger().info("initialized: mapper:" + this.mapper);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public static class MixinModule
    extends SimpleModule {
        public final Class<?> clazz;
        public final Class<?> mixin;

        public <T, U> MixinModule(String name, Class<T> clazz, Class<U> mixin) {
            super(name, new Version(1, 0, 0, null));
            this.clazz = clazz;
            this.mixin = mixin;
        }

        public void setupModule(Module.SetupContext context) {
            context.setMixInAnnotations(this.clazz, this.mixin);
        }
    }
}

