package tc

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// CacheGroupParameterRequest is a Cache Group Parameter request body.
//
// Deprecated: Cache Group Parameter associations have been removed in APIv4.
type CacheGroupParameterRequest struct {
	CacheGroupID int `json:"cacheGroupId"`
	ParameterID  int `json:"parameterId"`
}

// CacheGroupParametersPostResponse Response body when Posting to associate a
// Parameter with a Cache Group.
//
// Deprecated: Cache Group Parameter associations have been removed in APIv4.
type CacheGroupParametersPostResponse struct {
	Response []CacheGroupParameterRequest `json:"response"`
	Alerts
}

// CacheGroupParametersResponse is a Cache Group Parameter response body.
//
// Deprecated: Cache Group Parameter associations have been removed in APIv4.
type CacheGroupParametersResponse struct {
	Response []CacheGroupParameter `json:"response"`
	Alerts
}

// A CacheGroupParameter is an object that represents a Parameter, but also
// implies that it is associated with a Cache Group rather than (or in addition
// to) a Profile.
//
// Deprecated: Cache Group Parameter associations have been removed in APIv4.
type CacheGroupParameter struct {
	ConfigFile  string    `json:"configFile"`
	ID          int       `json:"id"`
	LastUpdated TimeNoMod `json:"lastUpdated"`
	Name        string    `json:"name"`
	Secure      bool      `json:"secure"`
	Value       string    `json:"value"`
}

// A CacheGroupParameterNullable is an object that represents a Parameter, but
// also implies that it is associated with a Cache Group rather than (or in
// addition to) a Profile.
//
// The only substantial difference between this and a CacheGroupParameter is
// that Go client methods unmarshal Traffic Ops responses into a
// CacheGroupParameter, while those responses are generated by marshalling data
// stored in CacheGroupParameterNullables.
//
// Deprecated: Cache Group Parameter associations have been removed in APIv4.
type CacheGroupParameterNullable struct {
	ConfigFile  *string    `json:"configFile" db:"config_file"`
	ID          *int       `json:"id" db:"id"`
	LastUpdated *TimeNoMod `json:"lastUpdated" db:"last_updated"`
	Name        *string    `json:"name" db:"name"`
	Secure      *bool      `json:"secure" db:"secure"`
	Value       *string    `json:"value" db:"value"`
}
