/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.threads.impl.ContextServiceImpl;
import org.apache.openejb.threads.task.ManagedTaskListenerTask;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public abstract class CUTask<T>
extends ManagedTaskListenerTask
implements Comparable<Object>,
Serializable {
    private static volatile ContainerListener[] CONTAINER_LISTENERS = new ContainerListener[0];
    protected final ContextServiceImpl contextService;
    private final ContextServiceImpl.Snapshot snapshot;
    private final Object[] containerListenerStates;
    private final Context initialContext;

    public static void addContainerListener(ContainerListener cl) {
        ContainerListener[] array = new ContainerListener[CONTAINER_LISTENERS.length + 1];
        if (CONTAINER_LISTENERS.length > 0) {
            System.arraycopy(CONTAINER_LISTENERS, 0, array, 0, CONTAINER_LISTENERS.length);
        }
        array[CUTask.CONTAINER_LISTENERS.length] = cl;
        CONTAINER_LISTENERS = array;
    }

    public CUTask(Object task, ContextServiceImpl contextService) {
        this(task, contextService, null);
    }

    public CUTask(Object task, ContextServiceImpl contextService, Map<String, String> props) {
        super(task);
        this.contextService = contextService;
        this.snapshot = contextService.snapshot(props);
        this.initialContext = new Context();
        if (CONTAINER_LISTENERS.length > 0) {
            this.containerListenerStates = new Object[CONTAINER_LISTENERS.length];
            for (int i = 0; i < CONTAINER_LISTENERS.length; ++i) {
                this.containerListenerStates[i] = CONTAINER_LISTENERS[i].onCreation();
            }
        } else {
            this.containerListenerStates = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T invoke(Callable<T> call) throws Exception {
        Object[] oldStates;
        this.initialContext.enter();
        if (CONTAINER_LISTENERS.length > 0) {
            oldStates = new Object[CONTAINER_LISTENERS.length];
            for (int i = 0; i < CONTAINER_LISTENERS.length; ++i) {
                oldStates[i] = CONTAINER_LISTENERS[i].onStart(this.containerListenerStates[i]);
            }
        } else {
            oldStates = null;
        }
        ContextServiceImpl.State state = null;
        if (this.contextService != null && this.snapshot != null) {
            state = this.contextService.enter(this.snapshot);
        }
        Throwable throwable = null;
        try {
            this.taskStarting(this.future, this.executor, this.delegate);
            T t = call.call();
            return t;
        }
        catch (Throwable t) {
            throwable = t;
            this.taskAborted(throwable);
            T t2 = this.rethrow(t);
            return t2;
        }
        finally {
            try {
                this.taskDone(this.future, this.executor, this.delegate, throwable);
            }
            finally {
                if (CONTAINER_LISTENERS.length > 0) {
                    for (int i = 0; i < CONTAINER_LISTENERS.length; ++i) {
                        CONTAINER_LISTENERS[i].onEnd(oldStates[i]);
                    }
                }
                if (this.contextService != null && state != null) {
                    this.contextService.exit(state);
                }
                this.initialContext.exit();
            }
        }
    }

    private T rethrow(Throwable t) throws Exception {
        if (Exception.class.isInstance(t)) {
            throw (Exception)Exception.class.cast(t);
        }
        if (Error.class.isInstance(t)) {
            throw (Error)Error.class.cast(t);
        }
        throw new OpenEJBRuntimeException(t.getMessage(), t);
    }

    @Override
    public int compareTo(Object o) {
        return Comparable.class.isInstance(this.delegate) ? ((Comparable)Comparable.class.cast(this.delegate)).compareTo(o) : -1;
    }

    public static interface ContainerListener<T>
    extends Serializable {
        public T onCreation();

        public T onStart(T var1);

        public void onEnd(T var1);
    }

    public static final class Context
    implements Serializable {
        public static final ThreadLocal<Context> CURRENT = new ThreadLocal();
        private Context previous = null;
        private Collection<Runnable> exitTasks;

        public void enter() {
            if (this.previous != null) {
                throw new IllegalStateException("Can't enter a context twice, create a new one, and call enter() on that.");
            }
            this.previous = CURRENT.get();
            CURRENT.set(this);
        }

        public void exit() {
            ArrayList<RuntimeException> errors = null;
            if (this.exitTasks != null) {
                for (Runnable r : this.exitTasks) {
                    try {
                        r.run();
                    }
                    catch (RuntimeException re) {
                        if (errors == null) {
                            errors = new ArrayList<RuntimeException>();
                        }
                        errors.add(re);
                        Logger.getInstance(LogCategory.OPENEJB, CUTask.class).warning(re.getMessage(), re);
                    }
                }
            }
            CURRENT.set(this.previous);
            this.previous = null;
        }

        public void pushExitTask(Runnable runnable) {
            if (this.exitTasks == null) {
                this.exitTasks = new ArrayList<Runnable>(2);
            }
            this.exitTasks.add(runnable);
        }
    }
}

