/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.translator;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pick;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Script;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.NumberHelper;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class JavascriptTranslator
implements Translator.ScriptTranslator {
    private final String traversalSource;
    private final Translator.ScriptTranslator.TypeTranslator typeTranslator;

    private JavascriptTranslator(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        this.traversalSource = traversalSource;
        this.typeTranslator = typeTranslator;
    }

    public static JavascriptTranslator of(String traversalSource) {
        return JavascriptTranslator.of(traversalSource, false);
    }

    public static JavascriptTranslator of(String traversalSource, boolean withParameters) {
        return JavascriptTranslator.of(traversalSource, new DefaultTypeTranslator(withParameters));
    }

    public static JavascriptTranslator of(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        return new JavascriptTranslator(traversalSource, typeTranslator);
    }

    @Override
    public Script translate(Bytecode bytecode) {
        return (Script)this.typeTranslator.apply(this.traversalSource, bytecode);
    }

    @Override
    public String getTargetLanguage() {
        return "gremlin-javascript";
    }

    public String toString() {
        return StringFactory.translatorString(this);
    }

    @Override
    public String getTraversalSource() {
        return this.traversalSource;
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_JS_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_JS_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toJavascript(String symbol) {
            return TO_JS_MAP.getOrDefault(symbol, symbol);
        }

        public static String toJava(String symbol) {
            return FROM_JS_MAP.getOrDefault(symbol, symbol);
        }

        static {
            TO_JS_MAP.put("from", "from_");
            TO_JS_MAP.put("in", "in_");
            TO_JS_MAP.put("with", "with_");
            TO_JS_MAP.forEach((k, v) -> FROM_JS_MAP.put((String)v, (String)k));
        }
    }

    public static class DefaultTypeTranslator
    extends Translator.ScriptTranslator.AbstractTypeTranslator {
        public DefaultTypeTranslator(boolean withParameters) {
            super(withParameters);
        }

        @Override
        protected String getNullSyntax() {
            return "null";
        }

        @Override
        protected String getSyntax(String o) {
            return (o.contains("\"") ? "\"\"\"" + StringEscapeUtils.escapeJava((String)o) + "\"\"\"" : "\"" + StringEscapeUtils.escapeJava((String)o) + "\"").replace("$", "\\$");
        }

        @Override
        protected String getSyntax(Boolean o) {
            return o.toString();
        }

        @Override
        protected String getSyntax(Date o) {
            return "new Date(" + o.getTime() + ")";
        }

        @Override
        protected String getSyntax(Timestamp o) {
            return "new Date(" + o.getTime() + ")";
        }

        @Override
        protected String getSyntax(UUID o) {
            return "'" + o.toString() + "'";
        }

        @Override
        protected String getSyntax(Lambda o) {
            return "() => \"" + StringEscapeUtils.escapeEcmaScript((String)o.getLambdaScript().trim()) + "\"";
        }

        @Override
        protected String getSyntax(SackFunctions.Barrier o) {
            return "Barrier." + o.toString();
        }

        @Override
        protected String getSyntax(VertexProperty.Cardinality o) {
            return "Cardinality." + o.toString();
        }

        @Override
        protected String getSyntax(Pick o) {
            return "Pick." + o.toString();
        }

        @Override
        protected String getSyntax(Number o) {
            if (o instanceof Float || o instanceof Double) {
                if (NumberHelper.isNaN(o)) {
                    return "Number.NaN";
                }
                if (NumberHelper.isPositiveInfinity(o)) {
                    return "Number.POSITIVE_INFINITY";
                }
                if (NumberHelper.isNegativeInfinity(o)) {
                    return "Number.NEGATIVE_INFINITY";
                }
            }
            return o.toString();
        }

        @Override
        protected Script produceScript(Set<?> o) {
            return this.produceScript(new ArrayList(o));
        }

        @Override
        protected Script produceScript(List<?> o) {
            Iterator<?> iterator = o.iterator();
            this.script.append("[");
            while (iterator.hasNext()) {
                Object nextItem = iterator.next();
                this.convertToScript(nextItem);
                if (!iterator.hasNext()) continue;
                this.script.append(",").append(" ");
            }
            return this.script.append("]");
        }

        @Override
        protected Script produceScript(Map<?, ?> o) {
            this.script.append("new Map([");
            Iterator<Map.Entry<?, ?>> itty = o.entrySet().iterator();
            while (itty.hasNext()) {
                Map.Entry<?, ?> entry = itty.next();
                this.script.append("[");
                this.convertToScript(entry.getKey());
                this.script.append(",");
                this.convertToScript(entry.getValue());
                this.script.append("]");
                if (!itty.hasNext()) continue;
                this.script.append(",");
            }
            return this.script.append("])");
        }

        @Override
        protected Script produceScript(Class<?> o) {
            return this.script.append(o.getCanonicalName());
        }

        @Override
        protected Script produceScript(Enum<?> o) {
            return this.script.append(o.getDeclaringClass().getSimpleName() + "." + o.toString());
        }

        @Override
        protected Script produceScript(Vertex o) {
            this.script.append("new Vertex(");
            this.convertToScript(o.id());
            this.script.append(",");
            this.convertToScript(o.label());
            return this.script.append(", null)");
        }

        @Override
        protected Script produceScript(Edge o) {
            this.script.append("new Edge(");
            this.convertToScript(o.id());
            this.script.append(", new Vertex(");
            this.convertToScript(o.outVertex().id());
            this.script.append(",");
            this.convertToScript(o.outVertex().label());
            this.script.append(", null),");
            this.convertToScript(o.label());
            this.script.append(", new Vertex(");
            this.convertToScript(o.inVertex().id());
            this.script.append(",");
            this.convertToScript(o.inVertex().label());
            return this.script.append(",null),null)");
        }

        @Override
        protected Script produceScript(VertexProperty<?> o) {
            this.script.append("new Property(");
            this.convertToScript(o.id());
            this.script.append(",");
            this.convertToScript(o.label());
            this.script.append(",");
            this.convertToScript(o.value());
            this.script.append(",");
            return this.script.append("null)");
        }

        @Override
        protected Script produceScript(TraversalStrategyProxy<?> o) {
            if (o.getConfiguration().isEmpty()) {
                return this.script.append("new " + o.getStrategyClass().getSimpleName() + "()");
            }
            this.script.append("new " + o.getStrategyClass().getSimpleName() + "(");
            Map conf = ConfigurationConverter.getMap((Configuration)o.getConfiguration());
            this.script.append("{");
            conf.entrySet().stream().filter(entry -> !entry.getKey().equals("strategy")).forEach(entry -> {
                this.script.append(entry.getKey().toString());
                this.script.append(":");
                this.convertToScript(entry.getValue()).getScript();
                this.script.append(",");
            });
            this.script.setCharAtEnd('}');
            return this.script.append(")");
        }

        @Override
        protected Script produceScript(String traversalSource, Bytecode o) {
            this.script.append(traversalSource);
            for (Bytecode.Instruction instruction : o.getInstructions()) {
                String methodName = instruction.getOperator();
                if (0 == instruction.getArguments().length) {
                    this.script.append(".").append(this.resolveSymbol(methodName)).append("()");
                    continue;
                }
                this.script.append(".").append(this.resolveSymbol(methodName)).append("(");
                if (methodName.equals("withSack") && instruction.getArguments().length == 2 && instruction.getArguments()[1] instanceof Lambda) {
                    String castSecondArgTo;
                    String castFirstArgTo = instruction.getArguments()[0] instanceof Lambda ? Supplier.class.getName() : "";
                    Lambda secondArg = (Lambda)instruction.getArguments()[1];
                    String string = castSecondArgTo = secondArg.getLambdaArguments() == 1 ? UnaryOperator.class.getName() : BinaryOperator.class.getName();
                    if (!castFirstArgTo.isEmpty()) {
                        this.script.append(String.format("(%s) ", castFirstArgTo));
                    }
                    this.convertToScript(instruction.getArguments()[0]);
                    this.script.append(", (").append(castSecondArgTo).append(") ");
                    this.convertToScript(instruction.getArguments()[1]);
                    this.script.append(",");
                } else if (methodName.equals("tx")) {
                    String command = instruction.getArguments()[0].toString();
                    this.script.append(").").append(command).append("()");
                } else {
                    for (Object object : instruction.getArguments()) {
                        this.convertToScript(object);
                        this.script.append(",");
                    }
                }
                this.script.setCharAtEnd(')');
            }
            return this.script;
        }

        @Override
        protected Script produceScript(P<?> p) {
            if (p instanceof TextP) {
                this.script.append("TextP.").append(p.getPredicateName()).append("(");
                this.convertToScript(p.getValue());
            } else if (p instanceof ConnectiveP) {
                List list = ((ConnectiveP)p).getPredicates();
                String connector = p.getPredicateName();
                for (int i = 0; i < list.size(); ++i) {
                    this.produceScript(list.get(i));
                    if (i > 0 && i < list.size() - 1) {
                        this.script.append(")");
                    }
                    if (i >= list.size() - 1) continue;
                    this.script.append(".").append(connector).append("(");
                }
            } else {
                this.script.append("P.").append(p.getPredicateName()).append("(");
                this.convertToScript(p.getValue());
            }
            this.script.append(")");
            return this.script;
        }

        protected String resolveSymbol(String methodName) {
            return SymbolHelper.toJavascript(methodName);
        }
    }
}

