/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;

public class P<V>
implements Predicate<V>,
Serializable,
Cloneable {
    protected BiPredicate<V, V> biPredicate;
    protected V value;
    protected V originalValue;

    public P(BiPredicate<V, V> biPredicate, V value) {
        this.value = value;
        this.originalValue = value;
        this.biPredicate = biPredicate;
    }

    public BiPredicate<V, V> getBiPredicate() {
        return this.biPredicate;
    }

    public V getOriginalValue() {
        return this.originalValue;
    }

    public String getPredicateName() {
        return this.biPredicate.toString();
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public boolean test(V testValue) {
        return this.biPredicate.test(testValue, this.value);
    }

    public int hashCode() {
        int result = this.biPredicate.hashCode();
        if (null != this.originalValue) {
            result ^= this.originalValue.hashCode();
        }
        return result;
    }

    public boolean equals(Object other) {
        return other instanceof P && ((P)other).getClass().equals(this.getClass()) && ((P)other).getBiPredicate().equals(this.biPredicate) && (((P)other).getOriginalValue() == null && this.originalValue == null || ((P)other).getOriginalValue().equals(this.originalValue));
    }

    public String toString() {
        return null == this.originalValue ? this.biPredicate.toString() : this.biPredicate.toString() + "(" + this.originalValue + ")";
    }

    @Override
    public P<V> negate() {
        return new P<V>(this.biPredicate.negate(), this.originalValue);
    }

    @Override
    public P<V> and(Predicate<? super V> predicate) {
        if (!(predicate instanceof P)) {
            throw new IllegalArgumentException("Only P predicates can be and'd together");
        }
        return new AndP(Arrays.asList(this, (P)predicate));
    }

    @Override
    public P<V> or(Predicate<? super V> predicate) {
        if (!(predicate instanceof P)) {
            throw new IllegalArgumentException("Only P predicates can be or'd together");
        }
        return new OrP(Arrays.asList(this, (P)predicate));
    }

    public P<V> clone() {
        try {
            return (P)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <V> P<V> eq(V value) {
        return new P<Object>(Compare.eq, value);
    }

    public static <V> P<V> neq(V value) {
        return new P<Object>(Compare.neq, value);
    }

    public static <V> P<V> lt(V value) {
        return new P<Object>(Compare.lt, value);
    }

    public static <V> P<V> lte(V value) {
        return new P<Object>(Compare.lte, value);
    }

    public static <V> P<V> gt(V value) {
        return new P<Object>(Compare.gt, value);
    }

    public static <V> P<V> gte(V value) {
        return new P<Object>(Compare.gte, value);
    }

    public static <V> P<V> inside(V first, V second) {
        return new AndP(Arrays.asList(new P<Object>(Compare.gt, first), new P<Object>(Compare.lt, second)));
    }

    public static <V> P<V> outside(V first, V second) {
        return new OrP(Arrays.asList(new P<Object>(Compare.lt, first), new P<Object>(Compare.gt, second)));
    }

    public static <V> P<V> between(V first, V second) {
        return new AndP(Arrays.asList(new P<Object>(Compare.gte, first), new P<Object>(Compare.lt, second)));
    }

    public static <V> P<V> within(V ... values) {
        Object[] objectArray;
        if (null == values) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = values;
        }
        V[] v = objectArray;
        return P.within(Arrays.asList(v));
    }

    public static <V> P<V> within(Collection<V> value) {
        if (null == value) {
            return P.within(new Object[]{null});
        }
        return new P<Collection<V>>(Contains.within, value);
    }

    public static <V> P<V> without(V ... values) {
        Object[] objectArray;
        if (null == values) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = values;
        }
        V[] v = objectArray;
        return P.without(Arrays.asList(v));
    }

    public static <V> P<V> without(Collection<V> value) {
        if (null == value) {
            return P.without(new Object[]{null});
        }
        return new P<Collection<V>>(Contains.without, value);
    }

    public static P test(BiPredicate biPredicate, Object value) {
        return new P<Object>(biPredicate, value);
    }

    public static <V> P<V> not(P<V> predicate) {
        return predicate.negate();
    }
}

