/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClientImpl;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;

public class DAGClientImplLocal
extends DAGClientImpl {
    private BiFunction<Set<StatusGetOpts>, Long, DAGStatus> dagStatusFunction;
    private BiFunction<Set<StatusGetOpts>, String, VertexStatus> vertexStatusFunction;

    public DAGClientImplLocal(ApplicationId appId, String dagId, TezConfiguration conf, FrameworkClient frameworkClient, UserGroupInformation ugi, BiFunction<Set<StatusGetOpts>, Long, DAGStatus> dagStatusFunction, BiFunction<Set<StatusGetOpts>, String, VertexStatus> vertexStatusFunction) {
        super(appId, dagId, conf, frameworkClient, ugi);
        this.dagStatusFunction = dagStatusFunction;
        this.vertexStatusFunction = vertexStatusFunction;
    }

    @Override
    protected DAGStatus getDAGStatusInternal(@Nullable Set<StatusGetOpts> statusOptions, long timeout) throws TezException, IOException {
        return this.dagStatusFunction.apply(statusOptions == null ? new HashSet() : statusOptions, timeout);
    }

    @Override
    protected VertexStatus getVertexStatusInternal(@Nullable Set<StatusGetOpts> statusOptions, String vertexName) throws TezException, IOException {
        return this.vertexStatusFunction.apply(statusOptions == null ? new HashSet() : statusOptions, vertexName);
    }
}

