/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.dag.api.HistoryLogLevel;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.logging.HistoryLoggingService;
import org.apache.tez.dag.history.recovery.RecoveryService;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryEventHandler
extends CompositeService {
    private static Logger LOG = LoggerFactory.getLogger(HistoryEventHandler.class);
    private static Logger LOG_CRITICAL_EVENTS = LoggerFactory.getLogger((String)(LOG.getName() + ".criticalEvents"));
    private final AppContext context;
    private RecoveryService recoveryService;
    private boolean recoveryEnabled;
    private HistoryLoggingService historyLoggingService;
    private HistoryLogLevel amHistoryLogLevel;
    private final Map<TezDAGID, HistoryLogLevel> dagIdToLogLevel = new ConcurrentHashMap<TezDAGID, HistoryLogLevel>();
    private Set<TaskAttemptTerminationCause> amTaskAttemptFilters;
    private final Map<TezDAGID, Set<TaskAttemptTerminationCause>> dagIdToTaskAttemptFilters = new ConcurrentHashMap<TezDAGID, Set<TaskAttemptTerminationCause>>();
    private final ConcurrentHashMap<TezTaskAttemptID, DAGHistoryEvent> suppressedEvents = new ConcurrentHashMap();
    private final AtomicLong criticalEventCount = new AtomicLong();

    public HistoryEventHandler(AppContext context) {
        super(HistoryEventHandler.class.getName());
        this.context = context;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.recoveryEnabled = this.context.getAMConf().getBoolean("tez.dag.recovery.enabled", true);
        String historyServiceClassName = this.context.getAMConf().get("tez.history.logging.service.class", "org.apache.tez.dag.history.logging.impl.SimpleHistoryLoggingService");
        LOG.info("Initializing HistoryEventHandler withrecoveryEnabled=" + this.recoveryEnabled + ", historyServiceClassName=" + historyServiceClassName);
        this.historyLoggingService = (HistoryLoggingService)((Object)ReflectionUtils.createClazzInstance((String)historyServiceClassName));
        this.historyLoggingService.setAppContext(this.context);
        this.addService((Service)this.historyLoggingService);
        if (this.recoveryEnabled) {
            String recoveryServiceClass = conf.get("tez.test.recovery-service-class", "org.apache.tez.dag.history.recovery.RecoveryService");
            this.recoveryService = (RecoveryService)((Object)ReflectionUtils.createClazzInstance((String)recoveryServiceClass, (Class[])new Class[]{AppContext.class}, (Object[])new Object[]{this.context}));
            this.addService((Service)this.recoveryService);
        }
        this.amHistoryLogLevel = HistoryLogLevel.getLogLevel((Configuration)this.context.getAMConf(), (HistoryLogLevel)HistoryLogLevel.DEFAULT);
        this.amTaskAttemptFilters = TezUtilsInternal.getEnums((Configuration)this.context.getAMConf(), (String)"tez.history.logging.taskattempt-filters", TaskAttemptTerminationCause.class, null);
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        LOG.info("Stopping HistoryEventHandler");
        super.serviceStop();
    }

    public void handleCriticalEvent(DAGHistoryEvent event) throws IOException {
        TezDAGID dagId = event.getDagID();
        String dagIdStr = "N/A";
        if (dagId != null) {
            dagIdStr = dagId.toString();
        }
        HistoryEvent historyEvent = event.getHistoryEvent();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling history event, eventType=" + (Object)((Object)historyEvent.getEventType()));
        }
        if (this.recoveryEnabled && historyEvent.isRecoveryEvent()) {
            this.recoveryService.handle(event);
        }
        if (historyEvent.isHistoryEvent() && this.shouldLogEvent(event)) {
            DAGHistoryEvent suppressedEvent = this.getSupressedEvent(historyEvent);
            if (suppressedEvent != null) {
                this.historyLoggingService.handle(suppressedEvent);
            }
            this.historyLoggingService.handle(event);
        }
        if (LOG_CRITICAL_EVENTS.isInfoEnabled()) {
            LOG_CRITICAL_EVENTS.info("[HISTORY][DAG:" + dagIdStr + "][Event:" + event.getHistoryEvent().getEventType().name() + "]: " + event.getHistoryEvent().toString());
        } else if (this.criticalEventCount.incrementAndGet() % 1000L == 0L) {
            LOG.info("Got {} critical events", (Object)this.criticalEventCount);
        }
    }

    private boolean shouldLogEvent(DAGHistoryEvent event) {
        HistoryEvent historyEvent;
        HistoryEventType eventType;
        TezDAGID dagId = event.getDagID();
        HistoryLogLevel dagLogLevel = null;
        if (dagId != null) {
            dagLogLevel = this.dagIdToLogLevel.get(dagId);
        }
        if (dagLogLevel == null) {
            dagLogLevel = this.amHistoryLogLevel;
        }
        if ((eventType = (historyEvent = event.getHistoryEvent()).getEventType()) == HistoryEventType.DAG_SUBMITTED) {
            Configuration dagConf = ((DAGSubmittedEvent)historyEvent).getConf();
            dagLogLevel = HistoryLogLevel.getLogLevel((Configuration)dagConf, (HistoryLogLevel)this.amHistoryLogLevel);
            this.dagIdToLogLevel.put(dagId, dagLogLevel);
            this.maybeUpdateDagTaskAttemptFilters(dagId, dagLogLevel, dagConf);
        } else if (eventType == HistoryEventType.DAG_RECOVERED) {
            if (this.context.getCurrentDAG() != null) {
                Configuration dagConf = this.context.getCurrentDAG().getConf();
                dagLogLevel = HistoryLogLevel.getLogLevel((Configuration)dagConf, (HistoryLogLevel)this.amHistoryLogLevel);
                this.dagIdToLogLevel.put(dagId, dagLogLevel);
                this.maybeUpdateDagTaskAttemptFilters(dagId, dagLogLevel, dagConf);
            }
        } else if (eventType == HistoryEventType.DAG_FINISHED) {
            this.dagIdToLogLevel.remove(dagId);
            this.dagIdToTaskAttemptFilters.remove(dagId);
            this.suppressedEvents.clear();
        }
        if (dagLogLevel.shouldLog(historyEvent.getEventType().getHistoryLogLevel())) {
            return this.shouldLogTaskAttemptEvents(event, dagLogLevel);
        }
        return false;
    }

    private boolean shouldLogTaskAttemptEvents(DAGHistoryEvent event, HistoryLogLevel dagLogLevel) {
        HistoryEvent historyEvent = event.getHistoryEvent();
        HistoryEventType eventType = historyEvent.getEventType();
        if (dagLogLevel == HistoryLogLevel.TASK_ATTEMPT && (eventType == HistoryEventType.TASK_ATTEMPT_STARTED || eventType == HistoryEventType.TASK_ATTEMPT_FINISHED)) {
            TezDAGID dagId = event.getDagID();
            Set<TaskAttemptTerminationCause> filters = null;
            if (dagId != null) {
                filters = this.dagIdToTaskAttemptFilters.get(dagId);
            }
            if (filters == null) {
                filters = this.amTaskAttemptFilters;
            }
            if (filters == null) {
                return true;
            }
            if (eventType == HistoryEventType.TASK_ATTEMPT_STARTED) {
                this.suppressedEvents.put(((TaskAttemptStartedEvent)historyEvent).getTaskAttemptID(), event);
                return false;
            }
            TaskAttemptFinishedEvent finishedEvent = (TaskAttemptFinishedEvent)historyEvent;
            if (filters.contains(finishedEvent.getTaskAttemptError())) {
                this.suppressedEvents.remove(finishedEvent.getTaskAttemptID());
                return false;
            }
        }
        return true;
    }

    private void maybeUpdateDagTaskAttemptFilters(TezDAGID dagId, HistoryLogLevel dagLogLevel, Configuration dagConf) {
        Set filters;
        if (dagLogLevel == HistoryLogLevel.TASK_ATTEMPT && (filters = TezUtilsInternal.getEnums((Configuration)dagConf, (String)"tez.history.logging.taskattempt-filters", TaskAttemptTerminationCause.class, null)) != null) {
            this.dagIdToTaskAttemptFilters.put(dagId, filters);
        }
    }

    private DAGHistoryEvent getSupressedEvent(HistoryEvent historyEvent) {
        if (historyEvent.getEventType() == HistoryEventType.TASK_ATTEMPT_FINISHED) {
            TaskAttemptFinishedEvent finishedEvent = (TaskAttemptFinishedEvent)historyEvent;
            return this.suppressedEvents.remove(finishedEvent.getTaskAttemptID());
        }
        return null;
    }

    public void handle(DAGHistoryEvent event) {
        try {
            this.handleCriticalEvent(event);
        }
        catch (IOException e) {
            LOG.warn("Failed to handle recovery event, eventType=" + (Object)((Object)event.getHistoryEvent().getEventType()), (Throwable)e);
        }
    }

    public boolean hasRecoveryFailed() {
        if (this.recoveryEnabled) {
            return this.recoveryService.hasRecoveryFailed();
        }
        return false;
    }
}

