/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezClassLoader
extends URLClassLoader {
    private static final TezClassLoader INSTANCE;
    private static final Logger LOG;

    private TezClassLoader() {
        super(new URL[0], TezClassLoader.class.getClassLoader());
        LOG.info("Created TezClassLoader with parent classloader: {}, thread: {}, system classloader: {}", new Object[]{TezClassLoader.class.getClassLoader(), Thread.currentThread().getId(), ClassLoader.getSystemClassLoader()});
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public static TezClassLoader getInstance() {
        return INSTANCE;
    }

    public static void setupTezClassLoader() {
        LOG.debug("Setting up TezClassLoader: thread: {}, current thread classloader: {} system classloader: {}", new Object[]{Thread.currentThread().getId(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()});
        Thread.currentThread().setContextClassLoader(INSTANCE);
    }

    public static void setupForConfiguration(Configuration configuration) {
        configuration.setClassLoader((ClassLoader)INSTANCE);
    }

    static {
        LOG = LoggerFactory.getLogger(TezClassLoader.class);
        INSTANCE = AccessController.doPrivileged(new PrivilegedAction<TezClassLoader>(){

            @Override
            public TezClassLoader run() {
                return new TezClassLoader();
            }
        });
    }
}

